/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.impl;

import java.util.ArrayList;
import java.util.List;
import org.ergoplatform.ErgoAddress;
import org.ergoplatform.ErgoBox;
import org.ergoplatform.ErgoBoxCandidate;
import org.ergoplatform.UnsignedErgoLikeTransaction;
import org.ergoplatform.appkit.ErgoId;
import org.ergoplatform.appkit.ExtendedInputBox;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.impl.BlockchainContextBase;
import org.ergoplatform.appkit.impl.BlockchainContextImpl;
import org.ergoplatform.appkit.impl.InputBoxImpl;
import org.ergoplatform.appkit.impl.OutBoxImpl;
import org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext;
import scala.collection.JavaConversions;

public class UnsignedTransactionImpl
implements UnsignedTransaction {
    private final UnsignedErgoLikeTransaction _tx;
    private List<ExtendedInputBox> _boxesToSpend;
    private List<ErgoBox> _dataBoxes;
    private List<ErgoBox> _outputs;
    private ErgoAddress _changeAddress;
    private ErgoLikeStateContext _stateContext;
    private BlockchainContextImpl _ctx;

    public UnsignedTransactionImpl(UnsignedErgoLikeTransaction unsignedErgoLikeTransaction, List<ExtendedInputBox> list, List<ErgoBox> list2, ErgoAddress ergoAddress, ErgoLikeStateContext ergoLikeStateContext, BlockchainContextImpl blockchainContextImpl) {
        this._tx = unsignedErgoLikeTransaction;
        this._boxesToSpend = list;
        this._dataBoxes = list2;
        this._outputs = JavaConversions.seqAsJavaList(this._tx.outputs());
        this._changeAddress = ergoAddress;
        this._stateContext = ergoLikeStateContext;
        this._ctx = blockchainContextImpl;
    }

    @Override
    public String getId() {
        return this.getTx().id();
    }

    public UnsignedErgoLikeTransaction getTx() {
        return this._tx;
    }

    public List<ExtendedInputBox> getBoxesToSpend() {
        return this._boxesToSpend;
    }

    public List<ErgoBox> getDataBoxes() {
        return this._dataBoxes;
    }

    public ErgoLikeStateContext getStateContext() {
        return this._stateContext;
    }

    @Override
    public List<InputBox> getInputs() {
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>(this._boxesToSpend.size());
        for (ExtendedInputBox extendedInputBox : this._boxesToSpend) {
            arrayList.add(new InputBoxImpl((BlockchainContextBase)this._ctx, extendedInputBox.box()));
        }
        return arrayList;
    }

    @Override
    public List<String> getInputBoxesIds() {
        ArrayList<String> arrayList = new ArrayList<String>(this._boxesToSpend.size());
        for (ExtendedInputBox extendedInputBox : this._boxesToSpend) {
            arrayList.add(new ErgoId(extendedInputBox.box().id()).toString());
        }
        return arrayList;
    }

    @Override
    public List<OutBox> getOutputs() {
        ArrayList<OutBox> arrayList = new ArrayList<OutBox>(this._outputs.size());
        for (ErgoBoxCandidate ergoBoxCandidate : this._outputs) {
            arrayList.add(new OutBoxImpl(this._ctx, ergoBoxCandidate));
        }
        return arrayList;
    }

    @Override
    public List<InputBox> getDataInputs() {
        ArrayList<InputBox> arrayList = new ArrayList<InputBox>(this._dataBoxes.size());
        for (ErgoBox ergoBox : this._dataBoxes) {
            arrayList.add(new InputBoxImpl((BlockchainContextBase)this._ctx, ergoBox));
        }
        return arrayList;
    }

    @Override
    public ErgoAddress getChangeAddress() {
        return this._changeAddress;
    }
}

