/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.restapi.client;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Merkle proof for a leaf, which is an array of bytes (e.g. a transaction identifier)")
public class MerkleProof {
    @SerializedName(value="leaf")
    private String leaf = null;
    @SerializedName(value="levels")
    private List<List> levels = new ArrayList<List>();

    public MerkleProof leaf(String string) {
        this.leaf = string;
        return this;
    }

    @Schema(example="cd665e49c834b0c25574fcb19a158d836f3f2aad8e91ac195f972534c25449b3", required=true, description="Base16-encoded Merkle tree leaf bytes")
    public String getLeaf() {
        return this.leaf;
    }

    public void setLeaf(String string) {
        this.leaf = string;
    }

    public MerkleProof levels(List<List> list) {
        this.levels = list;
        return this;
    }

    public MerkleProof addLevelsItem(List list) {
        this.levels.add(list);
        return this;
    }

    @Schema(example="[[\"018b7ae20a4acd23e3f1bf38671ce97103ad96d8f1c780b5e5e865e4873ae16337\",0]]", required=true, description="")
    public List<List> getLevels() {
        return this.levels;
    }

    public void setLevels(List<List> list) {
        this.levels = list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MerkleProof merkleProof = (MerkleProof)object;
        return Objects.equals(this.leaf, merkleProof.leaf) && Objects.equals(this.levels, merkleProof.levels);
    }

    public int hashCode() {
        return Objects.hash(this.leaf, this.levels);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class MerkleProof {\n");
        stringBuilder.append("    leaf: ").append(this.toIndentedString(this.leaf)).append("\n");
        stringBuilder.append("    levels: ").append(this.toIndentedString(this.levels)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

