/*
 * Decompiled with CFR 0.152.
 */
package scorex.crypto.authds.merkle;

import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.WrappedArray;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scorex.crypto.authds.merkle.InternalNode;
import scorex.crypto.authds.merkle.Leaf;
import scorex.crypto.authds.merkle.MerkleProof;
import scorex.crypto.authds.merkle.MerkleProof$;
import scorex.crypto.authds.merkle.MerkleTree$;
import scorex.crypto.authds.merkle.Node;
import scorex.crypto.hash.CryptographicHash;

@ScalaSignature(bytes="\u0006\u0001\tuc\u0001B\u0012%\u00016B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t7\u0002\u0011\t\u0012)A\u0005{!AA\f\u0001BK\u0002\u0013\u0005Q\f\u0003\u0005x\u0001\tE\t\u0015!\u0003_\u0011\u0015A\b\u0001\"\u0001z\u0011!i\b\u0001#b\u0001\n\u0003q\b\"C@\u0001\u0011\u000b\u0007I\u0011AA\u0001\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000bAq!!\b\u0001\t\u0003\ty\u0002C\u0004\u0002$\u0001!\t!!\n\t\u0015\u0005-\u0002\u0001#b\u0001\n\u0003\t\t\u0001\u0003\u0006\u0002.\u0001A)\u0019!C!\u0003_A\u0011\"a\u000e\u0001\u0003\u0003%\t!!\u000f\t\u0013\u0005%\u0003!%A\u0005\u0002\u0005-\u0003\"CA3\u0001E\u0005I\u0011AA4\u0011%\ty\u0007AA\u0001\n\u0003\n\t\bC\u0005\u0002\u0002\u0002\t\t\u0011\"\u0001\u0002\u0002!I\u00111\u0011\u0001\u0002\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003#\u0003\u0011\u0011!C!\u0003'C\u0011\"a'\u0001\u0003\u0003%\t!!(\t\u0013\u0005\u001d\u0006!!A\u0005B\u0005%\u0006\"CAV\u0001\u0005\u0005I\u0011IAW\u000f\u001d\t\t\f\nE\u0001\u0003g3aa\t\u0013\t\u0002\u0005U\u0006B\u0002=\u0019\t\u0003\t9\fC\u0005\u0002:b\u0011\r\u0011\"\u0001\u0002<\"A\u00111\u0019\r!\u0002\u0013\ti\fC\u0005\u0002Fb\u0011\r\u0011\"\u0001\u0002<\"A\u0011q\u0019\r!\u0002\u0013\ti\fC\u0004\u0002Jb!\t!a3\t\u000f\t\u001d\u0001\u0004\"\u0001\u0003\n!I\u0011\u0011\u001a\r\u0002\u0002\u0013\u0005%\u0011\u0006\u0005\n\u0005sA\u0012\u0011!CA\u0005wA\u0011Ba\u0015\u0019\u0003\u0003%IA!\u0016\u0003\u00155+'o\u001b7f)J,WM\u0003\u0002&M\u00051Q.\u001a:lY\u0016T!a\n\u0015\u0002\r\u0005,H\u000f\u001b3t\u0015\tI#&\u0001\u0004def\u0004Ho\u001c\u0006\u0002W\u000511oY8sKb\u001c\u0001!\u0006\u0002/\u0007N!\u0001aL\u001b9!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fMB\u0011\u0001GN\u0005\u0003oE\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00021s%\u0011!(\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\bi>\u0004hj\u001c3f+\u0005i\u0004c\u0001 @\u00036\tA%\u0003\u0002AI\t!aj\u001c3f!\t\u00115\t\u0004\u0001\u0005\u000b\u0011\u0003!\u0019A#\u0003\u0003\u0011\u000b\"AR%\u0011\u0005A:\u0015B\u0001%2\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0013-\u000f\u0005-+fB\u0001'T\u001d\ti%K\u0004\u0002O#6\tqJ\u0003\u0002QY\u00051AH]8pizJ\u0011aK\u0005\u0003S)J!\u0001\u0016\u0015\u0002\t!\f7\u000f[\u0005\u0003-^\u000bq\u0001]1dW\u0006<WM\u0003\u0002UQ%\u0011\u0011L\u0017\u0002\u0007\t&<Wm\u001d;\u000b\u0005Y;\u0016\u0001\u0003;pa:{G-\u001a\u0011\u0002#\u0015dW-\\3oiND\u0015m\u001d5J]\u0012,\u00070F\u0001_!\u0011y6M\u001a;\u000f\u0005\u0001\f\u0007C\u0001(2\u0013\t\u0011\u0017'\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0016\u00141!T1q\u0015\t\u0011\u0017\u0007\u0005\u0002hc:\u0011\u0001N\u001c\b\u0003S2l\u0011A\u001b\u0006\u0003WF\n!bY8mY\u0016\u001cG/[8o\u0013\ti'.A\u0004nkR\f'\r\\3\n\u0005=\u0004\u0018\u0001D,sCB\u0004X\rZ!se\u0006L(BA7k\u0013\t\u00118O\u0001\u0004pM\nKH/\u001a\u0006\u0003_B\u0004\"\u0001M;\n\u0005Y\f$aA%oi\u0006\u0011R\r\\3nK:$8\u000fS1tQ&sG-\u001a=!\u0003\u0019a\u0014N\\5u}Q\u0019!p\u001f?\u0011\u0007y\u0002\u0011\tC\u0003<\u000b\u0001\u0007Q\bC\u0003]\u000b\u0001\u0007a,\u0001\u0005s_>$\b*Y:i+\u0005\t\u0015A\u00027f]\u001e$\b.F\u0001u\u00039\u0001(o\\8g\u0005f,E.Z7f]R$B!a\u0002\u0002\u0014A)\u0001'!\u0003\u0002\u000e%\u0019\u00111B\u0019\u0003\r=\u0003H/[8o!\u0011q\u0014qB!\n\u0007\u0005EAEA\u0006NKJ\\G.\u001a)s_>4\u0007bBA\u000b\u0011\u0001\u0007\u0011qC\u0001\bK2,W.\u001a8u!\u0011q\u0014\u0011D!\n\u0007\u0005mAE\u0001\u0003MK\u00064\u0017A\u00059s_>4')_#mK6,g\u000e\u001e%bg\"$B!a\u0002\u0002\"!)A+\u0003a\u0001\u0003\u0006a\u0001O]8pM\nK\u0018J\u001c3fqR!\u0011qAA\u0014\u0011\u0019\tIC\u0003a\u0001i\u0006)\u0011N\u001c3fq\u0006!B.\u001a8hi\"<\u0016\u000e\u001e5F[B$\u0018\u0010T3bMN\f\u0001\u0002^8TiJLgnZ\u000b\u0003\u0003c\u00012aXA\u001a\u0013\r\t)$\u001a\u0002\u0007'R\u0014\u0018N\\4\u0002\t\r|\u0007/_\u000b\u0005\u0003w\t\t\u0005\u0006\u0004\u0002>\u0005\r\u0013q\t\t\u0005}\u0001\ty\u0004E\u0002C\u0003\u0003\"Q\u0001R\u0007C\u0002\u0015C\u0001bO\u0007\u0011\u0002\u0003\u0007\u0011Q\t\t\u0005}}\ny\u0004C\u0004]\u001bA\u0005\t\u0019\u00010\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU!\u0011QJA2+\t\tyEK\u0002>\u0003#Z#!a\u0015\u0011\t\u0005U\u0013qL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;\n\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011MA,\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006\t:\u0011\r!R\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0011\tI'!\u001c\u0016\u0005\u0005-$f\u00010\u0002R\u0011)Ai\u0004b\u0001\u000b\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001d\u0011\t\u0005U\u0014qP\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005!A.\u00198h\u0015\t\ti(\u0001\u0003kCZ\f\u0017\u0002BA\u001b\u0003o\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\b\u00065\u0005c\u0001\u0019\u0002\n&\u0019\u00111R\u0019\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002\u0010J\t\t\u00111\u0001u\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0013\t\u0006S\u0006]\u0015qQ\u0005\u0004\u00033S'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a(\u0002&B\u0019\u0001'!)\n\u0007\u0005\r\u0016GA\u0004C_>dW-\u00198\t\u0013\u0005=E#!AA\u0002\u0005\u001d\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003Q\fa!Z9vC2\u001cH\u0003BAP\u0003_C\u0011\"a$\u0017\u0003\u0003\u0005\r!a\"\u0002\u00155+'o\u001b7f)J,W\r\u0005\u0002?1M\u0019\u0001d\f\u001d\u0015\u0005\u0005M\u0016A\u0003'fC\u001a\u0004&/\u001a4jqV\u0011\u0011Q\u0018\t\u0004a\u0005}\u0016bAAac\t!!)\u001f;f\u0003-aU-\u00194Qe\u00164\u0017\u000e\u001f\u0011\u0002%%sG/\u001a:oC2tu\u000eZ3Qe\u00164\u0017\u000e_\u0001\u0014\u0013:$XM\u001d8bY:{G-\u001a)sK\u001aL\u0007\u0010I\u0001\u0006CB\u0004H._\u000b\u0005\u0003\u001b\f)\u000e\u0006\u0003\u0002P\u0006\rH\u0003BAi\u0003/\u0004BA\u0010\u0001\u0002TB\u0019!)!6\u0005\u000b\u0011s\"\u0019A#\t\u000f\u0005eg\u0004q\u0001\u0002\\\u0006\u0011\u0001N\u001a\t\u0007\u0003;\fy.a5\u000e\u0003]K1!!9X\u0005E\u0019%/\u001f9u_\u001e\u0014\u0018\r\u001d5jG\"\u000b7\u000f\u001b\u0005\b\u0003Kt\u0002\u0019AAt\u0003\u001d\u0001\u0018-\u001f7pC\u0012\u0004b!!;\u0002r\u0006]h\u0002BAv\u0003_t1ATAw\u0013\u0005\u0011\u0014B\u0001,2\u0013\u0011\t\u00190!>\u0003\u0007M+\u0017O\u0003\u0002WcA!\u0011\u0011 B\u0001\u001d\u0011\tY0a@\u000f\u00071\u000bi0\u0003\u0002(Q%\u0011aKJ\u0005\u0005\u0005\u0007\u0011)A\u0001\u0005MK\u00064G)\u0019;b\u0015\t1f%A\u0006dC2\u001cGk\u001c9O_\u0012,W\u0003\u0002B\u0006\u0005'!BA!\u0004\u0003\u001aQ!!q\u0002B\u000b!\u0011qtH!\u0005\u0011\u0007\t\u0013\u0019\u0002B\u0003E?\t\u0007Q\tC\u0004\u0002Z~\u0001\u001dAa\u0006\u0011\r\u0005u\u0017q\u001cB\t\u0011\u001d\u0011Yb\ba\u0001\u0005;\tQA\\8eKN\u0004b!!;\u0002r\n=\u0001fA\u0010\u0003\"A!!1\u0005B\u0013\u001b\t\tY&\u0003\u0003\u0003(\u0005m#a\u0002;bS2\u0014XmY\u000b\u0005\u0005W\u0011\t\u0004\u0006\u0004\u0003.\tM\"q\u0007\t\u0005}\u0001\u0011y\u0003E\u0002C\u0005c!Q\u0001\u0012\u0011C\u0002\u0015Caa\u000f\u0011A\u0002\tU\u0002\u0003\u0002 @\u0005_AQ\u0001\u0018\u0011A\u0002y\u000bq!\u001e8baBd\u00170\u0006\u0003\u0003>\t-C\u0003\u0002B \u0005\u001b\u0002R\u0001MA\u0005\u0005\u0003\u0002b\u0001\rB\"\u0005\u000fr\u0016b\u0001B#c\t1A+\u001e9mKJ\u0002BAP \u0003JA\u0019!Ia\u0013\u0005\u000b\u0011\u000b#\u0019A#\t\u0013\t=\u0013%!AA\u0002\tE\u0013a\u0001=%aA!a\b\u0001B%\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t]\u0003\u0003BA;\u00053JAAa\u0017\u0002x\t1qJ\u00196fGR\u0004")
public class MerkleTree<D extends byte[]>
implements Product,
scala.Serializable {
    private D rootHash;
    private int length;
    private int lengthWithEmptyLeafs;
    private String toString;
    private final Node<D> topNode;
    private final Map<WrappedArray.ofByte, Object> elementsHashIndex;
    private volatile byte bitmap$0;

    public static <D extends byte[]> Option<Tuple2<Node<D>, Map<WrappedArray.ofByte, Object>>> unapply(MerkleTree<D> merkleTree) {
        return MerkleTree$.MODULE$.unapply(merkleTree);
    }

    public static <D extends byte[]> MerkleTree<D> apply(Node<D> node, Map<WrappedArray.ofByte, Object> map2) {
        return MerkleTree$.MODULE$.apply(node, map2);
    }

    public static <D extends byte[]> Node<D> calcTopNode(Seq<Node<D>> seq, CryptographicHash<D> cryptographicHash) {
        return MerkleTree$.MODULE$.calcTopNode(seq, cryptographicHash);
    }

    public static <D extends byte[]> MerkleTree<D> apply(Seq<byte[]> seq, CryptographicHash<D> cryptographicHash) {
        return MerkleTree$.MODULE$.apply(seq, cryptographicHash);
    }

    public static byte InternalNodePrefix() {
        return MerkleTree$.MODULE$.InternalNodePrefix();
    }

    public static byte LeafPrefix() {
        return MerkleTree$.MODULE$.LeafPrefix();
    }

    public Node<D> topNode() {
        return this.topNode;
    }

    public Map<WrappedArray.ofByte, Object> elementsHashIndex() {
        return this.elementsHashIndex;
    }

    private D rootHash$lzycompute() {
        MerkleTree merkleTree = this;
        synchronized (merkleTree) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.rootHash = this.topNode().hash();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.rootHash;
    }

    public D rootHash() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.rootHash$lzycompute() : this.rootHash;
    }

    private int length$lzycompute() {
        MerkleTree merkleTree = this;
        synchronized (merkleTree) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.length = this.elementsHashIndex().size();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.length;
    }

    public int length() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.length$lzycompute() : this.length;
    }

    public Option<MerkleProof<D>> proofByElement(Leaf<D> element) {
        return this.proofByElementHash(element.hash());
    }

    public Option<MerkleProof<D>> proofByElementHash(D hash2) {
        return this.elementsHashIndex().get(new WrappedArray.ofByte((byte[])hash2)).flatMap((Function1<Object, Option> & Serializable & scala.Serializable)i -> this.proofByIndex(BoxesRunTime.unboxToInt(i)));
    }

    public Option<MerkleProof<D>> proofByIndex(int index) {
        Option option;
        if (index >= 0 && index < this.length()) {
            Option leafWithProofs = this.loop$1(this.topNode(), index, this.lengthWithEmptyLeafs(), Nil$.MODULE$);
            option = leafWithProofs.map((Function1<Tuple2, MerkleProof> & Serializable & scala.Serializable)lp -> new MerkleProof(((Leaf)lp._1()).data(), (Seq)lp._2(), ((Leaf)lp._1()).hf()));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private int lengthWithEmptyLeafs$lzycompute() {
        MerkleTree merkleTree = this;
        synchronized (merkleTree) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.lengthWithEmptyLeafs = Math.max((int)package$.MODULE$.pow(2.0, package$.MODULE$.ceil(MerkleTree.log2$1(this.length()))), 2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.lengthWithEmptyLeafs;
    }

    public int lengthWithEmptyLeafs() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.lengthWithEmptyLeafs$lzycompute() : this.lengthWithEmptyLeafs;
    }

    private String toString$lzycompute() {
        MerkleTree merkleTree = this;
        synchronized (merkleTree) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.toString = this.loop$2(new $colon$colon<Nothing$>((Nothing$)((Object)this.topNode()), Nil$.MODULE$), 0, "");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.toString;
    }

    public String toString() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.toString$lzycompute() : this.toString;
    }

    public <D extends byte[]> MerkleTree<D> copy(Node<D> topNode, Map<WrappedArray.ofByte, Object> elementsHashIndex) {
        return new MerkleTree<D>(topNode, elementsHashIndex);
    }

    public <D extends byte[]> Node<D> copy$default$1() {
        return this.topNode();
    }

    public <D extends byte[]> Map<WrappedArray.ofByte, Object> copy$default$2() {
        return this.elementsHashIndex();
    }

    @Override
    public String productPrefix() {
        return "MerkleTree";
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.topNode();
                break;
            }
            case 1: {
                object = this.elementsHashIndex();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof MerkleTree;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MerkleTree)) return false;
        boolean bl = true;
        if (!bl) return false;
        MerkleTree merkleTree = (MerkleTree)x$1;
        Node<D> node = this.topNode();
        Node<D> node2 = merkleTree.topNode();
        if (node == null) {
            if (node2 != null) {
                return false;
            }
        } else if (!node.equals(node2)) return false;
        Map<WrappedArray.ofByte, Object> map2 = this.elementsHashIndex();
        Map<WrappedArray.ofByte, Object> map3 = merkleTree.elementsHashIndex();
        if (map2 == null) {
            if (map3 != null) {
                return false;
            }
        } else if (!map2.equals(map3)) return false;
        if (!merkleTree.canEqual(this)) return false;
        return true;
    }

    private final Option loop$1(Node node, int i, int curLength, Seq acc) {
        Option option;
        Node node2;
        while (true) {
            boolean bl = false;
            InternalNode internalNode = null;
            node2 = node;
            if (node2 instanceof InternalNode) {
                bl = true;
                internalNode = (InternalNode)node2;
                if (i < curLength / 2) {
                    acc = acc.$colon$plus(new Tuple2(internalNode.right().hash(), BoxesRunTime.boxToByte(MerkleProof$.MODULE$.LeftSide())), Seq$.MODULE$.canBuildFrom());
                    curLength /= 2;
                    node = internalNode.left();
                    continue;
                }
            }
            if (!bl || i >= curLength) break;
            int n = i - curLength / 2;
            acc = acc.$colon$plus(new Tuple2(internalNode.left().hash(), BoxesRunTime.boxToByte(MerkleProof$.MODULE$.RightSide())), Seq$.MODULE$.canBuildFrom());
            curLength /= 2;
            i = n;
            node = internalNode.right();
        }
        if (node2 instanceof Leaf) {
            Leaf leaf = (Leaf)node2;
            option = new Some(new Tuple2(leaf, acc.reverse()));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private static final double log2$1(double x) {
        return package$.MODULE$.log(x) / package$.MODULE$.log(2.0);
    }

    private final String loop$2(Seq nodes, int level, String acc) {
        while (nodes.nonEmpty()) {
            String thisLevStr = new StringBuilder(9).append("Level ").append(level).append(": ").append(((TraversableOnce)nodes.map((Function1<Node, String> & Serializable & scala.Serializable)x$1 -> x$1.toString(), Seq$.MODULE$.canBuildFrom())).mkString(",")).append("\n").toString();
            Seq nextLevNodes = nodes.flatMap((Function1<Node, Seq> & Serializable & scala.Serializable)x0$1 -> {
                Seq seq;
                Node node = x0$1;
                if (node instanceof InternalNode) {
                    InternalNode internalNode = (InternalNode)node;
                    seq = new $colon$colon<Nothing$>((Nothing$)((Object)internalNode.left()), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)internalNode.right()), Nil$.MODULE$));
                } else {
                    seq = Nil$.MODULE$;
                }
                return seq;
            }, Seq$.MODULE$.canBuildFrom());
            acc = new StringBuilder(0).append(acc).append(thisLevStr).toString();
            ++level;
            nodes = nextLevNodes;
        }
        return acc;
    }

    public MerkleTree(Node<D> topNode, Map<WrappedArray.ofByte, Object> elementsHashIndex) {
        this.topNode = topNode;
        this.elementsHashIndex = elementsHashIndex;
        Product.$init$(this);
    }
}

