/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.basics;

import java.math.BigInteger;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Point;
import org.bouncycastle.util.BigIntegers;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import sigmastate.basics.DiffieHellmanTupleProverInput;
import sigmastate.basics.ProveDHTuple;
import sigmastate.interpreter.CryptoConstants$;

public final class DiffieHellmanTupleProverInput$
implements Serializable {
    public static DiffieHellmanTupleProverInput$ MODULE$;

    static {
        new DiffieHellmanTupleProverInput$();
    }

    public DiffieHellmanTupleProverInput random() {
        SecP256K1Point g = CryptoConstants$.MODULE$.dlogGroup().generator();
        SecP256K1Point h = CryptoConstants$.MODULE$.dlogGroup().createRandomGenerator();
        BigInteger qMinusOne = CryptoConstants$.MODULE$.dlogGroup().order().subtract(BigInteger.ONE);
        BigInteger w = BigIntegers.createRandomInRange(BigInteger.ZERO, qMinusOne, CryptoConstants$.MODULE$.dlogGroup().secureRandom());
        SecP256K1Point u = CryptoConstants$.MODULE$.dlogGroup().exponentiate(g, w);
        SecP256K1Point v = CryptoConstants$.MODULE$.dlogGroup().exponentiate(h, w);
        ProveDHTuple ci = new ProveDHTuple(g, h, u, v);
        return new DiffieHellmanTupleProverInput(w, ci);
    }

    public DiffieHellmanTupleProverInput apply(BigInteger w, ProveDHTuple commonInput) {
        return new DiffieHellmanTupleProverInput(w, commonInput);
    }

    public Option<Tuple2<BigInteger, ProveDHTuple>> unapply(DiffieHellmanTupleProverInput x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<BigInteger, ProveDHTuple>>(new Tuple2<BigInteger, ProveDHTuple>(x$0.w(), x$0.commonInput()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DiffieHellmanTupleProverInput$() {
        MODULE$ = this;
    }
}

