/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.AdditiveCommutativeMonoid;
import algebra.ring.AdditiveCommutativeSemigroup;
import algebra.ring.AdditiveMonoid;
import algebra.ring.AdditiveSemigroup;
import algebra.ring.MultiplicativeSemigroup;
import algebra.ring.Ring;
import algebra.ring.Semiring;
import cats.kernel.CommutativeMonoid;
import cats.kernel.Eq;
import cats.kernel.Order;
import cats.kernel.Semigroup;
import scala.Double$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;
import spire.math.Above$;
import spire.math.All$;
import spire.math.Below$;
import spire.math.Bounded$;
import spire.math.Empty$;
import spire.math.Interval;
import spire.math.Point$;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.interval.Bound;
import spire.math.interval.Closed;
import spire.math.interval.EmptyBound;
import spire.math.interval.Open;
import spire.math.interval.Unbound;

public final class Interval$
implements Serializable {
    public static Interval$ MODULE$;
    private final Regex NullRe;
    private final Regex SingleRe;
    private final Regex PairRe;

    static {
        new Interval$();
    }

    public <A> Interval<A> withFlags(A lower, A upper, int flags, Order<A> evidence$8) {
        return evidence$8.lt(lower, upper) ? Bounded$.MODULE$.apply(lower, upper, flags, evidence$8) : (evidence$8.eqv(lower, upper) && flags == 0 ? Point$.MODULE$.apply(lower, evidence$8) : this.empty(evidence$8));
    }

    public <A> Interval<A> empty(Order<A> o) {
        return Empty$.MODULE$.apply(o);
    }

    public <A> Interval<A> point(A a, Order<A> evidence$9) {
        return Point$.MODULE$.apply(a, evidence$9);
    }

    public <A> Interval<A> zero(Order<A> o, Semiring<A> r) {
        return Point$.MODULE$.apply(r.zero(), o);
    }

    public <A> Interval<A> all(Order<A> evidence$10) {
        return All$.MODULE$.apply(evidence$10);
    }

    public <A> Interval<A> apply(A lower, A upper, Order<A> evidence$11) {
        return this.closed(lower, upper, evidence$11);
    }

    public Interval<Rational> errorBounds(double d) {
        Interval<Rational> interval;
        if (d == Double.POSITIVE_INFINITY) {
            interval = this.above(Rational$.MODULE$.apply((double)Double.MAX_VALUE), Rational$.MODULE$.RationalAlgebra());
        } else if (d == Double.NEGATIVE_INFINITY) {
            interval = this.below(Rational$.MODULE$.apply(Double$.MODULE$.MinValue()), Rational$.MODULE$.RationalAlgebra());
        } else if (Double.isNaN(d)) {
            interval = this.empty(Rational$.MODULE$.RationalAlgebra());
        } else {
            Rational n0 = Rational$.MODULE$.apply(Math.nextAfter(d, -1.0));
            Rational n1 = Rational$.MODULE$.apply(d);
            Rational n2 = Rational$.MODULE$.apply(Math.nextUp(d));
            interval = this.apply(n1.$minus(n0).$div(Rational$.MODULE$.apply(2)).$plus(n0), n2.$minus(n1).$div(Rational$.MODULE$.apply(2)).$plus(n1), Rational$.MODULE$.RationalAlgebra());
        }
        return interval;
    }

    public final int closedLowerFlags() {
        return 0;
    }

    public final int openLowerFlags() {
        return 1;
    }

    public final int closedUpperFlags() {
        return 0;
    }

    public final int openUpperFlags() {
        return 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A> Interval<A> fromOrderedBounds(Bound<A> lower, Bound<A> upper, Order<A> evidence$12) {
        Bound<A> bound;
        Bound<A> bound2;
        Tuple2<Bound<A>, Bound<A>> tuple2 = new Tuple2<Bound<A>, Bound<A>>(lower, upper);
        if (tuple2 != null) {
            Bound<A> bound3 = tuple2._1();
            Bound<A> bound4 = tuple2._2();
            if (bound3 instanceof EmptyBound && bound4 instanceof EmptyBound) {
                return this.empty(evidence$12);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound5 = tuple2._1();
            Bound<A> bound6 = tuple2._2();
            if (bound5 instanceof Closed) {
                Closed closed = (Closed)bound5;
                Object x = closed.a();
                if (bound6 instanceof Closed) {
                    Closed closed2 = (Closed)bound6;
                    Object y = closed2.a();
                    return Bounded$.MODULE$.apply(x, y, this.closedLowerFlags() | this.closedUpperFlags(), evidence$12);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound7 = tuple2._1();
            Bound<A> bound8 = tuple2._2();
            if (bound7 instanceof Open) {
                Open open2 = (Open)bound7;
                Object x = open2.a();
                if (bound8 instanceof Open) {
                    Open open3 = (Open)bound8;
                    Object y = open3.a();
                    return Bounded$.MODULE$.apply(x, y, this.openLowerFlags() | this.openUpperFlags(), evidence$12);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound9 = tuple2._1();
            Bound<A> bound10 = tuple2._2();
            if (bound9 instanceof Unbound && bound10 instanceof Open) {
                Open open4 = (Open)bound10;
                Object y = open4.a();
                return this.below(y, evidence$12);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound11 = tuple2._1();
            Bound<A> bound12 = tuple2._2();
            if (bound11 instanceof Open) {
                Open open5 = (Open)bound11;
                Object x = open5.a();
                if (bound12 instanceof Unbound) {
                    return this.above(x, evidence$12);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound13 = tuple2._1();
            Bound<A> bound14 = tuple2._2();
            if (bound13 instanceof Unbound && bound14 instanceof Closed) {
                Closed closed = (Closed)bound14;
                Object y = closed.a();
                return this.atOrBelow(y, evidence$12);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound15 = tuple2._1();
            Bound<A> bound16 = tuple2._2();
            if (bound15 instanceof Closed) {
                Closed closed = (Closed)bound15;
                Object x = closed.a();
                if (bound16 instanceof Unbound) {
                    return this.atOrAbove(x, evidence$12);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound17 = tuple2._1();
            Bound<A> bound18 = tuple2._2();
            if (bound17 instanceof Closed) {
                Closed closed = (Closed)bound17;
                Object x = closed.a();
                if (bound18 instanceof Open) {
                    Open open6 = (Open)bound18;
                    Object y = open6.a();
                    return Bounded$.MODULE$.apply(x, y, this.closedLowerFlags() | this.openUpperFlags(), evidence$12);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound19 = tuple2._1();
            Bound<A> bound20 = tuple2._2();
            if (bound19 instanceof Open) {
                Open open7 = (Open)bound19;
                Object x = open7.a();
                if (bound20 instanceof Closed) {
                    Closed closed = (Closed)bound20;
                    Object y = closed.a();
                    return Bounded$.MODULE$.apply(x, y, this.openLowerFlags() | this.closedUpperFlags(), evidence$12);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound21 = tuple2._1();
            Bound<A> bound22 = tuple2._2();
            if (bound21 instanceof Unbound && bound22 instanceof Unbound) {
                return this.all(evidence$12);
            }
        }
        boolean bl = tuple2 != null && (bound2 = tuple2._1()) instanceof EmptyBound ? true : tuple2 != null && (bound = tuple2._2()) instanceof EmptyBound;
        if (!bl) throw new MatchError(tuple2);
        throw new IllegalArgumentException("invalid empty bound");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A> Interval<A> fromBounds(Bound<A> lower, Bound<A> upper, Order<A> evidence$13) {
        Bound<A> bound;
        Bound<A> bound2;
        Tuple2<Bound<A>, Bound<A>> tuple2 = new Tuple2<Bound<A>, Bound<A>>(lower, upper);
        if (tuple2 != null) {
            Bound<A> bound3 = tuple2._1();
            Bound<A> bound4 = tuple2._2();
            if (bound3 instanceof EmptyBound && bound4 instanceof EmptyBound) {
                return this.empty(evidence$13);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound5 = tuple2._1();
            Bound<A> bound6 = tuple2._2();
            if (bound5 instanceof Closed) {
                Closed closed = (Closed)bound5;
                Object x = closed.a();
                if (bound6 instanceof Closed) {
                    Closed closed2 = (Closed)bound6;
                    Object y = closed2.a();
                    return this.closed(x, y, evidence$13);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound7 = tuple2._1();
            Bound<A> bound8 = tuple2._2();
            if (bound7 instanceof Open) {
                Open open2 = (Open)bound7;
                Object x = open2.a();
                if (bound8 instanceof Open) {
                    Open open3 = (Open)bound8;
                    Object y = open3.a();
                    return this.open(x, y, evidence$13);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound9 = tuple2._1();
            Bound<A> bound10 = tuple2._2();
            if (bound9 instanceof Unbound && bound10 instanceof Open) {
                Open open4 = (Open)bound10;
                Object y = open4.a();
                return this.below(y, evidence$13);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound11 = tuple2._1();
            Bound<A> bound12 = tuple2._2();
            if (bound11 instanceof Open) {
                Open open5 = (Open)bound11;
                Object x = open5.a();
                if (bound12 instanceof Unbound) {
                    return this.above(x, evidence$13);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound13 = tuple2._1();
            Bound<A> bound14 = tuple2._2();
            if (bound13 instanceof Unbound && bound14 instanceof Closed) {
                Closed closed = (Closed)bound14;
                Object y = closed.a();
                return this.atOrBelow(y, evidence$13);
            }
        }
        if (tuple2 != null) {
            Bound<A> bound15 = tuple2._1();
            Bound<A> bound16 = tuple2._2();
            if (bound15 instanceof Closed) {
                Closed closed = (Closed)bound15;
                Object x = closed.a();
                if (bound16 instanceof Unbound) {
                    return this.atOrAbove(x, evidence$13);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound17 = tuple2._1();
            Bound<A> bound18 = tuple2._2();
            if (bound17 instanceof Closed) {
                Closed closed = (Closed)bound17;
                Object x = closed.a();
                if (bound18 instanceof Open) {
                    Open open6 = (Open)bound18;
                    Object y = open6.a();
                    return this.openUpper(x, y, evidence$13);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound19 = tuple2._1();
            Bound<A> bound20 = tuple2._2();
            if (bound19 instanceof Open) {
                Open open7 = (Open)bound19;
                Object x = open7.a();
                if (bound20 instanceof Closed) {
                    Closed closed = (Closed)bound20;
                    Object y = closed.a();
                    return this.openLower(x, y, evidence$13);
                }
            }
        }
        if (tuple2 != null) {
            Bound<A> bound21 = tuple2._1();
            Bound<A> bound22 = tuple2._2();
            if (bound21 instanceof Unbound && bound22 instanceof Unbound) {
                return this.all(evidence$13);
            }
        }
        boolean bl = tuple2 != null && (bound2 = tuple2._1()) instanceof EmptyBound ? true : tuple2 != null && (bound = tuple2._2()) instanceof EmptyBound;
        if (!bl) throw new MatchError(tuple2);
        throw new IllegalArgumentException("invalid empty bound");
    }

    public <A> Interval<A> closed(A lower, A upper, Order<A> evidence$14) {
        int c = evidence$14.compare(lower, upper);
        return c < 0 ? Bounded$.MODULE$.apply(lower, upper, 0, evidence$14) : (c == 0 ? Point$.MODULE$.apply(lower, evidence$14) : this.empty(evidence$14));
    }

    public <A> Interval<A> open(A lower, A upper, Order<A> evidence$15) {
        return evidence$15.lt(lower, upper) ? Bounded$.MODULE$.apply(lower, upper, 3, evidence$15) : this.empty(evidence$15);
    }

    public <A> Interval<A> openLower(A lower, A upper, Order<A> evidence$16) {
        return evidence$16.lt(lower, upper) ? Bounded$.MODULE$.apply(lower, upper, 1, evidence$16) : this.empty(evidence$16);
    }

    public <A> Interval<A> openUpper(A lower, A upper, Order<A> evidence$17) {
        return evidence$17.lt(lower, upper) ? Bounded$.MODULE$.apply(lower, upper, 2, evidence$17) : this.empty(evidence$17);
    }

    public <A> Interval<A> above(A a, Order<A> evidence$18) {
        return Above$.MODULE$.apply(a, 1, evidence$18);
    }

    public <A> Interval<A> below(A a, Order<A> evidence$19) {
        return Below$.MODULE$.apply(a, 2, evidence$19);
    }

    public <A> Interval<A> atOrAbove(A a, Order<A> evidence$20) {
        return Above$.MODULE$.apply(a, 0, evidence$20);
    }

    public <A> Interval<A> atOrBelow(A a, Order<A> evidence$21) {
        return Below$.MODULE$.apply(a, 0, evidence$21);
    }

    private Regex NullRe() {
        return this.NullRe;
    }

    private Regex SingleRe() {
        return this.SingleRe;
    }

    private Regex PairRe() {
        return this.PairRe;
    }

    /*
     * Unable to fully structure code
     */
    public Interval<Rational> apply(String s) {
        block3: {
            block5: {
                block7: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block8: {
                                                block6: {
                                                    block4: {
                                                        block2: {
                                                            var4_2 = s;
                                                            var5_3 = this.NullRe().unapplySeq(var4_2);
                                                            if (var5_3.isEmpty() || var5_3.get() == null || ((LinearSeqOptimized)var5_3.get()).lengthCompare(0) != 0) break block2;
                                                            var2_4 = this.empty(Rational$.MODULE$.RationalAlgebra());
                                                            break block3;
                                                        }
                                                        var6_5 = this.SingleRe().unapplySeq(var4_2);
                                                        if (var6_5.isEmpty() || var6_5.get() == null || ((LinearSeqOptimized)var6_5.get()).lengthCompare(1) != 0) break block4;
                                                        x = (String)((LinearSeqOptimized)var6_5.get()).apply(0);
                                                        var2_4 = this.point(Rational$.MODULE$.apply(x), Rational$.MODULE$.RationalAlgebra());
                                                        break block3;
                                                    }
                                                    var8_7 = this.PairRe().unapplySeq(var4_2);
                                                    if (var8_7.isEmpty() || var8_7.get() == null || ((LinearSeqOptimized)var8_7.get()).lengthCompare(4) != 0) break block5;
                                                    left = (String)((LinearSeqOptimized)var8_7.get()).apply(0);
                                                    var13_12 = new Tuple4<String, String, String, String>(left, x = (String)((LinearSeqOptimized)var8_7.get()).apply(1), y = (String)((LinearSeqOptimized)var8_7.get()).apply(2), right = (String)((LinearSeqOptimized)var8_7.get()).apply(3));
                                                    if (var13_12 == null) break block6;
                                                    var14_13 = var13_12._1();
                                                    var15_14 = var13_12._2();
                                                    var16_15 = var13_12._3();
                                                    var17_16 = var13_12._4();
                                                    if (!"(".equals(var14_13) || !"-\u221e".equals(var15_14) || !"\u221e".equals(var16_15) || !")".equals(var17_16)) break block6;
                                                    var3_17 = this.all(Rational$.MODULE$.RationalAlgebra());
                                                    break block7;
                                                }
                                                if (var13_12 == null) break block8;
                                                var18_18 = var13_12._1();
                                                var19_19 = var13_12._2();
                                                y = var13_12._3();
                                                var21_21 = var13_12._4();
                                                if (!"(".equals(var18_18) || !"-\u221e".equals(var19_19) || !")".equals(var21_21)) break block8;
                                                var3_17 = this.below(Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                                                break block7;
                                            }
                                            if (var13_12 == null) break block9;
                                            var22_22 = var13_12._1();
                                            var23_23 = var13_12._2();
                                            y = var13_12._3();
                                            var25_25 = var13_12._4();
                                            if (!"(".equals(var22_22) || !"-\u221e".equals(var23_23) || !"]".equals(var25_25)) break block9;
                                            var3_17 = this.atOrBelow(Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                                            break block7;
                                        }
                                        if (var13_12 == null) break block10;
                                        var26_26 = var13_12._1();
                                        x = var13_12._2();
                                        var28_28 = var13_12._3();
                                        var29_29 = var13_12._4();
                                        if (!"(".equals(var26_26) || !"\u221e".equals(var28_28) || !")".equals(var29_29)) break block10;
                                        var3_17 = this.above(Rational$.MODULE$.apply(x), Rational$.MODULE$.RationalAlgebra());
                                        break block7;
                                    }
                                    if (var13_12 == null) break block11;
                                    var30_30 = var13_12._1();
                                    x = var13_12._2();
                                    var32_32 = var13_12._3();
                                    var33_33 = var13_12._4();
                                    if (!"[".equals(var30_30) || !"\u221e".equals(var32_32) || !")".equals(var33_33)) break block11;
                                    var3_17 = this.atOrAbove(Rational$.MODULE$.apply(x), Rational$.MODULE$.RationalAlgebra());
                                    break block7;
                                }
                                if (var13_12 == null) break block12;
                                var34_34 = var13_12._1();
                                x = var13_12._2();
                                y = var13_12._3();
                                var37_37 = var13_12._4();
                                if (!"[".equals(var34_34) || !"]".equals(var37_37)) break block12;
                                var3_17 = this.closed(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                                break block7;
                            }
                            if (var13_12 == null) break block13;
                            var38_38 = var13_12._1();
                            x = var13_12._2();
                            y = var13_12._3();
                            var41_41 = var13_12._4();
                            if (!"(".equals(var38_38) || !")".equals(var41_41)) break block13;
                            var3_17 = this.open(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                            break block7;
                        }
                        if (var13_12 == null) break block14;
                        var42_42 = var13_12._1();
                        x = var13_12._2();
                        y = var13_12._3();
                        var45_45 = var13_12._4();
                        if (!"[".equals(var42_42) || !")".equals(var45_45)) break block14;
                        var3_17 = this.openUpper(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                        break block7;
                    }
                    if (var13_12 == null) ** GOTO lbl-1000
                    var46_46 = var13_12._1();
                    x = var13_12._2();
                    y = var13_12._3();
                    var49_49 = var13_12._4();
                    if ("(".equals(var46_46) && "]".equals(var49_49)) {
                        var3_17 = this.openLower(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                    } else lbl-1000:
                    // 2 sources

                    {
                        throw new NumberFormatException("Impossible: " + s);
                    }
                }
                var2_4 = var3_17;
                break block3;
            }
            throw new NumberFormatException("For input string: " + s);
        }
        return var2_4;
    }

    public <A> Eq<Interval<A>> eq(Eq<A> evidence$22) {
        return new Eq<Interval<A>>(){

            public boolean eqv$mcZ$sp(boolean x, boolean y) {
                return Eq.eqv$mcZ$sp$(this, x, y);
            }

            public boolean eqv$mcB$sp(byte x, byte y) {
                return Eq.eqv$mcB$sp$(this, x, y);
            }

            public boolean eqv$mcC$sp(char x, char y) {
                return Eq.eqv$mcC$sp$(this, x, y);
            }

            public boolean eqv$mcD$sp(double x, double y) {
                return Eq.eqv$mcD$sp$(this, x, y);
            }

            public boolean eqv$mcF$sp(float x, float y) {
                return Eq.eqv$mcF$sp$(this, x, y);
            }

            public boolean eqv$mcI$sp(int x, int y) {
                return Eq.eqv$mcI$sp$(this, x, y);
            }

            public boolean eqv$mcJ$sp(long x, long y) {
                return Eq.eqv$mcJ$sp$(this, x, y);
            }

            public boolean eqv$mcS$sp(short x, short y) {
                return Eq.eqv$mcS$sp$(this, x, y);
            }

            public boolean eqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Eq.eqv$mcV$sp$(this, x, y);
            }

            public boolean neqv(Object x, Object y) {
                return Eq.neqv$(this, x, y);
            }

            public boolean neqv$mcZ$sp(boolean x, boolean y) {
                return Eq.neqv$mcZ$sp$(this, x, y);
            }

            public boolean neqv$mcB$sp(byte x, byte y) {
                return Eq.neqv$mcB$sp$(this, x, y);
            }

            public boolean neqv$mcC$sp(char x, char y) {
                return Eq.neqv$mcC$sp$(this, x, y);
            }

            public boolean neqv$mcD$sp(double x, double y) {
                return Eq.neqv$mcD$sp$(this, x, y);
            }

            public boolean neqv$mcF$sp(float x, float y) {
                return Eq.neqv$mcF$sp$(this, x, y);
            }

            public boolean neqv$mcI$sp(int x, int y) {
                return Eq.neqv$mcI$sp$(this, x, y);
            }

            public boolean neqv$mcJ$sp(long x, long y) {
                return Eq.neqv$mcJ$sp$(this, x, y);
            }

            public boolean neqv$mcS$sp(short x, short y) {
                return Eq.neqv$mcS$sp$(this, x, y);
            }

            public boolean neqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return Eq.neqv$mcV$sp$(this, x, y);
            }

            public <B> Eq<B> on(Function1<B, Interval<A>> f) {
                return Eq.on$((Eq)this, f);
            }

            public <B> Eq<B> on$mcZ$sp(Function1<B, Object> f) {
                return Eq.on$mcZ$sp$((Eq)this, f);
            }

            public <B> Eq<B> on$mcB$sp(Function1<B, Object> f) {
                return Eq.on$mcB$sp$((Eq)this, f);
            }

            public <B> Eq<B> on$mcC$sp(Function1<B, Object> f) {
                return Eq.on$mcC$sp$((Eq)this, f);
            }

            public <B> Eq<B> on$mcD$sp(Function1<B, Object> f) {
                return Eq.on$mcD$sp$((Eq)this, f);
            }

            public <B> Eq<B> on$mcF$sp(Function1<B, Object> f) {
                return Eq.on$mcF$sp$((Eq)this, f);
            }

            public <B> Eq<B> on$mcI$sp(Function1<B, Object> f) {
                return Eq.on$mcI$sp$((Eq)this, f);
            }

            public <B> Eq<B> on$mcJ$sp(Function1<B, Object> f) {
                return Eq.on$mcJ$sp$((Eq)this, f);
            }

            public <B> Eq<B> on$mcS$sp(Function1<B, Object> f) {
                return Eq.on$mcS$sp$((Eq)this, f);
            }

            public <B> Eq<B> on$mcV$sp(Function1<B, BoxedUnit> f) {
                return Eq.on$mcV$sp$((Eq)this, f);
            }

            public Eq<Object> on$mZc$sp(Function1<Object, Interval<A>> f) {
                return Eq.on$mZc$sp$((Eq)this, f);
            }

            public Eq<Object> on$mZcZ$sp(Function1<Object, Object> f) {
                return Eq.on$mZcZ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mZcB$sp(Function1<Object, Object> f) {
                return Eq.on$mZcB$sp$((Eq)this, f);
            }

            public Eq<Object> on$mZcC$sp(Function1<Object, Object> f) {
                return Eq.on$mZcC$sp$((Eq)this, f);
            }

            public Eq<Object> on$mZcD$sp(Function1<Object, Object> f) {
                return Eq.on$mZcD$sp$((Eq)this, f);
            }

            public Eq<Object> on$mZcF$sp(Function1<Object, Object> f) {
                return Eq.on$mZcF$sp$((Eq)this, f);
            }

            public Eq<Object> on$mZcI$sp(Function1<Object, Object> f) {
                return Eq.on$mZcI$sp$((Eq)this, f);
            }

            public Eq<Object> on$mZcJ$sp(Function1<Object, Object> f) {
                return Eq.on$mZcJ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mZcS$sp(Function1<Object, Object> f) {
                return Eq.on$mZcS$sp$((Eq)this, f);
            }

            public Eq<Object> on$mZcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq.on$mZcV$sp$((Eq)this, f);
            }

            public Eq<Object> on$mBc$sp(Function1<Object, Interval<A>> f) {
                return Eq.on$mBc$sp$((Eq)this, f);
            }

            public Eq<Object> on$mBcZ$sp(Function1<Object, Object> f) {
                return Eq.on$mBcZ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mBcB$sp(Function1<Object, Object> f) {
                return Eq.on$mBcB$sp$((Eq)this, f);
            }

            public Eq<Object> on$mBcC$sp(Function1<Object, Object> f) {
                return Eq.on$mBcC$sp$((Eq)this, f);
            }

            public Eq<Object> on$mBcD$sp(Function1<Object, Object> f) {
                return Eq.on$mBcD$sp$((Eq)this, f);
            }

            public Eq<Object> on$mBcF$sp(Function1<Object, Object> f) {
                return Eq.on$mBcF$sp$((Eq)this, f);
            }

            public Eq<Object> on$mBcI$sp(Function1<Object, Object> f) {
                return Eq.on$mBcI$sp$((Eq)this, f);
            }

            public Eq<Object> on$mBcJ$sp(Function1<Object, Object> f) {
                return Eq.on$mBcJ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mBcS$sp(Function1<Object, Object> f) {
                return Eq.on$mBcS$sp$((Eq)this, f);
            }

            public Eq<Object> on$mBcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq.on$mBcV$sp$((Eq)this, f);
            }

            public Eq<Object> on$mCc$sp(Function1<Object, Interval<A>> f) {
                return Eq.on$mCc$sp$((Eq)this, f);
            }

            public Eq<Object> on$mCcZ$sp(Function1<Object, Object> f) {
                return Eq.on$mCcZ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mCcB$sp(Function1<Object, Object> f) {
                return Eq.on$mCcB$sp$((Eq)this, f);
            }

            public Eq<Object> on$mCcC$sp(Function1<Object, Object> f) {
                return Eq.on$mCcC$sp$((Eq)this, f);
            }

            public Eq<Object> on$mCcD$sp(Function1<Object, Object> f) {
                return Eq.on$mCcD$sp$((Eq)this, f);
            }

            public Eq<Object> on$mCcF$sp(Function1<Object, Object> f) {
                return Eq.on$mCcF$sp$((Eq)this, f);
            }

            public Eq<Object> on$mCcI$sp(Function1<Object, Object> f) {
                return Eq.on$mCcI$sp$((Eq)this, f);
            }

            public Eq<Object> on$mCcJ$sp(Function1<Object, Object> f) {
                return Eq.on$mCcJ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mCcS$sp(Function1<Object, Object> f) {
                return Eq.on$mCcS$sp$((Eq)this, f);
            }

            public Eq<Object> on$mCcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq.on$mCcV$sp$((Eq)this, f);
            }

            public Eq<Object> on$mDc$sp(Function1<Object, Interval<A>> f) {
                return Eq.on$mDc$sp$((Eq)this, f);
            }

            public Eq<Object> on$mDcZ$sp(Function1<Object, Object> f) {
                return Eq.on$mDcZ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mDcB$sp(Function1<Object, Object> f) {
                return Eq.on$mDcB$sp$((Eq)this, f);
            }

            public Eq<Object> on$mDcC$sp(Function1<Object, Object> f) {
                return Eq.on$mDcC$sp$((Eq)this, f);
            }

            public Eq<Object> on$mDcD$sp(Function1<Object, Object> f) {
                return Eq.on$mDcD$sp$((Eq)this, f);
            }

            public Eq<Object> on$mDcF$sp(Function1<Object, Object> f) {
                return Eq.on$mDcF$sp$((Eq)this, f);
            }

            public Eq<Object> on$mDcI$sp(Function1<Object, Object> f) {
                return Eq.on$mDcI$sp$((Eq)this, f);
            }

            public Eq<Object> on$mDcJ$sp(Function1<Object, Object> f) {
                return Eq.on$mDcJ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mDcS$sp(Function1<Object, Object> f) {
                return Eq.on$mDcS$sp$((Eq)this, f);
            }

            public Eq<Object> on$mDcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq.on$mDcV$sp$((Eq)this, f);
            }

            public Eq<Object> on$mFc$sp(Function1<Object, Interval<A>> f) {
                return Eq.on$mFc$sp$((Eq)this, f);
            }

            public Eq<Object> on$mFcZ$sp(Function1<Object, Object> f) {
                return Eq.on$mFcZ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mFcB$sp(Function1<Object, Object> f) {
                return Eq.on$mFcB$sp$((Eq)this, f);
            }

            public Eq<Object> on$mFcC$sp(Function1<Object, Object> f) {
                return Eq.on$mFcC$sp$((Eq)this, f);
            }

            public Eq<Object> on$mFcD$sp(Function1<Object, Object> f) {
                return Eq.on$mFcD$sp$((Eq)this, f);
            }

            public Eq<Object> on$mFcF$sp(Function1<Object, Object> f) {
                return Eq.on$mFcF$sp$((Eq)this, f);
            }

            public Eq<Object> on$mFcI$sp(Function1<Object, Object> f) {
                return Eq.on$mFcI$sp$((Eq)this, f);
            }

            public Eq<Object> on$mFcJ$sp(Function1<Object, Object> f) {
                return Eq.on$mFcJ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mFcS$sp(Function1<Object, Object> f) {
                return Eq.on$mFcS$sp$((Eq)this, f);
            }

            public Eq<Object> on$mFcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq.on$mFcV$sp$((Eq)this, f);
            }

            public Eq<Object> on$mIc$sp(Function1<Object, Interval<A>> f) {
                return Eq.on$mIc$sp$((Eq)this, f);
            }

            public Eq<Object> on$mIcZ$sp(Function1<Object, Object> f) {
                return Eq.on$mIcZ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mIcB$sp(Function1<Object, Object> f) {
                return Eq.on$mIcB$sp$((Eq)this, f);
            }

            public Eq<Object> on$mIcC$sp(Function1<Object, Object> f) {
                return Eq.on$mIcC$sp$((Eq)this, f);
            }

            public Eq<Object> on$mIcD$sp(Function1<Object, Object> f) {
                return Eq.on$mIcD$sp$((Eq)this, f);
            }

            public Eq<Object> on$mIcF$sp(Function1<Object, Object> f) {
                return Eq.on$mIcF$sp$((Eq)this, f);
            }

            public Eq<Object> on$mIcI$sp(Function1<Object, Object> f) {
                return Eq.on$mIcI$sp$((Eq)this, f);
            }

            public Eq<Object> on$mIcJ$sp(Function1<Object, Object> f) {
                return Eq.on$mIcJ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mIcS$sp(Function1<Object, Object> f) {
                return Eq.on$mIcS$sp$((Eq)this, f);
            }

            public Eq<Object> on$mIcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq.on$mIcV$sp$((Eq)this, f);
            }

            public Eq<Object> on$mJc$sp(Function1<Object, Interval<A>> f) {
                return Eq.on$mJc$sp$((Eq)this, f);
            }

            public Eq<Object> on$mJcZ$sp(Function1<Object, Object> f) {
                return Eq.on$mJcZ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mJcB$sp(Function1<Object, Object> f) {
                return Eq.on$mJcB$sp$((Eq)this, f);
            }

            public Eq<Object> on$mJcC$sp(Function1<Object, Object> f) {
                return Eq.on$mJcC$sp$((Eq)this, f);
            }

            public Eq<Object> on$mJcD$sp(Function1<Object, Object> f) {
                return Eq.on$mJcD$sp$((Eq)this, f);
            }

            public Eq<Object> on$mJcF$sp(Function1<Object, Object> f) {
                return Eq.on$mJcF$sp$((Eq)this, f);
            }

            public Eq<Object> on$mJcI$sp(Function1<Object, Object> f) {
                return Eq.on$mJcI$sp$((Eq)this, f);
            }

            public Eq<Object> on$mJcJ$sp(Function1<Object, Object> f) {
                return Eq.on$mJcJ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mJcS$sp(Function1<Object, Object> f) {
                return Eq.on$mJcS$sp$((Eq)this, f);
            }

            public Eq<Object> on$mJcV$sp(Function1<Object, BoxedUnit> f) {
                return Eq.on$mJcV$sp$((Eq)this, f);
            }

            public Eq<Object> on$mSc$sp(Function1<Object, Interval<A>> f) {
                return Eq.on$mSc$sp$((Eq)this, f);
            }

            public Eq<Object> on$mScZ$sp(Function1<Object, Object> f) {
                return Eq.on$mScZ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mScB$sp(Function1<Object, Object> f) {
                return Eq.on$mScB$sp$((Eq)this, f);
            }

            public Eq<Object> on$mScC$sp(Function1<Object, Object> f) {
                return Eq.on$mScC$sp$((Eq)this, f);
            }

            public Eq<Object> on$mScD$sp(Function1<Object, Object> f) {
                return Eq.on$mScD$sp$((Eq)this, f);
            }

            public Eq<Object> on$mScF$sp(Function1<Object, Object> f) {
                return Eq.on$mScF$sp$((Eq)this, f);
            }

            public Eq<Object> on$mScI$sp(Function1<Object, Object> f) {
                return Eq.on$mScI$sp$((Eq)this, f);
            }

            public Eq<Object> on$mScJ$sp(Function1<Object, Object> f) {
                return Eq.on$mScJ$sp$((Eq)this, f);
            }

            public Eq<Object> on$mScS$sp(Function1<Object, Object> f) {
                return Eq.on$mScS$sp$((Eq)this, f);
            }

            public Eq<Object> on$mScV$sp(Function1<Object, BoxedUnit> f) {
                return Eq.on$mScV$sp$((Eq)this, f);
            }

            public Eq<BoxedUnit> on$mVc$sp(Function1<BoxedUnit, Interval<A>> f) {
                return Eq.on$mVc$sp$((Eq)this, f);
            }

            public Eq<BoxedUnit> on$mVcZ$sp(Function1<BoxedUnit, Object> f) {
                return Eq.on$mVcZ$sp$((Eq)this, f);
            }

            public Eq<BoxedUnit> on$mVcB$sp(Function1<BoxedUnit, Object> f) {
                return Eq.on$mVcB$sp$((Eq)this, f);
            }

            public Eq<BoxedUnit> on$mVcC$sp(Function1<BoxedUnit, Object> f) {
                return Eq.on$mVcC$sp$((Eq)this, f);
            }

            public Eq<BoxedUnit> on$mVcD$sp(Function1<BoxedUnit, Object> f) {
                return Eq.on$mVcD$sp$((Eq)this, f);
            }

            public Eq<BoxedUnit> on$mVcF$sp(Function1<BoxedUnit, Object> f) {
                return Eq.on$mVcF$sp$((Eq)this, f);
            }

            public Eq<BoxedUnit> on$mVcI$sp(Function1<BoxedUnit, Object> f) {
                return Eq.on$mVcI$sp$((Eq)this, f);
            }

            public Eq<BoxedUnit> on$mVcJ$sp(Function1<BoxedUnit, Object> f) {
                return Eq.on$mVcJ$sp$((Eq)this, f);
            }

            public Eq<BoxedUnit> on$mVcS$sp(Function1<BoxedUnit, Object> f) {
                return Eq.on$mVcS$sp$((Eq)this, f);
            }

            public Eq<BoxedUnit> on$mVcV$sp(Function1<BoxedUnit, BoxedUnit> f) {
                return Eq.on$mVcV$sp$((Eq)this, f);
            }

            public Eq<Interval<A>> and(Eq<Interval<A>> that) {
                return Eq.and$((Eq)this, that);
            }

            public Eq<Object> and$mcZ$sp(Eq<Object> that) {
                return Eq.and$mcZ$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcB$sp(Eq<Object> that) {
                return Eq.and$mcB$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcC$sp(Eq<Object> that) {
                return Eq.and$mcC$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcD$sp(Eq<Object> that) {
                return Eq.and$mcD$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcF$sp(Eq<Object> that) {
                return Eq.and$mcF$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcI$sp(Eq<Object> that) {
                return Eq.and$mcI$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcJ$sp(Eq<Object> that) {
                return Eq.and$mcJ$sp$((Eq)this, that);
            }

            public Eq<Object> and$mcS$sp(Eq<Object> that) {
                return Eq.and$mcS$sp$((Eq)this, that);
            }

            public Eq<BoxedUnit> and$mcV$sp(Eq<BoxedUnit> that) {
                return Eq.and$mcV$sp$((Eq)this, that);
            }

            public Eq<Interval<A>> or(Eq<Interval<A>> that) {
                return Eq.or$((Eq)this, that);
            }

            public Eq<Object> or$mcZ$sp(Eq<Object> that) {
                return Eq.or$mcZ$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcB$sp(Eq<Object> that) {
                return Eq.or$mcB$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcC$sp(Eq<Object> that) {
                return Eq.or$mcC$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcD$sp(Eq<Object> that) {
                return Eq.or$mcD$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcF$sp(Eq<Object> that) {
                return Eq.or$mcF$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcI$sp(Eq<Object> that) {
                return Eq.or$mcI$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcJ$sp(Eq<Object> that) {
                return Eq.or$mcJ$sp$((Eq)this, that);
            }

            public Eq<Object> or$mcS$sp(Eq<Object> that) {
                return Eq.or$mcS$sp$((Eq)this, that);
            }

            public Eq<BoxedUnit> or$mcV$sp(Eq<BoxedUnit> that) {
                return Eq.or$mcV$sp$((Eq)this, that);
            }

            public boolean eqv(Interval<A> x, Interval<A> y) {
                Interval<A> interval = x;
                Interval<A> interval2 = y;
                return !(interval != null ? !interval.equals(interval2) : interval2 != null);
            }
            {
                Eq.$init$(this);
            }
        };
    }

    public <A> Semiring<Interval<A>> semiring(Ring<A> ev, Order<A> o) {
        return new Semiring<Interval<A>>(ev, o){
            private final Ring ev$1;
            private final Order o$1;

            public Semigroup<Interval<A>> multiplicative() {
                return MultiplicativeSemigroup.multiplicative$(this);
            }

            public Semigroup<Object> multiplicative$mcD$sp() {
                return MultiplicativeSemigroup.multiplicative$mcD$sp$(this);
            }

            public Semigroup<Object> multiplicative$mcF$sp() {
                return MultiplicativeSemigroup.multiplicative$mcF$sp$(this);
            }

            public Semigroup<Object> multiplicative$mcI$sp() {
                return MultiplicativeSemigroup.multiplicative$mcI$sp$(this);
            }

            public Semigroup<Object> multiplicative$mcJ$sp() {
                return MultiplicativeSemigroup.multiplicative$mcJ$sp$(this);
            }

            public double times$mcD$sp(double x, double y) {
                return MultiplicativeSemigroup.times$mcD$sp$(this, x, y);
            }

            public float times$mcF$sp(float x, float y) {
                return MultiplicativeSemigroup.times$mcF$sp$(this, x, y);
            }

            public int times$mcI$sp(int x, int y) {
                return MultiplicativeSemigroup.times$mcI$sp$(this, x, y);
            }

            public long times$mcJ$sp(long x, long y) {
                return MultiplicativeSemigroup.times$mcJ$sp$(this, x, y);
            }

            public double pow$mcD$sp(double a, int n) {
                return MultiplicativeSemigroup.pow$mcD$sp$(this, a, n);
            }

            public float pow$mcF$sp(float a, int n) {
                return MultiplicativeSemigroup.pow$mcF$sp$(this, a, n);
            }

            public int pow$mcI$sp(int a, int n) {
                return MultiplicativeSemigroup.pow$mcI$sp$(this, a, n);
            }

            public long pow$mcJ$sp(long a, int n) {
                return MultiplicativeSemigroup.pow$mcJ$sp$(this, a, n);
            }

            public Object positivePow(Object a, int n) {
                return MultiplicativeSemigroup.positivePow$(this, a, n);
            }

            public double positivePow$mcD$sp(double a, int n) {
                return MultiplicativeSemigroup.positivePow$mcD$sp$(this, a, n);
            }

            public float positivePow$mcF$sp(float a, int n) {
                return MultiplicativeSemigroup.positivePow$mcF$sp$(this, a, n);
            }

            public int positivePow$mcI$sp(int a, int n) {
                return MultiplicativeSemigroup.positivePow$mcI$sp$(this, a, n);
            }

            public long positivePow$mcJ$sp(long a, int n) {
                return MultiplicativeSemigroup.positivePow$mcJ$sp$(this, a, n);
            }

            public Option<Interval<A>> tryProduct(TraversableOnce<Interval<A>> as) {
                return MultiplicativeSemigroup.tryProduct$(this, as);
            }

            public CommutativeMonoid<Interval<A>> additive() {
                return AdditiveCommutativeMonoid.additive$(this);
            }

            public CommutativeMonoid<Object> additive$mcD$sp() {
                return AdditiveCommutativeMonoid.additive$mcD$sp$(this);
            }

            public CommutativeMonoid<Object> additive$mcF$sp() {
                return AdditiveCommutativeMonoid.additive$mcF$sp$(this);
            }

            public CommutativeMonoid<Object> additive$mcI$sp() {
                return AdditiveCommutativeMonoid.additive$mcI$sp$(this);
            }

            public CommutativeMonoid<Object> additive$mcJ$sp() {
                return AdditiveCommutativeMonoid.additive$mcJ$sp$(this);
            }

            public double zero$mcD$sp() {
                return AdditiveMonoid.zero$mcD$sp$(this);
            }

            public float zero$mcF$sp() {
                return AdditiveMonoid.zero$mcF$sp$(this);
            }

            public int zero$mcI$sp() {
                return AdditiveMonoid.zero$mcI$sp$(this);
            }

            public long zero$mcJ$sp() {
                return AdditiveMonoid.zero$mcJ$sp$(this);
            }

            public boolean isZero(Object a, Eq ev) {
                return AdditiveMonoid.isZero$(this, a, ev);
            }

            public boolean isZero$mcD$sp(double a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcD$sp$(this, a, ev);
            }

            public boolean isZero$mcF$sp(float a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcF$sp$(this, a, ev);
            }

            public boolean isZero$mcI$sp(int a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcI$sp$(this, a, ev);
            }

            public boolean isZero$mcJ$sp(long a, Eq<Object> ev) {
                return AdditiveMonoid.isZero$mcJ$sp$(this, a, ev);
            }

            public Object sumN(Object a, int n) {
                return AdditiveMonoid.sumN$(this, a, n);
            }

            public double sumN$mcD$sp(double a, int n) {
                return AdditiveMonoid.sumN$mcD$sp$(this, a, n);
            }

            public float sumN$mcF$sp(float a, int n) {
                return AdditiveMonoid.sumN$mcF$sp$(this, a, n);
            }

            public int sumN$mcI$sp(int a, int n) {
                return AdditiveMonoid.sumN$mcI$sp$(this, a, n);
            }

            public long sumN$mcJ$sp(long a, int n) {
                return AdditiveMonoid.sumN$mcJ$sp$(this, a, n);
            }

            public Object sum(TraversableOnce as) {
                return AdditiveMonoid.sum$(this, as);
            }

            public double sum$mcD$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcD$sp$(this, as);
            }

            public float sum$mcF$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcF$sp$(this, as);
            }

            public int sum$mcI$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcI$sp$(this, as);
            }

            public long sum$mcJ$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcJ$sp$(this, as);
            }

            public Option<Interval<A>> trySum(TraversableOnce<Interval<A>> as) {
                return AdditiveMonoid.trySum$(this, as);
            }

            public double plus$mcD$sp(double x, double y) {
                return AdditiveSemigroup.plus$mcD$sp$(this, x, y);
            }

            public float plus$mcF$sp(float x, float y) {
                return AdditiveSemigroup.plus$mcF$sp$(this, x, y);
            }

            public int plus$mcI$sp(int x, int y) {
                return AdditiveSemigroup.plus$mcI$sp$(this, x, y);
            }

            public long plus$mcJ$sp(long x, long y) {
                return AdditiveSemigroup.plus$mcJ$sp$(this, x, y);
            }

            public Object positiveSumN(Object a, int n) {
                return AdditiveSemigroup.positiveSumN$(this, a, n);
            }

            public double positiveSumN$mcD$sp(double a, int n) {
                return AdditiveSemigroup.positiveSumN$mcD$sp$(this, a, n);
            }

            public float positiveSumN$mcF$sp(float a, int n) {
                return AdditiveSemigroup.positiveSumN$mcF$sp$(this, a, n);
            }

            public int positiveSumN$mcI$sp(int a, int n) {
                return AdditiveSemigroup.positiveSumN$mcI$sp$(this, a, n);
            }

            public long positiveSumN$mcJ$sp(long a, int n) {
                return AdditiveSemigroup.positiveSumN$mcJ$sp$(this, a, n);
            }

            public Interval<A> zero() {
                return Interval$.MODULE$.point(this.ev$1.zero(), this.o$1);
            }

            public Interval<A> plus(Interval<A> x, Interval<A> y) {
                return x.$plus(y, (AdditiveSemigroup<Interval<A>>)this.ev$1);
            }

            public Interval<A> times(Interval<A> x, Interval<A> y) {
                return x.$times(y, (Semiring<Interval<A>>)this.ev$1);
            }

            public Interval<A> pow(Interval<A> x, int k) {
                return x.pow(k, this.ev$1);
            }
            {
                this.ev$1 = ev$1;
                this.o$1 = o$1;
                AdditiveSemigroup.$init$(this);
                AdditiveMonoid.$init$(this);
                AdditiveCommutativeSemigroup.$init$(this);
                AdditiveCommutativeMonoid.$init$(this);
                MultiplicativeSemigroup.$init$(this);
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Interval$() {
        MODULE$ = this;
        this.NullRe = new StringOps(Predef$.MODULE$.augmentString("^ *\\( *\u00d8 *\\) *$")).r();
        this.SingleRe = new StringOps(Predef$.MODULE$.augmentString("^ *\\[ *([^,]+) *\\] *$")).r();
        this.PairRe = new StringOps(Predef$.MODULE$.augmentString("^ *(\\[|\\() *(.+?) *, *(.+?) *(\\]|\\)) *$")).r();
    }
}

