from jpype._core import _JRuntime
from jpype._jcollection import _JIterable
from jpype._jio import _JCloseable
from jpype._jstring import _JStringProto
from jpype._jthread import _JThread
import java
import java.io
import java.lang.annotation
import java.lang.instrument
import java.lang.invoke
import java.lang.management
import java.lang.module
import java.lang.ref
import java.lang.reflect
import java.net
import java.nio
import java.nio.channels
import java.nio.charset
import java.security
import java.time
import java.util
import java.util.concurrent
import java.util.function
import java.util.stream
import jpype.protocol
import typing



class Appendable:
    @typing.overload
    def append(self, char: str) -> 'Appendable': ...
    @typing.overload
    def append(self, charSequence: typing.Union['CharSequence', str]) -> 'Appendable': ...
    @typing.overload
    def append(self, charSequence: typing.Union['CharSequence', str], int: int, int2: int) -> 'Appendable': ...

class AutoCloseable(_JCloseable):
    def close(self) -> None: ...

class CharSequence:
    def charAt(self, int: int) -> str: ...
    def chars(self) -> java.util.stream.IntStream: ...
    def codePoints(self) -> java.util.stream.IntStream: ...
    @staticmethod
    def compare(charSequence: typing.Union['CharSequence', str], charSequence2: typing.Union['CharSequence', str]) -> int: ...
    def length(self) -> int: ...
    def subSequence(self, int: int, int2: int) -> 'CharSequence': ...
    def toString(self) -> str: ...

_Class__T = typing.TypeVar('_Class__T')  # <T>
class Class(java.io.Serializable, java.lang.reflect.GenericDeclaration, java.lang.reflect.Type, java.lang.reflect.AnnotatedElement, typing.Generic[_Class__T]):
    _asSubclass__U = typing.TypeVar('_asSubclass__U')  # <U>
    def asSubclass(self, class_: typing.Type[_asSubclass__U]) -> typing.Type[_asSubclass__U]: ...
    def cast(self, object: typing.Any) -> _Class__T: ...
    def desiredAssertionStatus(self) -> bool: ...
    @typing.overload
    @staticmethod
    def forName(module: 'Module', string: str) -> typing.Type[typing.Any]: ...
    @typing.overload
    @staticmethod
    def forName(string: str) -> typing.Type[typing.Any]: ...
    @typing.overload
    @staticmethod
    def forName(string: str, boolean: bool, classLoader: 'ClassLoader') -> typing.Type[typing.Any]: ...
    def getAnnotatedInterfaces(self) -> typing.List[java.lang.reflect.AnnotatedType]: ...
    def getAnnotatedSuperclass(self) -> java.lang.reflect.AnnotatedType: ...
    _getAnnotation__A = typing.TypeVar('_getAnnotation__A', bound=java.lang.annotation.Annotation)  # <A>
    def getAnnotation(self, class_: typing.Type[_getAnnotation__A]) -> _getAnnotation__A: ...
    def getAnnotations(self) -> typing.List[java.lang.annotation.Annotation]: ...
    _getAnnotationsByType__A = typing.TypeVar('_getAnnotationsByType__A', bound=java.lang.annotation.Annotation)  # <A>
    def getAnnotationsByType(self, class_: typing.Type[_getAnnotationsByType__A]) -> typing.List[_getAnnotationsByType__A]: ...
    def getCanonicalName(self) -> str: ...
    def getClassLoader(self) -> 'ClassLoader': ...
    def getClasses(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getComponentType(self) -> typing.Type[typing.Any]: ...
    def getConstructor(self, classArray: typing.List[typing.Type[typing.Any]]) -> java.lang.reflect.Constructor[_Class__T]: ...
    def getConstructors(self) -> typing.List[java.lang.reflect.Constructor[typing.Any]]: ...
    _getDeclaredAnnotation__A = typing.TypeVar('_getDeclaredAnnotation__A', bound=java.lang.annotation.Annotation)  # <A>
    def getDeclaredAnnotation(self, class_: typing.Type[_getDeclaredAnnotation__A]) -> _getDeclaredAnnotation__A: ...
    def getDeclaredAnnotations(self) -> typing.List[java.lang.annotation.Annotation]: ...
    _getDeclaredAnnotationsByType__A = typing.TypeVar('_getDeclaredAnnotationsByType__A', bound=java.lang.annotation.Annotation)  # <A>
    def getDeclaredAnnotationsByType(self, class_: typing.Type[_getDeclaredAnnotationsByType__A]) -> typing.List[_getDeclaredAnnotationsByType__A]: ...
    def getDeclaredClasses(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getDeclaredConstructor(self, classArray: typing.List[typing.Type[typing.Any]]) -> java.lang.reflect.Constructor[_Class__T]: ...
    def getDeclaredConstructors(self) -> typing.List[java.lang.reflect.Constructor[typing.Any]]: ...
    def getDeclaredField(self, string: str) -> java.lang.reflect.Field: ...
    def getDeclaredFields(self) -> typing.List[java.lang.reflect.Field]: ...
    def getDeclaredMethod(self, string: str, classArray: typing.List[typing.Type[typing.Any]]) -> java.lang.reflect.Method: ...
    def getDeclaredMethods(self) -> typing.List[java.lang.reflect.Method]: ...
    def getDeclaringClass(self) -> typing.Type[typing.Any]: ...
    def getEnclosingClass(self) -> typing.Type[typing.Any]: ...
    def getEnclosingConstructor(self) -> java.lang.reflect.Constructor[typing.Any]: ...
    def getEnclosingMethod(self) -> java.lang.reflect.Method: ...
    def getEnumConstants(self) -> typing.List[_Class__T]: ...
    def getField(self, string: str) -> java.lang.reflect.Field: ...
    def getFields(self) -> typing.List[java.lang.reflect.Field]: ...
    def getGenericInterfaces(self) -> typing.List[java.lang.reflect.Type]: ...
    def getGenericSuperclass(self) -> java.lang.reflect.Type: ...
    def getInterfaces(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getMethod(self, string: str, classArray: typing.List[typing.Type[typing.Any]]) -> java.lang.reflect.Method: ...
    def getMethods(self) -> typing.List[java.lang.reflect.Method]: ...
    def getModifiers(self) -> int: ...
    def getModule(self) -> 'Module': ...
    def getName(self) -> str: ...
    def getNestHost(self) -> typing.Type[typing.Any]: ...
    def getNestMembers(self) -> typing.List[typing.Type[typing.Any]]: ...
    def getPackage(self) -> 'Package': ...
    def getPackageName(self) -> str: ...
    def getProtectionDomain(self) -> java.security.ProtectionDomain: ...
    def getResource(self, string: str) -> java.net.URL: ...
    def getResourceAsStream(self, string: str) -> java.io.InputStream: ...
    def getSigners(self) -> typing.List[typing.Any]: ...
    def getSimpleName(self) -> str: ...
    def getSuperclass(self) -> typing.Type[_Class__T]: ...
    def getTypeName(self) -> str: ...
    def getTypeParameters(self) -> typing.List[java.lang.reflect.TypeVariable[typing.Type[_Class__T]]]: ...
    def isAnnotation(self) -> bool: ...
    def isAnnotationPresent(self, class_: typing.Type[java.lang.annotation.Annotation]) -> bool: ...
    def isAnonymousClass(self) -> bool: ...
    def isArray(self) -> bool: ...
    def isAssignableFrom(self, class_: typing.Type[typing.Any]) -> bool: ...
    def isEnum(self) -> bool: ...
    def isInstance(self, object: typing.Any) -> bool: ...
    def isInterface(self) -> bool: ...
    def isLocalClass(self) -> bool: ...
    def isMemberClass(self) -> bool: ...
    def isNestmateOf(self, class_: typing.Type[typing.Any]) -> bool: ...
    def isPrimitive(self) -> bool: ...
    def isSynthetic(self) -> bool: ...
    def newInstance(self) -> _Class__T: ...
    def toGenericString(self) -> str: ...
    def toString(self) -> str: ...

class ClassLoader:
    def clearAssertionStatus(self) -> None: ...
    def getDefinedPackage(self, string: str) -> 'Package': ...
    def getDefinedPackages(self) -> typing.List['Package']: ...
    def getName(self) -> str: ...
    def getParent(self) -> 'ClassLoader': ...
    @staticmethod
    def getPlatformClassLoader() -> 'ClassLoader': ...
    def getResource(self, string: str) -> java.net.URL: ...
    def getResourceAsStream(self, string: str) -> java.io.InputStream: ...
    def getResources(self, string: str) -> java.util.Enumeration[java.net.URL]: ...
    @staticmethod
    def getSystemClassLoader() -> 'ClassLoader': ...
    @staticmethod
    def getSystemResource(string: str) -> java.net.URL: ...
    @staticmethod
    def getSystemResourceAsStream(string: str) -> java.io.InputStream: ...
    @staticmethod
    def getSystemResources(string: str) -> java.util.Enumeration[java.net.URL]: ...
    def getUnnamedModule(self) -> 'Module': ...
    def isRegisteredAsParallelCapable(self) -> bool: ...
    def loadClass(self, string: str) -> typing.Type[typing.Any]: ...
    def resources(self, string: str) -> java.util.stream.Stream[java.net.URL]: ...
    def setClassAssertionStatus(self, string: str, boolean: bool) -> None: ...
    def setDefaultAssertionStatus(self, boolean: bool) -> None: ...
    def setPackageAssertionStatus(self, string: str, boolean: bool) -> None: ...

_ClassValue__T = typing.TypeVar('_ClassValue__T')  # <T>
class ClassValue(typing.Generic[_ClassValue__T]):
    def get(self, class_: typing.Type[typing.Any]) -> _ClassValue__T: ...
    def remove(self, class_: typing.Type[typing.Any]) -> None: ...

class Cloneable: ...

_Comparable__T = typing.TypeVar('_Comparable__T')  # <T>
class Comparable(typing.Generic[_Comparable__T]):
    def compareTo(self, t: _Comparable__T) -> int: ...

class Compiler:
    @staticmethod
    def command(object: typing.Any) -> typing.Any: ...
    @staticmethod
    def compileClass(class_: typing.Type[typing.Any]) -> bool: ...
    @staticmethod
    def compileClasses(string: str) -> bool: ...
    @staticmethod
    def disable() -> None: ...
    @staticmethod
    def enable() -> None: ...

class Deprecated(java.lang.annotation.Annotation):
    def equals(self, object: typing.Any) -> bool: ...
    def forRemoval(self) -> bool: ...
    def hashCode(self) -> int: ...
    def since(self) -> str: ...
    def toString(self) -> str: ...

class FunctionalInterface(java.lang.annotation.Annotation):
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

_Iterable__T = typing.TypeVar('_Iterable__T')  # <T>
class Iterable(typing.Generic[_Iterable__T], _JIterable[_Iterable__T]):
    def forEach(self, consumer: typing.Union[java.util.function.Consumer[_Iterable__T], typing.Callable[[_Iterable__T], None]]) -> None: ...
    def iterator(self) -> java.util.Iterator[_Iterable__T]: ...
    def spliterator(self) -> java.util.Spliterator[_Iterable__T]: ...

class Math:
    E: typing.ClassVar[float] = ...
    PI: typing.ClassVar[float] = ...
    @staticmethod
    def IEEEremainder(double: float, double2: float) -> float: ...
    @typing.overload
    @staticmethod
    def abs(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def abs(float: float) -> float: ...
    @typing.overload
    @staticmethod
    def abs(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def abs(long: int) -> int: ...
    @staticmethod
    def acos(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def addExact(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def addExact(long: int, long2: int) -> int: ...
    @staticmethod
    def asin(double: float) -> float: ...
    @staticmethod
    def atan(double: float) -> float: ...
    @staticmethod
    def atan2(double: float, double2: float) -> float: ...
    @staticmethod
    def cbrt(double: float) -> float: ...
    @staticmethod
    def ceil(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def copySign(double: float, double2: float) -> float: ...
    @typing.overload
    @staticmethod
    def copySign(float: float, float2: float) -> float: ...
    @staticmethod
    def cos(double: float) -> float: ...
    @staticmethod
    def cosh(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def decrementExact(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def decrementExact(long: int) -> int: ...
    @staticmethod
    def exp(double: float) -> float: ...
    @staticmethod
    def expm1(double: float) -> float: ...
    @staticmethod
    def floor(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def floorDiv(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def floorDiv(long: int, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def floorDiv(long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def floorMod(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def floorMod(long: int, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def floorMod(long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def fma(double: float, double2: float, double3: float) -> float: ...
    @typing.overload
    @staticmethod
    def fma(float: float, float2: float, float3: float) -> float: ...
    @typing.overload
    @staticmethod
    def getExponent(double: float) -> int: ...
    @typing.overload
    @staticmethod
    def getExponent(float: float) -> int: ...
    @staticmethod
    def hypot(double: float, double2: float) -> float: ...
    @typing.overload
    @staticmethod
    def incrementExact(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def incrementExact(long: int) -> int: ...
    @staticmethod
    def log(double: float) -> float: ...
    @staticmethod
    def log10(double: float) -> float: ...
    @staticmethod
    def log1p(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def max(double: float, double2: float) -> float: ...
    @typing.overload
    @staticmethod
    def max(float: float, float2: float) -> float: ...
    @typing.overload
    @staticmethod
    def max(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def max(long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def min(double: float, double2: float) -> float: ...
    @typing.overload
    @staticmethod
    def min(float: float, float2: float) -> float: ...
    @typing.overload
    @staticmethod
    def min(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def min(long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def multiplyExact(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def multiplyExact(long: int, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def multiplyExact(long: int, long2: int) -> int: ...
    @staticmethod
    def multiplyFull(int: int, int2: int) -> int: ...
    @staticmethod
    def multiplyHigh(long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def negateExact(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def negateExact(long: int) -> int: ...
    @typing.overload
    @staticmethod
    def nextAfter(double: float, double2: float) -> float: ...
    @typing.overload
    @staticmethod
    def nextAfter(float: float, double: float) -> float: ...
    @typing.overload
    @staticmethod
    def nextDown(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def nextDown(float: float) -> float: ...
    @typing.overload
    @staticmethod
    def nextUp(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def nextUp(float: float) -> float: ...
    @staticmethod
    def pow(double: float, double2: float) -> float: ...
    @staticmethod
    def random() -> float: ...
    @staticmethod
    def rint(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def round(float: float) -> int: ...
    @typing.overload
    @staticmethod
    def round(double: float) -> int: ...
    @typing.overload
    @staticmethod
    def scalb(double: float, int: int) -> float: ...
    @typing.overload
    @staticmethod
    def scalb(float: float, int: int) -> float: ...
    @typing.overload
    @staticmethod
    def signum(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def signum(float: float) -> float: ...
    @staticmethod
    def sin(double: float) -> float: ...
    @staticmethod
    def sinh(double: float) -> float: ...
    @staticmethod
    def sqrt(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def subtractExact(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def subtractExact(long: int, long2: int) -> int: ...
    @staticmethod
    def tan(double: float) -> float: ...
    @staticmethod
    def tanh(double: float) -> float: ...
    @staticmethod
    def toDegrees(double: float) -> float: ...
    @staticmethod
    def toIntExact(long: int) -> int: ...
    @staticmethod
    def toRadians(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def ulp(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def ulp(float: float) -> float: ...

class Module(java.lang.reflect.AnnotatedElement):
    def addExports(self, string: str, module: 'Module') -> 'Module': ...
    def addOpens(self, string: str, module: 'Module') -> 'Module': ...
    def addReads(self, module: 'Module') -> 'Module': ...
    def addUses(self, class_: typing.Type[typing.Any]) -> 'Module': ...
    def canRead(self, module: 'Module') -> bool: ...
    def canUse(self, class_: typing.Type[typing.Any]) -> bool: ...
    _getAnnotation__T = typing.TypeVar('_getAnnotation__T', bound=java.lang.annotation.Annotation)  # <T>
    def getAnnotation(self, class_: typing.Type[_getAnnotation__T]) -> _getAnnotation__T: ...
    def getAnnotations(self) -> typing.List[java.lang.annotation.Annotation]: ...
    def getClassLoader(self) -> ClassLoader: ...
    def getDeclaredAnnotations(self) -> typing.List[java.lang.annotation.Annotation]: ...
    def getDescriptor(self) -> java.lang.module.ModuleDescriptor: ...
    def getLayer(self) -> 'ModuleLayer': ...
    def getName(self) -> str: ...
    def getPackages(self) -> java.util.Set[str]: ...
    def getResourceAsStream(self, string: str) -> java.io.InputStream: ...
    @typing.overload
    def isExported(self, string: str) -> bool: ...
    @typing.overload
    def isExported(self, string: str, module: 'Module') -> bool: ...
    def isNamed(self) -> bool: ...
    @typing.overload
    def isOpen(self, string: str) -> bool: ...
    @typing.overload
    def isOpen(self, string: str, module: 'Module') -> bool: ...
    def toString(self) -> str: ...

class ModuleLayer:
    @staticmethod
    def boot() -> 'ModuleLayer': ...
    def configuration(self) -> java.lang.module.Configuration: ...
    @typing.overload
    def defineModules(self, configuration: java.lang.module.Configuration, function: typing.Union[java.util.function.Function[str, ClassLoader], typing.Callable[[str], ClassLoader]]) -> 'ModuleLayer': ...
    @typing.overload
    @staticmethod
    def defineModules(configuration: java.lang.module.Configuration, list: java.util.List['ModuleLayer'], function: typing.Union[java.util.function.Function[str, ClassLoader], typing.Callable[[str], ClassLoader]]) -> 'ModuleLayer.Controller': ...
    @typing.overload
    def defineModulesWithManyLoaders(self, configuration: java.lang.module.Configuration, classLoader: ClassLoader) -> 'ModuleLayer': ...
    @typing.overload
    @staticmethod
    def defineModulesWithManyLoaders(configuration: java.lang.module.Configuration, list: java.util.List['ModuleLayer'], classLoader: ClassLoader) -> 'ModuleLayer.Controller': ...
    @typing.overload
    def defineModulesWithOneLoader(self, configuration: java.lang.module.Configuration, classLoader: ClassLoader) -> 'ModuleLayer': ...
    @typing.overload
    @staticmethod
    def defineModulesWithOneLoader(configuration: java.lang.module.Configuration, list: java.util.List['ModuleLayer'], classLoader: ClassLoader) -> 'ModuleLayer.Controller': ...
    @staticmethod
    def empty() -> 'ModuleLayer': ...
    def findLoader(self, string: str) -> ClassLoader: ...
    def findModule(self, string: str) -> java.util.Optional[Module]: ...
    def modules(self) -> java.util.Set[Module]: ...
    def parents(self) -> java.util.List['ModuleLayer']: ...
    def toString(self) -> str: ...
    class Controller:
        def addExports(self, module: Module, string: str, module2: Module) -> 'ModuleLayer.Controller': ...
        def addOpens(self, module: Module, string: str, module2: Module) -> 'ModuleLayer.Controller': ...
        def addReads(self, module: Module, module2: Module) -> 'ModuleLayer.Controller': ...
        def layer(self) -> 'ModuleLayer': ...

class Number(java.io.Serializable):
    def __init__(self): ...
    def byteValue(self) -> int: ...
    def doubleValue(self) -> float: ...
    def floatValue(self) -> float: ...
    def intValue(self) -> int: ...
    def longValue(self) -> int: ...
    def shortValue(self) -> int: ...

class Object:
    def __init__(self): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getClass(self) -> typing.Type[typing.Any]: ...
    def hashCode(self) -> int: ...
    def notify(self) -> None: ...
    def notifyAll(self) -> None: ...
    def toString(self) -> str: ...
    @typing.overload
    def wait(self, long: int) -> None: ...
    @typing.overload
    def wait(self) -> None: ...
    @typing.overload
    def wait(self, long: int, int: int) -> None: ...

class Override(java.lang.annotation.Annotation):
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class Process:
    def __init__(self): ...
    def children(self) -> java.util.stream.Stream['ProcessHandle']: ...
    def descendants(self) -> java.util.stream.Stream['ProcessHandle']: ...
    def destroy(self) -> None: ...
    def destroyForcibly(self) -> 'Process': ...
    def exitValue(self) -> int: ...
    def getErrorStream(self) -> java.io.InputStream: ...
    def getInputStream(self) -> java.io.InputStream: ...
    def getOutputStream(self) -> java.io.OutputStream: ...
    def info(self) -> 'ProcessHandle.Info': ...
    def isAlive(self) -> bool: ...
    def onExit(self) -> java.util.concurrent.CompletableFuture['Process']: ...
    def pid(self) -> int: ...
    def supportsNormalTermination(self) -> bool: ...
    def toHandle(self) -> 'ProcessHandle': ...
    @typing.overload
    def waitFor(self) -> int: ...
    @typing.overload
    def waitFor(self, long: int, timeUnit: java.util.concurrent.TimeUnit) -> bool: ...

class Readable:
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...

class Runnable:
    def run(self) -> None: ...

class RuntimePermission(java.security.BasicPermission):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...

class SafeVarargs(java.lang.annotation.Annotation):
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class SecurityManager:
    def __init__(self): ...
    def checkAccept(self, string: str, int: int) -> None: ...
    @typing.overload
    def checkAccess(self, thread: 'Thread') -> None: ...
    @typing.overload
    def checkAccess(self, threadGroup: 'ThreadGroup') -> None: ...
    @typing.overload
    def checkConnect(self, string: str, int: int) -> None: ...
    @typing.overload
    def checkConnect(self, string: str, int: int, object: typing.Any) -> None: ...
    def checkCreateClassLoader(self) -> None: ...
    def checkDelete(self, string: str) -> None: ...
    def checkExec(self, string: str) -> None: ...
    def checkExit(self, int: int) -> None: ...
    def checkLink(self, string: str) -> None: ...
    def checkListen(self, int: int) -> None: ...
    @typing.overload
    def checkMulticast(self, inetAddress: java.net.InetAddress) -> None: ...
    @typing.overload
    def checkMulticast(self, inetAddress: java.net.InetAddress, byte: int) -> None: ...
    def checkPackageAccess(self, string: str) -> None: ...
    def checkPackageDefinition(self, string: str) -> None: ...
    @typing.overload
    def checkPermission(self, permission: java.security.Permission) -> None: ...
    @typing.overload
    def checkPermission(self, permission: java.security.Permission, object: typing.Any) -> None: ...
    def checkPrintJobAccess(self) -> None: ...
    def checkPropertiesAccess(self) -> None: ...
    def checkPropertyAccess(self, string: str) -> None: ...
    @typing.overload
    def checkRead(self, fileDescriptor: java.io.FileDescriptor) -> None: ...
    @typing.overload
    def checkRead(self, string: str) -> None: ...
    @typing.overload
    def checkRead(self, string: str, object: typing.Any) -> None: ...
    def checkSecurityAccess(self, string: str) -> None: ...
    def checkSetFactory(self) -> None: ...
    @typing.overload
    def checkWrite(self, fileDescriptor: java.io.FileDescriptor) -> None: ...
    @typing.overload
    def checkWrite(self, string: str) -> None: ...
    def getSecurityContext(self) -> typing.Any: ...
    def getThreadGroup(self) -> 'ThreadGroup': ...

class StackTraceElement(java.io.Serializable):
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, string2: str, string3: str, string4: str, string5: str, string6: str, int: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getClassLoaderName(self) -> str: ...
    def getClassName(self) -> str: ...
    def getFileName(self) -> str: ...
    def getLineNumber(self) -> int: ...
    def getMethodName(self) -> str: ...
    def getModuleName(self) -> str: ...
    def getModuleVersion(self) -> str: ...
    def hashCode(self) -> int: ...
    def isNativeMethod(self) -> bool: ...
    def toString(self) -> str: ...

class StrictMath:
    E: typing.ClassVar[float] = ...
    PI: typing.ClassVar[float] = ...
    @staticmethod
    def IEEEremainder(double: float, double2: float) -> float: ...
    @typing.overload
    @staticmethod
    def abs(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def abs(float: float) -> float: ...
    @typing.overload
    @staticmethod
    def abs(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def abs(long: int) -> int: ...
    @staticmethod
    def acos(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def addExact(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def addExact(long: int, long2: int) -> int: ...
    @staticmethod
    def asin(double: float) -> float: ...
    @staticmethod
    def atan(double: float) -> float: ...
    @staticmethod
    def atan2(double: float, double2: float) -> float: ...
    @staticmethod
    def cbrt(double: float) -> float: ...
    @staticmethod
    def ceil(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def copySign(double: float, double2: float) -> float: ...
    @typing.overload
    @staticmethod
    def copySign(float: float, float2: float) -> float: ...
    @staticmethod
    def cos(double: float) -> float: ...
    @staticmethod
    def cosh(double: float) -> float: ...
    @staticmethod
    def exp(double: float) -> float: ...
    @staticmethod
    def expm1(double: float) -> float: ...
    @staticmethod
    def floor(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def floorDiv(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def floorDiv(long: int, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def floorDiv(long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def floorMod(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def floorMod(long: int, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def floorMod(long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def fma(double: float, double2: float, double3: float) -> float: ...
    @typing.overload
    @staticmethod
    def fma(float: float, float2: float, float3: float) -> float: ...
    @typing.overload
    @staticmethod
    def getExponent(double: float) -> int: ...
    @typing.overload
    @staticmethod
    def getExponent(float: float) -> int: ...
    @staticmethod
    def hypot(double: float, double2: float) -> float: ...
    @staticmethod
    def log(double: float) -> float: ...
    @staticmethod
    def log10(double: float) -> float: ...
    @staticmethod
    def log1p(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def max(double: float, double2: float) -> float: ...
    @typing.overload
    @staticmethod
    def max(float: float, float2: float) -> float: ...
    @typing.overload
    @staticmethod
    def max(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def max(long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def min(double: float, double2: float) -> float: ...
    @typing.overload
    @staticmethod
    def min(float: float, float2: float) -> float: ...
    @typing.overload
    @staticmethod
    def min(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def min(long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def multiplyExact(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def multiplyExact(long: int, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def multiplyExact(long: int, long2: int) -> int: ...
    @staticmethod
    def multiplyFull(int: int, int2: int) -> int: ...
    @staticmethod
    def multiplyHigh(long: int, long2: int) -> int: ...
    @typing.overload
    @staticmethod
    def nextAfter(double: float, double2: float) -> float: ...
    @typing.overload
    @staticmethod
    def nextAfter(float: float, double: float) -> float: ...
    @typing.overload
    @staticmethod
    def nextDown(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def nextDown(float: float) -> float: ...
    @typing.overload
    @staticmethod
    def nextUp(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def nextUp(float: float) -> float: ...
    @staticmethod
    def pow(double: float, double2: float) -> float: ...
    @staticmethod
    def random() -> float: ...
    @staticmethod
    def rint(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def round(float: float) -> int: ...
    @typing.overload
    @staticmethod
    def round(double: float) -> int: ...
    @typing.overload
    @staticmethod
    def scalb(double: float, int: int) -> float: ...
    @typing.overload
    @staticmethod
    def scalb(float: float, int: int) -> float: ...
    @typing.overload
    @staticmethod
    def signum(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def signum(float: float) -> float: ...
    @staticmethod
    def sin(double: float) -> float: ...
    @staticmethod
    def sinh(double: float) -> float: ...
    @staticmethod
    def sqrt(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def subtractExact(int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def subtractExact(long: int, long2: int) -> int: ...
    @staticmethod
    def tan(double: float) -> float: ...
    @staticmethod
    def tanh(double: float) -> float: ...
    @staticmethod
    def toDegrees(double: float) -> float: ...
    @staticmethod
    def toIntExact(long: int) -> int: ...
    @staticmethod
    def toRadians(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def ulp(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def ulp(float: float) -> float: ...

class SuppressWarnings(java.lang.annotation.Annotation):
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...
    def value(self) -> typing.List[str]: ...

_ThreadLocal__T = typing.TypeVar('_ThreadLocal__T')  # <T>
class ThreadLocal(typing.Generic[_ThreadLocal__T]):
    def __init__(self): ...
    def get(self) -> _ThreadLocal__T: ...
    def remove(self) -> None: ...
    def set(self, t: _ThreadLocal__T) -> None: ...
    _withInitial__S = typing.TypeVar('_withInitial__S')  # <S>
    @staticmethod
    def withInitial(supplier: typing.Union[java.util.function.Supplier[_withInitial__S], typing.Callable[[], _withInitial__S]]) -> 'ThreadLocal'[_withInitial__S]: ...

class Throwable(java.io.Serializable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: 'Throwable'): ...
    @typing.overload
    def __init__(self, throwable: 'Throwable'): ...
    def addSuppressed(self, throwable: 'Throwable') -> None: ...
    def fillInStackTrace(self) -> 'Throwable': ...
    def getCause(self) -> 'Throwable': ...
    def getLocalizedMessage(self) -> str: ...
    def getMessage(self) -> str: ...
    def getStackTrace(self) -> typing.List[StackTraceElement]: ...
    def getSuppressed(self) -> typing.List['Throwable']: ...
    def initCause(self, throwable: 'Throwable') -> 'Throwable': ...
    @typing.overload
    def printStackTrace(self) -> None: ...
    @typing.overload
    def printStackTrace(self, printStream: java.io.PrintStream) -> None: ...
    @typing.overload
    def printStackTrace(self, printWriter: java.io.PrintWriter) -> None: ...
    def setStackTrace(self, stackTraceElementArray: typing.List[StackTraceElement]) -> None: ...
    def toString(self) -> str: ...

class Void:
    TYPE: typing.ClassVar[typing.Type] = ...

class Boolean(java.io.Serializable, Comparable[bool]):
    TRUE: typing.ClassVar[bool] = ...
    FALSE: typing.ClassVar[bool] = ...
    TYPE: typing.ClassVar[typing.Type] = ...
    @typing.overload
    def __init__(self, boolean: bool): ...
    @typing.overload
    def __init__(self, string: str): ...
    def booleanValue(self) -> bool: ...
    @staticmethod
    def compare(boolean: bool, boolean2: bool) -> int: ...
    def compareTo(self, boolean: bool) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    @staticmethod
    def getBoolean(string: str) -> bool: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    @staticmethod
    def hashCode(boolean: bool) -> int: ...
    @staticmethod
    def logicalAnd(boolean: bool, boolean2: bool) -> bool: ...
    @staticmethod
    def logicalOr(boolean: bool, boolean2: bool) -> bool: ...
    @staticmethod
    def logicalXor(boolean: bool, boolean2: bool) -> bool: ...
    @staticmethod
    def parseBoolean(string: str) -> bool: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def toString(boolean: bool) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(boolean: bool) -> bool: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> bool: ...

class Byte(Number, Comparable[int]):
    MIN_VALUE: typing.ClassVar[int] = ...
    MAX_VALUE: typing.ClassVar[int] = ...
    TYPE: typing.ClassVar[typing.Type] = ...
    SIZE: typing.ClassVar[int] = ...
    BYTES: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, byte: int): ...
    @typing.overload
    def __init__(self, string: str): ...
    def byteValue(self) -> int: ...
    @staticmethod
    def compare(byte: int, byte2: int) -> int: ...
    def compareTo(self, byte: int) -> int: ...
    @staticmethod
    def compareUnsigned(byte: int, byte2: int) -> int: ...
    @staticmethod
    def decode(string: str) -> int: ...
    def doubleValue(self) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def floatValue(self) -> float: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    @staticmethod
    def hashCode(byte: int) -> int: ...
    def intValue(self) -> int: ...
    def longValue(self) -> int: ...
    @typing.overload
    @staticmethod
    def parseByte(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def parseByte(string: str, int: int) -> int: ...
    def shortValue(self) -> int: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def toString(byte: int) -> str: ...
    @staticmethod
    def toUnsignedInt(byte: int) -> int: ...
    @staticmethod
    def toUnsignedLong(byte: int) -> int: ...
    @typing.overload
    @staticmethod
    def valueOf(byte: int) -> int: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str, int: int) -> int: ...

class Double(Number, Comparable[float]):
    POSITIVE_INFINITY: typing.ClassVar[float] = ...
    NEGATIVE_INFINITY: typing.ClassVar[float] = ...
    NaN: typing.ClassVar[float] = ...
    MAX_VALUE: typing.ClassVar[float] = ...
    MIN_NORMAL: typing.ClassVar[float] = ...
    MIN_VALUE: typing.ClassVar[float] = ...
    MAX_EXPONENT: typing.ClassVar[int] = ...
    MIN_EXPONENT: typing.ClassVar[int] = ...
    SIZE: typing.ClassVar[int] = ...
    BYTES: typing.ClassVar[int] = ...
    TYPE: typing.ClassVar[typing.Type] = ...
    @typing.overload
    def __init__(self, double: float): ...
    @typing.overload
    def __init__(self, string: str): ...
    def byteValue(self) -> int: ...
    @staticmethod
    def compare(double: float, double2: float) -> int: ...
    def compareTo(self, double: float) -> int: ...
    @staticmethod
    def doubleToLongBits(double: float) -> int: ...
    @staticmethod
    def doubleToRawLongBits(double: float) -> int: ...
    def doubleValue(self) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def floatValue(self) -> float: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    @staticmethod
    def hashCode(double: float) -> int: ...
    def intValue(self) -> int: ...
    @staticmethod
    def isFinite(double: float) -> bool: ...
    @typing.overload
    def isInfinite(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isInfinite(double: float) -> bool: ...
    @typing.overload
    def isNaN(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isNaN(double: float) -> bool: ...
    @staticmethod
    def longBitsToDouble(long: int) -> float: ...
    def longValue(self) -> int: ...
    @staticmethod
    def max(double: float, double2: float) -> float: ...
    @staticmethod
    def min(double: float, double2: float) -> float: ...
    @staticmethod
    def parseDouble(string: str) -> float: ...
    def shortValue(self) -> int: ...
    @staticmethod
    def sum(double: float, double2: float) -> float: ...
    @staticmethod
    def toHexString(double: float) -> str: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def toString(double: float) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(double: float) -> float: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> float: ...

_Enum__E = typing.TypeVar('_Enum__E', bound='Enum')  # <E>
class Enum(Comparable[_Enum__E], java.io.Serializable, typing.Generic[_Enum__E]):
    def compareTo(self, e: _Enum__E) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getDeclaringClass(self) -> typing.Type[_Enum__E]: ...
    def hashCode(self) -> int: ...
    def name(self) -> str: ...
    def ordinal(self) -> int: ...
    def toString(self) -> str: ...
    _valueOf__T = typing.TypeVar('_valueOf__T', bound='Enum')  # <T>
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf__T], string: str) -> _valueOf__T: ...

class Error(Throwable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class Exception(Throwable):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class Float(Number, Comparable[float]):
    POSITIVE_INFINITY: typing.ClassVar[float] = ...
    NEGATIVE_INFINITY: typing.ClassVar[float] = ...
    NaN: typing.ClassVar[float] = ...
    MAX_VALUE: typing.ClassVar[float] = ...
    MIN_NORMAL: typing.ClassVar[float] = ...
    MIN_VALUE: typing.ClassVar[float] = ...
    MAX_EXPONENT: typing.ClassVar[int] = ...
    MIN_EXPONENT: typing.ClassVar[int] = ...
    SIZE: typing.ClassVar[int] = ...
    BYTES: typing.ClassVar[int] = ...
    TYPE: typing.ClassVar[typing.Type] = ...
    @typing.overload
    def __init__(self, double: float): ...
    @typing.overload
    def __init__(self, float: float): ...
    @typing.overload
    def __init__(self, string: str): ...
    def byteValue(self) -> int: ...
    @staticmethod
    def compare(float: float, float2: float) -> int: ...
    def compareTo(self, float: float) -> int: ...
    def doubleValue(self) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    @staticmethod
    def floatToIntBits(float: float) -> int: ...
    @staticmethod
    def floatToRawIntBits(float: float) -> int: ...
    def floatValue(self) -> float: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    @staticmethod
    def hashCode(float: float) -> int: ...
    @staticmethod
    def intBitsToFloat(int: int) -> float: ...
    def intValue(self) -> int: ...
    @staticmethod
    def isFinite(float: float) -> bool: ...
    @typing.overload
    def isInfinite(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isInfinite(float: float) -> bool: ...
    @typing.overload
    def isNaN(self) -> bool: ...
    @typing.overload
    @staticmethod
    def isNaN(float: float) -> bool: ...
    def longValue(self) -> int: ...
    @staticmethod
    def max(float: float, float2: float) -> float: ...
    @staticmethod
    def min(float: float, float2: float) -> float: ...
    @staticmethod
    def parseFloat(string: str) -> float: ...
    def shortValue(self) -> int: ...
    @staticmethod
    def sum(float: float, float2: float) -> float: ...
    @staticmethod
    def toHexString(float: float) -> str: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def toString(float: float) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(float: float) -> float: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> float: ...

_InheritableThreadLocal__T = typing.TypeVar('_InheritableThreadLocal__T')  # <T>
class InheritableThreadLocal(ThreadLocal[_InheritableThreadLocal__T], typing.Generic[_InheritableThreadLocal__T]):
    def __init__(self): ...

class Integer(Number, Comparable[int]):
    MIN_VALUE: typing.ClassVar[int] = ...
    MAX_VALUE: typing.ClassVar[int] = ...
    TYPE: typing.ClassVar[typing.Type] = ...
    SIZE: typing.ClassVar[int] = ...
    BYTES: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, string: str): ...
    @staticmethod
    def bitCount(int: int) -> int: ...
    def byteValue(self) -> int: ...
    @staticmethod
    def compare(int: int, int2: int) -> int: ...
    def compareTo(self, integer: int) -> int: ...
    @staticmethod
    def compareUnsigned(int: int, int2: int) -> int: ...
    @staticmethod
    def decode(string: str) -> int: ...
    @staticmethod
    def divideUnsigned(int: int, int2: int) -> int: ...
    def doubleValue(self) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def floatValue(self) -> float: ...
    @typing.overload
    @staticmethod
    def getInteger(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def getInteger(string: str, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def getInteger(string: str, integer: int) -> int: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    @staticmethod
    def hashCode(int: int) -> int: ...
    @staticmethod
    def highestOneBit(int: int) -> int: ...
    def intValue(self) -> int: ...
    def longValue(self) -> int: ...
    @staticmethod
    def lowestOneBit(int: int) -> int: ...
    @staticmethod
    def max(int: int, int2: int) -> int: ...
    @staticmethod
    def min(int: int, int2: int) -> int: ...
    @staticmethod
    def numberOfLeadingZeros(int: int) -> int: ...
    @staticmethod
    def numberOfTrailingZeros(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def parseInt(charSequence: typing.Union[CharSequence, str], int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    @staticmethod
    def parseInt(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def parseInt(string: str, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def parseUnsignedInt(charSequence: typing.Union[CharSequence, str], int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    @staticmethod
    def parseUnsignedInt(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def parseUnsignedInt(string: str, int: int) -> int: ...
    @staticmethod
    def remainderUnsigned(int: int, int2: int) -> int: ...
    @staticmethod
    def reverse(int: int) -> int: ...
    @staticmethod
    def reverseBytes(int: int) -> int: ...
    @staticmethod
    def rotateLeft(int: int, int2: int) -> int: ...
    @staticmethod
    def rotateRight(int: int, int2: int) -> int: ...
    def shortValue(self) -> int: ...
    @staticmethod
    def signum(int: int) -> int: ...
    @staticmethod
    def sum(int: int, int2: int) -> int: ...
    @staticmethod
    def toBinaryString(int: int) -> str: ...
    @staticmethod
    def toHexString(int: int) -> str: ...
    @staticmethod
    def toOctalString(int: int) -> str: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def toString(int: int) -> str: ...
    @typing.overload
    @staticmethod
    def toString(int: int, int2: int) -> str: ...
    @staticmethod
    def toUnsignedLong(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def toUnsignedString(int: int) -> str: ...
    @typing.overload
    @staticmethod
    def toUnsignedString(int: int, int2: int) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str, int: int) -> int: ...

class Long(Number, Comparable[int]):
    MIN_VALUE: typing.ClassVar[int] = ...
    MAX_VALUE: typing.ClassVar[int] = ...
    TYPE: typing.ClassVar[typing.Type] = ...
    SIZE: typing.ClassVar[int] = ...
    BYTES: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, long: int): ...
    @staticmethod
    def bitCount(long: int) -> int: ...
    def byteValue(self) -> int: ...
    @staticmethod
    def compare(long: int, long2: int) -> int: ...
    def compareTo(self, long: int) -> int: ...
    @staticmethod
    def compareUnsigned(long: int, long2: int) -> int: ...
    @staticmethod
    def decode(string: str) -> int: ...
    @staticmethod
    def divideUnsigned(long: int, long2: int) -> int: ...
    def doubleValue(self) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def floatValue(self) -> float: ...
    @typing.overload
    @staticmethod
    def getLong(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def getLong(string: str, long: int) -> int: ...
    @typing.overload
    @staticmethod
    def getLong(string: str, long: int) -> int: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    @staticmethod
    def hashCode(long: int) -> int: ...
    @staticmethod
    def highestOneBit(long: int) -> int: ...
    def intValue(self) -> int: ...
    def longValue(self) -> int: ...
    @staticmethod
    def lowestOneBit(long: int) -> int: ...
    @staticmethod
    def max(long: int, long2: int) -> int: ...
    @staticmethod
    def min(long: int, long2: int) -> int: ...
    @staticmethod
    def numberOfLeadingZeros(long: int) -> int: ...
    @staticmethod
    def numberOfTrailingZeros(long: int) -> int: ...
    @typing.overload
    @staticmethod
    def parseLong(charSequence: typing.Union[CharSequence, str], int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    @staticmethod
    def parseLong(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def parseLong(string: str, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def parseUnsignedLong(charSequence: typing.Union[CharSequence, str], int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    @staticmethod
    def parseUnsignedLong(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def parseUnsignedLong(string: str, int: int) -> int: ...
    @staticmethod
    def remainderUnsigned(long: int, long2: int) -> int: ...
    @staticmethod
    def reverse(long: int) -> int: ...
    @staticmethod
    def reverseBytes(long: int) -> int: ...
    @staticmethod
    def rotateLeft(long: int, int: int) -> int: ...
    @staticmethod
    def rotateRight(long: int, int: int) -> int: ...
    def shortValue(self) -> int: ...
    @staticmethod
    def signum(long: int) -> int: ...
    @staticmethod
    def sum(long: int, long2: int) -> int: ...
    @staticmethod
    def toBinaryString(long: int) -> str: ...
    @staticmethod
    def toHexString(long: int) -> str: ...
    @staticmethod
    def toOctalString(long: int) -> str: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def toString(long: int) -> str: ...
    @typing.overload
    @staticmethod
    def toString(long: int, int: int) -> str: ...
    @typing.overload
    @staticmethod
    def toUnsignedString(long: int) -> str: ...
    @typing.overload
    @staticmethod
    def toUnsignedString(long: int, int: int) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def valueOf(long: int) -> int: ...

class ProcessHandle(Comparable['ProcessHandle']):
    @staticmethod
    def allProcesses() -> java.util.stream.Stream['ProcessHandle']: ...
    def children(self) -> java.util.stream.Stream['ProcessHandle']: ...
    def compareTo(self, processHandle: 'ProcessHandle') -> int: ...
    @staticmethod
    def current() -> 'ProcessHandle': ...
    def descendants(self) -> java.util.stream.Stream['ProcessHandle']: ...
    def destroy(self) -> bool: ...
    def destroyForcibly(self) -> bool: ...
    def equals(self, object: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def info(self) -> 'ProcessHandle.Info': ...
    def isAlive(self) -> bool: ...
    @staticmethod
    def of(long: int) -> java.util.Optional['ProcessHandle']: ...
    def onExit(self) -> java.util.concurrent.CompletableFuture['ProcessHandle']: ...
    def parent(self) -> java.util.Optional['ProcessHandle']: ...
    def pid(self) -> int: ...
    def supportsNormalTermination(self) -> bool: ...
    class Info:
        def arguments(self) -> java.util.Optional[typing.List[str]]: ...
        def command(self) -> java.util.Optional[str]: ...
        def commandLine(self) -> java.util.Optional[str]: ...
        def startInstant(self) -> java.util.Optional[java.time.Instant]: ...
        def totalCpuDuration(self) -> java.util.Optional[java.time.Duration]: ...
        def user(self) -> java.util.Optional[str]: ...

class Runtime(_JRuntime):
    def availableProcessors(self) -> int: ...
    def exit(self, int: int) -> None: ...
    def freeMemory(self) -> int: ...
    def gc(self) -> None: ...
    @staticmethod
    def getRuntime() -> 'Runtime': ...
    def halt(self, int: int) -> None: ...
    def load(self, string: str) -> None: ...
    def loadLibrary(self, string: str) -> None: ...
    def maxMemory(self) -> int: ...
    def runFinalization(self) -> None: ...
    def totalMemory(self) -> int: ...
    def traceInstructions(self, boolean: bool) -> None: ...
    def traceMethodCalls(self, boolean: bool) -> None: ...
    @staticmethod
    def version() -> 'Runtime.Version': ...
    class Version(Comparable['Runtime.Version']):
        def build(self) -> java.util.Optional[int]: ...
        def compareTo(self, version: 'Runtime.Version') -> int: ...
        def compareToIgnoreOptional(self, version: 'Runtime.Version') -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
        def equalsIgnoreOptional(self, object: typing.Any) -> bool: ...
        def feature(self) -> int: ...
        def hashCode(self) -> int: ...
        def interim(self) -> int: ...
        def major(self) -> int: ...
        def minor(self) -> int: ...
        def optional(self) -> java.util.Optional[str]: ...
        @staticmethod
        def parse(string: str) -> 'Runtime.Version': ...
        def patch(self) -> int: ...
        def pre(self) -> java.util.Optional[str]: ...
        def security(self) -> int: ...
        def toString(self) -> str: ...
        def update(self) -> int: ...
        def version(self) -> java.util.List[int]: ...

class Short(Number, Comparable[int]):
    MIN_VALUE: typing.ClassVar[int] = ...
    MAX_VALUE: typing.ClassVar[int] = ...
    TYPE: typing.ClassVar[typing.Type] = ...
    SIZE: typing.ClassVar[int] = ...
    BYTES: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, short: int): ...
    def byteValue(self) -> int: ...
    @staticmethod
    def compare(short: int, short2: int) -> int: ...
    def compareTo(self, short: int) -> int: ...
    @staticmethod
    def compareUnsigned(short: int, short2: int) -> int: ...
    @staticmethod
    def decode(string: str) -> int: ...
    def doubleValue(self) -> float: ...
    def equals(self, object: typing.Any) -> bool: ...
    def floatValue(self) -> float: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    @staticmethod
    def hashCode(short: int) -> int: ...
    def intValue(self) -> int: ...
    def longValue(self) -> int: ...
    @typing.overload
    @staticmethod
    def parseShort(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def parseShort(string: str, int: int) -> int: ...
    @staticmethod
    def reverseBytes(short: int) -> int: ...
    def shortValue(self) -> int: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def toString(short: int) -> str: ...
    @staticmethod
    def toUnsignedInt(short: int) -> int: ...
    @staticmethod
    def toUnsignedLong(short: int) -> int: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> int: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def valueOf(short: int) -> int: ...

class String(java.io.Serializable, Comparable[str], CharSequence, _JStringProto):
    CASE_INSENSITIVE_ORDER: typing.ClassVar[java.util.Comparator] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int]): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int, int2: int): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int, int2: int, int3: int): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int, int2: int, string: str): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int, int2: int, charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], string: str): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, charArray: typing.List[str]): ...
    @typing.overload
    def __init__(self, charArray: typing.List[str], int: int, int2: int): ...
    @typing.overload
    def __init__(self, intArray: typing.List[int], int2: int, int3: int): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, stringBuffer: 'StringBuffer'): ...
    @typing.overload
    def __init__(self, stringBuilder: 'StringBuilder'): ...
    def charAt(self, int: int) -> str: ...
    def chars(self) -> java.util.stream.IntStream: ...
    def codePointAt(self, int: int) -> int: ...
    def codePointBefore(self, int: int) -> int: ...
    def codePointCount(self, int: int, int2: int) -> int: ...
    def codePoints(self) -> java.util.stream.IntStream: ...
    def compareTo(self, string: str) -> int: ...
    def compareToIgnoreCase(self, string: str) -> int: ...
    def concat(self, string: str) -> str: ...
    def contains(self, charSequence: typing.Union[CharSequence, str]) -> bool: ...
    @typing.overload
    def contentEquals(self, charSequence: typing.Union[CharSequence, str]) -> bool: ...
    @typing.overload
    def contentEquals(self, stringBuffer: 'StringBuffer') -> bool: ...
    @typing.overload
    @staticmethod
    def copyValueOf(charArray: typing.List[str]) -> str: ...
    @typing.overload
    @staticmethod
    def copyValueOf(charArray: typing.List[str], int: int, int2: int) -> str: ...
    def endsWith(self, string: str) -> bool: ...
    def equals(self, object: typing.Any) -> bool: ...
    def equalsIgnoreCase(self, string: str) -> bool: ...
    @typing.overload
    @staticmethod
    def format(string: str, objectArray: typing.List[typing.Any]) -> str: ...
    @typing.overload
    @staticmethod
    def format(locale: java.util.Locale, string: str, objectArray: typing.List[typing.Any]) -> str: ...
    @typing.overload
    def getBytes(self) -> typing.List[int]: ...
    @typing.overload
    def getBytes(self, string: str) -> typing.List[int]: ...
    @typing.overload
    def getBytes(self, charset: java.nio.charset.Charset) -> typing.List[int]: ...
    @typing.overload
    def getBytes(self, int: int, int2: int, byteArray: typing.List[int], int3: int) -> None: ...
    def getChars(self, int: int, int2: int, charArray: typing.List[str], int3: int) -> None: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def indexOf(self, int: int) -> int: ...
    @typing.overload
    def indexOf(self, int: int, int2: int) -> int: ...
    @typing.overload
    def indexOf(self, string: str) -> int: ...
    @typing.overload
    def indexOf(self, string: str, int: int) -> int: ...
    def intern(self) -> str: ...
    def isBlank(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    @typing.overload
    @staticmethod
    def join(charSequence: typing.Union[CharSequence, str], charSequenceArray: typing.List[CharSequence]) -> str: ...
    @typing.overload
    @staticmethod
    def join(charSequence: typing.Union[CharSequence, str], iterable: typing.Union[Iterable[CharSequence], typing.Sequence[CharSequence], typing.Set[CharSequence]]) -> str: ...
    @typing.overload
    def lastIndexOf(self, int: int) -> int: ...
    @typing.overload
    def lastIndexOf(self, int: int, int2: int) -> int: ...
    @typing.overload
    def lastIndexOf(self, string: str) -> int: ...
    @typing.overload
    def lastIndexOf(self, string: str, int: int) -> int: ...
    def length(self) -> int: ...
    def lines(self) -> java.util.stream.Stream[str]: ...
    def matches(self, string: str) -> bool: ...
    def offsetByCodePoints(self, int: int, int2: int) -> int: ...
    @typing.overload
    def regionMatches(self, boolean: bool, int: int, string: str, int2: int, int3: int) -> bool: ...
    @typing.overload
    def regionMatches(self, int: int, string: str, int2: int, int3: int) -> bool: ...
    def repeat(self, int: int) -> str: ...
    @typing.overload
    def replace(self, char: str, char2: str) -> str: ...
    @typing.overload
    def replace(self, charSequence: typing.Union[CharSequence, str], charSequence2: typing.Union[CharSequence, str]) -> str: ...
    def replaceAll(self, string: str, string2: str) -> str: ...
    def replaceFirst(self, string: str, string2: str) -> str: ...
    @typing.overload
    def split(self, string: str) -> typing.List[str]: ...
    @typing.overload
    def split(self, string: str, int: int) -> typing.List[str]: ...
    @typing.overload
    def startsWith(self, string: str) -> bool: ...
    @typing.overload
    def startsWith(self, string: str, int: int) -> bool: ...
    def strip(self) -> str: ...
    def stripLeading(self) -> str: ...
    def stripTrailing(self) -> str: ...
    def subSequence(self, int: int, int2: int) -> CharSequence: ...
    @typing.overload
    def substring(self, int: int) -> str: ...
    @typing.overload
    def substring(self, int: int, int2: int) -> str: ...
    def toCharArray(self) -> typing.List[str]: ...
    @typing.overload
    def toLowerCase(self) -> str: ...
    @typing.overload
    def toLowerCase(self, locale: java.util.Locale) -> str: ...
    def toString(self) -> str: ...
    @typing.overload
    def toUpperCase(self) -> str: ...
    @typing.overload
    def toUpperCase(self, locale: java.util.Locale) -> str: ...
    def trim(self) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(boolean: bool) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(char: str) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(charArray: typing.List[str]) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(charArray: typing.List[str], int: int, int2: int) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(double: float) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(float: float) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(int: int) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(object: typing.Any) -> str: ...
    @typing.overload
    @staticmethod
    def valueOf(long: int) -> str: ...

class AssertionError(Error):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, boolean: bool): ...
    @typing.overload
    def __init__(self, char: str): ...
    @typing.overload
    def __init__(self, double: float): ...
    @typing.overload
    def __init__(self, float: float): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, object: typing.Any): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, long: int): ...

class CloneNotSupportedException(Exception):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class InterruptedException(Exception):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class LinkageError(Error):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...

class ProcessBuilder:
    @typing.overload
    def __init__(self, stringArray: typing.List[str]): ...
    @typing.overload
    def __init__(self, list: java.util.List[str]): ...
    @typing.overload
    def command(self, stringArray: typing.List[str]) -> 'ProcessBuilder': ...
    @typing.overload
    def command(self, list: java.util.List[str]) -> 'ProcessBuilder': ...
    @typing.overload
    def command(self) -> java.util.List[str]: ...
    @typing.overload
    def directory(self) -> java.io.File: ...
    @typing.overload
    def directory(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> 'ProcessBuilder': ...
    def environment(self) -> java.util.Map[str, str]: ...
    def inheritIO(self) -> 'ProcessBuilder': ...
    @typing.overload
    def redirectError(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> 'ProcessBuilder': ...
    @typing.overload
    def redirectError(self, redirect: 'ProcessBuilder.Redirect') -> 'ProcessBuilder': ...
    @typing.overload
    def redirectError(self) -> 'ProcessBuilder.Redirect': ...
    @typing.overload
    def redirectErrorStream(self) -> bool: ...
    @typing.overload
    def redirectErrorStream(self, boolean: bool) -> 'ProcessBuilder': ...
    @typing.overload
    def redirectInput(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> 'ProcessBuilder': ...
    @typing.overload
    def redirectInput(self, redirect: 'ProcessBuilder.Redirect') -> 'ProcessBuilder': ...
    @typing.overload
    def redirectInput(self) -> 'ProcessBuilder.Redirect': ...
    @typing.overload
    def redirectOutput(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> 'ProcessBuilder': ...
    @typing.overload
    def redirectOutput(self, redirect: 'ProcessBuilder.Redirect') -> 'ProcessBuilder': ...
    @typing.overload
    def redirectOutput(self) -> 'ProcessBuilder.Redirect': ...
    def start(self) -> Process: ...
    @staticmethod
    def startPipeline(list: java.util.List['ProcessBuilder']) -> java.util.List[Process]: ...
    class Redirect:
        PIPE: typing.ClassVar['ProcessBuilder.Redirect'] = ...
        INHERIT: typing.ClassVar['ProcessBuilder.Redirect'] = ...
        DISCARD: typing.ClassVar['ProcessBuilder.Redirect'] = ...
        @staticmethod
        def appendTo(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> 'ProcessBuilder.Redirect': ...
        def equals(self, object: typing.Any) -> bool: ...
        def file(self) -> java.io.File: ...
        def hashCode(self) -> int: ...
        @staticmethod
        def to(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> 'ProcessBuilder.Redirect': ...
        def type(self) -> 'ProcessBuilder.Redirect.Type': ...
        class Type(Enum['ProcessBuilder.Redirect.Type']):
            PIPE: typing.ClassVar['ProcessBuilder.Redirect.Type'] = ...
            INHERIT: typing.ClassVar['ProcessBuilder.Redirect.Type'] = ...
            READ: typing.ClassVar['ProcessBuilder.Redirect.Type'] = ...
            WRITE: typing.ClassVar['ProcessBuilder.Redirect.Type'] = ...
            APPEND: typing.ClassVar['ProcessBuilder.Redirect.Type'] = ...
            _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=Enum)  # <T>
            @typing.overload
            @staticmethod
            def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
            @typing.overload
            @staticmethod
            def valueOf(string: str) -> 'ProcessBuilder.Redirect.Type': ...
            @staticmethod
            def values() -> typing.List['ProcessBuilder.Redirect.Type']: ...

class ReflectiveOperationException(Exception):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class RuntimeException(Exception):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class StackWalker:
    def forEach(self, consumer: typing.Union[java.util.function.Consumer['StackWalker.StackFrame'], typing.Callable[['StackWalker.StackFrame'], None]]) -> None: ...
    def getCallerClass(self) -> typing.Type[typing.Any]: ...
    @typing.overload
    @staticmethod
    def getInstance() -> 'StackWalker': ...
    @typing.overload
    @staticmethod
    def getInstance(option: 'StackWalker.Option') -> 'StackWalker': ...
    @typing.overload
    @staticmethod
    def getInstance(set: java.util.Set['StackWalker.Option']) -> 'StackWalker': ...
    @typing.overload
    @staticmethod
    def getInstance(set: java.util.Set['StackWalker.Option'], int: int) -> 'StackWalker': ...
    _walk__T = typing.TypeVar('_walk__T')  # <T>
    def walk(self, function: typing.Union[java.util.function.Function[java.util.stream.Stream['StackWalker.StackFrame'], _walk__T], typing.Callable[[java.util.stream.Stream['StackWalker.StackFrame']], _walk__T]]) -> _walk__T: ...
    class Option(Enum['StackWalker.Option']):
        RETAIN_CLASS_REFERENCE: typing.ClassVar['StackWalker.Option'] = ...
        SHOW_REFLECT_FRAMES: typing.ClassVar['StackWalker.Option'] = ...
        SHOW_HIDDEN_FRAMES: typing.ClassVar['StackWalker.Option'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'StackWalker.Option': ...
        @staticmethod
        def values() -> typing.List['StackWalker.Option']: ...
    class StackFrame:
        def getByteCodeIndex(self) -> int: ...
        def getClassName(self) -> str: ...
        def getDeclaringClass(self) -> typing.Type[typing.Any]: ...
        def getDescriptor(self) -> str: ...
        def getFileName(self) -> str: ...
        def getLineNumber(self) -> int: ...
        def getMethodName(self) -> str: ...
        def getMethodType(self) -> java.lang.invoke.MethodType: ...
        def isNativeMethod(self) -> bool: ...
        def toStackTraceElement(self) -> StackTraceElement: ...

class System:
    in_: typing.ClassVar[java.io.InputStream] = ...
    out: typing.ClassVar[java.io.PrintStream] = ...
    err: typing.ClassVar[java.io.PrintStream] = ...
    @staticmethod
    def arraycopy(object: typing.Any, int: int, object2: typing.Any, int2: int, int3: int) -> None: ...
    @staticmethod
    def clearProperty(string: str) -> str: ...
    @staticmethod
    def console() -> java.io.Console: ...
    @staticmethod
    def currentTimeMillis() -> int: ...
    @staticmethod
    def exit(int: int) -> None: ...
    @staticmethod
    def gc() -> None: ...
    @typing.overload
    @staticmethod
    def getLogger(string: str) -> 'System.Logger': ...
    @typing.overload
    @staticmethod
    def getLogger(string: str, resourceBundle: java.util.ResourceBundle) -> 'System.Logger': ...
    @staticmethod
    def getProperties() -> java.util.Properties: ...
    @typing.overload
    @staticmethod
    def getProperty(string: str) -> str: ...
    @typing.overload
    @staticmethod
    def getProperty(string: str, string2: str) -> str: ...
    @staticmethod
    def getSecurityManager() -> SecurityManager: ...
    @typing.overload
    @staticmethod
    def getenv(string: str) -> str: ...
    @typing.overload
    @staticmethod
    def getenv() -> java.util.Map[str, str]: ...
    @staticmethod
    def identityHashCode(object: typing.Any) -> int: ...
    @staticmethod
    def inheritedChannel() -> java.nio.channels.Channel: ...
    @staticmethod
    def lineSeparator() -> str: ...
    @staticmethod
    def load(string: str) -> None: ...
    @staticmethod
    def loadLibrary(string: str) -> None: ...
    @staticmethod
    def mapLibraryName(string: str) -> str: ...
    @staticmethod
    def nanoTime() -> int: ...
    @staticmethod
    def runFinalization() -> None: ...
    @staticmethod
    def setErr(printStream: java.io.PrintStream) -> None: ...
    @staticmethod
    def setIn(inputStream: java.io.InputStream) -> None: ...
    @staticmethod
    def setOut(printStream: java.io.PrintStream) -> None: ...
    @staticmethod
    def setProperties(properties: java.util.Properties) -> None: ...
    @staticmethod
    def setProperty(string: str, string2: str) -> str: ...
    @staticmethod
    def setSecurityManager(securityManager: SecurityManager) -> None: ...
    class Logger:
        def getName(self) -> str: ...
        def isLoggable(self, level: 'System.Logger.Level') -> bool: ...
        @typing.overload
        def log(self, level: 'System.Logger.Level', resourceBundle: java.util.ResourceBundle, string: str, objectArray: typing.List[typing.Any]) -> None: ...
        @typing.overload
        def log(self, level: 'System.Logger.Level', resourceBundle: java.util.ResourceBundle, string: str, throwable: Throwable) -> None: ...
        @typing.overload
        def log(self, level: 'System.Logger.Level', object: typing.Any) -> None: ...
        @typing.overload
        def log(self, level: 'System.Logger.Level', string: str) -> None: ...
        @typing.overload
        def log(self, level: 'System.Logger.Level', string: str, objectArray: typing.List[typing.Any]) -> None: ...
        @typing.overload
        def log(self, level: 'System.Logger.Level', string: str, throwable: Throwable) -> None: ...
        @typing.overload
        def log(self, level: 'System.Logger.Level', supplier: typing.Union[java.util.function.Supplier[str], typing.Callable[[], str]]) -> None: ...
        @typing.overload
        def log(self, level: 'System.Logger.Level', supplier: typing.Union[java.util.function.Supplier[str], typing.Callable[[], str]], throwable: Throwable) -> None: ...
        class Level(Enum['System.Logger.Level']):
            ALL: typing.ClassVar['System.Logger.Level'] = ...
            TRACE: typing.ClassVar['System.Logger.Level'] = ...
            DEBUG: typing.ClassVar['System.Logger.Level'] = ...
            INFO: typing.ClassVar['System.Logger.Level'] = ...
            WARNING: typing.ClassVar['System.Logger.Level'] = ...
            ERROR: typing.ClassVar['System.Logger.Level'] = ...
            OFF: typing.ClassVar['System.Logger.Level'] = ...
            def getName(self) -> str: ...
            def getSeverity(self) -> int: ...
            _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=Enum)  # <T>
            @typing.overload
            @staticmethod
            def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
            @typing.overload
            @staticmethod
            def valueOf(string: str) -> 'System.Logger.Level': ...
            @staticmethod
            def values() -> typing.List['System.Logger.Level']: ...
    class LoggerFinder:
        def getLocalizedLogger(self, string: str, resourceBundle: java.util.ResourceBundle, module: Module) -> 'System.Logger': ...
        def getLogger(self, string: str, module: Module) -> 'System.Logger': ...
        @staticmethod
        def getLoggerFinder() -> 'System.LoggerFinder': ...

class Thread(Runnable, _JThread):
    MIN_PRIORITY: typing.ClassVar[int] = ...
    NORM_PRIORITY: typing.ClassVar[int] = ...
    MAX_PRIORITY: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, runnable: typing.Union[Runnable, typing.Callable]): ...
    @typing.overload
    def __init__(self, runnable: typing.Union[Runnable, typing.Callable], string: str): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, threadGroup: 'ThreadGroup', runnable: typing.Union[Runnable, typing.Callable]): ...
    @typing.overload
    def __init__(self, threadGroup: 'ThreadGroup', runnable: typing.Union[Runnable, typing.Callable], string: str): ...
    @typing.overload
    def __init__(self, threadGroup: 'ThreadGroup', runnable: typing.Union[Runnable, typing.Callable], string: str, long: int): ...
    @typing.overload
    def __init__(self, threadGroup: 'ThreadGroup', runnable: typing.Union[Runnable, typing.Callable], string: str, long: int, boolean: bool): ...
    @typing.overload
    def __init__(self, threadGroup: 'ThreadGroup', string: str): ...
    @staticmethod
    def activeCount() -> int: ...
    def checkAccess(self) -> None: ...
    def countStackFrames(self) -> int: ...
    @staticmethod
    def currentThread() -> 'Thread': ...
    @staticmethod
    def dumpStack() -> None: ...
    @staticmethod
    def enumerate(threadArray: typing.List['Thread']) -> int: ...
    @staticmethod
    def getAllStackTraces() -> java.util.Map['Thread', typing.List[StackTraceElement]]: ...
    def getContextClassLoader(self) -> ClassLoader: ...
    @staticmethod
    def getDefaultUncaughtExceptionHandler() -> 'Thread.UncaughtExceptionHandler': ...
    def getId(self) -> int: ...
    def getName(self) -> str: ...
    def getPriority(self) -> int: ...
    def getStackTrace(self) -> typing.List[StackTraceElement]: ...
    def getState(self) -> 'Thread.State': ...
    def getThreadGroup(self) -> 'ThreadGroup': ...
    def getUncaughtExceptionHandler(self) -> 'Thread.UncaughtExceptionHandler': ...
    @staticmethod
    def holdsLock(object: typing.Any) -> bool: ...
    def interrupt(self) -> None: ...
    @staticmethod
    def interrupted() -> bool: ...
    def isAlive(self) -> bool: ...
    def isDaemon(self) -> bool: ...
    def isInterrupted(self) -> bool: ...
    @typing.overload
    def join(self, long: int) -> None: ...
    @typing.overload
    def join(self, long: int, int: int) -> None: ...
    @typing.overload
    def join(self) -> None: ...
    @staticmethod
    def onSpinWait() -> None: ...
    def resume(self) -> None: ...
    def run(self) -> None: ...
    def setContextClassLoader(self, classLoader: ClassLoader) -> None: ...
    def setDaemon(self, boolean: bool) -> None: ...
    @staticmethod
    def setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler: typing.Union['Thread.UncaughtExceptionHandler', typing.Callable]) -> None: ...
    def setName(self, string: str) -> None: ...
    def setPriority(self, int: int) -> None: ...
    def setUncaughtExceptionHandler(self, uncaughtExceptionHandler: typing.Union['Thread.UncaughtExceptionHandler', typing.Callable]) -> None: ...
    @typing.overload
    @staticmethod
    def sleep(long: int) -> None: ...
    @typing.overload
    @staticmethod
    def sleep(long: int, int: int) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def suspend(self) -> None: ...
    def toString(self) -> str: ...
    class State(Enum['Thread.State']):
        NEW: typing.ClassVar['Thread.State'] = ...
        RUNNABLE: typing.ClassVar['Thread.State'] = ...
        BLOCKED: typing.ClassVar['Thread.State'] = ...
        WAITING: typing.ClassVar['Thread.State'] = ...
        TIMED_WAITING: typing.ClassVar['Thread.State'] = ...
        TERMINATED: typing.ClassVar['Thread.State'] = ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'Thread.State': ...
        @staticmethod
        def values() -> typing.List['Thread.State']: ...
    class UncaughtExceptionHandler:
        def uncaughtException(self, thread: 'Thread', throwable: Throwable) -> None: ...

class ThreadDeath(Error):
    def __init__(self): ...

class VirtualMachineError(Error):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class ArithmeticException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class ArrayStoreException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class BootstrapMethodError(LinkageError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class ClassCastException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class ClassCircularityError(LinkageError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class ClassFormatError(LinkageError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class ClassNotFoundException(ReflectiveOperationException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    def getCause(self) -> Throwable: ...
    def getException(self) -> Throwable: ...

class EnumConstantNotPresentException(RuntimeException):
    def __init__(self, class_: typing.Type[Enum], string: str): ...
    def constantName(self) -> str: ...
    def enumType(self) -> typing.Type[Enum]: ...

class ExceptionInInitializerError(LinkageError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...
    def getCause(self) -> Throwable: ...
    def getException(self) -> Throwable: ...

class IllegalAccessException(ReflectiveOperationException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class IllegalArgumentException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class IllegalCallerException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class IllegalMonitorStateException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class IllegalStateException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class IncompatibleClassChangeError(LinkageError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class IndexOutOfBoundsException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, string: str): ...

class InstantiationException(ReflectiveOperationException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class InternalError(VirtualMachineError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class LayerInstantiationException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class NegativeArraySizeException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class NoClassDefFoundError(LinkageError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class NoSuchFieldException(ReflectiveOperationException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class NoSuchMethodException(ReflectiveOperationException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class NullPointerException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class OutOfMemoryError(VirtualMachineError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class SecurityException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class StackOverflowError(VirtualMachineError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class ThreadGroup(Thread.UncaughtExceptionHandler):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, threadGroup: 'ThreadGroup', string: str): ...
    def activeCount(self) -> int: ...
    def activeGroupCount(self) -> int: ...
    def allowThreadSuspension(self, boolean: bool) -> bool: ...
    def checkAccess(self) -> None: ...
    def destroy(self) -> None: ...
    @typing.overload
    def enumerate(self, threadGroupArray: typing.List['ThreadGroup']) -> int: ...
    @typing.overload
    def enumerate(self, threadGroupArray: typing.List['ThreadGroup'], boolean: bool) -> int: ...
    @typing.overload
    def enumerate(self, threadArray: typing.List[Thread]) -> int: ...
    @typing.overload
    def enumerate(self, threadArray: typing.List[Thread], boolean: bool) -> int: ...
    def getMaxPriority(self) -> int: ...
    def getName(self) -> str: ...
    def getParent(self) -> 'ThreadGroup': ...
    def interrupt(self) -> None: ...
    def isDaemon(self) -> bool: ...
    def isDestroyed(self) -> bool: ...
    def list(self) -> None: ...
    def parentOf(self, threadGroup: 'ThreadGroup') -> bool: ...
    def resume(self) -> None: ...
    def setDaemon(self, boolean: bool) -> None: ...
    def setMaxPriority(self, int: int) -> None: ...
    def stop(self) -> None: ...
    def suspend(self) -> None: ...
    def toString(self) -> str: ...
    def uncaughtException(self, thread: Thread, throwable: Throwable) -> None: ...

class TypeNotPresentException(RuntimeException):
    def __init__(self, string: str, throwable: Throwable): ...
    def typeName(self) -> str: ...

class UnknownError(VirtualMachineError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class UnsatisfiedLinkError(LinkageError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class UnsupportedOperationException(RuntimeException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: Throwable): ...
    @typing.overload
    def __init__(self, throwable: Throwable): ...

class VerifyError(LinkageError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class AbstractMethodError(IncompatibleClassChangeError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class ArrayIndexOutOfBoundsException(IndexOutOfBoundsException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, string: str): ...

class IllegalAccessError(IncompatibleClassChangeError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class IllegalThreadStateException(IllegalArgumentException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class InstantiationError(IncompatibleClassChangeError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class NoSuchFieldError(IncompatibleClassChangeError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class NoSuchMethodError(IncompatibleClassChangeError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class NumberFormatException(IllegalArgumentException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class StringIndexOutOfBoundsException(IndexOutOfBoundsException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, string: str): ...

class UnsupportedClassVersionError(ClassFormatError):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class Character(java.io.Serializable, Comparable[str]):
    MIN_RADIX: typing.ClassVar[int] = ...
    MAX_RADIX: typing.ClassVar[int] = ...
    MIN_VALUE: typing.ClassVar[str] = ...
    MAX_VALUE: typing.ClassVar[str] = ...
    TYPE: typing.ClassVar[typing.Type] = ...
    UNASSIGNED: typing.ClassVar[int] = ...
    UPPERCASE_LETTER: typing.ClassVar[int] = ...
    LOWERCASE_LETTER: typing.ClassVar[int] = ...
    TITLECASE_LETTER: typing.ClassVar[int] = ...
    MODIFIER_LETTER: typing.ClassVar[int] = ...
    OTHER_LETTER: typing.ClassVar[int] = ...
    NON_SPACING_MARK: typing.ClassVar[int] = ...
    ENCLOSING_MARK: typing.ClassVar[int] = ...
    COMBINING_SPACING_MARK: typing.ClassVar[int] = ...
    DECIMAL_DIGIT_NUMBER: typing.ClassVar[int] = ...
    LETTER_NUMBER: typing.ClassVar[int] = ...
    OTHER_NUMBER: typing.ClassVar[int] = ...
    SPACE_SEPARATOR: typing.ClassVar[int] = ...
    LINE_SEPARATOR: typing.ClassVar[int] = ...
    PARAGRAPH_SEPARATOR: typing.ClassVar[int] = ...
    CONTROL: typing.ClassVar[int] = ...
    FORMAT: typing.ClassVar[int] = ...
    PRIVATE_USE: typing.ClassVar[int] = ...
    SURROGATE: typing.ClassVar[int] = ...
    DASH_PUNCTUATION: typing.ClassVar[int] = ...
    START_PUNCTUATION: typing.ClassVar[int] = ...
    END_PUNCTUATION: typing.ClassVar[int] = ...
    CONNECTOR_PUNCTUATION: typing.ClassVar[int] = ...
    OTHER_PUNCTUATION: typing.ClassVar[int] = ...
    MATH_SYMBOL: typing.ClassVar[int] = ...
    CURRENCY_SYMBOL: typing.ClassVar[int] = ...
    MODIFIER_SYMBOL: typing.ClassVar[int] = ...
    OTHER_SYMBOL: typing.ClassVar[int] = ...
    INITIAL_QUOTE_PUNCTUATION: typing.ClassVar[int] = ...
    FINAL_QUOTE_PUNCTUATION: typing.ClassVar[int] = ...
    DIRECTIONALITY_UNDEFINED: typing.ClassVar[int] = ...
    DIRECTIONALITY_LEFT_TO_RIGHT: typing.ClassVar[int] = ...
    DIRECTIONALITY_RIGHT_TO_LEFT: typing.ClassVar[int] = ...
    DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC: typing.ClassVar[int] = ...
    DIRECTIONALITY_EUROPEAN_NUMBER: typing.ClassVar[int] = ...
    DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR: typing.ClassVar[int] = ...
    DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR: typing.ClassVar[int] = ...
    DIRECTIONALITY_ARABIC_NUMBER: typing.ClassVar[int] = ...
    DIRECTIONALITY_COMMON_NUMBER_SEPARATOR: typing.ClassVar[int] = ...
    DIRECTIONALITY_NONSPACING_MARK: typing.ClassVar[int] = ...
    DIRECTIONALITY_BOUNDARY_NEUTRAL: typing.ClassVar[int] = ...
    DIRECTIONALITY_PARAGRAPH_SEPARATOR: typing.ClassVar[int] = ...
    DIRECTIONALITY_SEGMENT_SEPARATOR: typing.ClassVar[int] = ...
    DIRECTIONALITY_WHITESPACE: typing.ClassVar[int] = ...
    DIRECTIONALITY_OTHER_NEUTRALS: typing.ClassVar[int] = ...
    DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING: typing.ClassVar[int] = ...
    DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE: typing.ClassVar[int] = ...
    DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING: typing.ClassVar[int] = ...
    DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE: typing.ClassVar[int] = ...
    DIRECTIONALITY_POP_DIRECTIONAL_FORMAT: typing.ClassVar[int] = ...
    DIRECTIONALITY_LEFT_TO_RIGHT_ISOLATE: typing.ClassVar[int] = ...
    DIRECTIONALITY_RIGHT_TO_LEFT_ISOLATE: typing.ClassVar[int] = ...
    DIRECTIONALITY_FIRST_STRONG_ISOLATE: typing.ClassVar[int] = ...
    DIRECTIONALITY_POP_DIRECTIONAL_ISOLATE: typing.ClassVar[int] = ...
    MIN_HIGH_SURROGATE: typing.ClassVar[str] = ...
    MAX_HIGH_SURROGATE: typing.ClassVar[str] = ...
    MIN_LOW_SURROGATE: typing.ClassVar[str] = ...
    MAX_LOW_SURROGATE: typing.ClassVar[str] = ...
    MIN_SURROGATE: typing.ClassVar[str] = ...
    MAX_SURROGATE: typing.ClassVar[str] = ...
    MIN_SUPPLEMENTARY_CODE_POINT: typing.ClassVar[int] = ...
    MIN_CODE_POINT: typing.ClassVar[int] = ...
    MAX_CODE_POINT: typing.ClassVar[int] = ...
    SIZE: typing.ClassVar[int] = ...
    BYTES: typing.ClassVar[int] = ...
    def __init__(self, char: str): ...
    @staticmethod
    def charCount(int: int) -> int: ...
    def charValue(self) -> str: ...
    @typing.overload
    @staticmethod
    def codePointAt(charArray: typing.List[str], int: int) -> int: ...
    @typing.overload
    @staticmethod
    def codePointAt(charArray: typing.List[str], int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def codePointAt(charSequence: typing.Union[CharSequence, str], int: int) -> int: ...
    @typing.overload
    @staticmethod
    def codePointBefore(charArray: typing.List[str], int: int) -> int: ...
    @typing.overload
    @staticmethod
    def codePointBefore(charArray: typing.List[str], int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def codePointBefore(charSequence: typing.Union[CharSequence, str], int: int) -> int: ...
    @typing.overload
    @staticmethod
    def codePointCount(charArray: typing.List[str], int: int, int2: int) -> int: ...
    @typing.overload
    @staticmethod
    def codePointCount(charSequence: typing.Union[CharSequence, str], int: int, int2: int) -> int: ...
    @staticmethod
    def codePointOf(string: str) -> int: ...
    @staticmethod
    def compare(char: str, char2: str) -> int: ...
    def compareTo(self, character: str) -> int: ...
    @typing.overload
    @staticmethod
    def digit(char: str, int: int) -> int: ...
    @typing.overload
    @staticmethod
    def digit(int: int, int2: int) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    @staticmethod
    def forDigit(int: int, int2: int) -> str: ...
    @typing.overload
    @staticmethod
    def getDirectionality(char: str) -> int: ...
    @typing.overload
    @staticmethod
    def getDirectionality(int: int) -> int: ...
    @staticmethod
    def getName(int: int) -> str: ...
    @typing.overload
    @staticmethod
    def getNumericValue(char: str) -> int: ...
    @typing.overload
    @staticmethod
    def getNumericValue(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def getType(char: str) -> int: ...
    @typing.overload
    @staticmethod
    def getType(int: int) -> int: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    @staticmethod
    def hashCode(char: str) -> int: ...
    @staticmethod
    def highSurrogate(int: int) -> str: ...
    @staticmethod
    def isAlphabetic(int: int) -> bool: ...
    @staticmethod
    def isBmpCodePoint(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isDefined(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isDefined(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isDigit(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isDigit(int: int) -> bool: ...
    @staticmethod
    def isHighSurrogate(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isISOControl(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isISOControl(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isIdentifierIgnorable(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isIdentifierIgnorable(int: int) -> bool: ...
    @staticmethod
    def isIdeographic(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isJavaIdentifierPart(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isJavaIdentifierPart(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isJavaIdentifierStart(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isJavaIdentifierStart(int: int) -> bool: ...
    @staticmethod
    def isJavaLetter(char: str) -> bool: ...
    @staticmethod
    def isJavaLetterOrDigit(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isLetter(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isLetter(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isLetterOrDigit(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isLetterOrDigit(int: int) -> bool: ...
    @staticmethod
    def isLowSurrogate(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isLowerCase(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isLowerCase(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isMirrored(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isMirrored(int: int) -> bool: ...
    @staticmethod
    def isSpace(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isSpaceChar(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isSpaceChar(int: int) -> bool: ...
    @staticmethod
    def isSupplementaryCodePoint(int: int) -> bool: ...
    @staticmethod
    def isSurrogate(char: str) -> bool: ...
    @staticmethod
    def isSurrogatePair(char: str, char2: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isTitleCase(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isTitleCase(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isUnicodeIdentifierPart(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isUnicodeIdentifierPart(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isUnicodeIdentifierStart(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isUnicodeIdentifierStart(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isUpperCase(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isUpperCase(int: int) -> bool: ...
    @staticmethod
    def isValidCodePoint(int: int) -> bool: ...
    @typing.overload
    @staticmethod
    def isWhitespace(char: str) -> bool: ...
    @typing.overload
    @staticmethod
    def isWhitespace(int: int) -> bool: ...
    @staticmethod
    def lowSurrogate(int: int) -> str: ...
    @typing.overload
    @staticmethod
    def offsetByCodePoints(charArray: typing.List[str], int: int, int2: int, int3: int, int4: int) -> int: ...
    @typing.overload
    @staticmethod
    def offsetByCodePoints(charSequence: typing.Union[CharSequence, str], int: int, int2: int) -> int: ...
    @staticmethod
    def reverseBytes(char: str) -> str: ...
    @typing.overload
    @staticmethod
    def toChars(int: int) -> typing.List[str]: ...
    @typing.overload
    @staticmethod
    def toChars(int: int, charArray: typing.List[str], int2: int) -> int: ...
    @staticmethod
    def toCodePoint(char: str, char2: str) -> int: ...
    @typing.overload
    @staticmethod
    def toLowerCase(char: str) -> str: ...
    @typing.overload
    @staticmethod
    def toLowerCase(int: int) -> int: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    @staticmethod
    def toString(char: str) -> str: ...
    @typing.overload
    @staticmethod
    def toString(int: int) -> str: ...
    @typing.overload
    @staticmethod
    def toTitleCase(char: str) -> str: ...
    @typing.overload
    @staticmethod
    def toTitleCase(int: int) -> int: ...
    @typing.overload
    @staticmethod
    def toUpperCase(char: str) -> str: ...
    @typing.overload
    @staticmethod
    def toUpperCase(int: int) -> int: ...
    @staticmethod
    def valueOf(char: str) -> str: ...
    class Subset:
        def equals(self, object: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toString(self) -> str: ...
    class UnicodeBlock(java.lang.Character.Subset):
        BASIC_LATIN: typing.ClassVar['Character.UnicodeBlock'] = ...
        LATIN_1_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        LATIN_EXTENDED_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        LATIN_EXTENDED_B: typing.ClassVar['Character.UnicodeBlock'] = ...
        IPA_EXTENSIONS: typing.ClassVar['Character.UnicodeBlock'] = ...
        SPACING_MODIFIER_LETTERS: typing.ClassVar['Character.UnicodeBlock'] = ...
        COMBINING_DIACRITICAL_MARKS: typing.ClassVar['Character.UnicodeBlock'] = ...
        GREEK: typing.ClassVar['Character.UnicodeBlock'] = ...
        CYRILLIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        ARMENIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        HEBREW: typing.ClassVar['Character.UnicodeBlock'] = ...
        ARABIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        DEVANAGARI: typing.ClassVar['Character.UnicodeBlock'] = ...
        BENGALI: typing.ClassVar['Character.UnicodeBlock'] = ...
        GURMUKHI: typing.ClassVar['Character.UnicodeBlock'] = ...
        GUJARATI: typing.ClassVar['Character.UnicodeBlock'] = ...
        ORIYA: typing.ClassVar['Character.UnicodeBlock'] = ...
        TAMIL: typing.ClassVar['Character.UnicodeBlock'] = ...
        TELUGU: typing.ClassVar['Character.UnicodeBlock'] = ...
        KANNADA: typing.ClassVar['Character.UnicodeBlock'] = ...
        MALAYALAM: typing.ClassVar['Character.UnicodeBlock'] = ...
        THAI: typing.ClassVar['Character.UnicodeBlock'] = ...
        LAO: typing.ClassVar['Character.UnicodeBlock'] = ...
        TIBETAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        GEORGIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        HANGUL_JAMO: typing.ClassVar['Character.UnicodeBlock'] = ...
        LATIN_EXTENDED_ADDITIONAL: typing.ClassVar['Character.UnicodeBlock'] = ...
        GREEK_EXTENDED: typing.ClassVar['Character.UnicodeBlock'] = ...
        GENERAL_PUNCTUATION: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUPERSCRIPTS_AND_SUBSCRIPTS: typing.ClassVar['Character.UnicodeBlock'] = ...
        CURRENCY_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        COMBINING_MARKS_FOR_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        LETTERLIKE_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        NUMBER_FORMS: typing.ClassVar['Character.UnicodeBlock'] = ...
        ARROWS: typing.ClassVar['Character.UnicodeBlock'] = ...
        MATHEMATICAL_OPERATORS: typing.ClassVar['Character.UnicodeBlock'] = ...
        MISCELLANEOUS_TECHNICAL: typing.ClassVar['Character.UnicodeBlock'] = ...
        CONTROL_PICTURES: typing.ClassVar['Character.UnicodeBlock'] = ...
        OPTICAL_CHARACTER_RECOGNITION: typing.ClassVar['Character.UnicodeBlock'] = ...
        ENCLOSED_ALPHANUMERICS: typing.ClassVar['Character.UnicodeBlock'] = ...
        BOX_DRAWING: typing.ClassVar['Character.UnicodeBlock'] = ...
        BLOCK_ELEMENTS: typing.ClassVar['Character.UnicodeBlock'] = ...
        GEOMETRIC_SHAPES: typing.ClassVar['Character.UnicodeBlock'] = ...
        MISCELLANEOUS_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        DINGBATS: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_SYMBOLS_AND_PUNCTUATION: typing.ClassVar['Character.UnicodeBlock'] = ...
        HIRAGANA: typing.ClassVar['Character.UnicodeBlock'] = ...
        KATAKANA: typing.ClassVar['Character.UnicodeBlock'] = ...
        BOPOMOFO: typing.ClassVar['Character.UnicodeBlock'] = ...
        HANGUL_COMPATIBILITY_JAMO: typing.ClassVar['Character.UnicodeBlock'] = ...
        KANBUN: typing.ClassVar['Character.UnicodeBlock'] = ...
        ENCLOSED_CJK_LETTERS_AND_MONTHS: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_COMPATIBILITY: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_UNIFIED_IDEOGRAPHS: typing.ClassVar['Character.UnicodeBlock'] = ...
        HANGUL_SYLLABLES: typing.ClassVar['Character.UnicodeBlock'] = ...
        PRIVATE_USE_AREA: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_COMPATIBILITY_IDEOGRAPHS: typing.ClassVar['Character.UnicodeBlock'] = ...
        ALPHABETIC_PRESENTATION_FORMS: typing.ClassVar['Character.UnicodeBlock'] = ...
        ARABIC_PRESENTATION_FORMS_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        COMBINING_HALF_MARKS: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_COMPATIBILITY_FORMS: typing.ClassVar['Character.UnicodeBlock'] = ...
        SMALL_FORM_VARIANTS: typing.ClassVar['Character.UnicodeBlock'] = ...
        ARABIC_PRESENTATION_FORMS_B: typing.ClassVar['Character.UnicodeBlock'] = ...
        HALFWIDTH_AND_FULLWIDTH_FORMS: typing.ClassVar['Character.UnicodeBlock'] = ...
        SPECIALS: typing.ClassVar['Character.UnicodeBlock'] = ...
        SURROGATES_AREA: typing.ClassVar['Character.UnicodeBlock'] = ...
        SYRIAC: typing.ClassVar['Character.UnicodeBlock'] = ...
        THAANA: typing.ClassVar['Character.UnicodeBlock'] = ...
        SINHALA: typing.ClassVar['Character.UnicodeBlock'] = ...
        MYANMAR: typing.ClassVar['Character.UnicodeBlock'] = ...
        ETHIOPIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        CHEROKEE: typing.ClassVar['Character.UnicodeBlock'] = ...
        UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS: typing.ClassVar['Character.UnicodeBlock'] = ...
        OGHAM: typing.ClassVar['Character.UnicodeBlock'] = ...
        RUNIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        KHMER: typing.ClassVar['Character.UnicodeBlock'] = ...
        MONGOLIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        BRAILLE_PATTERNS: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_RADICALS_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        KANGXI_RADICALS: typing.ClassVar['Character.UnicodeBlock'] = ...
        IDEOGRAPHIC_DESCRIPTION_CHARACTERS: typing.ClassVar['Character.UnicodeBlock'] = ...
        BOPOMOFO_EXTENDED: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        YI_SYLLABLES: typing.ClassVar['Character.UnicodeBlock'] = ...
        YI_RADICALS: typing.ClassVar['Character.UnicodeBlock'] = ...
        CYRILLIC_SUPPLEMENTARY: typing.ClassVar['Character.UnicodeBlock'] = ...
        TAGALOG: typing.ClassVar['Character.UnicodeBlock'] = ...
        HANUNOO: typing.ClassVar['Character.UnicodeBlock'] = ...
        BUHID: typing.ClassVar['Character.UnicodeBlock'] = ...
        TAGBANWA: typing.ClassVar['Character.UnicodeBlock'] = ...
        LIMBU: typing.ClassVar['Character.UnicodeBlock'] = ...
        TAI_LE: typing.ClassVar['Character.UnicodeBlock'] = ...
        KHMER_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        PHONETIC_EXTENSIONS: typing.ClassVar['Character.UnicodeBlock'] = ...
        MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUPPLEMENTAL_ARROWS_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUPPLEMENTAL_ARROWS_B: typing.ClassVar['Character.UnicodeBlock'] = ...
        MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUPPLEMENTAL_MATHEMATICAL_OPERATORS: typing.ClassVar['Character.UnicodeBlock'] = ...
        MISCELLANEOUS_SYMBOLS_AND_ARROWS: typing.ClassVar['Character.UnicodeBlock'] = ...
        KATAKANA_PHONETIC_EXTENSIONS: typing.ClassVar['Character.UnicodeBlock'] = ...
        YIJING_HEXAGRAM_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        VARIATION_SELECTORS: typing.ClassVar['Character.UnicodeBlock'] = ...
        LINEAR_B_SYLLABARY: typing.ClassVar['Character.UnicodeBlock'] = ...
        LINEAR_B_IDEOGRAMS: typing.ClassVar['Character.UnicodeBlock'] = ...
        AEGEAN_NUMBERS: typing.ClassVar['Character.UnicodeBlock'] = ...
        OLD_ITALIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        GOTHIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        UGARITIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        DESERET: typing.ClassVar['Character.UnicodeBlock'] = ...
        SHAVIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        OSMANYA: typing.ClassVar['Character.UnicodeBlock'] = ...
        CYPRIOT_SYLLABARY: typing.ClassVar['Character.UnicodeBlock'] = ...
        BYZANTINE_MUSICAL_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        MUSICAL_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        TAI_XUAN_JING_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        MATHEMATICAL_ALPHANUMERIC_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        TAGS: typing.ClassVar['Character.UnicodeBlock'] = ...
        VARIATION_SELECTORS_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUPPLEMENTARY_PRIVATE_USE_AREA_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUPPLEMENTARY_PRIVATE_USE_AREA_B: typing.ClassVar['Character.UnicodeBlock'] = ...
        HIGH_SURROGATES: typing.ClassVar['Character.UnicodeBlock'] = ...
        HIGH_PRIVATE_USE_SURROGATES: typing.ClassVar['Character.UnicodeBlock'] = ...
        LOW_SURROGATES: typing.ClassVar['Character.UnicodeBlock'] = ...
        ARABIC_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        NKO: typing.ClassVar['Character.UnicodeBlock'] = ...
        SAMARITAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        MANDAIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        ETHIOPIC_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED: typing.ClassVar['Character.UnicodeBlock'] = ...
        NEW_TAI_LUE: typing.ClassVar['Character.UnicodeBlock'] = ...
        BUGINESE: typing.ClassVar['Character.UnicodeBlock'] = ...
        TAI_THAM: typing.ClassVar['Character.UnicodeBlock'] = ...
        BALINESE: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUNDANESE: typing.ClassVar['Character.UnicodeBlock'] = ...
        BATAK: typing.ClassVar['Character.UnicodeBlock'] = ...
        LEPCHA: typing.ClassVar['Character.UnicodeBlock'] = ...
        OL_CHIKI: typing.ClassVar['Character.UnicodeBlock'] = ...
        VEDIC_EXTENSIONS: typing.ClassVar['Character.UnicodeBlock'] = ...
        PHONETIC_EXTENSIONS_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        COMBINING_DIACRITICAL_MARKS_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        GLAGOLITIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        LATIN_EXTENDED_C: typing.ClassVar['Character.UnicodeBlock'] = ...
        COPTIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        GEORGIAN_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        TIFINAGH: typing.ClassVar['Character.UnicodeBlock'] = ...
        ETHIOPIC_EXTENDED: typing.ClassVar['Character.UnicodeBlock'] = ...
        CYRILLIC_EXTENDED_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUPPLEMENTAL_PUNCTUATION: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_STROKES: typing.ClassVar['Character.UnicodeBlock'] = ...
        LISU: typing.ClassVar['Character.UnicodeBlock'] = ...
        VAI: typing.ClassVar['Character.UnicodeBlock'] = ...
        CYRILLIC_EXTENDED_B: typing.ClassVar['Character.UnicodeBlock'] = ...
        BAMUM: typing.ClassVar['Character.UnicodeBlock'] = ...
        MODIFIER_TONE_LETTERS: typing.ClassVar['Character.UnicodeBlock'] = ...
        LATIN_EXTENDED_D: typing.ClassVar['Character.UnicodeBlock'] = ...
        SYLOTI_NAGRI: typing.ClassVar['Character.UnicodeBlock'] = ...
        COMMON_INDIC_NUMBER_FORMS: typing.ClassVar['Character.UnicodeBlock'] = ...
        PHAGS_PA: typing.ClassVar['Character.UnicodeBlock'] = ...
        SAURASHTRA: typing.ClassVar['Character.UnicodeBlock'] = ...
        DEVANAGARI_EXTENDED: typing.ClassVar['Character.UnicodeBlock'] = ...
        KAYAH_LI: typing.ClassVar['Character.UnicodeBlock'] = ...
        REJANG: typing.ClassVar['Character.UnicodeBlock'] = ...
        HANGUL_JAMO_EXTENDED_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        JAVANESE: typing.ClassVar['Character.UnicodeBlock'] = ...
        CHAM: typing.ClassVar['Character.UnicodeBlock'] = ...
        MYANMAR_EXTENDED_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        TAI_VIET: typing.ClassVar['Character.UnicodeBlock'] = ...
        ETHIOPIC_EXTENDED_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        MEETEI_MAYEK: typing.ClassVar['Character.UnicodeBlock'] = ...
        HANGUL_JAMO_EXTENDED_B: typing.ClassVar['Character.UnicodeBlock'] = ...
        VERTICAL_FORMS: typing.ClassVar['Character.UnicodeBlock'] = ...
        ANCIENT_GREEK_NUMBERS: typing.ClassVar['Character.UnicodeBlock'] = ...
        ANCIENT_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        PHAISTOS_DISC: typing.ClassVar['Character.UnicodeBlock'] = ...
        LYCIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        CARIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        OLD_PERSIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        IMPERIAL_ARAMAIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        PHOENICIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        LYDIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        KHAROSHTHI: typing.ClassVar['Character.UnicodeBlock'] = ...
        OLD_SOUTH_ARABIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        AVESTAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        INSCRIPTIONAL_PARTHIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        INSCRIPTIONAL_PAHLAVI: typing.ClassVar['Character.UnicodeBlock'] = ...
        OLD_TURKIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        RUMI_NUMERAL_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        BRAHMI: typing.ClassVar['Character.UnicodeBlock'] = ...
        KAITHI: typing.ClassVar['Character.UnicodeBlock'] = ...
        CUNEIFORM: typing.ClassVar['Character.UnicodeBlock'] = ...
        CUNEIFORM_NUMBERS_AND_PUNCTUATION: typing.ClassVar['Character.UnicodeBlock'] = ...
        EGYPTIAN_HIEROGLYPHS: typing.ClassVar['Character.UnicodeBlock'] = ...
        BAMUM_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        KANA_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        ANCIENT_GREEK_MUSICAL_NOTATION: typing.ClassVar['Character.UnicodeBlock'] = ...
        COUNTING_ROD_NUMERALS: typing.ClassVar['Character.UnicodeBlock'] = ...
        MAHJONG_TILES: typing.ClassVar['Character.UnicodeBlock'] = ...
        DOMINO_TILES: typing.ClassVar['Character.UnicodeBlock'] = ...
        PLAYING_CARDS: typing.ClassVar['Character.UnicodeBlock'] = ...
        ENCLOSED_ALPHANUMERIC_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        ENCLOSED_IDEOGRAPHIC_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS: typing.ClassVar['Character.UnicodeBlock'] = ...
        EMOTICONS: typing.ClassVar['Character.UnicodeBlock'] = ...
        TRANSPORT_AND_MAP_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        ALCHEMICAL_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D: typing.ClassVar['Character.UnicodeBlock'] = ...
        ARABIC_EXTENDED_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUNDANESE_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        MEETEI_MAYEK_EXTENSIONS: typing.ClassVar['Character.UnicodeBlock'] = ...
        MEROITIC_HIEROGLYPHS: typing.ClassVar['Character.UnicodeBlock'] = ...
        MEROITIC_CURSIVE: typing.ClassVar['Character.UnicodeBlock'] = ...
        SORA_SOMPENG: typing.ClassVar['Character.UnicodeBlock'] = ...
        CHAKMA: typing.ClassVar['Character.UnicodeBlock'] = ...
        SHARADA: typing.ClassVar['Character.UnicodeBlock'] = ...
        TAKRI: typing.ClassVar['Character.UnicodeBlock'] = ...
        MIAO: typing.ClassVar['Character.UnicodeBlock'] = ...
        ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        COMBINING_DIACRITICAL_MARKS_EXTENDED: typing.ClassVar['Character.UnicodeBlock'] = ...
        MYANMAR_EXTENDED_B: typing.ClassVar['Character.UnicodeBlock'] = ...
        LATIN_EXTENDED_E: typing.ClassVar['Character.UnicodeBlock'] = ...
        COPTIC_EPACT_NUMBERS: typing.ClassVar['Character.UnicodeBlock'] = ...
        OLD_PERMIC: typing.ClassVar['Character.UnicodeBlock'] = ...
        ELBASAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        CAUCASIAN_ALBANIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        LINEAR_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        PALMYRENE: typing.ClassVar['Character.UnicodeBlock'] = ...
        NABATAEAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        OLD_NORTH_ARABIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        MANICHAEAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        PSALTER_PAHLAVI: typing.ClassVar['Character.UnicodeBlock'] = ...
        MAHAJANI: typing.ClassVar['Character.UnicodeBlock'] = ...
        SINHALA_ARCHAIC_NUMBERS: typing.ClassVar['Character.UnicodeBlock'] = ...
        KHOJKI: typing.ClassVar['Character.UnicodeBlock'] = ...
        KHUDAWADI: typing.ClassVar['Character.UnicodeBlock'] = ...
        GRANTHA: typing.ClassVar['Character.UnicodeBlock'] = ...
        TIRHUTA: typing.ClassVar['Character.UnicodeBlock'] = ...
        SIDDHAM: typing.ClassVar['Character.UnicodeBlock'] = ...
        MODI: typing.ClassVar['Character.UnicodeBlock'] = ...
        WARANG_CITI: typing.ClassVar['Character.UnicodeBlock'] = ...
        PAU_CIN_HAU: typing.ClassVar['Character.UnicodeBlock'] = ...
        MRO: typing.ClassVar['Character.UnicodeBlock'] = ...
        BASSA_VAH: typing.ClassVar['Character.UnicodeBlock'] = ...
        PAHAWH_HMONG: typing.ClassVar['Character.UnicodeBlock'] = ...
        DUPLOYAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        SHORTHAND_FORMAT_CONTROLS: typing.ClassVar['Character.UnicodeBlock'] = ...
        MENDE_KIKAKUI: typing.ClassVar['Character.UnicodeBlock'] = ...
        ORNAMENTAL_DINGBATS: typing.ClassVar['Character.UnicodeBlock'] = ...
        GEOMETRIC_SHAPES_EXTENDED: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUPPLEMENTAL_ARROWS_C: typing.ClassVar['Character.UnicodeBlock'] = ...
        CHEROKEE_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        HATRAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        OLD_HUNGARIAN: typing.ClassVar['Character.UnicodeBlock'] = ...
        MULTANI: typing.ClassVar['Character.UnicodeBlock'] = ...
        AHOM: typing.ClassVar['Character.UnicodeBlock'] = ...
        EARLY_DYNASTIC_CUNEIFORM: typing.ClassVar['Character.UnicodeBlock'] = ...
        ANATOLIAN_HIEROGLYPHS: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUTTON_SIGNWRITING: typing.ClassVar['Character.UnicodeBlock'] = ...
        SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E: typing.ClassVar['Character.UnicodeBlock'] = ...
        SYRIAC_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        CYRILLIC_EXTENDED_C: typing.ClassVar['Character.UnicodeBlock'] = ...
        OSAGE: typing.ClassVar['Character.UnicodeBlock'] = ...
        NEWA: typing.ClassVar['Character.UnicodeBlock'] = ...
        MONGOLIAN_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        MARCHEN: typing.ClassVar['Character.UnicodeBlock'] = ...
        IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION: typing.ClassVar['Character.UnicodeBlock'] = ...
        TANGUT: typing.ClassVar['Character.UnicodeBlock'] = ...
        TANGUT_COMPONENTS: typing.ClassVar['Character.UnicodeBlock'] = ...
        KANA_EXTENDED_A: typing.ClassVar['Character.UnicodeBlock'] = ...
        GLAGOLITIC_SUPPLEMENT: typing.ClassVar['Character.UnicodeBlock'] = ...
        ADLAM: typing.ClassVar['Character.UnicodeBlock'] = ...
        MASARAM_GONDI: typing.ClassVar['Character.UnicodeBlock'] = ...
        ZANABAZAR_SQUARE: typing.ClassVar['Character.UnicodeBlock'] = ...
        NUSHU: typing.ClassVar['Character.UnicodeBlock'] = ...
        SOYOMBO: typing.ClassVar['Character.UnicodeBlock'] = ...
        BHAIKSUKI: typing.ClassVar['Character.UnicodeBlock'] = ...
        CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F: typing.ClassVar['Character.UnicodeBlock'] = ...
        @staticmethod
        def forName(string: str) -> 'Character.UnicodeBlock': ...
        @typing.overload
        @staticmethod
        def of(char: str) -> 'Character.UnicodeBlock': ...
        @typing.overload
        @staticmethod
        def of(int: int) -> 'Character.UnicodeBlock': ...
    class UnicodeScript(Enum['Character.UnicodeScript']):
        COMMON: typing.ClassVar['Character.UnicodeScript'] = ...
        LATIN: typing.ClassVar['Character.UnicodeScript'] = ...
        GREEK: typing.ClassVar['Character.UnicodeScript'] = ...
        CYRILLIC: typing.ClassVar['Character.UnicodeScript'] = ...
        ARMENIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        HEBREW: typing.ClassVar['Character.UnicodeScript'] = ...
        ARABIC: typing.ClassVar['Character.UnicodeScript'] = ...
        SYRIAC: typing.ClassVar['Character.UnicodeScript'] = ...
        THAANA: typing.ClassVar['Character.UnicodeScript'] = ...
        DEVANAGARI: typing.ClassVar['Character.UnicodeScript'] = ...
        BENGALI: typing.ClassVar['Character.UnicodeScript'] = ...
        GURMUKHI: typing.ClassVar['Character.UnicodeScript'] = ...
        GUJARATI: typing.ClassVar['Character.UnicodeScript'] = ...
        ORIYA: typing.ClassVar['Character.UnicodeScript'] = ...
        TAMIL: typing.ClassVar['Character.UnicodeScript'] = ...
        TELUGU: typing.ClassVar['Character.UnicodeScript'] = ...
        KANNADA: typing.ClassVar['Character.UnicodeScript'] = ...
        MALAYALAM: typing.ClassVar['Character.UnicodeScript'] = ...
        SINHALA: typing.ClassVar['Character.UnicodeScript'] = ...
        THAI: typing.ClassVar['Character.UnicodeScript'] = ...
        LAO: typing.ClassVar['Character.UnicodeScript'] = ...
        TIBETAN: typing.ClassVar['Character.UnicodeScript'] = ...
        MYANMAR: typing.ClassVar['Character.UnicodeScript'] = ...
        GEORGIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        HANGUL: typing.ClassVar['Character.UnicodeScript'] = ...
        ETHIOPIC: typing.ClassVar['Character.UnicodeScript'] = ...
        CHEROKEE: typing.ClassVar['Character.UnicodeScript'] = ...
        CANADIAN_ABORIGINAL: typing.ClassVar['Character.UnicodeScript'] = ...
        OGHAM: typing.ClassVar['Character.UnicodeScript'] = ...
        RUNIC: typing.ClassVar['Character.UnicodeScript'] = ...
        KHMER: typing.ClassVar['Character.UnicodeScript'] = ...
        MONGOLIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        HIRAGANA: typing.ClassVar['Character.UnicodeScript'] = ...
        KATAKANA: typing.ClassVar['Character.UnicodeScript'] = ...
        BOPOMOFO: typing.ClassVar['Character.UnicodeScript'] = ...
        HAN: typing.ClassVar['Character.UnicodeScript'] = ...
        YI: typing.ClassVar['Character.UnicodeScript'] = ...
        OLD_ITALIC: typing.ClassVar['Character.UnicodeScript'] = ...
        GOTHIC: typing.ClassVar['Character.UnicodeScript'] = ...
        DESERET: typing.ClassVar['Character.UnicodeScript'] = ...
        INHERITED: typing.ClassVar['Character.UnicodeScript'] = ...
        TAGALOG: typing.ClassVar['Character.UnicodeScript'] = ...
        HANUNOO: typing.ClassVar['Character.UnicodeScript'] = ...
        BUHID: typing.ClassVar['Character.UnicodeScript'] = ...
        TAGBANWA: typing.ClassVar['Character.UnicodeScript'] = ...
        LIMBU: typing.ClassVar['Character.UnicodeScript'] = ...
        TAI_LE: typing.ClassVar['Character.UnicodeScript'] = ...
        LINEAR_B: typing.ClassVar['Character.UnicodeScript'] = ...
        UGARITIC: typing.ClassVar['Character.UnicodeScript'] = ...
        SHAVIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        OSMANYA: typing.ClassVar['Character.UnicodeScript'] = ...
        CYPRIOT: typing.ClassVar['Character.UnicodeScript'] = ...
        BRAILLE: typing.ClassVar['Character.UnicodeScript'] = ...
        BUGINESE: typing.ClassVar['Character.UnicodeScript'] = ...
        COPTIC: typing.ClassVar['Character.UnicodeScript'] = ...
        NEW_TAI_LUE: typing.ClassVar['Character.UnicodeScript'] = ...
        GLAGOLITIC: typing.ClassVar['Character.UnicodeScript'] = ...
        TIFINAGH: typing.ClassVar['Character.UnicodeScript'] = ...
        SYLOTI_NAGRI: typing.ClassVar['Character.UnicodeScript'] = ...
        OLD_PERSIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        KHAROSHTHI: typing.ClassVar['Character.UnicodeScript'] = ...
        BALINESE: typing.ClassVar['Character.UnicodeScript'] = ...
        CUNEIFORM: typing.ClassVar['Character.UnicodeScript'] = ...
        PHOENICIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        PHAGS_PA: typing.ClassVar['Character.UnicodeScript'] = ...
        NKO: typing.ClassVar['Character.UnicodeScript'] = ...
        SUNDANESE: typing.ClassVar['Character.UnicodeScript'] = ...
        BATAK: typing.ClassVar['Character.UnicodeScript'] = ...
        LEPCHA: typing.ClassVar['Character.UnicodeScript'] = ...
        OL_CHIKI: typing.ClassVar['Character.UnicodeScript'] = ...
        VAI: typing.ClassVar['Character.UnicodeScript'] = ...
        SAURASHTRA: typing.ClassVar['Character.UnicodeScript'] = ...
        KAYAH_LI: typing.ClassVar['Character.UnicodeScript'] = ...
        REJANG: typing.ClassVar['Character.UnicodeScript'] = ...
        LYCIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        CARIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        LYDIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        CHAM: typing.ClassVar['Character.UnicodeScript'] = ...
        TAI_THAM: typing.ClassVar['Character.UnicodeScript'] = ...
        TAI_VIET: typing.ClassVar['Character.UnicodeScript'] = ...
        AVESTAN: typing.ClassVar['Character.UnicodeScript'] = ...
        EGYPTIAN_HIEROGLYPHS: typing.ClassVar['Character.UnicodeScript'] = ...
        SAMARITAN: typing.ClassVar['Character.UnicodeScript'] = ...
        MANDAIC: typing.ClassVar['Character.UnicodeScript'] = ...
        LISU: typing.ClassVar['Character.UnicodeScript'] = ...
        BAMUM: typing.ClassVar['Character.UnicodeScript'] = ...
        JAVANESE: typing.ClassVar['Character.UnicodeScript'] = ...
        MEETEI_MAYEK: typing.ClassVar['Character.UnicodeScript'] = ...
        IMPERIAL_ARAMAIC: typing.ClassVar['Character.UnicodeScript'] = ...
        OLD_SOUTH_ARABIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        INSCRIPTIONAL_PARTHIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        INSCRIPTIONAL_PAHLAVI: typing.ClassVar['Character.UnicodeScript'] = ...
        OLD_TURKIC: typing.ClassVar['Character.UnicodeScript'] = ...
        BRAHMI: typing.ClassVar['Character.UnicodeScript'] = ...
        KAITHI: typing.ClassVar['Character.UnicodeScript'] = ...
        MEROITIC_HIEROGLYPHS: typing.ClassVar['Character.UnicodeScript'] = ...
        MEROITIC_CURSIVE: typing.ClassVar['Character.UnicodeScript'] = ...
        SORA_SOMPENG: typing.ClassVar['Character.UnicodeScript'] = ...
        CHAKMA: typing.ClassVar['Character.UnicodeScript'] = ...
        SHARADA: typing.ClassVar['Character.UnicodeScript'] = ...
        TAKRI: typing.ClassVar['Character.UnicodeScript'] = ...
        MIAO: typing.ClassVar['Character.UnicodeScript'] = ...
        CAUCASIAN_ALBANIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        BASSA_VAH: typing.ClassVar['Character.UnicodeScript'] = ...
        DUPLOYAN: typing.ClassVar['Character.UnicodeScript'] = ...
        ELBASAN: typing.ClassVar['Character.UnicodeScript'] = ...
        GRANTHA: typing.ClassVar['Character.UnicodeScript'] = ...
        PAHAWH_HMONG: typing.ClassVar['Character.UnicodeScript'] = ...
        KHOJKI: typing.ClassVar['Character.UnicodeScript'] = ...
        LINEAR_A: typing.ClassVar['Character.UnicodeScript'] = ...
        MAHAJANI: typing.ClassVar['Character.UnicodeScript'] = ...
        MANICHAEAN: typing.ClassVar['Character.UnicodeScript'] = ...
        MENDE_KIKAKUI: typing.ClassVar['Character.UnicodeScript'] = ...
        MODI: typing.ClassVar['Character.UnicodeScript'] = ...
        MRO: typing.ClassVar['Character.UnicodeScript'] = ...
        OLD_NORTH_ARABIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        NABATAEAN: typing.ClassVar['Character.UnicodeScript'] = ...
        PALMYRENE: typing.ClassVar['Character.UnicodeScript'] = ...
        PAU_CIN_HAU: typing.ClassVar['Character.UnicodeScript'] = ...
        OLD_PERMIC: typing.ClassVar['Character.UnicodeScript'] = ...
        PSALTER_PAHLAVI: typing.ClassVar['Character.UnicodeScript'] = ...
        SIDDHAM: typing.ClassVar['Character.UnicodeScript'] = ...
        KHUDAWADI: typing.ClassVar['Character.UnicodeScript'] = ...
        TIRHUTA: typing.ClassVar['Character.UnicodeScript'] = ...
        WARANG_CITI: typing.ClassVar['Character.UnicodeScript'] = ...
        AHOM: typing.ClassVar['Character.UnicodeScript'] = ...
        ANATOLIAN_HIEROGLYPHS: typing.ClassVar['Character.UnicodeScript'] = ...
        HATRAN: typing.ClassVar['Character.UnicodeScript'] = ...
        MULTANI: typing.ClassVar['Character.UnicodeScript'] = ...
        OLD_HUNGARIAN: typing.ClassVar['Character.UnicodeScript'] = ...
        SIGNWRITING: typing.ClassVar['Character.UnicodeScript'] = ...
        ADLAM: typing.ClassVar['Character.UnicodeScript'] = ...
        BHAIKSUKI: typing.ClassVar['Character.UnicodeScript'] = ...
        MARCHEN: typing.ClassVar['Character.UnicodeScript'] = ...
        NEWA: typing.ClassVar['Character.UnicodeScript'] = ...
        OSAGE: typing.ClassVar['Character.UnicodeScript'] = ...
        TANGUT: typing.ClassVar['Character.UnicodeScript'] = ...
        MASARAM_GONDI: typing.ClassVar['Character.UnicodeScript'] = ...
        NUSHU: typing.ClassVar['Character.UnicodeScript'] = ...
        SOYOMBO: typing.ClassVar['Character.UnicodeScript'] = ...
        ZANABAZAR_SQUARE: typing.ClassVar['Character.UnicodeScript'] = ...
        UNKNOWN: typing.ClassVar['Character.UnicodeScript'] = ...
        @staticmethod
        def forName(string: str) -> 'Character.UnicodeScript': ...
        @staticmethod
        def of(int: int) -> 'Character.UnicodeScript': ...
        _valueOf_1__T = typing.TypeVar('_valueOf_1__T', bound=Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'Character.UnicodeScript': ...
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @staticmethod
        def values() -> typing.List['Character.UnicodeScript']: ...

class Package(java.lang.NamedPackage, java.lang.reflect.AnnotatedElement):
    _getAnnotation__A = typing.TypeVar('_getAnnotation__A', bound=java.lang.annotation.Annotation)  # <A>
    def getAnnotation(self, class_: typing.Type[_getAnnotation__A]) -> _getAnnotation__A: ...
    def getAnnotations(self) -> typing.List[java.lang.annotation.Annotation]: ...
    _getAnnotationsByType__A = typing.TypeVar('_getAnnotationsByType__A', bound=java.lang.annotation.Annotation)  # <A>
    def getAnnotationsByType(self, class_: typing.Type[_getAnnotationsByType__A]) -> typing.List[_getAnnotationsByType__A]: ...
    _getDeclaredAnnotation__A = typing.TypeVar('_getDeclaredAnnotation__A', bound=java.lang.annotation.Annotation)  # <A>
    def getDeclaredAnnotation(self, class_: typing.Type[_getDeclaredAnnotation__A]) -> _getDeclaredAnnotation__A: ...
    def getDeclaredAnnotations(self) -> typing.List[java.lang.annotation.Annotation]: ...
    _getDeclaredAnnotationsByType__A = typing.TypeVar('_getDeclaredAnnotationsByType__A', bound=java.lang.annotation.Annotation)  # <A>
    def getDeclaredAnnotationsByType(self, class_: typing.Type[_getDeclaredAnnotationsByType__A]) -> typing.List[_getDeclaredAnnotationsByType__A]: ...
    def getImplementationTitle(self) -> str: ...
    def getImplementationVendor(self) -> str: ...
    def getImplementationVersion(self) -> str: ...
    def getName(self) -> str: ...
    @staticmethod
    def getPackage(string: str) -> 'Package': ...
    @staticmethod
    def getPackages() -> typing.List['Package']: ...
    def getSpecificationTitle(self) -> str: ...
    def getSpecificationVendor(self) -> str: ...
    def getSpecificationVersion(self) -> str: ...
    def hashCode(self) -> int: ...
    def isAnnotationPresent(self, class_: typing.Type[java.lang.annotation.Annotation]) -> bool: ...
    def isCompatibleWith(self, string: str) -> bool: ...
    @typing.overload
    def isSealed(self) -> bool: ...
    @typing.overload
    def isSealed(self, uRL: java.net.URL) -> bool: ...
    def toString(self) -> str: ...

class StringBuffer(java.lang.AbstractStringBuilder, java.io.Serializable, Comparable['StringBuffer'], CharSequence):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, charSequence: typing.Union[CharSequence, str]): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def append(self, boolean: bool) -> 'StringBuffer': ...
    @typing.overload
    def append(self, char: str) -> 'StringBuffer': ...
    @typing.overload
    def append(self, charArray: typing.List[str]) -> 'StringBuffer': ...
    @typing.overload
    def append(self, charArray: typing.List[str], int: int, int2: int) -> 'StringBuffer': ...
    @typing.overload
    def append(self, double: float) -> 'StringBuffer': ...
    @typing.overload
    def append(self, float: float) -> 'StringBuffer': ...
    @typing.overload
    def append(self, int: int) -> 'StringBuffer': ...
    @typing.overload
    def append(self, charSequence: typing.Union[CharSequence, str]) -> 'StringBuffer': ...
    @typing.overload
    def append(self, charSequence: typing.Union[CharSequence, str], int: int, int2: int) -> 'StringBuffer': ...
    @typing.overload
    def append(self, object: typing.Any) -> 'StringBuffer': ...
    @typing.overload
    def append(self, string: str) -> 'StringBuffer': ...
    @typing.overload
    def append(self, stringBuffer: 'StringBuffer') -> 'StringBuffer': ...
    @typing.overload
    def append(self, long: int) -> 'StringBuffer': ...
    def appendCodePoint(self, int: int) -> 'StringBuffer': ...
    def capacity(self) -> int: ...
    def charAt(self, int: int) -> str: ...
    def codePointAt(self, int: int) -> int: ...
    def codePointBefore(self, int: int) -> int: ...
    def codePointCount(self, int: int, int2: int) -> int: ...
    def compareTo(self, stringBuffer: 'StringBuffer') -> int: ...
    def delete(self, int: int, int2: int) -> 'StringBuffer': ...
    def deleteCharAt(self, int: int) -> 'StringBuffer': ...
    def ensureCapacity(self, int: int) -> None: ...
    def getChars(self, int: int, int2: int, charArray: typing.List[str], int3: int) -> None: ...
    @typing.overload
    def indexOf(self, string: str) -> int: ...
    @typing.overload
    def indexOf(self, string: str, int: int) -> int: ...
    @typing.overload
    def insert(self, int: int, boolean: bool) -> 'StringBuffer': ...
    @typing.overload
    def insert(self, int: int, double: float) -> 'StringBuffer': ...
    @typing.overload
    def insert(self, int: int, float: float) -> 'StringBuffer': ...
    @typing.overload
    def insert(self, int: int, int2: int) -> 'StringBuffer': ...
    @typing.overload
    def insert(self, int: int, charSequence: typing.Union[CharSequence, str]) -> 'StringBuffer': ...
    @typing.overload
    def insert(self, int: int, long: int) -> 'StringBuffer': ...
    @typing.overload
    def insert(self, int: int, char: str) -> 'StringBuffer': ...
    @typing.overload
    def insert(self, int: int, charArray: typing.List[str]) -> 'StringBuffer': ...
    @typing.overload
    def insert(self, int: int, charArray: typing.List[str], int2: int, int3: int) -> 'StringBuffer': ...
    @typing.overload
    def insert(self, int: int, charSequence: typing.Union[CharSequence, str], int2: int, int3: int) -> 'StringBuffer': ...
    @typing.overload
    def insert(self, int: int, object: typing.Any) -> 'StringBuffer': ...
    @typing.overload
    def insert(self, int: int, string: str) -> 'StringBuffer': ...
    @typing.overload
    def lastIndexOf(self, string: str) -> int: ...
    @typing.overload
    def lastIndexOf(self, string: str, int: int) -> int: ...
    def length(self) -> int: ...
    def offsetByCodePoints(self, int: int, int2: int) -> int: ...
    def replace(self, int: int, int2: int, string: str) -> 'StringBuffer': ...
    def reverse(self) -> 'StringBuffer': ...
    def setCharAt(self, int: int, char: str) -> None: ...
    def setLength(self, int: int) -> None: ...
    def subSequence(self, int: int, int2: int) -> CharSequence: ...
    @typing.overload
    def substring(self, int: int) -> str: ...
    @typing.overload
    def substring(self, int: int, int2: int) -> str: ...
    def toString(self) -> str: ...
    def trimToSize(self) -> None: ...

class StringBuilder(java.lang.AbstractStringBuilder, java.io.Serializable, Comparable['StringBuilder'], CharSequence):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, charSequence: typing.Union[CharSequence, str]): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def append(self, boolean: bool) -> 'StringBuilder': ...
    @typing.overload
    def append(self, char: str) -> 'StringBuilder': ...
    @typing.overload
    def append(self, charArray: typing.List[str]) -> 'StringBuilder': ...
    @typing.overload
    def append(self, charArray: typing.List[str], int: int, int2: int) -> 'StringBuilder': ...
    @typing.overload
    def append(self, double: float) -> 'StringBuilder': ...
    @typing.overload
    def append(self, float: float) -> 'StringBuilder': ...
    @typing.overload
    def append(self, int: int) -> 'StringBuilder': ...
    @typing.overload
    def append(self, charSequence: typing.Union[CharSequence, str]) -> 'StringBuilder': ...
    @typing.overload
    def append(self, charSequence: typing.Union[CharSequence, str], int: int, int2: int) -> 'StringBuilder': ...
    @typing.overload
    def append(self, object: typing.Any) -> 'StringBuilder': ...
    @typing.overload
    def append(self, string: str) -> 'StringBuilder': ...
    @typing.overload
    def append(self, stringBuffer: StringBuffer) -> 'StringBuilder': ...
    @typing.overload
    def append(self, long: int) -> 'StringBuilder': ...
    def appendCodePoint(self, int: int) -> 'StringBuilder': ...
    def compareTo(self, stringBuilder: 'StringBuilder') -> int: ...
    def delete(self, int: int, int2: int) -> 'StringBuilder': ...
    def deleteCharAt(self, int: int) -> 'StringBuilder': ...
    @typing.overload
    def indexOf(self, string: str) -> int: ...
    @typing.overload
    def indexOf(self, string: str, int: int) -> int: ...
    @typing.overload
    def insert(self, int: int, boolean: bool) -> 'StringBuilder': ...
    @typing.overload
    def insert(self, int: int, char: str) -> 'StringBuilder': ...
    @typing.overload
    def insert(self, int: int, charArray: typing.List[str]) -> 'StringBuilder': ...
    @typing.overload
    def insert(self, int: int, charArray: typing.List[str], int2: int, int3: int) -> 'StringBuilder': ...
    @typing.overload
    def insert(self, int: int, double: float) -> 'StringBuilder': ...
    @typing.overload
    def insert(self, int: int, float: float) -> 'StringBuilder': ...
    @typing.overload
    def insert(self, int: int, int2: int) -> 'StringBuilder': ...
    @typing.overload
    def insert(self, int: int, charSequence: typing.Union[CharSequence, str]) -> 'StringBuilder': ...
    @typing.overload
    def insert(self, int: int, charSequence: typing.Union[CharSequence, str], int2: int, int3: int) -> 'StringBuilder': ...
    @typing.overload
    def insert(self, int: int, object: typing.Any) -> 'StringBuilder': ...
    @typing.overload
    def insert(self, int: int, string: str) -> 'StringBuilder': ...
    @typing.overload
    def insert(self, int: int, long: int) -> 'StringBuilder': ...
    @typing.overload
    def lastIndexOf(self, string: str) -> int: ...
    @typing.overload
    def lastIndexOf(self, string: str, int: int) -> int: ...
    def replace(self, int: int, int2: int, string: str) -> 'StringBuilder': ...
    def reverse(self) -> 'StringBuilder': ...
    def toString(self) -> str: ...

class AbstractStringBuilder: ...

class NamedPackage: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.lang")``.

    AbstractMethodError: typing.Type[AbstractMethodError]
    AbstractStringBuilder: typing.Type[AbstractStringBuilder]
    Appendable: typing.Type[Appendable]
    ArithmeticException: typing.Type[ArithmeticException]
    ArrayIndexOutOfBoundsException: typing.Type[ArrayIndexOutOfBoundsException]
    ArrayStoreException: typing.Type[ArrayStoreException]
    AssertionError: typing.Type[AssertionError]
    AutoCloseable: typing.Type[AutoCloseable]
    Boolean: typing.Type[Boolean]
    BootstrapMethodError: typing.Type[BootstrapMethodError]
    Byte: typing.Type[Byte]
    CharSequence: typing.Type[CharSequence]
    Character: typing.Type[Character]
    Class: typing.Type[Class]
    ClassCastException: typing.Type[ClassCastException]
    ClassCircularityError: typing.Type[ClassCircularityError]
    ClassFormatError: typing.Type[ClassFormatError]
    ClassLoader: typing.Type[ClassLoader]
    ClassNotFoundException: typing.Type[ClassNotFoundException]
    ClassValue: typing.Type[ClassValue]
    CloneNotSupportedException: typing.Type[CloneNotSupportedException]
    Cloneable: typing.Type[Cloneable]
    Comparable: typing.Type[Comparable]
    Compiler: typing.Type[Compiler]
    Deprecated: typing.Type[Deprecated]
    Double: typing.Type[Double]
    Enum: typing.Type[Enum]
    EnumConstantNotPresentException: typing.Type[EnumConstantNotPresentException]
    Error: typing.Type[Error]
    Exception: typing.Type[Exception]
    ExceptionInInitializerError: typing.Type[ExceptionInInitializerError]
    Float: typing.Type[Float]
    FunctionalInterface: typing.Type[FunctionalInterface]
    IllegalAccessError: typing.Type[IllegalAccessError]
    IllegalAccessException: typing.Type[IllegalAccessException]
    IllegalArgumentException: typing.Type[IllegalArgumentException]
    IllegalCallerException: typing.Type[IllegalCallerException]
    IllegalMonitorStateException: typing.Type[IllegalMonitorStateException]
    IllegalStateException: typing.Type[IllegalStateException]
    IllegalThreadStateException: typing.Type[IllegalThreadStateException]
    IncompatibleClassChangeError: typing.Type[IncompatibleClassChangeError]
    IndexOutOfBoundsException: typing.Type[IndexOutOfBoundsException]
    InheritableThreadLocal: typing.Type[InheritableThreadLocal]
    InstantiationError: typing.Type[InstantiationError]
    InstantiationException: typing.Type[InstantiationException]
    Integer: typing.Type[Integer]
    InternalError: typing.Type[InternalError]
    InterruptedException: typing.Type[InterruptedException]
    Iterable: typing.Type[Iterable]
    LayerInstantiationException: typing.Type[LayerInstantiationException]
    LinkageError: typing.Type[LinkageError]
    Long: typing.Type[Long]
    Math: typing.Type[Math]
    Module: typing.Type[Module]
    ModuleLayer: typing.Type[ModuleLayer]
    NamedPackage: typing.Type[NamedPackage]
    NegativeArraySizeException: typing.Type[NegativeArraySizeException]
    NoClassDefFoundError: typing.Type[NoClassDefFoundError]
    NoSuchFieldError: typing.Type[NoSuchFieldError]
    NoSuchFieldException: typing.Type[NoSuchFieldException]
    NoSuchMethodError: typing.Type[NoSuchMethodError]
    NoSuchMethodException: typing.Type[NoSuchMethodException]
    NullPointerException: typing.Type[NullPointerException]
    Number: typing.Type[Number]
    NumberFormatException: typing.Type[NumberFormatException]
    Object: typing.Type[Object]
    OutOfMemoryError: typing.Type[OutOfMemoryError]
    Override: typing.Type[Override]
    Package: typing.Type[Package]
    Process: typing.Type[Process]
    ProcessBuilder: typing.Type[ProcessBuilder]
    ProcessHandle: typing.Type[ProcessHandle]
    Readable: typing.Type[Readable]
    ReflectiveOperationException: typing.Type[ReflectiveOperationException]
    Runnable: typing.Type[Runnable]
    Runtime: typing.Type[Runtime]
    RuntimeException: typing.Type[RuntimeException]
    RuntimePermission: typing.Type[RuntimePermission]
    SafeVarargs: typing.Type[SafeVarargs]
    SecurityException: typing.Type[SecurityException]
    SecurityManager: typing.Type[SecurityManager]
    Short: typing.Type[Short]
    StackOverflowError: typing.Type[StackOverflowError]
    StackTraceElement: typing.Type[StackTraceElement]
    StackWalker: typing.Type[StackWalker]
    StrictMath: typing.Type[StrictMath]
    String: typing.Type[String]
    StringBuffer: typing.Type[StringBuffer]
    StringBuilder: typing.Type[StringBuilder]
    StringIndexOutOfBoundsException: typing.Type[StringIndexOutOfBoundsException]
    SuppressWarnings: typing.Type[SuppressWarnings]
    System: typing.Type[System]
    Thread: typing.Type[Thread]
    ThreadDeath: typing.Type[ThreadDeath]
    ThreadGroup: typing.Type[ThreadGroup]
    ThreadLocal: typing.Type[ThreadLocal]
    Throwable: typing.Type[Throwable]
    TypeNotPresentException: typing.Type[TypeNotPresentException]
    UnknownError: typing.Type[UnknownError]
    UnsatisfiedLinkError: typing.Type[UnsatisfiedLinkError]
    UnsupportedClassVersionError: typing.Type[UnsupportedClassVersionError]
    UnsupportedOperationException: typing.Type[UnsupportedOperationException]
    VerifyError: typing.Type[VerifyError]
    VirtualMachineError: typing.Type[VirtualMachineError]
    Void: typing.Type[Void]
    annotation: java.lang.annotation.__module_protocol__
    instrument: java.lang.instrument.__module_protocol__
    invoke: java.lang.invoke.__module_protocol__
    management: java.lang.management.__module_protocol__
    module: java.lang.module.__module_protocol__
    ref: java.lang.ref.__module_protocol__
    reflect: java.lang.reflect.__module_protocol__
