import java.io
import java.lang
import java.math
import java.net
import java.util
import java.util.function
import jpype.protocol
import org
import org.bitbucket.inkytonik.kiama.attribution
import org.bitbucket.inkytonik.kiama.rewriting
import org.bouncycastle.math.ec
import org.bouncycastle.math.ec.custom.sec
import org.ergoplatform
import org.ergoplatform.appkit.cli
import org.ergoplatform.appkit.commands
import org.ergoplatform.appkit.config
import org.ergoplatform.appkit.ergotool
import org.ergoplatform.appkit.impl
import org.ergoplatform.restapi.client
import org.ergoplatform.settings
import org.ergoplatform.validation
import org.ergoplatform.wallet.interface4j
import org.ergoplatform.wallet.protocol.context
import org.ergoplatform.wallet.secrets
import org.ergoplatform.wallet.settings
import scala
import scala.collection
import scala.collection.immutable
import scala.collection.mutable
import scala.runtime
import scala.util
import scalan
import scorex.util.serialization
import sigmastate
import sigmastate.basics
import sigmastate.eval
import sigmastate.interpreter
import sigmastate.utils
import special.collection
import special.sigma
import typing



class Address:
    def __init__(self, ergoAddress: org.ergoplatform.ErgoAddress): ...
    def asP2PK(self) -> org.ergoplatform.P2PKAddress: ...
    def asP2S(self) -> org.ergoplatform.Pay2SAddress: ...
    @staticmethod
    def create(string: str) -> 'Address': ...
    @typing.overload
    @staticmethod
    def createEip3Address(int: int, networkType: 'NetworkType', secretString: 'SecretString', secretString2: 'SecretString') -> 'Address': ...
    @typing.overload
    @staticmethod
    def createEip3Address(int: int, networkType: 'NetworkType', extendedPublicKey: org.ergoplatform.wallet.secrets.ExtendedPublicKey) -> 'Address': ...
    def equals(self, object: typing.Any) -> bool: ...
    @staticmethod
    def fromErgoTree(ergoTree: sigmastate.Values.ErgoTree, networkType: 'NetworkType') -> 'Address': ...
    @typing.overload
    @staticmethod
    def fromMnemonic(networkType: 'NetworkType', mnemonic: 'Mnemonic') -> 'Address': ...
    @typing.overload
    @staticmethod
    def fromMnemonic(networkType: 'NetworkType', secretString: 'SecretString', secretString2: 'SecretString') -> 'Address': ...
    def getErgoAddress(self) -> org.ergoplatform.ErgoAddress: ...
    def getNetworkType(self) -> 'NetworkType': ...
    def getPublicKey(self) -> sigmastate.basics.DLogProtocol.ProveDlog: ...
    def getPublicKeyGE(self) -> special.sigma.GroupElement: ...
    def hashCode(self) -> int: ...
    def isMainnet(self) -> bool: ...
    def isP2PK(self) -> bool: ...
    def isP2S(self) -> bool: ...
    def toErgoContract(self) -> 'ErgoContract': ...
    def toString(self) -> str: ...

class AppkitProvingInterpreter(org.ergoplatform.ErgoLikeInterpreter, sigmastate.interpreter.ProverInterpreter):
    def __init__(self, secretKeys: java.util.List[org.ergoplatform.wallet.secrets.ExtendedSecretKey], dLogInputs: java.util.List[sigmastate.basics.DLogProtocol.DLogProverInput], dhtInputs: java.util.List[sigmastate.basics.DiffieHellmanTupleProverInput], params: org.ergoplatform.wallet.protocol.context.ErgoLikeParameters): ...
    def addCostLimited(self, currentCost: int, delta: int, limit: int, msg: scala.Function0[str]) -> int: ...
    _attrWithName__T = typing.TypeVar('_attrWithName__T')  # <T>
    _attrWithName__U = typing.TypeVar('_attrWithName__U')  # <U>
    def attrWithName(self, name: str, f: scala.Function1[_attrWithName__T, _attrWithName__U]) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CachedAttribute[_attrWithName__T, _attrWithName__U]: ...
    @typing.overload
    def bagForMultisig(self, context: sigmastate.interpreter.InterpreterContext, ergoTree: sigmastate.Values.ErgoTree, proof: typing.List[int], realSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean], simulatedSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> sigmastate.interpreter.HintsBag: ...
    @typing.overload
    def bagForMultisig(self, context: sigmastate.interpreter.InterpreterContext, sigmaTree: sigmastate.Values.SigmaBoolean, proof: typing.List[int], realSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean], simulatedSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> sigmastate.interpreter.HintsBag: ...
    def bagForMultisig$default$5(self) -> scala.collection.Seq[sigmastate.Values.SigmaBoolean]: ...
    _circularWithName__T = typing.TypeVar('_circularWithName__T')  # <T>
    _circularWithName__U = typing.TypeVar('_circularWithName__U')  # <U>
    def circularWithName(self, name: str, init: _circularWithName__U, f: scala.Function1[_circularWithName__T, _circularWithName__U]) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CircularAttribute[_circularWithName__T, _circularWithName__U]: ...
    _constant__T = typing.TypeVar('_constant__T')  # <T>
    _constant__U = typing.TypeVar('_constant__U')  # <U>
    def constant(self, name: str, u: scala.Function0[_constant__U]) -> org.bitbucket.inkytonik.kiama.attribution.Attribute[_constant__T, _constant__U]: ...
    def convertToUnchecked(self) -> scala.Function1[sigmastate.ProofTree, sigmastate.UncheckedSigmaTree]: ...
    def convertToUnproven(self, sigmaTree: sigmastate.Values.SigmaBoolean) -> sigmastate.UnprovenTree: ...
    def dLogInputs(self) -> java.util.List[sigmastate.basics.DLogProtocol.DLogProverInput]: ...
    def dhtInputs(self) -> java.util.List[sigmastate.basics.DiffieHellmanTupleProverInput]: ...
    _dynAttrWithName__T = typing.TypeVar('_dynAttrWithName__T')  # <T>
    _dynAttrWithName__U = typing.TypeVar('_dynAttrWithName__U')  # <U>
    def dynAttrWithName(self, name: str, f: scala.Function1[_dynAttrWithName__T, _dynAttrWithName__U]) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CachedDynamicAttribute[_dynAttrWithName__T, _dynAttrWithName__U]: ...
    @typing.overload
    def generateCommitments(self, ergoTree: sigmastate.Values.ErgoTree, ctx: sigmastate.interpreter.InterpreterContext) -> sigmastate.interpreter.HintsBag: ...
    @typing.overload
    def generateCommitments(self, sigmaTree: sigmastate.Values.SigmaBoolean) -> sigmastate.interpreter.HintsBag: ...
    @typing.overload
    def generateCommitmentsFor(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, generateFor: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> sigmastate.interpreter.HintsBag: ...
    @typing.overload
    def generateCommitmentsFor(self, sigmaTree: sigmastate.Values.SigmaBoolean, generateFor: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> sigmastate.interpreter.HintsBag: ...
    def generateProof(self, sb: sigmastate.Values.SigmaBoolean, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> typing.List[int]: ...
    _internalToDynamicAttribute__T = typing.TypeVar('_internalToDynamicAttribute__T')  # <T>
    _internalToDynamicAttribute__U = typing.TypeVar('_internalToDynamicAttribute__U')  # <U>
    def internalToDynamicAttribute(self, f: scala.Function1[_internalToDynamicAttribute__T, _internalToDynamicAttribute__U]) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CachedDynamicAttribute[_internalToDynamicAttribute__T, _internalToDynamicAttribute__U]: ...
    def markReal(self, hintsBag: sigmastate.interpreter.HintsBag) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    def org$bitbucket$inkytonik$kiama$attribution$AttributionCore$$CircularAttribute(self) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CircularAttribute.: ...
    _paramAttrWithName__V = typing.TypeVar('_paramAttrWithName__V')  # <V>
    _paramAttrWithName__T = typing.TypeVar('_paramAttrWithName__T')  # <T>
    _paramAttrWithName__U = typing.TypeVar('_paramAttrWithName__U')  # <U>
    def paramAttrWithName(self, name: str, f: scala.Function1[_paramAttrWithName__V, scala.Function1[_paramAttrWithName__T, _paramAttrWithName__U]]) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CachedParamAttribute[_paramAttrWithName__V, _paramAttrWithName__T, _paramAttrWithName__U]: ...
    def polishSimulated(self) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    @typing.overload
    def prove(self, env: scala.collection.immutable.Map[str, typing.Any], ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> scala.util.Try[sigmastate.interpreter.CostedProverResult]: ...
    @typing.overload
    def prove(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, message: typing.List[int]) -> scala.util.Try[sigmastate.interpreter.CostedProverResult]: ...
    @typing.overload
    def prove(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> scala.util.Try[sigmastate.interpreter.CostedProverResult]: ...
    @typing.overload
    def prove(self, unprovenTree: sigmastate.UnprovenTree, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> sigmastate.UncheckedTree: ...
    def prove$default$5(self) -> sigmastate.interpreter.HintsBag: ...
    def proveReduced(self, reducedInput: 'ReducedInputData', message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> sigmastate.interpreter.CostedProverResult: ...
    def proveReduced$default$3(self) -> sigmastate.interpreter.HintsBag: ...
    def proving(self, hintsBag: sigmastate.interpreter.HintsBag) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    def pubKeys(self) -> scala.collection.Seq[sigmastate.basics.DLogProtocol.ProveDlog]: ...
    def publicKeys(self) -> scala.collection.Seq[sigmastate.Values.SigmaBoolean]: ...
    def reduce(self, env: scala.collection.immutable.Map[str, typing.Any], ergoTree: sigmastate.Values.ErgoTree, context: org.ergoplatform.ErgoLikeContext) -> 'ReducedInputData': ...
    def reduceTransaction(self, unsignedTx: org.ergoplatform.UnsignedErgoLikeTransaction, boxesToSpend: scala.collection.IndexedSeq['ExtendedInputBox'], dataBoxes: scala.collection.IndexedSeq[org.ergoplatform.ErgoBox], stateContext: org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext, baseCost: int) -> scala.Tuple2['ReducedErgoLikeTransaction', typing.Any]: ...
    def secretKeys(self) -> java.util.List[org.ergoplatform.wallet.secrets.ExtendedSecretKey]: ...
    def secrets(self) -> scala.collection.Seq[sigmastate.basics.SigmaProtocolPrivateInput[sigmastate.basics.SigmaProtocol[typing.Any], sigmastate.basics.SigmaProtocolCommonInput[typing.Any]]]: ...
    def setPositions(self, uc: sigmastate.UnprovenConjecture) -> sigmastate.UnprovenConjecture: ...
    def sigmastate$interpreter$ProverInterpreter$_setter_$convertToUnchecked_$eq(self, x$1: scala.Function1[sigmastate.ProofTree, sigmastate.UncheckedSigmaTree]) -> None: ...
    def sigmastate$interpreter$ProverInterpreter$_setter_$polishSimulated_$eq(self, x$1: org.bitbucket.inkytonik.kiama.rewriting.Strategy) -> None: ...
    def sign(self, unsignedTx: org.ergoplatform.UnsignedErgoLikeTransaction, boxesToSpend: scala.collection.IndexedSeq['ExtendedInputBox'], dataBoxes: scala.collection.IndexedSeq[org.ergoplatform.ErgoBox], stateContext: org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext, baseCost: int) -> scala.util.Try[scala.Tuple2[org.ergoplatform.ErgoLikeTransaction, typing.Any]]: ...
    def signMessage(self, sigmaTree: sigmastate.Values.SigmaBoolean, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> scala.util.Try[typing.List[int]]: ...
    def signReduced(self, reducedTx: 'ReducedErgoLikeTransaction', baseCost: int) -> scala.Tuple2[org.ergoplatform.ErgoLikeTransaction, typing.Any]: ...
    def simulateAndCommit(self, hintsBag: sigmastate.interpreter.HintsBag) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...

class Bip32Serialization:
    def __init__(self): ...
    @staticmethod
    def parseExtendedPublicKey(byteArray: typing.List[int], networkType: 'NetworkType') -> org.ergoplatform.wallet.secrets.ExtendedPublicKey: ...
    @staticmethod
    def parseExtendedPublicKeyFromHex(string: str, networkType: 'NetworkType') -> org.ergoplatform.wallet.secrets.ExtendedPublicKey: ...
    @staticmethod
    def serializeExtendedPublicKeyBip32(extendedSecretKey: org.ergoplatform.wallet.secrets.ExtendedSecretKey, networkType: 'NetworkType') -> typing.List[int]: ...
    @staticmethod
    def serializeExtendedPublicKeyToHex(extendedSecretKey: org.ergoplatform.wallet.secrets.ExtendedSecretKey, networkType: 'NetworkType') -> str: ...

class BlockchainContext:
    DEFAULT_LIMIT_FOR_API: typing.ClassVar[int] = ...
    def compileContract(self, constants: 'Constants', string: str) -> 'ErgoContract': ...
    def createPreHeader(self) -> 'PreHeaderBuilder': ...
    def getBoxesById(self, stringArray: typing.List[str]) -> typing.List['InputBox']: ...
    def getCoveringBoxesFor(self, address: Address, long: int, list: java.util.List['ErgoToken']) -> 'CoveringBoxes': ...
    def getHeight(self) -> int: ...
    def getNetworkType(self) -> 'NetworkType': ...
    def getUnspentBoxesFor(self, address: Address, int: int, int2: int) -> java.util.List['InputBox']: ...
    def getWallet(self) -> 'ErgoWallet': ...
    def newContract(self, ergoTree: sigmastate.Values.ErgoTree) -> 'ErgoContract': ...
    def newProverBuilder(self) -> 'ErgoProverBuilder': ...
    def newTxBuilder(self) -> 'UnsignedTransactionBuilder': ...
    def parseReducedTransaction(self, byteArray: typing.List[int]) -> 'ReducedTransaction': ...
    def parseSignedTransaction(self, byteArray: typing.List[int]) -> 'SignedTransaction': ...
    def sendTransaction(self, signedTransaction: 'SignedTransaction') -> str: ...
    def signedTxFromJson(self, string: str) -> 'SignedTransaction': ...

class BlockchainContextBuilder:
    NUM_LAST_HEADERS: typing.ClassVar[int] = ...
    def build(self) -> BlockchainContext: ...

class BoxSelectorsJavaHelpers:
    @staticmethod
    def selectBoxes(unspentBoxes: java.util.List['InputBox'], amountToSpend: int, tokensToSpend: java.util.List['ErgoToken']) -> java.util.List['InputBox']: ...
    class InputBoxWrapper(org.ergoplatform.ErgoBoxAssets, scala.Product, scala.Serializable):
        def __init__(self, inputBox: 'InputBox'): ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def copy(self, inputBox: 'InputBox') -> 'BoxSelectorsJavaHelpers.InputBoxWrapper': ...
        def copy$default$1(self) -> 'InputBox': ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def inputBox(self) -> 'InputBox': ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> str: ...
        def toString(self) -> str: ...
        def tokens(self) -> scala.collection.immutable.Map[str, typing.Any]: ...
        def value(self) -> int: ...
    class InputBoxWrapper$(scala.runtime.AbstractFunction1['InputBox', 'BoxSelectorsJavaHelpers.InputBoxWrapper'], scala.Serializable):
        MODULE$: typing.ClassVar['BoxSelectorsJavaHelpers.InputBoxWrapper.'] = ...
        def __init__(self): ...
        def apply(self, inputBox: 'InputBox') -> 'BoxSelectorsJavaHelpers.InputBoxWrapper': ...
        def toString(self) -> str: ...
        def unapply(self, x$0: 'BoxSelectorsJavaHelpers.InputBoxWrapper') -> scala.Option['InputBox']: ...

class Constants(java.util.LinkedHashMap[str, typing.Any]):
    def __init__(self): ...

class ConstantsBuilder:
    def __init__(self): ...
    def build(self) -> Constants: ...
    @staticmethod
    def create() -> 'ConstantsBuilder': ...
    @staticmethod
    def empty() -> Constants: ...
    def item(self, string: str, object: typing.Any) -> 'ConstantsBuilder': ...

class ContextVar:
    MIN_ID: typing.ClassVar[int] = ...
    MAX_ID: typing.ClassVar[int] = ...
    def __init__(self, byte: int, ergoValue: 'ErgoValue'[typing.Any]): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getId(self) -> int: ...
    def getValue(self) -> 'ErgoValue'[typing.Any]: ...
    def hashCode(self) -> int: ...
    _of_8__T = typing.TypeVar('_of_8__T')  # <T>
    @typing.overload
    @staticmethod
    def of(byte: int, boolean: bool) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, byte2: int) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, byteArray: typing.List[int]) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, int: int) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, bigInteger: java.math.BigInteger) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, long: int) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, eCPoint: org.bouncycastle.math.ec.ECPoint) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, ergoBox: org.ergoplatform.ErgoBox) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, ergoValue: 'ErgoValue'[_of_8__T]) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, short: int) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, avlTreeData: sigmastate.AvlTreeData) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, sigmaBoolean: sigmastate.Values.SigmaBoolean) -> 'ContextVar': ...
    @typing.overload
    @staticmethod
    def of(byte: int, groupElement: special.sigma.GroupElement) -> 'ContextVar': ...

class CoveringBoxes:
    def __init__(self, long: int, list: java.util.List['InputBox'], list2: java.util.List['ErgoToken'], boolean: bool): ...
    def getBoxes(self) -> java.util.List['InputBox']: ...
    def getCoveredAmount(self) -> int: ...
    def isChangeBoxNeeded(self) -> bool: ...
    def isCovered(self) -> bool: ...

class ErgoClient:
    explorerUrlNotSpecifiedMessage: typing.ClassVar[str] = ...
    _execute__T = typing.TypeVar('_execute__T')  # <T>
    def execute(self, function: typing.Union[java.util.function.Function[BlockchainContext, _execute__T], typing.Callable[[BlockchainContext], _execute__T]]) -> _execute__T: ...

class ErgoClientException(java.lang.RuntimeException):
    def __init__(self, string: str, throwable: java.lang.Throwable): ...

class ErgoContract:
    def getConstants(self) -> Constants: ...
    def getErgoScript(self) -> str: ...
    def getErgoTree(self) -> sigmastate.Values.ErgoTree: ...
    def substConstant(self, string: str, object: typing.Any) -> 'ErgoContract': ...
    def toAddress(self) -> Address: ...

class ErgoId:
    def __init__(self, byteArray: typing.List[int]): ...
    @staticmethod
    def create(string: str) -> 'ErgoId': ...
    def equals(self, object: typing.Any) -> bool: ...
    def getBytes(self) -> typing.List[int]: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class ErgoProver:
    def getAddress(self) -> Address: ...
    def getEip3Addresses(self) -> java.util.List[Address]: ...
    def getP2PKAddress(self) -> org.ergoplatform.P2PKAddress: ...
    def getSecretKey(self) -> special.sigma.BigInt: ...
    def reduce(self, unsignedTransaction: 'UnsignedTransaction', int: int) -> 'ReducedTransaction': ...
    @typing.overload
    def sign(self, unsignedTransaction: 'UnsignedTransaction') -> 'SignedTransaction': ...
    @typing.overload
    def sign(self, unsignedTransaction: 'UnsignedTransaction', int: int) -> 'SignedTransaction': ...
    @typing.overload
    def signMessage(self, p2PKAddress: org.ergoplatform.P2PKAddress, byteArray: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> typing.List[int]: ...
    @typing.overload
    def signMessage(self, sigmaBoolean: sigmastate.Values.SigmaBoolean, byteArray: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> typing.List[int]: ...
    def signReduced(self, reducedTransaction: 'ReducedTransaction', int: int) -> 'SignedTransaction': ...

class ErgoProverBuilder:
    def build(self) -> ErgoProver: ...
    def withDHTData(self, groupElement: special.sigma.GroupElement, groupElement2: special.sigma.GroupElement, groupElement3: special.sigma.GroupElement, groupElement4: special.sigma.GroupElement, bigInteger: java.math.BigInteger) -> 'ErgoProverBuilder': ...
    def withDLogSecret(self, bigInteger: java.math.BigInteger) -> 'ErgoProverBuilder': ...
    def withEip3Secret(self, int: int) -> 'ErgoProverBuilder': ...
    @typing.overload
    def withMnemonic(self, mnemonic: 'Mnemonic') -> 'ErgoProverBuilder': ...
    @typing.overload
    def withMnemonic(self, secretString: 'SecretString', secretString2: 'SecretString') -> 'ErgoProverBuilder': ...
    def withSecretStorage(self, secretStorage: 'SecretStorage') -> 'ErgoProverBuilder': ...

class ErgoToken:
    @typing.overload
    def __init__(self, byteArray: typing.List[int], long: int): ...
    @typing.overload
    def __init__(self, string: str, long: int): ...
    @typing.overload
    def __init__(self, ergoId: ErgoId, long: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getId(self) -> ErgoId: ...
    def getValue(self) -> int: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class ErgoTreeTemplate:
    def applyParameters(self, ergoValue: 'ErgoValue'[typing.Any]) -> sigmastate.Values.ErgoTree: ...
    def equals(self, object: typing.Any) -> bool: ...
    @staticmethod
    def fromErgoTree(ergoTree: sigmastate.Values.ErgoTree) -> 'ErgoTreeTemplate': ...
    def getBytes(self) -> typing.List[int]: ...
    def getEncodedBytes(self) -> str: ...
    def getParameterCount(self) -> int: ...
    def getParameterTypes(self) -> java.util.List['ErgoType'[typing.Any]]: ...
    def hashCode(self) -> int: ...

_ErgoType__T = typing.TypeVar('_ErgoType__T')  # <T>
class ErgoType(typing.Generic[_ErgoType__T]):
    @staticmethod
    def avlTreeType() -> 'ErgoType'[special.sigma.AvlTree]: ...
    @staticmethod
    def bigIntType() -> 'ErgoType'[special.sigma.BigInt]: ...
    @staticmethod
    def booleanType() -> 'ErgoType'[scala.Boolean]: ...
    @staticmethod
    def boxType() -> 'ErgoType'[special.sigma.Box]: ...
    @staticmethod
    def byteType() -> 'ErgoType'[scala.Byte]: ...
    _collType__A = typing.TypeVar('_collType__A')  # <A>
    @staticmethod
    def collType(ergoType: 'ErgoType'[_collType__A]) -> 'ErgoType'[special.collection.Coll[_collType__A]]: ...
    def equals(self, object: typing.Any) -> bool: ...
    def getRType(self) -> scalan.RType[_ErgoType__T]: ...
    @staticmethod
    def groupElementType() -> 'ErgoType'[special.sigma.GroupElement]: ...
    def hashCode(self) -> int: ...
    @staticmethod
    def headerType() -> 'ErgoType'[special.sigma.Header]: ...
    @staticmethod
    def integerType() -> 'ErgoType'[scala.Int]: ...
    @staticmethod
    def longType() -> 'ErgoType'[scala.Long]: ...
    _optionType__A = typing.TypeVar('_optionType__A')  # <A>
    @staticmethod
    def optionType(ergoType: 'ErgoType'[_optionType__A]) -> 'ErgoType'[scala.Option[_optionType__A]]: ...
    _pairType__A = typing.TypeVar('_pairType__A')  # <A>
    _pairType__B = typing.TypeVar('_pairType__B')  # <B>
    @staticmethod
    def pairType(ergoType: 'ErgoType'[_pairType__A], ergoType2: 'ErgoType'[_pairType__B]) -> 'ErgoType'[scala.Tuple2[_pairType__A, _pairType__B]]: ...
    @staticmethod
    def preHeaderType() -> 'ErgoType'['PreHeader']: ...
    @staticmethod
    def shortType() -> 'ErgoType'[scala.Short]: ...
    @staticmethod
    def sigmaPropType() -> 'ErgoType'[special.sigma.SigmaProp]: ...

_ErgoValue__T = typing.TypeVar('_ErgoValue__T')  # <T>
class ErgoValue(typing.Generic[_ErgoValue__T]):
    def equals(self, object: typing.Any) -> bool: ...
    @staticmethod
    def fromHex(string: str) -> 'ErgoValue'[typing.Any]: ...
    def getType(self) -> ErgoType[_ErgoValue__T]: ...
    def getValue(self) -> _ErgoValue__T: ...
    def hashCode(self) -> int: ...
    _of_4__T = typing.TypeVar('_of_4__T')  # <T>
    _of_12__T = typing.TypeVar('_of_12__T')  # <T>
    @typing.overload
    @staticmethod
    def of(boolean: bool) -> 'ErgoValue'[scala.Boolean]: ...
    @typing.overload
    @staticmethod
    def of(byte: int) -> 'ErgoValue'[scala.Byte]: ...
    @typing.overload
    @staticmethod
    def of(byteArray: typing.List[int]) -> 'ErgoValue'[special.collection.Coll[scala.Byte]]: ...
    @typing.overload
    @staticmethod
    def of(int: int) -> 'ErgoValue'[scala.Int]: ...
    @typing.overload
    @staticmethod
    def of(tArray: typing.List[_of_4__T], ergoType: ErgoType[_of_4__T]) -> 'ErgoValue'[special.collection.Coll[_of_4__T]]: ...
    @typing.overload
    @staticmethod
    def of(bigInteger: java.math.BigInteger) -> 'ErgoValue'[special.sigma.BigInt]: ...
    @typing.overload
    @staticmethod
    def of(long: int) -> 'ErgoValue'[scala.Long]: ...
    @typing.overload
    @staticmethod
    def of(eCPoint: org.bouncycastle.math.ec.ECPoint) -> 'ErgoValue'[special.sigma.GroupElement]: ...
    @typing.overload
    @staticmethod
    def of(ergoBox: org.ergoplatform.ErgoBox) -> 'ErgoValue'[special.sigma.Box]: ...
    @typing.overload
    @staticmethod
    def of(short: int) -> 'ErgoValue'[scala.Short]: ...
    @typing.overload
    @staticmethod
    def of(avlTreeData: sigmastate.AvlTreeData) -> 'ErgoValue'[special.sigma.AvlTree]: ...
    @typing.overload
    @staticmethod
    def of(sigmaBoolean: sigmastate.Values.SigmaBoolean) -> 'ErgoValue'[special.sigma.SigmaProp]: ...
    @typing.overload
    @staticmethod
    def of(coll: special.collection.Coll[_of_12__T], ergoType: ErgoType[_of_12__T]) -> 'ErgoValue'[special.collection.Coll[_of_12__T]]: ...
    @typing.overload
    @staticmethod
    def of(groupElement: special.sigma.GroupElement) -> 'ErgoValue'[special.sigma.GroupElement]: ...
    @staticmethod
    def pairOf(ergoValue: 'ErgoValue', ergoValue2: 'ErgoValue') -> 'ErgoValue'[scala.Tuple2]: ...
    def toHex(self) -> str: ...

class ErgoWallet:
    def getUnspentBoxes(self, long: int) -> java.util.Optional[java.util.List['InputBox']]: ...

class ExtendedInputBox(scala.Product, scala.Serializable):
    def __init__(self, box: org.ergoplatform.ErgoBox, extension: sigmastate.interpreter.ContextExtension): ...
    @staticmethod
    def apply(box: org.ergoplatform.ErgoBox, extension: sigmastate.interpreter.ContextExtension) -> 'ExtendedInputBox': ...
    def box(self) -> org.ergoplatform.ErgoBox: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, box: org.ergoplatform.ErgoBox, extension: sigmastate.interpreter.ContextExtension) -> 'ExtendedInputBox': ...
    def copy$default$1(self) -> org.ergoplatform.ErgoBox: ...
    def copy$default$2(self) -> sigmastate.interpreter.ContextExtension: ...
    @staticmethod
    def curried() -> scala.Function1[org.ergoplatform.ErgoBox, scala.Function1[sigmastate.interpreter.ContextExtension, 'ExtendedInputBox']]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def extension(self) -> sigmastate.interpreter.ContextExtension: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> str: ...
    def toString(self) -> str: ...
    def toUnsignedInput(self) -> org.ergoplatform.UnsignedInput: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[org.ergoplatform.ErgoBox, sigmastate.interpreter.ContextExtension], 'ExtendedInputBox']: ...
    @staticmethod
    def unapply(x$0: 'ExtendedInputBox') -> scala.Option[scala.Tuple2[org.ergoplatform.ErgoBox, sigmastate.interpreter.ContextExtension]]: ...

_Helpers__AppkitTryOps__A = typing.TypeVar('_Helpers__AppkitTryOps__A')  # <A>
class Helpers:
    class AppkitTryOps(typing.Generic[_Helpers__AppkitTryOps__A]):
        def __init__(self, source: scala.util.Try[_Helpers__AppkitTryOps__A]): ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        _mapOrThrow__B = typing.TypeVar('_mapOrThrow__B')  # <B>
        def mapOrThrow(self, f: scala.Function1[_Helpers__AppkitTryOps__A, _mapOrThrow__B]) -> _mapOrThrow__B: ...
        def source(self) -> scala.util.Try[_Helpers__AppkitTryOps__A]: ...
    class AppkitTryOps$:
        MODULE$: typing.ClassVar['Helpers.AppkitTryOps.'] = ...
        def __init__(self): ...
        _equals$extension__A = typing.TypeVar('_equals$extension__A')  # <A>
        def equals$extension(self, $this: scala.util.Try[_equals.extension__A], x$1: typing.Any) -> bool: ...
        _hashCode$extension__A = typing.TypeVar('_hashCode$extension__A')  # <A>
        def hashCode$extension(self, $this: scala.util.Try[_hashCode.extension__A]) -> int: ...
        _mapOrThrow$extension__B = typing.TypeVar('_mapOrThrow$extension__B')  # <B>
        _mapOrThrow$extension__A = typing.TypeVar('_mapOrThrow$extension__A')  # <A>
        def mapOrThrow$extension(self, $this: scala.util.Try[_mapOrThrow.extension__A], f: scala.Function1[_mapOrThrow.extension__A, _mapOrThrow.extension__B]) -> _mapOrThrow.extension__B: ...

_Iso__A = typing.TypeVar('_Iso__A')  # <A>
_Iso__B = typing.TypeVar('_Iso__B')  # <B>
class Iso(typing.Generic[_Iso__A, _Iso__B]):
    def __init__(self): ...
    _JListToColl__A = typing.TypeVar('_JListToColl__A')  # <A>
    _JListToColl__B = typing.TypeVar('_JListToColl__B')  # <B>
    @staticmethod
    def JListToColl(itemIso: 'Iso'[_JListToColl__A, _JListToColl__B], tB: scalan.RType[_JListToColl__B]) -> 'Iso'[java.util.List[_JListToColl__A], special.collection.Coll[_JListToColl__B]]: ...
    _JListToIndexedSeq__A = typing.TypeVar('_JListToIndexedSeq__A')  # <A>
    _JListToIndexedSeq__B = typing.TypeVar('_JListToIndexedSeq__B')  # <B>
    @staticmethod
    def JListToIndexedSeq(itemIso: 'Iso'[_JListToIndexedSeq__A, _JListToIndexedSeq__B]) -> 'Iso'[java.util.List[_JListToIndexedSeq__A], scala.collection.IndexedSeq[_JListToIndexedSeq__B]]: ...
    _andThen__C = typing.TypeVar('_andThen__C')  # <C>
    def andThen(self, iso: 'Iso'[_Iso__B, _andThen__C]) -> 'Iso'[_Iso__A, _andThen__C]: ...
    @staticmethod
    def arrayCharToOptionString() -> 'Iso'['SecretString', scala.Option[str]]: ...
    _identityIso__A = typing.TypeVar('_identityIso__A')  # <A>
    @staticmethod
    def identityIso() -> 'Iso'[_identityIso__A, _identityIso__A]: ...
    _inverseIso__A = typing.TypeVar('_inverseIso__A')  # <A>
    _inverseIso__B = typing.TypeVar('_inverseIso__B')  # <B>
    @staticmethod
    def inverseIso(iso: 'Iso'[_inverseIso__A, _inverseIso__B]) -> 'Iso'[_inverseIso__B, _inverseIso__A]: ...
    @staticmethod
    def isoContextVarsToContextExtension() -> 'Iso'[java.util.List[ContextVar], sigmastate.interpreter.ContextExtension]: ...
    @staticmethod
    def isoErgoTokenToPair() -> 'Iso'[ErgoToken, scala.Tuple2[typing.List[int], typing.Any]]: ...
    @staticmethod
    def isoErgoTypeToSType() -> 'Iso'[ErgoType[typing.Any], sigmastate.SType]: ...
    @staticmethod
    def isoErgoValueToSValue() -> 'Iso'[ErgoValue[typing.Any], sigmastate.Values.EvaluatedValue[sigmastate.SType]]: ...
    @staticmethod
    def isoEvaluatedValueToSConstant() -> 'Iso'[sigmastate.Values.EvaluatedValue[sigmastate.SType], sigmastate.Values.Constant[sigmastate.SType]]: ...
    @staticmethod
    def isoJListErgoTokenToMapPair() -> 'Iso'[java.util.List[ErgoToken], scala.collection.mutable.LinkedHashMap[str, typing.Any]]: ...
    _isoJMapToMap__K = typing.TypeVar('_isoJMapToMap__K')  # <K>
    _isoJMapToMap__V1 = typing.TypeVar('_isoJMapToMap__V1')  # <V1>
    _isoJMapToMap__V2 = typing.TypeVar('_isoJMapToMap__V2')  # <V2>
    @staticmethod
    def isoJMapToMap(iso: 'Iso'[_isoJMapToMap__V1, _isoJMapToMap__V2]) -> 'Iso'[java.util.Map[_isoJMapToMap__K, _isoJMapToMap__V1], scala.collection.Map[_isoJMapToMap__K, _isoJMapToMap__V2]]: ...
    @staticmethod
    def isoTokensListToPairsColl() -> 'Iso'[java.util.List[ErgoToken], special.collection.Coll[scala.Tuple2[typing.List[int], typing.Any]]]: ...
    @staticmethod
    def jboolToBool() -> 'Iso'[bool, typing.Any]: ...
    @staticmethod
    def jbyteToByte() -> 'Iso'[int, typing.Any]: ...
    @staticmethod
    def jintToInt() -> 'Iso'[int, typing.Any]: ...
    @staticmethod
    def jlongToLong() -> 'Iso'[int, typing.Any]: ...
    @staticmethod
    def jshortToShort() -> 'Iso'[int, typing.Any]: ...
    @staticmethod
    def jstringToOptionString() -> 'Iso'[str, scala.Option[str]]: ...
    def to(self, a: _Iso__A) -> _Iso__B: ...

_JavaHelpers__ListOps__A = typing.TypeVar('_JavaHelpers__ListOps__A')  # <A>
_JavaHelpers__UniversalConverter__A = typing.TypeVar('_JavaHelpers__UniversalConverter__A')  # <A>
class JavaHelpers:
    @staticmethod
    def Algos() -> org.ergoplatform.settings.ErgoAlgos: ...
    @staticmethod
    def AvlTreeRType() -> scalan.RType[special.sigma.AvlTree]: ...
    @staticmethod
    def BigIntRType() -> scalan.RType[special.sigma.BigInt]: ...
    @staticmethod
    def BoxRType() -> scalan.RType[special.sigma.Box]: ...
    @staticmethod
    def GroupElementRType() -> scalan.RType[special.sigma.GroupElement]: ...
    @staticmethod
    def HeaderRType() -> scalan.RType[special.sigma.Header]: ...
    @staticmethod
    def PreHeaderRType() -> scalan.RType[special.sigma.PreHeader]: ...
    @staticmethod
    def SigmaDsl() -> sigmastate.eval.CostingSigmaDslBuilder: ...
    @staticmethod
    def SigmaPropRType() -> scalan.RType[special.sigma.SigmaProp]: ...
    @staticmethod
    def TokenIdRType() -> scalan.RType[typing.List[int]]: ...
    @staticmethod
    def collFrom(arr: typing.List[int]) -> special.collection.Coll[typing.Any]: ...
    _collRType__T = typing.TypeVar('_collRType__T')  # <T>
    @staticmethod
    def collRType(tItem: scalan.RType[_collRType__T]) -> scalan.RType[special.collection.Coll[_collRType__T]]: ...
    @staticmethod
    def collToByteArray(in_: special.collection.Coll[typing.Any]) -> typing.List[int]: ...
    @staticmethod
    def compile(constants: typing.Union[java.util.Map[str, typing.Any], typing.Mapping[str, typing.Any]], contractText: str, networkPrefix: int) -> sigmastate.Values.ErgoTree: ...
    @staticmethod
    def createBoxCandidate(value: int, tree: sigmastate.Values.ErgoTree, tokens: scala.collection.Seq[ErgoToken], registers: scala.collection.Seq[ErgoValue[typing.Any]], creationHeight: int) -> org.ergoplatform.ErgoBoxCandidate: ...
    @staticmethod
    def createDataInput(boxIdBytes: typing.List[int]) -> org.ergoplatform.DataInput: ...
    @typing.overload
    @staticmethod
    def createDiffieHellmanTupleProverInput(g: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, h: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, u: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, v: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, x: java.math.BigInteger) -> sigmastate.basics.DiffieHellmanTupleProverInput: ...
    @typing.overload
    @staticmethod
    def createDiffieHellmanTupleProverInput(g: special.sigma.GroupElement, h: special.sigma.GroupElement, u: special.sigma.GroupElement, v: special.sigma.GroupElement, x: java.math.BigInteger) -> sigmastate.basics.DiffieHellmanTupleProverInput: ...
    @staticmethod
    def createP2PKAddress(pk: sigmastate.basics.DLogProtocol.ProveDlog, networkPrefix: int) -> org.ergoplatform.P2PKAddress: ...
    @staticmethod
    def createP2SAddress(ergoTree: sigmastate.Values.ErgoTree, networkPrefix: int) -> org.ergoplatform.Pay2SAddress: ...
    @staticmethod
    def createTokensMap(linkedMap: scala.collection.mutable.LinkedHashMap[str, typing.Any]) -> scala.collection.immutable.Map[str, typing.Any]: ...
    @typing.overload
    @staticmethod
    def createUnsignedInput(boxIdBytes: typing.List[int]) -> org.ergoplatform.UnsignedInput: ...
    @typing.overload
    @staticmethod
    def createUnsignedInput(boxId: str) -> org.ergoplatform.UnsignedInput: ...
    @staticmethod
    def decodeStringToBytes(base16: str) -> typing.List[int]: ...
    @staticmethod
    def decodeStringToColl(base16: str) -> special.collection.Coll[typing.Any]: ...
    @staticmethod
    def decodeStringToErgoTree(base16: str) -> sigmastate.Values.ErgoTree: ...
    @staticmethod
    def decodeStringToGE(base16: str) -> special.sigma.GroupElement: ...
    _deserializeValue__T = typing.TypeVar('_deserializeValue__T', bound=sigmastate.Values.Value)  # <T>
    @staticmethod
    def deserializeValue(bytes: typing.List[int]) -> _deserializeValue__T: ...
    @staticmethod
    def eip3DerivationParent() -> org.ergoplatform.wallet.secrets.DerivationPath: ...
    @staticmethod
    def eip3DerivationWithLastIndex(index: int) -> org.ergoplatform.wallet.secrets.DerivationPath: ...
    @staticmethod
    def ergoTreeTemplateBytes(ergoTree: sigmastate.Values.ErgoTree) -> typing.List[int]: ...
    @staticmethod
    def extractAssets(boxes: scala.collection.IndexedSeq[org.ergoplatform.ErgoBoxCandidate]) -> scala.Tuple2[scala.collection.immutable.Map[scala.collection.Seq[typing.Any], typing.Any], typing.Any]: ...
    @staticmethod
    def getBoxRegisters(ergoBox: org.ergoplatform.ErgoBoxCandidate) -> java.util.List[ErgoValue[typing.Any]]: ...
    @staticmethod
    def getStateDigest(tree: special.sigma.AvlTree) -> typing.List[int]: ...
    @staticmethod
    def hash(s: str) -> str: ...
    @staticmethod
    def mnemonicToSeed(mnemonic: str, passOpt: scala.Option[str]) -> typing.List[int]: ...
    @staticmethod
    def mnemonicToSeed$default$2() -> scala.Option[str]: ...
    @staticmethod
    def secretStringToOption(secretString: org.ergoplatform.wallet.interface4j.SecretString) -> scala.Option[org.ergoplatform.wallet.interface4j.SecretString]: ...
    @staticmethod
    def seedToMasterKey(seedPhrase: 'SecretString', pass_: 'SecretString') -> org.ergoplatform.wallet.secrets.ExtendedSecretKey: ...
    @staticmethod
    def seedToMasterKey$default$2() -> 'SecretString': ...
    _toIndexedSeq__T = typing.TypeVar('_toIndexedSeq__T')  # <T>
    @staticmethod
    def toIndexedSeq(xs: java.util.List[_toIndexedSeq__T]) -> scala.collection.IndexedSeq[_toIndexedSeq__T]: ...
    @staticmethod
    def toPreHeader(h: special.sigma.Header) -> special.sigma.PreHeader: ...
    class ListOps(typing.Generic[_JavaHelpers__ListOps__A]):
        def __init__(self, xs: java.util.List[_JavaHelpers__ListOps__A]): ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        _map__B = typing.TypeVar('_map__B')  # <B>
        def map(self, f: scala.Function1[_JavaHelpers__ListOps__A, _map__B]) -> java.util.List[_map__B]: ...
        def xs(self) -> java.util.List[_JavaHelpers__ListOps__A]: ...
    class ListOps$:
        MODULE$: typing.ClassVar['JavaHelpers.ListOps.'] = ...
        def __init__(self): ...
        _equals$extension__A = typing.TypeVar('_equals$extension__A')  # <A>
        def equals$extension(self, $this: java.util.List[_equals.extension__A], x$1: typing.Any) -> bool: ...
        _hashCode$extension__A = typing.TypeVar('_hashCode$extension__A')  # <A>
        def hashCode$extension(self, $this: java.util.List[_hashCode.extension__A]) -> int: ...
        _map$extension__B = typing.TypeVar('_map$extension__B')  # <B>
        _map$extension__A = typing.TypeVar('_map$extension__A')  # <A>
        def map$extension(self, $this: java.util.List[_map.extension__A], f: scala.Function1[_map.extension__A, _map.extension__B]) -> java.util.List[_map.extension__B]: ...
    class StringExtensions:
        def __init__(self, base16: str): ...
        def base16(self) -> str: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toBytes(self) -> typing.List[int]: ...
        def toColl(self) -> special.collection.Coll[typing.Any]: ...
        def toErgoTree(self) -> sigmastate.Values.ErgoTree: ...
        def toGroupElement(self) -> special.sigma.GroupElement: ...
    class StringExtensions$:
        MODULE$: typing.ClassVar['JavaHelpers.StringExtensions.'] = ...
        def __init__(self): ...
        def equals$extension(self, $this: str, x$1: typing.Any) -> bool: ...
        def hashCode$extension(self, $this: str) -> int: ...
        def toBytes$extension(self, $this: str) -> typing.List[int]: ...
        def toColl$extension(self, $this: str) -> special.collection.Coll[typing.Any]: ...
        def toErgoTree$extension(self, $this: str) -> sigmastate.Values.ErgoTree: ...
        def toGroupElement$extension(self, $this: str) -> special.sigma.GroupElement: ...
    class UniversalConverter(typing.Generic[_JavaHelpers__UniversalConverter__A]):
        def __init__(self, x: _JavaHelpers__UniversalConverter__A): ...
        _convertTo__B = typing.TypeVar('_convertTo__B')  # <B>
        def convertTo(self, iso: Iso[_JavaHelpers__UniversalConverter__A, _convertTo__B]) -> _convertTo__B: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def x(self) -> _JavaHelpers__UniversalConverter__A: ...
    class UniversalConverter$:
        MODULE$: typing.ClassVar['JavaHelpers.UniversalConverter.'] = ...
        def __init__(self): ...
        _convertTo$extension__B = typing.TypeVar('_convertTo$extension__B')  # <B>
        _convertTo$extension__A = typing.TypeVar('_convertTo$extension__A')  # <A>
        def convertTo$extension(self, $this: _convertTo.extension__A, iso: Iso[_convertTo.extension__A, _convertTo.extension__B]) -> _convertTo.extension__B: ...
        _equals$extension__A = typing.TypeVar('_equals$extension__A')  # <A>
        def equals$extension(self, $this: _equals.extension__A, x$1: typing.Any) -> bool: ...
        _hashCode$extension__A = typing.TypeVar('_hashCode$extension__A')  # <A>
        def hashCode$extension(self, $this: _hashCode.extension__A) -> int: ...

class LowPriorityIsos: ...

class Mnemonic:
    LANGUAGE_ID_ENGLISH: typing.ClassVar[str] = ...
    DEFAULT_STRENGTH: typing.ClassVar[int] = ...
    @staticmethod
    def checkEnglishMnemonic(list: java.util.List[str]) -> None: ...
    @typing.overload
    @staticmethod
    def create(charArray: typing.List[str], charArray2: typing.List[str]) -> 'Mnemonic': ...
    @typing.overload
    @staticmethod
    def create(secretString: 'SecretString', secretString2: 'SecretString') -> 'Mnemonic': ...
    @staticmethod
    def generate(string: str, int: int, byteArray: typing.List[int]) -> str: ...
    @staticmethod
    def generateEnglishMnemonic() -> str: ...
    @staticmethod
    def getEntropy(int: int) -> typing.List[int]: ...
    def getPassword(self) -> 'SecretString': ...
    def getPhrase(self) -> 'SecretString': ...
    @staticmethod
    def toEntropy(string: str, list: java.util.List[str]) -> typing.List[int]: ...
    def toSeed(self) -> typing.List[int]: ...

class NetworkType(java.lang.Enum['NetworkType']):
    MAINNET: typing.ClassVar['NetworkType'] = ...
    TESTNET: typing.ClassVar['NetworkType'] = ...
    networkPrefix: int = ...
    verboseName: str = ...
    @staticmethod
    def fromValue(string: str) -> 'NetworkType': ...
    _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
    @typing.overload
    @staticmethod
    def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
    @typing.overload
    @staticmethod
    def valueOf(string: str) -> 'NetworkType': ...
    @staticmethod
    def values() -> typing.List['NetworkType']: ...

class OutBoxBuilder:
    def build(self) -> 'OutBox': ...
    def contract(self, ergoContract: ErgoContract) -> 'OutBoxBuilder': ...
    def creationHeight(self, int: int) -> 'OutBoxBuilder': ...
    def mintToken(self, eip4Token: 'Eip4Token') -> 'OutBoxBuilder': ...
    def registers(self, ergoValueArray: typing.List[ErgoValue[typing.Any]]) -> 'OutBoxBuilder': ...
    def tokens(self, ergoTokenArray: typing.List[ErgoToken]) -> 'OutBoxBuilder': ...
    def value(self, long: int) -> 'OutBoxBuilder': ...

class Parameters:
    MinerRewardDelay_Mainnet: typing.ClassVar[int] = ...
    MinerRewardDelay_Testnet: typing.ClassVar[int] = ...
    OneErg: typing.ClassVar[int] = ...
    MinFee: typing.ClassVar[int] = ...
    MinChangeValue: typing.ClassVar[int] = ...
    def __init__(self): ...

class PreHeader:
    def getHeight(self) -> int: ...
    def getMinerPk(self) -> special.sigma.GroupElement: ...
    def getNBits(self) -> int: ...
    def getParentId(self) -> special.collection.Coll[int]: ...
    def getTimestamp(self) -> int: ...
    def getVersion(self) -> int: ...
    def getVotes(self) -> special.collection.Coll[int]: ...

class PreHeaderBuilder:
    def build(self) -> PreHeader: ...
    def height(self, integer: int) -> 'PreHeaderBuilder': ...
    def minerPk(self, groupElement: special.sigma.GroupElement) -> 'PreHeaderBuilder': ...
    def nBits(self, long: int) -> 'PreHeaderBuilder': ...
    def parentId(self, coll: special.collection.Coll[int]) -> 'PreHeaderBuilder': ...
    def timestamp(self, long: int) -> 'PreHeaderBuilder': ...
    def version(self, byte: int) -> 'PreHeaderBuilder': ...
    def votes(self, coll: special.collection.Coll[int]) -> 'PreHeaderBuilder': ...

class ReducedErgoLikeTransaction(scala.Product, scala.Serializable):
    def __init__(self, unsignedTx: org.ergoplatform.UnsignedErgoLikeTransaction, reducedInputs: scala.collection.Seq['ReducedInputData']): ...
    @staticmethod
    def apply(unsignedTx: org.ergoplatform.UnsignedErgoLikeTransaction, reducedInputs: scala.collection.Seq['ReducedInputData']) -> 'ReducedErgoLikeTransaction': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, unsignedTx: org.ergoplatform.UnsignedErgoLikeTransaction, reducedInputs: scala.collection.Seq['ReducedInputData']) -> 'ReducedErgoLikeTransaction': ...
    def copy$default$1(self) -> org.ergoplatform.UnsignedErgoLikeTransaction: ...
    def copy$default$2(self) -> scala.collection.Seq['ReducedInputData']: ...
    @staticmethod
    def curried() -> scala.Function1[org.ergoplatform.UnsignedErgoLikeTransaction, scala.Function1[scala.collection.Seq['ReducedInputData'], 'ReducedErgoLikeTransaction']]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> str: ...
    def reducedInputs(self) -> scala.collection.Seq['ReducedInputData']: ...
    def toString(self) -> str: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[org.ergoplatform.UnsignedErgoLikeTransaction, scala.collection.Seq['ReducedInputData']], 'ReducedErgoLikeTransaction']: ...
    @staticmethod
    def unapply(x$0: 'ReducedErgoLikeTransaction') -> scala.Option[scala.Tuple2[org.ergoplatform.UnsignedErgoLikeTransaction, scala.collection.Seq['ReducedInputData']]]: ...
    def unsignedTx(self) -> org.ergoplatform.UnsignedErgoLikeTransaction: ...

class ReducedErgoLikeTransactionSerializer:
    @staticmethod
    def error(msg: str) -> scala.runtime.Nothing.: ...
    @staticmethod
    def fromBytes(bytes: typing.List[int]) -> typing.Any: ...
    @staticmethod
    def parse(r: sigmastate.utils.SigmaByteReader) -> ReducedErgoLikeTransaction: ...
    @staticmethod
    def parseTry(r: scorex.util.serialization.Reader) -> scala.util.Try: ...
    @staticmethod
    def parseWithGenericReader(r: scorex.util.serialization.Reader, vs: org.ergoplatform.validation.SigmaValidationSettings) -> typing.Any: ...
    @staticmethod
    def serialize(tx: ReducedErgoLikeTransaction, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    @staticmethod
    def serializeWithGenericWriter(obj: typing.Any, w: scorex.util.serialization.Writer) -> None: ...
    @staticmethod
    def toBytes(obj: typing.Any) -> typing.List[int]: ...

class ReducedInputData(scala.Product, scala.Serializable):
    def __init__(self, reductionResult: sigmastate.interpreter.Interpreter.ReductionResult, extension: sigmastate.interpreter.ContextExtension): ...
    @staticmethod
    def apply(reductionResult: sigmastate.interpreter.Interpreter.ReductionResult, extension: sigmastate.interpreter.ContextExtension) -> 'ReducedInputData': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, reductionResult: sigmastate.interpreter.Interpreter.ReductionResult, extension: sigmastate.interpreter.ContextExtension) -> 'ReducedInputData': ...
    def copy$default$1(self) -> sigmastate.interpreter.Interpreter.ReductionResult: ...
    def copy$default$2(self) -> sigmastate.interpreter.ContextExtension: ...
    @staticmethod
    def curried() -> scala.Function1[sigmastate.interpreter.Interpreter.ReductionResult, scala.Function1[sigmastate.interpreter.ContextExtension, 'ReducedInputData']]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def extension(self) -> sigmastate.interpreter.ContextExtension: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> str: ...
    def reductionResult(self) -> sigmastate.interpreter.Interpreter.ReductionResult: ...
    def toString(self) -> str: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[sigmastate.interpreter.Interpreter.ReductionResult, sigmastate.interpreter.ContextExtension], 'ReducedInputData']: ...
    @staticmethod
    def unapply(x$0: 'ReducedInputData') -> scala.Option[scala.Tuple2[sigmastate.interpreter.Interpreter.ReductionResult, sigmastate.interpreter.ContextExtension]]: ...

class SecretStorage:
    DEFAULT_SETTINGS: typing.ClassVar[org.ergoplatform.wallet.settings.EncryptionSettings] = ...
    @typing.overload
    @staticmethod
    def createFromMnemonicIn(string: str, mnemonic: Mnemonic, string2: str) -> 'SecretStorage': ...
    @typing.overload
    @staticmethod
    def createFromMnemonicIn(string: str, mnemonic: Mnemonic, secretString: 'SecretString') -> 'SecretStorage': ...
    def getAddressFor(self, networkType: NetworkType) -> Address: ...
    def getFile(self) -> java.io.File: ...
    def getSecret(self) -> org.ergoplatform.wallet.secrets.ExtendedSecretKey: ...
    def isLocked(self) -> bool: ...
    @typing.overload
    @staticmethod
    def loadFrom(file: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> 'SecretStorage': ...
    @typing.overload
    @staticmethod
    def loadFrom(string: str) -> 'SecretStorage': ...
    @typing.overload
    def unlock(self, string: str) -> None: ...
    @typing.overload
    def unlock(self, secretString: 'SecretString') -> None: ...

class SecretString:
    @typing.overload
    @staticmethod
    def create(charArray: typing.List[str]) -> 'SecretString': ...
    @typing.overload
    @staticmethod
    def create(string: str) -> 'SecretString': ...
    @staticmethod
    def empty() -> 'SecretString': ...
    def equals(self, object: typing.Any) -> bool: ...
    def erase(self) -> None: ...
    def getData(self) -> typing.List[str]: ...
    def hashCode(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def toInterface4JSecretString(self) -> org.ergoplatform.wallet.interface4j.SecretString: ...
    def toStringUnsecure(self) -> str: ...

class SelectTokensHelper:
    def __init__(self, iterable: typing.Union[java.lang.Iterable[ErgoToken], typing.Sequence[ErgoToken], typing.Set[ErgoToken]]): ...
    def areTokensCovered(self) -> bool: ...
    def areTokensNeeded(self, iterable: typing.Union[java.lang.Iterable[ErgoToken], typing.Sequence[ErgoToken], typing.Set[ErgoToken]]) -> bool: ...
    def getRemainingTokenList(self) -> java.util.List[ErgoToken]: ...
    def isChangeBoxNeeded(self) -> bool: ...
    def useTokens(self, iterable: typing.Union[java.lang.Iterable[ErgoToken], typing.Sequence[ErgoToken], typing.Set[ErgoToken]]) -> None: ...

class Signature:
    @typing.overload
    @staticmethod
    def verifySignature(p2PKAddress: org.ergoplatform.P2PKAddress, byteArray: typing.List[int], byteArray2: typing.List[int]) -> bool: ...
    @typing.overload
    @staticmethod
    def verifySignature(sigmaBoolean: sigmastate.Values.SigmaBoolean, byteArray: typing.List[int], byteArray2: typing.List[int]) -> bool: ...

class SignedInput:
    def getContextVars(self) -> java.util.Map[int, ErgoValue[typing.Any]]: ...
    def getId(self) -> ErgoId: ...
    def getProofBytes(self) -> typing.List[int]: ...
    def getTransaction(self) -> 'SignedTransaction': ...

class Transaction:
    def getId(self) -> str: ...
    def getInputBoxesIds(self) -> java.util.List[str]: ...
    def getOutputs(self) -> java.util.List['OutBox']: ...

class TransactionBox:
    def getCreationHeight(self) -> int: ...
    def getErgoTree(self) -> sigmastate.Values.ErgoTree: ...
    def getRegisters(self) -> java.util.List[ErgoValue[typing.Any]]: ...
    def getTokens(self) -> java.util.List[ErgoToken]: ...
    def getValue(self) -> int: ...

class UnsignedTransactionBuilder:
    def boxesToSpend(self, list: java.util.List['InputBox']) -> 'UnsignedTransactionBuilder': ...
    def build(self) -> 'UnsignedTransaction': ...
    def fee(self, long: int) -> 'UnsignedTransactionBuilder': ...
    def getCtx(self) -> BlockchainContext: ...
    def getInputBoxes(self) -> java.util.List['InputBox']: ...
    def getNetworkType(self) -> NetworkType: ...
    def getPreHeader(self) -> PreHeader: ...
    def outBoxBuilder(self) -> OutBoxBuilder: ...
    def outputs(self, outBoxArray: typing.List['OutBox']) -> 'UnsignedTransactionBuilder': ...
    def preHeader(self, preHeader: PreHeader) -> 'UnsignedTransactionBuilder': ...
    def sendChangeTo(self, ergoAddress: org.ergoplatform.ErgoAddress) -> 'UnsignedTransactionBuilder': ...
    def tokensToBurn(self, ergoTokenArray: typing.List[ErgoToken]) -> 'UnsignedTransactionBuilder': ...
    def withDataInputs(self, list: java.util.List['InputBox']) -> 'UnsignedTransactionBuilder': ...

class ColdErgoClient(ErgoClient):
    def __init__(self, networkType: NetworkType, params: org.ergoplatform.restapi.client.Parameters): ...
    _execute__T = typing.TypeVar('_execute__T')  # <T>
    def execute(self, action: typing.Union[java.util.function.Function[BlockchainContext, _execute__T], typing.Callable[[BlockchainContext], _execute__T]]) -> _execute__T: ...

_ComposeIso__A = typing.TypeVar('_ComposeIso__A')  # <A>
_ComposeIso__B = typing.TypeVar('_ComposeIso__B')  # <B>
_ComposeIso__C = typing.TypeVar('_ComposeIso__C')  # <C>
class ComposeIso(Iso[_ComposeIso__A, _ComposeIso__C], scala.Product, scala.Serializable, typing.Generic[_ComposeIso__A, _ComposeIso__B, _ComposeIso__C]):
    def __init__(self, iso2: Iso[_ComposeIso__B, _ComposeIso__C], iso1: Iso[_ComposeIso__A, _ComposeIso__B]): ...
    _apply__A = typing.TypeVar('_apply__A')  # <A>
    _apply__B = typing.TypeVar('_apply__B')  # <B>
    _apply__C = typing.TypeVar('_apply__C')  # <C>
    @staticmethod
    def apply(iso2: Iso[_apply__B, _apply__C], iso1: Iso[_apply__A, _apply__B]) -> 'ComposeIso'[_apply__A, _apply__B, _apply__C]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _copy__A = typing.TypeVar('_copy__A')  # <A>
    _copy__B = typing.TypeVar('_copy__B')  # <B>
    _copy__C = typing.TypeVar('_copy__C')  # <C>
    def copy(self, iso2: Iso[typing.Any, typing.Any], iso1: Iso[typing.Any, typing.Any]) -> 'ComposeIso'[typing.Any, typing.Any, typing.Any]: ...
    _copy$default$1__A = typing.TypeVar('_copy$default$1__A')  # <A>
    _copy$default$1__B = typing.TypeVar('_copy$default$1__B')  # <B>
    _copy$default$1__C = typing.TypeVar('_copy$default$1__C')  # <C>
    def copy$default$1(self) -> Iso[typing.Any, typing.Any]: ...
    _copy$default$2__A = typing.TypeVar('_copy$default$2__A')  # <A>
    _copy$default$2__B = typing.TypeVar('_copy$default$2__B')  # <B>
    _copy$default$2__C = typing.TypeVar('_copy$default$2__C')  # <C>
    def copy$default$2(self) -> Iso[typing.Any, typing.Any]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def iso1(self) -> Iso[_ComposeIso__A, _ComposeIso__B]: ...
    def iso2(self) -> Iso[_ComposeIso__B, _ComposeIso__C]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> str: ...
    def to(self, a: _ComposeIso__A) -> _ComposeIso__C: ...
    def toString(self) -> str: ...
    _unapply__A = typing.TypeVar('_unapply__A')  # <A>
    _unapply__B = typing.TypeVar('_unapply__B')  # <B>
    _unapply__C = typing.TypeVar('_unapply__C')  # <C>
    @staticmethod
    def unapply(x$0: 'ComposeIso'[_unapply__A, _unapply__B, _unapply__C]) -> scala.Option[scala.Tuple2[Iso[_unapply__B, _unapply__C], Iso[_unapply__A, _unapply__B]]]: ...

class Eip4Token(ErgoToken):
    @typing.overload
    def __init__(self, string: str, long: int, string2: str, string3: str, int: int): ...
    @typing.overload
    def __init__(self, string: str, long: int, string2: str, string3: str, int: int, ergoValue: ErgoValue[typing.Any], ergoValue2: ErgoValue[typing.Any], ergoValue3: ErgoValue[typing.Any]): ...
    @typing.overload
    def __init__(self, string: str, long: int, ergoValue: ErgoValue[special.collection.Coll[typing.Any]], ergoValue2: ErgoValue[special.collection.Coll[typing.Any]], ergoValue3: ErgoValue[special.collection.Coll[typing.Any]], ergoValue4: ErgoValue[typing.Any], ergoValue5: ErgoValue[typing.Any], ergoValue6: ErgoValue[typing.Any]): ...
    def getAmountFormatted(self) -> str: ...
    def getAssetType(self) -> 'Eip4Token.AssetType': ...
    def getDecimals(self) -> int: ...
    def getMintingBoxR4(self) -> ErgoValue[special.collection.Coll[scala.Byte]]: ...
    def getMintingBoxR5(self) -> ErgoValue[special.collection.Coll[scala.Byte]]: ...
    def getMintingBoxR6(self) -> ErgoValue[special.collection.Coll[scala.Byte]]: ...
    def getMintingBoxR7(self) -> ErgoValue[typing.Any]: ...
    def getMintingBoxR8(self) -> ErgoValue[typing.Any]: ...
    def getMintingBoxR9(self) -> ErgoValue[typing.Any]: ...
    def getNftContentHash(self) -> typing.List[int]: ...
    def getNftContentLink(self) -> str: ...
    def getNftCoverImageLink(self) -> str: ...
    def getTokenDescription(self) -> str: ...
    def getTokenName(self) -> str: ...
    def isNftAssetType(self) -> bool: ...
    class AssetType(java.lang.Enum['Eip4Token.AssetType']):
        NONE: typing.ClassVar['Eip4Token.AssetType'] = ...
        NFT_PICTURE: typing.ClassVar['Eip4Token.AssetType'] = ...
        NFT_AUDIO: typing.ClassVar['Eip4Token.AssetType'] = ...
        NFT_VIDEO: typing.ClassVar['Eip4Token.AssetType'] = ...
        MEMBERSHIP_THRESHOLD_SIG: typing.ClassVar['Eip4Token.AssetType'] = ...
        UNKNOWN: typing.ClassVar['Eip4Token.AssetType'] = ...
        def getR7ByteArrayForType(self) -> typing.List[int]: ...
        _valueOf_0__T = typing.TypeVar('_valueOf_0__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_0__T], string: str) -> _valueOf_0__T: ...
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'Eip4Token.AssetType': ...
        @staticmethod
        def values() -> typing.List['Eip4Token.AssetType']: ...

class InputBox(TransactionBox):
    def getBytes(self) -> typing.List[int]: ...
    def getId(self) -> ErgoId: ...
    @typing.overload
    def toJson(self, boolean: bool) -> str: ...
    @typing.overload
    def toJson(self, boolean: bool, boolean2: bool) -> str: ...
    def withContextVars(self, contextVarArray: typing.List[ContextVar]) -> 'InputBox': ...

_InverseIso__A = typing.TypeVar('_InverseIso__A')  # <A>
_InverseIso__B = typing.TypeVar('_InverseIso__B')  # <B>
class InverseIso(Iso[_InverseIso__B, _InverseIso__A], scala.Product, scala.Serializable, typing.Generic[_InverseIso__A, _InverseIso__B]):
    def __init__(self, iso: Iso[_InverseIso__A, _InverseIso__B]): ...
    _apply__A = typing.TypeVar('_apply__A')  # <A>
    _apply__B = typing.TypeVar('_apply__B')  # <B>
    @staticmethod
    def apply(iso: Iso[_apply__A, _apply__B]) -> 'InverseIso'[_apply__A, _apply__B]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _copy__A = typing.TypeVar('_copy__A')  # <A>
    _copy__B = typing.TypeVar('_copy__B')  # <B>
    def copy(self, iso: Iso[typing.Any, typing.Any]) -> 'InverseIso'[typing.Any, typing.Any]: ...
    _copy$default$1__A = typing.TypeVar('_copy$default$1__A')  # <A>
    _copy$default$1__B = typing.TypeVar('_copy$default$1__B')  # <B>
    def copy$default$1(self) -> Iso[typing.Any, typing.Any]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def iso(self) -> Iso[_InverseIso__A, _InverseIso__B]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> str: ...
    def to(self, a: _InverseIso__B) -> _InverseIso__A: ...
    def toString(self) -> str: ...
    _unapply__A = typing.TypeVar('_unapply__A')  # <A>
    _unapply__B = typing.TypeVar('_unapply__B')  # <B>
    @staticmethod
    def unapply(x$0: 'InverseIso'[_unapply__A, _unapply__B]) -> scala.Option[Iso[_unapply__A, _unapply__B]]: ...

class OutBox(TransactionBox):
    def convertToInputWith(self, string: str, short: int) -> InputBox: ...
    def getBytesWithNoRef(self) -> typing.List[int]: ...

class ReducedTransaction(Transaction):
    def getCost(self) -> int: ...
    def getTx(self) -> ReducedErgoLikeTransaction: ...
    def toBytes(self) -> typing.List[int]: ...

class RestApiErgoClient(ErgoClient):
    defaultMainnetExplorerUrl: typing.ClassVar[str] = ...
    defaultTestnetExplorerUrl: typing.ClassVar[str] = ...
    @typing.overload
    @staticmethod
    def create(string: str, networkType: NetworkType, string2: str, string3: str) -> ErgoClient: ...
    @typing.overload
    @staticmethod
    def create(ergoNodeConfig: org.ergoplatform.appkit.config.ErgoNodeConfig, string: str) -> ErgoClient: ...
    @typing.overload
    @staticmethod
    def createWithProxy(string: str, networkType: NetworkType, string2: str, string3: str, proxy: java.net.Proxy) -> ErgoClient: ...
    @typing.overload
    @staticmethod
    def createWithProxy(ergoNodeConfig: org.ergoplatform.appkit.config.ErgoNodeConfig, string: str, proxy: java.net.Proxy) -> ErgoClient: ...
    @staticmethod
    def createWithoutExplorer(string: str, networkType: NetworkType, string2: str) -> ErgoClient: ...
    _execute__T = typing.TypeVar('_execute__T')  # <T>
    def execute(self, function: typing.Union[java.util.function.Function[BlockchainContext, _execute__T], typing.Callable[[BlockchainContext], _execute__T]]) -> _execute__T: ...
    @staticmethod
    def getDefaultExplorerUrl(networkType: NetworkType) -> str: ...

class SignedTransaction(Transaction):
    def getCost(self) -> int: ...
    def getOutputsToSpend(self) -> java.util.List[InputBox]: ...
    def getSignedInputs(self) -> java.util.List[SignedInput]: ...
    def toBytes(self) -> typing.List[int]: ...
    @typing.overload
    def toJson(self, boolean: bool) -> str: ...
    @typing.overload
    def toJson(self, boolean: bool, boolean2: bool) -> str: ...

class UnsignedTransaction(Transaction):
    def getChangeAddress(self) -> org.ergoplatform.ErgoAddress: ...
    def getDataInputs(self) -> java.util.List[InputBox]: ...
    def getInputs(self) -> java.util.List[InputBox]: ...

class BoxOperations:
    def buildTxWithDefaultInputs(self, function: typing.Union[java.util.function.Function[UnsignedTransactionBuilder, UnsignedTransactionBuilder], typing.Callable[[UnsignedTransactionBuilder], UnsignedTransactionBuilder]]) -> UnsignedTransaction: ...
    @staticmethod
    def createForEip3Prover(ergoProver: ErgoProver, blockchainContext: BlockchainContext) -> 'BoxOperations': ...
    @staticmethod
    def createForProver(ergoProver: ErgoProver, blockchainContext: BlockchainContext) -> 'BoxOperations': ...
    @staticmethod
    def createForSender(address: Address, blockchainContext: BlockchainContext) -> 'BoxOperations': ...
    @staticmethod
    def createForSenders(list: java.util.List[Address], blockchainContext: BlockchainContext) -> 'BoxOperations': ...
    @typing.overload
    @staticmethod
    def createProver(blockchainContext: BlockchainContext, mnemonic: Mnemonic) -> ErgoProver: ...
    @typing.overload
    @staticmethod
    def createProver(blockchainContext: BlockchainContext, string: str, string2: str) -> ErgoProverBuilder: ...
    @typing.overload
    @staticmethod
    def createProver(blockchainContext: BlockchainContext, string: str, secretString: SecretString) -> ErgoProverBuilder: ...
    @staticmethod
    def getCoveringBoxesFor(long: int, list: java.util.List[ErgoToken], boolean: bool, function: typing.Union[java.util.function.Function[int, java.util.List[InputBox]], typing.Callable[[int], java.util.List[InputBox]]]) -> CoveringBoxes: ...
    def loadTop(self) -> java.util.List[InputBox]: ...
    def mintTokenToContractTxUnsigned(self, ergoContract: ErgoContract, function: typing.Union[java.util.function.Function[str, Eip4Token], typing.Callable[[str], Eip4Token]]) -> UnsignedTransaction: ...
    def putToContractTx(self, ergoContract: ErgoContract) -> SignedTransaction: ...
    def putToContractTxUnsigned(self, ergoContract: ErgoContract) -> UnsignedTransaction: ...
    def send(self, address: Address) -> str: ...
    @staticmethod
    def spendBoxesTx(blockchainContext: BlockchainContext, unsignedTransactionBuilder: UnsignedTransactionBuilder, list: java.util.List[InputBox], ergoProver: ErgoProver, address: Address, long: int, long2: int) -> SignedTransaction: ...
    def withAmountToSpend(self, long: int) -> 'BoxOperations': ...
    def withFeeAmount(self, long: int) -> 'BoxOperations': ...
    def withInputBoxesLoader(self, iUnspentBoxesLoader: 'BoxOperations.IUnspentBoxesLoader') -> 'BoxOperations': ...
    def withTokensToSpend(self, list: java.util.List[ErgoToken]) -> 'BoxOperations': ...
    class ExplorerApiUnspentLoader(org.ergoplatform.appkit.BoxOperations.IUnspentBoxesLoader):
        def __init__(self): ...
        def loadBoxesPage(self, blockchainContext: BlockchainContext, address: Address, integer: int) -> java.util.List[InputBox]: ...
        def prepare(self, blockchainContext: BlockchainContext, list: java.util.List[Address], long: int, list2: java.util.List[ErgoToken]) -> None: ...
        def prepareForAddress(self, address: Address) -> None: ...
    class ExplorerApiWithCheckerLoader(org.ergoplatform.appkit.BoxOperations.ExplorerApiUnspentLoader):
        def __init__(self): ...
        def loadBoxesPage(self, blockchainContext: BlockchainContext, address: Address, integer: int) -> java.util.List[InputBox]: ...
    class IUnspentBoxesLoader:
        def loadBoxesPage(self, blockchainContext: BlockchainContext, address: Address, integer: int) -> java.util.List[InputBox]: ...
        def prepare(self, blockchainContext: BlockchainContext, list: java.util.List[Address], long: int, list2: java.util.List[ErgoToken]) -> None: ...
        def prepareForAddress(self, address: Address) -> None: ...

class InputBoxesSelectionException(java.lang.RuntimeException):
    def __init__(self, string: str): ...
    class NotEnoughCoinsForChangeException(org.ergoplatform.appkit.InputBoxesSelectionException):
        def __init__(self, string: str): ...
    class NotEnoughErgsException(org.ergoplatform.appkit.InputBoxesSelectionException):
        balanceFound: int = ...
        def __init__(self, string: str, long: int): ...
    class NotEnoughTokensException(org.ergoplatform.appkit.InputBoxesSelectionException):
        tokenBalances: java.util.Map = ...
        def __init__(self, string: str, map: typing.Union[java.util.Map[str, int], typing.Mapping[str, int]]): ...

class MnemonicValidationException(java.lang.Exception):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    class MnemonicChecksumException(org.ergoplatform.appkit.MnemonicValidationException):
        def __init__(self): ...
    class MnemonicEmptyException(org.ergoplatform.appkit.MnemonicValidationException):
        def __init__(self): ...
    class MnemonicWordException(org.ergoplatform.appkit.MnemonicValidationException):
        badWord: str = ...
        def __init__(self, string: str): ...
    class MnemonicWrongListSizeException(org.ergoplatform.appkit.MnemonicValidationException):
        def __init__(self): ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.ergoplatform.appkit")``.

    Address: typing.Type[Address]
    AppkitProvingInterpreter: typing.Type[AppkitProvingInterpreter]
    Bip32Serialization: typing.Type[Bip32Serialization]
    BlockchainContext: typing.Type[BlockchainContext]
    BlockchainContextBuilder: typing.Type[BlockchainContextBuilder]
    BoxOperations: typing.Type[BoxOperations]
    BoxSelectorsJavaHelpers: typing.Type[BoxSelectorsJavaHelpers]
    ColdErgoClient: typing.Type[ColdErgoClient]
    ComposeIso: typing.Type[ComposeIso]
    Constants: typing.Type[Constants]
    ConstantsBuilder: typing.Type[ConstantsBuilder]
    ContextVar: typing.Type[ContextVar]
    CoveringBoxes: typing.Type[CoveringBoxes]
    Eip4Token: typing.Type[Eip4Token]
    ErgoClient: typing.Type[ErgoClient]
    ErgoClientException: typing.Type[ErgoClientException]
    ErgoContract: typing.Type[ErgoContract]
    ErgoId: typing.Type[ErgoId]
    ErgoProver: typing.Type[ErgoProver]
    ErgoProverBuilder: typing.Type[ErgoProverBuilder]
    ErgoToken: typing.Type[ErgoToken]
    ErgoTreeTemplate: typing.Type[ErgoTreeTemplate]
    ErgoType: typing.Type[ErgoType]
    ErgoValue: typing.Type[ErgoValue]
    ErgoWallet: typing.Type[ErgoWallet]
    ExtendedInputBox: typing.Type[ExtendedInputBox]
    Helpers: typing.Type[Helpers]
    InputBox: typing.Type[InputBox]
    InputBoxesSelectionException: typing.Type[InputBoxesSelectionException]
    InverseIso: typing.Type[InverseIso]
    Iso: typing.Type[Iso]
    JavaHelpers: typing.Type[JavaHelpers]
    LowPriorityIsos: typing.Type[LowPriorityIsos]
    Mnemonic: typing.Type[Mnemonic]
    MnemonicValidationException: typing.Type[MnemonicValidationException]
    NetworkType: typing.Type[NetworkType]
    OutBox: typing.Type[OutBox]
    OutBoxBuilder: typing.Type[OutBoxBuilder]
    Parameters: typing.Type[Parameters]
    PreHeader: typing.Type[PreHeader]
    PreHeaderBuilder: typing.Type[PreHeaderBuilder]
    ReducedErgoLikeTransaction: typing.Type[ReducedErgoLikeTransaction]
    ReducedErgoLikeTransactionSerializer: typing.Type[ReducedErgoLikeTransactionSerializer]
    ReducedInputData: typing.Type[ReducedInputData]
    ReducedTransaction: typing.Type[ReducedTransaction]
    RestApiErgoClient: typing.Type[RestApiErgoClient]
    SecretStorage: typing.Type[SecretStorage]
    SecretString: typing.Type[SecretString]
    SelectTokensHelper: typing.Type[SelectTokensHelper]
    Signature: typing.Type[Signature]
    SignedInput: typing.Type[SignedInput]
    SignedTransaction: typing.Type[SignedTransaction]
    Transaction: typing.Type[Transaction]
    TransactionBox: typing.Type[TransactionBox]
    UnsignedTransaction: typing.Type[UnsignedTransaction]
    UnsignedTransactionBuilder: typing.Type[UnsignedTransactionBuilder]
    cli: org.ergoplatform.appkit.cli.__module_protocol__
    commands: org.ergoplatform.appkit.commands.__module_protocol__
    config: org.ergoplatform.appkit.config.__module_protocol__
    ergotool: org.ergoplatform.appkit.ergotool.__module_protocol__
    impl: org.ergoplatform.appkit.impl.__module_protocol__
