import decimal
import java.math
import java.util
import org
import org.ergoplatform
import org.ergoplatform.appkit
import org.ergoplatform.explorer.client
import org.ergoplatform.explorer.client.model
import org.ergoplatform.restapi.client
import org.ergoplatform.wallet.protocol.context
import retrofit2
import scala
import scala.collection
import scala.collection.immutable
import sigmastate
import sigmastate.interpreter
import special.collection
import special.sigma
import typing



class BlockchainContextBase(org.ergoplatform.appkit.BlockchainContext):
    def __init__(self, networkType: org.ergoplatform.appkit.NetworkType): ...
    def compileContract(self, constants: org.ergoplatform.appkit.Constants, string: str) -> org.ergoplatform.appkit.ErgoContract: ...
    def getNetworkType(self) -> org.ergoplatform.appkit.NetworkType: ...
    def getNodeInfo(self) -> org.ergoplatform.restapi.client.NodeInfo: ...
    def newContract(self, ergoTree: sigmastate.Values.ErgoTree) -> org.ergoplatform.appkit.ErgoContract: ...
    def parseReducedTransaction(self, byteArray: typing.List[int]) -> org.ergoplatform.appkit.ReducedTransaction: ...
    def parseSignedTransaction(self, byteArray: typing.List[int]) -> org.ergoplatform.appkit.SignedTransaction: ...

class BlockchainContextBuilderImpl(org.ergoplatform.appkit.BlockchainContextBuilder):
    def __init__(self, apiClient: org.ergoplatform.restapi.client.ApiClient, explorerApiClient: org.ergoplatform.explorer.client.ExplorerApiClient, networkType: org.ergoplatform.appkit.NetworkType): ...
    def build(self) -> org.ergoplatform.appkit.BlockchainContext: ...

class Eip4TokenBuilder:
    def __init__(self): ...
    @staticmethod
    def buildFromAdditionalRegisters(string: str, long: int, additionalRegisters: org.ergoplatform.explorer.client.model.AdditionalRegisters) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildFromErgoBox(string: str, transactionBox: org.ergoplatform.appkit.TransactionBox) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildFromExplorerByIssuingBox(defaultApi: org.ergoplatform.explorer.client.DefaultApi, string: str, string2: str) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildFromExplorerByTokenId(defaultApi: org.ergoplatform.explorer.client.DefaultApi, string: str) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildFromHexEncodedRegisters(string: str, long: int, list: java.util.List[str]) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildNftAudioToken(string: str, long: int, string2: str, string3: str, int: int, byteArray: typing.List[int], string4: str, string5: str) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildNftPictureToken(string: str, long: int, string2: str, string3: str, int: int, byteArray: typing.List[int], string4: str) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildNftVideoToken(string: str, long: int, string2: str, string3: str, int: int, byteArray: typing.List[int], string4: str) -> org.ergoplatform.appkit.Eip4Token: ...

class ErgoProverBuilderImpl(org.ergoplatform.appkit.ErgoProverBuilder):
    org$ergoplatform$appkit$impl$ErgoProverBuilderImpl$$_ctx: BlockchainContextBase = ...
    def __init__(self, _ctx: BlockchainContextBase): ...
    def build(self) -> org.ergoplatform.appkit.ErgoProver: ...
    def withDHTData(self, g: special.sigma.GroupElement, h: special.sigma.GroupElement, u: special.sigma.GroupElement, v: special.sigma.GroupElement, x: java.math.BigInteger) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    def withDLogSecret(self, x: java.math.BigInteger) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    def withEip3Secret(self, index: int) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    @typing.overload
    def withMnemonic(self, mnemonic: org.ergoplatform.appkit.Mnemonic) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    @typing.overload
    def withMnemonic(self, mnemonicPhrase: org.ergoplatform.appkit.SecretString, mnemonicPass: org.ergoplatform.appkit.SecretString) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    def withSecretStorage(self, storage: org.ergoplatform.appkit.SecretStorage) -> org.ergoplatform.appkit.ErgoProverBuilder: ...

class ErgoProverImpl(org.ergoplatform.appkit.ErgoProver):
    def __init__(self, _ctx: BlockchainContextBase, _prover: org.ergoplatform.appkit.AppkitProvingInterpreter): ...
    def getAddress(self) -> org.ergoplatform.appkit.Address: ...
    def getEip3Addresses(self) -> java.util.List[org.ergoplatform.appkit.Address]: ...
    def getP2PKAddress(self) -> org.ergoplatform.P2PKAddress: ...
    def getSecretKey(self) -> special.sigma.BigInt: ...
    def reduce(self, tx: org.ergoplatform.appkit.UnsignedTransaction, baseCost: int) -> org.ergoplatform.appkit.ReducedTransaction: ...
    @typing.overload
    def sign(self, tx: org.ergoplatform.appkit.UnsignedTransaction) -> org.ergoplatform.appkit.SignedTransaction: ...
    @typing.overload
    def sign(self, tx: org.ergoplatform.appkit.UnsignedTransaction, baseCost: int) -> org.ergoplatform.appkit.SignedTransaction: ...
    @typing.overload
    def signMessage(self, addr: org.ergoplatform.P2PKAddress, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> typing.List[int]: ...
    @typing.overload
    def signMessage(self, sigmaTree: sigmastate.Values.SigmaBoolean, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> typing.List[int]: ...
    def signReduced(self, tx: org.ergoplatform.appkit.ReducedTransaction, baseCost: int) -> org.ergoplatform.appkit.SignedTransaction: ...

class ErgoScriptContract(org.ergoplatform.appkit.ErgoContract):
    @staticmethod
    def create(constants: org.ergoplatform.appkit.Constants, string: str, networkType: org.ergoplatform.appkit.NetworkType) -> 'ErgoScriptContract': ...
    def getConstants(self) -> org.ergoplatform.appkit.Constants: ...
    def getErgoScript(self) -> str: ...
    def getErgoTree(self) -> sigmastate.Values.ErgoTree: ...
    def substConstant(self, string: str, object: typing.Any) -> 'ErgoScriptContract': ...
    def toAddress(self) -> org.ergoplatform.appkit.Address: ...

class ErgoTreeContract(org.ergoplatform.appkit.ErgoContract):
    def __init__(self, ergoTree: sigmastate.Values.ErgoTree, networkType: org.ergoplatform.appkit.NetworkType): ...
    def getConstants(self) -> org.ergoplatform.appkit.Constants: ...
    def getErgoScript(self) -> str: ...
    def getErgoTree(self) -> sigmastate.Values.ErgoTree: ...
    def substConstant(self, string: str, object: typing.Any) -> 'ErgoTreeContract': ...
    def toAddress(self) -> org.ergoplatform.appkit.Address: ...

class ErgoWalletImpl(org.ergoplatform.appkit.ErgoWallet):
    def __init__(self, list: java.util.List[org.ergoplatform.restapi.client.WalletBox]): ...
    def getUnspentBoxes(self, long: int) -> java.util.Optional[java.util.List[org.ergoplatform.appkit.InputBox]]: ...

class ExplorerAndPoolUnspentBoxesLoader(org.ergoplatform.appkit.BoxOperations.ExplorerApiWithCheckerLoader):
    def __init__(self): ...
    def loadBoxesPage(self, blockchainContext: org.ergoplatform.appkit.BlockchainContext, address: org.ergoplatform.appkit.Address, integer: int) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def prepare(self, blockchainContext: org.ergoplatform.appkit.BlockchainContext, list: java.util.List[org.ergoplatform.appkit.Address], long: int, list2: java.util.List[org.ergoplatform.appkit.ErgoToken]) -> None: ...
    def prepareForAddress(self, address: org.ergoplatform.appkit.Address) -> None: ...
    def withAllowChainedTx(self, boolean: bool) -> 'ExplorerAndPoolUnspentBoxesLoader': ...

class InputBoxImpl(org.ergoplatform.appkit.InputBox):
    @typing.overload
    def __init__(self, blockchainContextBase: BlockchainContextBase, ergoBox: org.ergoplatform.ErgoBox): ...
    @typing.overload
    def __init__(self, blockchainContextBase: BlockchainContextBase, ergoTransactionOutput: org.ergoplatform.restapi.client.ErgoTransactionOutput): ...
    def getBytes(self) -> typing.List[int]: ...
    def getCreationHeight(self) -> int: ...
    def getErgoBox(self) -> org.ergoplatform.ErgoBox: ...
    def getErgoTree(self) -> sigmastate.Values.ErgoTree: ...
    def getExtension(self) -> sigmastate.interpreter.ContextExtension: ...
    def getId(self) -> org.ergoplatform.appkit.ErgoId: ...
    def getRegisters(self) -> java.util.List[org.ergoplatform.appkit.ErgoValue[typing.Any]]: ...
    def getTokens(self) -> java.util.List[org.ergoplatform.appkit.ErgoToken]: ...
    def getValue(self) -> int: ...
    @typing.overload
    def toJson(self, boolean: bool) -> str: ...
    @typing.overload
    def toJson(self, boolean: bool, boolean2: bool) -> str: ...
    def toString(self) -> str: ...
    def withContextVars(self, contextVarArray: typing.List[org.ergoplatform.appkit.ContextVar]) -> org.ergoplatform.appkit.InputBox: ...

class OutBoxBuilderImpl(org.ergoplatform.appkit.OutBoxBuilder):
    def __init__(self, _txB: 'UnsignedTransactionBuilderImpl'): ...
    def build(self) -> org.ergoplatform.appkit.OutBox: ...
    def contract(self, contract: org.ergoplatform.appkit.ErgoContract) -> 'OutBoxBuilderImpl': ...
    def creationHeight(self, height: int) -> org.ergoplatform.appkit.OutBoxBuilder: ...
    def mintToken(self, token: org.ergoplatform.appkit.Eip4Token) -> org.ergoplatform.appkit.OutBoxBuilder: ...
    @typing.overload
    def registers(self, registers: typing.List[org.ergoplatform.appkit.ErgoValue[typing.Any]]) -> 'OutBoxBuilderImpl': ...
    @typing.overload
    def registers(self, registers: scala.collection.Seq[org.ergoplatform.appkit.ErgoValue[typing.Any]]) -> 'OutBoxBuilderImpl': ...
    @typing.overload
    def tokens(self, tokens: typing.List[org.ergoplatform.appkit.ErgoToken]) -> 'OutBoxBuilderImpl': ...
    @typing.overload
    def tokens(self, tokens: scala.collection.Seq[org.ergoplatform.appkit.ErgoToken]) -> 'OutBoxBuilderImpl': ...
    def value(self, value: int) -> 'OutBoxBuilderImpl': ...

class OutBoxImpl(org.ergoplatform.appkit.OutBox):
    def __init__(self, _ctx: BlockchainContextBase, _ergoBoxCandidate: org.ergoplatform.ErgoBoxCandidate): ...
    def convertToInputWith(self, txId: str, boxIndex: int) -> org.ergoplatform.appkit.InputBox: ...
    def getBytesWithNoRef(self) -> typing.List[int]: ...
    def getCreationHeight(self) -> int: ...
    def getErgoBoxCandidate(self) -> org.ergoplatform.ErgoBoxCandidate: ...
    def getErgoTree(self) -> sigmastate.Values.ErgoTree: ...
    def getRegisters(self) -> java.util.List[org.ergoplatform.appkit.ErgoValue[typing.Any]]: ...
    def getTokens(self) -> java.util.List[org.ergoplatform.appkit.ErgoToken]: ...
    def getValue(self) -> int: ...

class PreHeaderBuilderImpl(org.ergoplatform.appkit.PreHeaderBuilder):
    def __init__(self, blockchainContextImpl: 'BlockchainContextImpl'): ...
    def build(self) -> org.ergoplatform.appkit.PreHeader: ...
    def height(self, integer: int) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def minerPk(self, groupElement: special.sigma.GroupElement) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def nBits(self, long: int) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def parentId(self, coll: special.collection.Coll[int]) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def timestamp(self, long: int) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def version(self, byte: int) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def votes(self, coll: special.collection.Coll[int]) -> org.ergoplatform.appkit.PreHeaderBuilder: ...

class PreHeaderImpl(org.ergoplatform.appkit.PreHeader):
    def __init__(self, preHeader: special.sigma.PreHeader): ...
    def getHeight(self) -> int: ...
    def getMinerPk(self) -> special.sigma.GroupElement: ...
    def getNBits(self) -> int: ...
    def getParentId(self) -> special.collection.Coll[int]: ...
    def getTimestamp(self) -> int: ...
    def getVersion(self) -> int: ...
    def getVotes(self) -> special.collection.Coll[int]: ...

class ReducedTransactionImpl(org.ergoplatform.appkit.ReducedTransaction):
    def __init__(self, blockchainContextBase: BlockchainContextBase, reducedErgoLikeTransaction: org.ergoplatform.appkit.ReducedErgoLikeTransaction, int: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getCost(self) -> int: ...
    def getId(self) -> str: ...
    def getInputBoxesIds(self) -> java.util.List[str]: ...
    def getOutputs(self) -> java.util.List[org.ergoplatform.appkit.OutBox]: ...
    def getTx(self) -> org.ergoplatform.appkit.ReducedErgoLikeTransaction: ...
    def hashCode(self) -> int: ...
    def toBytes(self) -> typing.List[int]: ...

class ScalaBridge:
    @staticmethod
    def isoAssetToErgoToken() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.Asset, org.ergoplatform.appkit.ErgoToken]: ...
    @staticmethod
    def isoAssetToPair() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.Asset, scala.Tuple2[typing.List[int], typing.Any]]: ...
    @staticmethod
    def isoBlockHeader() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.BlockHeader, special.sigma.Header]: ...
    @staticmethod
    def isoErgoTransaction() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.ErgoTransaction, org.ergoplatform.ErgoLikeTransaction]: ...
    @staticmethod
    def isoErgoTransactionDataInput() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.ErgoTransactionDataInput, org.ergoplatform.DataInput]: ...
    @staticmethod
    def isoErgoTransactionInput() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.ErgoTransactionInput, org.ergoplatform.Input]: ...
    @staticmethod
    def isoErgoTransactionOutput() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.ErgoTransactionOutput, org.ergoplatform.ErgoBox]: ...
    @staticmethod
    def isoExplRegistersToMap() -> org.ergoplatform.appkit.Iso[org.ergoplatform.explorer.client.model.AdditionalRegisters, scala.collection.immutable.Map[org.ergoplatform.ErgoBox.NonMandatoryRegisterId, sigmastate.Values.EvaluatedValue[sigmastate.SType]]]: ...
    @staticmethod
    def isoExplorerAssetToPair() -> org.ergoplatform.appkit.Iso[org.ergoplatform.explorer.client.model.AssetInfo, scala.Tuple2[typing.List[int], typing.Any]]: ...
    @staticmethod
    def isoRegistersToMap() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.Registers, scala.collection.immutable.Map[org.ergoplatform.ErgoBox.NonMandatoryRegisterId, sigmastate.Values.EvaluatedValue[sigmastate.SType]]]: ...
    @staticmethod
    def isoSpendingProof() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.SpendingProof, sigmastate.interpreter.ProverResult]: ...
    @staticmethod
    def isoStringToErgoTree() -> org.ergoplatform.appkit.Iso[str, sigmastate.Values.ErgoTree]: ...

class SignedInputImpl(org.ergoplatform.appkit.SignedInput):
    def __init__(self, signedTransactionImpl: 'SignedTransactionImpl', input: org.ergoplatform.Input): ...
    def getContextVars(self) -> java.util.Map[int, org.ergoplatform.appkit.ErgoValue[typing.Any]]: ...
    def getId(self) -> org.ergoplatform.appkit.ErgoId: ...
    def getProofBytes(self) -> typing.List[int]: ...
    def getTransaction(self) -> org.ergoplatform.appkit.SignedTransaction: ...

class SignedTransactionImpl(org.ergoplatform.appkit.SignedTransaction):
    def __init__(self, blockchainContextBase: BlockchainContextBase, ergoLikeTransaction: org.ergoplatform.ErgoLikeTransaction, int: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getCost(self) -> int: ...
    def getId(self) -> str: ...
    def getInputBoxesIds(self) -> java.util.List[str]: ...
    def getOutputs(self) -> java.util.List[org.ergoplatform.appkit.OutBox]: ...
    def getOutputsToSpend(self) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def getSignedInputs(self) -> java.util.List[org.ergoplatform.appkit.SignedInput]: ...
    def getTx(self) -> org.ergoplatform.ErgoLikeTransaction: ...
    def hashCode(self) -> int: ...
    def toBytes(self) -> typing.List[int]: ...
    @typing.overload
    def toJson(self, boolean: bool) -> str: ...
    @typing.overload
    def toJson(self, boolean: bool, boolean2: bool) -> str: ...
    def toString(self) -> str: ...

class UnsignedTransactionBuilderImpl(org.ergoplatform.appkit.UnsignedTransactionBuilder):
    def __init__(self, _ctx: 'BlockchainContextImpl'): ...
    def _ctx(self) -> 'BlockchainContextImpl': ...
    def _dataInputs(self) -> java.util.List[org.ergoplatform.DataInput]: ...
    def _dataInputs_$eq(self, x$1: java.util.List[org.ergoplatform.DataInput]) -> None: ...
    def _inputs(self) -> java.util.List[org.ergoplatform.UnsignedInput]: ...
    def _inputs_$eq(self, x$1: java.util.List[org.ergoplatform.UnsignedInput]) -> None: ...
    def _outputCandidates(self) -> scala.Option[java.util.List[org.ergoplatform.ErgoBoxCandidate]]: ...
    def _outputCandidates_$eq(self, x$1: scala.Option[java.util.List[org.ergoplatform.ErgoBoxCandidate]]) -> None: ...
    def boxesToSpend(self, inputBoxes: java.util.List[org.ergoplatform.appkit.InputBox]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def build(self) -> org.ergoplatform.appkit.UnsignedTransaction: ...
    def fee(self, feeAmount: int) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def getCtx(self) -> org.ergoplatform.appkit.BlockchainContext: ...
    _getDefined__T = typing.TypeVar('_getDefined__T')  # <T>
    def getDefined(self, opt: scala.Option[_getDefined__T], msg: scala.Function0[str]) -> _getDefined__T: ...
    def getInputBoxes(self) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def getNetworkType(self) -> org.ergoplatform.appkit.NetworkType: ...
    _getNonEmpty__T = typing.TypeVar('_getNonEmpty__T')  # <T>
    def getNonEmpty(self, list: scala.Option[java.util.List[_getNonEmpty__T]], msg: scala.Function0[str]) -> java.util.List[_getNonEmpty__T]: ...
    def getPreHeader(self) -> org.ergoplatform.appkit.PreHeader: ...
    def org$ergoplatform$appkit$impl$UnsignedTransactionBuilderImpl$$_ph(self) -> scala.Option[PreHeaderImpl]: ...
    def outBoxBuilder(self) -> OutBoxBuilderImpl: ...
    @typing.overload
    def outputs(self, outputs: typing.List[org.ergoplatform.appkit.OutBox]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    @typing.overload
    def outputs(self, outputs: scala.collection.Seq[org.ergoplatform.appkit.OutBox]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def preHeader(self, ph: org.ergoplatform.appkit.PreHeader) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def sendChangeTo(self, changeAddress: org.ergoplatform.ErgoAddress) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    @typing.overload
    def tokensToBurn(self, tokens: typing.List[org.ergoplatform.appkit.ErgoToken]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    @typing.overload
    def tokensToBurn(self, tokens: scala.collection.Seq[org.ergoplatform.appkit.ErgoToken]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def withDataInputs(self, inputBoxes: java.util.List[org.ergoplatform.appkit.InputBox]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...

class UnsignedTransactionImpl(org.ergoplatform.appkit.UnsignedTransaction):
    def __init__(self, unsignedErgoLikeTransaction: org.ergoplatform.UnsignedErgoLikeTransaction, list: java.util.List[org.ergoplatform.appkit.ExtendedInputBox], list2: java.util.List[org.ergoplatform.ErgoBox], ergoAddress: org.ergoplatform.ErgoAddress, ergoLikeStateContext: org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext, blockchainContextImpl: 'BlockchainContextImpl'): ...
    def getBoxesToSpend(self) -> java.util.List[org.ergoplatform.appkit.ExtendedInputBox]: ...
    def getChangeAddress(self) -> org.ergoplatform.ErgoAddress: ...
    def getDataBoxes(self) -> java.util.List[org.ergoplatform.ErgoBox]: ...
    def getDataInputs(self) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def getId(self) -> str: ...
    def getInputBoxesIds(self) -> java.util.List[str]: ...
    def getInputs(self) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def getOutputs(self) -> java.util.List[org.ergoplatform.appkit.OutBox]: ...
    def getStateContext(self) -> org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext: ...
    def getTx(self) -> org.ergoplatform.UnsignedErgoLikeTransaction: ...

class BlockchainContextImpl(BlockchainContextBase):
    def __init__(self, apiClient: org.ergoplatform.restapi.client.ApiClient, retrofit: retrofit2.Retrofit, explorerApiClient: org.ergoplatform.explorer.client.ExplorerApiClient, retrofit2: retrofit2.Retrofit, networkType: org.ergoplatform.appkit.NetworkType, nodeInfo: org.ergoplatform.restapi.client.NodeInfo, list: java.util.List[org.ergoplatform.restapi.client.BlockHeader]): ...
    def createPreHeader(self) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def getBoxesById(self, stringArray: typing.List[str]) -> typing.List[org.ergoplatform.appkit.InputBox]: ...
    def getCoveringBoxesFor(self, address: org.ergoplatform.appkit.Address, long: int, list: java.util.List[org.ergoplatform.appkit.ErgoToken]) -> org.ergoplatform.appkit.CoveringBoxes: ...
    def getHeaders(self) -> java.util.List[org.ergoplatform.restapi.client.BlockHeader]: ...
    def getHeight(self) -> int: ...
    def getNodeInfo(self) -> org.ergoplatform.restapi.client.NodeInfo: ...
    def getPreHeader(self) -> org.ergoplatform.appkit.PreHeader: ...
    def getUnspentBoxesFor(self, address: org.ergoplatform.appkit.Address, int: int, int2: int) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def getWallet(self) -> org.ergoplatform.appkit.ErgoWallet: ...
    def newProverBuilder(self) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    def newTxBuilder(self) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def sendTransaction(self, signedTransaction: org.ergoplatform.appkit.SignedTransaction) -> str: ...
    def signedTxFromJson(self, string: str) -> org.ergoplatform.appkit.SignedTransaction: ...

class ColdBlockchainContext(BlockchainContextBase):
    def __init__(self, networkType: org.ergoplatform.appkit.NetworkType, params: org.ergoplatform.restapi.client.Parameters): ...
    def createPreHeader(self) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def getApiClient(self) -> org.ergoplatform.restapi.client.ApiClient: ...
    @typing.overload
    def getBoxesById(self, boxIds: typing.List[str]) -> typing.List[org.ergoplatform.appkit.InputBox]: ...
    @typing.overload
    def getBoxesById(self, boxIds: scala.collection.Seq[str]) -> typing.List[org.ergoplatform.appkit.InputBox]: ...
    def getCoveringBoxesFor(self, address: org.ergoplatform.appkit.Address, amountToSpend: int, tokensToSpend: java.util.List[org.ergoplatform.appkit.ErgoToken]) -> org.ergoplatform.appkit.CoveringBoxes: ...
    def getHeight(self) -> int: ...
    def getNodeInfo(self) -> org.ergoplatform.restapi.client.NodeInfo: ...
    def getUnspentBoxesFor(self, address: org.ergoplatform.appkit.Address, offset: int, limit: int) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def getWallet(self) -> org.ergoplatform.appkit.ErgoWallet: ...
    def newProverBuilder(self) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    def newTxBuilder(self) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def sendTransaction(self, tx: org.ergoplatform.appkit.SignedTransaction) -> str: ...
    def signedTxFromJson(self, json: str) -> org.ergoplatform.appkit.SignedTransaction: ...

class ErgoNodeFacade(org.ergoplatform.appkit.impl.ApiFacade):
    def __init__(self): ...
    @staticmethod
    def getBoxById(retrofit: retrofit2.Retrofit, string: str) -> org.ergoplatform.restapi.client.ErgoTransactionOutput: ...
    @staticmethod
    def getBoxWithPoolById(retrofit: retrofit2.Retrofit, string: str) -> org.ergoplatform.restapi.client.ErgoTransactionOutput: ...
    @staticmethod
    def getLastHeaders(retrofit: retrofit2.Retrofit, bigDecimal: typing.Union[java.math.BigDecimal, decimal.Decimal]) -> java.util.List[org.ergoplatform.restapi.client.BlockHeader]: ...
    @staticmethod
    def getNodeInfo(retrofit: retrofit2.Retrofit) -> org.ergoplatform.restapi.client.NodeInfo: ...
    @staticmethod
    def getUnconfirmedTransactions(retrofit: retrofit2.Retrofit, int: int, int2: int) -> org.ergoplatform.restapi.client.Transactions: ...
    @staticmethod
    def getWalletUnspentBoxes(retrofit: retrofit2.Retrofit, integer: int, integer2: int) -> java.util.List[org.ergoplatform.restapi.client.WalletBox]: ...
    @staticmethod
    def sendTransaction(retrofit: retrofit2.Retrofit, ergoTransaction: org.ergoplatform.restapi.client.ErgoTransaction) -> str: ...

class ExplorerFacade(org.ergoplatform.appkit.impl.ApiFacade):
    def __init__(self): ...
    @staticmethod
    def getApiV1MempoolTransactionsByaddressP1(retrofit: retrofit2.Retrofit, string: str, int: int, int2: int) -> java.util.List[org.ergoplatform.explorer.client.model.TransactionInfo]: ...
    @staticmethod
    def transactionsBoxesByAddressUnspentIdGet(retrofit: retrofit2.Retrofit, string: str, integer: int, integer2: int) -> java.util.List[org.ergoplatform.explorer.client.model.OutputInfo]: ...

class ApiFacade: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.ergoplatform.appkit.impl")``.

    ApiFacade: typing.Type[ApiFacade]
    BlockchainContextBase: typing.Type[BlockchainContextBase]
    BlockchainContextBuilderImpl: typing.Type[BlockchainContextBuilderImpl]
    BlockchainContextImpl: typing.Type[BlockchainContextImpl]
    ColdBlockchainContext: typing.Type[ColdBlockchainContext]
    Eip4TokenBuilder: typing.Type[Eip4TokenBuilder]
    ErgoNodeFacade: typing.Type[ErgoNodeFacade]
    ErgoProverBuilderImpl: typing.Type[ErgoProverBuilderImpl]
    ErgoProverImpl: typing.Type[ErgoProverImpl]
    ErgoScriptContract: typing.Type[ErgoScriptContract]
    ErgoTreeContract: typing.Type[ErgoTreeContract]
    ErgoWalletImpl: typing.Type[ErgoWalletImpl]
    ExplorerAndPoolUnspentBoxesLoader: typing.Type[ExplorerAndPoolUnspentBoxesLoader]
    ExplorerFacade: typing.Type[ExplorerFacade]
    InputBoxImpl: typing.Type[InputBoxImpl]
    OutBoxBuilderImpl: typing.Type[OutBoxBuilderImpl]
    OutBoxImpl: typing.Type[OutBoxImpl]
    PreHeaderBuilderImpl: typing.Type[PreHeaderBuilderImpl]
    PreHeaderImpl: typing.Type[PreHeaderImpl]
    ReducedTransactionImpl: typing.Type[ReducedTransactionImpl]
    ScalaBridge: typing.Type[ScalaBridge]
    SignedInputImpl: typing.Type[SignedInputImpl]
    SignedTransactionImpl: typing.Type[SignedTransactionImpl]
    UnsignedTransactionBuilderImpl: typing.Type[UnsignedTransactionBuilderImpl]
    UnsignedTransactionImpl: typing.Type[UnsignedTransactionImpl]
