/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.ergoplatform.appkit.BoxAttachment;
import org.ergoplatform.appkit.BoxAttachmentGeneric;
import org.ergoplatform.appkit.ErgoType;
import org.ergoplatform.appkit.ErgoValue;
import scala.Tuple2;
import special.collection.Coll;

public class BoxAttachmentMulti
extends BoxAttachmentGeneric {
    private final Tuple2<Integer, Coll<Byte>>[] attachmentList;

    BoxAttachmentMulti(byte[] byArray) {
        super(BoxAttachment.Type.MULTI_ATTACHMENT.toTypeRawValue(), byArray);
        ErgoValue<?> ergoValue = ErgoValue.fromHex(new String(byArray, StandardCharsets.UTF_8));
        if (!ergoValue.getType().equals(ErgoType.collType(ErgoType.pairType(ErgoType.integerType(), ErgoType.collType(ErgoType.byteType()))))) {
            throw new IllegalArgumentException("Multi attachment content needs to be Coll[(Int, Coll[Byte])]");
        }
        this.attachmentList = (Tuple2[])((Coll)ergoValue.getValue()).toArray();
    }

    private BoxAttachmentMulti(byte[] byArray, Tuple2<Integer, Coll<Byte>>[] tuple2Array) {
        super(BoxAttachment.Type.MULTI_ATTACHMENT.toTypeRawValue(), byArray);
        this.attachmentList = tuple2Array;
    }

    public BoxAttachment getAttachment(int n) {
        return BoxAttachmentGeneric.createFromAttachmentTuple(this.attachmentList[n]);
    }

    public int getAttachmentCount() {
        return this.attachmentList.length;
    }

    public static BoxAttachmentMulti buildForList(List<BoxAttachment> list) {
        ArrayList arrayList = new ArrayList(list.size());
        for (BoxAttachment object2 : list) {
            arrayList.add(object2.getErgoValue().getValue()._2);
        }
        Tuple2[] tuple2Array = arrayList.toArray(new Tuple2[0]);
        ErgoValue<Coll<Tuple2<Integer, Coll<Byte>>>> ergoValue = ErgoValue.of(tuple2Array, ErgoType.pairType(ErgoType.integerType(), ErgoType.collType(ErgoType.byteType())));
        return new BoxAttachmentMulti(ergoValue.toHex().getBytes(StandardCharsets.UTF_8), tuple2Array);
    }
}

