/*
 * Decompiled with CFR 0.152.
 */
package scalan.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering$Long$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0$mcV$sp;
import scalan.util.CollectionUtil$;
import scalan.util.CollectionUtil$AnyOps$;
import scalan.util.StringUtil$;
import scalan.util.StringUtil$StringUtilExtensions$;

public final class FileUtil$ {
    public static FileUtil$ MODULE$;
    private final FilenameFilter AcceptAllFiles;
    private final FilenameFilter AcceptAllDirectories;

    static {
        new FileUtil$();
    }

    public String read(File file) {
        return FileUtils.readFileToString(file, Charset.defaultCharset());
    }

    public void withFile(File file, Function1<PrintWriter, BoxedUnit> f) {
        if (file.isDirectory() && !file.delete()) {
            throw new RuntimeException(new StringBuilder(30).append("File ").append(file).append(" is a non-empty directory").toString());
        }
        file.getParentFile().mkdirs();
        try (PrintWriter stream = new PrintWriter(new FileOutputStream(file));){
            f.apply(stream);
        }
    }

    public void write(File file, String text) {
        this.withFile(file, (Function1<PrintWriter, BoxedUnit>)(Function1<PrintWriter, Object> & java.io.Serializable & Serializable)x$1 -> {
            x$1.print(text);
            return BoxedUnit.UNIT;
        });
    }

    public void withStdOutAndErr(PrintStream out, Function0<BoxedUnit> func) {
        PrintStream oldStdOut = System.out;
        PrintStream oldStdErr = System.err;
        try {
            System.setOut(out);
            System.setErr(out);
            Console$.MODULE$.withOut(out, (JFunction0$mcV$sp & Serializable)() -> Console$.MODULE$.withErr(out, func));
        }
        finally {
            out.flush();
            System.setOut(oldStdOut);
            System.setErr(oldStdErr);
        }
    }

    public String captureStdOutAndErr(Function0<BoxedUnit> func) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream(out);){
            this.withStdOutAndErr(ps, func);
        }
        return out.toString();
    }

    public void copy(File source, File target) {
        if (source.isFile()) {
            FileUtils.copyFile(source, target, false);
        } else {
            FileUtils.copyDirectory(source, target, false);
        }
    }

    public void copyFromClassPath(String source, File target, ClassLoader classLoader) {
        target.getParentFile().mkdirs();
        Enumeration<URL> urls = classLoader.getResources(source);
        if (urls.hasMoreElements()) {
            if (source.endsWith("/")) {
                JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(urls).asScala().foreach((Function1<URL, Object> & java.io.Serializable & Serializable)url -> {
                    FileUtil$.$anonfun$copyFromClassPath$1(target, source, url);
                    return BoxedUnit.UNIT;
                });
            } else {
                URL url2 = urls.nextElement();
                if (urls.hasMoreElements()) {
                    throw new IllegalArgumentException(new StringBuilder(38).append("Multiple ").append(source).append(" resources found on classpath").toString());
                }
                FileUtils.copyInputStreamToFile(url2.openStream(), target);
            }
        } else {
            throw new IllegalArgumentException(new StringBuilder(32).append("Resource ").append(source).append(" not found on classpath").toString());
        }
    }

    public ClassLoader copyFromClassPath$default$3() {
        return this.getClass().getClassLoader();
    }

    public long classPathLastModified(String source, ClassLoader classLoader) {
        Enumeration<URL> urls = classLoader.getResources(source);
        if (!urls.hasMoreElements()) {
            throw new IllegalArgumentException(new StringBuilder(32).append("Resource ").append(source).append(" not found on classpath").toString());
        }
        return BoxesRunTime.unboxToLong(JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(urls).asScala().map((Function1<URL, Object> & java.io.Serializable & Serializable)url -> BoxesRunTime.boxToLong(this.urlLastModified$1(url))).max(Ordering$Long$.MODULE$));
    }

    public ClassLoader classPathLastModified$default$2() {
        return this.getClass().getClassLoader();
    }

    public File jarUrlToJarFile(URL url) {
        URL jarFileUrl = ((JarURLConnection)url.openConnection()).getJarFileURL();
        return this.urlToFile(jarFileUrl);
    }

    public void copyToDir(File source, File targetDir) {
        this.copy(source, new File(targetDir, source.getName()));
    }

    public void move(File source, File target) {
        if (source.isFile()) {
            FileUtils.moveFile(source, target);
        } else {
            FileUtils.moveDirectory(source, target);
        }
    }

    public void addHeader(File file, String header) {
        this.write(file, new StringBuilder(1).append(header).append("\n").append(this.read(file)).toString());
    }

    public void delete(File fileOrDirectory) {
        this.deleteRecursive(fileOrDirectory.toPath());
    }

    public void deleteIfExist(File fileOrDirectory) {
        block0: {
            if (!fileOrDirectory.exists()) break block0;
            this.delete(fileOrDirectory);
        }
    }

    public void deleteRecursive(Path path) {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public File currentWorkingDir() {
        return Paths.get("", new String[0]).toAbsolutePath().toFile();
    }

    public File file(String first, Seq<String> rest) {
        return this.file(new File(first), rest);
    }

    public File file(File first, Seq<String> rest) {
        return rest.foldLeft(first, (Function2<File, String, File> & java.io.Serializable & Serializable)(file, child) -> new File((File)file, (String)child));
    }

    public final FilenameFilter AcceptAllFiles() {
        return this.AcceptAllFiles;
    }

    public final FilenameFilter AcceptAllDirectories() {
        return this.AcceptAllDirectories;
    }

    public File[] listFiles(File dir, FilenameFilter filter2) {
        File[] fileArray = dir.listFiles(filter2);
        File[] fileArray2 = fileArray == null ? (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)) : fileArray;
        return fileArray2;
    }

    public FilenameFilter listFiles$default$2() {
        return this.AcceptAllFiles();
    }

    public File[] listDirectories(File dir) {
        return this.listFiles(dir, this.AcceptAllDirectories());
    }

    public File[] listDirectoriesRecursive(File dir) {
        return (File[])CollectionUtil$AnyOps$.MODULE$.traverseDepthFirst$extension(CollectionUtil$.MODULE$.AnyOps(dir), (Function1<File, List> & java.io.Serializable & Serializable)f -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])MODULE$.listDirectories((File)f))).toList()).toArray(ClassTag$.MODULE$.apply(File.class));
    }

    public File[] listFilesRecursive(File dir) {
        File[] dirs2 = this.listDirectoriesRecursive(dir);
        return (File[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])dirs2)).flatMap((Function1<File, Object> & java.io.Serializable & Serializable)d -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])FileUtil$.MODULE$.listFiles(d, FileUtil$.MODULE$.listFiles$default$2()))).map((Function1<File, File> & java.io.Serializable & Serializable)f -> f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    public String readAndCloseStream(InputStream stream) {
        String string;
        try {
            string = IOUtils.toString(stream, Charset.defaultCharset());
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
        return string;
    }

    public String stripExtension(String fileName) {
        String string;
        int n = fileName.lastIndexOf(46);
        switch (n) {
            case -1: {
                string = fileName;
                break;
            }
            default: {
                string = fileName.substring(0, n);
                break;
            }
        }
        return string;
    }

    public String replaceOrAppendExtension(String fileName, String extension2) {
        return new StringBuilder(1).append(this.stripExtension(fileName)).append(".").append(extension2).toString();
    }

    public File modifyName(File file, Function1<String, String> f) {
        File parent = file.getParentFile();
        String name = file.getName();
        String newName = f.apply(name);
        return new File(parent, newName);
    }

    public File urlToFile(URL url) {
        return Paths.get(url.toURI()).toFile();
    }

    public String cleanFileName(String string) {
        return string.replaceAll("[ /\\\\:;<>|?*^]", "_").replaceAll("['\"]", "");
    }

    public boolean isBadFileName(String string) {
        String string2 = this.cleanFileName(string);
        String string3 = string;
        return string2 == null ? string3 != null : !string2.equals(string3);
    }

    public String extractModuleName(String path, String sourceDir) {
        String moduleDir = StringUtil$StringUtilExtensions$.MODULE$.prefixBefore$extension(StringUtil$.MODULE$.StringUtilExtensions(path), new StringBuilder(1).append("/").append(sourceDir).toString());
        if (moduleDir.length() == path.length()) {
            return "";
        }
        return StringUtil$StringUtilExtensions$.MODULE$.lastComponent$extension(StringUtil$.MODULE$.StringUtilExtensions(moduleDir), '/');
    }

    public String extractModuleName$default$2() {
        return "src/main/scala";
    }

    public static final /* synthetic */ void $anonfun$copyFromClassPath$1(File target$1, String source$1, URL url) {
        String string = url.getProtocol();
        if ("file".equals(string)) {
            FileUtils.copyDirectory(MODULE$.urlToFile(url), target$1, false);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("jar".equals(string)) {
            JarFile jarFile = new JarFile(MODULE$.jarUrlToJarFile(url));
            JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(jarFile.entries()).asScala().foreach((Function1<JarEntry, Object> & java.io.Serializable & Serializable)entry -> {
                java.io.Serializable serializable;
                String entryPath = entry.getName();
                if (entryPath.startsWith(source$1)) {
                    File entryTarget = new File(target$1, new StringOps(Predef$.MODULE$.augmentString(entryPath)).stripPrefix(source$1));
                    if (entry.isDirectory()) {
                        serializable = BoxesRunTime.boxToBoolean(entryTarget.mkdirs());
                    } else {
                        FileUtils.copyInputStreamToFile(jarFile.getInputStream((ZipEntry)entry), entryTarget);
                        serializable = BoxedUnit.UNIT;
                    }
                } else {
                    serializable = BoxedUnit.UNIT;
                }
                return serializable;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)string);
        }
    }

    private final long urlLastModified$1(URL url) {
        long l;
        String string = url.getProtocol();
        if ("file".equals(string)) {
            long l2;
            File file = this.urlToFile(url);
            if (file.isDirectory()) {
                LongRef result2 = LongRef.create(file.lastModified());
                Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(result2){
                    private final LongRef result$1;

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        this.result$1.elem = package$.MODULE$.max(this.result$1.elem, file.toFile().lastModified());
                        return FileVisitResult.CONTINUE;
                    }

                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        if (exc != null) {
                            throw exc;
                        }
                        this.result$1.elem = package$.MODULE$.max(this.result$1.elem, dir.toFile().lastModified());
                        return FileVisitResult.CONTINUE;
                    }
                    {
                        this.result$1 = result$1;
                    }
                });
                l2 = result2.elem;
            } else {
                l2 = file.lastModified();
            }
            l = l2;
        } else if ("jar".equals(string)) {
            l = this.jarUrlToJarFile(url).lastModified();
        } else {
            throw new MatchError((Object)string);
        }
        return l;
    }

    private FileUtil$() {
        MODULE$ = this;
        this.AcceptAllFiles = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !FileUtil$.MODULE$.file(dir, Predef$.MODULE$.wrapRefArray((Object[])new String[]{name})).isDirectory();
            }
        };
        this.AcceptAllDirectories = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return FileUtil$.MODULE$.file(dir, Predef$.MODULE$.wrapRefArray((Object[])new String[]{name})).isDirectory();
            }
        };
    }
}

