import org.bitbucket.inkytonik.kiama.attribution
import org.bitbucket.inkytonik.kiama.rewriting
import org.ergoplatform
import org.ergoplatform.wallet.protocol.context
import org.ergoplatform.wallet.secrets
import scala
import scala.collection
import scala.collection.immutable
import scala.util
import sigmastate
import sigmastate.basics
import sigmastate.eval
import sigmastate.interpreter
import typing



class ErgoInterpreter(org.ergoplatform.ErgoLikeInterpreter):
    def __init__(self, params: org.ergoplatform.wallet.protocol.context.ErgoLikeParameters, IR: sigmastate.eval.IRContext): ...
    @staticmethod
    def apply(params: org.ergoplatform.wallet.protocol.context.ErgoLikeParameters) -> 'ErgoInterpreter': ...
    @staticmethod
    def avlTreeFromDigest(digest: typing.List[int]) -> sigmastate.AvlTreeData: ...
    def checkExpiredBox(self, box: org.ergoplatform.ErgoBox, output: org.ergoplatform.ErgoBoxCandidate, currentHeight: int) -> bool: ...
    @staticmethod
    def frequentlyUsedScripts() -> scala.collection.Seq[str]: ...
    @staticmethod
    def scriptProcessor() -> sigmastate.interpreter.PrecompiledScriptProcessor: ...
    @typing.overload
    def verify(self, env: scala.collection.immutable.Map[str, typing.Any], ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, proverResult: sigmastate.interpreter.ProverResult, message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...
    @typing.overload
    def verify(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, proof: sigmastate.UncheckedTree, message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...
    @typing.overload
    def verify(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, proverResult: sigmastate.interpreter.ProverResult, message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...
    @typing.overload
    def verify(self, env: scala.collection.immutable.Map[str, typing.Any], exp: sigmastate.Values.ErgoTree, context: org.ergoplatform.ErgoLikeContext, proof: typing.List[int], message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...

class ErgoUnsafeProver:
    @typing.overload
    @staticmethod
    def prove(unsignedTx: org.ergoplatform.UnsignedErgoLikeTransaction, sks: scala.collection.Map[str, sigmastate.basics.DLogProtocol.DLogProverInput]) -> org.ergoplatform.ErgoLikeTransaction: ...
    @typing.overload
    @staticmethod
    def prove(unsignedTx: org.ergoplatform.UnsignedErgoLikeTransaction, sk: sigmastate.basics.DLogProtocol.DLogProverInput) -> org.ergoplatform.ErgoLikeTransaction: ...

class TransactionHintsBag(scala.Product, scala.Serializable):
    def __init__(self, secretHints: scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag], publicHints: scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag]): ...
    def addHintsForInput(self, index: int, hintsBag: sigmastate.interpreter.HintsBag) -> 'TransactionHintsBag': ...
    def allHintsForInput(self, index: int) -> sigmastate.interpreter.HintsBag: ...
    @typing.overload
    @staticmethod
    def apply(mixedHints: scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag]) -> 'TransactionHintsBag': ...
    @typing.overload
    @staticmethod
    def apply(secretHints: scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag], publicHints: scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag]) -> 'TransactionHintsBag': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, secretHints: scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag], publicHints: scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag]) -> 'TransactionHintsBag': ...
    def copy$default$1(self) -> scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag]: ...
    def copy$default$2(self) -> scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag]: ...
    @staticmethod
    def empty() -> 'TransactionHintsBag': ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> str: ...
    def publicHints(self) -> scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag]: ...
    def replaceHintsForInput(self, index: int, hintsBag: sigmastate.interpreter.HintsBag) -> 'TransactionHintsBag': ...
    def secretHints(self) -> scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag]: ...
    def toString(self) -> str: ...
    @staticmethod
    def unapply(x$0: 'TransactionHintsBag') -> scala.Option[scala.Tuple2[scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag], scala.collection.immutable.Map[typing.Any, sigmastate.interpreter.HintsBag]]]: ...

class ErgoProvingInterpreter(ErgoInterpreter, sigmastate.interpreter.ProverInterpreter):
    def __init__(self, secretKeys: scala.collection.IndexedSeq[org.ergoplatform.wallet.secrets.SecretKey], params: org.ergoplatform.wallet.protocol.context.ErgoLikeParameters, cachedHdPubKeysOpt: scala.Option[scala.collection.IndexedSeq[org.ergoplatform.wallet.secrets.ExtendedPublicKey]], IR: sigmastate.eval.IRContext): ...
    @staticmethod
    def $lessinit$greater$default$3() -> scala.Option[scala.collection.IndexedSeq[org.ergoplatform.wallet.secrets.ExtendedPublicKey]]: ...
    def activatedScriptVersion(self) -> int: ...
    @typing.overload
    @staticmethod
    def apply(params: org.ergoplatform.wallet.protocol.context.ErgoLikeParameters) -> ErgoInterpreter: ...
    @typing.overload
    @staticmethod
    def apply(rootSecret: org.ergoplatform.wallet.secrets.ExtendedSecretKey, params: org.ergoplatform.wallet.protocol.context.ErgoLikeParameters) -> 'ErgoProvingInterpreter': ...
    @typing.overload
    @staticmethod
    def apply(secrets: scala.collection.IndexedSeq[org.ergoplatform.wallet.secrets.SecretKey], params: org.ergoplatform.wallet.protocol.context.ErgoLikeParameters) -> 'ErgoProvingInterpreter': ...
    _attrWithName__T = typing.TypeVar('_attrWithName__T')  # <T>
    _attrWithName__U = typing.TypeVar('_attrWithName__U')  # <U>
    def attrWithName(self, name: str, f: scala.Function1[_attrWithName__T, _attrWithName__U]) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CachedAttribute[_attrWithName__T, _attrWithName__U]: ...
    @typing.overload
    def bagForMultisig(self, context: sigmastate.interpreter.InterpreterContext, ergoTree: sigmastate.Values.ErgoTree, proof: typing.List[int], realSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean], simulatedSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> sigmastate.interpreter.HintsBag: ...
    @typing.overload
    def bagForMultisig(self, context: sigmastate.interpreter.InterpreterContext, sigmaTree: sigmastate.Values.SigmaBoolean, proof: typing.List[int], realSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean], simulatedSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> sigmastate.interpreter.HintsBag: ...
    def bagForMultisig$default$5(self) -> scala.collection.Seq[sigmastate.Values.SigmaBoolean]: ...
    def bagForTransaction(self, tx: org.ergoplatform.ErgoLikeTransaction, boxesToSpend: scala.collection.IndexedSeq[org.ergoplatform.ErgoBox], dataBoxes: scala.collection.IndexedSeq[org.ergoplatform.ErgoBox], stateContext: org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext, realSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean], simulatedSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> TransactionHintsBag: ...
    def cachedHdPubKeysOpt(self) -> scala.Option[scala.collection.IndexedSeq[org.ergoplatform.wallet.secrets.ExtendedPublicKey]]: ...
    _circularWithName__T = typing.TypeVar('_circularWithName__T')  # <T>
    _circularWithName__U = typing.TypeVar('_circularWithName__U')  # <U>
    def circularWithName(self, name: str, init: _circularWithName__U, f: scala.Function1[_circularWithName__T, _circularWithName__U]) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CircularAttribute[_circularWithName__T, _circularWithName__U]: ...
    _constant__T = typing.TypeVar('_constant__T')  # <T>
    _constant__U = typing.TypeVar('_constant__U')  # <U>
    def constant(self, name: str, u: scala.Function0[_constant__U]) -> org.bitbucket.inkytonik.kiama.attribution.Attribute[_constant__T, _constant__U]: ...
    def convertToUnchecked(self) -> scala.Function1[sigmastate.ProofTree, sigmastate.UncheckedSigmaTree]: ...
    def convertToUnproven(self, sigmaTree: sigmastate.Values.SigmaBoolean) -> sigmastate.UnprovenTree: ...
    _dynAttrWithName__T = typing.TypeVar('_dynAttrWithName__T')  # <T>
    _dynAttrWithName__U = typing.TypeVar('_dynAttrWithName__U')  # <U>
    def dynAttrWithName(self, name: str, f: scala.Function1[_dynAttrWithName__T, _dynAttrWithName__U]) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CachedDynamicAttribute[_dynAttrWithName__T, _dynAttrWithName__U]: ...
    @typing.overload
    def generateCommitments(self, ergoTree: sigmastate.Values.ErgoTree, ctx: sigmastate.interpreter.InterpreterContext) -> sigmastate.interpreter.HintsBag: ...
    @typing.overload
    def generateCommitments(self, sigmaTree: sigmastate.Values.SigmaBoolean) -> sigmastate.interpreter.HintsBag: ...
    @typing.overload
    def generateCommitmentsFor(self, unsignedTx: org.ergoplatform.UnsignedErgoLikeTransaction, boxesToSpend: scala.collection.IndexedSeq[org.ergoplatform.ErgoBox], dataBoxes: scala.collection.IndexedSeq[org.ergoplatform.ErgoBox], stateContext: org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext) -> scala.util.Try[TransactionHintsBag]: ...
    @typing.overload
    def generateCommitmentsFor(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, generateFor: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> sigmastate.interpreter.HintsBag: ...
    @typing.overload
    def generateCommitmentsFor(self, sigmaTree: sigmastate.Values.SigmaBoolean, generateFor: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> sigmastate.interpreter.HintsBag: ...
    def generateProof(self, sb: sigmastate.Values.SigmaBoolean, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> typing.List[int]: ...
    def hdKeys(self) -> scala.collection.IndexedSeq[org.ergoplatform.wallet.secrets.ExtendedSecretKey]: ...
    def hdPubKeys(self) -> scala.collection.IndexedSeq[org.ergoplatform.wallet.secrets.ExtendedPublicKey]: ...
    _internalToDynamicAttribute__T = typing.TypeVar('_internalToDynamicAttribute__T')  # <T>
    _internalToDynamicAttribute__U = typing.TypeVar('_internalToDynamicAttribute__U')  # <U>
    def internalToDynamicAttribute(self, f: scala.Function1[_internalToDynamicAttribute__T, _internalToDynamicAttribute__U]) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CachedDynamicAttribute[_internalToDynamicAttribute__T, _internalToDynamicAttribute__U]: ...
    def markReal(self, hintsBag: sigmastate.interpreter.HintsBag) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    def org$bitbucket$inkytonik$kiama$attribution$AttributionCore$$CircularAttribute(self) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CircularAttribute.: ...
    _paramAttrWithName__V = typing.TypeVar('_paramAttrWithName__V')  # <V>
    _paramAttrWithName__T = typing.TypeVar('_paramAttrWithName__T')  # <T>
    _paramAttrWithName__U = typing.TypeVar('_paramAttrWithName__U')  # <U>
    def paramAttrWithName(self, name: str, f: scala.Function1[_paramAttrWithName__V, scala.Function1[_paramAttrWithName__T, _paramAttrWithName__U]]) -> org.bitbucket.inkytonik.kiama.attribution.AttributionCore.CachedParamAttribute[_paramAttrWithName__V, _paramAttrWithName__T, _paramAttrWithName__U]: ...
    def polishSimulated(self) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    @typing.overload
    def prove(self, env: scala.collection.immutable.Map[str, typing.Any], ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> scala.util.Try[sigmastate.interpreter.CostedProverResult]: ...
    @typing.overload
    def prove(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, message: typing.List[int]) -> scala.util.Try[sigmastate.interpreter.CostedProverResult]: ...
    @typing.overload
    def prove(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> scala.util.Try[sigmastate.interpreter.CostedProverResult]: ...
    @typing.overload
    def prove(self, unprovenTree: sigmastate.UnprovenTree, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> sigmastate.UncheckedTree: ...
    def prove$default$5(self) -> sigmastate.interpreter.HintsBag: ...
    def proving(self, hintsBag: sigmastate.interpreter.HintsBag) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    def publicKeys(self) -> scala.collection.Seq[sigmastate.Values.SigmaBoolean]: ...
    def secretKeys(self) -> scala.collection.IndexedSeq[org.ergoplatform.wallet.secrets.SecretKey]: ...
    def secrets(self) -> scala.collection.IndexedSeq[sigmastate.basics.SigmaProtocolPrivateInput[typing.Any, typing.Any]]: ...
    def setPositions(self, uc: sigmastate.UnprovenConjecture) -> sigmastate.UnprovenConjecture: ...
    def sigmastate$interpreter$ProverInterpreter$_setter_$convertToUnchecked_$eq(self, x$1: scala.Function1[sigmastate.ProofTree, sigmastate.UncheckedSigmaTree]) -> None: ...
    def sigmastate$interpreter$ProverInterpreter$_setter_$polishSimulated_$eq(self, x$1: org.bitbucket.inkytonik.kiama.rewriting.Strategy) -> None: ...
    def sign(self, unsignedTx: org.ergoplatform.UnsignedErgoLikeTransaction, boxesToSpend: scala.collection.IndexedSeq[org.ergoplatform.ErgoBox], dataBoxes: scala.collection.IndexedSeq[org.ergoplatform.ErgoBox], stateContext: org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext, txHints: TransactionHintsBag) -> scala.util.Try[org.ergoplatform.ErgoLikeTransaction]: ...
    def sign$default$5(self) -> TransactionHintsBag: ...
    def signInputs(self, unsignedTx: org.ergoplatform.UnsignedErgoLikeTransaction, boxesToSpend: scala.collection.IndexedSeq[org.ergoplatform.ErgoBox], dataBoxes: scala.collection.IndexedSeq[org.ergoplatform.ErgoBox], stateContext: org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext, txHints: TransactionHintsBag) -> scala.util.Try[scala.Tuple2[scala.collection.IndexedSeq[org.ergoplatform.Input], typing.Any]]: ...
    def signMessage(self, sigmaTree: sigmastate.Values.SigmaBoolean, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> scala.util.Try[typing.List[int]]: ...
    def simulateAndCommit(self, hintsBag: sigmastate.interpreter.HintsBag) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    def withNewExtendedSecret(self, secret: org.ergoplatform.wallet.secrets.ExtendedSecretKey) -> 'ErgoProvingInterpreter': ...
    def withNewParameters(self, newParams: org.ergoplatform.wallet.protocol.context.ErgoLikeParameters) -> 'ErgoProvingInterpreter': ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.ergoplatform.wallet.interpreter")``.

    ErgoInterpreter: typing.Type[ErgoInterpreter]
    ErgoProvingInterpreter: typing.Type[ErgoProvingInterpreter]
    ErgoUnsafeProver: typing.Type[ErgoUnsafeProver]
    TransactionHintsBag: typing.Type[TransactionHintsBag]
