import java.lang
import java.net
import java.nio
import java.nio.channels
import java.nio.charset
import java.nio.file
import java.security
import java.util
import java.util.stream
import jpype.protocol
import typing



class Closeable(java.lang.AutoCloseable):
    def close(self) -> None: ...

class DataInput:
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> str: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    def readUTF(self) -> str: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def skipBytes(self, int: int) -> int: ...

class DataOutput:
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: str) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: str) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: str) -> None: ...

class FileDescriptor:
    in_: typing.ClassVar['FileDescriptor'] = ...
    out: typing.ClassVar['FileDescriptor'] = ...
    err: typing.ClassVar['FileDescriptor'] = ...
    def __init__(self): ...
    def sync(self) -> None: ...
    def valid(self) -> bool: ...

class FileFilter:
    def accept(self, file: typing.Union['File', jpype.protocol.SupportsPath]) -> bool: ...

class FilenameFilter:
    def accept(self, file: typing.Union['File', jpype.protocol.SupportsPath], string: str) -> bool: ...

class Flushable:
    def flush(self) -> None: ...

class IOError(java.lang.Error):
    def __init__(self, throwable: java.lang.Throwable): ...

class IOException(java.lang.Exception):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, throwable: java.lang.Throwable): ...
    @typing.overload
    def __init__(self, throwable: java.lang.Throwable): ...

class ObjectInputFilter:
    def checkInput(self, filterInfo: 'ObjectInputFilter.FilterInfo') -> 'ObjectInputFilter.Status': ...
    class Config:
        @staticmethod
        def createFilter(string: str) -> 'ObjectInputFilter': ...
        @staticmethod
        def getSerialFilter() -> 'ObjectInputFilter': ...
        @staticmethod
        def setSerialFilter(objectInputFilter: typing.Union['ObjectInputFilter', typing.Callable]) -> None: ...
    class FilterInfo:
        def arrayLength(self) -> int: ...
        def depth(self) -> int: ...
        def references(self) -> int: ...
        def serialClass(self) -> typing.Type[typing.Any]: ...
        def streamBytes(self) -> int: ...
    class Status(java.lang.Enum['ObjectInputFilter.Status']):
        UNDECIDED: typing.ClassVar['ObjectInputFilter.Status'] = ...
        ALLOWED: typing.ClassVar['ObjectInputFilter.Status'] = ...
        REJECTED: typing.ClassVar['ObjectInputFilter.Status'] = ...
        _valueOf_1__T = typing.TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'ObjectInputFilter.Status': ...
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @staticmethod
        def values() -> typing.List['ObjectInputFilter.Status']: ...

class ObjectInputValidation:
    def validateObject(self) -> None: ...

class ObjectStreamConstants:
    STREAM_MAGIC: typing.ClassVar[int] = ...
    STREAM_VERSION: typing.ClassVar[int] = ...
    TC_BASE: typing.ClassVar[int] = ...
    TC_NULL: typing.ClassVar[int] = ...
    TC_REFERENCE: typing.ClassVar[int] = ...
    TC_CLASSDESC: typing.ClassVar[int] = ...
    TC_OBJECT: typing.ClassVar[int] = ...
    TC_STRING: typing.ClassVar[int] = ...
    TC_ARRAY: typing.ClassVar[int] = ...
    TC_CLASS: typing.ClassVar[int] = ...
    TC_BLOCKDATA: typing.ClassVar[int] = ...
    TC_ENDBLOCKDATA: typing.ClassVar[int] = ...
    TC_RESET: typing.ClassVar[int] = ...
    TC_BLOCKDATALONG: typing.ClassVar[int] = ...
    TC_EXCEPTION: typing.ClassVar[int] = ...
    TC_LONGSTRING: typing.ClassVar[int] = ...
    TC_PROXYCLASSDESC: typing.ClassVar[int] = ...
    TC_ENUM: typing.ClassVar[int] = ...
    TC_MAX: typing.ClassVar[int] = ...
    baseWireHandle: typing.ClassVar[int] = ...
    SC_WRITE_METHOD: typing.ClassVar[int] = ...
    SC_BLOCK_DATA: typing.ClassVar[int] = ...
    SC_SERIALIZABLE: typing.ClassVar[int] = ...
    SC_EXTERNALIZABLE: typing.ClassVar[int] = ...
    SC_ENUM: typing.ClassVar[int] = ...
    SUBSTITUTION_PERMISSION: typing.ClassVar['SerializablePermission'] = ...
    SUBCLASS_IMPLEMENTATION_PERMISSION: typing.ClassVar['SerializablePermission'] = ...
    SERIAL_FILTER_PERMISSION: typing.ClassVar['SerializablePermission'] = ...
    PROTOCOL_VERSION_1: typing.ClassVar[int] = ...
    PROTOCOL_VERSION_2: typing.ClassVar[int] = ...

class ObjectStreamField(java.lang.Comparable[typing.Any]):
    @typing.overload
    def __init__(self, string: str, class_: typing.Type[typing.Any]): ...
    @typing.overload
    def __init__(self, string: str, class_: typing.Type[typing.Any], boolean: bool): ...
    def compareTo(self, object: typing.Any) -> int: ...
    def getName(self) -> str: ...
    def getOffset(self) -> int: ...
    def getType(self) -> typing.Type[typing.Any]: ...
    def getTypeCode(self) -> str: ...
    def getTypeString(self) -> str: ...
    def isPrimitive(self) -> bool: ...
    def isUnshared(self) -> bool: ...
    def toString(self) -> str: ...

class Serializable: ...

class SerializablePermission(java.security.BasicPermission):
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...

class StreamTokenizer:
    ttype: int = ...
    TT_EOF: typing.ClassVar[int] = ...
    TT_EOL: typing.ClassVar[int] = ...
    TT_NUMBER: typing.ClassVar[int] = ...
    TT_WORD: typing.ClassVar[int] = ...
    sval: str = ...
    nval: float = ...
    @typing.overload
    def __init__(self, inputStream: 'InputStream'): ...
    @typing.overload
    def __init__(self, reader: 'Reader'): ...
    def commentChar(self, int: int) -> None: ...
    def eolIsSignificant(self, boolean: bool) -> None: ...
    def lineno(self) -> int: ...
    def lowerCaseMode(self, boolean: bool) -> None: ...
    def nextToken(self) -> int: ...
    def ordinaryChar(self, int: int) -> None: ...
    def ordinaryChars(self, int: int, int2: int) -> None: ...
    def parseNumbers(self) -> None: ...
    def pushBack(self) -> None: ...
    def quoteChar(self, int: int) -> None: ...
    def resetSyntax(self) -> None: ...
    def slashSlashComments(self, boolean: bool) -> None: ...
    def slashStarComments(self, boolean: bool) -> None: ...
    def toString(self) -> str: ...
    def whitespaceChars(self, int: int, int2: int) -> None: ...
    def wordChars(self, int: int, int2: int) -> None: ...

class UncheckedIOException(java.lang.RuntimeException):
    @typing.overload
    def __init__(self, iOException: IOException): ...
    @typing.overload
    def __init__(self, string: str, iOException: IOException): ...
    def getCause(self) -> IOException: ...

class CharConversionException(IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class Console(Flushable):
    def flush(self) -> None: ...
    def format(self, string: str, objectArray: typing.List[typing.Any]) -> 'Console': ...
    def printf(self, string: str, objectArray: typing.List[typing.Any]) -> 'Console': ...
    @typing.overload
    def readLine(self) -> str: ...
    @typing.overload
    def readLine(self, string: str, objectArray: typing.List[typing.Any]) -> str: ...
    @typing.overload
    def readPassword(self) -> typing.List[str]: ...
    @typing.overload
    def readPassword(self, string: str, objectArray: typing.List[typing.Any]) -> typing.List[str]: ...
    def reader(self) -> 'Reader': ...
    def writer(self) -> 'PrintWriter': ...

class EOFException(IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class Externalizable(Serializable):
    def readExternal(self, objectInput: 'ObjectInput') -> None: ...
    def writeExternal(self, objectOutput: 'ObjectOutput') -> None: ...

class File(Serializable, java.lang.Comparable['File']):
    separatorChar: typing.ClassVar[str] = ...
    separator: typing.ClassVar[str] = ...
    pathSeparatorChar: typing.ClassVar[str] = ...
    pathSeparator: typing.ClassVar[str] = ...
    @typing.overload
    def __init__(self, file: typing.Union['File', jpype.protocol.SupportsPath], string: str): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, uRI: java.net.URI): ...
    def canExecute(self) -> bool: ...
    def canRead(self) -> bool: ...
    def canWrite(self) -> bool: ...
    def compareTo(self, file: typing.Union['File', jpype.protocol.SupportsPath]) -> int: ...
    def createNewFile(self) -> bool: ...
    @typing.overload
    @staticmethod
    def createTempFile(string: str, string2: str) -> 'File': ...
    @typing.overload
    @staticmethod
    def createTempFile(string: str, string2: str, file: typing.Union['File', jpype.protocol.SupportsPath]) -> 'File': ...
    def delete(self) -> bool: ...
    def deleteOnExit(self) -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    def exists(self) -> bool: ...
    def getAbsoluteFile(self) -> 'File': ...
    def getAbsolutePath(self) -> str: ...
    def getCanonicalFile(self) -> 'File': ...
    def getCanonicalPath(self) -> str: ...
    def getFreeSpace(self) -> int: ...
    def getName(self) -> str: ...
    def getParent(self) -> str: ...
    def getParentFile(self) -> 'File': ...
    def getPath(self) -> str: ...
    def getTotalSpace(self) -> int: ...
    def getUsableSpace(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAbsolute(self) -> bool: ...
    def isDirectory(self) -> bool: ...
    def isFile(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def lastModified(self) -> int: ...
    def length(self) -> int: ...
    @typing.overload
    def list(self) -> typing.List[str]: ...
    @typing.overload
    def list(self, filenameFilter: typing.Union[FilenameFilter, typing.Callable]) -> typing.List[str]: ...
    @typing.overload
    def listFiles(self) -> typing.List['File']: ...
    @typing.overload
    def listFiles(self, fileFilter: typing.Union[FileFilter, typing.Callable]) -> typing.List['File']: ...
    @typing.overload
    def listFiles(self, filenameFilter: typing.Union[FilenameFilter, typing.Callable]) -> typing.List['File']: ...
    @staticmethod
    def listRoots() -> typing.List['File']: ...
    def mkdir(self) -> bool: ...
    def mkdirs(self) -> bool: ...
    def renameTo(self, file: typing.Union['File', jpype.protocol.SupportsPath]) -> bool: ...
    @typing.overload
    def setExecutable(self, boolean: bool) -> bool: ...
    @typing.overload
    def setExecutable(self, boolean: bool, boolean2: bool) -> bool: ...
    def setLastModified(self, long: int) -> bool: ...
    def setReadOnly(self) -> bool: ...
    @typing.overload
    def setReadable(self, boolean: bool) -> bool: ...
    @typing.overload
    def setReadable(self, boolean: bool, boolean2: bool) -> bool: ...
    @typing.overload
    def setWritable(self, boolean: bool) -> bool: ...
    @typing.overload
    def setWritable(self, boolean: bool, boolean2: bool) -> bool: ...
    def toPath(self) -> java.nio.file.Path: ...
    def toString(self) -> str: ...
    def toURI(self) -> java.net.URI: ...
    def toURL(self) -> java.net.URL: ...

class FileNotFoundException(IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class FilePermission(java.security.Permission, Serializable):
    def __init__(self, string: str, string2: str): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getActions(self) -> str: ...
    def hashCode(self) -> int: ...
    def implies(self, permission: java.security.Permission) -> bool: ...
    def newPermissionCollection(self) -> java.security.PermissionCollection: ...

class InputStream(Closeable):
    def __init__(self): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @staticmethod
    def nullInputStream() -> 'InputStream': ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def readAllBytes(self) -> typing.List[int]: ...
    @typing.overload
    def readNBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def readNBytes(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...
    def transferTo(self, outputStream: 'OutputStream') -> int: ...

class InterruptedIOException(IOException):
    bytesTransferred: int = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class ObjectInput(DataInput, java.lang.AutoCloseable):
    def available(self) -> int: ...
    def close(self) -> None: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def readObject(self) -> typing.Any: ...
    def skip(self, long: int) -> int: ...

class ObjectOutput(DataOutput, java.lang.AutoCloseable):
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    def writeObject(self, object: typing.Any) -> None: ...

class ObjectStreamClass(Serializable):
    NO_FIELDS: typing.ClassVar[typing.List[ObjectStreamField]] = ...
    def forClass(self) -> typing.Type[typing.Any]: ...
    def getField(self, string: str) -> ObjectStreamField: ...
    def getFields(self) -> typing.List[ObjectStreamField]: ...
    def getName(self) -> str: ...
    def getSerialVersionUID(self) -> int: ...
    @staticmethod
    def lookup(class_: typing.Type[typing.Any]) -> 'ObjectStreamClass': ...
    @staticmethod
    def lookupAny(class_: typing.Type[typing.Any]) -> 'ObjectStreamClass': ...
    def toString(self) -> str: ...

class ObjectStreamException(IOException): ...

class OutputStream(Closeable, Flushable):
    def __init__(self): ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @staticmethod
    def nullOutputStream() -> 'OutputStream': ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...

class RandomAccessFile(DataOutput, DataInput, Closeable):
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath], string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    def close(self) -> None: ...
    def getChannel(self) -> java.nio.channels.FileChannel: ...
    def getFD(self) -> FileDescriptor: ...
    def getFilePointer(self) -> int: ...
    def length(self) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> str: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    def readUTF(self) -> str: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def seek(self, long: int) -> None: ...
    def setLength(self, long: int) -> None: ...
    def skipBytes(self, int: int) -> int: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: str) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: str) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: str) -> None: ...

class Reader(java.lang.Readable, Closeable):
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @staticmethod
    def nullReader() -> 'Reader': ...
    @typing.overload
    def read(self, charArray: typing.List[str], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str]) -> int: ...
    @typing.overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...
    def transferTo(self, writer: 'Writer') -> int: ...

class SyncFailedException(IOException):
    def __init__(self, string: str): ...

class UTFDataFormatException(IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class UnsupportedEncodingException(IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class Writer(java.lang.Appendable, Closeable, Flushable):
    @typing.overload
    def append(self, char: str) -> 'Writer': ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str]) -> 'Writer': ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str], int: int, int2: int) -> 'Writer': ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @staticmethod
    def nullWriter() -> 'Writer': ...
    @typing.overload
    def write(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str]) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, string: str) -> None: ...
    @typing.overload
    def write(self, string: str, int: int, int2: int) -> None: ...

class BufferedReader(Reader):
    @typing.overload
    def __init__(self, reader: Reader): ...
    @typing.overload
    def __init__(self, reader: Reader, int: int): ...
    def close(self) -> None: ...
    def lines(self) -> java.util.stream.Stream[str]: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str]) -> int: ...
    @typing.overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def readLine(self) -> str: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class BufferedWriter(Writer):
    @typing.overload
    def __init__(self, writer: Writer): ...
    @typing.overload
    def __init__(self, writer: Writer, int: int): ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def newLine(self) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, string: str, int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str]) -> None: ...
    @typing.overload
    def write(self, string: str) -> None: ...

class ByteArrayInputStream(InputStream):
    @typing.overload
    def __init__(self, byteArray: typing.List[int]): ...
    @typing.overload
    def __init__(self, byteArray: typing.List[int], int: int, int2: int): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def readAllBytes(self) -> typing.List[int]: ...
    @typing.overload
    def readNBytes(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def readNBytes(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...
    def transferTo(self, outputStream: OutputStream) -> int: ...

class ByteArrayOutputStream(OutputStream):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    def close(self) -> None: ...
    def reset(self) -> None: ...
    def size(self) -> int: ...
    def toByteArray(self) -> typing.List[int]: ...
    @typing.overload
    def toString(self) -> str: ...
    @typing.overload
    def toString(self, int: int) -> str: ...
    @typing.overload
    def toString(self, string: str) -> str: ...
    @typing.overload
    def toString(self, charset: java.nio.charset.Charset) -> str: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    def writeBytes(self, byteArray: typing.List[int]) -> None: ...
    def writeTo(self, outputStream: OutputStream) -> None: ...

class CharArrayReader(Reader):
    @typing.overload
    def __init__(self, charArray: typing.List[str]): ...
    @typing.overload
    def __init__(self, charArray: typing.List[str], int: int, int2: int): ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str]) -> int: ...
    @typing.overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class CharArrayWriter(Writer):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def append(self, char: str) -> 'CharArrayWriter': ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str]) -> 'CharArrayWriter': ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str], int: int, int2: int) -> 'CharArrayWriter': ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def reset(self) -> None: ...
    def size(self) -> int: ...
    def toCharArray(self) -> typing.List[str]: ...
    def toString(self) -> str: ...
    @typing.overload
    def write(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, string: str, int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str]) -> None: ...
    @typing.overload
    def write(self, string: str) -> None: ...
    def writeTo(self, writer: Writer) -> None: ...

class FileInputStream(InputStream):
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, fileDescriptor: FileDescriptor): ...
    @typing.overload
    def __init__(self, string: str): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def getChannel(self) -> java.nio.channels.FileChannel: ...
    def getFD(self) -> FileDescriptor: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def skip(self, long: int) -> int: ...

class FileOutputStream(OutputStream):
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath], boolean: bool): ...
    @typing.overload
    def __init__(self, fileDescriptor: FileDescriptor): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, boolean: bool): ...
    def close(self) -> None: ...
    def getChannel(self) -> java.nio.channels.FileChannel: ...
    def getFD(self) -> FileDescriptor: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...

class FilterInputStream(InputStream):
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class FilterOutputStream(OutputStream):
    def __init__(self, outputStream: OutputStream): ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...

class FilterReader(Reader):
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str]) -> int: ...
    @typing.overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class FilterWriter(Writer):
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, string: str, int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str]) -> None: ...
    @typing.overload
    def write(self, string: str) -> None: ...

class InputStreamReader(Reader):
    @typing.overload
    def __init__(self, inputStream: InputStream): ...
    @typing.overload
    def __init__(self, inputStream: InputStream, string: str): ...
    @typing.overload
    def __init__(self, inputStream: InputStream, charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, inputStream: InputStream, charsetDecoder: java.nio.charset.CharsetDecoder): ...
    def close(self) -> None: ...
    def getEncoding(self) -> str: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str]) -> int: ...
    @typing.overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def ready(self) -> bool: ...

class InvalidClassException(ObjectStreamException):
    classname: str = ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    def getMessage(self) -> str: ...

class InvalidObjectException(ObjectStreamException):
    def __init__(self, string: str): ...

class NotActiveException(ObjectStreamException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class NotSerializableException(ObjectStreamException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class ObjectInputStream(InputStream, ObjectInput, ObjectStreamConstants):
    def __init__(self, inputStream: InputStream): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def defaultReadObject(self) -> None: ...
    def getObjectInputFilter(self) -> ObjectInputFilter: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFields(self) -> 'ObjectInputStream.GetField': ...
    def readFloat(self) -> float: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> str: ...
    def readLong(self) -> int: ...
    def readObject(self) -> typing.Any: ...
    def readShort(self) -> int: ...
    def readUTF(self) -> str: ...
    def readUnshared(self) -> typing.Any: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def registerValidation(self, objectInputValidation: ObjectInputValidation, int: int) -> None: ...
    def setObjectInputFilter(self, objectInputFilter: typing.Union[ObjectInputFilter, typing.Callable]) -> None: ...
    def skipBytes(self, int: int) -> int: ...
    class GetField:
        def __init__(self): ...
        def defaulted(self, string: str) -> bool: ...
        @typing.overload
        def get(self, string: str, boolean: bool) -> bool: ...
        @typing.overload
        def get(self, string: str, byte: int) -> int: ...
        @typing.overload
        def get(self, string: str, char: str) -> str: ...
        @typing.overload
        def get(self, string: str, double: float) -> float: ...
        @typing.overload
        def get(self, string: str, float: float) -> float: ...
        @typing.overload
        def get(self, string: str, int: int) -> int: ...
        @typing.overload
        def get(self, string: str, object: typing.Any) -> typing.Any: ...
        @typing.overload
        def get(self, string: str, long: int) -> int: ...
        @typing.overload
        def get(self, string: str, short: int) -> int: ...
        def getObjectStreamClass(self) -> ObjectStreamClass: ...

class ObjectOutputStream(OutputStream, ObjectOutput, ObjectStreamConstants):
    def __init__(self, outputStream: OutputStream): ...
    def close(self) -> None: ...
    def defaultWriteObject(self) -> None: ...
    def flush(self) -> None: ...
    def putFields(self) -> 'ObjectOutputStream.PutField': ...
    def reset(self) -> None: ...
    def useProtocolVersion(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: str) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: str) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFields(self) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeObject(self, object: typing.Any) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: str) -> None: ...
    def writeUnshared(self, object: typing.Any) -> None: ...
    class PutField:
        def __init__(self): ...
        @typing.overload
        def put(self, string: str, boolean: bool) -> None: ...
        @typing.overload
        def put(self, string: str, byte: int) -> None: ...
        @typing.overload
        def put(self, string: str, char: str) -> None: ...
        @typing.overload
        def put(self, string: str, double: float) -> None: ...
        @typing.overload
        def put(self, string: str, float: float) -> None: ...
        @typing.overload
        def put(self, string: str, int: int) -> None: ...
        @typing.overload
        def put(self, string: str, object: typing.Any) -> None: ...
        @typing.overload
        def put(self, string: str, long: int) -> None: ...
        @typing.overload
        def put(self, string: str, short: int) -> None: ...
        def write(self, objectOutput: ObjectOutput) -> None: ...

class OptionalDataException(ObjectStreamException):
    length: int = ...
    eof: bool = ...

class OutputStreamWriter(Writer):
    @typing.overload
    def __init__(self, outputStream: OutputStream): ...
    @typing.overload
    def __init__(self, outputStream: OutputStream, string: str): ...
    @typing.overload
    def __init__(self, outputStream: OutputStream, charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, outputStream: OutputStream, charsetEncoder: java.nio.charset.CharsetEncoder): ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str]) -> Writer: ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str], int: int, int2: int) -> Writer: ...
    @typing.overload
    def append(self, char: str) -> Writer: ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def getEncoding(self) -> str: ...
    @typing.overload
    def write(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, string: str, int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str]) -> None: ...
    @typing.overload
    def write(self, string: str) -> None: ...

class PipedInputStream(InputStream):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, pipedOutputStream: 'PipedOutputStream'): ...
    @typing.overload
    def __init__(self, pipedOutputStream: 'PipedOutputStream', int: int): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def connect(self, pipedOutputStream: 'PipedOutputStream') -> None: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...

class PipedOutputStream(OutputStream):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, pipedInputStream: PipedInputStream): ...
    def close(self) -> None: ...
    def connect(self, pipedInputStream: PipedInputStream) -> None: ...
    def flush(self) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...

class PipedReader(Reader):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, pipedWriter: 'PipedWriter'): ...
    @typing.overload
    def __init__(self, pipedWriter: 'PipedWriter', int: int): ...
    def close(self) -> None: ...
    def connect(self, pipedWriter: 'PipedWriter') -> None: ...
    @typing.overload
    def read(self, charArray: typing.List[str]) -> int: ...
    @typing.overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str], int: int, int2: int) -> int: ...
    def ready(self) -> bool: ...

class PipedWriter(Writer):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, pipedReader: PipedReader): ...
    def close(self) -> None: ...
    def connect(self, pipedReader: PipedReader) -> None: ...
    def flush(self) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str]) -> None: ...
    @typing.overload
    def write(self, string: str) -> None: ...
    @typing.overload
    def write(self, string: str, int: int, int2: int) -> None: ...

class PrintWriter(Writer):
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath], string: str): ...
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath], charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, outputStream: OutputStream): ...
    @typing.overload
    def __init__(self, outputStream: OutputStream, boolean: bool): ...
    @typing.overload
    def __init__(self, outputStream: OutputStream, boolean: bool, charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, writer: Writer): ...
    @typing.overload
    def __init__(self, writer: Writer, boolean: bool): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, charset: java.nio.charset.Charset): ...
    @typing.overload
    def append(self, char: str) -> 'PrintWriter': ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str]) -> 'PrintWriter': ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str], int: int, int2: int) -> 'PrintWriter': ...
    def checkError(self) -> bool: ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @typing.overload
    def format(self, string: str, objectArray: typing.List[typing.Any]) -> 'PrintWriter': ...
    @typing.overload
    def format(self, locale: java.util.Locale, string: str, objectArray: typing.List[typing.Any]) -> 'PrintWriter': ...
    @typing.overload
    def printf(self, string: str, objectArray: typing.List[typing.Any]) -> 'PrintWriter': ...
    @typing.overload
    def printf(self, locale: java.util.Locale, string: str, objectArray: typing.List[typing.Any]) -> 'PrintWriter': ...
    @typing.overload
    def println(self) -> None: ...
    @typing.overload
    def println(self, boolean: bool) -> None: ...
    @typing.overload
    def println(self, char: str) -> None: ...
    @typing.overload
    def println(self, charArray: typing.List[str]) -> None: ...
    @typing.overload
    def println(self, double: float) -> None: ...
    @typing.overload
    def println(self, float: float) -> None: ...
    @typing.overload
    def println(self, int: int) -> None: ...
    @typing.overload
    def println(self, object: typing.Any) -> None: ...
    @typing.overload
    def println(self, string: str) -> None: ...
    @typing.overload
    def println(self, long: int) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str]) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, string: str) -> None: ...
    @typing.overload
    def write(self, string: str, int: int, int2: int) -> None: ...

class SequenceInputStream(InputStream):
    @typing.overload
    def __init__(self, inputStream: InputStream, inputStream2: InputStream): ...
    @typing.overload
    def __init__(self, enumeration: java.util.Enumeration[InputStream]): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...

class StreamCorruptedException(ObjectStreamException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class StringBufferInputStream(InputStream):
    def __init__(self, string: str): ...
    def available(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class StringReader(Reader):
    def __init__(self, string: str): ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self, charArray: typing.List[str]) -> int: ...
    @typing.overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str], int: int, int2: int) -> int: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class StringWriter(Writer):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def append(self, char: str) -> 'StringWriter': ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str]) -> 'StringWriter': ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str], int: int, int2: int) -> 'StringWriter': ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    def getBuffer(self) -> java.lang.StringBuffer: ...
    def toString(self) -> str: ...
    @typing.overload
    def write(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, string: str) -> None: ...
    @typing.overload
    def write(self, string: str, int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, charArray: typing.List[str]) -> None: ...

class WriteAbortedException(ObjectStreamException):
    detail: java.lang.Exception = ...
    def __init__(self, string: str, exception: java.lang.Exception): ...
    def getCause(self) -> java.lang.Throwable: ...
    def getMessage(self) -> str: ...

class BufferedInputStream(FilterInputStream):
    @typing.overload
    def __init__(self, inputStream: InputStream): ...
    @typing.overload
    def __init__(self, inputStream: InputStream, int: int): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class BufferedOutputStream(FilterOutputStream):
    @typing.overload
    def __init__(self, outputStream: OutputStream): ...
    @typing.overload
    def __init__(self, outputStream: OutputStream, int: int): ...
    def flush(self) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...

class DataInputStream(FilterInputStream, DataInput):
    def __init__(self, inputStream: InputStream): ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    def readBoolean(self) -> bool: ...
    def readByte(self) -> int: ...
    def readChar(self) -> str: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def readFully(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    def readInt(self) -> int: ...
    def readLine(self) -> str: ...
    def readLong(self) -> int: ...
    def readShort(self) -> int: ...
    @typing.overload
    def readUTF(self) -> str: ...
    @typing.overload
    @staticmethod
    def readUTF(dataInput: DataInput) -> str: ...
    def readUnsignedByte(self) -> int: ...
    def readUnsignedShort(self) -> int: ...
    def skipBytes(self, int: int) -> int: ...

class DataOutputStream(FilterOutputStream, DataOutput):
    def __init__(self, outputStream: OutputStream): ...
    def flush(self) -> None: ...
    def size(self) -> int: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    def writeBoolean(self, boolean: bool) -> None: ...
    def writeByte(self, int: int) -> None: ...
    def writeBytes(self, string: str) -> None: ...
    def writeChar(self, int: int) -> None: ...
    def writeChars(self, string: str) -> None: ...
    def writeDouble(self, double: float) -> None: ...
    def writeFloat(self, float: float) -> None: ...
    def writeInt(self, int: int) -> None: ...
    def writeLong(self, long: int) -> None: ...
    def writeShort(self, int: int) -> None: ...
    def writeUTF(self, string: str) -> None: ...

class FileReader(InputStreamReader):
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath], charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, fileDescriptor: FileDescriptor): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, charset: java.nio.charset.Charset): ...

class FileWriter(OutputStreamWriter):
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath], boolean: bool): ...
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath], charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath], charset: java.nio.charset.Charset, boolean: bool): ...
    @typing.overload
    def __init__(self, fileDescriptor: FileDescriptor): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, boolean: bool): ...
    @typing.overload
    def __init__(self, string: str, charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, string: str, charset: java.nio.charset.Charset, boolean: bool): ...

class LineNumberInputStream(FilterInputStream):
    def __init__(self, inputStream: InputStream): ...
    def available(self) -> int: ...
    def getLineNumber(self) -> int: ...
    def mark(self, int: int) -> None: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def setLineNumber(self, int: int) -> None: ...
    def skip(self, long: int) -> int: ...

class LineNumberReader(BufferedReader):
    @typing.overload
    def __init__(self, reader: Reader): ...
    @typing.overload
    def __init__(self, reader: Reader, int: int): ...
    def getLineNumber(self) -> int: ...
    def mark(self, int: int) -> None: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str]) -> int: ...
    @typing.overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def readLine(self) -> str: ...
    def reset(self) -> None: ...
    def setLineNumber(self, int: int) -> None: ...
    def skip(self, long: int) -> int: ...

class PrintStream(FilterOutputStream, java.lang.Appendable, Closeable):
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath], string: str): ...
    @typing.overload
    def __init__(self, file: typing.Union[File, jpype.protocol.SupportsPath], charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, outputStream: OutputStream): ...
    @typing.overload
    def __init__(self, outputStream: OutputStream, boolean: bool): ...
    @typing.overload
    def __init__(self, outputStream: OutputStream, boolean: bool, string: str): ...
    @typing.overload
    def __init__(self, outputStream: OutputStream, boolean: bool, charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, string2: str): ...
    @typing.overload
    def __init__(self, string: str, charset: java.nio.charset.Charset): ...
    @typing.overload
    def append(self, char: str) -> 'PrintStream': ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str]) -> 'PrintStream': ...
    @typing.overload
    def append(self, charSequence: typing.Union[java.lang.CharSequence, str], int: int, int2: int) -> 'PrintStream': ...
    def checkError(self) -> bool: ...
    def close(self) -> None: ...
    def flush(self) -> None: ...
    @typing.overload
    def format(self, string: str, objectArray: typing.List[typing.Any]) -> 'PrintStream': ...
    @typing.overload
    def format(self, locale: java.util.Locale, string: str, objectArray: typing.List[typing.Any]) -> 'PrintStream': ...
    @typing.overload
    def printf(self, string: str, objectArray: typing.List[typing.Any]) -> 'PrintStream': ...
    @typing.overload
    def printf(self, locale: java.util.Locale, string: str, objectArray: typing.List[typing.Any]) -> 'PrintStream': ...
    @typing.overload
    def println(self) -> None: ...
    @typing.overload
    def println(self, boolean: bool) -> None: ...
    @typing.overload
    def println(self, char: str) -> None: ...
    @typing.overload
    def println(self, charArray: typing.List[str]) -> None: ...
    @typing.overload
    def println(self, double: float) -> None: ...
    @typing.overload
    def println(self, float: float) -> None: ...
    @typing.overload
    def println(self, int: int) -> None: ...
    @typing.overload
    def println(self, object: typing.Any) -> None: ...
    @typing.overload
    def println(self, string: str) -> None: ...
    @typing.overload
    def println(self, long: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...

class PushbackInputStream(FilterInputStream):
    @typing.overload
    def __init__(self, inputStream: InputStream): ...
    @typing.overload
    def __init__(self, inputStream: InputStream, int: int): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...
    @typing.overload
    def unread(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def unread(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def unread(self, int: int) -> None: ...

class PushbackReader(FilterReader):
    @typing.overload
    def __init__(self, reader: Reader): ...
    @typing.overload
    def __init__(self, reader: Reader, int: int): ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self, charArray: typing.List[str]) -> int: ...
    @typing.overload
    def read(self, charBuffer: java.nio.CharBuffer) -> int: ...
    def ready(self) -> bool: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...
    @typing.overload
    def unread(self, charArray: typing.List[str]) -> None: ...
    @typing.overload
    def unread(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
    @typing.overload
    def unread(self, int: int) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.io")``.

    BufferedInputStream: typing.Type[BufferedInputStream]
    BufferedOutputStream: typing.Type[BufferedOutputStream]
    BufferedReader: typing.Type[BufferedReader]
    BufferedWriter: typing.Type[BufferedWriter]
    ByteArrayInputStream: typing.Type[ByteArrayInputStream]
    ByteArrayOutputStream: typing.Type[ByteArrayOutputStream]
    CharArrayReader: typing.Type[CharArrayReader]
    CharArrayWriter: typing.Type[CharArrayWriter]
    CharConversionException: typing.Type[CharConversionException]
    Closeable: typing.Type[Closeable]
    Console: typing.Type[Console]
    DataInput: typing.Type[DataInput]
    DataInputStream: typing.Type[DataInputStream]
    DataOutput: typing.Type[DataOutput]
    DataOutputStream: typing.Type[DataOutputStream]
    EOFException: typing.Type[EOFException]
    Externalizable: typing.Type[Externalizable]
    File: typing.Type[File]
    FileDescriptor: typing.Type[FileDescriptor]
    FileFilter: typing.Type[FileFilter]
    FileInputStream: typing.Type[FileInputStream]
    FileNotFoundException: typing.Type[FileNotFoundException]
    FileOutputStream: typing.Type[FileOutputStream]
    FilePermission: typing.Type[FilePermission]
    FileReader: typing.Type[FileReader]
    FileWriter: typing.Type[FileWriter]
    FilenameFilter: typing.Type[FilenameFilter]
    FilterInputStream: typing.Type[FilterInputStream]
    FilterOutputStream: typing.Type[FilterOutputStream]
    FilterReader: typing.Type[FilterReader]
    FilterWriter: typing.Type[FilterWriter]
    Flushable: typing.Type[Flushable]
    IOError: typing.Type[IOError]
    IOException: typing.Type[IOException]
    InputStream: typing.Type[InputStream]
    InputStreamReader: typing.Type[InputStreamReader]
    InterruptedIOException: typing.Type[InterruptedIOException]
    InvalidClassException: typing.Type[InvalidClassException]
    InvalidObjectException: typing.Type[InvalidObjectException]
    LineNumberInputStream: typing.Type[LineNumberInputStream]
    LineNumberReader: typing.Type[LineNumberReader]
    NotActiveException: typing.Type[NotActiveException]
    NotSerializableException: typing.Type[NotSerializableException]
    ObjectInput: typing.Type[ObjectInput]
    ObjectInputFilter: typing.Type[ObjectInputFilter]
    ObjectInputStream: typing.Type[ObjectInputStream]
    ObjectInputValidation: typing.Type[ObjectInputValidation]
    ObjectOutput: typing.Type[ObjectOutput]
    ObjectOutputStream: typing.Type[ObjectOutputStream]
    ObjectStreamClass: typing.Type[ObjectStreamClass]
    ObjectStreamConstants: typing.Type[ObjectStreamConstants]
    ObjectStreamException: typing.Type[ObjectStreamException]
    ObjectStreamField: typing.Type[ObjectStreamField]
    OptionalDataException: typing.Type[OptionalDataException]
    OutputStream: typing.Type[OutputStream]
    OutputStreamWriter: typing.Type[OutputStreamWriter]
    PipedInputStream: typing.Type[PipedInputStream]
    PipedOutputStream: typing.Type[PipedOutputStream]
    PipedReader: typing.Type[PipedReader]
    PipedWriter: typing.Type[PipedWriter]
    PrintStream: typing.Type[PrintStream]
    PrintWriter: typing.Type[PrintWriter]
    PushbackInputStream: typing.Type[PushbackInputStream]
    PushbackReader: typing.Type[PushbackReader]
    RandomAccessFile: typing.Type[RandomAccessFile]
    Reader: typing.Type[Reader]
    SequenceInputStream: typing.Type[SequenceInputStream]
    Serializable: typing.Type[Serializable]
    SerializablePermission: typing.Type[SerializablePermission]
    StreamCorruptedException: typing.Type[StreamCorruptedException]
    StreamTokenizer: typing.Type[StreamTokenizer]
    StringBufferInputStream: typing.Type[StringBufferInputStream]
    StringReader: typing.Type[StringReader]
    StringWriter: typing.Type[StringWriter]
    SyncFailedException: typing.Type[SyncFailedException]
    UTFDataFormatException: typing.Type[UTFDataFormatException]
    UncheckedIOException: typing.Type[UncheckedIOException]
    UnsupportedEncodingException: typing.Type[UnsupportedEncodingException]
    WriteAbortedException: typing.Type[WriteAbortedException]
    Writer: typing.Type[Writer]
