import java
import java.io
import java.lang
import java.nio
import java.nio.charset
import java.nio.file.attribute
import java.time
import java.util
import java.util.stream
import jpype.protocol
import typing



class CheckedInputStream(java.io.FilterInputStream):
    def __init__(self, inputStream: java.io.InputStream, checksum: 'Checksum'): ...
    def getChecksum(self) -> 'Checksum': ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def skip(self, long: int) -> int: ...

class CheckedOutputStream(java.io.FilterOutputStream):
    def __init__(self, outputStream: java.io.OutputStream, checksum: 'Checksum'): ...
    def getChecksum(self) -> 'Checksum': ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...

class Checksum:
    def getValue(self) -> int: ...
    def reset(self) -> None: ...
    @typing.overload
    def update(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def update(self, int: int) -> None: ...
    @typing.overload
    def update(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def update(self, byteBuffer: java.nio.ByteBuffer) -> None: ...

class DataFormatException(java.lang.Exception):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class Deflater:
    DEFLATED: typing.ClassVar[int] = ...
    NO_COMPRESSION: typing.ClassVar[int] = ...
    BEST_SPEED: typing.ClassVar[int] = ...
    BEST_COMPRESSION: typing.ClassVar[int] = ...
    DEFAULT_COMPRESSION: typing.ClassVar[int] = ...
    FILTERED: typing.ClassVar[int] = ...
    HUFFMAN_ONLY: typing.ClassVar[int] = ...
    DEFAULT_STRATEGY: typing.ClassVar[int] = ...
    NO_FLUSH: typing.ClassVar[int] = ...
    SYNC_FLUSH: typing.ClassVar[int] = ...
    FULL_FLUSH: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, int: int): ...
    @typing.overload
    def __init__(self, int: int, boolean: bool): ...
    @typing.overload
    def deflate(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def deflate(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def deflate(self, byteArray: typing.List[int], int: int, int2: int, int3: int) -> int: ...
    @typing.overload
    def deflate(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    @typing.overload
    def deflate(self, byteBuffer: java.nio.ByteBuffer, int: int) -> int: ...
    def end(self) -> None: ...
    def finish(self) -> None: ...
    def finished(self) -> bool: ...
    def getAdler(self) -> int: ...
    def getBytesRead(self) -> int: ...
    def getBytesWritten(self) -> int: ...
    def getTotalIn(self) -> int: ...
    def getTotalOut(self) -> int: ...
    def needsInput(self) -> bool: ...
    def reset(self) -> None: ...
    @typing.overload
    def setDictionary(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def setDictionary(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def setDictionary(self, byteBuffer: java.nio.ByteBuffer) -> None: ...
    @typing.overload
    def setInput(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def setInput(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def setInput(self, byteBuffer: java.nio.ByteBuffer) -> None: ...
    def setLevel(self, int: int) -> None: ...
    def setStrategy(self, int: int) -> None: ...

class DeflaterInputStream(java.io.FilterInputStream):
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream): ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream, deflater: Deflater): ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream, deflater: Deflater, int: int): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class DeflaterOutputStream(java.io.FilterOutputStream):
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, boolean: bool): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, deflater: Deflater): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, deflater: Deflater, boolean: bool): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, deflater: Deflater, int: int): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, deflater: Deflater, int: int, boolean: bool): ...
    def close(self) -> None: ...
    def finish(self) -> None: ...
    def flush(self) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...

class Inflater:
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, boolean: bool): ...
    def end(self) -> None: ...
    def finished(self) -> bool: ...
    def getAdler(self) -> int: ...
    def getBytesRead(self) -> int: ...
    def getBytesWritten(self) -> int: ...
    def getRemaining(self) -> int: ...
    def getTotalIn(self) -> int: ...
    def getTotalOut(self) -> int: ...
    @typing.overload
    def inflate(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def inflate(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def inflate(self, byteBuffer: java.nio.ByteBuffer) -> int: ...
    def needsDictionary(self) -> bool: ...
    def needsInput(self) -> bool: ...
    def reset(self) -> None: ...
    @typing.overload
    def setDictionary(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def setDictionary(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def setDictionary(self, byteBuffer: java.nio.ByteBuffer) -> None: ...
    @typing.overload
    def setInput(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def setInput(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def setInput(self, byteBuffer: java.nio.ByteBuffer) -> None: ...

class InflaterInputStream(java.io.FilterInputStream):
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream): ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream, inflater: Inflater): ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream, inflater: Inflater, int: int): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def mark(self, int: int) -> None: ...
    def markSupported(self) -> bool: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def reset(self) -> None: ...
    def skip(self, long: int) -> int: ...

class InflaterOutputStream(java.io.FilterOutputStream):
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, inflater: Inflater): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, inflater: Inflater, int: int): ...
    def close(self) -> None: ...
    def finish(self) -> None: ...
    def flush(self) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...

class ZipError(java.lang.InternalError):
    def __init__(self, string: str): ...

class ZipException(java.io.IOException):
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, string: str): ...

class Adler32(Checksum):
    def __init__(self): ...
    def getValue(self) -> int: ...
    def reset(self) -> None: ...
    @typing.overload
    def update(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def update(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def update(self, int: int) -> None: ...
    @typing.overload
    def update(self, byteBuffer: java.nio.ByteBuffer) -> None: ...

class CRC32(Checksum):
    def __init__(self): ...
    def getValue(self) -> int: ...
    def reset(self) -> None: ...
    @typing.overload
    def update(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def update(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def update(self, int: int) -> None: ...
    @typing.overload
    def update(self, byteBuffer: java.nio.ByteBuffer) -> None: ...

class CRC32C(Checksum):
    def __init__(self): ...
    def getValue(self) -> int: ...
    def reset(self) -> None: ...
    @typing.overload
    def update(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def update(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def update(self, int: int) -> None: ...
    @typing.overload
    def update(self, byteBuffer: java.nio.ByteBuffer) -> None: ...

class GZIPInputStream(InflaterInputStream):
    GZIP_MAGIC: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream): ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream, int: int): ...
    def close(self) -> None: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    @typing.overload
    def read(self) -> int: ...

class GZIPOutputStream(DeflaterOutputStream):
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, boolean: bool): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, int: int): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, int: int, boolean: bool): ...
    def finish(self) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...

class ZipEntry(java.util.zip.ZipConstants, java.lang.Cloneable):
    STORED: typing.ClassVar[int] = ...
    DEFLATED: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, zipEntry: 'ZipEntry'): ...
    def clone(self) -> typing.Any: ...
    def getComment(self) -> str: ...
    def getCompressedSize(self) -> int: ...
    def getCrc(self) -> int: ...
    def getCreationTime(self) -> java.nio.file.attribute.FileTime: ...
    def getExtra(self) -> typing.List[int]: ...
    def getLastAccessTime(self) -> java.nio.file.attribute.FileTime: ...
    def getLastModifiedTime(self) -> java.nio.file.attribute.FileTime: ...
    def getMethod(self) -> int: ...
    def getName(self) -> str: ...
    def getSize(self) -> int: ...
    def getTime(self) -> int: ...
    def getTimeLocal(self) -> java.time.LocalDateTime: ...
    def hashCode(self) -> int: ...
    def isDirectory(self) -> bool: ...
    def setComment(self, string: str) -> None: ...
    def setCompressedSize(self, long: int) -> None: ...
    def setCrc(self, long: int) -> None: ...
    def setCreationTime(self, fileTime: java.nio.file.attribute.FileTime) -> 'ZipEntry': ...
    def setExtra(self, byteArray: typing.List[int]) -> None: ...
    def setLastAccessTime(self, fileTime: java.nio.file.attribute.FileTime) -> 'ZipEntry': ...
    def setLastModifiedTime(self, fileTime: java.nio.file.attribute.FileTime) -> 'ZipEntry': ...
    def setMethod(self, int: int) -> None: ...
    def setSize(self, long: int) -> None: ...
    def setTime(self, long: int) -> None: ...
    def setTimeLocal(self, localDateTime: java.time.LocalDateTime) -> None: ...
    def toString(self) -> str: ...

class ZipFile(java.util.zip.ZipConstants, java.io.Closeable):
    OPEN_READ: typing.ClassVar[int] = ...
    OPEN_DELETE: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], int: int): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], int: int, charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath], charset: java.nio.charset.Charset): ...
    @typing.overload
    def __init__(self, string: str): ...
    @typing.overload
    def __init__(self, string: str, charset: java.nio.charset.Charset): ...
    def close(self) -> None: ...
    def entries(self) -> java.util.Enumeration[ZipEntry]: ...
    def getComment(self) -> str: ...
    def getEntry(self, string: str) -> ZipEntry: ...
    def getInputStream(self, zipEntry: ZipEntry) -> java.io.InputStream: ...
    def getName(self) -> str: ...
    def size(self) -> int: ...
    def stream(self) -> java.util.stream.Stream[ZipEntry]: ...

class ZipInputStream(InflaterInputStream, java.util.zip.ZipConstants):
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream): ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream, charset: java.nio.charset.Charset): ...
    def available(self) -> int: ...
    def close(self) -> None: ...
    def closeEntry(self) -> None: ...
    def getNextEntry(self) -> ZipEntry: ...
    @typing.overload
    def read(self, byteArray: typing.List[int]) -> int: ...
    @typing.overload
    def read(self) -> int: ...
    @typing.overload
    def read(self, byteArray: typing.List[int], int: int, int2: int) -> int: ...
    def skip(self, long: int) -> int: ...

class ZipOutputStream(DeflaterOutputStream, java.util.zip.ZipConstants):
    STORED: typing.ClassVar[int] = ...
    DEFLATED: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream): ...
    @typing.overload
    def __init__(self, outputStream: java.io.OutputStream, charset: java.nio.charset.Charset): ...
    def close(self) -> None: ...
    def closeEntry(self) -> None: ...
    def finish(self) -> None: ...
    def putNextEntry(self, zipEntry: ZipEntry) -> None: ...
    def setComment(self, string: str) -> None: ...
    def setLevel(self, int: int) -> None: ...
    def setMethod(self, int: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int], int: int, int2: int) -> None: ...
    @typing.overload
    def write(self, byteArray: typing.List[int]) -> None: ...
    @typing.overload
    def write(self, int: int) -> None: ...

class ZipConstants: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.util.zip")``.

    Adler32: typing.Type[Adler32]
    CRC32: typing.Type[CRC32]
    CRC32C: typing.Type[CRC32C]
    CheckedInputStream: typing.Type[CheckedInputStream]
    CheckedOutputStream: typing.Type[CheckedOutputStream]
    Checksum: typing.Type[Checksum]
    DataFormatException: typing.Type[DataFormatException]
    Deflater: typing.Type[Deflater]
    DeflaterInputStream: typing.Type[DeflaterInputStream]
    DeflaterOutputStream: typing.Type[DeflaterOutputStream]
    GZIPInputStream: typing.Type[GZIPInputStream]
    GZIPOutputStream: typing.Type[GZIPOutputStream]
    Inflater: typing.Type[Inflater]
    InflaterInputStream: typing.Type[InflaterInputStream]
    InflaterOutputStream: typing.Type[InflaterOutputStream]
    ZipConstants: typing.Type[ZipConstants]
    ZipEntry: typing.Type[ZipEntry]
    ZipError: typing.Type[ZipError]
    ZipException: typing.Type[ZipException]
    ZipFile: typing.Type[ZipFile]
    ZipInputStream: typing.Type[ZipInputStream]
    ZipOutputStream: typing.Type[ZipOutputStream]
