import java.lang
import scala
import scala.collection
import scala.collection.generic
import scala.collection.immutable
import scala.collection.mutable
import scala.collection.parallel
import scala.math
import scala.reflect
import scala.runtime
import scala.util
import scalan
import scorex.util.serialization
import sigmastate
import sigmastate.eval
import sigmastate.serialization
import sigmastate.utils
import sigmastate.utxo
import special.sigma
import typing



class DisabledRule:
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def statusCode() -> int: ...
    @staticmethod
    def toString() -> java.lang.String: ...

class EnabledRule:
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def statusCode() -> int: ...
    @staticmethod
    def toString() -> java.lang.String: ...

class RuleStatus:
    @staticmethod
    def ChangedRuleCode() -> int: ...
    @staticmethod
    def DisabledRuleCode() -> int: ...
    @staticmethod
    def EnabledRuleCode() -> int: ...
    @staticmethod
    def ReplacedRuleCode() -> int: ...
    def statusCode(self) -> int: ...

class RuleStatusSerializer:
    @staticmethod
    def FirstRuleId() -> int: ...
    @staticmethod
    def error(msg: typing.Union[java.lang.String, str]) -> scala.runtime.Nothing.: ...
    @staticmethod
    def fromBytes(bytes: typing.List[int]) -> typing.Any: ...
    @staticmethod
    def measureWrittenBytes(block: scala.Function1[sigmastate.utils.SigmaByteWriter, scala.runtime.BoxedUnit]) -> int: ...
    @staticmethod
    def parse(r: sigmastate.utils.SigmaByteReader) -> RuleStatus: ...
    @staticmethod
    def parseTry(r: scorex.util.serialization.Reader) -> scala.util.Try: ...
    @staticmethod
    def parseWithGenericReader(r: scorex.util.serialization.Reader, vs: 'SigmaValidationSettings') -> typing.Any: ...
    @staticmethod
    def serialize(status: RuleStatus, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    @staticmethod
    def serializeWithGenericWriter(obj: typing.Any, w: scorex.util.serialization.Writer) -> None: ...
    @staticmethod
    def toBytes(obj: typing.Any) -> typing.List[int]: ...

class SigmaValidationSettings(scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]):
    def __init__(self): ...
    _$colon$bslash__B = typing.TypeVar('_$colon$bslash__B')  # <B>
    def $colon$bslash(self, z: _.colon.bslash__B, op: scala.Function2[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _.colon.bslash__B, _.colon.bslash__B]) -> _.colon.bslash__B: ...
    _$div$colon__B = typing.TypeVar('_$div$colon__B')  # <B>
    def $div$colon(self, z: _.div.colon__B, op: scala.Function2[_.div.colon__B, scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _.div.colon__B]) -> _.div.colon__B: ...
    _$plus$plus__B = typing.TypeVar('_$plus$plus__B')  # <B>
    _$plus$plus__That = typing.TypeVar('_$plus$plus__That')  # <That>
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], _.plus.plus__B, _.plus.plus__That]) -> _.plus.plus__That: ...
    _$plus$plus$colon_0__B = typing.TypeVar('_$plus$plus$colon_0__B')  # <B>
    _$plus$plus$colon_0__That = typing.TypeVar('_$plus$plus$colon_0__That')  # <That>
    _$plus$plus$colon_1__B = typing.TypeVar('_$plus$plus$colon_1__B')  # <B>
    _$plus$plus$colon_1__That = typing.TypeVar('_$plus$plus$colon_1__That')  # <That>
    @typing.overload
    def $plus$plus$colon(self, that: scala.collection.Traversable[_.plus.plus.colon_0__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], _.plus.plus.colon_0__B, _.plus.plus.colon_0__That]) -> _.plus.plus.colon_0__That: ...
    @typing.overload
    def $plus$plus$colon(self, that: scala.collection.TraversableOnce[_.plus.plus.colon_1__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], _.plus.plus.colon_1__B, _.plus.plus.colon_1__That]) -> _.plus.plus.colon_1__That: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder, sep: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    _aggregate__B = typing.TypeVar('_aggregate__B')  # <B>
    def aggregate(self, z: scala.Function0[_aggregate__B], seqop: scala.Function2[_aggregate__B, scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _aggregate__B], combop: scala.Function2[_aggregate__B, _aggregate__B, _aggregate__B]) -> _aggregate__B: ...
    def canEqual(self, that: typing.Any) -> bool: ...
    _collect__B = typing.TypeVar('_collect__B')  # <B>
    _collect__That = typing.TypeVar('_collect__That')  # <That>
    def collect(self, pf: scala.PartialFunction[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _collect__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], _collect__B, _collect__That]) -> _collect__That: ...
    _collectFirst__B = typing.TypeVar('_collectFirst__B')  # <B>
    def collectFirst(self, pf: scala.PartialFunction[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _collectFirst__B]) -> scala.Option[_collectFirst__B]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion[scala.collection.Iterable]: ...
    _copyToArray_0__B = typing.TypeVar('_copyToArray_0__B')  # <B>
    _copyToArray_1__B = typing.TypeVar('_copyToArray_1__B')  # <B>
    _copyToArray_2__B = typing.TypeVar('_copyToArray_2__B')  # <B>
    @typing.overload
    def copyToArray(self, xs: typing.Any) -> None: ...
    @typing.overload
    def copyToArray(self, xs: typing.Any, start: int) -> None: ...
    @typing.overload
    def copyToArray(self, xs: typing.Any, start: int, len: int) -> None: ...
    _copyToBuffer__B = typing.TypeVar('_copyToBuffer__B')  # <B>
    def copyToBuffer(self, dest: scala.collection.mutable.Buffer[_copyToBuffer__B]) -> None: ...
    def count(self, p: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], typing.Any]) -> int: ...
    def drop(self, n: int) -> typing.Any: ...
    def dropRight(self, n: int) -> typing.Any: ...
    def dropWhile(self, p: scala.Function1) -> typing.Any: ...
    def exists(self, p: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], typing.Any]) -> bool: ...
    def filter(self, p: scala.Function1) -> typing.Any: ...
    def filterImpl(self, p: scala.Function1, isFlipped: bool) -> typing.Any: ...
    def filterNot(self, p: scala.Function1) -> typing.Any: ...
    def find(self, p: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], typing.Any]) -> scala.Option[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    _flatMap__B = typing.TypeVar('_flatMap__B')  # <B>
    _flatMap__That = typing.TypeVar('_flatMap__That')  # <That>
    def flatMap(self, f: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], scala.collection.GenTraversableOnce[_flatMap__B]], bf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], _flatMap__B, _flatMap__That]) -> _flatMap__That: ...
    def flatten(self, asTraversable: scala.Function1) -> scala.collection.GenTraversable: ...
    _fold__A1 = typing.TypeVar('_fold__A1')  # <A1>
    def fold(self, z: _fold__A1, op: scala.Function2[_fold__A1, _fold__A1, _fold__A1]) -> _fold__A1: ...
    _foldLeft__B = typing.TypeVar('_foldLeft__B')  # <B>
    def foldLeft(self, z: _foldLeft__B, op: scala.Function2[_foldLeft__B, scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _foldLeft__B]) -> _foldLeft__B: ...
    _foldRight__B = typing.TypeVar('_foldRight__B')  # <B>
    def foldRight(self, z: _foldRight__B, op: scala.Function2[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _foldRight__B, _foldRight__B]) -> _foldRight__B: ...
    def forall(self, p: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], typing.Any]) -> bool: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _foreach__U]) -> None: ...
    _genericBuilder__B = typing.TypeVar('_genericBuilder__B')  # <B>
    def genericBuilder(self) -> scala.collection.mutable.Builder[_genericBuilder__B, scala.collection.Iterable[_genericBuilder__B]]: ...
    def get(self, id: int) -> scala.Option[scala.Tuple2['ValidationRule', RuleStatus]]: ...
    def getStatus(self, id: int) -> scala.Option[RuleStatus]: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _groupBy__K]) -> scala.collection.immutable.Map[_groupBy__K, scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    def grouped(self, size: int) -> scala.collection.Iterator[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    def hasDefiniteSize(self) -> bool: ...
    def head(self) -> typing.Any: ...
    def headOption(self) -> scala.Option[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    def init(self) -> typing.Any: ...
    def inits(self) -> scala.collection.Iterator[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    def isEmpty(self) -> bool: ...
    @typing.overload
    def isSoftFork(self, ve: 'ValidationException') -> bool: ...
    @typing.overload
    def isSoftFork(self, ruleId: int, ve: 'ValidationException') -> bool: ...
    def isTraversableAgain(self) -> bool: ...
    def last(self) -> typing.Any: ...
    def lastOption(self) -> scala.Option[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    _map__B = typing.TypeVar('_map__B')  # <B>
    _map__That = typing.TypeVar('_map__That')  # <That>
    def map(self, f: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _map__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], _map__B, _map__That]) -> _map__That: ...
    def max(self, cmp: scala.math.Ordering) -> typing.Any: ...
    def maxBy(self, f: scala.Function1, cmp: scala.math.Ordering) -> typing.Any: ...
    def min(self, cmp: scala.math.Ordering) -> typing.Any: ...
    def minBy(self, f: scala.Function1, cmp: scala.math.Ordering) -> typing.Any: ...
    @typing.overload
    def mkString(self) -> java.lang.String: ...
    @typing.overload
    def mkString(self, sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def mkString(self, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def newBuilder(self) -> scala.collection.mutable.Builder[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    def nonEmpty(self) -> bool: ...
    def par(self) -> scala.collection.Parallel: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], scala.collection.parallel.ParIterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    def partition(self, p: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], typing.Any]) -> scala.Tuple2[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    _product__B = typing.TypeVar('_product__B')  # <B>
    def product(self, num: scala.math.Numeric[_product__B]) -> _product__B: ...
    _reduce__A1 = typing.TypeVar('_reduce__A1')  # <A1>
    def reduce(self, op: scala.Function2[_reduce__A1, _reduce__A1, _reduce__A1]) -> _reduce__A1: ...
    _reduceLeft__B = typing.TypeVar('_reduceLeft__B')  # <B>
    def reduceLeft(self, op: scala.Function2[_reduceLeft__B, scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _reduceLeft__B]) -> _reduceLeft__B: ...
    _reduceLeftOption__B = typing.TypeVar('_reduceLeftOption__B')  # <B>
    def reduceLeftOption(self, op: scala.Function2[_reduceLeftOption__B, scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _reduceLeftOption__B]) -> scala.Option[_reduceLeftOption__B]: ...
    _reduceOption__A1 = typing.TypeVar('_reduceOption__A1')  # <A1>
    def reduceOption(self, op: scala.Function2[_reduceOption__A1, _reduceOption__A1, _reduceOption__A1]) -> scala.Option[_reduceOption__A1]: ...
    _reduceRight__B = typing.TypeVar('_reduceRight__B')  # <B>
    def reduceRight(self, op: scala.Function2[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _reduceRight__B, _reduceRight__B]) -> _reduceRight__B: ...
    _reduceRightOption__B = typing.TypeVar('_reduceRightOption__B')  # <B>
    def reduceRightOption(self, op: scala.Function2[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _reduceRightOption__B, _reduceRightOption__B]) -> scala.Option[_reduceRightOption__B]: ...
    def repr(self) -> typing.Any: ...
    def reversed(self) -> scala.collection.immutable.List[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    _sameElements__B = typing.TypeVar('_sameElements__B')  # <B>
    def sameElements(self, that: scala.collection.GenIterable[_sameElements__B]) -> bool: ...
    _scan__B = typing.TypeVar('_scan__B')  # <B>
    _scan__That = typing.TypeVar('_scan__That')  # <That>
    def scan(self, z: _scan__B, op: scala.Function2[_scan__B, _scan__B, _scan__B], cbf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], _scan__B, _scan__That]) -> _scan__That: ...
    _scanLeft__B = typing.TypeVar('_scanLeft__B')  # <B>
    _scanLeft__That = typing.TypeVar('_scanLeft__That')  # <That>
    def scanLeft(self, z: _scanLeft__B, op: scala.Function2[_scanLeft__B, scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _scanLeft__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], _scanLeft__B, _scanLeft__That]) -> _scanLeft__That: ...
    _scanRight__B = typing.TypeVar('_scanRight__B')  # <B>
    _scanRight__That = typing.TypeVar('_scanRight__That')  # <That>
    def scanRight(self, z: _scanRight__B, op: scala.Function2[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _scanRight__B, _scanRight__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], _scanRight__B, _scanRight__That]) -> _scanRight__That: ...
    def seq(self) -> scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    def size(self) -> int: ...
    def sizeHintIfCheap(self) -> int: ...
    def slice(self, from_: int, until: int) -> typing.Any: ...
    def sliceWithKnownBound(self, from_: int, until: int) -> typing.Any: ...
    def sliceWithKnownDelta(self, from_: int, until: int, delta: int) -> typing.Any: ...
    @typing.overload
    def sliding(self, size: int) -> scala.collection.Iterator[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    @typing.overload
    def sliding(self, size: int, step: int) -> scala.collection.Iterator[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    def span(self, p: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], typing.Any]) -> scala.Tuple2[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    def splitAt(self, n: int) -> scala.Tuple2[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    def stringPrefix(self) -> java.lang.String: ...
    _sum__B = typing.TypeVar('_sum__B')  # <B>
    def sum(self, num: scala.math.Numeric[_sum__B]) -> _sum__B: ...
    def tail(self) -> typing.Any: ...
    def tails(self) -> scala.collection.Iterator[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    def take(self, n: int) -> typing.Any: ...
    def takeRight(self, n: int) -> typing.Any: ...
    def takeWhile(self, p: scala.Function1) -> typing.Any: ...
    def thisCollection(self) -> scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    _to__Col = typing.TypeVar('_to__Col')  # <Col>
    def to(self, cbf: scala.collection.generic.CanBuildFrom[scala.runtime.Nothing., scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], _to__Col]) -> _to__Col: ...
    _toArray__B = typing.TypeVar('_toArray__B')  # <B>
    def toArray(self, evidence$1: scala.reflect.ClassTag[_toArray__B]) -> typing.Any: ...
    _toBuffer__B = typing.TypeVar('_toBuffer__B')  # <B>
    def toBuffer(self) -> scala.collection.mutable.Buffer[_toBuffer__B]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
    def toIndexedSeq(self) -> scala.collection.immutable.IndexedSeq[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    def toIterable(self) -> scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    def toIterator(self) -> scala.collection.Iterator[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    def toList(self) -> scala.collection.immutable.List[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    _toMap__T = typing.TypeVar('_toMap__T')  # <T>
    _toMap__U = typing.TypeVar('_toMap__U')  # <U>
    def toMap(self, ev: scala.Predef..less.colon.less[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], scala.Tuple2[_toMap__T, _toMap__U]]) -> scala.collection.immutable.Map[_toMap__T, _toMap__U]: ...
    def toSeq(self) -> scala.collection.Seq[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    _toSet__B = typing.TypeVar('_toSet__B')  # <B>
    def toSet(self) -> scala.collection.immutable.Set[_toSet__B]: ...
    def toStream(self) -> scala.collection.immutable.Stream[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    def toString(self) -> java.lang.String: ...
    def toTraversable(self) -> scala.collection.Traversable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    def toVector(self) -> scala.collection.immutable.Vector[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    def transpose(self, asTraversable: scala.Function1) -> scala.collection.GenTraversable: ...
    _unzip__A1 = typing.TypeVar('_unzip__A1')  # <A1>
    _unzip__A2 = typing.TypeVar('_unzip__A2')  # <A2>
    def unzip(self, asPair: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], scala.Tuple2[_unzip__A1, _unzip__A2]]) -> scala.Tuple2[scala.collection.Iterable[_unzip__A1], scala.collection.Iterable[_unzip__A2]]: ...
    _unzip3__A1 = typing.TypeVar('_unzip3__A1')  # <A1>
    _unzip3__A2 = typing.TypeVar('_unzip3__A2')  # <A2>
    _unzip3__A3 = typing.TypeVar('_unzip3__A3')  # <A3>
    def unzip3(self, asTriple: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], scala.Tuple3[_unzip3__A1, _unzip3__A2, _unzip3__A3]]) -> scala.Tuple3[scala.collection.Iterable[_unzip3__A1], scala.collection.Iterable[_unzip3__A2], scala.collection.Iterable[_unzip3__A3]]: ...
    def updated(self, id: int, newStatus: RuleStatus) -> 'SigmaValidationSettings': ...
    @typing.overload
    def view(self) -> scala.collection.IterableView[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.IterableView[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    def withFilter(self, p: scala.Function1[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], typing.Any]) -> scala.collection.generic.FilterMonadic[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]], scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]]: ...
    _zip__A1 = typing.TypeVar('_zip__A1')  # <A1>
    _zip__B = typing.TypeVar('_zip__B')  # <B>
    _zip__That = typing.TypeVar('_zip__That')  # <That>
    def zip(self, that: scala.collection.GenIterable[_zip__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], scala.Tuple2[_zip__A1, _zip__B], _zip__That]) -> _zip__That: ...
    _zipAll__B = typing.TypeVar('_zipAll__B')  # <B>
    _zipAll__A1 = typing.TypeVar('_zipAll__A1')  # <A1>
    _zipAll__That = typing.TypeVar('_zipAll__That')  # <That>
    def zipAll(self, that: scala.collection.GenIterable[_zipAll__B], thisElem: _zipAll__A1, thatElem: _zipAll__B, bf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], scala.Tuple2[_zipAll__A1, _zipAll__B], _zipAll__That]) -> _zipAll__That: ...
    _zipWithIndex__A1 = typing.TypeVar('_zipWithIndex__A1')  # <A1>
    _zipWithIndex__That = typing.TypeVar('_zipWithIndex__That')  # <That>
    def zipWithIndex(self, bf: scala.collection.generic.CanBuildFrom[scala.collection.Iterable[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]], scala.Tuple2[_zipWithIndex__A1, typing.Any], _zipWithIndex__That]) -> _zipWithIndex__That: ...

class SigmaValidationSettingsSerializer:
    @staticmethod
    def error(msg: typing.Union[java.lang.String, str]) -> scala.runtime.Nothing.: ...
    @staticmethod
    def fromBytes(bytes: typing.List[int]) -> typing.Any: ...
    @staticmethod
    def parse(r: sigmastate.utils.SigmaByteReader) -> SigmaValidationSettings: ...
    @staticmethod
    def parseTry(r: scorex.util.serialization.Reader) -> scala.util.Try: ...
    @staticmethod
    def parseWithGenericReader(r: scorex.util.serialization.Reader, vs: SigmaValidationSettings) -> typing.Any: ...
    @staticmethod
    def serialize(settings: SigmaValidationSettings, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    @staticmethod
    def serializeWithGenericWriter(obj: typing.Any, w: scorex.util.serialization.Writer) -> None: ...
    @staticmethod
    def toBytes(obj: typing.Any) -> typing.List[int]: ...

class SoftForkChecker:
    @staticmethod
    def $init$($this: 'SoftForkChecker') -> None: ...
    def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...

class ValidationException(java.lang.Exception, scala.Product, scala.Serializable):
    def __init__(self, message: typing.Union[java.lang.String, str], rule: 'ValidationRule', args: scala.collection.Seq[typing.Any], cause: scala.Option[java.lang.Throwable]): ...
    @staticmethod
    def $lessinit$greater$default$4() -> scala.Option[java.lang.Throwable]: ...
    @staticmethod
    def apply(message: typing.Union[java.lang.String, str], rule: 'ValidationRule', args: scala.collection.Seq[typing.Any], cause: scala.Option[java.lang.Throwable]) -> 'ValidationException': ...
    @staticmethod
    def apply$default$4() -> scala.Option[java.lang.Throwable]: ...
    def args(self) -> scala.collection.Seq[typing.Any]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def cause(self) -> scala.Option[java.lang.Throwable]: ...
    def copy(self, message: typing.Union[java.lang.String, str], rule: 'ValidationRule', args: scala.collection.Seq[typing.Any], cause: scala.Option[java.lang.Throwable]) -> 'ValidationException': ...
    def copy$default$1(self) -> java.lang.String: ...
    def copy$default$2(self) -> 'ValidationRule': ...
    def copy$default$3(self) -> scala.collection.Seq[typing.Any]: ...
    def copy$default$4(self) -> scala.Option[java.lang.Throwable]: ...
    @staticmethod
    def curried() -> scala.Function1[java.lang.String, scala.Function1['ValidationRule', scala.Function1[scala.collection.Seq[typing.Any], scala.Function1[scala.Option[java.lang.Throwable], 'ValidationException']]]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def fillInStackTrace(self) -> java.lang.Throwable: ...
    def hashCode(self) -> int: ...
    def message(self) -> java.lang.String: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def rule(self) -> 'ValidationRule': ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple4[java.lang.String, 'ValidationRule', scala.collection.Seq[typing.Any], scala.Option[java.lang.Throwable]], 'ValidationException']: ...
    @staticmethod
    def unapply(x$0: 'ValidationException') -> scala.Option[scala.Tuple4[java.lang.String, 'ValidationRule', scala.collection.Seq[typing.Any], scala.Option[java.lang.Throwable]]]: ...

class ChangedRule(RuleStatus, scala.Product, scala.Serializable):
    def __init__(self, newValue: typing.List[int]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['ChangedRule', _andThen__A]) -> scala.Function1[typing.List[int], _andThen__A]: ...
    @staticmethod
    def apply(newValue: typing.List[int]) -> 'ChangedRule': ...
    def canEqual(self, that: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.List[int]]) -> scala.Function1[_compose__A, 'ChangedRule']: ...
    def copy(self, newValue: typing.List[int]) -> 'ChangedRule': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def equals(self, obj: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def newValue(self) -> typing.List[int]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def statusCode(self) -> int: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ChangedRule') -> scala.Option[typing.List[int]]: ...

class MapSigmaValidationSettings(SigmaValidationSettings):
    def __init__(self, map: scala.collection.immutable.Map[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]): ...
    def canEqual(self, that: typing.Any) -> bool: ...
    def equals(self, obj: typing.Any) -> bool: ...
    def get(self, id: int) -> scala.Option[scala.Tuple2['ValidationRule', RuleStatus]]: ...
    def getStatus(self, id: int) -> scala.Option[RuleStatus]: ...
    def hashCode(self) -> int: ...
    def iterator(self) -> scala.collection.Iterator[scala.Tuple2[typing.Any, scala.Tuple2['ValidationRule', RuleStatus]]]: ...
    def updated(self, id: int, newStatus: RuleStatus) -> 'MapSigmaValidationSettings': ...

class ReplacedRule(RuleStatus, scala.Product, scala.Serializable):
    def __init__(self, newRuleId: int): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['ReplacedRule', _andThen__A]) -> scala.Function1[typing.Any, _andThen__A]: ...
    @staticmethod
    def apply(newRuleId: int) -> 'ReplacedRule': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.Any]) -> scala.Function1[_compose__A, 'ReplacedRule']: ...
    def copy(self, newRuleId: int) -> 'ReplacedRule': ...
    def copy$default$1(self) -> int: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def newRuleId(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def statusCode(self) -> int: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ReplacedRule') -> scala.Option[typing.Any]: ...

class SoftForkWhenCodeAdded(SoftForkChecker):
    @staticmethod
    def $init$($this: 'SoftForkWhenCodeAdded') -> None: ...
    def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...

class SoftForkWhenReplaced(SoftForkChecker):
    @staticmethod
    def $init$($this: 'SoftForkWhenReplaced') -> None: ...
    def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...

class ValidationRule(SoftForkChecker, scala.Product, scala.Serializable):
    def __init__(self, id: int, description: typing.Union[java.lang.String, str]): ...
    @staticmethod
    def apply(id: int, description: typing.Union[java.lang.String, str]) -> 'ValidationRule': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def checkRule(self) -> None: ...
    def copy(self, id: int, description: typing.Union[java.lang.String, str]) -> 'ValidationRule': ...
    def copy$default$1(self) -> int: ...
    def copy$default$2(self) -> java.lang.String: ...
    @staticmethod
    def curried() -> scala.Function1[typing.Any, scala.Function1[java.lang.String, 'ValidationRule']]: ...
    def description(self) -> java.lang.String: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def id(self) -> int: ...
    def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...
    def org$ergoplatform$validation$ValidationRule$$_checked(self) -> bool: ...
    def org$ergoplatform$validation$ValidationRule$$_checked_$eq(self, x$1: bool) -> None: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def throwValidationException(self, cause: java.lang.Throwable, args: scala.collection.Seq[typing.Any]) -> scala.runtime.Nothing.: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[typing.Any, java.lang.String], 'ValidationRule']: ...
    @staticmethod
    def unapply(x$0: 'ValidationRule') -> scala.Option[scala.Tuple2[typing.Any, java.lang.String]]: ...

class ValidationRules:
    @staticmethod
    def FirstRuleId() -> int: ...
    @staticmethod
    def currentSettings() -> SigmaValidationSettings: ...
    @staticmethod
    def ruleSpecs() -> scala.collection.Seq[ValidationRule]: ...
    _trySoftForkable__T = typing.TypeVar('_trySoftForkable__T')  # <T>
    @staticmethod
    def trySoftForkable(whenSoftFork: scala.Function0[_trySoftForkable__T], block: scala.Function0[_trySoftForkable__T], vs: SigmaValidationSettings) -> _trySoftForkable__T: ...
    class CheckAndGetMethod$(ValidationRule):
        MODULE$: typing.ClassVar['ValidationRules.CheckAndGetMethod.'] = ...
        def __init__(self): ...
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, objType: sigmastate.STypeCompanion, methodId: int) -> sigmastate.SMethod: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
        def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...
    class CheckCalcFunc$(ValidationRule):
        MODULE$: typing.ClassVar['ValidationRules.CheckCalcFunc.'] = ...
        def __init__(self): ...
        _apply_0__Ctx = typing.TypeVar('_apply_0__Ctx', bound=sigmastate.eval.IRContext)  # <Ctx>
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, ctx: _apply_0__Ctx, calcF: scalan.Base.Ref[scala.Function1[special.sigma.SigmaDsl.Context, typing.Any]]) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
    class CheckCostFunc$(ValidationRule):
        MODULE$: typing.ClassVar['ValidationRules.CheckCostFunc.'] = ...
        def __init__(self): ...
        _apply_0__Ctx = typing.TypeVar('_apply_0__Ctx', bound=sigmastate.eval.IRContext)  # <Ctx>
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, ctx: _apply_0__Ctx, costF: scalan.Base.Ref[scala.Function1[typing.Any, typing.Any]]) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
    class CheckCostFuncOperation$(ValidationRule, SoftForkWhenCodeAdded):
        MODULE$: typing.ClassVar['ValidationRules.CheckCostFuncOperation.'] = ...
        def __init__(self): ...
        _apply_0__Ctx = typing.TypeVar('_apply_0__Ctx', bound=sigmastate.eval.IRContext)  # <Ctx>
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, ctx: _apply_0__Ctx, opCode: int) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
        def decodeVLQUShort(self, bytes: typing.List[int]) -> scala.collection.Seq[typing.Any]: ...
        def encodeVLQUShort(self, opCodes: scala.collection.Seq[typing.Any]) -> typing.List[int]: ...
        def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...
    class CheckDeserializedScriptIsSigmaProp$(ValidationRule):
        MODULE$: typing.ClassVar['ValidationRules.CheckDeserializedScriptIsSigmaProp.'] = ...
        def __init__(self): ...
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, root: sigmastate.Values.Value[sigmastate.SType]) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
    class CheckDeserializedScriptType$(ValidationRule):
        MODULE$: typing.ClassVar['ValidationRules.CheckDeserializedScriptType.'] = ...
        def __init__(self): ...
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, d: sigmastate.utxo.DeserializeContext[typing.Any], script: sigmastate.Values.Value[sigmastate.SType]) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
    class CheckHeaderSizeBit$(ValidationRule, SoftForkWhenReplaced):
        MODULE$: typing.ClassVar['ValidationRules.CheckHeaderSizeBit.'] = ...
        def __init__(self): ...
        @typing.overload
        def apply(self, header: int) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
        def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...
    class CheckIsSupportedIndexExpression$(ValidationRule):
        MODULE$: typing.ClassVar['ValidationRules.CheckIsSupportedIndexExpression.'] = ...
        def __init__(self): ...
        _apply_0__Ctx = typing.TypeVar('_apply_0__Ctx', bound=sigmastate.eval.IRContext)  # <Ctx>
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, ctx: _apply_0__Ctx, coll: sigmastate.Values.Value[sigmastate.SCollection[typing.Any]], i: sigmastate.Values.Value[sigmastate.SInt.], iSym: scalan.Base.Ref[typing.Any]) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
    class CheckLoopLevelInCostFunction$(ValidationRule, SoftForkWhenReplaced):
        MODULE$: typing.ClassVar['ValidationRules.CheckLoopLevelInCostFunction.'] = ...
        def __init__(self): ...
        @typing.overload
        def apply(self, level: int) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
        def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...
    class CheckPositionLimit$(ValidationRule, SoftForkWhenReplaced):
        MODULE$: typing.ClassVar['ValidationRules.CheckPositionLimit.'] = ...
        def __init__(self): ...
        def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...
    class CheckPrimitiveTypeCode$(ValidationRule, SoftForkWhenCodeAdded):
        MODULE$: typing.ClassVar['ValidationRules.CheckPrimitiveTypeCode.'] = ...
        def __init__(self): ...
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, code: int) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
        def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...
    class CheckSerializableTypeCode$(ValidationRule, SoftForkWhenReplaced):
        MODULE$: typing.ClassVar['ValidationRules.CheckSerializableTypeCode.'] = ...
        def __init__(self): ...
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, typeCode: int) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
        def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...
    class CheckTupleType$(ValidationRule, SoftForkWhenReplaced):
        MODULE$: typing.ClassVar['ValidationRules.CheckTupleType.'] = ...
        def __init__(self): ...
        _apply_0__Ctx = typing.TypeVar('_apply_0__Ctx', bound=sigmastate.eval.IRContext)  # <Ctx>
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, ctx: _apply_0__Ctx, e: scalan.TypeDescs.Elem[typing.Any]) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
        def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...
    class CheckTypeCode$(ValidationRule, SoftForkWhenCodeAdded):
        MODULE$: typing.ClassVar['ValidationRules.CheckTypeCode.'] = ...
        def __init__(self): ...
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, typeCode: int) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
        def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...
    class CheckTypeWithMethods$(ValidationRule, SoftForkWhenCodeAdded):
        MODULE$: typing.ClassVar['ValidationRules.CheckTypeWithMethods.'] = ...
        def __init__(self): ...
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, typeCode: int, cond: bool) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
        def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...
    class CheckValidOpCode$(ValidationRule, SoftForkWhenCodeAdded):
        MODULE$: typing.ClassVar['ValidationRules.CheckValidOpCode.'] = ...
        def __init__(self): ...
        _apply_0__T = typing.TypeVar('_apply_0__T')  # <T>
        @typing.overload
        def apply(self, ser: sigmastate.serialization.ValueSerializer[typing.Any], opCode: int) -> None: ...
        @typing.overload
        @staticmethod
        def apply(id: int, description: typing.Union[java.lang.String, str]) -> ValidationRule: ...
        def isSoftFork(self, vs: SigmaValidationSettings, ruleId: int, status: RuleStatus, args: scala.collection.Seq[typing.Any]) -> bool: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.ergoplatform.validation")``.

    ChangedRule: typing.Type[ChangedRule]
    DisabledRule: typing.Type[DisabledRule]
    EnabledRule: typing.Type[EnabledRule]
    MapSigmaValidationSettings: typing.Type[MapSigmaValidationSettings]
    ReplacedRule: typing.Type[ReplacedRule]
    RuleStatus: typing.Type[RuleStatus]
    RuleStatusSerializer: typing.Type[RuleStatusSerializer]
    SigmaValidationSettings: typing.Type[SigmaValidationSettings]
    SigmaValidationSettingsSerializer: typing.Type[SigmaValidationSettingsSerializer]
    SoftForkChecker: typing.Type[SoftForkChecker]
    SoftForkWhenCodeAdded: typing.Type[SoftForkWhenCodeAdded]
    SoftForkWhenReplaced: typing.Type[SoftForkWhenReplaced]
    ValidationException: typing.Type[ValidationException]
    ValidationRule: typing.Type[ValidationRule]
    ValidationRules: typing.Type[ValidationRules]
