import java.lang
import java.math
import java.security
import org.bouncycastle.asn1.x9
import org.bouncycastle.math.ec
import org.bouncycastle.math.ec.custom.sec
import scala
import scala.collection
import scala.concurrent
import scala.math
import scala.runtime
import sigmastate
import special.sigma
import supertagged
import typing



class DiffieHellmanTupleInteractiveProver:
    @staticmethod
    def computeCommitment(proposition: 'ProveDHTuple', challenge: typing.List[int], secondMessage: 'SecondDiffieHellmanTupleProverMessage') -> scala.Tuple2[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, org.bouncycastle.math.ec.custom.sec.SecP256K1Point]: ...
    @staticmethod
    def firstMessage(publicInput: 'ProveDHTuple') -> scala.Tuple2[java.math.BigInteger, 'FirstDiffieHellmanTupleProverMessage']: ...
    @staticmethod
    def secondMessage(privateInput: 'DiffieHellmanTupleProverInput', rnd: java.math.BigInteger, challenge: typing.List[int]) -> 'SecondDiffieHellmanTupleProverMessage': ...
    @staticmethod
    def simulate(publicInput: 'ProveDHTuple', challenge: typing.List[int]) -> scala.Tuple2['FirstDiffieHellmanTupleProverMessage', 'SecondDiffieHellmanTupleProverMessage']: ...

_DlogGroup__ElemType = typing.TypeVar('_DlogGroup__ElemType', bound=org.bouncycastle.math.ec.ECPoint)  # <ElemType>
class DlogGroup(typing.Generic[_DlogGroup__ElemType]):
    @staticmethod
    def $init$($this: 'DlogGroup') -> None: ...
    def createRandomElement(self) -> _DlogGroup__ElemType: ...
    def createRandomGenerator(self) -> _DlogGroup__ElemType: ...
    def endExponentiateWithPreComputedValues(self, base: _DlogGroup__ElemType) -> None: ...
    def exponentiate(self, base: _DlogGroup__ElemType, exponent: java.math.BigInteger) -> _DlogGroup__ElemType: ...
    def exponentiateWithPreComputedValues(self, base: _DlogGroup__ElemType, exponent: java.math.BigInteger) -> _DlogGroup__ElemType: ...
    def generator(self) -> _DlogGroup__ElemType: ...
    def identity(self) -> _DlogGroup__ElemType: ...
    def inverseOf(self, groupElement: _DlogGroup__ElemType) -> _DlogGroup__ElemType: ...
    def maxLengthOfByteArrayForEncoding(self) -> int: ...
    def multiplyGroupElements(self, groupElement1: _DlogGroup__ElemType, groupElement2: _DlogGroup__ElemType) -> _DlogGroup__ElemType: ...
    def order(self) -> java.math.BigInteger: ...
    def orderGreaterThan(self, numBits: int) -> bool: ...
    def secureRandom(self) -> java.security.SecureRandom: ...
    def sigmastate$basics$DlogGroup$_setter_$secureRandom_$eq(self, x$1: java.security.SecureRandom) -> None: ...
    def simultaneousMultipleExponentiations(self, groupElements: typing.List[_DlogGroup__ElemType], exponentiations: typing.List[java.math.BigInteger]) -> _DlogGroup__ElemType: ...

class InteractiveParty: ...

_Party__SP = typing.TypeVar('_Party__SP', bound='SigmaProtocol')  # <SP>
_Party__CI = typing.TypeVar('_Party__CI', bound='SigmaProtocolCommonInput')  # <CI>
class Party(typing.Generic[_Party__SP, _Party__CI]):
    def publicInput(self) -> _Party__CI: ...

class ProveDHTuple(sigmastate.SigmaProofOfKnowledgeLeaf['DiffieHellmanTupleProtocol', 'DiffieHellmanTupleProverInput'], scala.Product, scala.Serializable):
    def __init__(self, gv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, hv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, uv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, vv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point): ...
    @staticmethod
    def Code() -> int: ...
    @staticmethod
    def apply(gv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, hv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, uv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, vv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point) -> 'ProveDHTuple': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, gv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, hv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, uv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, vv: org.bouncycastle.math.ec.custom.sec.SecP256K1Point) -> 'ProveDHTuple': ...
    def copy$default$1(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def copy$default$2(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def copy$default$3(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def copy$default$4(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def g(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def gv(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def h(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def hashCode(self) -> int: ...
    def hv(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def opCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def sigmastate$basics$SigmaProtocolCommonInput$_setter_$soundness_$eq(self, x$1: int) -> None: ...
    def size(self) -> int: ...
    def soundness(self) -> int: ...
    def toString(self) -> java.lang.String: ...
    def u(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    @staticmethod
    def unapply(x$0: 'ProveDHTuple') -> scala.Option[scala.Tuple4[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, org.bouncycastle.math.ec.custom.sec.SecP256K1Point, org.bouncycastle.math.ec.custom.sec.SecP256K1Point, org.bouncycastle.math.ec.custom.sec.SecP256K1Point]]: ...
    def uv(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def v(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def vv(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...

class ProveDHTupleProp:
    @staticmethod
    def unapply(p: special.sigma.SigmaProp) -> scala.Option[ProveDHTuple]: ...

class SecP256K1:
    @staticmethod
    def calcK(p: java.math.BigInteger) -> int: ...
    @staticmethod
    def checkCurveMembership(x: java.math.BigInteger, y: java.math.BigInteger) -> bool: ...
    @staticmethod
    def createRandomElement() -> org.bouncycastle.math.ec.ECPoint: ...
    @staticmethod
    def createRandomGenerator() -> org.bouncycastle.math.ec.ECPoint: ...
    @staticmethod
    def curve() -> org.bouncycastle.math.ec.ECCurve: ...
    @staticmethod
    def endExponentiateWithPreComputedValues(base: org.bouncycastle.math.ec.ECPoint) -> None: ...
    @staticmethod
    def exponentiate(base: org.bouncycastle.math.ec.ECPoint, exponent: java.math.BigInteger) -> org.bouncycastle.math.ec.ECPoint: ...
    @staticmethod
    def exponentiateWithPreComputedValues(base: org.bouncycastle.math.ec.ECPoint, exponent: java.math.BigInteger) -> org.bouncycastle.math.ec.ECPoint: ...
    @staticmethod
    def generator() -> org.bouncycastle.math.ec.ECPoint: ...
    @staticmethod
    def identity() -> org.bouncycastle.math.ec.ECPoint: ...
    @staticmethod
    def inverseOf(groupElement: org.bouncycastle.math.ec.ECPoint) -> org.bouncycastle.math.ec.ECPoint: ...
    @staticmethod
    def k() -> int: ...
    @staticmethod
    def maxLengthOfByteArrayForEncoding() -> int: ...
    @staticmethod
    def multiplyGroupElements(groupElement1: org.bouncycastle.math.ec.ECPoint, groupElement2: org.bouncycastle.math.ec.ECPoint) -> org.bouncycastle.math.ec.ECPoint: ...
    @staticmethod
    def order() -> java.math.BigInteger: ...
    @staticmethod
    def orderGreaterThan(numBits: int) -> bool: ...
    @staticmethod
    def p() -> java.math.BigInteger: ...
    @staticmethod
    def q() -> java.math.BigInteger: ...
    @staticmethod
    def secureRandom() -> java.security.SecureRandom: ...
    @staticmethod
    def simultaneousMultipleExponentiations(groupElements: typing.List[org.bouncycastle.math.ec.ECPoint], exponentiations: typing.List[java.math.BigInteger]) -> org.bouncycastle.math.ec.ECPoint: ...
    @staticmethod
    def x9params() -> org.bouncycastle.asn1.x9.X9ECParameters: ...

_SigmaProtocol__SP = typing.TypeVar('_SigmaProtocol__SP', bound='SigmaProtocol')  # <SP>
class SigmaProtocol(typing.Generic[_SigmaProtocol__SP]): ...

_SigmaProtocolCommonInput__SP = typing.TypeVar('_SigmaProtocolCommonInput__SP', bound=SigmaProtocol)  # <SP>
class SigmaProtocolCommonInput(typing.Generic[_SigmaProtocolCommonInput__SP]):
    @staticmethod
    def $init$($this: 'SigmaProtocolCommonInput') -> None: ...
    def sigmastate$basics$SigmaProtocolCommonInput$_setter_$soundness_$eq(self, x$1: int) -> None: ...
    def soundness(self) -> int: ...

_SigmaProtocolPrivateInput__SP = typing.TypeVar('_SigmaProtocolPrivateInput__SP', bound=SigmaProtocol)  # <SP>
_SigmaProtocolPrivateInput__CI = typing.TypeVar('_SigmaProtocolPrivateInput__CI', bound=SigmaProtocolCommonInput)  # <CI>
class SigmaProtocolPrivateInput(typing.Generic[_SigmaProtocolPrivateInput__SP, _SigmaProtocolPrivateInput__CI]):
    def publicImage(self) -> _SigmaProtocolPrivateInput__CI: ...

_SigmaProtocolTranscript__SP = typing.TypeVar('_SigmaProtocolTranscript__SP', bound=SigmaProtocol)  # <SP>
_SigmaProtocolTranscript__CI = typing.TypeVar('_SigmaProtocolTranscript__CI', bound=SigmaProtocolCommonInput)  # <CI>
class SigmaProtocolTranscript(typing.Generic[_SigmaProtocolTranscript__SP, _SigmaProtocolTranscript__CI]):
    def a(self) -> 'FirstProverMessage': ...
    def accepted(self) -> bool: ...
    def e(self) -> typing.List[int]: ...
    def x(self) -> _SigmaProtocolTranscript__CI: ...
    def z(self) -> 'SecondProverMessage': ...

_SimulatingProver__SP = typing.TypeVar('_SimulatingProver__SP', bound=SigmaProtocol)  # <SP>
_SimulatingProver__CI = typing.TypeVar('_SimulatingProver__CI', bound=SigmaProtocolCommonInput)  # <CI>
class SimulatingProver(typing.Generic[_SimulatingProver__SP, _SimulatingProver__CI]):
    def challenge(self) -> typing.List[int]: ...

class TranscriptMessage: ...

_ZeroKnowledgeProofOfKnowledge__SP = typing.TypeVar('_ZeroKnowledgeProofOfKnowledge__SP', bound=SigmaProtocol)  # <SP>
class ZeroKnowledgeProofOfKnowledge(typing.Generic[_ZeroKnowledgeProofOfKnowledge__SP]): ...

_BcDlogGroup__ElemType = typing.TypeVar('_BcDlogGroup__ElemType', bound=org.bouncycastle.math.ec.ECPoint)  # <ElemType>
class BcDlogGroup(DlogGroup[_BcDlogGroup__ElemType], typing.Generic[_BcDlogGroup__ElemType]):
    def __init__(self, x9params: org.bouncycastle.asn1.x9.X9ECParameters): ...
    def calcK(self, p: java.math.BigInteger) -> int: ...
    def checkCurveMembership(self, x: java.math.BigInteger, y: java.math.BigInteger) -> bool: ...
    def computeLL(self, groupElements: typing.List[_BcDlogGroup__ElemType], exponentiations: typing.List[java.math.BigInteger]) -> _BcDlogGroup__ElemType: ...
    def computeNaive(self, groupElements: typing.List[_BcDlogGroup__ElemType], exponentiations: typing.List[java.math.BigInteger]) -> _BcDlogGroup__ElemType: ...
    def createRandomElement(self) -> _BcDlogGroup__ElemType: ...
    def createRandomGenerator(self) -> _BcDlogGroup__ElemType: ...
    def curve(self) -> org.bouncycastle.math.ec.ECCurve: ...
    def endExponentiateWithPreComputedValues(self, base: _BcDlogGroup__ElemType) -> None: ...
    def exponentiate(self, base: _BcDlogGroup__ElemType, exponent: java.math.BigInteger) -> _BcDlogGroup__ElemType: ...
    def exponentiateWithPreComputedValues(self, base: _BcDlogGroup__ElemType, exponent: java.math.BigInteger) -> _BcDlogGroup__ElemType: ...
    def generator(self) -> _BcDlogGroup__ElemType: ...
    def identity(self) -> _BcDlogGroup__ElemType: ...
    def inverseOf(self, groupElement: _BcDlogGroup__ElemType) -> _BcDlogGroup__ElemType: ...
    def k(self) -> int: ...
    def maxLengthOfByteArrayForEncoding(self) -> int: ...
    def multiplyGroupElements(self, groupElement1: _BcDlogGroup__ElemType, groupElement2: _BcDlogGroup__ElemType) -> _BcDlogGroup__ElemType: ...
    def order(self) -> java.math.BigInteger: ...
    def orderGreaterThan(self, numBits: int) -> bool: ...
    def p(self) -> java.math.BigInteger: ...
    def q(self) -> java.math.BigInteger: ...
    def secureRandom(self) -> java.security.SecureRandom: ...
    def sigmastate$basics$DlogGroup$_setter_$secureRandom_$eq(self, x$1: java.security.SecureRandom) -> None: ...
    def simultaneousMultipleExponentiations(self, groupElements: typing.List[_BcDlogGroup__ElemType], exponentiations: typing.List[java.math.BigInteger]) -> _BcDlogGroup__ElemType: ...
    def x9params(self) -> org.bouncycastle.asn1.x9.X9ECParameters: ...
    class GroupElementsExponentiations:
        $outer: 'BcDlogGroup' = ...
        def __init__(self, $outer: 'BcDlogGroup', base: _BcDlogGroup__ElemType): ...
        def getExponentiation(self, size: java.math.BigInteger) -> _BcDlogGroup__ElemType: ...
        def two(self) -> java.math.BigInteger: ...

class DiffieHellmanTupleProtocol(SigmaProtocol['DiffieHellmanTupleProtocol']): ...

class DiffieHellmanTupleProverInput(SigmaProtocolPrivateInput[DiffieHellmanTupleProtocol, ProveDHTuple], scala.Product, scala.Serializable):
    def __init__(self, w: java.math.BigInteger, commonInput: ProveDHTuple): ...
    @staticmethod
    def apply(w: java.math.BigInteger, commonInput: ProveDHTuple) -> 'DiffieHellmanTupleProverInput': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def commonInput(self) -> ProveDHTuple: ...
    def copy(self, w: java.math.BigInteger, commonInput: ProveDHTuple) -> 'DiffieHellmanTupleProverInput': ...
    def copy$default$1(self) -> java.math.BigInteger: ...
    def copy$default$2(self) -> ProveDHTuple: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def publicImage(self) -> ProveDHTuple: ...
    @staticmethod
    def random() -> 'DiffieHellmanTupleProverInput': ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'DiffieHellmanTupleProverInput') -> scala.Option[scala.Tuple2[java.math.BigInteger, ProveDHTuple]]: ...
    def w(self) -> java.math.BigInteger: ...

_Prover__SP = typing.TypeVar('_Prover__SP', bound=SigmaProtocol)  # <SP>
_Prover__CI = typing.TypeVar('_Prover__CI', bound=SigmaProtocolCommonInput)  # <CI>
_Prover__PI = typing.TypeVar('_Prover__PI', bound=SigmaProtocolPrivateInput)  # <PI>
class Prover(Party[_Prover__SP, _Prover__CI], typing.Generic[_Prover__SP, _Prover__CI, _Prover__PI]):
    def privateInputOpt(self) -> scala.Option[_Prover__PI]: ...

class ProverMessage(TranscriptMessage): ...

_Verifier__SP = typing.TypeVar('_Verifier__SP', bound=SigmaProtocol)  # <SP>
_Verifier__CI = typing.TypeVar('_Verifier__CI', bound=SigmaProtocolCommonInput)  # <CI>
class Verifier(Party[_Verifier__SP, _Verifier__CI], typing.Generic[_Verifier__SP, _Verifier__CI]):
    @staticmethod
    def $init$($this: 'Verifier') -> None: ...
    def challenge(self) -> typing.List[int]: ...
    def prover(self) -> Prover: ...
    def publicInput(self) -> _Verifier__CI: ...
    def transcript(self) -> scala.concurrent.Future[scala.Option[SigmaProtocolTranscript]]: ...

class VerifierMessage(TranscriptMessage):
    class Challenge$(supertagged.package.TaggedType[typing.List[int]]):
        MODULE$: typing.ClassVar['VerifierMessage.Challenge.'] = ...
        def __init__(self): ...
        _$at$at__TagIn = typing.TypeVar('_$at$at__TagIn')  # <TagIn>
        _$at$at__Sub = typing.TypeVar('_$at$at__Sub')  # <Sub>
        _$at$at__C = typing.TypeVar('_$at$at__C')  # <C>
        def $at$at(self, c: _.at.at__C, tagger: supertagged.package.Tagger[_.at.at__TagIn, typing.List[int], supertagged.package.TaggedType, _.at.at__Sub, _.at.at__C]) -> typing.Any: ...
        _$bang$at$at__TagIn = typing.TypeVar('_$bang$at$at__TagIn')  # <TagIn>
        _$bang$at$at__Sub = typing.TypeVar('_$bang$at$at__Sub')  # <Sub>
        _$bang$at$at__C = typing.TypeVar('_$bang$at$at__C')  # <C>
        def $bang$at$at(self, c: _.bang.at.at__C, tagger: supertagged.package.Tagger[_.bang.at.at__TagIn, typing.List[int], supertagged.package.TaggedType, _.bang.at.at__Sub, _.bang.at.at__C]) -> typing.Any: ...
        _apply__TagIn = typing.TypeVar('_apply__TagIn')  # <TagIn>
        _apply__Sub = typing.TypeVar('_apply__Sub')  # <Sub>
        _apply__C = typing.TypeVar('_apply__C')  # <C>
        def apply(self, c: _apply__C, tagger: supertagged.package.Tagger[_apply__TagIn, typing.List[int], supertagged.package.TaggedType, _apply__Sub, _apply__C]) -> typing.Any: ...
        _ordering__U = typing.TypeVar('_ordering__U')  # <U>
        def ordering(self, origin: scala.math.Ordering[typing.List[int]]) -> scala.math.Ordering[typing.List[int]]: ...
        def raw(self, c: typing.Any) -> typing.Any: ...
        _untag__TagIn = typing.TypeVar('_untag__TagIn')  # <TagIn>
        _untag__Sub = typing.TypeVar('_untag__Sub')  # <Sub>
        _untag__C = typing.TypeVar('_untag__C')  # <C>
        def untag(self, c: _untag__C, tagger: supertagged.package.Tagger[_untag__TagIn, typing.List[int], supertagged.package.TaggedType, _untag__Sub, _untag__C]) -> typing.Any: ...

class FirstProverMessage(ProverMessage):
    def bytes(self) -> typing.List[int]: ...

_InteractiveProver__SP = typing.TypeVar('_InteractiveProver__SP', bound=SigmaProtocol)  # <SP>
_InteractiveProver__CI = typing.TypeVar('_InteractiveProver__CI', bound=SigmaProtocolCommonInput)  # <CI>
_InteractiveProver__PI = typing.TypeVar('_InteractiveProver__PI', bound=SigmaProtocolPrivateInput)  # <PI>
class InteractiveProver(Prover[_InteractiveProver__SP, _InteractiveProver__CI, _InteractiveProver__PI], InteractiveParty, typing.Generic[_InteractiveProver__SP, _InteractiveProver__CI, _InteractiveProver__PI]):
    def firstMessage(self) -> FirstProverMessage: ...
    def secondMessage(self, challenge: typing.List[int]) -> 'SecondProverMessage': ...
    def simulate(self, challenge: typing.List[int]) -> scala.Tuple2[FirstProverMessage, 'SecondProverMessage']: ...

_NonInteractiveProver__SP = typing.TypeVar('_NonInteractiveProver__SP', bound=SigmaProtocol)  # <SP>
_NonInteractiveProver__PI = typing.TypeVar('_NonInteractiveProver__PI', bound=SigmaProtocolPrivateInput)  # <PI>
_NonInteractiveProver__CI = typing.TypeVar('_NonInteractiveProver__CI', bound=sigmastate.SigmaProofOfKnowledgeLeaf)  # <CI>
_NonInteractiveProver__P = typing.TypeVar('_NonInteractiveProver__P', bound=sigmastate.UncheckedTree)  # <P>
class NonInteractiveProver(Prover[_NonInteractiveProver__SP, _NonInteractiveProver__CI, _NonInteractiveProver__PI], typing.Generic[_NonInteractiveProver__SP, _NonInteractiveProver__PI, _NonInteractiveProver__CI, _NonInteractiveProver__P]):
    def prove(self, challenge: typing.List[int]) -> _NonInteractiveProver__P: ...

class SecondProverMessage(ProverMessage): ...

class DLogProtocol:
    class DLogInteractiveProver$:
        MODULE$: typing.ClassVar['DLogProtocol.DLogInteractiveProver.'] = ...
        def __init__(self): ...
        def computeCommitment(self, proposition: 'DLogProtocol.ProveDlog', challenge: typing.List[int], secondMessage: 'DLogProtocol.SecondDLogProverMessage') -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
        def firstMessage(self) -> scala.Tuple2[java.math.BigInteger, 'DLogProtocol.FirstDLogProverMessage']: ...
        def secondMessage(self, privateInput: 'DLogProtocol.DLogProverInput', rnd: java.math.BigInteger, challenge: typing.List[int]) -> 'DLogProtocol.SecondDLogProverMessage': ...
        def simulate(self, publicInput: 'DLogProtocol.ProveDlog', challenge: typing.List[int]) -> scala.Tuple2['DLogProtocol.FirstDLogProverMessage', 'DLogProtocol.SecondDLogProverMessage']: ...
    class DLogProverInput(SigmaProtocolPrivateInput['DLogProtocol.DLogSigmaProtocol', 'DLogProtocol.ProveDlog'], scala.Product, scala.Serializable):
        def __init__(self, w: java.math.BigInteger): ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def copy(self, w: java.math.BigInteger) -> 'DLogProtocol.DLogProverInput': ...
        def copy$default$1(self) -> java.math.BigInteger: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def publicImage(self) -> 'DLogProtocol.ProveDlog': ...
        def toString(self) -> java.lang.String: ...
        def w(self) -> java.math.BigInteger: ...
    class DLogProverInput$(scala.Serializable):
        MODULE$: typing.ClassVar['DLogProtocol.DLogProverInput.'] = ...
        def __init__(self): ...
        def apply(self, w: java.math.BigInteger) -> 'DLogProtocol.DLogProverInput': ...
        def random(self) -> 'DLogProtocol.DLogProverInput': ...
        def unapply(self, x$0: 'DLogProtocol.DLogProverInput') -> scala.Option[java.math.BigInteger]: ...
    class DLogSigmaProtocol(SigmaProtocol['DLogProtocol.DLogSigmaProtocol']): ...
    class FirstDLogProverMessage(FirstProverMessage, scala.Product, scala.Serializable):
        def __init__(self, ecData: org.bouncycastle.math.ec.custom.sec.SecP256K1Point): ...
        def bytes(self) -> typing.List[int]: ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def copy(self, ecData: org.bouncycastle.math.ec.custom.sec.SecP256K1Point) -> 'DLogProtocol.FirstDLogProverMessage': ...
        def copy$default$1(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
        def ecData(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def toString(self) -> java.lang.String: ...
    class FirstDLogProverMessage$(scala.runtime.AbstractFunction1[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, 'DLogProtocol.FirstDLogProverMessage'], scala.Serializable):
        MODULE$: typing.ClassVar['DLogProtocol.FirstDLogProverMessage.'] = ...
        def __init__(self): ...
        def apply(self, ecData: org.bouncycastle.math.ec.custom.sec.SecP256K1Point) -> 'DLogProtocol.FirstDLogProverMessage': ...
        def toString(self) -> java.lang.String: ...
        def unapply(self, x$0: 'DLogProtocol.FirstDLogProverMessage') -> scala.Option[org.bouncycastle.math.ec.custom.sec.SecP256K1Point]: ...
    class ProveDlog(sigmastate.SigmaProofOfKnowledgeLeaf['DLogProtocol.DLogSigmaProtocol', 'DLogProtocol.DLogProverInput'], scala.Product, scala.Serializable):
        def __init__(self, value: org.bouncycastle.math.ec.custom.sec.SecP256K1Point): ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def copy(self, value: org.bouncycastle.math.ec.custom.sec.SecP256K1Point) -> 'DLogProtocol.ProveDlog': ...
        def copy$default$1(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def h(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
        def hashCode(self) -> int: ...
        def opCode(self) -> int: ...
        def pkBytes(self) -> typing.List[int]: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def sigmastate$basics$SigmaProtocolCommonInput$_setter_$soundness_$eq(self, x$1: int) -> None: ...
        def size(self) -> int: ...
        def soundness(self) -> int: ...
        def toString(self) -> java.lang.String: ...
        def value(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    class ProveDlog$(scala.Serializable):
        MODULE$: typing.ClassVar['DLogProtocol.ProveDlog.'] = ...
        def __init__(self): ...
        def Code(self) -> int: ...
        def apply(self, value: org.bouncycastle.math.ec.custom.sec.SecP256K1Point) -> 'DLogProtocol.ProveDlog': ...
        def unapply(self, x$0: 'DLogProtocol.ProveDlog') -> scala.Option[org.bouncycastle.math.ec.custom.sec.SecP256K1Point]: ...
    class ProveDlogProp$:
        MODULE$: typing.ClassVar['DLogProtocol.ProveDlogProp.'] = ...
        def __init__(self): ...
        def unapply(self, p: special.sigma.SigmaProp) -> scala.Option['DLogProtocol.ProveDlog']: ...
    class SecondDLogProverMessage(SecondProverMessage, scala.Product, scala.Serializable):
        def __init__(self, z: scala.math.BigInt): ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def copy(self, z: scala.math.BigInt) -> 'DLogProtocol.SecondDLogProverMessage': ...
        def copy$default$1(self) -> scala.math.BigInt: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def toString(self) -> java.lang.String: ...
        def z(self) -> scala.math.BigInt: ...
    class SecondDLogProverMessage$(scala.runtime.AbstractFunction1[scala.math.BigInt, 'DLogProtocol.SecondDLogProverMessage'], scala.Serializable):
        MODULE$: typing.ClassVar['DLogProtocol.SecondDLogProverMessage.'] = ...
        def __init__(self): ...
        def apply(self, z: scala.math.BigInt) -> 'DLogProtocol.SecondDLogProverMessage': ...
        def toString(self) -> java.lang.String: ...
        def unapply(self, x$0: 'DLogProtocol.SecondDLogProverMessage') -> scala.Option[scala.math.BigInt]: ...

class FirstDiffieHellmanTupleProverMessage(FirstProverMessage, scala.Product, scala.Serializable):
    def __init__(self, a: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, b: org.bouncycastle.math.ec.custom.sec.SecP256K1Point): ...
    def a(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    @staticmethod
    def apply(a: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, b: org.bouncycastle.math.ec.custom.sec.SecP256K1Point) -> 'FirstDiffieHellmanTupleProverMessage': ...
    def b(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def bytes(self) -> typing.List[int]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, a: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, b: org.bouncycastle.math.ec.custom.sec.SecP256K1Point) -> 'FirstDiffieHellmanTupleProverMessage': ...
    def copy$default$1(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def copy$default$2(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    @staticmethod
    def curried() -> scala.Function1[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, scala.Function1[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, 'FirstDiffieHellmanTupleProverMessage']]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, org.bouncycastle.math.ec.custom.sec.SecP256K1Point], 'FirstDiffieHellmanTupleProverMessage']: ...
    @staticmethod
    def unapply(x$0: 'FirstDiffieHellmanTupleProverMessage') -> scala.Option[scala.Tuple2[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, org.bouncycastle.math.ec.custom.sec.SecP256K1Point]]: ...

class SecondDiffieHellmanTupleProverMessage(SecondProverMessage, scala.Product, scala.Serializable):
    def __init__(self, z: java.math.BigInteger): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['SecondDiffieHellmanTupleProverMessage', _andThen__A]) -> scala.Function1[java.math.BigInteger, _andThen__A]: ...
    @staticmethod
    def apply(z: java.math.BigInteger) -> 'SecondDiffieHellmanTupleProverMessage': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, java.math.BigInteger]) -> scala.Function1[_compose__A, 'SecondDiffieHellmanTupleProverMessage']: ...
    def copy(self, z: java.math.BigInteger) -> 'SecondDiffieHellmanTupleProverMessage': ...
    def copy$default$1(self) -> java.math.BigInteger: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'SecondDiffieHellmanTupleProverMessage') -> scala.Option[java.math.BigInteger]: ...
    def z(self) -> java.math.BigInteger: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("sigmastate.basics")``.

    BcDlogGroup: typing.Type[BcDlogGroup]
    DLogProtocol: typing.Type[DLogProtocol]
    DiffieHellmanTupleInteractiveProver: typing.Type[DiffieHellmanTupleInteractiveProver]
    DiffieHellmanTupleProtocol: typing.Type[DiffieHellmanTupleProtocol]
    DiffieHellmanTupleProverInput: typing.Type[DiffieHellmanTupleProverInput]
    DlogGroup: typing.Type[DlogGroup]
    FirstDiffieHellmanTupleProverMessage: typing.Type[FirstDiffieHellmanTupleProverMessage]
    FirstProverMessage: typing.Type[FirstProverMessage]
    InteractiveParty: typing.Type[InteractiveParty]
    InteractiveProver: typing.Type[InteractiveProver]
    NonInteractiveProver: typing.Type[NonInteractiveProver]
    Party: typing.Type[Party]
    ProveDHTuple: typing.Type[ProveDHTuple]
    ProveDHTupleProp: typing.Type[ProveDHTupleProp]
    Prover: typing.Type[Prover]
    ProverMessage: typing.Type[ProverMessage]
    SecP256K1: typing.Type[SecP256K1]
    SecondDiffieHellmanTupleProverMessage: typing.Type[SecondDiffieHellmanTupleProverMessage]
    SecondProverMessage: typing.Type[SecondProverMessage]
    SigmaProtocol: typing.Type[SigmaProtocol]
    SigmaProtocolCommonInput: typing.Type[SigmaProtocolCommonInput]
    SigmaProtocolPrivateInput: typing.Type[SigmaProtocolPrivateInput]
    SigmaProtocolTranscript: typing.Type[SigmaProtocolTranscript]
    SimulatingProver: typing.Type[SimulatingProver]
    TranscriptMessage: typing.Type[TranscriptMessage]
    Verifier: typing.Type[Verifier]
    VerifierMessage: typing.Type[VerifierMessage]
    ZeroKnowledgeProofOfKnowledge: typing.Type[ZeroKnowledgeProofOfKnowledge]
