import java.lang
import scala
import sigmastate.lang
import typing



class SigmaException(java.lang.Exception):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext], cause: scala.Option[java.lang.Throwable]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...
    @staticmethod
    def $lessinit$greater$default$3() -> scala.Option[java.lang.Throwable]: ...
    def cause(self) -> scala.Option[java.lang.Throwable]: ...
    def getMessage(self) -> java.lang.String: ...
    def message(self) -> java.lang.String: ...
    def source(self) -> scala.Option[sigmastate.lang.SourceContext]: ...

class BinderException(SigmaException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...

class BuilderException(SigmaException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...

class CostLimitException(SigmaException):
    def __init__(self, estimatedCost: int, message: typing.Union[java.lang.String, str], cause: scala.Option[java.lang.Throwable]): ...
    @staticmethod
    def $lessinit$greater$default$3() -> scala.Option[java.lang.Throwable]: ...
    def estimatedCost(self) -> int: ...
    @staticmethod
    def msgCostLimitError(cost: int, limit: int) -> java.lang.String: ...

class CosterException(SigmaException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext], cause: scala.Option[java.lang.Throwable]): ...
    @staticmethod
    def $lessinit$greater$default$3() -> scala.Option[java.lang.Throwable]: ...

class InterpreterException(SigmaException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext], cause: scala.Option[java.lang.Throwable]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...
    @staticmethod
    def $lessinit$greater$default$3() -> scala.Option[java.lang.Throwable]: ...

class SerializerException(SigmaException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext], cause: scala.Option[java.lang.Throwable]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...
    @staticmethod
    def $lessinit$greater$default$3() -> scala.Option[java.lang.Throwable]: ...

class SpecializerException(SigmaException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...

class TyperException(SigmaException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...

class ConstraintFailed(BuilderException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...

class DeserializeCallDepthExceeded(SerializerException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext], cause: scala.Option[java.lang.Throwable]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...
    @staticmethod
    def $lessinit$greater$default$3() -> scala.Option[java.lang.Throwable]: ...

class InputSizeLimitExceeded(SerializerException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext], cause: scala.Option[java.lang.Throwable]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...
    @staticmethod
    def $lessinit$greater$default$3() -> scala.Option[java.lang.Throwable]: ...

class InvalidArguments(BinderException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...

class InvalidBinaryOperationParameters(TyperException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...

class InvalidOpCode(SerializerException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext], cause: scala.Option[java.lang.Throwable]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...
    @staticmethod
    def $lessinit$greater$default$3() -> scala.Option[java.lang.Throwable]: ...

class InvalidTypePrefix(SerializerException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext], cause: scala.Option[java.lang.Throwable]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...
    @staticmethod
    def $lessinit$greater$default$3() -> scala.Option[java.lang.Throwable]: ...

class InvalidUnaryOperationParameters(TyperException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...

class MethodNotFound(TyperException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...

class NonApplicableMethod(TyperException):
    def __init__(self, message: typing.Union[java.lang.String, str], source: scala.Option[sigmastate.lang.SourceContext]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[sigmastate.lang.SourceContext]: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("sigmastate.lang.exceptions")``.

    BinderException: typing.Type[BinderException]
    BuilderException: typing.Type[BuilderException]
    ConstraintFailed: typing.Type[ConstraintFailed]
    CostLimitException: typing.Type[CostLimitException]
    CosterException: typing.Type[CosterException]
    DeserializeCallDepthExceeded: typing.Type[DeserializeCallDepthExceeded]
    InputSizeLimitExceeded: typing.Type[InputSizeLimitExceeded]
    InterpreterException: typing.Type[InterpreterException]
    InvalidArguments: typing.Type[InvalidArguments]
    InvalidBinaryOperationParameters: typing.Type[InvalidBinaryOperationParameters]
    InvalidOpCode: typing.Type[InvalidOpCode]
    InvalidTypePrefix: typing.Type[InvalidTypePrefix]
    InvalidUnaryOperationParameters: typing.Type[InvalidUnaryOperationParameters]
    MethodNotFound: typing.Type[MethodNotFound]
    NonApplicableMethod: typing.Type[NonApplicableMethod]
    SerializerException: typing.Type[SerializerException]
    SigmaException: typing.Type[SigmaException]
    SpecializerException: typing.Type[SpecializerException]
    TyperException: typing.Type[TyperException]
