/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.util;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class FieldNameResolver {
    private final FieldNamingStrategy fieldNamingStrategy;
    private final ConcurrentMap<Field, String> fieldNameCache = new ConcurrentHashMap<Field, String>();

    public FieldNameResolver(Gson gson) {
        this.fieldNamingStrategy = this.getFieldNamingStrategy(gson);
    }

    public String getFieldName(Field field2) {
        String fieldName = (String)this.fieldNameCache.get(field2);
        if (fieldName == null) {
            SerializedName serializedName = field2.getAnnotation(SerializedName.class);
            fieldName = serializedName == null ? this.fieldNamingStrategy.translateName(field2) : serializedName.value();
            if (!this.fieldNameCache.containsKey(field2)) {
                this.fieldNameCache.put(field2, fieldName);
            }
        }
        return fieldName;
    }

    private FieldNamingStrategy getFieldNamingStrategy(Gson gson) {
        return gson.fieldNamingStrategy();
    }
}

