/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.explorer.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ergoplatform.explorer.client.model.AdditionalRegisters;
import org.ergoplatform.explorer.client.model.AssetInstanceInfo;

public class InputInfo {
    @SerializedName(value="boxId")
    private String boxId = null;
    @SerializedName(value="value")
    private Long value = null;
    @SerializedName(value="index")
    private Integer index = null;
    @SerializedName(value="spendingProof")
    private String spendingProof = null;
    @SerializedName(value="outputBlockId")
    private String outputBlockId = null;
    @SerializedName(value="outputTransactionId")
    private String outputTransactionId = null;
    @SerializedName(value="outputIndex")
    private Integer outputIndex = null;
    @SerializedName(value="ergoTree")
    private String ergoTree = null;
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="assets")
    private List<AssetInstanceInfo> assets = null;
    @SerializedName(value="additionalRegisters")
    private AdditionalRegisters additionalRegisters = null;

    public InputInfo boxId(String string) {
        this.boxId = string;
        return this;
    }

    @Schema(required=true, description="ID of the corresponding box")
    public String getBoxId() {
        return this.boxId;
    }

    public void setBoxId(String string) {
        this.boxId = string;
    }

    public InputInfo value(Long l) {
        this.value = l;
        return this;
    }

    @Schema(required=true, description="Number of nanoErgs in the corresponding box")
    public Long getValue() {
        return this.value;
    }

    public void setValue(Long l) {
        this.value = l;
    }

    public InputInfo index(Integer n) {
        this.index = n;
        return this;
    }

    @Schema(required=true, description="Index of the input in a transaction")
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer n) {
        this.index = n;
    }

    public InputInfo spendingProof(String string) {
        this.spendingProof = string;
        return this;
    }

    @Schema(description="Hex-encoded serialized sigma proof")
    public String getSpendingProof() {
        return this.spendingProof;
    }

    public void setSpendingProof(String string) {
        this.spendingProof = string;
    }

    public InputInfo outputBlockId(String string) {
        this.outputBlockId = string;
        return this;
    }

    @Schema(required=true, description="Modifier ID")
    public String getOutputBlockId() {
        return this.outputBlockId;
    }

    public void setOutputBlockId(String string) {
        this.outputBlockId = string;
    }

    public InputInfo outputTransactionId(String string) {
        this.outputTransactionId = string;
        return this;
    }

    @Schema(required=true, description="ID of the transaction outputting corresponding box")
    public String getOutputTransactionId() {
        return this.outputTransactionId;
    }

    public void setOutputTransactionId(String string) {
        this.outputTransactionId = string;
    }

    public InputInfo outputIndex(Integer n) {
        this.outputIndex = n;
        return this;
    }

    @Schema(required=true, description="Index of the output corresponding this input")
    public Integer getOutputIndex() {
        return this.outputIndex;
    }

    public void setOutputIndex(Integer n) {
        this.outputIndex = n;
    }

    public InputInfo ergoTree(String string) {
        this.ergoTree = string;
        return this;
    }

    @Schema(required=true, description="Hex-encoded string")
    public String getErgoTree() {
        return this.ergoTree;
    }

    public void setErgoTree(String string) {
        this.ergoTree = string;
    }

    public InputInfo address(String string) {
        this.address = string;
        return this;
    }

    @Schema(required=true, description="Decoded address of the corresponding box holder")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public InputInfo assets(List<AssetInstanceInfo> list) {
        this.assets = list;
        return this;
    }

    public InputInfo addAssetsItem(AssetInstanceInfo assetInstanceInfo) {
        if (this.assets == null) {
            this.assets = new ArrayList<AssetInstanceInfo>();
        }
        this.assets.add(assetInstanceInfo);
        return this;
    }

    @Schema(description="")
    public List<AssetInstanceInfo> getAssets() {
        return this.assets;
    }

    public void setAssets(List<AssetInstanceInfo> list) {
        this.assets = list;
    }

    public InputInfo additionalRegisters(AdditionalRegisters additionalRegisters) {
        this.additionalRegisters = additionalRegisters;
        return this;
    }

    @Schema(required=true, description="")
    public AdditionalRegisters getAdditionalRegisters() {
        return this.additionalRegisters;
    }

    public void setAdditionalRegisters(AdditionalRegisters additionalRegisters) {
        this.additionalRegisters = additionalRegisters;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        InputInfo inputInfo = (InputInfo)object;
        return Objects.equals(this.boxId, inputInfo.boxId) && Objects.equals(this.value, inputInfo.value) && Objects.equals(this.index, inputInfo.index) && Objects.equals(this.spendingProof, inputInfo.spendingProof) && Objects.equals(this.outputBlockId, inputInfo.outputBlockId) && Objects.equals(this.outputTransactionId, inputInfo.outputTransactionId) && Objects.equals(this.outputIndex, inputInfo.outputIndex) && Objects.equals(this.ergoTree, inputInfo.ergoTree) && Objects.equals(this.address, inputInfo.address) && Objects.equals(this.assets, inputInfo.assets) && Objects.equals(this.additionalRegisters, inputInfo.additionalRegisters);
    }

    public int hashCode() {
        return Objects.hash(this.boxId, this.value, this.index, this.spendingProof, this.outputBlockId, this.outputTransactionId, this.outputIndex, this.ergoTree, this.address, this.assets, this.additionalRegisters);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("class InputInfo {\n");
        stringBuilder.append("    boxId: ").append(this.toIndentedString(this.boxId)).append("\n");
        stringBuilder.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        stringBuilder.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        stringBuilder.append("    spendingProof: ").append(this.toIndentedString(this.spendingProof)).append("\n");
        stringBuilder.append("    outputBlockId: ").append(this.toIndentedString(this.outputBlockId)).append("\n");
        stringBuilder.append("    outputTransactionId: ").append(this.toIndentedString(this.outputTransactionId)).append("\n");
        stringBuilder.append("    outputIndex: ").append(this.toIndentedString(this.outputIndex)).append("\n");
        stringBuilder.append("    ergoTree: ").append(this.toIndentedString(this.ergoTree)).append("\n");
        stringBuilder.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        stringBuilder.append("    assets: ").append(this.toIndentedString(this.assets)).append("\n");
        stringBuilder.append("    additionalRegisters: ").append(this.toIndentedString(this.additionalRegisters)).append("\n");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private String toIndentedString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.toString().replace("\n", "\n    ");
    }
}

