/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.wallet.secrets;

import io.circe.syntax.package$;
import io.circe.syntax.package$EncoderOps$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.UUID;
import org.ergoplatform.wallet.crypto.AES$;
import org.ergoplatform.wallet.interface4j.SecretString;
import org.ergoplatform.wallet.mnemonic.Mnemonic$;
import org.ergoplatform.wallet.secrets.EncryptedSecret;
import org.ergoplatform.wallet.secrets.EncryptedSecret$;
import org.ergoplatform.wallet.secrets.EncryptedSecret$EncryptedSecretEncoder$;
import org.ergoplatform.wallet.secrets.JsonSecretStorage;
import org.ergoplatform.wallet.settings.SecretStorageSettings;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scorex.utils.Random$;

public final class JsonSecretStorage$ {
    public static JsonSecretStorage$ MODULE$;

    static {
        new JsonSecretStorage$();
    }

    public JsonSecretStorage init(byte[] seed, SecretString pass, SecretStorageSettings settings) {
        byte[] iv = Random$.MODULE$.randomBytes(AES$.MODULE$.NonceBitsLen() / 8);
        byte[] salt = Random$.MODULE$.randomBytes(32);
        Tuple2<byte[], byte[]> tuple2 = AES$.MODULE$.encrypt(seed, pass.getData(), salt, iv, settings.encryption());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte[] ciphertext = tuple2._1();
        byte[] tag2 = tuple2._2();
        Tuple2<byte[], byte[]> tuple22 = new Tuple2<byte[], byte[]>(ciphertext, tag2);
        Tuple2<byte[], byte[]> tuple23 = tuple22;
        byte[] ciphertext2 = tuple23._1();
        byte[] tag3 = tuple23._2();
        EncryptedSecret encryptedSecret = EncryptedSecret$.MODULE$.apply(ciphertext2, salt, iv, tag3, settings.encryption());
        UUID uuid = UUID.nameUUIDFromBytes(ciphertext2);
        new File(settings.secretDir()).mkdirs();
        File file = new File(new StringBuilder(6).append(settings.secretDir()).append("/").append(uuid).append(".json").toString());
        PrintWriter outWriter = new PrintWriter(file);
        String jsonRaw = package$EncoderOps$.MODULE$.asJson$extension(package$.MODULE$.EncoderOps(encryptedSecret), EncryptedSecret$EncryptedSecretEncoder$.MODULE$).noSpaces();
        outWriter.write(jsonRaw);
        outWriter.close();
        pass.erase();
        Arrays.fill(seed, (byte)0);
        return new JsonSecretStorage(file, settings.encryption());
    }

    public JsonSecretStorage restore(SecretString mnemonic, Option<SecretString> mnemonicPassOpt, SecretString encryptionPass, SecretStorageSettings settings) {
        byte[] seed = Mnemonic$.MODULE$.toSeed(mnemonic, mnemonicPassOpt);
        return this.init(seed, encryptionPass, settings);
    }

    public Try<JsonSecretStorage> readFile(SecretStorageSettings settings) {
        Try try_;
        File dir = new File(settings.secretDir());
        if (dir.exists()) {
            Try try_2;
            List<Object> list = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).toList();
            if (list.size() > 1) {
                Try try_3;
                List jsonFiles = (List)list.filter((Function1<File, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean(JsonSecretStorage$.$anonfun$readFile$1(x$5)));
                Option option = jsonFiles.headOption();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    File headFile = (File)some.value();
                    try_3 = new Success<JsonSecretStorage>(new JsonSecretStorage(headFile, settings.encryption()));
                } else if (None$.MODULE$.equals(option)) {
                    try_3 = new Failure(new Exception(new StringBuilder(29).append("No json files found in dir '").append(dir).append("'").toString()));
                } else {
                    throw new MatchError(option);
                }
                try_2 = try_3;
            } else if (list instanceof $colon$colon) {
                $colon$colon $colon$colon = ($colon$colon)list;
                File headFile = (File)$colon$colon.head();
                try_2 = new Success<JsonSecretStorage>(new JsonSecretStorage(headFile, settings.encryption()));
            } else if (((Object)Nil$.MODULE$).equals(list)) {
                try_2 = new Failure(new Exception(new StringBuilder(57).append("Cannot readSecretStorage: Secret file not found in dir '").append(dir).append("'").toString()));
            } else {
                throw new MatchError(list);
            }
            try_ = try_2;
        } else {
            try_ = new Failure<JsonSecretStorage>(new FileNotFoundException(new StringBuilder(46).append("Cannot readSecretStorage: dir '").append(dir).append("' doesn't exist").toString()));
        }
        return try_;
    }

    public static final /* synthetic */ boolean $anonfun$readFile$1(File x$5) {
        return x$5.getName().contains(".json");
    }

    private JsonSecretStorage$() {
        MODULE$ = this;
    }
}

