/*
 * Decompiled with CFR 0.152.
 */
package scorex.crypto.authds.avltree.batch.serialization;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.util.Try;
import scala.util.Try$;
import scorex.crypto.authds.avltree.batch.BatchAVLProver;
import scorex.crypto.authds.avltree.batch.BatchAVLProver$;
import scorex.crypto.authds.avltree.batch.InternalProverNode;
import scorex.crypto.authds.avltree.batch.ProverLeaf;
import scorex.crypto.authds.avltree.batch.ProverNodes;
import scorex.crypto.authds.avltree.batch.serialization.BatchAVLProverManifest;
import scorex.crypto.authds.avltree.batch.serialization.BatchAVLProverSubtree;
import scorex.crypto.authds.avltree.batch.serialization.ProxyInternalNode;
import scorex.crypto.authds.avltree.batch.serialization.ProxyInternalNode$;
import scorex.crypto.authds.package$ADKey$;
import scorex.crypto.authds.package$ADValue$;
import scorex.crypto.authds.package$Balance$;
import scorex.crypto.hash.CryptographicHash;
import supertagged.package$Tagger$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001\u0002\t\u0012\u0001yA\u0001B\n\u0001\u0003\u0006\u0004%\u0019a\n\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005Q!)1\n\u0001C\u0001\u0019\"9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0006B\u0002,\u0001A\u0003%1+\u0002\u0003X\u0001\u0001A\u0006\"B5\u0001\t\u0003Q\u0007\"B5\u0001\t\u0003\u0019\b\"B<\u0001\t\u0003A\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\tA\")\u0019;dQ\u00063F\n\u0015:pm\u0016\u00148+\u001a:jC2L'0\u001a:\u000b\u0005I\u0019\u0012!D:fe&\fG.\u001b>bi&|gN\u0003\u0002\u0015+\u0005)!-\u0019;dQ*\u0011acF\u0001\bCZdGO]3f\u0015\tA\u0012$\u0001\u0004bkRDGm\u001d\u0006\u00035m\taa\u0019:zaR|'\"\u0001\u000f\u0002\rM\u001cwN]3y\u0007\u0001)2aH\u001c+'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VMZ\u0001\u0003Q\u001a,\u0012\u0001\u000b\t\u0003S)b\u0001\u0001B\u0003,\u0001\t\u0007AF\u0001\u0002I\rF\u0011Q\u0006\r\t\u0003C9J!a\f\u0012\u0003\u000f9{G\u000f[5oOB\u0019\u0011\u0007\u000e\u001c\u000e\u0003IR!aM\r\u0002\t!\f7\u000f[\u0005\u0003kI\u0012\u0011c\u0011:zaR|wM]1qQ&\u001c\u0007*Y:i!\tIs\u0007B\u00039\u0001\t\u0007\u0011HA\u0001E#\ti#\b\u0005\u0002<\u000f:\u0011A(\u0012\b\u0003{\u0011s!AP\"\u000f\u0005}\u0012U\"\u0001!\u000b\u0005\u0005k\u0012A\u0002\u001fs_>$h(C\u0001\u001d\u0013\tQ2$\u0003\u000243%\u0011aIM\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0015J\u0001\u0004ES\u001e,7\u000f\u001e\u0006\u0003\rJ\n1\u0001\u001b4!\u0003\u0019a\u0014N\\5u}Q\tQ\n\u0006\u0002O!B!q\n\u0001\u001c)\u001b\u0005\t\u0002\"\u0002\u0014\u0004\u0001\bA\u0013a\u00037bE\u0016dG*\u001a8hi\",\u0012a\u0015\t\u0003CQK!!\u0016\u0012\u0003\u0007%sG/\u0001\u0007mC\n,G\u000eT3oORD\u0007E\u0001\u0006TY&\u001cW\r\u001a+sK\u0016\u0004B!I-\\=&\u0011!L\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t=cf\u0007K\u0005\u0003;F\u0011aCQ1uG\"\fe\u000b\u0014)s_Z,'/T1oS\u001a,7\u000f\u001e\t\u0004?\u000e4gB\u00011c\u001d\ty\u0014-C\u0001$\u0013\t1%%\u0003\u0002eK\n\u00191+Z9\u000b\u0005\u0019\u0013\u0003\u0003B(hm!J!\u0001[\t\u0003+\t\u000bGo\u00195B-2\u0003&o\u001c<feN+(\r\u001e:fK\u0006)1\u000f\\5dKR\u00111.\u001c\t\u0003Y\u001ai\u0011\u0001\u0001\u0005\u0006]\u001e\u0001\ra\\\u0001\u0005iJ,W\r\u0005\u0003qcZBS\"A\n\n\u0005I\u001c\"A\u0004\"bi\u000eD\u0017I\u0016'Qe>4XM\u001d\u000b\u0004WR,\b\"\u00028\t\u0001\u0004y\u0007\"\u0002<\t\u0001\u0004\u0019\u0016\u0001D:vER\u0014X-\u001a#faRD\u0017aB2p[\nLg.\u001a\u000b\u0003s~\u00042A_?p\u001b\u0005Y(B\u0001?#\u0003\u0011)H/\u001b7\n\u0005y\\(a\u0001+ss\"1\u0011\u0011A\u0005A\u0002-\faa\u001d7jG\u0016$\u0017aD7b]&4Wm\u001d;U_\nKH/Z:\u0015\t\u0005\u001d\u00111\u0003\t\u0006C\u0005%\u0011QB\u0005\u0004\u0003\u0017\u0011#!B!se\u0006L\bcA\u0011\u0002\u0010%\u0019\u0011\u0011\u0003\u0012\u0003\t\tKH/\u001a\u0005\u0007\u0003+Q\u0001\u0019A.\u0002\u00115\fg.\u001b4fgR\f\u0011#\\1oS\u001a,7\u000f\u001e$s_6\u0014\u0015\u0010^3t)\u0011\tY\"!\b\u0011\u0007il8\fC\u0004\u0002 -\u0001\r!a\u0002\u0002\u000b\tLH/Z:\u0002\u001dM,(\r\u001e:fKR{')\u001f;fgR!\u0011qAA\u0013\u0011\u0019\t9\u0003\u0004a\u0001M\u0006\tA/\u0001\ttk\n$(/Z3Ge>l')\u001f;fgR1\u0011QFA\u0018\u0003g\u00012A_?g\u0011\u001d\t\t$\u0004a\u0001\u0003\u000f\t\u0011A\u0019\u0005\u0007\u0003ki\u0001\u0019A*\u0002\u0005-d\u0017\u0001\u00048pI\u0016\u001cHk\u001c\"zi\u0016\u001cH\u0003BA\u0004\u0003wAq!!\u0010\u000f\u0001\u0004\ty$A\u0002pE*\u0004B\u0001]A!m%\u0019\u00111I\n\u0003\u0017A\u0013xN^3s\u001d>$Wm]\u0001\u000f]>$Wm\u001d$s_6\u0014\u0015\u0010^3t)\u0019\tI%a\u0013\u0002PA!!0`A \u0011\u001d\tie\u0004a\u0001\u0003\u000f\tqAY=uKNLe\u000e\u0003\u0004\u0002R=\u0001\raU\u0001\nW\u0016LH*\u001a8hi\"\u0004")
public class BatchAVLProverSerializer<D extends byte[], HF extends CryptographicHash<D>> {
    private final HF hf;
    private final int labelLength;

    public HF hf() {
        return this.hf;
    }

    private int labelLength() {
        return this.labelLength;
    }

    public Tuple2<BatchAVLProverManifest<D, HF>, Seq<BatchAVLProverSubtree<D, HF>>> slice(BatchAVLProver<D, HF> tree) {
        return this.slice(tree, tree.rootNodeHeight() / 2);
    }

    public Tuple2<BatchAVLProverManifest<D, HF>, Seq<BatchAVLProverSubtree<D, HF>>> slice(BatchAVLProver<D, HF> tree, int subtreeDepth) {
        Tuple2<BatchAVLProverManifest<D, HF>, Seq<BatchAVLProverSubtree<D, HF>>> tuple2;
        ProverNodes<D> proverNodes = tree.topNode();
        if (proverNodes instanceof InternalProverNode) {
            InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
            int height = tree.rootNodeHeight();
            ProxyInternalNode rootProxyNode = ProxyInternalNode$.MODULE$.apply(internalProverNode, this.hf());
            Seq subtrees = this.getSubtrees$1((ProverNodes)internalProverNode.left(), height - 1, rootProxyNode, subtreeDepth).$plus$plus(this.getSubtrees$1((ProverNodes)internalProverNode.right(), height - 1, rootProxyNode, subtreeDepth), Seq$.MODULE$.canBuildFrom());
            BatchAVLProverManifest manifest = new BatchAVLProverManifest(tree.keyLength(), tree.valueLengthOpt(), new Tuple2(rootProxyNode, BoxesRunTime.boxToInteger(height)));
            tuple2 = new Tuple2(manifest, subtrees);
        } else if (proverNodes instanceof ProverLeaf) {
            ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
            tuple2 = new Tuple2<BatchAVLProverManifest<D, HF>, Seq<BatchAVLProverSubtree<D, HF>>>(new BatchAVLProverManifest(tree.keyLength(), tree.valueLengthOpt(), new Tuple2(proverLeaf, BoxesRunTime.boxToInteger(tree.rootNodeHeight()))), Nil$.MODULE$);
        } else {
            throw new MatchError(proverNodes);
        }
        return tuple2;
    }

    public Try<BatchAVLProver<D, HF>> combine(Tuple2<BatchAVLProverManifest<D, HF>, Seq<BatchAVLProverSubtree<D, HF>>> sliced) {
        return Try$.MODULE$.apply((Function0<BatchAVLProver> & Serializable & scala.Serializable)() -> {
            BatchAVLProver batchAVLProver;
            ProverNodes proverNodes = ((BatchAVLProverManifest)sliced._1()).rootAndHeight()._1();
            if (proverNodes instanceof InternalProverNode) {
                InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
                this.mutateLoop$1(internalProverNode, sliced);
                batchAVLProver = new BatchAVLProver(((BatchAVLProverManifest)sliced._1()).keyLength(), ((BatchAVLProverManifest)sliced._1()).valueLengthOpt(), new Some(((BatchAVLProverManifest)sliced._1()).rootAndHeight()), BatchAVLProver$.MODULE$.$lessinit$greater$default$4(), this.hf());
            } else if (proverNodes instanceof ProverLeaf) {
                batchAVLProver = new BatchAVLProver(((BatchAVLProverManifest)sliced._1()).keyLength(), ((BatchAVLProverManifest)sliced._1()).valueLengthOpt(), new Some(((BatchAVLProverManifest)sliced._1()).rootAndHeight()), BatchAVLProver$.MODULE$.$lessinit$greater$default$4(), this.hf());
            } else {
                throw new MatchError(proverNodes);
            }
            return batchAVLProver;
        });
    }

    public byte[] manifestToBytes(BatchAVLProverManifest<D, HF> manifest) {
        return Bytes.concat(Ints.toByteArray(manifest.keyLength()), Ints.toByteArray(BoxesRunTime.unboxToInt(manifest.valueLengthOpt().getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> -1))), Ints.toByteArray(manifest.rootAndHeight()._2$mcI$sp()), this.nodesToBytes(manifest.rootAndHeight()._1()));
    }

    public Try<BatchAVLProverManifest<D, HF>> manifestFromBytes(byte[] bytes) {
        return Try$.MODULE$.apply((Function0<BatchAVLProverManifest> & Serializable & scala.Serializable)() -> {
            int keyLength = Ints.fromByteArray((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(0, 4));
            int valueLength = Ints.fromByteArray((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(4, 8));
            if (valueLength < -1) {
                throw new Error(new StringBuilder(19).append("Wrong valueLength: ").append(valueLength).toString());
            }
            Option valueLengthOpt = valueLength == -1 ? None$.MODULE$ : new Some<Integer>(BoxesRunTime.boxToInteger(valueLength));
            int oldHeight = Ints.fromByteArray((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(8, 12));
            ProverNodes oldTop = this.nodesFromBytes((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(12, bytes.length), keyLength).get();
            return new BatchAVLProverManifest(keyLength, valueLengthOpt, new Tuple2(oldTop, BoxesRunTime.boxToInteger(oldHeight)));
        });
    }

    public byte[] subtreeToBytes(BatchAVLProverSubtree<D, HF> t) {
        return this.nodesToBytes(t.subtreeTop());
    }

    public Try<BatchAVLProverSubtree<D, HF>> subtreeFromBytes(byte[] b, int kl) {
        return this.nodesFromBytes(b, kl).map((Function1<ProverNodes, BatchAVLProverSubtree> & Serializable & scala.Serializable)topNode -> new BatchAVLProverSubtree(topNode));
    }

    public byte[] nodesToBytes(ProverNodes<D> obj) {
        return BatchAVLProverSerializer.loop$1(obj);
    }

    public Try<ProverNodes<D>> nodesFromBytes(byte[] bytesIn, int keyLength) {
        return Try$.MODULE$.apply((Function0<ProverNodes> & Serializable & scala.Serializable)() -> this.loop$2(bytesIn, keyLength));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Seq getSubtrees$1(ProverNodes currentNode, int currentHeight, ProxyInternalNode parent, int subtreeDepth$1) {
        boolean bl = false;
        InternalProverNode internalProverNode = null;
        ProverNodes proverNodes = currentNode;
        if (proverNodes instanceof InternalProverNode) {
            bl = true;
            internalProverNode = (InternalProverNode)proverNodes;
            if (currentHeight > subtreeDepth$1) {
                ProxyInternalNode nextParent = ProxyInternalNode$.MODULE$.apply(internalProverNode, this.hf());
                parent.mutate(nextParent);
                Seq leftSubtrees = this.getSubtrees$1((ProverNodes)internalProverNode.left(), currentHeight - 1, nextParent, subtreeDepth$1);
                Seq rightSubtrees = this.getSubtrees$1((ProverNodes)internalProverNode.right(), currentHeight - 1, nextParent, subtreeDepth$1);
                return leftSubtrees.$plus$plus(rightSubtrees, Seq$.MODULE$.canBuildFrom());
            }
        }
        if (bl) {
            parent.mutate(ProxyInternalNode$.MODULE$.apply(internalProverNode, this.hf()));
            return new $colon$colon<Nothing$>((Nothing$)((Object)new BatchAVLProverSubtree(internalProverNode.left())), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)new BatchAVLProverSubtree(internalProverNode.right())), Nil$.MODULE$));
        }
        if (!(proverNodes instanceof ProverLeaf)) throw new MatchError(proverNodes);
        ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
        parent.mutate(proverLeaf);
        return new $colon$colon<Nothing$>((Nothing$)((Object)new BatchAVLProverSubtree(proverLeaf)), Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$combine$2(ProxyInternalNode x2$1, BatchAVLProverSubtree x$1) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])x$1.subtreeTop().label())).sameElements(Predef$.MODULE$.wrapByteArray((byte[])x2$1.leftLabel()));
    }

    public static final /* synthetic */ boolean $anonfun$combine$3(ProxyInternalNode x2$1, BatchAVLProverSubtree x$2) {
        return new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])x$2.subtreeTop().label())).sameElements(Predef$.MODULE$.wrapByteArray((byte[])x2$1.rightLabel()));
    }

    private final void mutateLoop$1(ProverNodes n, Tuple2 sliced$1) {
        block2: {
            while (true) {
                ProxyInternalNode proxyInternalNode;
                ProverNodes proverNodes;
                if ((proverNodes = n) instanceof ProxyInternalNode && (proxyInternalNode = (ProxyInternalNode)proverNodes).isEmpty()) {
                    ProverNodes left = ((BatchAVLProverSubtree)((IterableLike)sliced$1._2()).find((Function1<BatchAVLProverSubtree, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(BatchAVLProverSerializer.$anonfun$combine$2(proxyInternalNode, x$1))).get()).subtreeTop();
                    ProverNodes right = ((BatchAVLProverSubtree)((IterableLike)sliced$1._2()).find((Function1<BatchAVLProverSubtree, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(BatchAVLProverSerializer.$anonfun$combine$3(proxyInternalNode, x$2))).get()).subtreeTop();
                    proxyInternalNode.mutate(left);
                    proxyInternalNode.mutate(right);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                if (!(proverNodes instanceof InternalProverNode)) break;
                InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
                this.mutateLoop$1((ProverNodes)internalProverNode.left(), sliced$1);
                n = internalProverNode.right();
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final byte[] loop$1(ProverNodes currentNode) {
        ProxyInternalNode proxyInternalNode;
        byte[] byArray;
        ProverNodes proverNodes = currentNode;
        if (proverNodes instanceof ProverLeaf) {
            ProverLeaf proverLeaf = (ProverLeaf)proverNodes;
            byArray = Bytes.concat({(byte)0}, proverLeaf.key(), proverLeaf.nextLeafKey(), proverLeaf.value());
        } else if (proverNodes instanceof ProxyInternalNode && (proxyInternalNode = (ProxyInternalNode)proverNodes).isEmpty()) {
            byArray = Bytes.concat({(byte)2, proxyInternalNode.balance()}, proxyInternalNode.key(), (byte[])proxyInternalNode.leftLabel(), (byte[])proxyInternalNode.rightLabel(), (byte[])proxyInternalNode.label());
        } else if (proverNodes instanceof InternalProverNode) {
            InternalProverNode internalProverNode = (InternalProverNode)proverNodes;
            byte[] leftBytes = BatchAVLProverSerializer.loop$1((ProverNodes)internalProverNode.left());
            byte[] rightBytes = BatchAVLProverSerializer.loop$1((ProverNodes)internalProverNode.right());
            byArray = Bytes.concat({(byte)1, internalProverNode.balance()}, internalProverNode.key(), Ints.toByteArray(leftBytes.length), leftBytes, rightBytes);
        } else {
            throw new MatchError(proverNodes);
        }
        return byArray;
    }

    private final ProverNodes loop$2(byte[] bytes, int keyLength$1) {
        ProverNodes<Object> proverNodes;
        byte by = BoxesRunTime.unboxToByte(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).head());
        switch (by) {
            case 0: {
                byte[] key = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(1, keyLength$1 + 1), package$Tagger$.MODULE$.baseRaw());
                byte[] nextLeafKey = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$1 + 1, 2 * keyLength$1 + 1), package$Tagger$.MODULE$.baseRaw());
                byte[] value = (byte[])package$ADValue$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(2 * keyLength$1 + 1, bytes.length), package$Tagger$.MODULE$.baseRaw());
                proverNodes = new ProverLeaf(key, value, nextLeafKey, this.hf());
                break;
            }
            case 1: {
                byte balance = BoxesRunTime.unboxToByte(package$Balance$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(1, 2))).head(), package$Tagger$.MODULE$.baseRaw()));
                byte[] key = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(2, keyLength$1 + 2), package$Tagger$.MODULE$.baseRaw());
                int leftLength = Ints.fromByteArray((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$1 + 2, keyLength$1 + 6));
                byte[] leftBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$1 + 6, keyLength$1 + 6 + leftLength);
                byte[] rightBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$1 + 6 + leftLength, bytes.length);
                ProverNodes left = this.loop$2(leftBytes, keyLength$1);
                ProverNodes right = this.loop$2(rightBytes, keyLength$1);
                proverNodes = new InternalProverNode(key, left, right, balance, this.hf());
                break;
            }
            case 2: {
                byte balance = BoxesRunTime.unboxToByte(package$Balance$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(1, 2))).head(), package$Tagger$.MODULE$.baseRaw()));
                byte[] key = (byte[])package$ADKey$.MODULE$.$at$at(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(2, keyLength$1 + 2), package$Tagger$.MODULE$.baseRaw());
                byte[] leftLabel = (byte[])this.hf().byteArrayToDigest((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$1 + 2, keyLength$1 + 2 + this.labelLength())).get();
                byte[] rightLabel = (byte[])this.hf().byteArrayToDigest((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$1 + 2 + this.labelLength(), keyLength$1 + 2 + 2 * this.labelLength())).get();
                byte[] selfLabel = (byte[])this.hf().byteArrayToDigest((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(keyLength$1 + 2 + 2 * this.labelLength(), keyLength$1 + 2 + 3 * this.labelLength())).get();
                proverNodes = new ProxyInternalNode<byte[]>(key, (Option<byte[]>)new Some<byte[]>(selfLabel), leftLabel, rightLabel, balance, (CryptographicHash<byte[]>)this.hf());
                break;
            }
            default: {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        }
        return proverNodes;
    }

    public BatchAVLProverSerializer(HF hf) {
        this.hf = hf;
        this.labelLength = hf.DigestSize();
    }
}

