/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.math.BigInteger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.ScalaNumber;
import scala.math.ScalaNumericAnyConversions;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import spire.math.DecimalNumber;
import spire.math.FloatNumber;
import spire.math.IntNumber$;
import spire.math.Number;
import spire.math.Number$;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.SafeLong;
import spire.math.SafeLongBigInteger;
import spire.math.SafeLongLong;
import spire.math.package$;
import spire.std.package$bigDecimal$;

@ScalaSignature(bytes="\u0006\u0001\t-c!B\u0001\u0003\u0001\n1!!C%oi:+XNY3s\u0015\t\u0019A!\u0001\u0003nCRD'\"A\u0003\u0002\u000bM\u0004\u0018N]3\u0014\u000b\u00019aB\u0005\f\u0011\u0005!aQ\"A\u0005\u000b\u0005\rQ!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055I!aC*dC2\fg*^7cKJ\u0004\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\r9+XNY3s!\t\u0019B#D\u0001\u000b\u0013\t)\"BA\u0004Qe>$Wo\u0019;\u0011\u0005M9\u0012B\u0001\r\u000b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!Q\u0002A!f\u0001\n\u0003a\u0012!\u00018\u0004\u0001U\tQ\u0004\u0005\u0002\u0010=%\u0011qD\u0001\u0002\t'\u00064W\rT8oO\"A\u0011\u0005\u0001B\tB\u0003%Q$\u0001\u0002oA!)1\u0005\u0001C\u0001I\u00051A(\u001b8jiz\"\"!\n\u0014\u0011\u0005=\u0001\u0001\"\u0002\u000e#\u0001\u0004i\u0002\"\u0002\u0015\u0001\t\u0003J\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003)\u0002\"a\u000b\u001a\u000f\u00051\u0002\u0004CA\u0017\u000b\u001b\u0005q#BA\u0018\u001c\u0003\u0019a$o\\8u}%\u0011\u0011GC\u0001\u0007!J,G-\u001a4\n\u0005M\"$AB*ue&twM\u0003\u00022\u0015!)a\u0007\u0001C\u0001o\u0005\u0019\u0011MY:\u0016\u0003\u0015BQ!\u000f\u0001\u0005\u0002i\naa]5h]VlW#A\u001e\u0011\u0005Ma\u0014BA\u001f\u000b\u0005\rIe\u000e\u001e\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\no&$\b.\u001b8J]R,\u0012!\u0011\t\u0003'\tK!a\u0011\u0006\u0003\u000f\t{w\u000e\\3b]\")Q\t\u0001C\u0001\u0001\u0006Qq/\u001b;iS:duN\\4\t\u000b\u001d\u0003A\u0011\u0001!\u0002\u0019]LG\u000f[5o\t>,(\r\\3\t\u000b%\u0003A\u0011\u0001!\u0002\u0011\r\fgNQ3J]RDQa\u0013\u0001\u0005\u0002\u0001\u000b\u0011bY1o\u0005\u0016duN\\4\t\u000b5\u0003A\u0011\u0001!\u0002\u000f%\u001cX\t_1di\")q\n\u0001C\u0001!\u0006AAo\u001c\"jO&sG/F\u0001R!\t\u0011vK\u0004\u0002T+:\u0011Q\u0006V\u0005\u0002\u0017%\u0011aKC\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0016L\u0001\u0004CS\u001eLe\u000e\u001e\u0006\u0003-*AQa\u0017\u0001\u0005\u0002q\u000bA\u0002^8CS\u001e$UmY5nC2,\u0012!\u0018\t\u0003%zK!aX-\u0003\u0015\tKw\rR3dS6\fG\u000eC\u0003b\u0001\u0011\u0005!-\u0001\u0006u_J\u000bG/[8oC2,\u0012a\u0019\t\u0003\u001f\u0011L!!\u001a\u0002\u0003\u0011I\u000bG/[8oC2DQa\u001a\u0001\u0005\u0002!\f!\"\u001e8eKJd\u00170\u001b8h)\u0005I\u0007C\u00016p\u001b\u0005Y'B\u00017n\u0003\u0011a\u0017M\\4\u000b\u00039\fAA[1wC&\u0011\u0001o\u001b\u0002\u0007\u001f\nTWm\u0019;\t\u000bI\u0004A\u0011A:\u0002\u000f%\u001cx\u000b[8mKR\t\u0011\tC\u0003v\u0001\u0011\u0005a/A\u0006e_V\u0014G.\u001a,bYV,G#A<\u0011\u0005MA\u0018BA=\u000b\u0005\u0019!u.\u001e2mK\")1\u0010\u0001C\u0001y\u0006Qa\r\\8biZ\u000bG.^3\u0015\u0003u\u0004\"a\u0005@\n\u0005}T!!\u0002$m_\u0006$\bbBA\u0002\u0001\u0011\u0005\u0011QA\u0001\nY>twMV1mk\u0016$\"!a\u0002\u0011\u0007M\tI!C\u0002\u0002\f)\u0011A\u0001T8oO\"9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0011\u0001C5oiZ\u000bG.^3\u0015\u0003mBq!!\u0006\u0001\t\u0003\t9\"A\u0004d_6\u0004\u0018M]3\u0015\u0007m\nI\u0002C\u0004\u0002\u001c\u0005M\u0001\u0019\u0001\b\u0002\u0007ID7\u000fC\u0004\u0002 \u0001!\t%!\t\u0002\r\u0015\fX/\u00197t)\r\t\u00151\u0005\u0005\t\u0003K\ti\u00021\u0001\u0002(\u0005!A\u000f[1u!\r\u0019\u0012\u0011F\u0005\u0004\u0003WQ!aA!os\"9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0012!\u0003\u0013fc\u0012*\u0017\u000fJ3r)\r\t\u00151\u0007\u0005\b\u0003K\ti\u00031\u0001\u000f\u0011\u001d\t9\u0004\u0001C\u0001\u0003s\tA\"\u001e8bef|F%\\5okN$\u0012A\u0004\u0005\b\u0003{\u0001A\u0011AA \u0003\u0015!\u0003\u000f\\;t)\rq\u0011\u0011\t\u0005\b\u00037\tY\u00041\u0001\u000f\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\na\u0001\n;j[\u0016\u001cHc\u0001\b\u0002J!9\u00111DA\"\u0001\u0004q\u0001bBA'\u0001\u0011\u0005\u0011qJ\u0001\u0007I5Lg.^:\u0015\u00079\t\t\u0006C\u0004\u0002\u001c\u0005-\u0003\u0019\u0001\b\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X\u0005!A\u0005Z5w)\rq\u0011\u0011\f\u0005\b\u00037\t\u0019\u00061\u0001\u000f\u0011!\ti\u0006\u0001C\u0001\u0005\u0005}\u0013\u0001\u0003:`I5Lg.^:\u0015\u00079\t\t\u0007C\u0004\u0002d\u0005m\u0003\u0019\u0001\b\u0002\u00071D7\u000f\u0003\u0005\u0002h\u0001!\tAAA5\u0003\u0019\u0011x\f\n3jmR\u0019a\"a\u001b\t\u000f\u0005\r\u0014Q\ra\u0001\u001d!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0014a\u00019poR\u0019a\"a\u001d\t\u000f\u0005m\u0011Q\u000ea\u0001\u001d!9\u0011q\u000f\u0001\u0005B\u0005e\u0014\u0001\u0002\u0013b[B$2ADA>\u0011\u001d\tY\"!\u001eA\u00029Aq!a \u0001\t\u0003\n\t)\u0001\u0003%E\u0006\u0014Hc\u0001\b\u0002\u0004\"9\u00111DA?\u0001\u0004q\u0001bBAD\u0001\u0011\u0005\u0013\u0011R\u0001\u0004IU\u0004Hc\u0001\b\u0002\f\"9\u00111DAC\u0001\u0004q\u0001bBAH\u0001\u0011\u0005\u0013\u0011S\u0001\u000bI1,7o\u001d\u0013mKN\u001cHc\u0001\b\u0002\u0014\"9\u00111DAG\u0001\u0004q\u0001bBAL\u0001\u0011\u0005\u0013\u0011T\u0001\u0011I\u001d\u0014X-\u0019;fe\u0012:'/Z1uKJ$2ADAN\u0011\u001d\tY\"!&A\u00029Aq!a(\u0001\t\u0003\t\t+\u0001\u0003tcJ$X#\u0001\b\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\u0006)aN]8piR\u0019a\"!+\t\u000f\u0005-\u00161\u0015a\u0001w\u0005\t1\u000eC\u0004\u00020\u0002!\t!!)\u0002\u000b\u0019dwn\u001c:\t\u000f\u0005M\u0006\u0001\"\u0001\u0002\"\u0006!1-Z5m\u0011\u001d\t9\f\u0001C\u0001\u0003C\u000bQA]8v]\u0012D\u0011\"a/\u0001\u0003\u0003%\t!!0\u0002\t\r|\u0007/\u001f\u000b\u0004K\u0005}\u0006\u0002\u0003\u000e\u0002:B\u0005\t\u0019A\u000f\t\u0013\u0005\r\u0007!%A\u0005\u0002\u0005\u0015\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000fT3!HAeW\t\tY\r\u0005\u0003\u0002N\u0006]WBAAh\u0015\u0011\t\t.a5\u0002\u0013Ut7\r[3dW\u0016$'bAAk\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0017q\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAo\u0001\u0005\u0005I\u0011IAp\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u001d\t\u0004U\u0006\r\u0018BA\u001al\u0011!\t9\u000fAA\u0001\n\u0003Q\u0014\u0001\u00049s_\u0012,8\r^!sSRL\b\"CAv\u0001\u0005\u0005I\u0011AAw\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\n\u0002p\"I\u0011\u0011_Au\u0003\u0003\u0005\raO\u0001\u0004q\u0012\n\u0004\"CA{\u0001\u0005\u0005I\u0011IA|\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA}!\u0019\tYP!\u0001\u0002(5\u0011\u0011Q \u0006\u0004\u0003\u007fT\u0011AC2pY2,7\r^5p]&!!1AA\u007f\u0005!IE/\u001a:bi>\u0014\b\"\u0003B\u0004\u0001\u0005\u0005I\u0011\u0001B\u0005\u0003!\u0019\u0017M\\#rk\u0006dGcA!\u0003\f!Q\u0011\u0011\u001fB\u0003\u0003\u0003\u0005\r!a\n\t\u0013\t=\u0001!!A\u0005B\u0005E\u0011\u0001\u00035bg\"\u001cu\u000eZ3\b\u0015\tM!!!A\t\u0002\t\u0011)\"A\u0005J]RtU/\u001c2feB\u0019qBa\u0006\u0007\u0013\u0005\u0011\u0011\u0011!E\u0001\u0005\te1#\u0002B\f\u000571\u0002C\u0002B\u000f\u0005GiR%\u0004\u0002\u0003 )\u0019!\u0011\u0005\u0006\u0002\u000fI,h\u000e^5nK&!!Q\u0005B\u0010\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u0005\bG\t]A\u0011\u0001B\u0015)\t\u0011)\u0002C\u0005)\u0005/\t\t\u0011\"\u0012\u0003.Q\u0011\u0011\u0011\u001d\u0005\u000b\u0005c\u00119\"!A\u0005\u0002\nM\u0012!B1qa2LHcA\u0013\u00036!1!Da\fA\u0002uA!B!\u000f\u0003\u0018\u0005\u0005I\u0011\u0011B\u001e\u0003\u001d)h.\u00199qYf$BA!\u0010\u0003DA!1Ca\u0010\u001e\u0013\r\u0011\tE\u0003\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\t\u0015#qGA\u0001\u0002\u0004)\u0013a\u0001=%a!I!\u0011\nB\f\u0003\u0003%I\u0001[\u0001\fe\u0016\fGMU3t_24X\r")
public class IntNumber
extends ScalaNumber
implements Number,
Product {
    private final SafeLong n;

    public static Option<SafeLong> unapply(IntNumber intNumber) {
        return IntNumber$.MODULE$.unapply(intNumber);
    }

    public static IntNumber apply(SafeLong safeLong) {
        return IntNumber$.MODULE$.apply(safeLong);
    }

    public static <A> Function1<SafeLong, A> andThen(Function1<IntNumber, A> function1) {
        return IntNumber$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, IntNumber> compose(Function1<A, SafeLong> function1) {
        return IntNumber$.MODULE$.compose(function1);
    }

    @Override
    public final Number $times$times(Number rhs) {
        return Number.$times$times$(this, rhs);
    }

    @Override
    public boolean $eq$bang$eq(Number rhs) {
        return Number.$eq$bang$eq$(this, rhs);
    }

    @Override
    public Number min(Number rhs) {
        return Number.min$(this, rhs);
    }

    @Override
    public Number max(Number rhs) {
        return Number.max$(this, rhs);
    }

    @Override
    public final boolean $less(Number rhs) {
        return Number.$less$(this, rhs);
    }

    @Override
    public final boolean $less$eq(Number rhs) {
        return Number.$less$eq$(this, rhs);
    }

    @Override
    public final boolean $greater(Number rhs) {
        return Number.$greater$(this, rhs);
    }

    @Override
    public final boolean $greater$eq(Number rhs) {
        return Number.$greater$eq$(this, rhs);
    }

    @Override
    public char toChar() {
        return ScalaNumericAnyConversions.toChar$(this);
    }

    @Override
    public byte toByte() {
        return ScalaNumericAnyConversions.toByte$(this);
    }

    @Override
    public short toShort() {
        return ScalaNumericAnyConversions.toShort$(this);
    }

    @Override
    public int toInt() {
        return ScalaNumericAnyConversions.toInt$(this);
    }

    @Override
    public long toLong() {
        return ScalaNumericAnyConversions.toLong$(this);
    }

    @Override
    public float toFloat() {
        return ScalaNumericAnyConversions.toFloat$(this);
    }

    @Override
    public double toDouble() {
        return ScalaNumericAnyConversions.toDouble$(this);
    }

    @Override
    public boolean isValidByte() {
        return ScalaNumericAnyConversions.isValidByte$(this);
    }

    @Override
    public boolean isValidShort() {
        return ScalaNumericAnyConversions.isValidShort$(this);
    }

    @Override
    public boolean isValidInt() {
        return ScalaNumericAnyConversions.isValidInt$(this);
    }

    @Override
    public boolean isValidChar() {
        return ScalaNumericAnyConversions.isValidChar$(this);
    }

    @Override
    public int unifiedPrimitiveHashcode() {
        return ScalaNumericAnyConversions.unifiedPrimitiveHashcode$(this);
    }

    @Override
    public boolean unifiedPrimitiveEquals(Object x) {
        return ScalaNumericAnyConversions.unifiedPrimitiveEquals$(this, x);
    }

    public SafeLong n() {
        return this.n;
    }

    public String toString() {
        return this.n().toString();
    }

    @Override
    public IntNumber abs() {
        return new IntNumber(this.n().abs());
    }

    @Override
    public int signum() {
        return this.n().signum();
    }

    @Override
    public boolean withinInt() {
        return Number$.MODULE$.minInt().$less$eq(this.n()) && this.n().$less$eq(Number$.MODULE$.maxInt());
    }

    @Override
    public boolean withinLong() {
        return Number$.MODULE$.minLong().$less$eq(this.n()) && this.n().$less$eq(Number$.MODULE$.maxLong());
    }

    @Override
    public boolean withinDouble() {
        BigDecimal d = this.n().toBigDecimal();
        return Number$.MODULE$.minDouble().$less$eq(d) && d.$less$eq(Number$.MODULE$.maxDouble());
    }

    @Override
    public boolean canBeInt() {
        return this.isWhole() && this.withinInt();
    }

    @Override
    public boolean canBeLong() {
        return this.isWhole() && this.withinLong();
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public BigInt toBigInt() {
        return this.n().toBigInt();
    }

    @Override
    public BigDecimal toBigDecimal() {
        return this.n().toBigDecimal();
    }

    @Override
    public Rational toRational() {
        return Rational$.MODULE$.apply(this.n());
    }

    @Override
    public Object underlying() {
        return this.n().underlying();
    }

    @Override
    public boolean isWhole() {
        return true;
    }

    @Override
    public double doubleValue() {
        return this.n().doubleValue();
    }

    @Override
    public float floatValue() {
        return this.n().floatValue();
    }

    @Override
    public long longValue() {
        return this.n().longValue();
    }

    @Override
    public int intValue() {
        return this.n().intValue();
    }

    @Override
    public int compare(Number rhs) {
        int n;
        Number number = rhs;
        if (number instanceof IntNumber) {
            IntNumber intNumber = (IntNumber)number;
            SafeLong m = intNumber.n();
            n = this.n().compare(m);
        } else {
            n = -number.compare(this);
        }
        return n;
    }

    @Override
    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof Number) {
            Number number = (Number)object;
            bl = this.$eq$eq$eq(number);
        } else {
            bl = BoxesRunTime.equalsNumObject(this.n(), object);
        }
        return bl;
    }

    @Override
    public boolean $eq$eq$eq(Number that) {
        boolean bl;
        Number number = that;
        if (number instanceof IntNumber) {
            IntNumber intNumber = (IntNumber)number;
            SafeLong n2 = intNumber.n();
            bl = BoxesRunTime.equalsNumNum(this.n(), n2);
        } else {
            bl = number.$eq$eq$eq(this);
        }
        return bl;
    }

    @Override
    public Number unary_$minus() {
        return Number$.MODULE$.apply(this.n().unary_$minus());
    }

    @Override
    public Number $plus(Number rhs) {
        Number number;
        Number number2 = rhs;
        if (number2 instanceof IntNumber) {
            IntNumber intNumber = (IntNumber)number2;
            SafeLong m = intNumber.n();
            number = new IntNumber(this.n().$plus(m));
        } else {
            number = number2.$plus(this);
        }
        return number;
    }

    @Override
    public Number $times(Number rhs) {
        Number number;
        Number number2 = rhs;
        if (number2 instanceof IntNumber) {
            IntNumber intNumber = (IntNumber)number2;
            SafeLong m = intNumber.n();
            number = new IntNumber(this.n().$times(m));
        } else {
            number = number2.$times(this);
        }
        return number;
    }

    @Override
    public Number $minus(Number rhs) {
        Number number;
        Number number2 = rhs;
        if (number2 instanceof IntNumber) {
            IntNumber intNumber = (IntNumber)number2;
            SafeLong m = intNumber.n();
            number = new IntNumber(this.n().$minus(m));
        } else {
            number = number2.r_$minus(this);
        }
        return number;
    }

    @Override
    public Number $div(Number rhs) {
        Number number;
        Number number2 = rhs;
        if (number2 instanceof IntNumber) {
            Number number3;
            IntNumber intNumber = (IntNumber)number2;
            SafeLong m = intNumber.n();
            SafeLong safeLong = this.n();
            if (safeLong instanceof SafeLongLong) {
                Number number4;
                SafeLongLong safeLongLong = (SafeLongLong)safeLong;
                long x = safeLongLong.x();
                SafeLong safeLong2 = m;
                if (safeLong2 instanceof SafeLongLong) {
                    SafeLongLong safeLongLong2 = (SafeLongLong)safeLong2;
                    long y = safeLongLong2.x();
                    number4 = Number$.MODULE$.apply((double)x / (double)y);
                } else if (safeLong2 instanceof SafeLongBigInteger) {
                    SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong2;
                    BigInteger y = safeLongBigInteger.x();
                    number4 = new DecimalNumber(scala.package$.MODULE$.BigDecimal().apply(x).$div(scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(y))));
                } else {
                    throw new MatchError(safeLong2);
                }
                number3 = number4;
            } else if (safeLong instanceof SafeLongBigInteger) {
                SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong;
                BigInteger x = safeLongBigInteger.x();
                number3 = Number$.MODULE$.apply(scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(x)).$div(m.toBigDecimal()));
            } else {
                throw new MatchError(safeLong);
            }
            number = number3;
        } else {
            number = number2.r_$div(this);
        }
        return number;
    }

    @Override
    public Number r_$minus(Number lhs) {
        Number number;
        Number number2 = lhs;
        if (number2 instanceof IntNumber) {
            IntNumber intNumber = (IntNumber)number2;
            SafeLong m = intNumber.n();
            number = new IntNumber(m.$minus(this.n()));
        } else {
            number = number2.$minus(lhs);
        }
        return number;
    }

    @Override
    public Number r_$div(Number lhs) {
        Number number;
        Number number2 = lhs;
        if (number2 instanceof IntNumber) {
            Number number3;
            IntNumber intNumber = (IntNumber)number2;
            SafeLong m = intNumber.n();
            SafeLong safeLong = this.n();
            if (safeLong instanceof SafeLongLong) {
                Number number4;
                SafeLongLong safeLongLong = (SafeLongLong)safeLong;
                long x = safeLongLong.x();
                SafeLong safeLong2 = m;
                if (safeLong2 instanceof SafeLongLong) {
                    SafeLongLong safeLongLong2 = (SafeLongLong)safeLong2;
                    long y = safeLongLong2.x();
                    number4 = Number$.MODULE$.apply((double)y / (double)x);
                } else if (safeLong2 instanceof SafeLongBigInteger) {
                    SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong2;
                    BigInteger y = safeLongBigInteger.x();
                    number4 = new DecimalNumber(scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(y)).$div(scala.package$.MODULE$.BigDecimal().apply(x)));
                } else {
                    throw new MatchError(safeLong2);
                }
                number3 = number4;
            } else if (safeLong instanceof SafeLongBigInteger) {
                SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong;
                BigInteger x = safeLongBigInteger.x();
                number3 = Number$.MODULE$.apply(m.toBigDecimal().$div(scala.package$.MODULE$.BigDecimal().apply(BigInt$.MODULE$.javaBigInteger2bigInt(x))));
            } else {
                throw new MatchError(safeLong);
            }
            number = number3;
        } else {
            number = number2.$div(lhs);
        }
        return number;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Number pow(Number rhs) {
        Number number = rhs;
        if (rhs.canBeInt()) {
            return Number$.MODULE$.apply(this.n().pow(rhs.intValue()));
        }
        if (!(number instanceof FloatNumber)) return Number$.MODULE$.apply(package$.MODULE$.pow(this.toBigDecimal(), rhs.toBigDecimal()));
        FloatNumber floatNumber = (FloatNumber)number;
        double m = floatNumber.n();
        if (!this.withinDouble()) return Number$.MODULE$.apply(package$.MODULE$.pow(this.toBigDecimal(), rhs.toBigDecimal()));
        return Number$.MODULE$.apply(package$.MODULE$.pow(this.doubleValue(), m));
    }

    @Override
    public Number $amp(Number rhs) {
        Number number = rhs;
        if (!(number instanceof IntNumber)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("%s not an integer")).format(Predef$.MODULE$.genericWrapArray(new Object[]{rhs})));
        }
        IntNumber intNumber = (IntNumber)number;
        SafeLong x = intNumber.n();
        IntNumber intNumber2 = new IntNumber(this.n().$amp(x));
        return intNumber2;
    }

    @Override
    public Number $bar(Number rhs) {
        Number number = rhs;
        if (!(number instanceof IntNumber)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("%s not an integer")).format(Predef$.MODULE$.genericWrapArray(new Object[]{rhs})));
        }
        IntNumber intNumber = (IntNumber)number;
        SafeLong x = intNumber.n();
        IntNumber intNumber2 = new IntNumber(this.n().$bar(x));
        return intNumber2;
    }

    @Override
    public Number $up(Number rhs) {
        Number number = rhs;
        if (!(number instanceof IntNumber)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("%s not an integer")).format(Predef$.MODULE$.genericWrapArray(new Object[]{rhs})));
        }
        IntNumber intNumber = (IntNumber)number;
        SafeLong x = intNumber.n();
        IntNumber intNumber2 = new IntNumber(this.n().$up(x));
        return intNumber2;
    }

    @Override
    public Number $less$less(Number rhs) {
        Number number = rhs;
        if (!(number instanceof IntNumber)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("%s not an integer")).format(Predef$.MODULE$.genericWrapArray(new Object[]{rhs})));
        }
        IntNumber intNumber = (IntNumber)number;
        SafeLong x = intNumber.n();
        IntNumber intNumber2 = new IntNumber(this.n().$less$less(x.toInt()));
        return intNumber2;
    }

    @Override
    public Number $greater$greater(Number rhs) {
        Number number = rhs;
        if (!(number instanceof IntNumber)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("%s not an integer")).format(Predef$.MODULE$.genericWrapArray(new Object[]{rhs})));
        }
        IntNumber intNumber = (IntNumber)number;
        SafeLong x = intNumber.n();
        IntNumber intNumber2 = new IntNumber(this.n().$greater$greater(x.toInt()));
        return intNumber2;
    }

    public Number sqrt() {
        return this.withinDouble() ? Number$.MODULE$.apply(Math.sqrt(this.n().toDouble())) : Number$.MODULE$.apply(package$bigDecimal$.MODULE$.BigDecimalAlgebra().sqrt(this.n().toBigDecimal()));
    }

    public Number nroot(int k) {
        return this.withinDouble() ? Number$.MODULE$.apply(Math.pow(this.n().toDouble(), 1.0 / (double)k)) : Number$.MODULE$.apply(package$bigDecimal$.MODULE$.BigDecimalAlgebra().nroot(this.n().toBigDecimal(), k));
    }

    @Override
    public Number floor() {
        return this;
    }

    @Override
    public Number ceil() {
        return this;
    }

    @Override
    public Number round() {
        return this;
    }

    public IntNumber copy(SafeLong n) {
        return new IntNumber(n);
    }

    public SafeLong copy$default$1() {
        return this.n();
    }

    @Override
    public String productPrefix() {
        return "IntNumber";
    }

    @Override
    public int productArity() {
        return 1;
    }

    @Override
    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
        }
        return this.n();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof IntNumber;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    public IntNumber(SafeLong n) {
        this.n = n;
        ScalaNumericAnyConversions.$init$(this);
        Number.$init$(this);
        Product.$init$(this);
    }
}

