/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import spire.math.DecimalNumber;
import spire.math.FloatNumber;
import spire.math.IntNumber;
import spire.math.Number;
import spire.math.NumberTag;
import spire.math.Rational;
import spire.math.RationalAlgebra;
import spire.math.RationalInstances;
import spire.math.RationalNumber;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.SafeLongBigInteger;
import spire.math.SafeLongLong;
import spire.math.package$;

public final class Rational$
implements RationalInstances,
Serializable {
    public static Rational$ MODULE$;
    private final Regex RationalString;
    private final Regex IntegerString;
    private final Rational zero;
    private final Rational one;
    private final RationalAlgebra RationalAlgebra;
    private final NumberTag.LargeTag<Rational> RationalTag;

    static {
        new Rational$();
    }

    @Override
    public final RationalAlgebra RationalAlgebra() {
        return this.RationalAlgebra;
    }

    @Override
    public final NumberTag.LargeTag<Rational> RationalTag() {
        return this.RationalTag;
    }

    @Override
    public final void spire$math$RationalInstances$_setter_$RationalAlgebra_$eq(RationalAlgebra x$1) {
        this.RationalAlgebra = x$1;
    }

    @Override
    public final void spire$math$RationalInstances$_setter_$RationalTag_$eq(NumberTag.LargeTag<Rational> x$1) {
        this.RationalTag = x$1;
    }

    private Regex RationalString() {
        return this.RationalString;
    }

    private Regex IntegerString() {
        return this.IntegerString;
    }

    public Rational zero() {
        return this.zero;
    }

    public Rational one() {
        return this.one;
    }

    public double toDouble(SafeLong n, SafeLong d) {
        double d2;
        int n2 = n.signum();
        switch (n2) {
            case 0: {
                d2 = 0.0;
                break;
            }
            case -1: {
                d2 = -this.toDouble(n.unary_$minus(), d);
                break;
            }
            case 1: {
                int sharedLength = Math.min(n.bitLength(), d.bitLength());
                int dLowerLength = d.bitLength() - sharedLength;
                SafeLong nShared = n.$greater$greater(n.bitLength() - sharedLength);
                SafeLong dShared = d.$greater$greater(dLowerLength);
                int addBit = nShared.$less(dShared) || BoxesRunTime.equalsNumNum(nShared, dShared) && d.toBigInteger().getLowestSetBit() < dLowerLength ? 1 : 0;
                int e = d.bitLength() - n.bitLength() + addBit;
                SafeLong ln = n.$less$less(53 + e);
                long lm = ln.$div(d).toLong();
                long m = (lm >> 1) + (lm & 1L) & 0xFFFFFFFFFFFFFL;
                long bits = m | 1023L - (long)e << 52;
                d2 = Double.longBitsToDouble(bits);
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n2));
            }
        }
        return d2;
    }

    public Rational apply(BigInt n, BigInt d) {
        return this.apply(SafeLong$.MODULE$.apply(n), SafeLong$.MODULE$.apply(d));
    }

    public Rational apply(long n, long d) {
        if (d == 0L) {
            throw new IllegalArgumentException("0 denominator");
        }
        return d > 0L ? this.build0$1(n, d) : (n == Long.MIN_VALUE || d == Long.MIN_VALUE ? this.apply(scala.package$.MODULE$.BigInt().apply(n).unary_$minus(), scala.package$.MODULE$.BigInt().apply(d).unary_$minus()) : this.build0$1(-n, -d));
    }

    public Rational buildWithDiv(long num, long ngcd, long rd, long lden) {
        long n = num / ngcd;
        long d = rd / ngcd;
        long z$macro$432 = lden * d;
        if (lden != 0L && (d != z$macro$432 / lden || lden == -1L && d == Long.MIN_VALUE)) {
            return Rational$.checked$fallback$macro$431$1(lden, n, d);
        }
        return this.apply(n, z$macro$432);
    }

    public Rational apply(SafeLong n, SafeLong d) {
        Rational rational;
        block11: {
            Rational rational2;
            while (true) {
                if (d.isZero()) {
                    throw new IllegalArgumentException("0 denominator");
                }
                if (n.isValidLong() && d.isValidLong()) {
                    rational = this.apply(n.toLong(), d.toLong());
                    break block11;
                }
                if (d.signum() >= 0) break;
                d = d.unary_$minus();
                n = n.unary_$minus();
            }
            SafeLong g = n.gcd(d);
            SafeLong safeLong = n.$div(g);
            if (safeLong instanceof SafeLongLong) {
                Rational rational3;
                SafeLongLong safeLongLong = (SafeLongLong)safeLong;
                long x = safeLongLong.x();
                SafeLong safeLong2 = d.$div(g);
                if (safeLong2 instanceof SafeLongLong) {
                    SafeLongLong safeLongLong2 = (SafeLongLong)safeLong2;
                    long y = safeLongLong2.x();
                    rational3 = this.spire$math$Rational$$longRational(x, y);
                } else if (safeLong2 instanceof SafeLongBigInteger) {
                    SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong2;
                    rational3 = this.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(x), safeLongBigInteger);
                } else {
                    throw new MatchError(safeLong2);
                }
                rational2 = rational3;
            } else if (safeLong instanceof SafeLongBigInteger) {
                SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong;
                rational2 = this.spire$math$Rational$$bigRational(safeLongBigInteger, d.$div(g));
            } else {
                throw new MatchError(safeLong);
            }
            rational = rational2;
        }
        return rational;
    }

    public Rational apply(int x) {
        return x == 0 ? this.zero() : this.spire$math$Rational$$longRational(x, 1L);
    }

    public Rational apply(long x) {
        return x == 0L ? this.zero() : this.spire$math$Rational$$longRational(x, 1L);
    }

    public Rational apply(BigInt x) {
        return this.apply(SafeLong$.MODULE$.apply(x), SafeLong$.MODULE$.one());
    }

    public Rational apply(float x) {
        return this.apply((double)x);
    }

    public Rational apply(double x) {
        Rational rational;
        if (x == 0.0) {
            rational = this.zero();
        } else {
            long bits = Double.doubleToLongBits(x);
            long value = bits >> 63 < 0L ? -(bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L) : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            int exp = (int)(bits >> 52 & 0x7FFL) - 1075;
            rational = exp > 10 ? this.apply(SafeLong$.MODULE$.apply(value).$less$less(exp), SafeLong$.MODULE$.one()) : (exp >= 0 ? this.apply(value << exp, 1L) : (exp >= -52 && ((-1L << -exp ^ 0xFFFFFFFFFFFFFFFFL) & value) == 0L ? this.apply(value >> -exp, 1L) : this.apply(SafeLong$.MODULE$.apply(value), SafeLong$.MODULE$.one().$less$less(-exp))));
        }
        return rational;
    }

    public Rational apply(BigDecimal x) {
        Rational rational;
        if (x.ulp().$greater$eq(BigDecimal$.MODULE$.int2bigDecimal(1))) {
            rational = this.apply(x.toBigInt(), BigInt$.MODULE$.int2bigInt(1));
        } else {
            BigInt n = x.$div(x.ulp()).toBigInt();
            BigInt d = scala.package$.MODULE$.BigDecimal().apply(1.0).$div(x.ulp()).toBigInt();
            rational = this.apply(n, d);
        }
        return rational;
    }

    public Rational apply(String r) {
        Rational rational;
        String string = r;
        Option<List<String>> option = this.RationalString().unapplySeq(string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String n = (String)((LinearSeqOptimized)option.get()).apply(0);
            String d = (String)((LinearSeqOptimized)option.get()).apply(1);
            rational = this.apply(SafeLong$.MODULE$.apply(n), SafeLong$.MODULE$.apply(d));
        } else {
            Option<List<String>> option2 = this.IntegerString().unapplySeq(string);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String n = (String)((LinearSeqOptimized)option2.get()).apply(0);
                rational = this.apply(SafeLong$.MODULE$.apply(n));
            } else {
                Rational rational2;
                try {
                    rational2 = this.apply(scala.package$.MODULE$.BigDecimal().apply(string));
                }
                catch (NumberFormatException nfe) {
                    throw new NumberFormatException("For input string: " + string);
                }
                rational = rational2;
            }
        }
        return rational;
    }

    public Rational apply(SafeLong n) {
        Rational rational;
        SafeLong safeLong = n;
        if (safeLong instanceof SafeLongLong) {
            SafeLongLong safeLongLong = (SafeLongLong)safeLong;
            long x = safeLongLong.x();
            rational = x == 0L ? this.zero() : this.spire$math$Rational$$longRational(x, 1L);
        } else if (safeLong instanceof SafeLongBigInteger) {
            SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong;
            rational = this.spire$math$Rational$$bigRational(safeLongBigInteger, SafeLong$.MODULE$.one());
        } else {
            throw new MatchError(safeLong);
        }
        return rational;
    }

    public Rational apply(Number x) {
        Rational rational;
        Number number = x;
        if (number instanceof RationalNumber) {
            Rational n;
            RationalNumber rationalNumber = (RationalNumber)number;
            rational = n = rationalNumber.n();
        } else if (number instanceof IntNumber) {
            IntNumber intNumber = (IntNumber)number;
            SafeLong n = intNumber.n();
            rational = this.apply(n);
        } else if (number instanceof FloatNumber) {
            FloatNumber floatNumber = (FloatNumber)number;
            double n = floatNumber.n();
            rational = this.apply(n);
        } else if (number instanceof DecimalNumber) {
            DecimalNumber decimalNumber = (DecimalNumber)number;
            BigDecimal n = decimalNumber.n();
            rational = this.apply(n);
        } else {
            throw new MatchError(number);
        }
        return rational;
    }

    public Rational.LongRational spire$math$Rational$$longRational(long n, long d) {
        return new Rational.LongRational(n, d);
    }

    public Rational.BigRational spire$math$Rational$$bigRational(SafeLong n, SafeLong d) {
        return new Rational.BigRational(n, d.isOne() ? SafeLong$.MODULE$.one() : d);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Rational build0$1(long n, long d) {
        long divisor;
        return n == 0L ? this.zero() : ((divisor = package$.MODULE$.gcd(n, d)) == 1L ? this.spire$math$Rational$$longRational(n, d) : this.spire$math$Rational$$longRational(n / divisor, d / divisor));
    }

    private static final Rational checked$fallback$macro$431$1(long lden$1, long n$1, long d$1) {
        return MODULE$.apply(SafeLong$.MODULE$.apply(n$1), SafeLong$.MODULE$.apply(lden$1).$times(d$1));
    }

    private Rational$() {
        MODULE$ = this;
        RationalInstances.$init$(this);
        this.RationalString = new StringOps(Predef$.MODULE$.augmentString("^(-?\\d+)/(-?\\d+)$")).r();
        this.IntegerString = new StringOps(Predef$.MODULE$.augmentString("^(-?\\d+)$")).r();
        this.zero = this.spire$math$Rational$$longRational(0L, 1L);
        this.one = this.spire$math$Rational$$longRational(1L, 1L);
    }
}

