import java.awt
import java.awt.geom
import java.io
import java.lang
import java.text
import java.util
import typing



class FontRenderContext:
    @typing.overload
    def __init__(self, affineTransform: java.awt.geom.AffineTransform, boolean: bool, boolean2: bool): ...
    @typing.overload
    def __init__(self, affineTransform: java.awt.geom.AffineTransform, object: typing.Any, object2: typing.Any): ...
    @typing.overload
    def equals(self, fontRenderContext: 'FontRenderContext') -> bool: ...
    @typing.overload
    def equals(self, object: typing.Any) -> bool: ...
    def getAntiAliasingHint(self) -> typing.Any: ...
    def getFractionalMetricsHint(self) -> typing.Any: ...
    def getTransform(self) -> java.awt.geom.AffineTransform: ...
    def getTransformType(self) -> int: ...
    def hashCode(self) -> int: ...
    def isAntiAliased(self) -> bool: ...
    def isTransformed(self) -> bool: ...
    def usesFractionalMetrics(self) -> bool: ...

class GlyphJustificationInfo:
    PRIORITY_KASHIDA: typing.ClassVar[int] = ...
    PRIORITY_WHITESPACE: typing.ClassVar[int] = ...
    PRIORITY_INTERCHAR: typing.ClassVar[int] = ...
    PRIORITY_NONE: typing.ClassVar[int] = ...
    weight: float = ...
    growPriority: int = ...
    growAbsorb: bool = ...
    growLeftLimit: float = ...
    growRightLimit: float = ...
    shrinkPriority: int = ...
    shrinkAbsorb: bool = ...
    shrinkLeftLimit: float = ...
    shrinkRightLimit: float = ...
    def __init__(self, float: float, boolean: bool, int: int, float2: float, float3: float, boolean2: bool, int2: int, float4: float, float5: float): ...

class GlyphMetrics:
    STANDARD: typing.ClassVar[int] = ...
    LIGATURE: typing.ClassVar[int] = ...
    COMBINING: typing.ClassVar[int] = ...
    COMPONENT: typing.ClassVar[int] = ...
    WHITESPACE: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, boolean: bool, float: float, float2: float, rectangle2D: java.awt.geom.Rectangle2D, byte: int): ...
    @typing.overload
    def __init__(self, float: float, rectangle2D: java.awt.geom.Rectangle2D, byte: int): ...
    def getAdvance(self) -> float: ...
    def getAdvanceX(self) -> float: ...
    def getAdvanceY(self) -> float: ...
    def getBounds2D(self) -> java.awt.geom.Rectangle2D: ...
    def getLSB(self) -> float: ...
    def getRSB(self) -> float: ...
    def getType(self) -> int: ...
    def isCombining(self) -> bool: ...
    def isComponent(self) -> bool: ...
    def isLigature(self) -> bool: ...
    def isStandard(self) -> bool: ...
    def isWhitespace(self) -> bool: ...

class GlyphVector(java.lang.Cloneable):
    FLAG_HAS_TRANSFORMS: typing.ClassVar[int] = ...
    FLAG_HAS_POSITION_ADJUSTMENTS: typing.ClassVar[int] = ...
    FLAG_RUN_RTL: typing.ClassVar[int] = ...
    FLAG_COMPLEX_GLYPHS: typing.ClassVar[int] = ...
    FLAG_MASK: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def equals(self, glyphVector: 'GlyphVector') -> bool: ...
    @typing.overload
    def equals(self, object: typing.Any) -> bool: ...
    def getFont(self) -> java.awt.Font: ...
    def getFontRenderContext(self) -> FontRenderContext: ...
    def getGlyphCharIndex(self, int: int) -> int: ...
    def getGlyphCharIndices(self, int: int, int2: int, intArray: typing.List[int]) -> typing.List[int]: ...
    def getGlyphCode(self, int: int) -> int: ...
    def getGlyphCodes(self, int: int, int2: int, intArray: typing.List[int]) -> typing.List[int]: ...
    def getGlyphJustificationInfo(self, int: int) -> GlyphJustificationInfo: ...
    def getGlyphLogicalBounds(self, int: int) -> java.awt.Shape: ...
    def getGlyphMetrics(self, int: int) -> GlyphMetrics: ...
    @typing.overload
    def getGlyphOutline(self, int: int) -> java.awt.Shape: ...
    @typing.overload
    def getGlyphOutline(self, int: int, float: float, float2: float) -> java.awt.Shape: ...
    def getGlyphPixelBounds(self, int: int, fontRenderContext: FontRenderContext, float: float, float2: float) -> java.awt.Rectangle: ...
    def getGlyphPosition(self, int: int) -> java.awt.geom.Point2D: ...
    def getGlyphPositions(self, int: int, int2: int, floatArray: typing.List[float]) -> typing.List[float]: ...
    def getGlyphTransform(self, int: int) -> java.awt.geom.AffineTransform: ...
    def getGlyphVisualBounds(self, int: int) -> java.awt.Shape: ...
    def getLayoutFlags(self) -> int: ...
    def getLogicalBounds(self) -> java.awt.geom.Rectangle2D: ...
    def getNumGlyphs(self) -> int: ...
    @typing.overload
    def getOutline(self) -> java.awt.Shape: ...
    @typing.overload
    def getOutline(self, float: float, float2: float) -> java.awt.Shape: ...
    def getPixelBounds(self, fontRenderContext: FontRenderContext, float: float, float2: float) -> java.awt.Rectangle: ...
    def getVisualBounds(self) -> java.awt.geom.Rectangle2D: ...
    def performDefaultLayout(self) -> None: ...
    def setGlyphPosition(self, int: int, point2D: java.awt.geom.Point2D) -> None: ...
    def setGlyphTransform(self, int: int, affineTransform: java.awt.geom.AffineTransform) -> None: ...

class GraphicAttribute:
    TOP_ALIGNMENT: typing.ClassVar[int] = ...
    BOTTOM_ALIGNMENT: typing.ClassVar[int] = ...
    ROMAN_BASELINE: typing.ClassVar[int] = ...
    CENTER_BASELINE: typing.ClassVar[int] = ...
    HANGING_BASELINE: typing.ClassVar[int] = ...
    def draw(self, graphics2D: java.awt.Graphics2D, float: float, float2: float) -> None: ...
    def getAdvance(self) -> float: ...
    def getAlignment(self) -> int: ...
    def getAscent(self) -> float: ...
    def getBounds(self) -> java.awt.geom.Rectangle2D: ...
    def getDescent(self) -> float: ...
    def getJustificationInfo(self) -> GlyphJustificationInfo: ...
    def getOutline(self, affineTransform: java.awt.geom.AffineTransform) -> java.awt.Shape: ...

class LayoutPath:
    def __init__(self): ...
    def pathToPoint(self, point2D: java.awt.geom.Point2D, boolean: bool, point2D2: java.awt.geom.Point2D) -> None: ...
    def pointToPath(self, point2D: java.awt.geom.Point2D, point2D2: java.awt.geom.Point2D) -> bool: ...

class LineBreakMeasurer:
    @typing.overload
    def __init__(self, attributedCharacterIterator: java.text.AttributedCharacterIterator, fontRenderContext: FontRenderContext): ...
    @typing.overload
    def __init__(self, attributedCharacterIterator: java.text.AttributedCharacterIterator, breakIterator: java.text.BreakIterator, fontRenderContext: FontRenderContext): ...
    def deleteChar(self, attributedCharacterIterator: java.text.AttributedCharacterIterator, int: int) -> None: ...
    def getPosition(self) -> int: ...
    def insertChar(self, attributedCharacterIterator: java.text.AttributedCharacterIterator, int: int) -> None: ...
    @typing.overload
    def nextLayout(self, float: float) -> 'TextLayout': ...
    @typing.overload
    def nextLayout(self, float: float, int: int, boolean: bool) -> 'TextLayout': ...
    @typing.overload
    def nextOffset(self, float: float) -> int: ...
    @typing.overload
    def nextOffset(self, float: float, int: int, boolean: bool) -> int: ...
    def setPosition(self, int: int) -> None: ...

class LineMetrics:
    def __init__(self): ...
    def getAscent(self) -> float: ...
    def getBaselineIndex(self) -> int: ...
    def getBaselineOffsets(self) -> typing.List[float]: ...
    def getDescent(self) -> float: ...
    def getHeight(self) -> float: ...
    def getLeading(self) -> float: ...
    def getNumChars(self) -> int: ...
    def getStrikethroughOffset(self) -> float: ...
    def getStrikethroughThickness(self) -> float: ...
    def getUnderlineOffset(self) -> float: ...
    def getUnderlineThickness(self) -> float: ...

class MultipleMaster:
    @typing.overload
    def deriveMMFont(self, floatArray: typing.List[float]) -> java.awt.Font: ...
    @typing.overload
    def deriveMMFont(self, floatArray: typing.List[float], float2: float, float3: float, float4: float, float5: float) -> java.awt.Font: ...
    def getDesignAxisDefaults(self) -> typing.List[float]: ...
    def getDesignAxisNames(self) -> typing.List[str]: ...
    def getDesignAxisRanges(self) -> typing.List[float]: ...
    def getNumDesignAxes(self) -> int: ...

class NumericShaper(java.io.Serializable):
    EUROPEAN: typing.ClassVar[int] = ...
    ARABIC: typing.ClassVar[int] = ...
    EASTERN_ARABIC: typing.ClassVar[int] = ...
    DEVANAGARI: typing.ClassVar[int] = ...
    BENGALI: typing.ClassVar[int] = ...
    GURMUKHI: typing.ClassVar[int] = ...
    GUJARATI: typing.ClassVar[int] = ...
    ORIYA: typing.ClassVar[int] = ...
    TAMIL: typing.ClassVar[int] = ...
    TELUGU: typing.ClassVar[int] = ...
    KANNADA: typing.ClassVar[int] = ...
    MALAYALAM: typing.ClassVar[int] = ...
    THAI: typing.ClassVar[int] = ...
    LAO: typing.ClassVar[int] = ...
    TIBETAN: typing.ClassVar[int] = ...
    MYANMAR: typing.ClassVar[int] = ...
    ETHIOPIC: typing.ClassVar[int] = ...
    KHMER: typing.ClassVar[int] = ...
    MONGOLIAN: typing.ClassVar[int] = ...
    ALL_RANGES: typing.ClassVar[int] = ...
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    @staticmethod
    def getContextualShaper(int: int) -> 'NumericShaper': ...
    @typing.overload
    @staticmethod
    def getContextualShaper(int: int, int2: int) -> 'NumericShaper': ...
    @typing.overload
    @staticmethod
    def getContextualShaper(set: java.util.Set['NumericShaper.Range']) -> 'NumericShaper': ...
    @typing.overload
    @staticmethod
    def getContextualShaper(set: java.util.Set['NumericShaper.Range'], range: 'NumericShaper.Range') -> 'NumericShaper': ...
    def getRangeSet(self) -> java.util.Set['NumericShaper.Range']: ...
    def getRanges(self) -> int: ...
    @typing.overload
    @staticmethod
    def getShaper(int: int) -> 'NumericShaper': ...
    @typing.overload
    @staticmethod
    def getShaper(range: 'NumericShaper.Range') -> 'NumericShaper': ...
    def hashCode(self) -> int: ...
    def isContextual(self) -> bool: ...
    @typing.overload
    def shape(self, charArray: typing.List[str], int: int, int2: int) -> None: ...
    @typing.overload
    def shape(self, charArray: typing.List[str], int: int, int2: int, int3: int) -> None: ...
    @typing.overload
    def shape(self, charArray: typing.List[str], int: int, int2: int, range: 'NumericShaper.Range') -> None: ...
    def toString(self) -> str: ...
    class Range(java.lang.Enum['NumericShaper.Range']):
        EUROPEAN: typing.ClassVar['NumericShaper.Range'] = ...
        ARABIC: typing.ClassVar['NumericShaper.Range'] = ...
        EASTERN_ARABIC: typing.ClassVar['NumericShaper.Range'] = ...
        DEVANAGARI: typing.ClassVar['NumericShaper.Range'] = ...
        BENGALI: typing.ClassVar['NumericShaper.Range'] = ...
        GURMUKHI: typing.ClassVar['NumericShaper.Range'] = ...
        GUJARATI: typing.ClassVar['NumericShaper.Range'] = ...
        ORIYA: typing.ClassVar['NumericShaper.Range'] = ...
        TAMIL: typing.ClassVar['NumericShaper.Range'] = ...
        TELUGU: typing.ClassVar['NumericShaper.Range'] = ...
        KANNADA: typing.ClassVar['NumericShaper.Range'] = ...
        MALAYALAM: typing.ClassVar['NumericShaper.Range'] = ...
        THAI: typing.ClassVar['NumericShaper.Range'] = ...
        LAO: typing.ClassVar['NumericShaper.Range'] = ...
        TIBETAN: typing.ClassVar['NumericShaper.Range'] = ...
        MYANMAR: typing.ClassVar['NumericShaper.Range'] = ...
        ETHIOPIC: typing.ClassVar['NumericShaper.Range'] = ...
        KHMER: typing.ClassVar['NumericShaper.Range'] = ...
        MONGOLIAN: typing.ClassVar['NumericShaper.Range'] = ...
        NKO: typing.ClassVar['NumericShaper.Range'] = ...
        MYANMAR_SHAN: typing.ClassVar['NumericShaper.Range'] = ...
        LIMBU: typing.ClassVar['NumericShaper.Range'] = ...
        NEW_TAI_LUE: typing.ClassVar['NumericShaper.Range'] = ...
        BALINESE: typing.ClassVar['NumericShaper.Range'] = ...
        SUNDANESE: typing.ClassVar['NumericShaper.Range'] = ...
        LEPCHA: typing.ClassVar['NumericShaper.Range'] = ...
        OL_CHIKI: typing.ClassVar['NumericShaper.Range'] = ...
        VAI: typing.ClassVar['NumericShaper.Range'] = ...
        SAURASHTRA: typing.ClassVar['NumericShaper.Range'] = ...
        KAYAH_LI: typing.ClassVar['NumericShaper.Range'] = ...
        CHAM: typing.ClassVar['NumericShaper.Range'] = ...
        TAI_THAM_HORA: typing.ClassVar['NumericShaper.Range'] = ...
        TAI_THAM_THAM: typing.ClassVar['NumericShaper.Range'] = ...
        JAVANESE: typing.ClassVar['NumericShaper.Range'] = ...
        MEETEI_MAYEK: typing.ClassVar['NumericShaper.Range'] = ...
        SINHALA: typing.ClassVar['NumericShaper.Range'] = ...
        MYANMAR_TAI_LAING: typing.ClassVar['NumericShaper.Range'] = ...
        _valueOf_1__T = typing.TypeVar('_valueOf_1__T', bound=java.lang.Enum)  # <T>
        @typing.overload
        @staticmethod
        def valueOf(string: str) -> 'NumericShaper.Range': ...
        @typing.overload
        @staticmethod
        def valueOf(class_: typing.Type[_valueOf_1__T], string: str) -> _valueOf_1__T: ...
        @staticmethod
        def values() -> typing.List['NumericShaper.Range']: ...

class OpenType:
    TAG_CMAP: typing.ClassVar[int] = ...
    TAG_HEAD: typing.ClassVar[int] = ...
    TAG_NAME: typing.ClassVar[int] = ...
    TAG_GLYF: typing.ClassVar[int] = ...
    TAG_MAXP: typing.ClassVar[int] = ...
    TAG_PREP: typing.ClassVar[int] = ...
    TAG_HMTX: typing.ClassVar[int] = ...
    TAG_KERN: typing.ClassVar[int] = ...
    TAG_HDMX: typing.ClassVar[int] = ...
    TAG_LOCA: typing.ClassVar[int] = ...
    TAG_POST: typing.ClassVar[int] = ...
    TAG_OS2: typing.ClassVar[int] = ...
    TAG_CVT: typing.ClassVar[int] = ...
    TAG_GASP: typing.ClassVar[int] = ...
    TAG_VDMX: typing.ClassVar[int] = ...
    TAG_VMTX: typing.ClassVar[int] = ...
    TAG_VHEA: typing.ClassVar[int] = ...
    TAG_HHEA: typing.ClassVar[int] = ...
    TAG_TYP1: typing.ClassVar[int] = ...
    TAG_BSLN: typing.ClassVar[int] = ...
    TAG_GSUB: typing.ClassVar[int] = ...
    TAG_DSIG: typing.ClassVar[int] = ...
    TAG_FPGM: typing.ClassVar[int] = ...
    TAG_FVAR: typing.ClassVar[int] = ...
    TAG_GVAR: typing.ClassVar[int] = ...
    TAG_CFF: typing.ClassVar[int] = ...
    TAG_MMSD: typing.ClassVar[int] = ...
    TAG_MMFX: typing.ClassVar[int] = ...
    TAG_BASE: typing.ClassVar[int] = ...
    TAG_GDEF: typing.ClassVar[int] = ...
    TAG_GPOS: typing.ClassVar[int] = ...
    TAG_JSTF: typing.ClassVar[int] = ...
    TAG_EBDT: typing.ClassVar[int] = ...
    TAG_EBLC: typing.ClassVar[int] = ...
    TAG_EBSC: typing.ClassVar[int] = ...
    TAG_LTSH: typing.ClassVar[int] = ...
    TAG_PCLT: typing.ClassVar[int] = ...
    TAG_ACNT: typing.ClassVar[int] = ...
    TAG_AVAR: typing.ClassVar[int] = ...
    TAG_BDAT: typing.ClassVar[int] = ...
    TAG_BLOC: typing.ClassVar[int] = ...
    TAG_CVAR: typing.ClassVar[int] = ...
    TAG_FEAT: typing.ClassVar[int] = ...
    TAG_FDSC: typing.ClassVar[int] = ...
    TAG_FMTX: typing.ClassVar[int] = ...
    TAG_JUST: typing.ClassVar[int] = ...
    TAG_LCAR: typing.ClassVar[int] = ...
    TAG_MORT: typing.ClassVar[int] = ...
    TAG_OPBD: typing.ClassVar[int] = ...
    TAG_PROP: typing.ClassVar[int] = ...
    TAG_TRAK: typing.ClassVar[int] = ...
    @typing.overload
    def getFontTable(self, int: int) -> typing.List[int]: ...
    @typing.overload
    def getFontTable(self, int: int, int2: int, int3: int) -> typing.List[int]: ...
    @typing.overload
    def getFontTable(self, string: str) -> typing.List[int]: ...
    @typing.overload
    def getFontTable(self, string: str, int: int, int2: int) -> typing.List[int]: ...
    @typing.overload
    def getFontTableSize(self, int: int) -> int: ...
    @typing.overload
    def getFontTableSize(self, string: str) -> int: ...
    def getVersion(self) -> int: ...

class TextAttribute(java.text.AttributedCharacterIterator.Attribute):
    FAMILY: typing.ClassVar['TextAttribute'] = ...
    WEIGHT: typing.ClassVar['TextAttribute'] = ...
    WEIGHT_EXTRA_LIGHT: typing.ClassVar[float] = ...
    WEIGHT_LIGHT: typing.ClassVar[float] = ...
    WEIGHT_DEMILIGHT: typing.ClassVar[float] = ...
    WEIGHT_REGULAR: typing.ClassVar[float] = ...
    WEIGHT_SEMIBOLD: typing.ClassVar[float] = ...
    WEIGHT_MEDIUM: typing.ClassVar[float] = ...
    WEIGHT_DEMIBOLD: typing.ClassVar[float] = ...
    WEIGHT_BOLD: typing.ClassVar[float] = ...
    WEIGHT_HEAVY: typing.ClassVar[float] = ...
    WEIGHT_EXTRABOLD: typing.ClassVar[float] = ...
    WEIGHT_ULTRABOLD: typing.ClassVar[float] = ...
    WIDTH: typing.ClassVar['TextAttribute'] = ...
    WIDTH_CONDENSED: typing.ClassVar[float] = ...
    WIDTH_SEMI_CONDENSED: typing.ClassVar[float] = ...
    WIDTH_REGULAR: typing.ClassVar[float] = ...
    WIDTH_SEMI_EXTENDED: typing.ClassVar[float] = ...
    WIDTH_EXTENDED: typing.ClassVar[float] = ...
    POSTURE: typing.ClassVar['TextAttribute'] = ...
    POSTURE_REGULAR: typing.ClassVar[float] = ...
    POSTURE_OBLIQUE: typing.ClassVar[float] = ...
    SIZE: typing.ClassVar['TextAttribute'] = ...
    TRANSFORM: typing.ClassVar['TextAttribute'] = ...
    SUPERSCRIPT: typing.ClassVar['TextAttribute'] = ...
    SUPERSCRIPT_SUPER: typing.ClassVar[int] = ...
    SUPERSCRIPT_SUB: typing.ClassVar[int] = ...
    FONT: typing.ClassVar['TextAttribute'] = ...
    CHAR_REPLACEMENT: typing.ClassVar['TextAttribute'] = ...
    FOREGROUND: typing.ClassVar['TextAttribute'] = ...
    BACKGROUND: typing.ClassVar['TextAttribute'] = ...
    UNDERLINE: typing.ClassVar['TextAttribute'] = ...
    UNDERLINE_ON: typing.ClassVar[int] = ...
    STRIKETHROUGH: typing.ClassVar['TextAttribute'] = ...
    STRIKETHROUGH_ON: typing.ClassVar[bool] = ...
    RUN_DIRECTION: typing.ClassVar['TextAttribute'] = ...
    RUN_DIRECTION_LTR: typing.ClassVar[bool] = ...
    RUN_DIRECTION_RTL: typing.ClassVar[bool] = ...
    BIDI_EMBEDDING: typing.ClassVar['TextAttribute'] = ...
    JUSTIFICATION: typing.ClassVar['TextAttribute'] = ...
    JUSTIFICATION_FULL: typing.ClassVar[float] = ...
    JUSTIFICATION_NONE: typing.ClassVar[float] = ...
    INPUT_METHOD_HIGHLIGHT: typing.ClassVar['TextAttribute'] = ...
    INPUT_METHOD_UNDERLINE: typing.ClassVar['TextAttribute'] = ...
    UNDERLINE_LOW_ONE_PIXEL: typing.ClassVar[int] = ...
    UNDERLINE_LOW_TWO_PIXEL: typing.ClassVar[int] = ...
    UNDERLINE_LOW_DOTTED: typing.ClassVar[int] = ...
    UNDERLINE_LOW_GRAY: typing.ClassVar[int] = ...
    UNDERLINE_LOW_DASHED: typing.ClassVar[int] = ...
    SWAP_COLORS: typing.ClassVar['TextAttribute'] = ...
    SWAP_COLORS_ON: typing.ClassVar[bool] = ...
    NUMERIC_SHAPING: typing.ClassVar['TextAttribute'] = ...
    KERNING: typing.ClassVar['TextAttribute'] = ...
    KERNING_ON: typing.ClassVar[int] = ...
    LIGATURES: typing.ClassVar['TextAttribute'] = ...
    LIGATURES_ON: typing.ClassVar[int] = ...
    TRACKING: typing.ClassVar['TextAttribute'] = ...
    TRACKING_TIGHT: typing.ClassVar[float] = ...
    TRACKING_LOOSE: typing.ClassVar[float] = ...

class TextHitInfo:
    @staticmethod
    def afterOffset(int: int) -> 'TextHitInfo': ...
    @staticmethod
    def beforeOffset(int: int) -> 'TextHitInfo': ...
    @typing.overload
    def equals(self, textHitInfo: 'TextHitInfo') -> bool: ...
    @typing.overload
    def equals(self, object: typing.Any) -> bool: ...
    def getCharIndex(self) -> int: ...
    def getInsertionIndex(self) -> int: ...
    def getOffsetHit(self, int: int) -> 'TextHitInfo': ...
    def getOtherHit(self) -> 'TextHitInfo': ...
    def hashCode(self) -> int: ...
    def isLeadingEdge(self) -> bool: ...
    @staticmethod
    def leading(int: int) -> 'TextHitInfo': ...
    def toString(self) -> str: ...
    @staticmethod
    def trailing(int: int) -> 'TextHitInfo': ...

class TextLayout(java.lang.Cloneable):
    DEFAULT_CARET_POLICY: typing.ClassVar['TextLayout.CaretPolicy'] = ...
    @typing.overload
    def __init__(self, string: str, font: java.awt.Font, fontRenderContext: FontRenderContext): ...
    @typing.overload
    def __init__(self, string: str, map: typing.Union[java.util.Map[java.text.AttributedCharacterIterator.Attribute, typing.Any], typing.Mapping[java.text.AttributedCharacterIterator.Attribute, typing.Any]], fontRenderContext: FontRenderContext): ...
    @typing.overload
    def __init__(self, attributedCharacterIterator: java.text.AttributedCharacterIterator, fontRenderContext: FontRenderContext): ...
    def draw(self, graphics2D: java.awt.Graphics2D, float: float, float2: float) -> None: ...
    @typing.overload
    def equals(self, textLayout: 'TextLayout') -> bool: ...
    @typing.overload
    def equals(self, object: typing.Any) -> bool: ...
    def getAdvance(self) -> float: ...
    def getAscent(self) -> float: ...
    def getBaseline(self) -> int: ...
    def getBaselineOffsets(self) -> typing.List[float]: ...
    def getBlackBoxBounds(self, int: int, int2: int) -> java.awt.Shape: ...
    def getBounds(self) -> java.awt.geom.Rectangle2D: ...
    @typing.overload
    def getCaretInfo(self, textHitInfo: TextHitInfo) -> typing.List[float]: ...
    @typing.overload
    def getCaretInfo(self, textHitInfo: TextHitInfo, rectangle2D: java.awt.geom.Rectangle2D) -> typing.List[float]: ...
    @typing.overload
    def getCaretShape(self, textHitInfo: TextHitInfo) -> java.awt.Shape: ...
    @typing.overload
    def getCaretShape(self, textHitInfo: TextHitInfo, rectangle2D: java.awt.geom.Rectangle2D) -> java.awt.Shape: ...
    @typing.overload
    def getCaretShapes(self, int: int) -> typing.List[java.awt.Shape]: ...
    @typing.overload
    def getCaretShapes(self, int: int, rectangle2D: java.awt.geom.Rectangle2D) -> typing.List[java.awt.Shape]: ...
    @typing.overload
    def getCaretShapes(self, int: int, rectangle2D: java.awt.geom.Rectangle2D, caretPolicy: 'TextLayout.CaretPolicy') -> typing.List[java.awt.Shape]: ...
    def getCharacterCount(self) -> int: ...
    def getCharacterLevel(self, int: int) -> int: ...
    def getDescent(self) -> float: ...
    def getJustifiedLayout(self, float: float) -> 'TextLayout': ...
    def getLayoutPath(self) -> LayoutPath: ...
    def getLeading(self) -> float: ...
    @typing.overload
    def getLogicalHighlightShape(self, int: int, int2: int) -> java.awt.Shape: ...
    @typing.overload
    def getLogicalHighlightShape(self, int: int, int2: int, rectangle2D: java.awt.geom.Rectangle2D) -> java.awt.Shape: ...
    def getLogicalRangesForVisualSelection(self, textHitInfo: TextHitInfo, textHitInfo2: TextHitInfo) -> typing.List[int]: ...
    @typing.overload
    def getNextLeftHit(self, int: int) -> TextHitInfo: ...
    @typing.overload
    def getNextLeftHit(self, int: int, caretPolicy: 'TextLayout.CaretPolicy') -> TextHitInfo: ...
    @typing.overload
    def getNextLeftHit(self, textHitInfo: TextHitInfo) -> TextHitInfo: ...
    @typing.overload
    def getNextRightHit(self, int: int) -> TextHitInfo: ...
    @typing.overload
    def getNextRightHit(self, int: int, caretPolicy: 'TextLayout.CaretPolicy') -> TextHitInfo: ...
    @typing.overload
    def getNextRightHit(self, textHitInfo: TextHitInfo) -> TextHitInfo: ...
    def getOutline(self, affineTransform: java.awt.geom.AffineTransform) -> java.awt.Shape: ...
    def getPixelBounds(self, fontRenderContext: FontRenderContext, float: float, float2: float) -> java.awt.Rectangle: ...
    def getVisibleAdvance(self) -> float: ...
    @typing.overload
    def getVisualHighlightShape(self, textHitInfo: TextHitInfo, textHitInfo2: TextHitInfo) -> java.awt.Shape: ...
    @typing.overload
    def getVisualHighlightShape(self, textHitInfo: TextHitInfo, textHitInfo2: TextHitInfo, rectangle2D: java.awt.geom.Rectangle2D) -> java.awt.Shape: ...
    def getVisualOtherHit(self, textHitInfo: TextHitInfo) -> TextHitInfo: ...
    @typing.overload
    def hitTestChar(self, float: float, float2: float) -> TextHitInfo: ...
    @typing.overload
    def hitTestChar(self, float: float, float2: float, rectangle2D: java.awt.geom.Rectangle2D) -> TextHitInfo: ...
    def hitToPoint(self, textHitInfo: TextHitInfo, point2D: java.awt.geom.Point2D) -> None: ...
    def isLeftToRight(self) -> bool: ...
    def isVertical(self) -> bool: ...
    def toString(self) -> str: ...
    class CaretPolicy:
        def __init__(self): ...
        def getStrongCaret(self, textHitInfo: TextHitInfo, textHitInfo2: TextHitInfo, textLayout: 'TextLayout') -> TextHitInfo: ...

class TextMeasurer(java.lang.Cloneable):
    def __init__(self, attributedCharacterIterator: java.text.AttributedCharacterIterator, fontRenderContext: FontRenderContext): ...
    def deleteChar(self, attributedCharacterIterator: java.text.AttributedCharacterIterator, int: int) -> None: ...
    def getAdvanceBetween(self, int: int, int2: int) -> float: ...
    def getLayout(self, int: int, int2: int) -> TextLayout: ...
    def getLineBreakIndex(self, int: int, float: float) -> int: ...
    def insertChar(self, attributedCharacterIterator: java.text.AttributedCharacterIterator, int: int) -> None: ...

class TransformAttribute(java.io.Serializable):
    IDENTITY: typing.ClassVar['TransformAttribute'] = ...
    def __init__(self, affineTransform: java.awt.geom.AffineTransform): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getTransform(self) -> java.awt.geom.AffineTransform: ...
    def hashCode(self) -> int: ...
    def isIdentity(self) -> bool: ...

class ImageGraphicAttribute(GraphicAttribute):
    @typing.overload
    def __init__(self, image: java.awt.Image, int: int): ...
    @typing.overload
    def __init__(self, image: java.awt.Image, int: int, float: float, float2: float): ...
    def draw(self, graphics2D: java.awt.Graphics2D, float: float, float2: float) -> None: ...
    @typing.overload
    def equals(self, imageGraphicAttribute: 'ImageGraphicAttribute') -> bool: ...
    @typing.overload
    def equals(self, object: typing.Any) -> bool: ...
    def getAdvance(self) -> float: ...
    def getAscent(self) -> float: ...
    def getBounds(self) -> java.awt.geom.Rectangle2D: ...
    def getDescent(self) -> float: ...
    def hashCode(self) -> int: ...

class ShapeGraphicAttribute(GraphicAttribute):
    STROKE: typing.ClassVar[bool] = ...
    FILL: typing.ClassVar[bool] = ...
    def __init__(self, shape: java.awt.Shape, int: int, boolean: bool): ...
    def draw(self, graphics2D: java.awt.Graphics2D, float: float, float2: float) -> None: ...
    @typing.overload
    def equals(self, shapeGraphicAttribute: 'ShapeGraphicAttribute') -> bool: ...
    @typing.overload
    def equals(self, object: typing.Any) -> bool: ...
    def getAdvance(self) -> float: ...
    def getAscent(self) -> float: ...
    def getBounds(self) -> java.awt.geom.Rectangle2D: ...
    def getDescent(self) -> float: ...
    def getOutline(self, affineTransform: java.awt.geom.AffineTransform) -> java.awt.Shape: ...
    def hashCode(self) -> int: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("java.awt.font")``.

    FontRenderContext: typing.Type[FontRenderContext]
    GlyphJustificationInfo: typing.Type[GlyphJustificationInfo]
    GlyphMetrics: typing.Type[GlyphMetrics]
    GlyphVector: typing.Type[GlyphVector]
    GraphicAttribute: typing.Type[GraphicAttribute]
    ImageGraphicAttribute: typing.Type[ImageGraphicAttribute]
    LayoutPath: typing.Type[LayoutPath]
    LineBreakMeasurer: typing.Type[LineBreakMeasurer]
    LineMetrics: typing.Type[LineMetrics]
    MultipleMaster: typing.Type[MultipleMaster]
    NumericShaper: typing.Type[NumericShaper]
    OpenType: typing.Type[OpenType]
    ShapeGraphicAttribute: typing.Type[ShapeGraphicAttribute]
    TextAttribute: typing.Type[TextAttribute]
    TextHitInfo: typing.Type[TextHitInfo]
    TextLayout: typing.Type[TextLayout]
    TextMeasurer: typing.Type[TextMeasurer]
    TransformAttribute: typing.Type[TransformAttribute]
