import java.lang
import java.math
import java.util
import org.ergoplatform
import org.ergoplatform.appkit
import org.ergoplatform.explorer.client
import org.ergoplatform.explorer.client.model
import org.ergoplatform.restapi.client
import org.ergoplatform.wallet.protocol.context
import scala
import scala.collection
import scala.collection.immutable
import sigmastate
import sigmastate.interpreter
import special.collection
import special.sigma
import typing



class BlockchainContextBase(org.ergoplatform.appkit.BlockchainContext):
    def __init__(self, networkType: org.ergoplatform.appkit.NetworkType): ...
    def compileContract(self, constants: org.ergoplatform.appkit.Constants, string: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.ErgoContract: ...
    def getNetworkType(self) -> org.ergoplatform.appkit.NetworkType: ...
    def getParameters(self) -> org.ergoplatform.appkit.BlockchainParameters: ...
    def newContract(self, ergoTree: sigmastate.Values.ErgoTree) -> org.ergoplatform.appkit.ErgoContract: ...
    def parseReducedTransaction(self, byteArray: typing.List[int]) -> org.ergoplatform.appkit.ReducedTransaction: ...
    def parseSignedTransaction(self, byteArray: typing.List[int]) -> org.ergoplatform.appkit.SignedTransaction: ...

class BlockchainContextBuilderImpl(org.ergoplatform.appkit.BlockchainContextBuilder):
    def __init__(self, blockchainDataSource: org.ergoplatform.appkit.BlockchainDataSource, networkType: org.ergoplatform.appkit.NetworkType): ...
    def build(self) -> org.ergoplatform.appkit.BlockchainContext: ...

class BoxAttachmentBuilder:
    def __init__(self): ...
    @staticmethod
    def buildFromAdditionalRegisters(additionalRegisters: org.ergoplatform.explorer.client.model.AdditionalRegisters) -> org.ergoplatform.appkit.BoxAttachment: ...
    @staticmethod
    def buildFromHexEncodedErgoValue(string: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.BoxAttachment: ...
    @staticmethod
    def buildFromTransactionBox(transactionBox: org.ergoplatform.appkit.TransactionBox) -> org.ergoplatform.appkit.BoxAttachment: ...
    @staticmethod
    def createMultiAttachment(list: java.util.List[org.ergoplatform.appkit.BoxAttachment]) -> org.ergoplatform.appkit.BoxAttachmentMulti: ...
    @staticmethod
    def createPlainTextAttachment(string: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.BoxAttachmentPlainText: ...
    @staticmethod
    def getAttachmentRegisterIndex() -> int: ...

class Eip4TokenBuilder:
    def __init__(self): ...
    @staticmethod
    def buildFromAdditionalRegisters(string: typing.Union[java.lang.String, str], long: int, additionalRegisters: org.ergoplatform.explorer.client.model.AdditionalRegisters) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildFromErgoBox(string: typing.Union[java.lang.String, str], transactionBox: org.ergoplatform.appkit.TransactionBox) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildFromExplorerByIssuingBox(defaultApi: org.ergoplatform.explorer.client.DefaultApi, string: typing.Union[java.lang.String, str], string2: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildFromExplorerByTokenId(defaultApi: org.ergoplatform.explorer.client.DefaultApi, string: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildFromHexEncodedRegisters(string: typing.Union[java.lang.String, str], long: int, list: java.util.List[typing.Union[java.lang.String, str]]) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildNftAudioToken(string: typing.Union[java.lang.String, str], long: int, string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], int: int, byteArray: typing.List[int], string4: typing.Union[java.lang.String, str], string5: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildNftPictureToken(string: typing.Union[java.lang.String, str], long: int, string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], int: int, byteArray: typing.List[int], string4: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.Eip4Token: ...
    @staticmethod
    def buildNftVideoToken(string: typing.Union[java.lang.String, str], long: int, string2: typing.Union[java.lang.String, str], string3: typing.Union[java.lang.String, str], int: int, byteArray: typing.List[int], string4: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.Eip4Token: ...

class ErgoProverBuilderImpl(org.ergoplatform.appkit.ErgoProverBuilder):
    org$ergoplatform$appkit$impl$ErgoProverBuilderImpl$$_ctx: BlockchainContextBase = ...
    def __init__(self, _ctx: BlockchainContextBase): ...
    def build(self) -> org.ergoplatform.appkit.ErgoProver: ...
    def withDHTData(self, g: special.sigma.GroupElement, h: special.sigma.GroupElement, u: special.sigma.GroupElement, v: special.sigma.GroupElement, x: java.math.BigInteger) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    def withDLogSecret(self, x: java.math.BigInteger) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    def withEip3Secret(self, index: int) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    @typing.overload
    def withMnemonic(self, mnemonic: org.ergoplatform.appkit.Mnemonic) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    @typing.overload
    def withMnemonic(self, mnemonicPhrase: org.ergoplatform.appkit.SecretString, mnemonicPass: org.ergoplatform.appkit.SecretString) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    def withSecretStorage(self, storage: org.ergoplatform.appkit.SecretStorage) -> org.ergoplatform.appkit.ErgoProverBuilder: ...

class ErgoProverImpl(org.ergoplatform.appkit.ErgoProver):
    def __init__(self, _ctx: BlockchainContextBase, _prover: org.ergoplatform.appkit.AppkitProvingInterpreter): ...
    def getAddress(self) -> org.ergoplatform.appkit.Address: ...
    def getEip3Addresses(self) -> java.util.List[org.ergoplatform.appkit.Address]: ...
    def getP2PKAddress(self) -> org.ergoplatform.P2PKAddress: ...
    def getSecretKey(self) -> special.sigma.BigInt: ...
    def reduce(self, tx: org.ergoplatform.appkit.UnsignedTransaction, baseCost: int) -> org.ergoplatform.appkit.ReducedTransaction: ...
    @typing.overload
    def sign(self, tx: org.ergoplatform.appkit.UnsignedTransaction) -> org.ergoplatform.appkit.SignedTransaction: ...
    @typing.overload
    def sign(self, tx: org.ergoplatform.appkit.UnsignedTransaction, baseCost: int) -> org.ergoplatform.appkit.SignedTransaction: ...
    def signMessage(self, sigmaProp: org.ergoplatform.appkit.SigmaProp, message: typing.List[int], hintsBag: sigmastate.interpreter.HintsBag) -> typing.List[int]: ...
    def signReduced(self, tx: org.ergoplatform.appkit.ReducedTransaction, baseCost: int) -> org.ergoplatform.appkit.SignedTransaction: ...

class ErgoScriptContract(org.ergoplatform.appkit.ErgoContract):
    @staticmethod
    def create(constants: org.ergoplatform.appkit.Constants, string: typing.Union[java.lang.String, str], networkType: org.ergoplatform.appkit.NetworkType) -> 'ErgoScriptContract': ...
    def getConstants(self) -> org.ergoplatform.appkit.Constants: ...
    def getErgoScript(self) -> java.lang.String: ...
    def getErgoTree(self) -> sigmastate.Values.ErgoTree: ...
    def substConstant(self, string: typing.Union[java.lang.String, str], object: typing.Any) -> 'ErgoScriptContract': ...
    def toAddress(self) -> org.ergoplatform.appkit.Address: ...

class ErgoTreeContract(org.ergoplatform.appkit.ErgoContract):
    def __init__(self, ergoTree: sigmastate.Values.ErgoTree, networkType: org.ergoplatform.appkit.NetworkType): ...
    def getConstants(self) -> org.ergoplatform.appkit.Constants: ...
    def getErgoScript(self) -> java.lang.String: ...
    def getErgoTree(self) -> sigmastate.Values.ErgoTree: ...
    def substConstant(self, string: typing.Union[java.lang.String, str], object: typing.Any) -> 'ErgoTreeContract': ...
    def toAddress(self) -> org.ergoplatform.appkit.Address: ...

class InputBoxImpl(org.ergoplatform.appkit.InputBox):
    @typing.overload
    def __init__(self, ergoBox: org.ergoplatform.ErgoBox): ...
    @typing.overload
    def __init__(self, ergoTransactionOutput: org.ergoplatform.restapi.client.ErgoTransactionOutput): ...
    def getAttachment(self) -> org.ergoplatform.appkit.BoxAttachment: ...
    def getBytes(self) -> typing.List[int]: ...
    def getCreationHeight(self) -> int: ...
    def getErgoBox(self) -> org.ergoplatform.ErgoBox: ...
    def getErgoTree(self) -> sigmastate.Values.ErgoTree: ...
    def getExtension(self) -> sigmastate.interpreter.ContextExtension: ...
    def getId(self) -> org.ergoplatform.appkit.ErgoId: ...
    def getRegisters(self) -> java.util.List[org.ergoplatform.appkit.ErgoValue[typing.Any]]: ...
    def getTokens(self) -> java.util.List[org.ergoplatform.appkit.ErgoToken]: ...
    def getValue(self) -> int: ...
    @typing.overload
    def toJson(self, boolean: bool) -> java.lang.String: ...
    @typing.overload
    def toJson(self, boolean: bool, boolean2: bool) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def withContextVars(self, *contextVar: org.ergoplatform.appkit.ContextVar) -> org.ergoplatform.appkit.InputBox: ...

class NodeAndExplorerDataSourceImpl(org.ergoplatform.appkit.BlockchainDataSource):
    performCheckBeforeSend: bool = ...
    def __init__(self, apiClient: org.ergoplatform.restapi.client.ApiClient, explorerApiClient: org.ergoplatform.explorer.client.ExplorerApiClient): ...
    def getBoxById(self, string: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.InputBox: ...
    def getBoxByIdWithMemPool(self, string: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.InputBox: ...
    def getExplorerApi(self) -> org.ergoplatform.explorer.client.DefaultApi: ...
    def getLastBlockHeaders(self, int: int, boolean: bool) -> java.util.List[org.ergoplatform.appkit.BlockHeader]: ...
    def getNodeBlocksApi(self) -> org.ergoplatform.restapi.client.BlocksApi: ...
    def getNodeInfoApi(self) -> org.ergoplatform.restapi.client.InfoApi: ...
    def getNodeTransactionsApi(self) -> org.ergoplatform.restapi.client.TransactionsApi: ...
    def getNodeUtxoApi(self) -> org.ergoplatform.restapi.client.UtxoApi: ...
    def getNodeWalletApi(self) -> org.ergoplatform.restapi.client.WalletApi: ...
    def getParameters(self) -> org.ergoplatform.appkit.BlockchainParameters: ...
    def getUnconfirmedTransactions(self, int: int, int2: int) -> java.util.List[org.ergoplatform.appkit.Transaction]: ...
    def getUnconfirmedUnspentBoxesFor(self, address: org.ergoplatform.appkit.Address, int: int, int2: int) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def getUnspentBoxesFor(self, address: org.ergoplatform.appkit.Address, int: int, int2: int) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def sendTransaction(self, signedTransaction: org.ergoplatform.appkit.SignedTransaction) -> java.lang.String: ...

class NodeInfoParameters(org.ergoplatform.appkit.BlockchainParameters):
    def __init__(self, nodeInfo: org.ergoplatform.restapi.client.NodeInfo): ...
    def getBlockVersion(self) -> int: ...
    def getDataInputCost(self) -> int: ...
    def getInputCost(self) -> int: ...
    def getMaxBlockCost(self) -> int: ...
    def getMaxBlockSize(self) -> int: ...
    def getMinValuePerByte(self) -> int: ...
    def getNetworkType(self) -> org.ergoplatform.appkit.NetworkType: ...
    def getOutputCost(self) -> int: ...
    def getStorageFeeFactor(self) -> int: ...
    def getTokenAccessCost(self) -> int: ...

class OutBoxBuilderImpl(org.ergoplatform.appkit.OutBoxBuilder):
    def __init__(self, _txB: 'UnsignedTransactionBuilderImpl'): ...
    def build(self) -> org.ergoplatform.appkit.OutBox: ...
    def contract(self, contract: org.ergoplatform.appkit.ErgoContract) -> 'OutBoxBuilderImpl': ...
    def creationHeight(self, height: int) -> org.ergoplatform.appkit.OutBoxBuilder: ...
    def mintToken(self, token: org.ergoplatform.appkit.Eip4Token) -> org.ergoplatform.appkit.OutBoxBuilder: ...
    @typing.overload
    def registers(self, registers: typing.List[org.ergoplatform.appkit.ErgoValue[typing.Any]]) -> 'OutBoxBuilderImpl': ...
    @typing.overload
    def registers(self, registers: scala.collection.Seq[org.ergoplatform.appkit.ErgoValue[typing.Any]]) -> 'OutBoxBuilderImpl': ...
    @typing.overload
    def tokens(self, tokens: typing.List[org.ergoplatform.appkit.ErgoToken]) -> 'OutBoxBuilderImpl': ...
    @typing.overload
    def tokens(self, tokens: scala.collection.Seq[org.ergoplatform.appkit.ErgoToken]) -> 'OutBoxBuilderImpl': ...
    def value(self, value: int) -> 'OutBoxBuilderImpl': ...

class OutBoxImpl(org.ergoplatform.appkit.OutBox):
    def __init__(self, _ergoBoxCandidate: org.ergoplatform.ErgoBoxCandidate): ...
    def convertToInputWith(self, txId: typing.Union[java.lang.String, str], boxIndex: int) -> org.ergoplatform.appkit.InputBox: ...
    def getAttachment(self) -> org.ergoplatform.appkit.BoxAttachment: ...
    def getBytesWithNoRef(self) -> typing.List[int]: ...
    def getCreationHeight(self) -> int: ...
    def getErgoBoxCandidate(self) -> org.ergoplatform.ErgoBoxCandidate: ...
    def getErgoTree(self) -> sigmastate.Values.ErgoTree: ...
    def getRegisters(self) -> java.util.List[org.ergoplatform.appkit.ErgoValue[typing.Any]]: ...
    def getTokens(self) -> java.util.List[org.ergoplatform.appkit.ErgoToken]: ...
    def getValue(self) -> int: ...

class PreHeaderBuilderImpl(org.ergoplatform.appkit.PreHeaderBuilder):
    def __init__(self, blockchainContextImpl: 'BlockchainContextImpl'): ...
    def build(self) -> org.ergoplatform.appkit.PreHeader: ...
    def height(self, integer: int) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def minerPk(self, groupElement: special.sigma.GroupElement) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def nBits(self, long: int) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def parentId(self, coll: special.collection.Coll[int]) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def timestamp(self, long: int) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def version(self, byte: int) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def votes(self, coll: special.collection.Coll[int]) -> org.ergoplatform.appkit.PreHeaderBuilder: ...

class PreHeaderImpl(org.ergoplatform.appkit.PreHeader):
    def __init__(self, preHeader: special.sigma.PreHeader): ...
    def getHeight(self) -> int: ...
    def getMinerPk(self) -> special.sigma.GroupElement: ...
    def getNBits(self) -> int: ...
    def getParentId(self) -> special.collection.Coll[int]: ...
    def getTimestamp(self) -> int: ...
    def getVersion(self) -> int: ...
    def getVotes(self) -> special.collection.Coll[int]: ...

class ReducedTransactionImpl(org.ergoplatform.appkit.ReducedTransaction):
    def __init__(self, blockchainContextBase: BlockchainContextBase, reducedErgoLikeTransaction: org.ergoplatform.appkit.ReducedErgoLikeTransaction, int: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getCost(self) -> int: ...
    def getId(self) -> java.lang.String: ...
    def getInputBoxesIds(self) -> java.util.List[java.lang.String]: ...
    def getOutputs(self) -> java.util.List[org.ergoplatform.appkit.OutBox]: ...
    def getTx(self) -> org.ergoplatform.appkit.ReducedErgoLikeTransaction: ...
    def hashCode(self) -> int: ...
    def toBytes(self) -> typing.List[int]: ...

class ScalaBridge:
    @staticmethod
    def isoAssetToErgoToken() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.Asset, org.ergoplatform.appkit.ErgoToken]: ...
    @staticmethod
    def isoAssetToPair() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.Asset, scala.Tuple2[typing.List[int], typing.Any]]: ...
    @staticmethod
    def isoBlockHeader() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.BlockHeader, special.sigma.Header]: ...
    @staticmethod
    def isoErgoTransaction() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.ErgoTransaction, org.ergoplatform.ErgoLikeTransaction]: ...
    @staticmethod
    def isoErgoTransactionDataInput() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.ErgoTransactionDataInput, org.ergoplatform.DataInput]: ...
    @staticmethod
    def isoErgoTransactionInput() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.ErgoTransactionInput, org.ergoplatform.Input]: ...
    @staticmethod
    def isoErgoTransactionOutput() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.ErgoTransactionOutput, org.ergoplatform.ErgoBox]: ...
    @staticmethod
    def isoExplRegistersToMap() -> org.ergoplatform.appkit.Iso[org.ergoplatform.explorer.client.model.AdditionalRegisters, scala.collection.immutable.Map[org.ergoplatform.ErgoBox.NonMandatoryRegisterId, sigmastate.Values.EvaluatedValue[sigmastate.SType]]]: ...
    @staticmethod
    def isoExplorerAssetToPair() -> org.ergoplatform.appkit.Iso[org.ergoplatform.explorer.client.model.AssetInfo, scala.Tuple2[typing.List[int], typing.Any]]: ...
    @staticmethod
    def isoRegistersToMap() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.Registers, scala.collection.immutable.Map[org.ergoplatform.ErgoBox.NonMandatoryRegisterId, sigmastate.Values.EvaluatedValue[sigmastate.SType]]]: ...
    @staticmethod
    def isoSpendingProof() -> org.ergoplatform.appkit.Iso[org.ergoplatform.restapi.client.SpendingProof, sigmastate.interpreter.ProverResult]: ...
    @staticmethod
    def isoStringToErgoTree() -> org.ergoplatform.appkit.Iso[java.lang.String, sigmastate.Values.ErgoTree]: ...
    @staticmethod
    def toSigmaHeader(h: org.ergoplatform.appkit.BlockHeader) -> special.sigma.Header: ...

class SignedInputImpl(org.ergoplatform.appkit.SignedInput):
    def __init__(self, signedTransactionImpl: 'SignedTransactionImpl', input: org.ergoplatform.Input): ...
    def getContextVars(self) -> java.util.Map[int, org.ergoplatform.appkit.ErgoValue[typing.Any]]: ...
    def getId(self) -> org.ergoplatform.appkit.ErgoId: ...
    def getProofBytes(self) -> typing.List[int]: ...
    def getTransaction(self) -> org.ergoplatform.appkit.SignedTransaction: ...

class SignedTransactionImpl(org.ergoplatform.appkit.SignedTransaction):
    def __init__(self, blockchainContextBase: BlockchainContextBase, ergoLikeTransaction: org.ergoplatform.ErgoLikeTransaction, int: int): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getCost(self) -> int: ...
    def getId(self) -> java.lang.String: ...
    def getInputBoxesIds(self) -> java.util.List[java.lang.String]: ...
    def getOutputs(self) -> java.util.List[org.ergoplatform.appkit.OutBox]: ...
    def getOutputsToSpend(self) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def getSignedInputs(self) -> java.util.List[org.ergoplatform.appkit.SignedInput]: ...
    def getTx(self) -> org.ergoplatform.ErgoLikeTransaction: ...
    def hashCode(self) -> int: ...
    def toBytes(self) -> typing.List[int]: ...
    @typing.overload
    def toJson(self, boolean: bool) -> java.lang.String: ...
    @typing.overload
    def toJson(self, boolean: bool, boolean2: bool) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...

class UnsignedTransactionBuilderImpl(org.ergoplatform.appkit.UnsignedTransactionBuilder):
    def __init__(self, _ctx: 'BlockchainContextImpl'): ...
    def _ctx(self) -> 'BlockchainContextImpl': ...
    def _dataInputs(self) -> java.util.List[org.ergoplatform.DataInput]: ...
    def _dataInputs_$eq(self, x$1: java.util.List[org.ergoplatform.DataInput]) -> None: ...
    def _inputs(self) -> java.util.List[org.ergoplatform.UnsignedInput]: ...
    def _inputs_$eq(self, x$1: java.util.List[org.ergoplatform.UnsignedInput]) -> None: ...
    def _outputCandidates(self) -> scala.Option[java.util.List[org.ergoplatform.ErgoBoxCandidate]]: ...
    def _outputCandidates_$eq(self, x$1: scala.Option[java.util.List[org.ergoplatform.ErgoBoxCandidate]]) -> None: ...
    def boxesToSpend(self, inputBoxes: java.util.List[org.ergoplatform.appkit.InputBox]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def build(self) -> org.ergoplatform.appkit.UnsignedTransaction: ...
    def fee(self, feeAmount: int) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def getCtx(self) -> org.ergoplatform.appkit.BlockchainContext: ...
    _getDefined__T = typing.TypeVar('_getDefined__T')  # <T>
    def getDefined(self, opt: scala.Option[_getDefined__T], msg: scala.Function0[typing.Union[java.lang.String, str]]) -> _getDefined__T: ...
    def getInputBoxes(self) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def getNetworkType(self) -> org.ergoplatform.appkit.NetworkType: ...
    _getNonEmpty__T = typing.TypeVar('_getNonEmpty__T')  # <T>
    def getNonEmpty(self, list: scala.Option[java.util.List[_getNonEmpty__T]], msg: scala.Function0[typing.Union[java.lang.String, str]]) -> java.util.List[_getNonEmpty__T]: ...
    def getPreHeader(self) -> org.ergoplatform.appkit.PreHeader: ...
    def org$ergoplatform$appkit$impl$UnsignedTransactionBuilderImpl$$_ph(self) -> scala.Option[PreHeaderImpl]: ...
    def outBoxBuilder(self) -> OutBoxBuilderImpl: ...
    @typing.overload
    def outputs(self, outputs: typing.List[org.ergoplatform.appkit.OutBox]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    @typing.overload
    def outputs(self, outputs: scala.collection.Seq[org.ergoplatform.appkit.OutBox]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def preHeader(self, ph: org.ergoplatform.appkit.PreHeader) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def sendChangeTo(self, changeAddress: org.ergoplatform.ErgoAddress) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    @typing.overload
    def tokensToBurn(self, tokens: typing.List[org.ergoplatform.appkit.ErgoToken]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    @typing.overload
    def tokensToBurn(self, tokens: scala.collection.Seq[org.ergoplatform.appkit.ErgoToken]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def withDataInputs(self, inputBoxes: java.util.List[org.ergoplatform.appkit.InputBox]) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...

class UnsignedTransactionImpl(org.ergoplatform.appkit.UnsignedTransaction):
    def __init__(self, unsignedErgoLikeTransaction: org.ergoplatform.UnsignedErgoLikeTransaction, list: java.util.List[org.ergoplatform.appkit.ExtendedInputBox], list2: java.util.List[org.ergoplatform.ErgoBox], ergoAddress: org.ergoplatform.ErgoAddress, ergoLikeStateContext: org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext, blockchainContextImpl: 'BlockchainContextImpl'): ...
    def getBoxesToSpend(self) -> java.util.List[org.ergoplatform.appkit.ExtendedInputBox]: ...
    def getChangeAddress(self) -> org.ergoplatform.ErgoAddress: ...
    def getDataBoxes(self) -> java.util.List[org.ergoplatform.ErgoBox]: ...
    def getDataInputs(self) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def getId(self) -> java.lang.String: ...
    def getInputBoxesIds(self) -> java.util.List[java.lang.String]: ...
    def getInputs(self) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def getOutputs(self) -> java.util.List[org.ergoplatform.appkit.OutBox]: ...
    def getStateContext(self) -> org.ergoplatform.wallet.protocol.context.ErgoLikeStateContext: ...
    def getTx(self) -> org.ergoplatform.UnsignedErgoLikeTransaction: ...

class BlockHeaderImpl(PreHeaderImpl, org.ergoplatform.appkit.BlockHeader):
    def __init__(self, header: special.sigma.Header, blockHeader: org.ergoplatform.restapi.client.BlockHeader): ...
    @staticmethod
    def createFromRestApi(blockHeader: org.ergoplatform.restapi.client.BlockHeader) -> 'BlockHeaderImpl': ...
    def getAdProofsRoot(self) -> special.collection.Coll[int]: ...
    def getExtensionHash(self) -> special.collection.Coll[int]: ...
    def getId(self) -> java.lang.String: ...
    def getPowSolutionsD(self) -> java.math.BigInteger: ...
    def getPowSolutionsN(self) -> special.collection.Coll[int]: ...
    def getPowSolutionsPk(self) -> special.sigma.GroupElement: ...
    def getPowSolutionsW(self) -> special.sigma.GroupElement: ...
    def getStateRoot(self) -> special.sigma.AvlTree: ...
    def getTransactionsRoot(self) -> special.collection.Coll[int]: ...

class BlockchainContextImpl(BlockchainContextBase):
    def __init__(self, blockchainDataSource: org.ergoplatform.appkit.BlockchainDataSource, networkType: org.ergoplatform.appkit.NetworkType): ...
    def createPreHeader(self) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    def getBoxesById(self, *string: typing.Union[java.lang.String, str]) -> typing.List[org.ergoplatform.appkit.InputBox]: ...
    def getCoveringBoxesFor(self, address: org.ergoplatform.appkit.Address, long: int, list: java.util.List[org.ergoplatform.appkit.ErgoToken]) -> org.ergoplatform.appkit.CoveringBoxes: ...
    def getDataSource(self) -> org.ergoplatform.appkit.BlockchainDataSource: ...
    def getHeaders(self) -> java.util.List[org.ergoplatform.appkit.BlockHeader]: ...
    def getHeight(self) -> int: ...
    def getParameters(self) -> org.ergoplatform.appkit.BlockchainParameters: ...
    def getUnspentBoxesFor(self, address: org.ergoplatform.appkit.Address, int: int, int2: int) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def newProverBuilder(self) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    def newTxBuilder(self) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def sendTransaction(self, signedTransaction: org.ergoplatform.appkit.SignedTransaction) -> java.lang.String: ...
    def signedTxFromJson(self, string: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.SignedTransaction: ...

class ColdBlockchainContext(BlockchainContextBase):
    def __init__(self, networkType: org.ergoplatform.appkit.NetworkType, params: org.ergoplatform.appkit.BlockchainParameters): ...
    def createPreHeader(self) -> org.ergoplatform.appkit.PreHeaderBuilder: ...
    @typing.overload
    def getBoxesById(self, boxIds: typing.List[java.lang.String]) -> typing.List[org.ergoplatform.appkit.InputBox]: ...
    @typing.overload
    def getBoxesById(self, boxIds: scala.collection.Seq[typing.Union[java.lang.String, str]]) -> typing.List[org.ergoplatform.appkit.InputBox]: ...
    def getCoveringBoxesFor(self, address: org.ergoplatform.appkit.Address, amountToSpend: int, tokensToSpend: java.util.List[org.ergoplatform.appkit.ErgoToken]) -> org.ergoplatform.appkit.CoveringBoxes: ...
    def getDataSource(self) -> org.ergoplatform.appkit.BlockchainDataSource: ...
    def getHeight(self) -> int: ...
    def getParameters(self) -> org.ergoplatform.appkit.BlockchainParameters: ...
    def getUnspentBoxesFor(self, address: org.ergoplatform.appkit.Address, offset: int, limit: int) -> java.util.List[org.ergoplatform.appkit.InputBox]: ...
    def newProverBuilder(self) -> org.ergoplatform.appkit.ErgoProverBuilder: ...
    def newTxBuilder(self) -> org.ergoplatform.appkit.UnsignedTransactionBuilder: ...
    def sendTransaction(self, tx: org.ergoplatform.appkit.SignedTransaction) -> java.lang.String: ...
    def signedTxFromJson(self, json: typing.Union[java.lang.String, str]) -> org.ergoplatform.appkit.SignedTransaction: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.ergoplatform.appkit.impl")``.

    BlockHeaderImpl: typing.Type[BlockHeaderImpl]
    BlockchainContextBase: typing.Type[BlockchainContextBase]
    BlockchainContextBuilderImpl: typing.Type[BlockchainContextBuilderImpl]
    BlockchainContextImpl: typing.Type[BlockchainContextImpl]
    BoxAttachmentBuilder: typing.Type[BoxAttachmentBuilder]
    ColdBlockchainContext: typing.Type[ColdBlockchainContext]
    Eip4TokenBuilder: typing.Type[Eip4TokenBuilder]
    ErgoProverBuilderImpl: typing.Type[ErgoProverBuilderImpl]
    ErgoProverImpl: typing.Type[ErgoProverImpl]
    ErgoScriptContract: typing.Type[ErgoScriptContract]
    ErgoTreeContract: typing.Type[ErgoTreeContract]
    InputBoxImpl: typing.Type[InputBoxImpl]
    NodeAndExplorerDataSourceImpl: typing.Type[NodeAndExplorerDataSourceImpl]
    NodeInfoParameters: typing.Type[NodeInfoParameters]
    OutBoxBuilderImpl: typing.Type[OutBoxBuilderImpl]
    OutBoxImpl: typing.Type[OutBoxImpl]
    PreHeaderBuilderImpl: typing.Type[PreHeaderBuilderImpl]
    PreHeaderImpl: typing.Type[PreHeaderImpl]
    ReducedTransactionImpl: typing.Type[ReducedTransactionImpl]
    ScalaBridge: typing.Type[ScalaBridge]
    SignedInputImpl: typing.Type[SignedInputImpl]
    SignedTransactionImpl: typing.Type[SignedTransactionImpl]
    UnsignedTransactionBuilderImpl: typing.Type[UnsignedTransactionBuilderImpl]
    UnsignedTransactionImpl: typing.Type[UnsignedTransactionImpl]
