import java.io
import java.lang
import java.util
import jpype.protocol
import scala
import scala.collection
import scala.collection.generic
import scala.collection.mutable
import scala.collection.parallel
import scala.collection.parallel.immutable
import scala.io
import scala.math
import scala.reflect
import scala.runtime
import scala.util.matching
import typing



_IntMapIterator__V = typing.TypeVar('_IntMapIterator__V')  # <V>
_IntMapIterator__T = typing.TypeVar('_IntMapIterator__T')  # <T>
class IntMapIterator(scala.collection.AbstractIterator[_IntMapIterator__T], typing.Generic[_IntMapIterator__V, _IntMapIterator__T]):
    def __init__(self, it: 'IntMap'[_IntMapIterator__V]): ...
    def buffer(self) -> typing.List[typing.Any]: ...
    def buffer_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def hasNext(self) -> bool: ...
    def index(self) -> int: ...
    def index_$eq(self, x$1: int) -> None: ...
    def next(self) -> _IntMapIterator__T: ...
    def pop(self) -> 'IntMap'[_IntMapIterator__V]: ...
    def push(self, x: 'IntMap'[_IntMapIterator__V]) -> None: ...
    def valueOf(self, tip: 'IntMap.Tip'[_IntMapIterator__V]) -> _IntMapIterator__T: ...

class IntMapUtils:
    _bin__T = typing.TypeVar('_bin__T')  # <T>
    @staticmethod
    def bin(prefix: int, mask: int, left: 'IntMap'[_bin__T], right: 'IntMap'[_bin__T]) -> 'IntMap'[_bin__T]: ...
    @staticmethod
    def bitString(num: int, sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @staticmethod
    def bitString$default$2() -> java.lang.String: ...
    @staticmethod
    def bits(num: int) -> 'IndexedSeq'[typing.Any]: ...
    @staticmethod
    def branchMask(i: int, j: int) -> int: ...
    @staticmethod
    def complement(i: int) -> int: ...
    @staticmethod
    def hasMatch(key: int, prefix: int, m: int) -> bool: ...
    @staticmethod
    def highestOneBit(j: int) -> int: ...
    _join__T = typing.TypeVar('_join__T')  # <T>
    @staticmethod
    def join(p1: int, t1: 'IntMap'[_join__T], p2: int, t2: 'IntMap'[_join__T]) -> 'IntMap'[_join__T]: ...
    @staticmethod
    def mask(i: int, mask: int) -> int: ...
    @staticmethod
    def shorter(m1: int, m2: int) -> bool: ...
    @staticmethod
    def unsignedCompare(i: int, j: int) -> bool: ...
    @staticmethod
    def zero(i: int, mask: int) -> bool: ...

class ListSerializeEnd:
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def toString() -> java.lang.String: ...

_LongMapIterator__V = typing.TypeVar('_LongMapIterator__V')  # <V>
_LongMapIterator__T = typing.TypeVar('_LongMapIterator__T')  # <T>
class LongMapIterator(scala.collection.AbstractIterator[_LongMapIterator__T], typing.Generic[_LongMapIterator__V, _LongMapIterator__T]):
    def __init__(self, it: 'LongMap'[_LongMapIterator__V]): ...
    def buffer(self) -> typing.List[typing.Any]: ...
    def buffer_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def hasNext(self) -> bool: ...
    def index(self) -> int: ...
    def index_$eq(self, x$1: int) -> None: ...
    def next(self) -> _LongMapIterator__T: ...
    def pop(self) -> 'LongMap'[_LongMapIterator__V]: ...
    def push(self, x: 'LongMap'[_LongMapIterator__V]) -> None: ...
    def valueOf(self, tip: 'LongMap.Tip'[_LongMapIterator__V]) -> _LongMapIterator__T: ...

class LongMapUtils:
    _bin__T = typing.TypeVar('_bin__T')  # <T>
    @staticmethod
    def bin(prefix: int, mask: int, left: 'LongMap'[_bin__T], right: 'LongMap'[_bin__T]) -> 'LongMap'[_bin__T]: ...
    @staticmethod
    def bitString(num: int, sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @staticmethod
    def bitString$default$2() -> java.lang.String: ...
    @staticmethod
    def bits(num: int) -> 'IndexedSeq'[typing.Any]: ...
    @staticmethod
    def branchMask(i: int, j: int) -> int: ...
    @staticmethod
    def complement(i: int) -> int: ...
    @staticmethod
    def hasMatch(key: int, prefix: int, m: int) -> bool: ...
    @staticmethod
    def highestOneBit(j: int) -> int: ...
    _join__T = typing.TypeVar('_join__T')  # <T>
    @staticmethod
    def join(p1: int, t1: 'LongMap'[_join__T], p2: int, t2: 'LongMap'[_join__T]) -> 'LongMap'[_join__T]: ...
    @staticmethod
    def mask(i: int, mask: int) -> int: ...
    @staticmethod
    def shorter(m1: int, m2: int) -> bool: ...
    @staticmethod
    def unsignedCompare(i: int, j: int) -> bool: ...
    @staticmethod
    def zero(i: int, mask: int) -> bool: ...

class Nil:
    _$colon$bslash__B = typing.TypeVar('_$colon$bslash__B')  # <B>
    @staticmethod
    def $colon$bslash(z: _.colon.bslash__B, op: scala.Function2[scala.runtime.Nothing., _.colon.bslash__B, _.colon.bslash__B]) -> _.colon.bslash__B: ...
    _$colon$colon__B = typing.TypeVar('_$colon$colon__B')  # <B>
    @staticmethod
    def $colon$colon(x: _.colon.colon__B) -> 'List'[_.colon.colon__B]: ...
    _$colon$colon$colon__B = typing.TypeVar('_$colon$colon$colon__B')  # <B>
    @staticmethod
    def $colon$colon$colon(prefix: 'List'[_.colon.colon.colon__B]) -> 'List'[_.colon.colon.colon__B]: ...
    _$colon$plus__B = typing.TypeVar('_$colon$plus__B')  # <B>
    _$colon$plus__That = typing.TypeVar('_$colon$plus__That')  # <That>
    @staticmethod
    def $colon$plus(elem: _.colon.plus__B, bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _.colon.plus__B, _.colon.plus__That]) -> _.colon.plus__That: ...
    _$div$colon__B = typing.TypeVar('_$div$colon__B')  # <B>
    @staticmethod
    def $div$colon(z: _.div.colon__B, op: scala.Function2[_.div.colon__B, scala.runtime.Nothing., _.div.colon__B]) -> _.div.colon__B: ...
    _$plus$colon__B = typing.TypeVar('_$plus$colon__B')  # <B>
    _$plus$colon__That = typing.TypeVar('_$plus$colon__That')  # <That>
    @staticmethod
    def $plus$colon(elem: _.plus.colon__B, bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _.plus.colon__B, _.plus.colon__That]) -> _.plus.colon__That: ...
    _$plus$plus__B = typing.TypeVar('_$plus$plus__B')  # <B>
    _$plus$plus__That = typing.TypeVar('_$plus$plus__That')  # <That>
    @staticmethod
    def $plus$plus(that: scala.collection.GenTraversableOnce[_.plus.plus__B], bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _.plus.plus__B, _.plus.plus__That]) -> _.plus.plus__That: ...
    _$plus$plus$colon_0__B = typing.TypeVar('_$plus$plus$colon_0__B')  # <B>
    _$plus$plus$colon_0__That = typing.TypeVar('_$plus$plus$colon_0__That')  # <That>
    _$plus$plus$colon_1__B = typing.TypeVar('_$plus$plus$colon_1__B')  # <B>
    _$plus$plus$colon_1__That = typing.TypeVar('_$plus$plus$colon_1__That')  # <That>
    @typing.overload
    @staticmethod
    def $plus$plus$colon(that: scala.collection.Traversable[_.plus.plus.colon_0__B], bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _.plus.plus.colon_0__B, _.plus.plus.colon_0__That]) -> _.plus.plus.colon_0__That: ...
    @typing.overload
    @staticmethod
    def $plus$plus$colon(that: scala.collection.TraversableOnce[_.plus.plus.colon_1__B], bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _.plus.plus.colon_1__B, _.plus.plus.colon_1__That]) -> _.plus.plus.colon_1__That: ...
    @typing.overload
    @staticmethod
    def addString(b: scala.collection.mutable.StringBuilder) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    @staticmethod
    def addString(b: scala.collection.mutable.StringBuilder, sep: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    @staticmethod
    def addString(b: scala.collection.mutable.StringBuilder, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    _aggregate__B = typing.TypeVar('_aggregate__B')  # <B>
    @staticmethod
    def aggregate(z: scala.Function0[_aggregate__B], seqop: scala.Function2[_aggregate__B, scala.runtime.Nothing., _aggregate__B], combop: scala.Function2[_aggregate__B, _aggregate__B, _aggregate__B]) -> _aggregate__B: ...
    _andThen__C = typing.TypeVar('_andThen__C')  # <C>
    @staticmethod
    def andThen(k: scala.Function1[scala.runtime.Nothing., _andThen__C]) -> scala.PartialFunction[typing.Any, _andThen__C]: ...
    @staticmethod
    def apply(n: int) -> typing.Any: ...
    @staticmethod
    def applyOrElse(x: typing.Any, default: scala.Function1) -> typing.Any: ...
    @staticmethod
    def canEqual(that: typing.Any) -> bool: ...
    _collect__B = typing.TypeVar('_collect__B')  # <B>
    _collect__That = typing.TypeVar('_collect__That')  # <That>
    @staticmethod
    def collect(pf: scala.PartialFunction[scala.runtime.Nothing., _collect__B], bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _collect__B, _collect__That]) -> _collect__That: ...
    _collectFirst__B = typing.TypeVar('_collectFirst__B')  # <B>
    @staticmethod
    def collectFirst(pf: scala.PartialFunction[scala.runtime.Nothing., _collectFirst__B]) -> scala.Option[_collectFirst__B]: ...
    @staticmethod
    def combinations(n: int) -> scala.collection.Iterator['List'[scala.runtime.Nothing.]]: ...
    @staticmethod
    def companion() -> scala.collection.generic.GenericCompanion['List']: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.Any]) -> scala.Function1[_compose__A, scala.runtime.Nothing.]: ...
    _contains__A1 = typing.TypeVar('_contains__A1')  # <A1>
    @staticmethod
    def contains(elem: _contains__A1) -> bool: ...
    _containsSlice__B = typing.TypeVar('_containsSlice__B')  # <B>
    @staticmethod
    def containsSlice(that: scala.collection.GenSeq[_containsSlice__B]) -> bool: ...
    _copyToArray_0__B = typing.TypeVar('_copyToArray_0__B')  # <B>
    _copyToArray_1__B = typing.TypeVar('_copyToArray_1__B')  # <B>
    _copyToArray_2__B = typing.TypeVar('_copyToArray_2__B')  # <B>
    @typing.overload
    @staticmethod
    def copyToArray(xs: typing.Any) -> None: ...
    @typing.overload
    @staticmethod
    def copyToArray(xs: typing.Any, start: int) -> None: ...
    @typing.overload
    @staticmethod
    def copyToArray(xs: typing.Any, start: int, len: int) -> None: ...
    _copyToBuffer__B = typing.TypeVar('_copyToBuffer__B')  # <B>
    @staticmethod
    def copyToBuffer(dest: scala.collection.mutable.Buffer[_copyToBuffer__B]) -> None: ...
    _corresponds__B = typing.TypeVar('_corresponds__B')  # <B>
    @staticmethod
    def corresponds(that: scala.collection.GenSeq[_corresponds__B], p: scala.Function2[scala.runtime.Nothing., _corresponds__B, typing.Any]) -> bool: ...
    @staticmethod
    def count(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> int: ...
    @staticmethod
    def diff(that: scala.collection.GenSeq) -> typing.Any: ...
    @staticmethod
    def distinct() -> typing.Any: ...
    @staticmethod
    def drop(n: int) -> 'List'[scala.runtime.Nothing.]: ...
    @staticmethod
    def dropRight(n: int) -> scala.collection.LinearSeqOptimized: ...
    @staticmethod
    def dropWhile(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> 'List'[scala.runtime.Nothing.]: ...
    _endsWith__B = typing.TypeVar('_endsWith__B')  # <B>
    @staticmethod
    def endsWith(that: scala.collection.GenSeq[_endsWith__B]) -> bool: ...
    @staticmethod
    def equals(that: typing.Any) -> bool: ...
    @staticmethod
    def exists(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> bool: ...
    @staticmethod
    def filter(p: scala.Function1) -> typing.Any: ...
    @staticmethod
    def filterNot(p: scala.Function1) -> typing.Any: ...
    @staticmethod
    def find(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> scala.Option[scala.runtime.Nothing.]: ...
    _flatMap__B = typing.TypeVar('_flatMap__B')  # <B>
    _flatMap__That = typing.TypeVar('_flatMap__That')  # <That>
    @staticmethod
    def flatMap(f: scala.Function1[scala.runtime.Nothing., scala.collection.GenTraversableOnce[_flatMap__B]], bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _flatMap__B, _flatMap__That]) -> _flatMap__That: ...
    @staticmethod
    def flatten(asTraversable: scala.Function1) -> scala.collection.GenTraversable: ...
    _fold__A1 = typing.TypeVar('_fold__A1')  # <A1>
    @staticmethod
    def fold(z: _fold__A1, op: scala.Function2[_fold__A1, _fold__A1, _fold__A1]) -> _fold__A1: ...
    _foldLeft__B = typing.TypeVar('_foldLeft__B')  # <B>
    @staticmethod
    def foldLeft(z: _foldLeft__B, op: scala.Function2[_foldLeft__B, scala.runtime.Nothing., _foldLeft__B]) -> _foldLeft__B: ...
    _foldRight__B = typing.TypeVar('_foldRight__B')  # <B>
    @staticmethod
    def foldRight(z: _foldRight__B, op: scala.Function2[scala.runtime.Nothing., _foldRight__B, _foldRight__B]) -> _foldRight__B: ...
    @staticmethod
    def forall(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> bool: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    @staticmethod
    def foreach(f: scala.Function1[scala.runtime.Nothing., _foreach__U]) -> None: ...
    _genericBuilder__B = typing.TypeVar('_genericBuilder__B')  # <B>
    @staticmethod
    def genericBuilder() -> scala.collection.mutable.Builder[_genericBuilder__B, 'List'[_genericBuilder__B]]: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    @staticmethod
    def groupBy(f: scala.Function1[scala.runtime.Nothing., _groupBy__K]) -> 'Map'[_groupBy__K, 'List'[scala.runtime.Nothing.]]: ...
    @staticmethod
    def grouped(size: int) -> scala.collection.Iterator['List'[scala.runtime.Nothing.]]: ...
    @staticmethod
    def hasDefiniteSize() -> bool: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def head() -> scala.runtime.Nothing.: ...
    @staticmethod
    def headOption() -> scala.Option[scala.runtime.Nothing.]: ...
    _indexOf_0__B = typing.TypeVar('_indexOf_0__B')  # <B>
    _indexOf_1__B = typing.TypeVar('_indexOf_1__B')  # <B>
    @typing.overload
    @staticmethod
    def indexOf(elem: _indexOf_0__B) -> int: ...
    @typing.overload
    @staticmethod
    def indexOf(elem: _indexOf_1__B, from_: int) -> int: ...
    _indexOfSlice_0__B = typing.TypeVar('_indexOfSlice_0__B')  # <B>
    _indexOfSlice_1__B = typing.TypeVar('_indexOfSlice_1__B')  # <B>
    @typing.overload
    @staticmethod
    def indexOfSlice(that: scala.collection.GenSeq[_indexOfSlice_0__B]) -> int: ...
    @typing.overload
    @staticmethod
    def indexOfSlice(that: scala.collection.GenSeq[_indexOfSlice_1__B], from_: int) -> int: ...
    @typing.overload
    @staticmethod
    def indexWhere(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> int: ...
    @typing.overload
    @staticmethod
    def indexWhere(p: scala.Function1[scala.runtime.Nothing., typing.Any], from_: int) -> int: ...
    @staticmethod
    def indices() -> 'Range': ...
    @staticmethod
    def init() -> typing.Any: ...
    @staticmethod
    def inits() -> scala.collection.Iterator['List'[scala.runtime.Nothing.]]: ...
    @staticmethod
    def intersect(that: scala.collection.GenSeq) -> typing.Any: ...
    @staticmethod
    def isDefinedAt(x: int) -> bool: ...
    @staticmethod
    def isEmpty() -> bool: ...
    @staticmethod
    def isTraversableAgain() -> bool: ...
    @staticmethod
    def iterator() -> scala.collection.Iterator[scala.runtime.Nothing.]: ...
    @staticmethod
    def last() -> typing.Any: ...
    _lastIndexOf_0__B = typing.TypeVar('_lastIndexOf_0__B')  # <B>
    _lastIndexOf_1__B = typing.TypeVar('_lastIndexOf_1__B')  # <B>
    @typing.overload
    @staticmethod
    def lastIndexOf(elem: _lastIndexOf_0__B) -> int: ...
    @typing.overload
    @staticmethod
    def lastIndexOf(elem: _lastIndexOf_1__B, end: int) -> int: ...
    _lastIndexOfSlice_0__B = typing.TypeVar('_lastIndexOfSlice_0__B')  # <B>
    _lastIndexOfSlice_1__B = typing.TypeVar('_lastIndexOfSlice_1__B')  # <B>
    @typing.overload
    @staticmethod
    def lastIndexOfSlice(that: scala.collection.GenSeq[_lastIndexOfSlice_0__B]) -> int: ...
    @typing.overload
    @staticmethod
    def lastIndexOfSlice(that: scala.collection.GenSeq[_lastIndexOfSlice_1__B], end: int) -> int: ...
    @typing.overload
    @staticmethod
    def lastIndexWhere(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> int: ...
    @typing.overload
    @staticmethod
    def lastIndexWhere(p: scala.Function1[scala.runtime.Nothing., typing.Any], end: int) -> int: ...
    @staticmethod
    def lastOption() -> scala.Option[scala.runtime.Nothing.]: ...
    @staticmethod
    def length() -> int: ...
    @staticmethod
    def lengthCompare(len: int) -> int: ...
    @staticmethod
    def lift() -> scala.Function1[typing.Any, scala.Option[scala.runtime.Nothing.]]: ...
    _map__B = typing.TypeVar('_map__B')  # <B>
    _map__That = typing.TypeVar('_map__That')  # <That>
    @staticmethod
    def map(f: scala.Function1[scala.runtime.Nothing., _map__B], bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _map__B, _map__That]) -> _map__That: ...
    _mapConserve__B = typing.TypeVar('_mapConserve__B')  # <B>
    @staticmethod
    def mapConserve(f: scala.Function1[scala.runtime.Nothing., _mapConserve__B]) -> 'List'[_mapConserve__B]: ...
    @staticmethod
    def max(cmp: scala.math.Ordering) -> typing.Any: ...
    @staticmethod
    def maxBy(f: scala.Function1, cmp: scala.math.Ordering) -> typing.Any: ...
    @staticmethod
    def min(cmp: scala.math.Ordering) -> typing.Any: ...
    @staticmethod
    def minBy(f: scala.Function1, cmp: scala.math.Ordering) -> typing.Any: ...
    @typing.overload
    @staticmethod
    def mkString() -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def mkString(sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def mkString(start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @staticmethod
    def nonEmpty() -> bool: ...
    _orElse__A1 = typing.TypeVar('_orElse__A1')  # <A1>
    _orElse__B1 = typing.TypeVar('_orElse__B1')  # <B1>
    @staticmethod
    def orElse(that: scala.PartialFunction[_orElse__A1, _orElse__B1]) -> scala.PartialFunction[_orElse__A1, _orElse__B1]: ...
    _padTo__B = typing.TypeVar('_padTo__B')  # <B>
    _padTo__That = typing.TypeVar('_padTo__That')  # <That>
    @staticmethod
    def padTo(len: int, elem: _padTo__B, bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _padTo__B, _padTo__That]) -> _padTo__That: ...
    @staticmethod
    def par() -> scala.collection.Parallel: ...
    @staticmethod
    def partition(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> scala.Tuple2['List'[scala.runtime.Nothing.], 'List'[scala.runtime.Nothing.]]: ...
    _patch__B = typing.TypeVar('_patch__B')  # <B>
    _patch__That = typing.TypeVar('_patch__That')  # <That>
    @staticmethod
    def patch(from_: int, patch: scala.collection.GenSeq[_patch__B], replaced: int, bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _patch__B, _patch__That]) -> _patch__That: ...
    @staticmethod
    def permutations() -> scala.collection.Iterator['List'[scala.runtime.Nothing.]]: ...
    @staticmethod
    def prefixLength(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> int: ...
    _product__B = typing.TypeVar('_product__B')  # <B>
    @staticmethod
    def product(num: scala.math.Numeric[_product__B]) -> _product__B: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    _reduce__A1 = typing.TypeVar('_reduce__A1')  # <A1>
    @staticmethod
    def reduce(op: scala.Function2[_reduce__A1, _reduce__A1, _reduce__A1]) -> _reduce__A1: ...
    _reduceLeft__B = typing.TypeVar('_reduceLeft__B')  # <B>
    @staticmethod
    def reduceLeft(op: scala.Function2[_reduceLeft__B, scala.runtime.Nothing., _reduceLeft__B]) -> _reduceLeft__B: ...
    _reduceLeftOption__B = typing.TypeVar('_reduceLeftOption__B')  # <B>
    @staticmethod
    def reduceLeftOption(op: scala.Function2[_reduceLeftOption__B, scala.runtime.Nothing., _reduceLeftOption__B]) -> scala.Option[_reduceLeftOption__B]: ...
    _reduceOption__A1 = typing.TypeVar('_reduceOption__A1')  # <A1>
    @staticmethod
    def reduceOption(op: scala.Function2[_reduceOption__A1, _reduceOption__A1, _reduceOption__A1]) -> scala.Option[_reduceOption__A1]: ...
    _reduceRight__B = typing.TypeVar('_reduceRight__B')  # <B>
    @staticmethod
    def reduceRight(op: scala.Function2[scala.runtime.Nothing., _reduceRight__B, _reduceRight__B]) -> _reduceRight__B: ...
    _reduceRightOption__B = typing.TypeVar('_reduceRightOption__B')  # <B>
    @staticmethod
    def reduceRightOption(op: scala.Function2[scala.runtime.Nothing., _reduceRightOption__B, _reduceRightOption__B]) -> scala.Option[_reduceRightOption__B]: ...
    @staticmethod
    def repr() -> typing.Any: ...
    @staticmethod
    def reverse() -> 'List'[scala.runtime.Nothing.]: ...
    @staticmethod
    def reverseIterator() -> scala.collection.Iterator[scala.runtime.Nothing.]: ...
    _reverseMap__B = typing.TypeVar('_reverseMap__B')  # <B>
    _reverseMap__That = typing.TypeVar('_reverseMap__That')  # <That>
    @staticmethod
    def reverseMap(f: scala.Function1[scala.runtime.Nothing., _reverseMap__B], bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _reverseMap__B, _reverseMap__That]) -> _reverseMap__That: ...
    _reverse_$colon$colon$colon__B = typing.TypeVar('_reverse_$colon$colon$colon__B')  # <B>
    @staticmethod
    def reverse_$colon$colon$colon(prefix: 'List'[_reverse_.colon.colon.colon__B]) -> 'List'[_reverse_.colon.colon.colon__B]: ...
    _runWith__U = typing.TypeVar('_runWith__U')  # <U>
    @staticmethod
    def runWith(action: scala.Function1[scala.runtime.Nothing., _runWith__U]) -> scala.Function1[typing.Any, typing.Any]: ...
    _sameElements__B = typing.TypeVar('_sameElements__B')  # <B>
    @staticmethod
    def sameElements(that: scala.collection.GenIterable[_sameElements__B]) -> bool: ...
    _scan__B = typing.TypeVar('_scan__B')  # <B>
    _scan__That = typing.TypeVar('_scan__That')  # <That>
    @staticmethod
    def scan(z: _scan__B, op: scala.Function2[_scan__B, _scan__B, _scan__B], cbf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _scan__B, _scan__That]) -> _scan__That: ...
    _scanLeft__B = typing.TypeVar('_scanLeft__B')  # <B>
    _scanLeft__That = typing.TypeVar('_scanLeft__That')  # <That>
    @staticmethod
    def scanLeft(z: _scanLeft__B, op: scala.Function2[_scanLeft__B, scala.runtime.Nothing., _scanLeft__B], bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _scanLeft__B, _scanLeft__That]) -> _scanLeft__That: ...
    _scanRight__B = typing.TypeVar('_scanRight__B')  # <B>
    _scanRight__That = typing.TypeVar('_scanRight__That')  # <That>
    @staticmethod
    def scanRight(z: _scanRight__B, op: scala.Function2[scala.runtime.Nothing., _scanRight__B, _scanRight__B], bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _scanRight__B, _scanRight__That]) -> _scanRight__That: ...
    @staticmethod
    def segmentLength(p: scala.Function1[scala.runtime.Nothing., typing.Any], from_: int) -> int: ...
    @staticmethod
    def seq() -> 'LinearSeq'[scala.runtime.Nothing.]: ...
    @staticmethod
    def size() -> int: ...
    @staticmethod
    def slice(from_: int, until: int) -> 'List'[scala.runtime.Nothing.]: ...
    @typing.overload
    @staticmethod
    def sliding(size: int) -> scala.collection.Iterator['List'[scala.runtime.Nothing.]]: ...
    @typing.overload
    @staticmethod
    def sliding(size: int, step: int) -> scala.collection.Iterator['List'[scala.runtime.Nothing.]]: ...
    @staticmethod
    def sortBy(f: scala.Function1, ord: scala.math.Ordering) -> typing.Any: ...
    @staticmethod
    def sortWith(lt: scala.Function2) -> typing.Any: ...
    @staticmethod
    def sorted(ord: scala.math.Ordering) -> typing.Any: ...
    @staticmethod
    def span(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> scala.Tuple2['List'[scala.runtime.Nothing.], 'List'[scala.runtime.Nothing.]]: ...
    @staticmethod
    def splitAt(n: int) -> scala.Tuple2['List'[scala.runtime.Nothing.], 'List'[scala.runtime.Nothing.]]: ...
    _startsWith_0__B = typing.TypeVar('_startsWith_0__B')  # <B>
    _startsWith_1__B = typing.TypeVar('_startsWith_1__B')  # <B>
    @typing.overload
    @staticmethod
    def startsWith(that: scala.collection.GenSeq[_startsWith_0__B]) -> bool: ...
    @typing.overload
    @staticmethod
    def startsWith(that: scala.collection.GenSeq[_startsWith_1__B], offset: int) -> bool: ...
    @staticmethod
    def stringPrefix() -> java.lang.String: ...
    _sum__B = typing.TypeVar('_sum__B')  # <B>
    @staticmethod
    def sum(num: scala.math.Numeric[_sum__B]) -> _sum__B: ...
    @staticmethod
    def tail() -> 'List'[scala.runtime.Nothing.]: ...
    @staticmethod
    def tails() -> scala.collection.Iterator['List'[scala.runtime.Nothing.]]: ...
    @staticmethod
    def take(n: int) -> 'List'[scala.runtime.Nothing.]: ...
    @staticmethod
    def takeRight(n: int) -> 'List'[scala.runtime.Nothing.]: ...
    @staticmethod
    def takeWhile(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> 'List'[scala.runtime.Nothing.]: ...
    _to__Col = typing.TypeVar('_to__Col')  # <Col>
    @staticmethod
    def to(cbf: scala.collection.generic.CanBuildFrom[scala.runtime.Nothing., scala.runtime.Nothing., _to__Col]) -> _to__Col: ...
    @staticmethod
    def toArray(evidence$1: scala.reflect.ClassTag) -> typing.Any: ...
    _toBuffer__B = typing.TypeVar('_toBuffer__B')  # <B>
    @staticmethod
    def toBuffer() -> scala.collection.mutable.Buffer[_toBuffer__B]: ...
    @staticmethod
    def toIndexedSeq() -> 'IndexedSeq'[scala.runtime.Nothing.]: ...
    @staticmethod
    def toIterable() -> scala.collection.Iterable[scala.runtime.Nothing.]: ...
    @staticmethod
    def toIterator() -> scala.collection.Iterator[scala.runtime.Nothing.]: ...
    @staticmethod
    def toList() -> 'List'[scala.runtime.Nothing.]: ...
    _toMap__T = typing.TypeVar('_toMap__T')  # <T>
    _toMap__U = typing.TypeVar('_toMap__U')  # <U>
    @staticmethod
    def toMap(ev: scala.Predef..less.colon.less[scala.runtime.Nothing., scala.Tuple2[_toMap__T, _toMap__U]]) -> 'Map'[_toMap__T, _toMap__U]: ...
    @staticmethod
    def toSeq() -> 'Seq'[scala.runtime.Nothing.]: ...
    _toSet__B = typing.TypeVar('_toSet__B')  # <B>
    @staticmethod
    def toSet() -> 'Set'[_toSet__B]: ...
    @staticmethod
    def toStream() -> 'Stream'[scala.runtime.Nothing.]: ...
    @staticmethod
    def toString() -> java.lang.String: ...
    @staticmethod
    def toTraversable() -> scala.collection.Traversable[scala.runtime.Nothing.]: ...
    @staticmethod
    def toVector() -> 'Vector'[scala.runtime.Nothing.]: ...
    @staticmethod
    def transpose(asTraversable: scala.Function1) -> scala.collection.GenTraversable: ...
    _union__B = typing.TypeVar('_union__B')  # <B>
    _union__That = typing.TypeVar('_union__That')  # <That>
    @staticmethod
    def union(that: scala.collection.GenSeq[_union__B], bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _union__B, _union__That]) -> _union__That: ...
    _unzip__A1 = typing.TypeVar('_unzip__A1')  # <A1>
    _unzip__A2 = typing.TypeVar('_unzip__A2')  # <A2>
    @staticmethod
    def unzip(asPair: scala.Function1[scala.runtime.Nothing., scala.Tuple2[_unzip__A1, _unzip__A2]]) -> scala.Tuple2['List'[_unzip__A1], 'List'[_unzip__A2]]: ...
    _unzip3__A1 = typing.TypeVar('_unzip3__A1')  # <A1>
    _unzip3__A2 = typing.TypeVar('_unzip3__A2')  # <A2>
    _unzip3__A3 = typing.TypeVar('_unzip3__A3')  # <A3>
    @staticmethod
    def unzip3(asTriple: scala.Function1[scala.runtime.Nothing., scala.Tuple3[_unzip3__A1, _unzip3__A2, _unzip3__A3]]) -> scala.Tuple3['List'[_unzip3__A1], 'List'[_unzip3__A2], 'List'[_unzip3__A3]]: ...
    _updated__B = typing.TypeVar('_updated__B')  # <B>
    _updated__That = typing.TypeVar('_updated__That')  # <That>
    @staticmethod
    def updated(index: int, elem: _updated__B, bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], _updated__B, _updated__That]) -> _updated__That: ...
    @typing.overload
    @staticmethod
    def view() -> scala.collection.SeqView[scala.runtime.Nothing., 'List'[scala.runtime.Nothing.]]: ...
    @typing.overload
    @staticmethod
    def view(from_: int, until: int) -> scala.collection.SeqView[scala.runtime.Nothing., 'List'[scala.runtime.Nothing.]]: ...
    @staticmethod
    def withFilter(p: scala.Function1[scala.runtime.Nothing., typing.Any]) -> scala.collection.generic.FilterMonadic[scala.runtime.Nothing., 'List'[scala.runtime.Nothing.]]: ...
    _zip__A1 = typing.TypeVar('_zip__A1')  # <A1>
    _zip__B = typing.TypeVar('_zip__B')  # <B>
    _zip__That = typing.TypeVar('_zip__That')  # <That>
    @staticmethod
    def zip(that: scala.collection.GenIterable[_zip__B], bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], scala.Tuple2[_zip__A1, _zip__B], _zip__That]) -> _zip__That: ...
    _zipAll__B = typing.TypeVar('_zipAll__B')  # <B>
    _zipAll__A1 = typing.TypeVar('_zipAll__A1')  # <A1>
    _zipAll__That = typing.TypeVar('_zipAll__That')  # <That>
    @staticmethod
    def zipAll(that: scala.collection.GenIterable[_zipAll__B], thisElem: _zipAll__A1, thatElem: _zipAll__B, bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], scala.Tuple2[_zipAll__A1, _zipAll__B], _zipAll__That]) -> _zipAll__That: ...
    _zipWithIndex__A1 = typing.TypeVar('_zipWithIndex__A1')  # <A1>
    _zipWithIndex__That = typing.TypeVar('_zipWithIndex__That')  # <That>
    @staticmethod
    def zipWithIndex(bf: scala.collection.generic.CanBuildFrom['List'[scala.runtime.Nothing.], scala.Tuple2[_zipWithIndex__A1, typing.Any], _zipWithIndex__That]) -> _zipWithIndex__That: ...

_Page__T = typing.TypeVar('_Page__T')  # <T>
class Page(typing.Generic[_Page__T]):
    def __init__(self, num: int, evidence$5: scala.reflect.ClassTag[_Page__T]): ...
    def addMore(self, more: scala.Function3[typing.Any, typing.Any, typing.Any, typing.Any]) -> 'Page'[_Page__T]: ...
    def apply(self, index: int) -> _Page__T: ...
    def data(self) -> typing.Any: ...
    def end(self) -> int: ...
    def filled(self) -> int: ...
    def filled_$eq(self, x$1: int) -> None: ...
    def isLast(self) -> bool: ...
    def isLast_$eq(self, x$1: bool) -> None: ...
    def later(self) -> 'Page'[_Page__T]: ...
    def later_$eq(self, x$1: 'Page'[_Page__T]) -> None: ...
    def latest(self) -> 'Page'[_Page__T]: ...
    def next(self) -> 'Page'[_Page__T]: ...
    def next_$eq(self, x$1: 'Page'[_Page__T]) -> None: ...
    def num(self) -> int: ...
    def start(self) -> int: ...

_PagedSeq__T = typing.TypeVar('_PagedSeq__T')  # <T>
class PagedSeq(scala.collection.AbstractSeq[_PagedSeq__T], scala.collection.IndexedSeq[_PagedSeq__T], typing.Generic[_PagedSeq__T]):
    @typing.overload
    def __init__(self, more: scala.Function3[typing.Any, typing.Any, typing.Any, typing.Any], first1: Page[_PagedSeq__T], start: int, end: int, evidence$3: scala.reflect.ClassTag[_PagedSeq__T]): ...
    @typing.overload
    def __init__(self, more: scala.Function3[typing.Any, typing.Any, typing.Any, typing.Any], evidence$4: scala.reflect.ClassTag[_PagedSeq__T]): ...
    @staticmethod
    def UndeterminedEnd() -> int: ...
    def apply(self, index: int) -> _PagedSeq__T: ...
    def companion(self) -> scala.collection.generic.GenericCompanion[scala.collection.IndexedSeq]: ...
    @typing.overload
    @staticmethod
    def fromFile(source: typing.Union[java.io.File, jpype.protocol.SupportsPath]) -> 'PagedSeq'[typing.Any]: ...
    @typing.overload
    @staticmethod
    def fromFile(source: typing.Union[java.lang.String, str]) -> 'PagedSeq'[typing.Any]: ...
    _fromIterable__T = typing.TypeVar('_fromIterable__T')  # <T>
    @staticmethod
    def fromIterable(source: 'Iterable'[_fromIterable__T], evidence$2: scala.reflect.ClassTag[_fromIterable__T]) -> 'PagedSeq'[_fromIterable__T]: ...
    _fromIterator__T = typing.TypeVar('_fromIterator__T')  # <T>
    @staticmethod
    def fromIterator(source: scala.collection.Iterator[_fromIterator__T], evidence$1: scala.reflect.ClassTag[_fromIterator__T]) -> 'PagedSeq'[_fromIterator__T]: ...
    @typing.overload
    @staticmethod
    def fromLines(source: scala.collection.Iterator[typing.Union[java.lang.String, str]]) -> 'PagedSeq'[typing.Any]: ...
    @typing.overload
    @staticmethod
    def fromLines(source: 'Iterable'[typing.Union[java.lang.String, str]]) -> 'PagedSeq'[typing.Any]: ...
    @staticmethod
    def fromReader(source: java.io.Reader) -> 'PagedSeq'[typing.Any]: ...
    @staticmethod
    def fromSource(source: scala.io.Source) -> 'PagedSeq'[typing.Any]: ...
    @typing.overload
    @staticmethod
    def fromStrings(source: scala.collection.Iterator[typing.Union[java.lang.String, str]]) -> 'PagedSeq'[typing.Any]: ...
    @typing.overload
    @staticmethod
    def fromStrings(source: 'Iterable'[typing.Union[java.lang.String, str]]) -> 'PagedSeq'[typing.Any]: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[typing.Any, _groupBy__K]) -> 'Map'[_groupBy__K, scala.collection.Traversable[typing.Any]]: ...
    def hashCode(self) -> int: ...
    def isDefinedAt(self, index: int) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[_PagedSeq__T]: ...
    def length(self) -> int: ...
    def seq(self) -> scala.collection.IndexedSeq[_PagedSeq__T]: ...
    def sizeHintIfCheap(self) -> int: ...
    @typing.overload
    def slice(self, start: int) -> 'PagedSeq'[_PagedSeq__T]: ...
    @typing.overload
    def slice(self, _start: int, _end: int) -> 'PagedSeq'[_PagedSeq__T]: ...
    def thisCollection(self) -> scala.collection.IndexedSeq[_PagedSeq__T]: ...
    _toBuffer__A1 = typing.TypeVar('_toBuffer__A1')  # <A1>
    def toBuffer(self) -> scala.collection.mutable.Buffer[_toBuffer__A1]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.IndexedSeq: ...
    def toIterable(self) -> scala.collection.Iterable[typing.Any]: ...
    def toSeq(self) -> scala.collection.Seq[typing.Any]: ...
    def toString(self) -> java.lang.String: ...
    def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
    @typing.overload
    def view(self) -> scala.collection.SeqView[typing.Any, scala.collection.Seq[typing.Any]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.SeqView[typing.Any, scala.collection.Seq[typing.Any]]: ...

_StreamIterator__A = typing.TypeVar('_StreamIterator__A')  # <A>
class StreamIterator(scala.collection.AbstractIterator[_StreamIterator__A], typing.Generic[_StreamIterator__A]):
    def __init__(self, self): ...
    def hasNext(self) -> bool: ...
    def next(self) -> _StreamIterator__A: ...
    def toList(self) -> 'List'[_StreamIterator__A]: ...
    def toStream(self) -> 'Stream'[_StreamIterator__A]: ...
    class LazyCell:
        $outer: 'StreamIterator' = ...
        def __init__(self, $outer: 'StreamIterator', st: scala.Function0['Stream'[_StreamIterator__A]]): ...
        def v(self) -> 'Stream'[_StreamIterator__A]: ...

_StringLike__Repr = typing.TypeVar('_StringLike__Repr')  # <Repr>
class StringLike(scala.collection.IndexedSeqOptimized[typing.Any, _StringLike__Repr], scala.math.Ordered[java.lang.String], typing.Generic[_StringLike__Repr]):
    @staticmethod
    def $init$($this: 'StringLike') -> None: ...
    def $times(self, n: int) -> java.lang.String: ...
    @typing.overload
    def apply(self, idx: int) -> typing.Any: ...
    @typing.overload
    def apply(self, n: int) -> str: ...
    def capitalize(self) -> java.lang.String: ...
    @typing.overload
    def compare(self, that: typing.Any) -> int: ...
    @typing.overload
    def compare(self, other: typing.Union[java.lang.String, str]) -> int: ...
    def equals(self, that: typing.Any) -> bool: ...
    def format(self, args: scala.collection.Seq[typing.Any]) -> java.lang.String: ...
    def formatLocal(self, l: java.util.Locale, args: scala.collection.Seq[typing.Any]) -> java.lang.String: ...
    def hashCode(self) -> int: ...
    def length(self) -> int: ...
    def lines(self) -> scala.collection.Iterator[java.lang.String]: ...
    def linesIterator(self) -> scala.collection.Iterator[java.lang.String]: ...
    def linesWithSeparators(self) -> scala.collection.Iterator[java.lang.String]: ...
    @typing.overload
    def mkString(self, sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def mkString(self, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def mkString(self) -> java.lang.String: ...
    def newBuilder(self) -> scala.collection.mutable.Builder[typing.Any, _StringLike__Repr]: ...
    @typing.overload
    def r(self) -> scala.util.matching.Regex: ...
    @typing.overload
    def r(self, groupNames: scala.collection.Seq[typing.Union[java.lang.String, str]]) -> scala.util.matching.Regex: ...
    def replaceAllLiterally(self, literal: typing.Union[java.lang.String, str], replacement: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def scala$collection$immutable$StringLike$$isLineBreak(self, c: str) -> bool: ...
    def slice(self, from_: int, until: int) -> _StringLike__Repr: ...
    @typing.overload
    def split(self, separator: str) -> typing.List[java.lang.String]: ...
    @typing.overload
    def split(self, separators: typing.List[str]) -> typing.List[java.lang.String]: ...
    def stripLineEnd(self) -> java.lang.String: ...
    @typing.overload
    def stripMargin(self) -> java.lang.String: ...
    @typing.overload
    def stripMargin(self, marginChar: str) -> java.lang.String: ...
    def stripPrefix(self, prefix: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def stripSuffix(self, suffix: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    _toArray__B = typing.TypeVar('_toArray__B')  # <B>
    def toArray(self, evidence$1: scala.reflect.ClassTag[_toArray__B]) -> typing.Any: ...
    def toBoolean(self) -> bool: ...
    def toByte(self) -> int: ...
    def toDouble(self) -> float: ...
    def toFloat(self) -> float: ...
    def toInt(self) -> int: ...
    def toLong(self) -> int: ...
    def toShort(self) -> int: ...
    def toString(self) -> java.lang.String: ...

_Traversable__A = typing.TypeVar('_Traversable__A')  # <A>
class Traversable(scala.collection.Traversable[_Traversable__A], scala.Immutable, typing.Generic[_Traversable__A]):
    @staticmethod
    def $init$($this: 'Traversable') -> None: ...
    @staticmethod
    def ReusableCBF() -> scala.collection.generic.GenTraversableFactory.GenericCanBuildFrom[scala.runtime.Nothing.]: ...
    @staticmethod
    def apply(elems: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['Traversable'[typing.Any], _canBuildFrom__A, 'Traversable'[_canBuildFrom__A]]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['Traversable']: ...
    @staticmethod
    def concat(xss: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    @staticmethod
    def empty() -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, n5: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @staticmethod
    def iterate(start: typing.Any, len: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, step: typing.Any, evidence$2: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, evidence$1: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_Traversable__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_Traversable__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Traversable[_Traversable__A]: ...
    @typing.overload
    def seq(self) -> 'Traversable'[_Traversable__A]: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, n5: int, f: scala.Function5) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, f: scala.Function4) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, f: scala.Function3) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, f: scala.Function2) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def toString(self) -> java.lang.String: ...

_VectorPointer__T = typing.TypeVar('_VectorPointer__T')  # <T>
class VectorPointer(typing.Generic[_VectorPointer__T]):
    @staticmethod
    def $init$($this: 'VectorPointer') -> None: ...
    def copyOf(self, a: typing.List[typing.Any]) -> typing.List[typing.Any]: ...
    def copyRange(self, array: typing.List[typing.Any], oldLeft: int, newLeft: int) -> typing.List[typing.Any]: ...
    def depth(self) -> int: ...
    def depth_$eq(self, x$1: int) -> None: ...
    def display0(self) -> typing.List[typing.Any]: ...
    def display0_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display1(self) -> typing.List[typing.Any]: ...
    def display1_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display2(self) -> typing.List[typing.Any]: ...
    def display2_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display3(self) -> typing.List[typing.Any]: ...
    def display3_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display4(self) -> typing.List[typing.Any]: ...
    def display4_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display5(self) -> typing.List[typing.Any]: ...
    def display5_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def getElem(self, index: int, xor: int) -> _VectorPointer__T: ...
    def gotoFreshPosWritable0(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    def gotoFreshPosWritable1(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    def gotoNextBlockStart(self, index: int, xor: int) -> None: ...
    def gotoNextBlockStartWritable(self, index: int, xor: int) -> None: ...
    def gotoPos(self, index: int, xor: int) -> None: ...
    def gotoPosWritable0(self, newIndex: int, xor: int) -> None: ...
    def gotoPosWritable1(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    _initFrom_0__U = typing.TypeVar('_initFrom_0__U')  # <U>
    _initFrom_1__U = typing.TypeVar('_initFrom_1__U')  # <U>
    @typing.overload
    def initFrom(self, that: 'VectorPointer'[_initFrom_0__U]) -> None: ...
    @typing.overload
    def initFrom(self, that: 'VectorPointer'[_initFrom_1__U], depth: int) -> None: ...
    def nullSlotAndCopy(self, array: typing.List[typing.Any], index: int) -> typing.List[typing.Any]: ...
    def stabilize(self, index: int) -> None: ...

_IntMapEntryIterator__V = typing.TypeVar('_IntMapEntryIterator__V')  # <V>
class IntMapEntryIterator(IntMapIterator[_IntMapEntryIterator__V, scala.Tuple2[typing.Any, _IntMapEntryIterator__V]], typing.Generic[_IntMapEntryIterator__V]):
    def __init__(self, it: 'IntMap'[_IntMapEntryIterator__V]): ...
    def valueOf(self, tip: 'IntMap.Tip'[_IntMapEntryIterator__V]) -> scala.Tuple2[typing.Any, _IntMapEntryIterator__V]: ...

_IntMapKeyIterator__V = typing.TypeVar('_IntMapKeyIterator__V')  # <V>
class IntMapKeyIterator(IntMapIterator[_IntMapKeyIterator__V, typing.Any], typing.Generic[_IntMapKeyIterator__V]):
    def __init__(self, it: 'IntMap'[_IntMapKeyIterator__V]): ...
    def valueOf(self, tip: 'IntMap.Tip'[_IntMapKeyIterator__V]) -> int: ...

_IntMapValueIterator__V = typing.TypeVar('_IntMapValueIterator__V')  # <V>
class IntMapValueIterator(IntMapIterator[_IntMapValueIterator__V, _IntMapValueIterator__V], typing.Generic[_IntMapValueIterator__V]):
    def __init__(self, it: 'IntMap'[_IntMapValueIterator__V]): ...
    def valueOf(self, tip: 'IntMap.Tip'[_IntMapValueIterator__V]) -> _IntMapValueIterator__V: ...

_Iterable__A = typing.TypeVar('_Iterable__A')  # <A>
class Iterable(Traversable[_Iterable__A], scala.collection.Iterable[_Iterable__A], typing.Generic[_Iterable__A]):
    @staticmethod
    def $init$($this: 'Iterable') -> None: ...
    @staticmethod
    def ReusableCBF() -> scala.collection.generic.GenTraversableFactory.GenericCanBuildFrom[scala.runtime.Nothing.]: ...
    @staticmethod
    def apply(elems: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['Iterable'[typing.Any], _canBuildFrom__A, 'Iterable'[_canBuildFrom__A]]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['Iterable']: ...
    @staticmethod
    def concat(xss: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    @staticmethod
    def empty() -> scala.collection.GenTraversable: ...
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, n5: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @staticmethod
    def iterate(start: typing.Any, len: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_Iterable__A, scala.collection.parallel.immutable.ParIterable[_Iterable__A]]: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, step: typing.Any, evidence$2: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, evidence$1: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_Iterable__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_Iterable__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Iterable[_Iterable__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Traversable[_Iterable__A]: ...
    @typing.overload
    def seq(self) -> 'Iterable'[_Iterable__A]: ...
    @typing.overload
    def seq(self) -> Traversable[_Iterable__A]: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, n5: int, f: scala.Function5) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, f: scala.Function4) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, f: scala.Function3) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, f: scala.Function2) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def toString(self) -> java.lang.String: ...

_LongMapEntryIterator__V = typing.TypeVar('_LongMapEntryIterator__V')  # <V>
class LongMapEntryIterator(LongMapIterator[_LongMapEntryIterator__V, scala.Tuple2[typing.Any, _LongMapEntryIterator__V]], typing.Generic[_LongMapEntryIterator__V]):
    def __init__(self, it: 'LongMap'[_LongMapEntryIterator__V]): ...
    def valueOf(self, tip: 'LongMap.Tip'[_LongMapEntryIterator__V]) -> scala.Tuple2[typing.Any, _LongMapEntryIterator__V]: ...

_LongMapKeyIterator__V = typing.TypeVar('_LongMapKeyIterator__V')  # <V>
class LongMapKeyIterator(LongMapIterator[_LongMapKeyIterator__V, typing.Any], typing.Generic[_LongMapKeyIterator__V]):
    def __init__(self, it: 'LongMap'[_LongMapKeyIterator__V]): ...
    def valueOf(self, tip: 'LongMap.Tip'[_LongMapKeyIterator__V]) -> int: ...

_LongMapValueIterator__V = typing.TypeVar('_LongMapValueIterator__V')  # <V>
class LongMapValueIterator(LongMapIterator[_LongMapValueIterator__V, _LongMapValueIterator__V], typing.Generic[_LongMapValueIterator__V]):
    def __init__(self, it: 'LongMap'[_LongMapValueIterator__V]): ...
    def valueOf(self, tip: 'LongMap.Tip'[_LongMapValueIterator__V]) -> _LongMapValueIterator__V: ...

class StringOps(StringLike[java.lang.String]):
    def __init__(self, repr: typing.Union[java.lang.String, str]): ...
    _$colon$bslash__B = typing.TypeVar('_$colon$bslash__B')  # <B>
    def $colon$bslash(self, z: _.colon.bslash__B, op: scala.Function2[typing.Any, _.colon.bslash__B, _.colon.bslash__B]) -> _.colon.bslash__B: ...
    _$colon$plus__B = typing.TypeVar('_$colon$plus__B')  # <B>
    _$colon$plus__That = typing.TypeVar('_$colon$plus__That')  # <That>
    def $colon$plus(self, elem: _.colon.plus__B, bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _.colon.plus__B, _.colon.plus__That]) -> _.colon.plus__That: ...
    _$div$colon__B = typing.TypeVar('_$div$colon__B')  # <B>
    def $div$colon(self, z: _.div.colon__B, op: scala.Function2[_.div.colon__B, typing.Any, _.div.colon__B]) -> _.div.colon__B: ...
    def $greater(self, that: typing.Any) -> bool: ...
    def $greater$eq(self, that: typing.Any) -> bool: ...
    def $less(self, that: typing.Any) -> bool: ...
    def $less$eq(self, that: typing.Any) -> bool: ...
    _$plus$colon__B = typing.TypeVar('_$plus$colon__B')  # <B>
    _$plus$colon__That = typing.TypeVar('_$plus$colon__That')  # <That>
    def $plus$colon(self, elem: _.plus.colon__B, bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _.plus.colon__B, _.plus.colon__That]) -> _.plus.colon__That: ...
    _$plus$plus__B = typing.TypeVar('_$plus$plus__B')  # <B>
    _$plus$plus__That = typing.TypeVar('_$plus$plus__That')  # <That>
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus__B], bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _.plus.plus__B, _.plus.plus__That]) -> _.plus.plus__That: ...
    _$plus$plus$colon_0__B = typing.TypeVar('_$plus$plus$colon_0__B')  # <B>
    _$plus$plus$colon_0__That = typing.TypeVar('_$plus$plus$colon_0__That')  # <That>
    _$plus$plus$colon_1__B = typing.TypeVar('_$plus$plus$colon_1__B')  # <B>
    _$plus$plus$colon_1__That = typing.TypeVar('_$plus$plus$colon_1__That')  # <That>
    @typing.overload
    def $plus$plus$colon(self, that: scala.collection.Traversable[_.plus.plus.colon_0__B], bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _.plus.plus.colon_0__B, _.plus.plus.colon_0__That]) -> _.plus.plus.colon_0__That: ...
    @typing.overload
    def $plus$plus$colon(self, that: scala.collection.TraversableOnce[_.plus.plus.colon_1__B], bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _.plus.plus.colon_1__B, _.plus.plus.colon_1__That]) -> _.plus.plus.colon_1__That: ...
    def $times(self, n: int) -> java.lang.String: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder, sep: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    _aggregate__B = typing.TypeVar('_aggregate__B')  # <B>
    def aggregate(self, z: scala.Function0[_aggregate__B], seqop: scala.Function2[_aggregate__B, typing.Any, _aggregate__B], combop: scala.Function2[_aggregate__B, _aggregate__B, _aggregate__B]) -> _aggregate__B: ...
    def apply(self, index: int) -> str: ...
    @staticmethod
    def apply$extension($this: typing.Union[java.lang.String, str], index: int) -> str: ...
    def canEqual(self, that: typing.Any) -> bool: ...
    def capitalize(self) -> java.lang.String: ...
    _collect__B = typing.TypeVar('_collect__B')  # <B>
    _collect__That = typing.TypeVar('_collect__That')  # <That>
    def collect(self, pf: scala.PartialFunction[typing.Any, _collect__B], bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _collect__B, _collect__That]) -> _collect__That: ...
    _collectFirst__B = typing.TypeVar('_collectFirst__B')  # <B>
    def collectFirst(self, pf: scala.PartialFunction[typing.Any, _collectFirst__B]) -> scala.Option[_collectFirst__B]: ...
    def combinations(self, n: int) -> scala.collection.Iterator[java.lang.String]: ...
    def compare(self, other: typing.Union[java.lang.String, str]) -> int: ...
    def compareTo(self, that: typing.Any) -> int: ...
    _contains__A1 = typing.TypeVar('_contains__A1')  # <A1>
    def contains(self, elem: _contains__A1) -> bool: ...
    _containsSlice__B = typing.TypeVar('_containsSlice__B')  # <B>
    def containsSlice(self, that: scala.collection.GenSeq[_containsSlice__B]) -> bool: ...
    _copyToArray_0__B = typing.TypeVar('_copyToArray_0__B')  # <B>
    _copyToArray_1__B = typing.TypeVar('_copyToArray_1__B')  # <B>
    _copyToArray_2__B = typing.TypeVar('_copyToArray_2__B')  # <B>
    @typing.overload
    def copyToArray(self, xs: typing.Any) -> None: ...
    @typing.overload
    def copyToArray(self, xs: typing.Any, start: int) -> None: ...
    @typing.overload
    def copyToArray(self, xs: typing.Any, start: int, len: int) -> None: ...
    _copyToBuffer__B = typing.TypeVar('_copyToBuffer__B')  # <B>
    def copyToBuffer(self, dest: scala.collection.mutable.Buffer[_copyToBuffer__B]) -> None: ...
    _corresponds__B = typing.TypeVar('_corresponds__B')  # <B>
    def corresponds(self, that: scala.collection.GenSeq[_corresponds__B], p: scala.Function2[typing.Any, _corresponds__B, typing.Any]) -> bool: ...
    def count(self, p: scala.Function1[typing.Any, typing.Any]) -> int: ...
    def diff(self, that: scala.collection.GenSeq) -> typing.Any: ...
    def distinct(self) -> typing.Any: ...
    def drop(self, n: int) -> typing.Any: ...
    def dropRight(self, n: int) -> typing.Any: ...
    def dropWhile(self, p: scala.Function1) -> typing.Any: ...
    _endsWith__B = typing.TypeVar('_endsWith__B')  # <B>
    def endsWith(self, that: scala.collection.GenSeq[_endsWith__B]) -> bool: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    @staticmethod
    def equals$extension($this: typing.Union[java.lang.String, str], x$1: typing.Any) -> bool: ...
    def exists(self, p: scala.Function1[typing.Any, typing.Any]) -> bool: ...
    def filter(self, p: scala.Function1) -> typing.Any: ...
    def filterImpl(self, p: scala.Function1, isFlipped: bool) -> typing.Any: ...
    def filterNot(self, p: scala.Function1) -> typing.Any: ...
    def find(self, p: scala.Function1[typing.Any, typing.Any]) -> scala.Option[typing.Any]: ...
    _flatMap__B = typing.TypeVar('_flatMap__B')  # <B>
    _flatMap__That = typing.TypeVar('_flatMap__That')  # <That>
    def flatMap(self, f: scala.Function1[typing.Any, scala.collection.GenTraversableOnce[_flatMap__B]], bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _flatMap__B, _flatMap__That]) -> _flatMap__That: ...
    _fold__A1 = typing.TypeVar('_fold__A1')  # <A1>
    def fold(self, z: _fold__A1, op: scala.Function2[_fold__A1, _fold__A1, _fold__A1]) -> _fold__A1: ...
    _foldLeft__B = typing.TypeVar('_foldLeft__B')  # <B>
    def foldLeft(self, z: _foldLeft__B, op: scala.Function2[_foldLeft__B, typing.Any, _foldLeft__B]) -> _foldLeft__B: ...
    _foldRight__B = typing.TypeVar('_foldRight__B')  # <B>
    def foldRight(self, z: _foldRight__B, op: scala.Function2[typing.Any, _foldRight__B, _foldRight__B]) -> _foldRight__B: ...
    def forall(self, p: scala.Function1[typing.Any, typing.Any]) -> bool: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[typing.Any, _foreach__U]) -> None: ...
    def format(self, args: scala.collection.Seq[typing.Any]) -> java.lang.String: ...
    def formatLocal(self, l: java.util.Locale, args: scala.collection.Seq[typing.Any]) -> java.lang.String: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[typing.Any, _groupBy__K]) -> 'Map'[_groupBy__K, java.lang.String]: ...
    def grouped(self, size: int) -> scala.collection.Iterator[java.lang.String]: ...
    def hasDefiniteSize(self) -> bool: ...
    def hashCode(self) -> int: ...
    @staticmethod
    def hashCode$extension($this: typing.Union[java.lang.String, str]) -> int: ...
    def head(self) -> typing.Any: ...
    def headOption(self) -> scala.Option[typing.Any]: ...
    _indexOf_0__B = typing.TypeVar('_indexOf_0__B')  # <B>
    _indexOf_1__B = typing.TypeVar('_indexOf_1__B')  # <B>
    @typing.overload
    def indexOf(self, elem: _indexOf_0__B) -> int: ...
    @typing.overload
    def indexOf(self, elem: _indexOf_1__B, from_: int) -> int: ...
    _indexOfSlice_0__B = typing.TypeVar('_indexOfSlice_0__B')  # <B>
    _indexOfSlice_1__B = typing.TypeVar('_indexOfSlice_1__B')  # <B>
    @typing.overload
    def indexOfSlice(self, that: scala.collection.GenSeq[_indexOfSlice_0__B]) -> int: ...
    @typing.overload
    def indexOfSlice(self, that: scala.collection.GenSeq[_indexOfSlice_1__B], from_: int) -> int: ...
    @typing.overload
    def indexWhere(self, p: scala.Function1[typing.Any, typing.Any]) -> int: ...
    @typing.overload
    def indexWhere(self, p: scala.Function1[typing.Any, typing.Any], from_: int) -> int: ...
    def indices(self) -> 'Range': ...
    def init(self) -> typing.Any: ...
    def inits(self) -> scala.collection.Iterator[java.lang.String]: ...
    def intersect(self, that: scala.collection.GenSeq) -> typing.Any: ...
    def isDefinedAt(self, idx: int) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isTraversableAgain(self) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def last(self) -> typing.Any: ...
    _lastIndexOf_0__B = typing.TypeVar('_lastIndexOf_0__B')  # <B>
    _lastIndexOf_1__B = typing.TypeVar('_lastIndexOf_1__B')  # <B>
    @typing.overload
    def lastIndexOf(self, elem: _lastIndexOf_0__B) -> int: ...
    @typing.overload
    def lastIndexOf(self, elem: _lastIndexOf_1__B, end: int) -> int: ...
    _lastIndexOfSlice_0__B = typing.TypeVar('_lastIndexOfSlice_0__B')  # <B>
    _lastIndexOfSlice_1__B = typing.TypeVar('_lastIndexOfSlice_1__B')  # <B>
    @typing.overload
    def lastIndexOfSlice(self, that: scala.collection.GenSeq[_lastIndexOfSlice_0__B]) -> int: ...
    @typing.overload
    def lastIndexOfSlice(self, that: scala.collection.GenSeq[_lastIndexOfSlice_1__B], end: int) -> int: ...
    @typing.overload
    def lastIndexWhere(self, p: scala.Function1[typing.Any, typing.Any]) -> int: ...
    @typing.overload
    def lastIndexWhere(self, p: scala.Function1[typing.Any, typing.Any], end: int) -> int: ...
    def lastOption(self) -> scala.Option[typing.Any]: ...
    def length(self) -> int: ...
    @staticmethod
    def length$extension($this: typing.Union[java.lang.String, str]) -> int: ...
    def lengthCompare(self, len: int) -> int: ...
    def lines(self) -> scala.collection.Iterator[java.lang.String]: ...
    def linesIterator(self) -> scala.collection.Iterator[java.lang.String]: ...
    def linesWithSeparators(self) -> scala.collection.Iterator[java.lang.String]: ...
    _map__B = typing.TypeVar('_map__B')  # <B>
    _map__That = typing.TypeVar('_map__That')  # <That>
    def map(self, f: scala.Function1[typing.Any, _map__B], bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _map__B, _map__That]) -> _map__That: ...
    def max(self, cmp: scala.math.Ordering) -> typing.Any: ...
    def maxBy(self, f: scala.Function1, cmp: scala.math.Ordering) -> typing.Any: ...
    def min(self, cmp: scala.math.Ordering) -> typing.Any: ...
    def minBy(self, f: scala.Function1, cmp: scala.math.Ordering) -> typing.Any: ...
    @typing.overload
    def mkString(self) -> java.lang.String: ...
    @typing.overload
    def mkString(self, sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def mkString(self, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def newBuilder(self) -> scala.collection.mutable.StringBuilder: ...
    @staticmethod
    def newBuilder$extension($this: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    def nonEmpty(self) -> bool: ...
    _padTo__B = typing.TypeVar('_padTo__B')  # <B>
    _padTo__That = typing.TypeVar('_padTo__That')  # <That>
    def padTo(self, len: int, elem: _padTo__B, bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _padTo__B, _padTo__That]) -> _padTo__That: ...
    def par(self) -> scala.collection.Parallel: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[typing.Any, scala.collection.parallel.ParSeq[typing.Any]]: ...
    def partition(self, p: scala.Function1[typing.Any, typing.Any]) -> scala.Tuple2[java.lang.String, java.lang.String]: ...
    _patch__B = typing.TypeVar('_patch__B')  # <B>
    _patch__That = typing.TypeVar('_patch__That')  # <That>
    def patch(self, from_: int, patch: scala.collection.GenSeq[_patch__B], replaced: int, bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _patch__B, _patch__That]) -> _patch__That: ...
    def permutations(self) -> scala.collection.Iterator[java.lang.String]: ...
    def prefixLength(self, p: scala.Function1[typing.Any, typing.Any]) -> int: ...
    _product__B = typing.TypeVar('_product__B')  # <B>
    def product(self, num: scala.math.Numeric[_product__B]) -> _product__B: ...
    @typing.overload
    def r(self) -> scala.util.matching.Regex: ...
    @typing.overload
    def r(self, groupNames: scala.collection.Seq[typing.Union[java.lang.String, str]]) -> scala.util.matching.Regex: ...
    _reduce__A1 = typing.TypeVar('_reduce__A1')  # <A1>
    def reduce(self, op: scala.Function2[_reduce__A1, _reduce__A1, _reduce__A1]) -> _reduce__A1: ...
    _reduceLeft__B = typing.TypeVar('_reduceLeft__B')  # <B>
    def reduceLeft(self, op: scala.Function2[_reduceLeft__B, typing.Any, _reduceLeft__B]) -> _reduceLeft__B: ...
    _reduceLeftOption__B = typing.TypeVar('_reduceLeftOption__B')  # <B>
    def reduceLeftOption(self, op: scala.Function2[_reduceLeftOption__B, typing.Any, _reduceLeftOption__B]) -> scala.Option[_reduceLeftOption__B]: ...
    _reduceOption__A1 = typing.TypeVar('_reduceOption__A1')  # <A1>
    def reduceOption(self, op: scala.Function2[_reduceOption__A1, _reduceOption__A1, _reduceOption__A1]) -> scala.Option[_reduceOption__A1]: ...
    _reduceRight__B = typing.TypeVar('_reduceRight__B')  # <B>
    def reduceRight(self, op: scala.Function2[typing.Any, _reduceRight__B, _reduceRight__B]) -> _reduceRight__B: ...
    _reduceRightOption__B = typing.TypeVar('_reduceRightOption__B')  # <B>
    def reduceRightOption(self, op: scala.Function2[typing.Any, _reduceRightOption__B, _reduceRightOption__B]) -> scala.Option[_reduceRightOption__B]: ...
    def replaceAllLiterally(self, literal: typing.Union[java.lang.String, str], replacement: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def repr(self) -> java.lang.String: ...
    def reverse(self) -> typing.Any: ...
    def reverseIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    _reverseMap__B = typing.TypeVar('_reverseMap__B')  # <B>
    _reverseMap__That = typing.TypeVar('_reverseMap__That')  # <That>
    def reverseMap(self, f: scala.Function1[typing.Any, _reverseMap__B], bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _reverseMap__B, _reverseMap__That]) -> _reverseMap__That: ...
    def reversed(self) -> 'List'[typing.Any]: ...
    _sameElements__B = typing.TypeVar('_sameElements__B')  # <B>
    def sameElements(self, that: scala.collection.GenIterable[_sameElements__B]) -> bool: ...
    _scan__B = typing.TypeVar('_scan__B')  # <B>
    _scan__That = typing.TypeVar('_scan__That')  # <That>
    def scan(self, z: _scan__B, op: scala.Function2[_scan__B, _scan__B, _scan__B], cbf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _scan__B, _scan__That]) -> _scan__That: ...
    _scanLeft__B = typing.TypeVar('_scanLeft__B')  # <B>
    _scanLeft__That = typing.TypeVar('_scanLeft__That')  # <That>
    def scanLeft(self, z: _scanLeft__B, op: scala.Function2[_scanLeft__B, typing.Any, _scanLeft__B], bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _scanLeft__B, _scanLeft__That]) -> _scanLeft__That: ...
    _scanRight__B = typing.TypeVar('_scanRight__B')  # <B>
    _scanRight__That = typing.TypeVar('_scanRight__That')  # <That>
    def scanRight(self, z: _scanRight__B, op: scala.Function2[typing.Any, _scanRight__B, _scanRight__B], bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _scanRight__B, _scanRight__That]) -> _scanRight__That: ...
    def segmentLength(self, p: scala.Function1[typing.Any, typing.Any], from_: int) -> int: ...
    def seq(self) -> 'WrappedString': ...
    @staticmethod
    def seq$extension($this: typing.Union[java.lang.String, str]) -> 'WrappedString': ...
    def size(self) -> int: ...
    def sizeHintIfCheap(self) -> int: ...
    def slice(self, from_: int, until: int) -> java.lang.String: ...
    @staticmethod
    def slice$extension($this: typing.Union[java.lang.String, str], from_: int, until: int) -> java.lang.String: ...
    def sliceWithKnownBound(self, from_: int, until: int) -> typing.Any: ...
    def sliceWithKnownDelta(self, from_: int, until: int, delta: int) -> typing.Any: ...
    @typing.overload
    def sliding(self, size: int) -> scala.collection.Iterator[java.lang.String]: ...
    @typing.overload
    def sliding(self, size: int, step: int) -> scala.collection.Iterator[java.lang.String]: ...
    def sortBy(self, f: scala.Function1, ord: scala.math.Ordering) -> typing.Any: ...
    def sortWith(self, lt: scala.Function2) -> typing.Any: ...
    def sorted(self, ord: scala.math.Ordering) -> typing.Any: ...
    def span(self, p: scala.Function1[typing.Any, typing.Any]) -> scala.Tuple2[java.lang.String, java.lang.String]: ...
    @typing.overload
    def split(self, separator: str) -> typing.List[java.lang.String]: ...
    @typing.overload
    def split(self, separators: typing.List[str]) -> typing.List[java.lang.String]: ...
    def splitAt(self, n: int) -> scala.Tuple2[java.lang.String, java.lang.String]: ...
    _startsWith_0__B = typing.TypeVar('_startsWith_0__B')  # <B>
    _startsWith_1__B = typing.TypeVar('_startsWith_1__B')  # <B>
    @typing.overload
    def startsWith(self, that: scala.collection.GenSeq[_startsWith_0__B]) -> bool: ...
    @typing.overload
    def startsWith(self, that: scala.collection.GenSeq[_startsWith_1__B], offset: int) -> bool: ...
    def stringPrefix(self) -> java.lang.String: ...
    def stripLineEnd(self) -> java.lang.String: ...
    @typing.overload
    def stripMargin(self) -> java.lang.String: ...
    @typing.overload
    def stripMargin(self, marginChar: str) -> java.lang.String: ...
    def stripPrefix(self, prefix: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def stripSuffix(self, suffix: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    _sum__B = typing.TypeVar('_sum__B')  # <B>
    def sum(self, num: scala.math.Numeric[_sum__B]) -> _sum__B: ...
    def tail(self) -> typing.Any: ...
    def tails(self) -> scala.collection.Iterator[java.lang.String]: ...
    def take(self, n: int) -> typing.Any: ...
    def takeRight(self, n: int) -> typing.Any: ...
    def takeWhile(self, p: scala.Function1) -> typing.Any: ...
    def thisCollection(self) -> 'WrappedString': ...
    @staticmethod
    def thisCollection$extension($this: typing.Union[java.lang.String, str]) -> 'WrappedString': ...
    _to__Col = typing.TypeVar('_to__Col')  # <Col>
    def to(self, cbf: scala.collection.generic.CanBuildFrom[scala.runtime.Nothing., typing.Any, _to__Col]) -> _to__Col: ...
    _toArray__B = typing.TypeVar('_toArray__B')  # <B>
    def toArray(self, evidence$1: scala.reflect.ClassTag[_toArray__B]) -> typing.Any: ...
    def toBoolean(self) -> bool: ...
    _toBuffer__A1 = typing.TypeVar('_toBuffer__A1')  # <A1>
    def toBuffer(self) -> scala.collection.mutable.Buffer[_toBuffer__A1]: ...
    def toByte(self) -> int: ...
    def toCollection(self, repr: typing.Union[java.lang.String, str]) -> 'WrappedString': ...
    @staticmethod
    def toCollection$extension($this: typing.Union[java.lang.String, str], repr: typing.Union[java.lang.String, str]) -> 'WrappedString': ...
    def toDouble(self) -> float: ...
    def toFloat(self) -> float: ...
    def toIndexedSeq(self) -> 'IndexedSeq'[typing.Any]: ...
    def toInt(self) -> int: ...
    def toIterable(self) -> scala.collection.Iterable[typing.Any]: ...
    def toIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def toList(self) -> 'List'[typing.Any]: ...
    def toLong(self) -> int: ...
    _toMap__T = typing.TypeVar('_toMap__T')  # <T>
    _toMap__U = typing.TypeVar('_toMap__U')  # <U>
    def toMap(self, ev: scala.Predef..less.colon.less[typing.Any, scala.Tuple2[_toMap__T, _toMap__U]]) -> 'Map'[_toMap__T, _toMap__U]: ...
    def toSeq(self) -> scala.collection.Seq[typing.Any]: ...
    _toSet__B = typing.TypeVar('_toSet__B')  # <B>
    def toSet(self) -> 'Set'[_toSet__B]: ...
    def toShort(self) -> int: ...
    def toStream(self) -> 'Stream'[typing.Any]: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def toString$extension($this: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
    def toVector(self) -> 'Vector'[typing.Any]: ...
    _union__B = typing.TypeVar('_union__B')  # <B>
    _union__That = typing.TypeVar('_union__That')  # <That>
    def union(self, that: scala.collection.GenSeq[_union__B], bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _union__B, _union__That]) -> _union__That: ...
    _updated__B = typing.TypeVar('_updated__B')  # <B>
    _updated__That = typing.TypeVar('_updated__That')  # <That>
    def updated(self, index: int, elem: _updated__B, bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], _updated__B, _updated__That]) -> _updated__That: ...
    @typing.overload
    def view(self) -> scala.collection.SeqView[typing.Any, java.lang.String]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.SeqView[typing.Any, java.lang.String]: ...
    def withFilter(self, p: scala.Function1[typing.Any, typing.Any]) -> scala.collection.generic.FilterMonadic[typing.Any, java.lang.String]: ...
    _zip__A1 = typing.TypeVar('_zip__A1')  # <A1>
    _zip__B = typing.TypeVar('_zip__B')  # <B>
    _zip__That = typing.TypeVar('_zip__That')  # <That>
    def zip(self, that: scala.collection.GenIterable[_zip__B], bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], scala.Tuple2[_zip__A1, _zip__B], _zip__That]) -> _zip__That: ...
    _zipAll__B = typing.TypeVar('_zipAll__B')  # <B>
    _zipAll__A1 = typing.TypeVar('_zipAll__A1')  # <A1>
    _zipAll__That = typing.TypeVar('_zipAll__That')  # <That>
    def zipAll(self, that: scala.collection.GenIterable[_zipAll__B], thisElem: _zipAll__A1, thatElem: _zipAll__B, bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], scala.Tuple2[_zipAll__A1, _zipAll__B], _zipAll__That]) -> _zipAll__That: ...
    _zipWithIndex__A1 = typing.TypeVar('_zipWithIndex__A1')  # <A1>
    _zipWithIndex__That = typing.TypeVar('_zipWithIndex__That')  # <That>
    def zipWithIndex(self, bf: scala.collection.generic.CanBuildFrom[typing.Union[java.lang.String, str], scala.Tuple2[_zipWithIndex__A1, typing.Any], _zipWithIndex__That]) -> _zipWithIndex__That: ...

_VectorBuilder__A = typing.TypeVar('_VectorBuilder__A')  # <A>
class VectorBuilder(scala.collection.mutable.ReusableBuilder[_VectorBuilder__A, 'Vector'[_VectorBuilder__A]], VectorPointer[_VectorBuilder__A], typing.Generic[_VectorBuilder__A]):
    def __init__(self): ...
    @typing.overload
    def $plus$eq(self, elem1: _VectorBuilder__A, elem2: _VectorBuilder__A, elems: scala.collection.Seq[_VectorBuilder__A]) -> scala.collection.generic.Growable[_VectorBuilder__A]: ...
    @typing.overload
    def $plus$eq(self, elem: _VectorBuilder__A) -> 'VectorBuilder'[_VectorBuilder__A]: ...
    def $plus$plus$eq(self, xs: scala.collection.TraversableOnce[_VectorBuilder__A]) -> 'VectorBuilder'[_VectorBuilder__A]: ...
    def clear(self) -> None: ...
    def copyOf(self, a: typing.List[typing.Any]) -> typing.List[typing.Any]: ...
    def copyRange(self, array: typing.List[typing.Any], oldLeft: int, newLeft: int) -> typing.List[typing.Any]: ...
    def depth(self) -> int: ...
    def depth_$eq(self, x$1: int) -> None: ...
    def display0(self) -> typing.List[typing.Any]: ...
    def display0_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display1(self) -> typing.List[typing.Any]: ...
    def display1_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display2(self) -> typing.List[typing.Any]: ...
    def display2_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display3(self) -> typing.List[typing.Any]: ...
    def display3_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display4(self) -> typing.List[typing.Any]: ...
    def display4_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display5(self) -> typing.List[typing.Any]: ...
    def display5_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def getElem(self, index: int, xor: int) -> _VectorBuilder__A: ...
    def gotoFreshPosWritable0(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    def gotoFreshPosWritable1(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    def gotoNextBlockStart(self, index: int, xor: int) -> None: ...
    def gotoNextBlockStartWritable(self, index: int, xor: int) -> None: ...
    def gotoPos(self, index: int, xor: int) -> None: ...
    def gotoPosWritable0(self, newIndex: int, xor: int) -> None: ...
    def gotoPosWritable1(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    _initFrom_0__U = typing.TypeVar('_initFrom_0__U')  # <U>
    _initFrom_1__U = typing.TypeVar('_initFrom_1__U')  # <U>
    @typing.overload
    def initFrom(self, that: VectorPointer[_initFrom_0__U]) -> None: ...
    @typing.overload
    def initFrom(self, that: VectorPointer[_initFrom_1__U], depth: int) -> None: ...
    _mapResult__NewTo = typing.TypeVar('_mapResult__NewTo')  # <NewTo>
    def mapResult(self, f: scala.Function1['Vector'[_VectorBuilder__A], _mapResult__NewTo]) -> scala.collection.mutable.Builder[_VectorBuilder__A, _mapResult__NewTo]: ...
    def nullSlotAndCopy(self, array: typing.List[typing.Any], index: int) -> typing.List[typing.Any]: ...
    def result(self) -> 'Vector'[_VectorBuilder__A]: ...
    @typing.overload
    def sizeHint(self, size: int) -> None: ...
    @typing.overload
    def sizeHint(self, coll: scala.collection.TraversableLike[typing.Any, typing.Any]) -> None: ...
    @typing.overload
    def sizeHint(self, coll: scala.collection.TraversableLike[typing.Any, typing.Any], delta: int) -> None: ...
    def sizeHintBounded(self, size: int, boundingColl: scala.collection.TraversableLike[typing.Any, typing.Any]) -> None: ...
    def stabilize(self, index: int) -> None: ...

_VectorIterator__A = typing.TypeVar('_VectorIterator__A')  # <A>
class VectorIterator(scala.collection.AbstractIterator[_VectorIterator__A], VectorPointer[_VectorIterator__A], typing.Generic[_VectorIterator__A]):
    def __init__(self, _startIndex: int, endIndex: int): ...
    def copyOf(self, a: typing.List[typing.Any]) -> typing.List[typing.Any]: ...
    def copyRange(self, array: typing.List[typing.Any], oldLeft: int, newLeft: int) -> typing.List[typing.Any]: ...
    def depth(self) -> int: ...
    def depth_$eq(self, x$1: int) -> None: ...
    def display0(self) -> typing.List[typing.Any]: ...
    def display0_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display1(self) -> typing.List[typing.Any]: ...
    def display1_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display2(self) -> typing.List[typing.Any]: ...
    def display2_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display3(self) -> typing.List[typing.Any]: ...
    def display3_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display4(self) -> typing.List[typing.Any]: ...
    def display4_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display5(self) -> typing.List[typing.Any]: ...
    def display5_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def getElem(self, index: int, xor: int) -> _VectorIterator__A: ...
    def gotoFreshPosWritable0(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    def gotoFreshPosWritable1(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    def gotoNextBlockStart(self, index: int, xor: int) -> None: ...
    def gotoNextBlockStartWritable(self, index: int, xor: int) -> None: ...
    def gotoPos(self, index: int, xor: int) -> None: ...
    def gotoPosWritable0(self, newIndex: int, xor: int) -> None: ...
    def gotoPosWritable1(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    def hasNext(self) -> bool: ...
    _initFrom_0__U = typing.TypeVar('_initFrom_0__U')  # <U>
    _initFrom_1__U = typing.TypeVar('_initFrom_1__U')  # <U>
    @typing.overload
    def initFrom(self, that: VectorPointer[_initFrom_0__U]) -> None: ...
    @typing.overload
    def initFrom(self, that: VectorPointer[_initFrom_1__U], depth: int) -> None: ...
    def next(self) -> _VectorIterator__A: ...
    def nullSlotAndCopy(self, array: typing.List[typing.Any], index: int) -> typing.List[typing.Any]: ...
    def remainingElementCount(self) -> int: ...
    def remainingVector(self) -> 'Vector'[_VectorIterator__A]: ...
    def stabilize(self, index: int) -> None: ...

_Seq__A = typing.TypeVar('_Seq__A')  # <A>
class Seq(Iterable[_Seq__A], scala.collection.Seq[_Seq__A], typing.Generic[_Seq__A]):
    @staticmethod
    def $init$($this: 'Seq') -> None: ...
    @staticmethod
    def ReusableCBF() -> scala.collection.generic.GenTraversableFactory.GenericCanBuildFrom[scala.runtime.Nothing.]: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['Seq'[typing.Any], _canBuildFrom__A, 'Seq'[_canBuildFrom__A]]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['Seq']: ...
    @staticmethod
    def concat(xss: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    @staticmethod
    def empty() -> scala.collection.GenTraversable: ...
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, n5: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    def hashCode(self) -> int: ...
    @staticmethod
    def iterate(start: typing.Any, len: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_Seq__A, scala.collection.parallel.immutable.ParSeq[_Seq__A]]: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, step: typing.Any, evidence$2: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, evidence$1: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_Seq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_Seq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Iterable[_Seq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Seq[_Seq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Traversable[_Seq__A]: ...
    @typing.overload
    def seq(self) -> Iterable[_Seq__A]: ...
    @typing.overload
    def seq(self) -> 'Seq'[_Seq__A]: ...
    @typing.overload
    def seq(self) -> Traversable[_Seq__A]: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, n5: int, f: scala.Function5) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, f: scala.Function4) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, f: scala.Function3) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, f: scala.Function2) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    @typing.overload
    def toSeq(self) -> scala.collection.GenSeq[_Seq__A]: ...
    @typing.overload
    def toSeq(self) -> scala.collection.Seq[_Seq__A]: ...
    @typing.overload
    def toSeq(self) -> 'Seq'[_Seq__A]: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapplySeq(x: scala.collection.Seq) -> scala.Some: ...

_LinearSeq__A = typing.TypeVar('_LinearSeq__A')  # <A>
class LinearSeq(Seq[_LinearSeq__A], scala.collection.LinearSeq[_LinearSeq__A], typing.Generic[_LinearSeq__A]):
    @staticmethod
    def $init$($this: 'LinearSeq') -> None: ...
    @staticmethod
    def ReusableCBF() -> scala.collection.generic.GenTraversableFactory.GenericCanBuildFrom[scala.runtime.Nothing.]: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['LinearSeq'[typing.Any], _canBuildFrom__A, 'LinearSeq'[_canBuildFrom__A]]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['LinearSeq']: ...
    @staticmethod
    def concat(xss: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    @staticmethod
    def empty() -> scala.collection.GenTraversable: ...
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, n5: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    def hashCode(self) -> int: ...
    @staticmethod
    def iterate(start: typing.Any, len: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, step: typing.Any, evidence$2: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, evidence$1: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_LinearSeq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_LinearSeq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Iterable[_LinearSeq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.LinearSeq[_LinearSeq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Seq[_LinearSeq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Traversable[_LinearSeq__A]: ...
    @typing.overload
    def seq(self) -> Iterable[_LinearSeq__A]: ...
    @typing.overload
    def seq(self) -> 'LinearSeq'[_LinearSeq__A]: ...
    @typing.overload
    def seq(self) -> Seq[_LinearSeq__A]: ...
    @typing.overload
    def seq(self) -> Traversable[_LinearSeq__A]: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, n5: int, f: scala.Function5) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, f: scala.Function4) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, f: scala.Function3) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, f: scala.Function2) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapplySeq(x: scala.collection.Seq) -> scala.Some: ...

_List__SerializationProxy__A = typing.TypeVar('_List__SerializationProxy__A')  # <A>
_List__A = typing.TypeVar('_List__A')  # <A>
class List(scala.collection.AbstractSeq[_List__A], LinearSeq[_List__A], scala.Product, scala.collection.LinearSeqOptimized[_List__A, 'List'[_List__A]], scala.Serializable, typing.Generic[_List__A]):
    serialVersionUID: typing.ClassVar[int] = ...
    def __init__(self): ...
    _$colon$colon__B = typing.TypeVar('_$colon$colon__B')  # <B>
    def $colon$colon(self, x: _.colon.colon__B) -> 'List'[_.colon.colon__B]: ...
    _$colon$colon$colon__B = typing.TypeVar('_$colon$colon$colon__B')  # <B>
    def $colon$colon$colon(self, prefix: 'List'[_.colon.colon.colon__B]) -> 'List'[_.colon.colon.colon__B]: ...
    _$plus$colon__B = typing.TypeVar('_$plus$colon__B')  # <B>
    _$plus$colon__That = typing.TypeVar('_$plus$colon__That')  # <That>
    def $plus$colon(self, elem: _.plus.colon__B, bf: scala.collection.generic.CanBuildFrom['List'[_List__A], _.plus.colon__B, _.plus.colon__That]) -> _.plus.colon__That: ...
    _$plus$plus__B = typing.TypeVar('_$plus$plus__B')  # <B>
    _$plus$plus__That = typing.TypeVar('_$plus$plus__That')  # <That>
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus__B], bf: scala.collection.generic.CanBuildFrom['List'[_List__A], _.plus.plus__B, _.plus.plus__That]) -> _.plus.plus__That: ...
    @staticmethod
    def ReusableCBF() -> scala.collection.generic.GenTraversableFactory.GenericCanBuildFrom[scala.runtime.Nothing.]: ...
    def apply(self, n: int) -> _List__A: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['List'[typing.Any], _canBuildFrom__A, 'List'[_canBuildFrom__A]]: ...
    _collect__B = typing.TypeVar('_collect__B')  # <B>
    _collect__That = typing.TypeVar('_collect__That')  # <That>
    def collect(self, pf: scala.PartialFunction[_List__A, _collect__B], bf: scala.collection.generic.CanBuildFrom['List'[_List__A], _collect__B, _collect__That]) -> _collect__That: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['List']: ...
    @staticmethod
    def concat(xss: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    _contains__A1 = typing.TypeVar('_contains__A1')  # <A1>
    def contains(self, elem: _contains__A1) -> bool: ...
    _corresponds__B = typing.TypeVar('_corresponds__B')  # <B>
    def corresponds(self, that: scala.collection.GenSeq[_corresponds__B], p: scala.Function2[_List__A, _corresponds__B, typing.Any]) -> bool: ...
    def drop(self, n: int) -> 'List'[_List__A]: ...
    def dropRight(self, n: int) -> scala.collection.LinearSeqOptimized: ...
    def dropWhile(self, p: scala.Function1[_List__A, typing.Any]) -> 'List'[_List__A]: ...
    _empty__A = typing.TypeVar('_empty__A')  # <A>
    @staticmethod
    def empty() -> 'List'[_empty__A]: ...
    def exists(self, p: scala.Function1[_List__A, typing.Any]) -> bool: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, n5: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    def find(self, p: scala.Function1[_List__A, typing.Any]) -> scala.Option[_List__A]: ...
    _flatMap__B = typing.TypeVar('_flatMap__B')  # <B>
    _flatMap__That = typing.TypeVar('_flatMap__That')  # <That>
    def flatMap(self, f: scala.Function1[_List__A, scala.collection.GenTraversableOnce[_flatMap__B]], bf: scala.collection.generic.CanBuildFrom['List'[_List__A], _flatMap__B, _flatMap__That]) -> _flatMap__That: ...
    _foldLeft__B = typing.TypeVar('_foldLeft__B')  # <B>
    def foldLeft(self, z: _foldLeft__B, op: scala.Function2[_foldLeft__B, _List__A, _foldLeft__B]) -> _foldLeft__B: ...
    _foldRight__B = typing.TypeVar('_foldRight__B')  # <B>
    def foldRight(self, z: _foldRight__B, op: scala.Function2[_List__A, _foldRight__B, _foldRight__B]) -> _foldRight__B: ...
    def forall(self, p: scala.Function1[_List__A, typing.Any]) -> bool: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[_List__A, _foreach__U]) -> None: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[_List__A, _groupBy__K]) -> 'Map'[_groupBy__K, scala.collection.Traversable[_List__A]]: ...
    def hashCode(self) -> int: ...
    def head(self) -> _List__A: ...
    @typing.overload
    def indexWhere(self, p: scala.Function1[_List__A, typing.Any]) -> int: ...
    @typing.overload
    def indexWhere(self, p: scala.Function1[_List__A, typing.Any], from_: int) -> int: ...
    def isDefinedAt(self, x: int) -> bool: ...
    def isEmpty(self) -> bool: ...
    @staticmethod
    def iterate(start: typing.Any, len: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def iterator(self) -> scala.collection.Iterator[_List__A]: ...
    def last(self) -> _List__A: ...
    @typing.overload
    def lastIndexWhere(self, p: scala.Function1[_List__A, typing.Any]) -> int: ...
    @typing.overload
    def lastIndexWhere(self, p: scala.Function1[_List__A, typing.Any], end: int) -> int: ...
    def length(self) -> int: ...
    def lengthCompare(self, len: int) -> int: ...
    _map__B = typing.TypeVar('_map__B')  # <B>
    _map__That = typing.TypeVar('_map__That')  # <That>
    def map(self, f: scala.Function1[_List__A, _map__B], bf: scala.collection.generic.CanBuildFrom['List'[_List__A], _map__B, _map__That]) -> _map__That: ...
    _mapConserve__B = typing.TypeVar('_mapConserve__B')  # <B>
    def mapConserve(self, f: scala.Function1[_List__A, _mapConserve__B]) -> 'List'[_mapConserve__B]: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_List__A, scala.collection.parallel.immutable.ParSeq[_List__A]]: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, step: typing.Any, evidence$2: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, evidence$1: scala.math.Integral) -> scala.collection.GenTraversable: ...
    _reduceLeft__B = typing.TypeVar('_reduceLeft__B')  # <B>
    def reduceLeft(self, op: scala.Function2[_reduceLeft__B, _List__A, _reduceLeft__B]) -> _reduceLeft__B: ...
    _reduceRight__B = typing.TypeVar('_reduceRight__B')  # <B>
    def reduceRight(self, op: scala.Function2[_List__A, _reduceRight__B, _reduceRight__B]) -> _reduceRight__B: ...
    def reverse(self) -> 'List'[_List__A]: ...
    _reverse_$colon$colon$colon__B = typing.TypeVar('_reverse_$colon$colon$colon__B')  # <B>
    def reverse_$colon$colon$colon(self, prefix: 'List'[_reverse_.colon.colon.colon__B]) -> 'List'[_reverse_.colon.colon.colon__B]: ...
    _sameElements__B = typing.TypeVar('_sameElements__B')  # <B>
    def sameElements(self, that: scala.collection.GenIterable[_sameElements__B]) -> bool: ...
    def segmentLength(self, p: scala.Function1[_List__A, typing.Any], from_: int) -> int: ...
    def seq(self) -> LinearSeq[_List__A]: ...
    def slice(self, from_: int, until: int) -> 'List'[_List__A]: ...
    def span(self, p: scala.Function1[_List__A, typing.Any]) -> scala.Tuple2['List'[_List__A], 'List'[_List__A]]: ...
    def splitAt(self, n: int) -> scala.Tuple2['List'[_List__A], 'List'[_List__A]]: ...
    def stringPrefix(self) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, n5: int, f: scala.Function5) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, f: scala.Function4) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, f: scala.Function3) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, f: scala.Function2) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def tail(self) -> typing.Any: ...
    def tails(self) -> scala.collection.Iterator['List'[_List__A]]: ...
    def take(self, n: int) -> 'List'[_List__A]: ...
    def takeRight(self, n: int) -> 'List'[_List__A]: ...
    def takeWhile(self, p: scala.Function1[_List__A, typing.Any]) -> 'List'[_List__A]: ...
    def thisCollection(self) -> scala.collection.LinearSeq[_List__A]: ...
    def toCollection(self, repr: scala.collection.LinearSeqLike) -> scala.collection.LinearSeq: ...
    def toIterable(self) -> scala.collection.Iterable[_List__A]: ...
    def toList(self) -> 'List'[_List__A]: ...
    def toSeq(self) -> Seq[_List__A]: ...
    def toStream(self) -> 'Stream'[_List__A]: ...
    def toTraversable(self) -> scala.collection.Traversable[_List__A]: ...
    @staticmethod
    def unapplySeq(x: scala.collection.Seq) -> scala.Some: ...
    @typing.overload
    def view(self) -> scala.collection.SeqView[_List__A, scala.collection.Seq[_List__A]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.SeqView[_List__A, scala.collection.Seq[_List__A]]: ...
    def writeReplace(self) -> typing.Any: ...
    class SerializationProxy(scala.Serializable, typing.Generic[_List__SerializationProxy__A]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, orig: 'List'[_List__SerializationProxy__A]): ...

_Stack__A = typing.TypeVar('_Stack__A')  # <A>
class Stack(scala.collection.AbstractSeq[_Stack__A], LinearSeq[_Stack__A], scala.collection.LinearSeqOptimized[_Stack__A, 'Stack'[_Stack__A]], scala.Serializable, typing.Generic[_Stack__A]):
    serialVersionUID: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self): ...
    @typing.overload
    def __init__(self, elems: List[_Stack__A]): ...
    @staticmethod
    def ReusableCBF() -> scala.collection.generic.GenTraversableFactory.GenericCanBuildFrom[scala.runtime.Nothing.]: ...
    def apply(self, n: int) -> _Stack__A: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['Stack'[typing.Any], _canBuildFrom__A, 'Stack'[_canBuildFrom__A]]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['Stack']: ...
    @staticmethod
    def concat(xss: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    _contains__A1 = typing.TypeVar('_contains__A1')  # <A1>
    def contains(self, elem: _contains__A1) -> bool: ...
    _corresponds__B = typing.TypeVar('_corresponds__B')  # <B>
    def corresponds(self, that: scala.collection.GenSeq[_corresponds__B], p: scala.Function2[_Stack__A, _corresponds__B, typing.Any]) -> bool: ...
    def drop(self, n: int) -> scala.collection.LinearSeqOptimized: ...
    def dropRight(self, n: int) -> scala.collection.LinearSeqOptimized: ...
    def elems(self) -> List[_Stack__A]: ...
    @staticmethod
    def empty() -> scala.collection.GenTraversable: ...
    def exists(self, p: scala.Function1[_Stack__A, typing.Any]) -> bool: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, n5: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    def find(self, p: scala.Function1[_Stack__A, typing.Any]) -> scala.Option[_Stack__A]: ...
    _foldLeft__B = typing.TypeVar('_foldLeft__B')  # <B>
    def foldLeft(self, z: _foldLeft__B, op: scala.Function2[_foldLeft__B, _Stack__A, _foldLeft__B]) -> _foldLeft__B: ...
    _foldRight__B = typing.TypeVar('_foldRight__B')  # <B>
    def foldRight(self, z: _foldRight__B, op: scala.Function2[_Stack__A, _foldRight__B, _foldRight__B]) -> _foldRight__B: ...
    def forall(self, p: scala.Function1[_Stack__A, typing.Any]) -> bool: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[_Stack__A, _foreach__U]) -> None: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[_Stack__A, _groupBy__K]) -> 'Map'[_groupBy__K, scala.collection.Traversable[_Stack__A]]: ...
    def hashCode(self) -> int: ...
    def head(self) -> _Stack__A: ...
    @typing.overload
    def indexWhere(self, p: scala.Function1[_Stack__A, typing.Any]) -> int: ...
    @typing.overload
    def indexWhere(self, p: scala.Function1[_Stack__A, typing.Any], from_: int) -> int: ...
    def isDefinedAt(self, x: int) -> bool: ...
    def isEmpty(self) -> bool: ...
    @staticmethod
    def iterate(start: typing.Any, len: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def iterator(self) -> scala.collection.Iterator[_Stack__A]: ...
    def last(self) -> _Stack__A: ...
    @typing.overload
    def lastIndexWhere(self, p: scala.Function1[_Stack__A, typing.Any]) -> int: ...
    @typing.overload
    def lastIndexWhere(self, p: scala.Function1[_Stack__A, typing.Any], end: int) -> int: ...
    def length(self) -> int: ...
    def lengthCompare(self, len: int) -> int: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_Stack__A, scala.collection.parallel.immutable.ParSeq[_Stack__A]]: ...
    def pop(self) -> 'Stack'[_Stack__A]: ...
    def pop2(self) -> scala.Tuple2[_Stack__A, 'Stack'[_Stack__A]]: ...
    _push_0__B = typing.TypeVar('_push_0__B')  # <B>
    _push_1__B = typing.TypeVar('_push_1__B')  # <B>
    @typing.overload
    def push(self, elem: _push_0__B) -> 'Stack'[_push_0__B]: ...
    @typing.overload
    def push(self, elem1: _push_1__B, elem2: _push_1__B, elems: scala.collection.Seq[_push_1__B]) -> 'Stack'[_push_1__B]: ...
    _pushAll__B = typing.TypeVar('_pushAll__B')  # <B>
    def pushAll(self, xs: scala.collection.TraversableOnce[_pushAll__B]) -> 'Stack'[_pushAll__B]: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, step: typing.Any, evidence$2: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, evidence$1: scala.math.Integral) -> scala.collection.GenTraversable: ...
    _reduceLeft__B = typing.TypeVar('_reduceLeft__B')  # <B>
    def reduceLeft(self, op: scala.Function2[_reduceLeft__B, _Stack__A, _reduceLeft__B]) -> _reduceLeft__B: ...
    _reduceRight__B = typing.TypeVar('_reduceRight__B')  # <B>
    def reduceRight(self, op: scala.Function2[_Stack__A, _reduceRight__B, _reduceRight__B]) -> _reduceRight__B: ...
    def reverse(self) -> 'Stack'[_Stack__A]: ...
    _sameElements__B = typing.TypeVar('_sameElements__B')  # <B>
    def sameElements(self, that: scala.collection.GenIterable[_sameElements__B]) -> bool: ...
    def segmentLength(self, p: scala.Function1[_Stack__A, typing.Any], from_: int) -> int: ...
    def seq(self) -> LinearSeq[_Stack__A]: ...
    def slice(self, from_: int, until: int) -> scala.collection.LinearSeqOptimized: ...
    def span(self, p: scala.Function1[_Stack__A, typing.Any]) -> scala.Tuple2['Stack'[_Stack__A], 'Stack'[_Stack__A]]: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, n5: int, f: scala.Function5) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, f: scala.Function4) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, f: scala.Function3) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, f: scala.Function2) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def tail(self) -> 'Stack'[_Stack__A]: ...
    def tails(self) -> scala.collection.Iterator['Stack'[_Stack__A]]: ...
    def take(self, n: int) -> scala.collection.LinearSeqOptimized: ...
    def takeWhile(self, p: scala.Function1) -> scala.collection.LinearSeqOptimized: ...
    def thisCollection(self) -> scala.collection.LinearSeq[_Stack__A]: ...
    def toCollection(self, repr: scala.collection.LinearSeqLike) -> scala.collection.LinearSeq: ...
    def toIterable(self) -> scala.collection.Iterable[_Stack__A]: ...
    def toSeq(self) -> Seq[_Stack__A]: ...
    def toString(self) -> java.lang.String: ...
    def toTraversable(self) -> scala.collection.Traversable[_Stack__A]: ...
    def top(self) -> _Stack__A: ...
    @staticmethod
    def unapplySeq(x: scala.collection.Seq) -> scala.Some: ...
    @typing.overload
    def view(self) -> scala.collection.SeqView[_Stack__A, scala.collection.Seq[_Stack__A]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.SeqView[_Stack__A, scala.collection.Seq[_Stack__A]]: ...

_AbstractMap__K = typing.TypeVar('_AbstractMap__K')  # <K>
_AbstractMap__V = typing.TypeVar('_AbstractMap__V')  # <V>
class AbstractMap(scala.collection.AbstractMap[_AbstractMap__K, _AbstractMap__V], scala.collection.immutable.Map[_AbstractMap__K, _AbstractMap__V], typing.Generic[_AbstractMap__K, _AbstractMap__V]):
    def __init__(self): ...
    _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
    _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
    _$plus_2__V1 = typing.TypeVar('_$plus_2__V1')  # <V1>
    _$plus_3__V1 = typing.TypeVar('_$plus_3__V1')  # <V1>
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_AbstractMap__K, _.plus_0__V1]) -> scala.collection.GenMap[_AbstractMap__K, _.plus_0__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_AbstractMap__K, _.plus_1__V1]) -> scala.collection.Map[_AbstractMap__K, _.plus_1__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_AbstractMap__K, _.plus_2__V1]) -> 'Map'[_AbstractMap__K, _.plus_2__V1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[_AbstractMap__K, _.plus_3__V1], elem2: scala.Tuple2[_AbstractMap__K, _.plus_3__V1], elems: scala.collection.Seq[scala.Tuple2[_AbstractMap__K, _.plus_3__V1]]) -> 'Map'[_AbstractMap__K, _.plus_3__V1]: ...
    _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
    _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
    _$plus$plus_1__V1 = typing.TypeVar('_$plus$plus_1__V1')  # <V1>
    @typing.overload
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus_0__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Traversable[typing.Any], _.plus.plus_0__B, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[_AbstractMap__K, _.plus.plus_1__V1]]) -> 'Map'[_AbstractMap__K, _.plus.plus_1__V1]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion[Iterable]: ...
    def empty(self) -> 'Map'[_AbstractMap__K, _AbstractMap__V]: ...
    def filterKeys(self, p: scala.Function1[_AbstractMap__K, typing.Any]) -> 'Map'[_AbstractMap__K, _AbstractMap__V]: ...
    def filterNot(self, p: scala.Function1[scala.Tuple2[_AbstractMap__K, _AbstractMap__V], typing.Any]) -> scala.collection.Map[_AbstractMap__K, _AbstractMap__V]: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[typing.Any, typing.Any]) -> 'Map'[typing.Any, scala.collection.Traversable[typing.Any]]: ...
    def keySet(self) -> 'Set'[_AbstractMap__K]: ...
    def keys(self) -> scala.collection.Iterable[_AbstractMap__K]: ...
    _mapValues__W = typing.TypeVar('_mapValues__W')  # <W>
    def mapValues(self, f: scala.Function1[_AbstractMap__V, _mapValues__W]) -> 'Map'[_AbstractMap__K, _mapValues__W]: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[scala.Tuple2[_AbstractMap__K, _AbstractMap__V], scala.collection.parallel.immutable.ParMap[_AbstractMap__K, _AbstractMap__V]]: ...
    def repr(self) -> typing.Any: ...
    def seq(self) -> 'Map'[_AbstractMap__K, _AbstractMap__V]: ...
    def thisCollection(self) -> scala.collection.Iterable[typing.Any]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
    def toIterable(self) -> scala.collection.Iterable[typing.Any]: ...
    _toMap__T = typing.TypeVar('_toMap__T')  # <T>
    _toMap__U = typing.TypeVar('_toMap__U')  # <U>
    def toMap(self, ev: scala.Predef..less.colon.less[scala.Tuple2[_AbstractMap__K, _AbstractMap__V], scala.Tuple2[_toMap__T, _toMap__U]]) -> 'Map'[_toMap__T, _toMap__U]: ...
    def toSeq(self) -> scala.collection.Seq[scala.Tuple2[_AbstractMap__K, _AbstractMap__V]]: ...
    def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
    _transform__W = typing.TypeVar('_transform__W')  # <W>
    _transform__That = typing.TypeVar('_transform__That')  # <That>
    def transform(self, f: scala.Function2[_AbstractMap__K, _AbstractMap__V, _transform__W], bf: scala.collection.generic.CanBuildFrom['Map'[_AbstractMap__K, _AbstractMap__V], scala.Tuple2[_AbstractMap__K, _transform__W], _transform__That]) -> _transform__That: ...
    _updated__V1 = typing.TypeVar('_updated__V1')  # <V1>
    def updated(self, key: _AbstractMap__K, value: _updated__V1) -> 'Map'[_AbstractMap__K, _updated__V1]: ...
    def values(self) -> scala.collection.Iterable[_AbstractMap__V]: ...
    @typing.overload
    def view(self) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
    _withDefault__V1 = typing.TypeVar('_withDefault__V1')  # <V1>
    def withDefault(self, d: scala.Function1[_AbstractMap__K, _withDefault__V1]) -> 'Map'[_AbstractMap__K, _withDefault__V1]: ...
    _withDefaultValue__V1 = typing.TypeVar('_withDefaultValue__V1')  # <V1>
    def withDefaultValue(self, d: _withDefaultValue__V1) -> 'Map'[_AbstractMap__K, _withDefaultValue__V1]: ...

class BitSet(scala.collection.AbstractSet[typing.Any], scala.collection.immutable.SortedSet[typing.Any], scala.collection.BitSet, scala.Serializable):
    serialVersionUID: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def $amp(self, that: scala.collection.GenSet) -> typing.Any: ...
    @typing.overload
    def $amp(self, other: scala.collection.BitSet) -> scala.collection.BitSetLike: ...
    @typing.overload
    def $amp$tilde(self, that: scala.collection.GenSet) -> typing.Any: ...
    @typing.overload
    def $amp$tilde(self, other: scala.collection.BitSet) -> scala.collection.BitSetLike: ...
    @typing.overload
    def $bar(self, that: scala.collection.GenSet) -> typing.Any: ...
    @typing.overload
    def $bar(self, other: scala.collection.BitSet) -> scala.collection.BitSetLike: ...
    @typing.overload
    def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, elem: int) -> 'BitSet': ...
    @typing.overload
    def $plus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq[typing.Any]) -> scala.collection.Set[typing.Any]: ...
    @typing.overload
    def $plus(self, elem: int) -> 'BitSet': ...
    def $up(self, other: scala.collection.BitSet) -> scala.collection.BitSetLike: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder, sep: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, sb: scala.collection.mutable.StringBuilder, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    def apply(self, elem: typing.Any) -> bool: ...
    @staticmethod
    def bitsetCanBuildFrom() -> scala.collection.generic.CanBuildFrom['BitSet', typing.Any, 'BitSet']: ...
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['BitSet', typing.Any, 'BitSet']: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['Set']: ...
    def compare(self, k0: typing.Any, k1: typing.Any) -> int: ...
    def contains(self, elem: int) -> bool: ...
    def diff(self, that: scala.collection.GenSet[typing.Any]) -> scala.collection.Set[typing.Any]: ...
    def empty(self) -> 'BitSet': ...
    def firstKey(self) -> typing.Any: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[typing.Any, _foreach__U]) -> None: ...
    @staticmethod
    def fromBitMask(elems: typing.List[int]) -> 'BitSet': ...
    def fromBitMaskNoCopy(self, elems: typing.List[int]) -> 'BitSet': ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[typing.Any, _groupBy__K]) -> 'Map'[_groupBy__K, scala.collection.Traversable[typing.Any]]: ...
    def hasAll(self, j: scala.collection.Iterator[typing.Any]) -> bool: ...
    def head(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def iteratorFrom(self, start: typing.Any) -> scala.collection.Iterator: ...
    def keySet(self) -> scala.collection.SortedSet: ...
    def keysIteratorFrom(self, start: int) -> scala.collection.AbstractIterator[typing.Any]: ...
    def last(self) -> int: ...
    def lastKey(self) -> typing.Any: ...
    def ordering(self) -> scala.math.Ordering[typing.Any]: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[typing.Any, scala.collection.parallel.immutable.ParSet[typing.Any]]: ...
    def range(self, from_: typing.Any, until: typing.Any) -> scala.collection.SortedSet: ...
    def rangeImpl(self, from_: scala.Option, until: scala.Option) -> scala.collection.BitSetLike: ...
    def repr(self) -> typing.Any: ...
    def seq(self) -> 'Set'[typing.Any]: ...
    def size(self) -> int: ...
    def stringPrefix(self) -> java.lang.String: ...
    @typing.overload
    def subsetOf(self, other: scala.collection.BitSet) -> bool: ...
    @typing.overload
    def subsetOf(self, that: scala.collection.GenSet[typing.Any]) -> bool: ...
    def thisCollection(self) -> scala.collection.Iterable[typing.Any]: ...
    _to_0__Col = typing.TypeVar('_to_0__Col')  # <Col>
    @typing.overload
    def to(self, cbf: scala.collection.generic.CanBuildFrom[scala.runtime.Nothing., typing.Any, _to_0__Col]) -> _to_0__Col: ...
    @typing.overload
    def to(self, to: typing.Any) -> scala.collection.generic.Sorted: ...
    def toBitMask(self) -> typing.List[int]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
    def toIterable(self) -> scala.collection.Iterable[typing.Any]: ...
    def toSeq(self) -> scala.collection.Seq[typing.Any]: ...
    _toSet__B = typing.TypeVar('_toSet__B')  # <B>
    def toSet(self) -> 'Set'[_toSet__B]: ...
    def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
    def union(self, that: scala.collection.GenSet[typing.Any]) -> scala.collection.Set[typing.Any]: ...
    def until(self, until: typing.Any) -> scala.collection.SortedSet: ...
    def updateWord(self, idx: int, w: int) -> 'BitSet': ...
    @typing.overload
    def view(self) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
    class BitSet1(scala.collection.immutable.BitSet):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, elems: int): ...
        def elems(self) -> int: ...
        def head(self) -> int: ...
        def nwords(self) -> int: ...
        def tail(self) -> 'BitSet': ...
        def updateWord(self, idx: int, w: int) -> 'BitSet': ...
        def word(self, idx: int) -> int: ...
    class BitSet2(scala.collection.immutable.BitSet):
        def __init__(self, elems0: int, elems1: int): ...
        def elems0(self) -> int: ...
        def head(self) -> int: ...
        def nwords(self) -> int: ...
        def tail(self) -> 'BitSet': ...
        def updateWord(self, idx: int, w: int) -> 'BitSet': ...
        def word(self, idx: int) -> int: ...
    class BitSetN(scala.collection.immutable.BitSet):
        def __init__(self, elems: typing.List[int]): ...
        def elems(self) -> typing.List[int]: ...
        def nwords(self) -> int: ...
        def tail(self) -> 'BitSet': ...
        def updateWord(self, idx: int, w: int) -> 'BitSet': ...
        def word(self, idx: int) -> int: ...

_DefaultMap__A = typing.TypeVar('_DefaultMap__A')  # <A>
_DefaultMap__B = typing.TypeVar('_DefaultMap__B')  # <B>
class DefaultMap(scala.collection.immutable.Map[_DefaultMap__A, _DefaultMap__B], typing.Generic[_DefaultMap__A, _DefaultMap__B]):
    @staticmethod
    def $init$($this: 'DefaultMap') -> None: ...
    @typing.overload
    def $minus(self, key: typing.Any) -> typing.Any: ...
    @typing.overload
    def $minus(self, key: typing.Any) -> scala.collection.MapLike: ...
    @typing.overload
    def $minus(self, elem: _DefaultMap__A) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, elem1: _DefaultMap__A, elem2: _DefaultMap__A, elems: scala.collection.Seq[_DefaultMap__A]) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, key: _DefaultMap__A) -> 'Map'[_DefaultMap__A, _DefaultMap__B]: ...
    _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
    _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
    _$plus_2__V1 = typing.TypeVar('_$plus_2__V1')  # <V1>
    _$plus_3__B1 = typing.TypeVar('_$plus_3__B1')  # <B1>
    _$plus_4__V1 = typing.TypeVar('_$plus_4__V1')  # <V1>
    @typing.overload
    def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_0__V1]) -> scala.collection.GenMap[typing.Any, _.plus_0__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_1__V1]) -> scala.collection.Map[typing.Any, _.plus_1__V1]: ...
    @typing.overload
    def $plus(self, kv1: scala.Tuple2[typing.Any, _.plus_2__V1], kv2: scala.Tuple2[typing.Any, _.plus_2__V1], kvs: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_2__V1]]) -> scala.collection.Map[typing.Any, _.plus_2__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_DefaultMap__A, _.plus_3__B1]) -> 'Map'[_DefaultMap__A, _.plus_3__B1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[typing.Any, _.plus_4__V1], elem2: scala.Tuple2[typing.Any, _.plus_4__V1], elems: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_4__V1]]) -> 'Map'[typing.Any, _.plus_4__V1]: ...
    def equals(self, that: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def toString(self) -> java.lang.String: ...

_HashMap__HashMap1__A = typing.TypeVar('_HashMap__HashMap1__A')  # <A>
_HashMap__HashMap1__B = typing.TypeVar('_HashMap__HashMap1__B')  # <B>
_HashMap__HashMapCollision1__A = typing.TypeVar('_HashMap__HashMapCollision1__A')  # <A>
_HashMap__HashMapCollision1__B = typing.TypeVar('_HashMap__HashMapCollision1__B')  # <B>
_HashMap__HashTrieMap__A = typing.TypeVar('_HashMap__HashTrieMap__A')  # <A>
_HashMap__HashTrieMap__B = typing.TypeVar('_HashMap__HashTrieMap__B')  # <B>
_HashMap__Merger__A = typing.TypeVar('_HashMap__Merger__A')  # <A>
_HashMap__Merger__B = typing.TypeVar('_HashMap__Merger__B')  # <B>
_HashMap__SerializationProxy__A = typing.TypeVar('_HashMap__SerializationProxy__A')  # <A>
_HashMap__SerializationProxy__B = typing.TypeVar('_HashMap__SerializationProxy__B')  # <B>
_HashMap__A = typing.TypeVar('_HashMap__A')  # <A>
_HashMap__B = typing.TypeVar('_HashMap__B')  # <B>
class HashMap(AbstractMap[_HashMap__A, _HashMap__B], scala.Serializable, scala.collection.CustomParallelizable[scala.Tuple2[_HashMap__A, _HashMap__B], scala.collection.parallel.immutable.ParHashMap[_HashMap__A, _HashMap__B]], typing.Generic[_HashMap__A, _HashMap__B]):
    serialVersionUID: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, key: _HashMap__A) -> 'HashMap'[_HashMap__A, _HashMap__B]: ...
    _$plus_0__B1 = typing.TypeVar('_$plus_0__B1')  # <B1>
    _$plus_1__B1 = typing.TypeVar('_$plus_1__B1')  # <B1>
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_HashMap__A, _.plus_0__B1]) -> 'HashMap'[_HashMap__A, _.plus_0__B1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[_HashMap__A, _.plus_1__B1], elem2: scala.Tuple2[_HashMap__A, _.plus_1__B1], elems: scala.collection.Seq[scala.Tuple2[_HashMap__A, _.plus_1__B1]]) -> 'HashMap'[_HashMap__A, _.plus_1__B1]: ...
    _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
    _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
    _$plus$plus_1__V1 = typing.TypeVar('_$plus$plus_1__V1')  # <V1>
    @typing.overload
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[typing.Any], bf: scala.collection.generic.CanBuildFrom[scala.collection.Traversable[_HashMap__A], typing.Any, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[typing.Any, _.plus.plus_1__V1]]) -> 'Map'[typing.Any, _.plus.plus_1__V1]: ...
    @staticmethod
    def bitString(num: int, sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @staticmethod
    def bitString$default$2() -> java.lang.String: ...
    @staticmethod
    def bits(num: int) -> 'IndexedSeq'[typing.Any]: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    _canBuildFrom__B = typing.TypeVar('_canBuildFrom__B')  # <B>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['HashMap'[typing.Any, typing.Any], scala.Tuple2[_canBuildFrom__A, _canBuildFrom__B], 'HashMap'[_canBuildFrom__A, _canBuildFrom__B]]: ...
    @staticmethod
    def complement(i: int) -> int: ...
    def computeHash(self, key: _HashMap__A) -> int: ...
    def contains(self, key: _HashMap__A) -> bool: ...
    def contains0(self, key: _HashMap__A, hash: int, level: int) -> bool: ...
    def elemHashCode(self, key: _HashMap__A) -> int: ...
    def empty(self) -> 'HashMap'[_HashMap__A, _HashMap__B]: ...
    def filter(self, p: scala.Function1[scala.Tuple2[_HashMap__A, _HashMap__B], typing.Any]) -> 'HashMap'[_HashMap__A, _HashMap__B]: ...
    def filter0(self, p: scala.Function1[scala.Tuple2[_HashMap__A, _HashMap__B], typing.Any], negate: bool, level: int, buffer: typing.List['HashMap'[_HashMap__A, _HashMap__B]], offset0: int) -> 'HashMap'[_HashMap__A, _HashMap__B]: ...
    def filterKeys(self, p: scala.Function1[typing.Any, typing.Any]) -> 'Map'[typing.Any, typing.Any]: ...
    def filterNot(self, p: scala.Function1[scala.Tuple2[_HashMap__A, _HashMap__B], typing.Any]) -> 'HashMap'[_HashMap__A, _HashMap__B]: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[scala.Tuple2[_HashMap__A, _HashMap__B], _foreach__U]) -> None: ...
    def get(self, key: _HashMap__A) -> scala.Option[_HashMap__B]: ...
    def get0(self, key: _HashMap__A, hash: int, level: int) -> scala.Option[_HashMap__B]: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[_HashMap__A, _groupBy__K]) -> 'Map'[_groupBy__K, scala.collection.Traversable[_HashMap__A]]: ...
    @staticmethod
    def hasMatch(key: int, prefix: int, m: int) -> bool: ...
    @staticmethod
    def highestOneBit(j: int) -> int: ...
    def improve(self, hcode: int) -> int: ...
    def iterator(self) -> scala.collection.Iterator[scala.Tuple2[_HashMap__A, _HashMap__B]]: ...
    def keySet(self) -> 'Set'[typing.Any]: ...
    def keys(self) -> scala.collection.Iterable[typing.Any]: ...
    _mapValues__W = typing.TypeVar('_mapValues__W')  # <W>
    def mapValues(self, f: scala.Function1[typing.Any, _mapValues__W]) -> 'Map'[typing.Any, _mapValues__W]: ...
    @staticmethod
    def mask(i: int, mask: int) -> int: ...
    _merge0__B1 = typing.TypeVar('_merge0__B1')  # <B1>
    def merge0(self, that: 'HashMap'[_HashMap__A, _merge0__B1], level: int, merger: 'HashMap.Merger'[_HashMap__A, _merge0__B1]) -> 'HashMap'[_HashMap__A, _merge0__B1]: ...
    _merged__B1 = typing.TypeVar('_merged__B1')  # <B1>
    def merged(self, that: 'HashMap'[_HashMap__A, _merged__B1], mergef: scala.Function2[scala.Tuple2[_HashMap__A, _merged__B1], scala.Tuple2[_HashMap__A, _merged__B1], scala.Tuple2[_HashMap__A, _merged__B1]]) -> 'HashMap'[_HashMap__A, _merged__B1]: ...
    def par(self) -> scala.collection.parallel.immutable.ParHashMap[_HashMap__A, _HashMap__B]: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[scala.Tuple2[_HashMap__A, _HashMap__B], scala.collection.parallel.immutable.ParHashMap[_HashMap__A, _HashMap__B]]: ...
    def removed0(self, key: _HashMap__A, hash: int, level: int) -> 'HashMap'[_HashMap__A, _HashMap__B]: ...
    def repr(self) -> typing.Any: ...
    def seq(self) -> 'Map'[typing.Any, typing.Any]: ...
    @staticmethod
    def shorter(m1: int, m2: int) -> bool: ...
    def size(self) -> int: ...
    def split(self) -> Seq['HashMap'[_HashMap__A, _HashMap__B]]: ...
    def tail(self) -> 'HashMap'[_HashMap__A, _HashMap__B]: ...
    def thisCollection(self) -> scala.collection.Iterable[_HashMap__A]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
    def toIterable(self) -> scala.collection.Iterable[_HashMap__A]: ...
    def toSeq(self) -> scala.collection.Seq[scala.Tuple2[typing.Any, typing.Any]]: ...
    def toTraversable(self) -> scala.collection.Traversable[_HashMap__A]: ...
    @staticmethod
    def unsignedCompare(i: int, j: int) -> bool: ...
    _updated__B1 = typing.TypeVar('_updated__B1')  # <B1>
    def updated(self, key: _HashMap__A, value: _updated__B1) -> 'HashMap'[_HashMap__A, _updated__B1]: ...
    _updated0__B1 = typing.TypeVar('_updated0__B1')  # <B1>
    def updated0(self, key: _HashMap__A, hash: int, level: int, value: _updated0__B1, kv: scala.Tuple2[_HashMap__A, _updated0__B1], merger: 'HashMap.Merger'[_HashMap__A, _updated0__B1]) -> 'HashMap'[_HashMap__A, _updated0__B1]: ...
    def values(self) -> scala.collection.Iterable[typing.Any]: ...
    @typing.overload
    def view(self) -> scala.collection.IterableView[_HashMap__A, scala.collection.Iterable[_HashMap__A]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.IterableView[_HashMap__A, scala.collection.Iterable[_HashMap__A]]: ...
    def writeReplace(self) -> typing.Any: ...
    @staticmethod
    def zero(i: int, mask: int) -> bool: ...
    class EmptyHashMap$(scala.collection.immutable.HashMap[typing.Any, scala.runtime.Nothing.]):
        MODULE$: typing.ClassVar['HashMap.EmptyHashMap.'] = ...
        def __init__(self): ...
        def head(self) -> scala.Tuple2[typing.Any, scala.runtime.Nothing.]: ...
        def tail(self) -> 'HashMap'[typing.Any, scala.runtime.Nothing.]: ...
    class HashMap1(scala.collection.immutable.HashMap[_HashMap__HashMap1__A, _HashMap__HashMap1__B], typing.Generic[_HashMap__HashMap1__A, _HashMap__HashMap1__B]):
        def __init__(self, key: _HashMap__HashMap1__A, hash: int, value: _HashMap__HashMap1__B, kv: scala.Tuple2[_HashMap__HashMap1__A, _HashMap__HashMap1__B]): ...
        def computeHashFor(self, k: _HashMap__HashMap1__A) -> int: ...
        def contains0(self, key: _HashMap__HashMap1__A, hash: int, level: int) -> bool: ...
        def ensurePair(self) -> scala.Tuple2[_HashMap__HashMap1__A, _HashMap__HashMap1__B]: ...
        def filter0(self, p: scala.Function1[scala.Tuple2[_HashMap__HashMap1__A, _HashMap__HashMap1__B], typing.Any], negate: bool, level: int, buffer: typing.List['HashMap'[_HashMap__HashMap1__A, _HashMap__HashMap1__B]], offset0: int) -> 'HashMap'[_HashMap__HashMap1__A, _HashMap__HashMap1__B]: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[scala.Tuple2[_HashMap__HashMap1__A, _HashMap__HashMap1__B], _foreach__U]) -> None: ...
        def get0(self, key: _HashMap__HashMap1__A, hash: int, level: int) -> scala.Option[_HashMap__HashMap1__B]: ...
        def getHash(self) -> int: ...
        def getKey(self) -> _HashMap__HashMap1__A: ...
        def hash(self) -> int: ...
        def iterator(self) -> scala.collection.Iterator[scala.Tuple2[_HashMap__HashMap1__A, _HashMap__HashMap1__B]]: ...
        def key(self) -> _HashMap__HashMap1__A: ...
        def kv(self) -> scala.Tuple2[_HashMap__HashMap1__A, _HashMap__HashMap1__B]: ...
        def kv_$eq(self, x$1: scala.Tuple2[_HashMap__HashMap1__A, _HashMap__HashMap1__B]) -> None: ...
        _merge0__B1 = typing.TypeVar('_merge0__B1')  # <B1>
        def merge0(self, that: 'HashMap'[_HashMap__HashMap1__A, _merge0__B1], level: int, merger: 'HashMap.Merger'[_HashMap__HashMap1__A, _merge0__B1]) -> 'HashMap'[_HashMap__HashMap1__A, _merge0__B1]: ...
        def removed0(self, key: _HashMap__HashMap1__A, hash: int, level: int) -> 'HashMap'[_HashMap__HashMap1__A, _HashMap__HashMap1__B]: ...
        def size(self) -> int: ...
        _updated0__B1 = typing.TypeVar('_updated0__B1')  # <B1>
        def updated0(self, key: _HashMap__HashMap1__A, hash: int, level: int, value: _updated0__B1, kv: scala.Tuple2[_HashMap__HashMap1__A, _updated0__B1], merger: 'HashMap.Merger'[_HashMap__HashMap1__A, _updated0__B1]) -> 'HashMap'[_HashMap__HashMap1__A, _updated0__B1]: ...
        def value(self) -> _HashMap__HashMap1__B: ...
    class HashMapCollision1(scala.collection.immutable.HashMap[_HashMap__HashMapCollision1__A, _HashMap__HashMapCollision1__B], typing.Generic[_HashMap__HashMapCollision1__A, _HashMap__HashMapCollision1__B]):
        def __init__(self, hash: int, kvs: 'ListMap'[_HashMap__HashMapCollision1__A, _HashMap__HashMapCollision1__B]): ...
        def contains0(self, key: _HashMap__HashMapCollision1__A, hash: int, level: int) -> bool: ...
        def filter0(self, p: scala.Function1[scala.Tuple2[_HashMap__HashMapCollision1__A, _HashMap__HashMapCollision1__B], typing.Any], negate: bool, level: int, buffer: typing.List['HashMap'[_HashMap__HashMapCollision1__A, _HashMap__HashMapCollision1__B]], offset0: int) -> 'HashMap'[_HashMap__HashMapCollision1__A, _HashMap__HashMapCollision1__B]: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[scala.Tuple2[_HashMap__HashMapCollision1__A, _HashMap__HashMapCollision1__B], _foreach__U]) -> None: ...
        def get0(self, key: _HashMap__HashMapCollision1__A, hash: int, level: int) -> scala.Option[_HashMap__HashMapCollision1__B]: ...
        def hash(self) -> int: ...
        def iterator(self) -> scala.collection.Iterator[scala.Tuple2[_HashMap__HashMapCollision1__A, _HashMap__HashMapCollision1__B]]: ...
        def kvs(self) -> 'ListMap'[_HashMap__HashMapCollision1__A, _HashMap__HashMapCollision1__B]: ...
        _merge0__B1 = typing.TypeVar('_merge0__B1')  # <B1>
        def merge0(self, that: 'HashMap'[_HashMap__HashMapCollision1__A, _merge0__B1], level: int, merger: 'HashMap.Merger'[_HashMap__HashMapCollision1__A, _merge0__B1]) -> 'HashMap'[_HashMap__HashMapCollision1__A, _merge0__B1]: ...
        def removed0(self, key: _HashMap__HashMapCollision1__A, hash: int, level: int) -> 'HashMap'[_HashMap__HashMapCollision1__A, _HashMap__HashMapCollision1__B]: ...
        def size(self) -> int: ...
        def split(self) -> Seq['HashMap'[_HashMap__HashMapCollision1__A, _HashMap__HashMapCollision1__B]]: ...
        _updated0__B1 = typing.TypeVar('_updated0__B1')  # <B1>
        def updated0(self, key: _HashMap__HashMapCollision1__A, hash: int, level: int, value: _updated0__B1, kv: scala.Tuple2[_HashMap__HashMapCollision1__A, _updated0__B1], merger: 'HashMap.Merger'[_HashMap__HashMapCollision1__A, _updated0__B1]) -> 'HashMap'[_HashMap__HashMapCollision1__A, _updated0__B1]: ...
    class HashTrieMap(scala.collection.immutable.HashMap[_HashMap__HashTrieMap__A, _HashMap__HashTrieMap__B], typing.Generic[_HashMap__HashTrieMap__A, _HashMap__HashTrieMap__B]):
        def __init__(self, bitmap: int, elems: typing.List['HashMap'[_HashMap__HashTrieMap__A, _HashMap__HashTrieMap__B]], size0: int): ...
        def bitmap(self) -> int: ...
        def contains0(self, key: _HashMap__HashTrieMap__A, hash: int, level: int) -> bool: ...
        def elems(self) -> typing.List['HashMap'[_HashMap__HashTrieMap__A, _HashMap__HashTrieMap__B]]: ...
        def filter0(self, p: scala.Function1[scala.Tuple2[_HashMap__HashTrieMap__A, _HashMap__HashTrieMap__B], typing.Any], negate: bool, level: int, buffer: typing.List['HashMap'[_HashMap__HashTrieMap__A, _HashMap__HashTrieMap__B]], offset0: int) -> 'HashMap'[_HashMap__HashTrieMap__A, _HashMap__HashTrieMap__B]: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[scala.Tuple2[_HashMap__HashTrieMap__A, _HashMap__HashTrieMap__B], _foreach__U]) -> None: ...
        def get0(self, key: _HashMap__HashTrieMap__A, hash: int, level: int) -> scala.Option[_HashMap__HashTrieMap__B]: ...
        def iterator(self) -> scala.collection.Iterator[scala.Tuple2[_HashMap__HashTrieMap__A, _HashMap__HashTrieMap__B]]: ...
        _merge0__B1 = typing.TypeVar('_merge0__B1')  # <B1>
        def merge0(self, that: 'HashMap'[_HashMap__HashTrieMap__A, _merge0__B1], level: int, merger: 'HashMap.Merger'[_HashMap__HashTrieMap__A, _merge0__B1]) -> 'HashMap'[_HashMap__HashTrieMap__A, _merge0__B1]: ...
        def removed0(self, key: _HashMap__HashTrieMap__A, hash: int, level: int) -> 'HashMap'[_HashMap__HashTrieMap__A, _HashMap__HashTrieMap__B]: ...
        def size(self) -> int: ...
        def size0(self) -> int: ...
        def split(self) -> Seq['HashMap'[_HashMap__HashTrieMap__A, _HashMap__HashTrieMap__B]]: ...
        _updated0__B1 = typing.TypeVar('_updated0__B1')  # <B1>
        def updated0(self, key: _HashMap__HashTrieMap__A, hash: int, level: int, value: _updated0__B1, kv: scala.Tuple2[_HashMap__HashTrieMap__A, _updated0__B1], merger: 'HashMap.Merger'[_HashMap__HashTrieMap__A, _updated0__B1]) -> 'HashMap'[_HashMap__HashTrieMap__A, _updated0__B1]: ...
    class Merger(typing.Generic[_HashMap__Merger__A, _HashMap__Merger__B]):
        def __init__(self): ...
        def apply(self, kv1: scala.Tuple2[_HashMap__Merger__A, _HashMap__Merger__B], kv2: scala.Tuple2[_HashMap__Merger__A, _HashMap__Merger__B]) -> scala.Tuple2[_HashMap__Merger__A, _HashMap__Merger__B]: ...
        def invert(self) -> 'HashMap.Merger'[_HashMap__Merger__A, _HashMap__Merger__B]: ...
    class SerializationProxy(scala.Serializable, typing.Generic[_HashMap__SerializationProxy__A, _HashMap__SerializationProxy__B]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, orig: 'HashMap'[_HashMap__SerializationProxy__A, _HashMap__SerializationProxy__B]): ...

_HashSet__HashSet1__A = typing.TypeVar('_HashSet__HashSet1__A')  # <A>
_HashSet__HashSetCollision1__A = typing.TypeVar('_HashSet__HashSetCollision1__A')  # <A>
_HashSet__HashTrieSet__A = typing.TypeVar('_HashSet__HashTrieSet__A')  # <A>
_HashSet__LeafHashSet__A = typing.TypeVar('_HashSet__LeafHashSet__A')  # <A>
_HashSet__SerializationProxy__A = typing.TypeVar('_HashSet__SerializationProxy__A')  # <A>
_HashSet__SerializationProxy__B = typing.TypeVar('_HashSet__SerializationProxy__B')  # <B>
_HashSet__A = typing.TypeVar('_HashSet__A')  # <A>
class HashSet(scala.collection.AbstractSet[_HashSet__A], scala.collection.immutable.Set[_HashSet__A], scala.collection.CustomParallelizable[_HashSet__A, scala.collection.parallel.immutable.ParHashSet[_HashSet__A]], scala.Serializable, typing.Generic[_HashSet__A]):
    serialVersionUID: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, e: _HashSet__A) -> 'HashSet'[_HashSet__A]: ...
    @typing.overload
    def $plus(self, e: _HashSet__A) -> 'HashSet'[_HashSet__A]: ...
    @typing.overload
    def $plus(self, elem1: _HashSet__A, elem2: _HashSet__A, elems: scala.collection.Seq[_HashSet__A]) -> 'HashSet'[_HashSet__A]: ...
    def apply(self, elem: _HashSet__A) -> bool: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['HashSet'[typing.Any], _canBuildFrom__A, 'HashSet'[_canBuildFrom__A]]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['HashSet']: ...
    def computeHash(self, key: _HashSet__A) -> int: ...
    def contains(self, e: _HashSet__A) -> bool: ...
    def diff(self, that: scala.collection.GenSet[_HashSet__A]) -> 'HashSet'[_HashSet__A]: ...
    def diff0(self, that: 'HashSet'[_HashSet__A], level: int, buffer: typing.List['HashSet'[_HashSet__A]], offset0: int) -> 'HashSet'[_HashSet__A]: ...
    def elemHashCode(self, key: _HashSet__A) -> int: ...
    def empty(self) -> 'HashSet'[_HashSet__A]: ...
    def filter(self, p: scala.Function1[_HashSet__A, typing.Any]) -> 'HashSet'[_HashSet__A]: ...
    def filter0(self, p: scala.Function1[_HashSet__A, typing.Any], negate: bool, level: int, buffer: typing.List['HashSet'[_HashSet__A]], offset0: int) -> 'HashSet'[_HashSet__A]: ...
    def filterNot(self, p: scala.Function1[_HashSet__A, typing.Any]) -> 'HashSet'[_HashSet__A]: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[_HashSet__A, _foreach__U]) -> None: ...
    def get0(self, key: _HashSet__A, hash: int, level: int) -> bool: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[_HashSet__A, _groupBy__K]) -> 'Map'[_groupBy__K, scala.collection.Traversable[_HashSet__A]]: ...
    def improve(self, hcode: int) -> int: ...
    def intersect(self, that: scala.collection.GenSet[_HashSet__A]) -> 'HashSet'[_HashSet__A]: ...
    def intersect0(self, that: 'HashSet'[_HashSet__A], level: int, buffer: typing.List['HashSet'[_HashSet__A]], offset0: int) -> 'HashSet'[_HashSet__A]: ...
    def iterator(self) -> scala.collection.Iterator[_HashSet__A]: ...
    def par(self) -> scala.collection.parallel.immutable.ParHashSet[_HashSet__A]: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_HashSet__A, scala.collection.parallel.immutable.ParHashSet[_HashSet__A]]: ...
    def removed0(self, key: _HashSet__A, hash: int, level: int) -> 'HashSet'[_HashSet__A]: ...
    def repr(self) -> typing.Any: ...
    def seq(self) -> 'Set'[_HashSet__A]: ...
    _setCanBuildFrom__A = typing.TypeVar('_setCanBuildFrom__A')  # <A>
    @staticmethod
    def setCanBuildFrom() -> scala.collection.generic.CanBuildFrom['HashSet'[typing.Any], _setCanBuildFrom__A, 'HashSet'[_setCanBuildFrom__A]]: ...
    def size(self) -> int: ...
    def subsetOf(self, that: scala.collection.GenSet[_HashSet__A]) -> bool: ...
    def subsetOf0(self, that: 'HashSet'[_HashSet__A], level: int) -> bool: ...
    def tail(self) -> 'HashSet'[_HashSet__A]: ...
    def thisCollection(self) -> scala.collection.Iterable[_HashSet__A]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
    def toIterable(self) -> scala.collection.Iterable[_HashSet__A]: ...
    def toSeq(self) -> scala.collection.Seq[_HashSet__A]: ...
    _toSet__B = typing.TypeVar('_toSet__B')  # <B>
    def toSet(self) -> 'Set'[_toSet__B]: ...
    def toTraversable(self) -> scala.collection.Traversable[_HashSet__A]: ...
    def union(self, that: scala.collection.GenSet[_HashSet__A]) -> 'HashSet'[_HashSet__A]: ...
    @typing.overload
    def union0(self, that: 'HashSet.LeafHashSet'[_HashSet__A], level: int) -> 'HashSet'[_HashSet__A]: ...
    @typing.overload
    def union0(self, that: 'HashSet'[_HashSet__A], level: int, buffer: typing.List['HashSet'[_HashSet__A]], offset0: int) -> 'HashSet'[_HashSet__A]: ...
    def updated0(self, key: _HashSet__A, hash: int, level: int) -> 'HashSet'[_HashSet__A]: ...
    @typing.overload
    def view(self) -> scala.collection.IterableView[_HashSet__A, scala.collection.Iterable[_HashSet__A]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.IterableView[_HashSet__A, scala.collection.Iterable[_HashSet__A]]: ...
    def writeReplace(self) -> typing.Any: ...
    class EmptyHashSet$(scala.collection.immutable.HashSet[typing.Any]):
        MODULE$: typing.ClassVar['HashSet.EmptyHashSet.'] = ...
        def __init__(self): ...
        def head(self) -> typing.Any: ...
        def tail(self) -> 'HashSet'[typing.Any]: ...
    class HashSet1(scala.collection.immutable.HashSet.LeafHashSet[_HashSet__HashSet1__A], typing.Generic[_HashSet__HashSet1__A]):
        def __init__(self, key: _HashSet__HashSet1__A, hash: int): ...
        def diff0(self, that: 'HashSet'[_HashSet__HashSet1__A], level: int, buffer: typing.List['HashSet'[_HashSet__HashSet1__A]], offset0: int) -> 'HashSet'[_HashSet__HashSet1__A]: ...
        def filter0(self, p: scala.Function1[_HashSet__HashSet1__A, typing.Any], negate: bool, level: int, buffer: typing.List['HashSet'[_HashSet__HashSet1__A]], offset0: int) -> 'HashSet'[_HashSet__HashSet1__A]: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[_HashSet__HashSet1__A, _foreach__U]) -> None: ...
        def get0(self, key: _HashSet__HashSet1__A, hash: int, level: int) -> bool: ...
        def hash(self) -> int: ...
        def intersect0(self, that: 'HashSet'[_HashSet__HashSet1__A], level: int, buffer: typing.List['HashSet'[_HashSet__HashSet1__A]], offset0: int) -> 'HashSet'[_HashSet__HashSet1__A]: ...
        def iterator(self) -> scala.collection.Iterator[_HashSet__HashSet1__A]: ...
        def key(self) -> _HashSet__HashSet1__A: ...
        def removed0(self, key: _HashSet__HashSet1__A, hash: int, level: int) -> 'HashSet'[_HashSet__HashSet1__A]: ...
        def size(self) -> int: ...
        def subsetOf0(self, that: 'HashSet'[_HashSet__HashSet1__A], level: int) -> bool: ...
        @typing.overload
        def union0(self, that: 'HashSet.LeafHashSet'[_HashSet__HashSet1__A], level: int) -> 'HashSet'[_HashSet__HashSet1__A]: ...
        @typing.overload
        def union0(self, that: 'HashSet'[_HashSet__HashSet1__A], level: int, buffer: typing.List['HashSet'[_HashSet__HashSet1__A]], offset0: int) -> 'HashSet'[_HashSet__HashSet1__A]: ...
        def updated0(self, key: _HashSet__HashSet1__A, hash: int, level: int) -> 'HashSet'[_HashSet__HashSet1__A]: ...
    class HashSetCollision1(scala.collection.immutable.HashSet.LeafHashSet[_HashSet__HashSetCollision1__A], typing.Generic[_HashSet__HashSetCollision1__A]):
        def __init__(self, hash: int, ks: 'ListSet'[_HashSet__HashSetCollision1__A]): ...
        def diff0(self, that: 'HashSet'[_HashSet__HashSetCollision1__A], level: int, buffer: typing.List['HashSet'[_HashSet__HashSetCollision1__A]], offset0: int) -> 'HashSet'[_HashSet__HashSetCollision1__A]: ...
        def filter0(self, p: scala.Function1[_HashSet__HashSetCollision1__A, typing.Any], negate: bool, level: int, buffer: typing.List['HashSet'[_HashSet__HashSetCollision1__A]], offset0: int) -> 'HashSet'[_HashSet__HashSetCollision1__A]: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[_HashSet__HashSetCollision1__A, _foreach__U]) -> None: ...
        def get0(self, key: _HashSet__HashSetCollision1__A, hash: int, level: int) -> bool: ...
        def hash(self) -> int: ...
        def intersect0(self, that: 'HashSet'[_HashSet__HashSetCollision1__A], level: int, buffer: typing.List['HashSet'[_HashSet__HashSetCollision1__A]], offset0: int) -> 'HashSet'[_HashSet__HashSetCollision1__A]: ...
        def iterator(self) -> scala.collection.Iterator[_HashSet__HashSetCollision1__A]: ...
        def ks(self) -> 'ListSet'[_HashSet__HashSetCollision1__A]: ...
        def removed0(self, key: _HashSet__HashSetCollision1__A, hash: int, level: int) -> 'HashSet'[_HashSet__HashSetCollision1__A]: ...
        def size(self) -> int: ...
        def subsetOf0(self, that: 'HashSet'[_HashSet__HashSetCollision1__A], level: int) -> bool: ...
        @typing.overload
        def union0(self, that: 'HashSet.LeafHashSet'[_HashSet__HashSetCollision1__A], level: int) -> 'HashSet'[_HashSet__HashSetCollision1__A]: ...
        @typing.overload
        def union0(self, that: 'HashSet'[_HashSet__HashSetCollision1__A], level: int, buffer: typing.List['HashSet'[_HashSet__HashSetCollision1__A]], offset0: int) -> 'HashSet'[_HashSet__HashSetCollision1__A]: ...
        def updated0(self, key: _HashSet__HashSetCollision1__A, hash: int, level: int) -> 'HashSet'[_HashSet__HashSetCollision1__A]: ...
    class HashTrieSet(scala.collection.immutable.HashSet[_HashSet__HashTrieSet__A], typing.Generic[_HashSet__HashTrieSet__A]):
        def __init__(self, bitmap: int, elems: typing.List['HashSet'[_HashSet__HashTrieSet__A]], size0: int): ...
        def diff0(self, that: 'HashSet'[_HashSet__HashTrieSet__A], level: int, buffer: typing.List['HashSet'[_HashSet__HashTrieSet__A]], offset0: int) -> 'HashSet'[_HashSet__HashTrieSet__A]: ...
        def elems(self) -> typing.List['HashSet'[_HashSet__HashTrieSet__A]]: ...
        def filter0(self, p: scala.Function1[_HashSet__HashTrieSet__A, typing.Any], negate: bool, level: int, buffer: typing.List['HashSet'[_HashSet__HashTrieSet__A]], offset0: int) -> 'HashSet'[_HashSet__HashTrieSet__A]: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[_HashSet__HashTrieSet__A, _foreach__U]) -> None: ...
        def get0(self, key: _HashSet__HashTrieSet__A, hash: int, level: int) -> bool: ...
        def intersect0(self, that: 'HashSet'[_HashSet__HashTrieSet__A], level: int, buffer: typing.List['HashSet'[_HashSet__HashTrieSet__A]], offset0: int) -> 'HashSet'[_HashSet__HashTrieSet__A]: ...
        def iterator(self) -> 'TrieIterator'[_HashSet__HashTrieSet__A]: ...
        def removed0(self, key: _HashSet__HashTrieSet__A, hash: int, level: int) -> 'HashSet'[_HashSet__HashTrieSet__A]: ...
        def size(self) -> int: ...
        def subsetOf0(self, that: 'HashSet'[_HashSet__HashTrieSet__A], level: int) -> bool: ...
        @typing.overload
        def union0(self, that: 'HashSet.LeafHashSet'[_HashSet__HashTrieSet__A], level: int) -> 'HashSet'[_HashSet__HashTrieSet__A]: ...
        @typing.overload
        def union0(self, that: 'HashSet'[_HashSet__HashTrieSet__A], level: int, buffer: typing.List['HashSet'[_HashSet__HashTrieSet__A]], offset0: int) -> 'HashSet'[_HashSet__HashTrieSet__A]: ...
        def updated0(self, key: _HashSet__HashTrieSet__A, hash: int, level: int) -> 'HashSet'[_HashSet__HashTrieSet__A]: ...
    class LeafHashSet(scala.collection.immutable.HashSet[_HashSet__LeafHashSet__A], typing.Generic[_HashSet__LeafHashSet__A]):
        def __init__(self): ...
        def hash(self) -> int: ...
    class SerializationProxy(scala.Serializable, typing.Generic[_HashSet__SerializationProxy__A, _HashSet__SerializationProxy__B]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, orig: 'HashSet'[_HashSet__SerializationProxy__A]): ...

_IndexedSeq__Impl__A = typing.TypeVar('_IndexedSeq__Impl__A')  # <A>
_IndexedSeq__A = typing.TypeVar('_IndexedSeq__A')  # <A>
class IndexedSeq(Seq[_IndexedSeq__A], scala.collection.IndexedSeq[_IndexedSeq__A], typing.Generic[_IndexedSeq__A]):
    @staticmethod
    def $init$($this: 'IndexedSeq') -> None: ...
    @staticmethod
    def ReusableCBF() -> scala.collection.generic.GenTraversableFactory.GenericCanBuildFrom[scala.runtime.Nothing.]: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['IndexedSeq'[typing.Any], _canBuildFrom__A, 'IndexedSeq'[_canBuildFrom__A]]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['IndexedSeq']: ...
    @staticmethod
    def concat(xss: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    @staticmethod
    def empty() -> scala.collection.GenTraversable: ...
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, n5: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    def hashCode(self) -> int: ...
    @staticmethod
    def iterate(start: typing.Any, len: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, step: typing.Any, evidence$2: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, evidence$1: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_IndexedSeq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_IndexedSeq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.IndexedSeq[_IndexedSeq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Iterable[_IndexedSeq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Seq[_IndexedSeq__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Traversable[_IndexedSeq__A]: ...
    @typing.overload
    def seq(self) -> 'IndexedSeq'[_IndexedSeq__A]: ...
    @typing.overload
    def seq(self) -> Iterable[_IndexedSeq__A]: ...
    @typing.overload
    def seq(self) -> Seq[_IndexedSeq__A]: ...
    @typing.overload
    def seq(self) -> Traversable[_IndexedSeq__A]: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, n5: int, f: scala.Function5) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, f: scala.Function4) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, f: scala.Function3) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, f: scala.Function2) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def toIndexedSeq(self) -> 'IndexedSeq'[_IndexedSeq__A]: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapplySeq(x: scala.collection.Seq) -> scala.Some: ...
    class Impl(scala.collection.AbstractSeq[_IndexedSeq__Impl__A], scala.collection.immutable.IndexedSeq[_IndexedSeq__Impl__A], scala.Serializable, typing.Generic[_IndexedSeq__Impl__A]):
        def __init__(self, buf: scala.collection.mutable.ArrayBuffer[_IndexedSeq__Impl__A]): ...
        def apply(self, idx: int) -> _IndexedSeq__Impl__A: ...
        def companion(self) -> scala.collection.generic.GenericCompanion['IndexedSeq']: ...
        _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
        def groupBy(self, f: scala.Function1[_IndexedSeq__Impl__A, _groupBy__K]) -> 'Map'[_groupBy__K, scala.collection.Traversable[_IndexedSeq__Impl__A]]: ...
        def hashCode(self) -> int: ...
        def isDefinedAt(self, idx: int) -> bool: ...
        def iterator(self) -> scala.collection.Iterator[_IndexedSeq__Impl__A]: ...
        def length(self) -> int: ...
        def parCombiner(self) -> scala.collection.parallel.Combiner[_IndexedSeq__Impl__A, scala.collection.parallel.immutable.ParSeq[_IndexedSeq__Impl__A]]: ...
        def seq(self) -> 'IndexedSeq'[_IndexedSeq__Impl__A]: ...
        def sizeHintIfCheap(self) -> int: ...
        def thisCollection(self) -> scala.collection.IndexedSeq[_IndexedSeq__Impl__A]: ...
        _toBuffer__A1 = typing.TypeVar('_toBuffer__A1')  # <A1>
        def toBuffer(self) -> scala.collection.mutable.Buffer[_toBuffer__A1]: ...
        def toCollection(self, repr: typing.Any) -> scala.collection.IndexedSeq: ...
        def toIndexedSeq(self) -> 'IndexedSeq'[_IndexedSeq__Impl__A]: ...
        def toIterable(self) -> scala.collection.Iterable[_IndexedSeq__Impl__A]: ...
        def toSeq(self) -> Seq[_IndexedSeq__Impl__A]: ...
        def toTraversable(self) -> scala.collection.Traversable[_IndexedSeq__Impl__A]: ...
        @typing.overload
        def view(self) -> scala.collection.SeqView[_IndexedSeq__Impl__A, scala.collection.Seq[_IndexedSeq__Impl__A]]: ...
        @typing.overload
        def view(self, from_: int, until: int) -> scala.collection.SeqView[_IndexedSeq__Impl__A, scala.collection.Seq[_IndexedSeq__Impl__A]]: ...

_IntMap__Bin__T = typing.TypeVar('_IntMap__Bin__T')  # <T>
_IntMap__Tip__T = typing.TypeVar('_IntMap__Tip__T')  # <T>
_IntMap__T = typing.TypeVar('_IntMap__T')  # <T>
class IntMap(AbstractMap[typing.Any, _IntMap__T], typing.Generic[_IntMap__T]):
    def __init__(self): ...
    @typing.overload
    def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, key: int) -> 'IntMap'[_IntMap__T]: ...
    _$plus_0__S = typing.TypeVar('_$plus_0__S')  # <S>
    _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
    @typing.overload
    def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_0__S]) -> 'IntMap'[_.plus_0__S]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[typing.Any, _.plus_1__V1], elem2: scala.Tuple2[typing.Any, _.plus_1__V1], elems: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_1__V1]]) -> 'Map'[typing.Any, _.plus_1__V1]: ...
    _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
    _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
    _$plus$plus_1__S = typing.TypeVar('_$plus$plus_1__S')  # <S>
    _$plus$plus_2__V1 = typing.TypeVar('_$plus$plus_2__V1')  # <V1>
    @typing.overload
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus_0__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Traversable[typing.Any], _.plus.plus_0__B, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
    @typing.overload
    def $plus$plus(self, that: 'IntMap'[_.plus.plus_1__S]) -> 'IntMap'[_.plus.plus_1__S]: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[typing.Any, _.plus.plus_2__V1]]) -> 'Map'[typing.Any, _.plus.plus_2__V1]: ...
    def apply(self, key: int) -> _IntMap__T: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    _canBuildFrom__B = typing.TypeVar('_canBuildFrom__B')  # <B>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['IntMap'[_canBuildFrom__A], scala.Tuple2[typing.Any, _canBuildFrom__B], 'IntMap'[_canBuildFrom__B]]: ...
    def empty(self) -> 'IntMap'[_IntMap__T]: ...
    def filter(self, f: scala.Function1[scala.Tuple2[typing.Any, _IntMap__T], typing.Any]) -> 'IntMap'[_IntMap__T]: ...
    def filterKeys(self, p: scala.Function1[typing.Any, typing.Any]) -> 'Map'[typing.Any, typing.Any]: ...
    def filterNot(self, p: scala.Function1[scala.Tuple2[typing.Any, typing.Any], typing.Any]) -> scala.collection.Map[typing.Any, typing.Any]: ...
    def firstKey(self) -> int: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[scala.Tuple2[typing.Any, _IntMap__T], _foreach__U]) -> None: ...
    def foreachKey(self, f: scala.Function1[typing.Any, scala.runtime.BoxedUnit]) -> None: ...
    def foreachValue(self, f: scala.Function1[_IntMap__T, scala.runtime.BoxedUnit]) -> None: ...
    def get(self, key: int) -> scala.Option[_IntMap__T]: ...
    _getOrElse__S = typing.TypeVar('_getOrElse__S')  # <S>
    def getOrElse(self, key: int, default: scala.Function0[_getOrElse__S]) -> _getOrElse__S: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[typing.Any, _groupBy__K]) -> 'Map'[_groupBy__K, scala.collection.Traversable[typing.Any]]: ...
    _intersection__R = typing.TypeVar('_intersection__R')  # <R>
    def intersection(self, that: 'IntMap'[_intersection__R]) -> 'IntMap'[_IntMap__T]: ...
    _intersectionWith__S = typing.TypeVar('_intersectionWith__S')  # <S>
    _intersectionWith__R = typing.TypeVar('_intersectionWith__R')  # <R>
    def intersectionWith(self, that: 'IntMap'[_intersectionWith__S], f: scala.Function3[typing.Any, _IntMap__T, _intersectionWith__S, _intersectionWith__R]) -> 'IntMap'[_intersectionWith__R]: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[scala.Tuple2[typing.Any, _IntMap__T]]: ...
    def keySet(self) -> 'Set'[typing.Any]: ...
    def keys(self) -> scala.collection.Iterable[typing.Any]: ...
    def keysIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def lastKey(self) -> int: ...
    _mapValues__W = typing.TypeVar('_mapValues__W')  # <W>
    def mapValues(self, f: scala.Function1[typing.Any, _mapValues__W]) -> 'Map'[typing.Any, _mapValues__W]: ...
    _modifyOrRemove__S = typing.TypeVar('_modifyOrRemove__S')  # <S>
    def modifyOrRemove(self, f: scala.Function2[typing.Any, _IntMap__T, scala.Option[_modifyOrRemove__S]]) -> 'IntMap'[_modifyOrRemove__S]: ...
    def repr(self) -> typing.Any: ...
    def seq(self) -> 'Map'[typing.Any, typing.Any]: ...
    _singleton__T = typing.TypeVar('_singleton__T')  # <T>
    @staticmethod
    def singleton(key: int, value: _singleton__T) -> 'IntMap'[_singleton__T]: ...
    def size(self) -> int: ...
    def stringPrefix(self) -> java.lang.String: ...
    def thisCollection(self) -> scala.collection.Iterable[typing.Any]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
    def toIterable(self) -> scala.collection.Iterable[typing.Any]: ...
    def toList(self) -> List[scala.Tuple2[typing.Any, _IntMap__T]]: ...
    def toSeq(self) -> scala.collection.Seq[scala.Tuple2[typing.Any, typing.Any]]: ...
    def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
    _transform_0__W = typing.TypeVar('_transform_0__W')  # <W>
    _transform_0__That = typing.TypeVar('_transform_0__That')  # <That>
    _transform_1__S = typing.TypeVar('_transform_1__S')  # <S>
    @typing.overload
    def transform(self, f: scala.Function2[typing.Any, typing.Any, _transform_0__W], bf: scala.collection.generic.CanBuildFrom['Map'[typing.Any, typing.Any], scala.Tuple2[typing.Any, _transform_0__W], _transform_0__That]) -> _transform_0__That: ...
    @typing.overload
    def transform(self, f: scala.Function2[typing.Any, _IntMap__T, _transform_1__S]) -> 'IntMap'[_transform_1__S]: ...
    _unionWith__S = typing.TypeVar('_unionWith__S')  # <S>
    def unionWith(self, that: 'IntMap'[_unionWith__S], f: scala.Function3[typing.Any, _unionWith__S, _unionWith__S, _unionWith__S]) -> 'IntMap'[_unionWith__S]: ...
    _updateWith__S = typing.TypeVar('_updateWith__S')  # <S>
    def updateWith(self, key: int, value: _updateWith__S, f: scala.Function2[_IntMap__T, _updateWith__S, _updateWith__S]) -> 'IntMap'[_updateWith__S]: ...
    _updated__S = typing.TypeVar('_updated__S')  # <S>
    def updated(self, key: int, value: _updated__S) -> 'IntMap'[_updated__S]: ...
    def values(self) -> scala.collection.Iterable[typing.Any]: ...
    def valuesIterator(self) -> scala.collection.Iterator[_IntMap__T]: ...
    @typing.overload
    def view(self) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
    class Bin(scala.collection.immutable.IntMap[_IntMap__Bin__T], scala.Product, scala.Serializable, typing.Generic[_IntMap__Bin__T]):
        def __init__(self, prefix: int, mask: int, left: 'IntMap'[_IntMap__Bin__T], right: 'IntMap'[_IntMap__Bin__T]): ...
        _bin__S = typing.TypeVar('_bin__S')  # <S>
        def bin(self, left: 'IntMap'[_bin__S], right: 'IntMap'[_bin__S]) -> 'IntMap'[_bin__S]: ...
        _copy__T = typing.TypeVar('_copy__T')  # <T>
        def copy(self, prefix: int, mask: int, left: 'IntMap'[typing.Any], right: 'IntMap'[typing.Any]) -> 'IntMap.Bin'[typing.Any]: ...
        _copy$default$1__T = typing.TypeVar('_copy$default$1__T')  # <T>
        def copy$default$1(self) -> int: ...
        _copy$default$2__T = typing.TypeVar('_copy$default$2__T')  # <T>
        def copy$default$2(self) -> int: ...
        _copy$default$3__T = typing.TypeVar('_copy$default$3__T')  # <T>
        def copy$default$3(self) -> 'IntMap'[typing.Any]: ...
        _copy$default$4__T = typing.TypeVar('_copy$default$4__T')  # <T>
        def copy$default$4(self) -> 'IntMap'[typing.Any]: ...
        def left(self) -> 'IntMap'[_IntMap__Bin__T]: ...
        def mask(self) -> int: ...
        def prefix(self) -> int: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def right(self) -> 'IntMap'[_IntMap__Bin__T]: ...
    class Bin$(scala.Serializable):
        MODULE$: typing.ClassVar['IntMap.Bin.'] = ...
        def __init__(self): ...
        _apply__T = typing.TypeVar('_apply__T')  # <T>
        def apply(self, prefix: int, mask: int, left: 'IntMap'[_apply__T], right: 'IntMap'[_apply__T]) -> 'IntMap.Bin'[_apply__T]: ...
        def toString(self) -> java.lang.String: ...
        _unapply__T = typing.TypeVar('_unapply__T')  # <T>
        def unapply(self, x$0: 'IntMap.Bin'[_unapply__T]) -> scala.Option[scala.Tuple4[typing.Any, typing.Any, 'IntMap'[_unapply__T], 'IntMap'[_unapply__T]]]: ...
    class Nil$(scala.collection.immutable.IntMap[scala.runtime.Nothing.], scala.Product, scala.Serializable):
        MODULE$: typing.ClassVar['IntMap.Nil.'] = ...
        def __init__(self): ...
        def equals(self, that: typing.Any) -> bool: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
    class Tip(scala.collection.immutable.IntMap[_IntMap__Tip__T], scala.Product, scala.Serializable, typing.Generic[_IntMap__Tip__T]):
        def __init__(self, key: int, value: _IntMap__Tip__T): ...
        _copy__T = typing.TypeVar('_copy__T')  # <T>
        def copy(self, key: int, value: typing.Any) -> 'IntMap.Tip'[typing.Any]: ...
        _copy$default$1__T = typing.TypeVar('_copy$default$1__T')  # <T>
        def copy$default$1(self) -> int: ...
        _copy$default$2__T = typing.TypeVar('_copy$default$2__T')  # <T>
        def copy$default$2(self) -> typing.Any: ...
        def key(self) -> int: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def value(self) -> _IntMap__Tip__T: ...
        _withValue__S = typing.TypeVar('_withValue__S')  # <S>
        def withValue(self, s: _withValue__S) -> 'IntMap.Tip'[_withValue__S]: ...
    class Tip$(scala.Serializable):
        MODULE$: typing.ClassVar['IntMap.Tip.'] = ...
        def __init__(self): ...
        _apply__T = typing.TypeVar('_apply__T')  # <T>
        def apply(self, key: int, value: _apply__T) -> 'IntMap.Tip'[_apply__T]: ...
        def toString(self) -> java.lang.String: ...
        _unapply__T = typing.TypeVar('_unapply__T')  # <T>
        def unapply(self, x$0: 'IntMap.Tip'[_unapply__T]) -> scala.Option[scala.Tuple2[typing.Any, _unapply__T]]: ...

_ListMap__Node__B1 = typing.TypeVar('_ListMap__Node__B1')  # <B1>
_ListMap__A = typing.TypeVar('_ListMap__A')  # <A>
_ListMap__B = typing.TypeVar('_ListMap__B')  # <B>
class ListMap(AbstractMap[_ListMap__A, _ListMap__B], scala.Serializable, typing.Generic[_ListMap__A, _ListMap__B]):
    serialVersionUID: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, key: _ListMap__A) -> 'ListMap'[_ListMap__A, _ListMap__B]: ...
    _$plus_0__B1 = typing.TypeVar('_$plus_0__B1')  # <B1>
    _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_ListMap__A, _.plus_0__B1]) -> 'ListMap'[_ListMap__A, _.plus_0__B1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[typing.Any, _.plus_1__V1], elem2: scala.Tuple2[typing.Any, _.plus_1__V1], elems: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_1__V1]]) -> 'Map'[typing.Any, _.plus_1__V1]: ...
    _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
    _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
    _$plus$plus_1__B1 = typing.TypeVar('_$plus$plus_1__B1')  # <B1>
    @typing.overload
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[typing.Any], bf: scala.collection.generic.CanBuildFrom[scala.collection.Traversable[_ListMap__A], typing.Any, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[_ListMap__A, _.plus.plus_1__B1]]) -> 'ListMap'[_ListMap__A, _.plus.plus_1__B1]: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    _canBuildFrom__B = typing.TypeVar('_canBuildFrom__B')  # <B>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['ListMap'[typing.Any, typing.Any], scala.Tuple2[_canBuildFrom__A, _canBuildFrom__B], 'ListMap'[_canBuildFrom__A, _canBuildFrom__B]]: ...
    def empty(self) -> 'ListMap'[_ListMap__A, scala.runtime.Nothing.]: ...
    def filterKeys(self, p: scala.Function1[typing.Any, typing.Any]) -> 'Map'[typing.Any, typing.Any]: ...
    def filterNot(self, p: scala.Function1[scala.Tuple2[typing.Any, typing.Any], typing.Any]) -> scala.collection.Map[typing.Any, typing.Any]: ...
    def get(self, key: _ListMap__A) -> scala.Option[_ListMap__B]: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[_ListMap__A, _groupBy__K]) -> 'Map'[_groupBy__K, scala.collection.Traversable[_ListMap__A]]: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[scala.Tuple2[_ListMap__A, _ListMap__B]]: ...
    def key(self) -> _ListMap__A: ...
    def keySet(self) -> 'Set'[typing.Any]: ...
    def keys(self) -> scala.collection.Iterable[typing.Any]: ...
    _mapValues__W = typing.TypeVar('_mapValues__W')  # <W>
    def mapValues(self, f: scala.Function1[typing.Any, _mapValues__W]) -> 'Map'[typing.Any, _mapValues__W]: ...
    def next(self) -> 'ListMap'[_ListMap__A, _ListMap__B]: ...
    def repr(self) -> typing.Any: ...
    def seq(self) -> 'Map'[typing.Any, typing.Any]: ...
    def size(self) -> int: ...
    def stringPrefix(self) -> java.lang.String: ...
    def thisCollection(self) -> scala.collection.Iterable[_ListMap__A]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
    def toIterable(self) -> scala.collection.Iterable[_ListMap__A]: ...
    def toSeq(self) -> scala.collection.Seq[scala.Tuple2[typing.Any, typing.Any]]: ...
    def toTraversable(self) -> scala.collection.Traversable[_ListMap__A]: ...
    _updated__B1 = typing.TypeVar('_updated__B1')  # <B1>
    def updated(self, key: _ListMap__A, value: _updated__B1) -> 'ListMap'[_ListMap__A, _updated__B1]: ...
    def value(self) -> _ListMap__B: ...
    def values(self) -> scala.collection.Iterable[typing.Any]: ...
    @typing.overload
    def view(self) -> scala.collection.IterableView[_ListMap__A, scala.collection.Iterable[_ListMap__A]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.IterableView[_ListMap__A, scala.collection.Iterable[_ListMap__A]]: ...
    class EmptyListMap$(scala.collection.immutable.ListMap[typing.Any, scala.runtime.Nothing.]):
        MODULE$: typing.ClassVar['ListMap.EmptyListMap.'] = ...
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self): ...
    class Node(scala.collection.immutable.ListMap[_ListMap__A, _ListMap__Node__B1], typing.Generic[_ListMap__Node__B1]):
        serialVersionUID: typing.ClassVar[int] = ...
        $outer: 'ListMap' = ...
        def __init__(self, $outer: 'ListMap', key: _ListMap__A, value: _ListMap__Node__B1): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, k: _ListMap__A) -> 'ListMap'[_ListMap__A, _ListMap__Node__B1]: ...
        _$plus_0__B2 = typing.TypeVar('_$plus_0__B2')  # <B2>
        _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
        @typing.overload
        def $plus(self, kv: scala.Tuple2[_ListMap__A, _.plus_0__B2]) -> 'ListMap'[_ListMap__A, _.plus_0__B2]: ...
        @typing.overload
        def $plus(self, elem1: scala.Tuple2[typing.Any, _.plus_1__V1], elem2: scala.Tuple2[typing.Any, _.plus_1__V1], elems: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_1__V1]]) -> 'Map'[typing.Any, _.plus_1__V1]: ...
        def apply(self, k: _ListMap__A) -> _ListMap__Node__B1: ...
        def contains(self, k: _ListMap__A) -> bool: ...
        def get(self, k: _ListMap__A) -> scala.Option[_ListMap__Node__B1]: ...
        def init(self) -> 'ListMap'[_ListMap__A, _ListMap__Node__B1]: ...
        def isEmpty(self) -> bool: ...
        def key(self) -> _ListMap__A: ...
        def last(self) -> scala.Tuple2[_ListMap__A, _ListMap__Node__B1]: ...
        def next(self) -> 'ListMap'[_ListMap__A, _ListMap__Node__B1]: ...
        def size(self) -> int: ...
        _updated__B2 = typing.TypeVar('_updated__B2')  # <B2>
        def updated(self, k: _ListMap__A, v: _updated__B2) -> 'ListMap'[_ListMap__A, _updated__B2]: ...
        def value(self) -> _ListMap__Node__B1: ...

_ListSet__A = typing.TypeVar('_ListSet__A')  # <A>
class ListSet(scala.collection.AbstractSet[_ListSet__A], scala.collection.immutable.Set[_ListSet__A], scala.Serializable, typing.Generic[_ListSet__A]):
    serialVersionUID: typing.ClassVar[int] = ...
    def __init__(self): ...
    @typing.overload
    def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, elem: _ListSet__A) -> 'ListSet'[_ListSet__A]: ...
    @typing.overload
    def $plus(self, elem1: _ListSet__A, elem2: _ListSet__A, elems: scala.collection.Seq[_ListSet__A]) -> scala.collection.Set[_ListSet__A]: ...
    @typing.overload
    def $plus(self, elem: _ListSet__A) -> 'ListSet'[_ListSet__A]: ...
    _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
    _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
    @typing.overload
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus_0__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Traversable[_ListSet__A], _.plus.plus_0__B, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[_ListSet__A]) -> 'ListSet'[_ListSet__A]: ...
    def apply(self, elem: _ListSet__A) -> bool: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['ListSet'[typing.Any], _canBuildFrom__A, 'ListSet'[_canBuildFrom__A]]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['ListSet']: ...
    def contains(self, elem: _ListSet__A) -> bool: ...
    def diff(self, that: scala.collection.GenSet[_ListSet__A]) -> scala.collection.Set[_ListSet__A]: ...
    def elem(self) -> _ListSet__A: ...
    def empty(self) -> scala.collection.GenSet: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[_ListSet__A, _groupBy__K]) -> 'Map'[_groupBy__K, scala.collection.Traversable[_ListSet__A]]: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[_ListSet__A]: ...
    def next(self) -> 'ListSet'[_ListSet__A]: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_ListSet__A, scala.collection.parallel.immutable.ParSet[_ListSet__A]]: ...
    def repr(self) -> typing.Any: ...
    def seq(self) -> 'Set'[_ListSet__A]: ...
    _setCanBuildFrom__A = typing.TypeVar('_setCanBuildFrom__A')  # <A>
    @staticmethod
    def setCanBuildFrom() -> scala.collection.generic.CanBuildFrom['ListSet'[typing.Any], _setCanBuildFrom__A, 'ListSet'[_setCanBuildFrom__A]]: ...
    def size(self) -> int: ...
    def stringPrefix(self) -> java.lang.String: ...
    def thisCollection(self) -> scala.collection.Iterable[_ListSet__A]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
    def toIterable(self) -> scala.collection.Iterable[_ListSet__A]: ...
    def toSeq(self) -> scala.collection.Seq[_ListSet__A]: ...
    _toSet__B = typing.TypeVar('_toSet__B')  # <B>
    def toSet(self) -> 'Set'[_toSet__B]: ...
    def toTraversable(self) -> scala.collection.Traversable[_ListSet__A]: ...
    def union(self, that: scala.collection.GenSet[_ListSet__A]) -> scala.collection.Set[_ListSet__A]: ...
    @typing.overload
    def view(self) -> scala.collection.IterableView[_ListSet__A, scala.collection.Iterable[_ListSet__A]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.IterableView[_ListSet__A, scala.collection.Iterable[_ListSet__A]]: ...
    class EmptyListSet$(scala.collection.immutable.ListSet[typing.Any]):
        MODULE$: typing.ClassVar['ListSet.EmptyListSet.'] = ...
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self): ...
    class Node(scala.collection.immutable.ListSet[_ListSet__A]):
        serialVersionUID: typing.ClassVar[int] = ...
        $outer: 'ListSet' = ...
        def __init__(self, $outer: 'ListSet', elem: _ListSet__A): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, e: _ListSet__A) -> 'ListSet'[_ListSet__A]: ...
        @typing.overload
        def $plus(self, elem1: _ListSet__A, elem2: _ListSet__A, elems: scala.collection.Seq[_ListSet__A]) -> scala.collection.Set[_ListSet__A]: ...
        @typing.overload
        def $plus(self, e: _ListSet__A) -> 'ListSet'[_ListSet__A]: ...
        def contains(self, e: _ListSet__A) -> bool: ...
        def elem(self) -> _ListSet__A: ...
        def init(self) -> 'ListSet'[_ListSet__A]: ...
        def isEmpty(self) -> bool: ...
        def last(self) -> _ListSet__A: ...
        def next(self) -> 'ListSet'[_ListSet__A]: ...
        def size(self) -> int: ...

_LongMap__Bin__T = typing.TypeVar('_LongMap__Bin__T')  # <T>
_LongMap__Tip__T = typing.TypeVar('_LongMap__Tip__T')  # <T>
_LongMap__T = typing.TypeVar('_LongMap__T')  # <T>
class LongMap(AbstractMap[typing.Any, _LongMap__T], typing.Generic[_LongMap__T]):
    def __init__(self): ...
    @typing.overload
    def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, key: int) -> 'LongMap'[_LongMap__T]: ...
    _$plus_0__S = typing.TypeVar('_$plus_0__S')  # <S>
    _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
    @typing.overload
    def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_0__S]) -> 'LongMap'[_.plus_0__S]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[typing.Any, _.plus_1__V1], elem2: scala.Tuple2[typing.Any, _.plus_1__V1], elems: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_1__V1]]) -> 'Map'[typing.Any, _.plus_1__V1]: ...
    _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
    _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
    _$plus$plus_1__S = typing.TypeVar('_$plus$plus_1__S')  # <S>
    _$plus$plus_2__V1 = typing.TypeVar('_$plus$plus_2__V1')  # <V1>
    @typing.overload
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus_0__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Traversable[typing.Any], _.plus.plus_0__B, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
    @typing.overload
    def $plus$plus(self, that: 'LongMap'[_.plus.plus_1__S]) -> 'LongMap'[_.plus.plus_1__S]: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[typing.Any, _.plus.plus_2__V1]]) -> 'Map'[typing.Any, _.plus.plus_2__V1]: ...
    def apply(self, key: int) -> _LongMap__T: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    _canBuildFrom__B = typing.TypeVar('_canBuildFrom__B')  # <B>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['LongMap'[_canBuildFrom__A], scala.Tuple2[typing.Any, _canBuildFrom__B], 'LongMap'[_canBuildFrom__B]]: ...
    def empty(self) -> 'LongMap'[_LongMap__T]: ...
    def filter(self, f: scala.Function1[scala.Tuple2[typing.Any, _LongMap__T], typing.Any]) -> 'LongMap'[_LongMap__T]: ...
    def filterKeys(self, p: scala.Function1[typing.Any, typing.Any]) -> 'Map'[typing.Any, typing.Any]: ...
    def filterNot(self, p: scala.Function1[scala.Tuple2[typing.Any, typing.Any], typing.Any]) -> scala.collection.Map[typing.Any, typing.Any]: ...
    def firstKey(self) -> int: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[scala.Tuple2[typing.Any, _LongMap__T], _foreach__U]) -> None: ...
    def foreachKey(self, f: scala.Function1[typing.Any, scala.runtime.BoxedUnit]) -> None: ...
    def foreachValue(self, f: scala.Function1[_LongMap__T, scala.runtime.BoxedUnit]) -> None: ...
    def get(self, key: int) -> scala.Option[_LongMap__T]: ...
    _getOrElse__S = typing.TypeVar('_getOrElse__S')  # <S>
    def getOrElse(self, key: int, default: scala.Function0[_getOrElse__S]) -> _getOrElse__S: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[typing.Any, _groupBy__K]) -> 'Map'[_groupBy__K, scala.collection.Traversable[typing.Any]]: ...
    _intersection__R = typing.TypeVar('_intersection__R')  # <R>
    def intersection(self, that: 'LongMap'[_intersection__R]) -> 'LongMap'[_LongMap__T]: ...
    _intersectionWith__S = typing.TypeVar('_intersectionWith__S')  # <S>
    _intersectionWith__R = typing.TypeVar('_intersectionWith__R')  # <R>
    def intersectionWith(self, that: 'LongMap'[_intersectionWith__S], f: scala.Function3[typing.Any, _LongMap__T, _intersectionWith__S, _intersectionWith__R]) -> 'LongMap'[_intersectionWith__R]: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[scala.Tuple2[typing.Any, _LongMap__T]]: ...
    def keySet(self) -> 'Set'[typing.Any]: ...
    def keys(self) -> scala.collection.Iterable[typing.Any]: ...
    def keysIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def lastKey(self) -> int: ...
    _mapValues__W = typing.TypeVar('_mapValues__W')  # <W>
    def mapValues(self, f: scala.Function1[typing.Any, _mapValues__W]) -> 'Map'[typing.Any, _mapValues__W]: ...
    _modifyOrRemove__S = typing.TypeVar('_modifyOrRemove__S')  # <S>
    def modifyOrRemove(self, f: scala.Function2[typing.Any, _LongMap__T, scala.Option[_modifyOrRemove__S]]) -> 'LongMap'[_modifyOrRemove__S]: ...
    def repr(self) -> typing.Any: ...
    def seq(self) -> 'Map'[typing.Any, typing.Any]: ...
    _singleton__T = typing.TypeVar('_singleton__T')  # <T>
    @staticmethod
    def singleton(key: int, value: _singleton__T) -> 'LongMap'[_singleton__T]: ...
    def size(self) -> int: ...
    def stringPrefix(self) -> java.lang.String: ...
    def thisCollection(self) -> scala.collection.Iterable[typing.Any]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
    def toIterable(self) -> scala.collection.Iterable[typing.Any]: ...
    def toList(self) -> List[scala.Tuple2[typing.Any, _LongMap__T]]: ...
    def toSeq(self) -> scala.collection.Seq[scala.Tuple2[typing.Any, typing.Any]]: ...
    def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
    _transform_0__W = typing.TypeVar('_transform_0__W')  # <W>
    _transform_0__That = typing.TypeVar('_transform_0__That')  # <That>
    _transform_1__S = typing.TypeVar('_transform_1__S')  # <S>
    @typing.overload
    def transform(self, f: scala.Function2[typing.Any, typing.Any, _transform_0__W], bf: scala.collection.generic.CanBuildFrom['Map'[typing.Any, typing.Any], scala.Tuple2[typing.Any, _transform_0__W], _transform_0__That]) -> _transform_0__That: ...
    @typing.overload
    def transform(self, f: scala.Function2[typing.Any, _LongMap__T, _transform_1__S]) -> 'LongMap'[_transform_1__S]: ...
    _unionWith__S = typing.TypeVar('_unionWith__S')  # <S>
    def unionWith(self, that: 'LongMap'[_unionWith__S], f: scala.Function3[typing.Any, _unionWith__S, _unionWith__S, _unionWith__S]) -> 'LongMap'[_unionWith__S]: ...
    _updateWith__S = typing.TypeVar('_updateWith__S')  # <S>
    def updateWith(self, key: int, value: _updateWith__S, f: scala.Function2[_LongMap__T, _updateWith__S, _updateWith__S]) -> 'LongMap'[_updateWith__S]: ...
    _updated__S = typing.TypeVar('_updated__S')  # <S>
    def updated(self, key: int, value: _updated__S) -> 'LongMap'[_updated__S]: ...
    def values(self) -> scala.collection.Iterable[typing.Any]: ...
    def valuesIterator(self) -> scala.collection.Iterator[_LongMap__T]: ...
    @typing.overload
    def view(self) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
    class Bin(scala.collection.immutable.LongMap[_LongMap__Bin__T], scala.Product, scala.Serializable, typing.Generic[_LongMap__Bin__T]):
        def __init__(self, prefix: int, mask: int, left: 'LongMap'[_LongMap__Bin__T], right: 'LongMap'[_LongMap__Bin__T]): ...
        _bin__S = typing.TypeVar('_bin__S')  # <S>
        def bin(self, left: 'LongMap'[_bin__S], right: 'LongMap'[_bin__S]) -> 'LongMap'[_bin__S]: ...
        _copy__T = typing.TypeVar('_copy__T')  # <T>
        def copy(self, prefix: int, mask: int, left: 'LongMap'[typing.Any], right: 'LongMap'[typing.Any]) -> 'LongMap.Bin'[typing.Any]: ...
        _copy$default$1__T = typing.TypeVar('_copy$default$1__T')  # <T>
        def copy$default$1(self) -> int: ...
        _copy$default$2__T = typing.TypeVar('_copy$default$2__T')  # <T>
        def copy$default$2(self) -> int: ...
        _copy$default$3__T = typing.TypeVar('_copy$default$3__T')  # <T>
        def copy$default$3(self) -> 'LongMap'[typing.Any]: ...
        _copy$default$4__T = typing.TypeVar('_copy$default$4__T')  # <T>
        def copy$default$4(self) -> 'LongMap'[typing.Any]: ...
        def left(self) -> 'LongMap'[_LongMap__Bin__T]: ...
        def mask(self) -> int: ...
        def prefix(self) -> int: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def right(self) -> 'LongMap'[_LongMap__Bin__T]: ...
    class Bin$(scala.Serializable):
        MODULE$: typing.ClassVar['LongMap.Bin.'] = ...
        def __init__(self): ...
        _apply__T = typing.TypeVar('_apply__T')  # <T>
        def apply(self, prefix: int, mask: int, left: 'LongMap'[_apply__T], right: 'LongMap'[_apply__T]) -> 'LongMap.Bin'[_apply__T]: ...
        def toString(self) -> java.lang.String: ...
        _unapply__T = typing.TypeVar('_unapply__T')  # <T>
        def unapply(self, x$0: 'LongMap.Bin'[_unapply__T]) -> scala.Option[scala.Tuple4[typing.Any, typing.Any, 'LongMap'[_unapply__T], 'LongMap'[_unapply__T]]]: ...
    class Nil$(scala.collection.immutable.LongMap[scala.runtime.Nothing.], scala.Product, scala.Serializable):
        MODULE$: typing.ClassVar['LongMap.Nil.'] = ...
        def __init__(self): ...
        def equals(self, that: typing.Any) -> bool: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
    class Tip(scala.collection.immutable.LongMap[_LongMap__Tip__T], scala.Product, scala.Serializable, typing.Generic[_LongMap__Tip__T]):
        def __init__(self, key: int, value: _LongMap__Tip__T): ...
        _copy__T = typing.TypeVar('_copy__T')  # <T>
        def copy(self, key: int, value: typing.Any) -> 'LongMap.Tip'[typing.Any]: ...
        _copy$default$1__T = typing.TypeVar('_copy$default$1__T')  # <T>
        def copy$default$1(self) -> int: ...
        _copy$default$2__T = typing.TypeVar('_copy$default$2__T')  # <T>
        def copy$default$2(self) -> typing.Any: ...
        def key(self) -> int: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def value(self) -> _LongMap__Tip__T: ...
        _withValue__S = typing.TypeVar('_withValue__S')  # <S>
        def withValue(self, s: _withValue__S) -> 'LongMap.Tip'[_withValue__S]: ...
    class Tip$(scala.Serializable):
        MODULE$: typing.ClassVar['LongMap.Tip.'] = ...
        def __init__(self): ...
        _apply__T = typing.TypeVar('_apply__T')  # <T>
        def apply(self, key: int, value: _apply__T) -> 'LongMap.Tip'[_apply__T]: ...
        def toString(self) -> java.lang.String: ...
        _unapply__T = typing.TypeVar('_unapply__T')  # <T>
        def unapply(self, x$0: 'LongMap.Tip'[_unapply__T]) -> scala.Option[scala.Tuple2[typing.Any, _unapply__T]]: ...

_Map__Map1__K = typing.TypeVar('_Map__Map1__K')  # <K>
_Map__Map1__V = typing.TypeVar('_Map__Map1__V')  # <V>
_Map__Map2__K = typing.TypeVar('_Map__Map2__K')  # <K>
_Map__Map2__V = typing.TypeVar('_Map__Map2__V')  # <V>
_Map__Map3__K = typing.TypeVar('_Map__Map3__K')  # <K>
_Map__Map3__V = typing.TypeVar('_Map__Map3__V')  # <V>
_Map__Map4__K = typing.TypeVar('_Map__Map4__K')  # <K>
_Map__Map4__V = typing.TypeVar('_Map__Map4__V')  # <V>
_Map__WithDefault__K = typing.TypeVar('_Map__WithDefault__K')  # <K>
_Map__WithDefault__V = typing.TypeVar('_Map__WithDefault__V')  # <V>
_Map__K = typing.TypeVar('_Map__K')  # <K>
_Map__V = typing.TypeVar('_Map__V')  # <V>
class Map(Iterable[scala.Tuple2[_Map__K, _Map__V]], scala.collection.Map[_Map__K, _Map__V], scala.collection.immutable.MapLike[_Map__K, _Map__V, 'Map'[_Map__K, _Map__V]], typing.Generic[_Map__K, _Map__V]):
    @staticmethod
    def $init$($this: 'Map') -> None: ...
    _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
    _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
    _$plus_2__V1 = typing.TypeVar('_$plus_2__V1')  # <V1>
    _$plus_3__V1 = typing.TypeVar('_$plus_3__V1')  # <V1>
    _$plus_4__V1 = typing.TypeVar('_$plus_4__V1')  # <V1>
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_Map__K, _.plus_0__V1]) -> scala.collection.GenMap[_Map__K, _.plus_0__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_Map__K, _.plus_1__V1]) -> scala.collection.Map[_Map__K, _.plus_1__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_Map__K, _.plus_2__V1]) -> 'Map'[_Map__K, _.plus_2__V1]: ...
    @typing.overload
    def $plus(self, kv1: scala.Tuple2[_Map__K, _.plus_3__V1], kv2: scala.Tuple2[_Map__K, _.plus_3__V1], kvs: scala.collection.Seq[scala.Tuple2[_Map__K, _.plus_3__V1]]) -> scala.collection.Map[_Map__K, _.plus_3__V1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[_Map__K, _.plus_4__V1], elem2: scala.Tuple2[_Map__K, _.plus_4__V1], elems: scala.collection.Seq[scala.Tuple2[_Map__K, _.plus_4__V1]]) -> 'Map'[_Map__K, _.plus_4__V1]: ...
    _canBuildFrom__K = typing.TypeVar('_canBuildFrom__K')  # <K>
    _canBuildFrom__V = typing.TypeVar('_canBuildFrom__V')  # <V>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['Map'[typing.Any, typing.Any], scala.Tuple2[_canBuildFrom__K, _canBuildFrom__V], 'Map'[_canBuildFrom__K, _canBuildFrom__V]]: ...
    @typing.overload
    def empty(self) -> scala.collection.Map[_Map__K, _Map__V]: ...
    @typing.overload
    def empty(self) -> 'Map'[_Map__K, _Map__V]: ...
    def equals(self, that: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[typing.Any]: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[typing.Any]: ...
    @typing.overload
    def seq(self) -> scala.collection.Iterable[typing.Any]: ...
    @typing.overload
    def seq(self) -> scala.collection.Map[_Map__K, _Map__V]: ...
    @typing.overload
    def seq(self) -> scala.collection.Traversable[typing.Any]: ...
    @typing.overload
    def seq(self) -> Iterable[typing.Any]: ...
    @typing.overload
    def seq(self) -> 'Map'[_Map__K, _Map__V]: ...
    @typing.overload
    def seq(self) -> Traversable[typing.Any]: ...
    _toMap_0__K = typing.TypeVar('_toMap_0__K')  # <K>
    _toMap_0__V = typing.TypeVar('_toMap_0__V')  # <V>
    _toMap_1__T = typing.TypeVar('_toMap_1__T')  # <T>
    _toMap_1__U = typing.TypeVar('_toMap_1__U')  # <U>
    @typing.overload
    def toMap(self, ev: scala.Predef..less.colon.less[typing.Any, scala.Tuple2[typing.Any, typing.Any]]) -> scala.collection.GenMap[typing.Any, typing.Any]: ...
    @typing.overload
    def toMap(self, ev: scala.Predef..less.colon.less[scala.Tuple2[_Map__K, _Map__V], scala.Tuple2[_toMap_1__T, _toMap_1__U]]) -> 'Map'[_toMap_1__T, _toMap_1__U]: ...
    def toString(self) -> java.lang.String: ...
    _updated_0__V1 = typing.TypeVar('_updated_0__V1')  # <V1>
    _updated_1__V1 = typing.TypeVar('_updated_1__V1')  # <V1>
    _updated_2__V1 = typing.TypeVar('_updated_2__V1')  # <V1>
    @typing.overload
    def updated(self, key: _Map__K, value: _updated_0__V1) -> scala.collection.GenMap[_Map__K, _updated_0__V1]: ...
    @typing.overload
    def updated(self, key: _Map__K, value: _updated_1__V1) -> 'Map'[_Map__K, _updated_1__V1]: ...
    @typing.overload
    def updated(self, key: _Map__K, value: _updated_2__V1) -> scala.collection.Map[_Map__K, _updated_2__V1]: ...
    _withDefault__V1 = typing.TypeVar('_withDefault__V1')  # <V1>
    def withDefault(self, d: scala.Function1[_Map__K, _withDefault__V1]) -> 'Map'[_Map__K, _withDefault__V1]: ...
    _withDefaultValue__V1 = typing.TypeVar('_withDefaultValue__V1')  # <V1>
    def withDefaultValue(self, d: _withDefaultValue__V1) -> 'Map'[_Map__K, _withDefaultValue__V1]: ...
    class EmptyMap$(AbstractMap[typing.Any, scala.runtime.Nothing.], scala.Serializable):
        MODULE$: typing.ClassVar['Map.EmptyMap.'] = ...
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, key: typing.Any) -> 'Map'[typing.Any, scala.runtime.Nothing.]: ...
        _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
        _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
        @typing.overload
        def $plus(self, elem1: scala.Tuple2[typing.Any, _.plus_0__V1], elem2: scala.Tuple2[typing.Any, _.plus_0__V1], elems: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_0__V1]]) -> 'Map'[typing.Any, _.plus_0__V1]: ...
        @typing.overload
        def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_1__V1]) -> 'Map'[typing.Any, _.plus_1__V1]: ...
        def apply(self, key: typing.Any) -> scala.runtime.Nothing.: ...
        def contains(self, key: typing.Any) -> bool: ...
        def get(self, key: typing.Any) -> scala.Option[scala.runtime.Nothing.]: ...
        _getOrElse__V1 = typing.TypeVar('_getOrElse__V1')  # <V1>
        def getOrElse(self, key: typing.Any, default: scala.Function0[_getOrElse__V1]) -> _getOrElse__V1: ...
        def iterator(self) -> scala.collection.Iterator[scala.Tuple2[typing.Any, scala.runtime.Nothing.]]: ...
        def size(self) -> int: ...
        _updated__V1 = typing.TypeVar('_updated__V1')  # <V1>
        def updated(self, key: typing.Any, value: _updated__V1) -> 'Map'[typing.Any, _updated__V1]: ...
    class Map1(AbstractMap[_Map__Map1__K, _Map__Map1__V], scala.Serializable, typing.Generic[_Map__Map1__K, _Map__Map1__V]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, key1: _Map__Map1__K, value1: _Map__Map1__V): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, key: _Map__Map1__K) -> 'Map'[_Map__Map1__K, _Map__Map1__V]: ...
        _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
        _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
        @typing.overload
        def $plus(self, elem1: scala.Tuple2[_Map__Map1__K, _.plus_0__V1], elem2: scala.Tuple2[_Map__Map1__K, _.plus_0__V1], elems: scala.collection.Seq[scala.Tuple2[_Map__Map1__K, _.plus_0__V1]]) -> 'Map'[_Map__Map1__K, _.plus_0__V1]: ...
        @typing.overload
        def $plus(self, kv: scala.Tuple2[_Map__Map1__K, _.plus_1__V1]) -> 'Map'[_Map__Map1__K, _.plus_1__V1]: ...
        def apply(self, key: _Map__Map1__K) -> _Map__Map1__V: ...
        def contains(self, key: _Map__Map1__K) -> bool: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[scala.Tuple2[_Map__Map1__K, _Map__Map1__V], _foreach__U]) -> None: ...
        def get(self, key: _Map__Map1__K) -> scala.Option[_Map__Map1__V]: ...
        _getOrElse__V1 = typing.TypeVar('_getOrElse__V1')  # <V1>
        def getOrElse(self, key: _Map__Map1__K, default: scala.Function0[_getOrElse__V1]) -> _getOrElse__V1: ...
        def iterator(self) -> scala.collection.Iterator[scala.Tuple2[_Map__Map1__K, _Map__Map1__V]]: ...
        def size(self) -> int: ...
        _updated__V1 = typing.TypeVar('_updated__V1')  # <V1>
        def updated(self, key: _Map__Map1__K, value: _updated__V1) -> 'Map'[_Map__Map1__K, _updated__V1]: ...
    class Map2(AbstractMap[_Map__Map2__K, _Map__Map2__V], scala.Serializable, typing.Generic[_Map__Map2__K, _Map__Map2__V]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, key1: _Map__Map2__K, value1: _Map__Map2__V, key2: _Map__Map2__K, value2: _Map__Map2__V): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, key: _Map__Map2__K) -> 'Map'[_Map__Map2__K, _Map__Map2__V]: ...
        _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
        _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
        @typing.overload
        def $plus(self, elem1: scala.Tuple2[_Map__Map2__K, _.plus_0__V1], elem2: scala.Tuple2[_Map__Map2__K, _.plus_0__V1], elems: scala.collection.Seq[scala.Tuple2[_Map__Map2__K, _.plus_0__V1]]) -> 'Map'[_Map__Map2__K, _.plus_0__V1]: ...
        @typing.overload
        def $plus(self, kv: scala.Tuple2[_Map__Map2__K, _.plus_1__V1]) -> 'Map'[_Map__Map2__K, _.plus_1__V1]: ...
        def apply(self, key: _Map__Map2__K) -> _Map__Map2__V: ...
        def contains(self, key: _Map__Map2__K) -> bool: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[scala.Tuple2[_Map__Map2__K, _Map__Map2__V], _foreach__U]) -> None: ...
        def get(self, key: _Map__Map2__K) -> scala.Option[_Map__Map2__V]: ...
        _getOrElse__V1 = typing.TypeVar('_getOrElse__V1')  # <V1>
        def getOrElse(self, key: _Map__Map2__K, default: scala.Function0[_getOrElse__V1]) -> _getOrElse__V1: ...
        def iterator(self) -> scala.collection.Iterator[scala.Tuple2[_Map__Map2__K, _Map__Map2__V]]: ...
        def size(self) -> int: ...
        _updated__V1 = typing.TypeVar('_updated__V1')  # <V1>
        def updated(self, key: _Map__Map2__K, value: _updated__V1) -> 'Map'[_Map__Map2__K, _updated__V1]: ...
    class Map3(AbstractMap[_Map__Map3__K, _Map__Map3__V], scala.Serializable, typing.Generic[_Map__Map3__K, _Map__Map3__V]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, key1: _Map__Map3__K, value1: _Map__Map3__V, key2: _Map__Map3__K, value2: _Map__Map3__V, key3: _Map__Map3__K, value3: _Map__Map3__V): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, key: _Map__Map3__K) -> 'Map'[_Map__Map3__K, _Map__Map3__V]: ...
        _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
        _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
        @typing.overload
        def $plus(self, elem1: scala.Tuple2[_Map__Map3__K, _.plus_0__V1], elem2: scala.Tuple2[_Map__Map3__K, _.plus_0__V1], elems: scala.collection.Seq[scala.Tuple2[_Map__Map3__K, _.plus_0__V1]]) -> 'Map'[_Map__Map3__K, _.plus_0__V1]: ...
        @typing.overload
        def $plus(self, kv: scala.Tuple2[_Map__Map3__K, _.plus_1__V1]) -> 'Map'[_Map__Map3__K, _.plus_1__V1]: ...
        def apply(self, key: _Map__Map3__K) -> _Map__Map3__V: ...
        def contains(self, key: _Map__Map3__K) -> bool: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[scala.Tuple2[_Map__Map3__K, _Map__Map3__V], _foreach__U]) -> None: ...
        def get(self, key: _Map__Map3__K) -> scala.Option[_Map__Map3__V]: ...
        _getOrElse__V1 = typing.TypeVar('_getOrElse__V1')  # <V1>
        def getOrElse(self, key: _Map__Map3__K, default: scala.Function0[_getOrElse__V1]) -> _getOrElse__V1: ...
        def iterator(self) -> scala.collection.Iterator[scala.Tuple2[_Map__Map3__K, _Map__Map3__V]]: ...
        def size(self) -> int: ...
        _updated__V1 = typing.TypeVar('_updated__V1')  # <V1>
        def updated(self, key: _Map__Map3__K, value: _updated__V1) -> 'Map'[_Map__Map3__K, _updated__V1]: ...
    class Map4(AbstractMap[_Map__Map4__K, _Map__Map4__V], scala.Serializable, typing.Generic[_Map__Map4__K, _Map__Map4__V]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, key1: _Map__Map4__K, value1: _Map__Map4__V, key2: _Map__Map4__K, value2: _Map__Map4__V, key3: _Map__Map4__K, value3: _Map__Map4__V, key4: _Map__Map4__K, value4: _Map__Map4__V): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, key: _Map__Map4__K) -> 'Map'[_Map__Map4__K, _Map__Map4__V]: ...
        _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
        _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
        @typing.overload
        def $plus(self, elem1: scala.Tuple2[_Map__Map4__K, _.plus_0__V1], elem2: scala.Tuple2[_Map__Map4__K, _.plus_0__V1], elems: scala.collection.Seq[scala.Tuple2[_Map__Map4__K, _.plus_0__V1]]) -> 'Map'[_Map__Map4__K, _.plus_0__V1]: ...
        @typing.overload
        def $plus(self, kv: scala.Tuple2[_Map__Map4__K, _.plus_1__V1]) -> 'Map'[_Map__Map4__K, _.plus_1__V1]: ...
        def apply(self, key: _Map__Map4__K) -> _Map__Map4__V: ...
        def contains(self, key: _Map__Map4__K) -> bool: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[scala.Tuple2[_Map__Map4__K, _Map__Map4__V], _foreach__U]) -> None: ...
        def get(self, key: _Map__Map4__K) -> scala.Option[_Map__Map4__V]: ...
        _getOrElse__V1 = typing.TypeVar('_getOrElse__V1')  # <V1>
        def getOrElse(self, key: _Map__Map4__K, default: scala.Function0[_getOrElse__V1]) -> _getOrElse__V1: ...
        def iterator(self) -> scala.collection.Iterator[scala.Tuple2[_Map__Map4__K, _Map__Map4__V]]: ...
        def size(self) -> int: ...
        _updated__V1 = typing.TypeVar('_updated__V1')  # <V1>
        def updated(self, key: _Map__Map4__K, value: _updated__V1) -> 'Map'[_Map__Map4__K, _updated__V1]: ...
    class WithDefault(scala.collection.Map.WithDefault[_Map__WithDefault__K, _Map__WithDefault__V], scala.collection.immutable.Map[_Map__WithDefault__K, _Map__WithDefault__V], typing.Generic[_Map__WithDefault__K, _Map__WithDefault__V]):
        def __init__(self, underlying: 'Map'[_Map__WithDefault__K, _Map__WithDefault__V], d: scala.Function1[_Map__WithDefault__K, _Map__WithDefault__V]): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, key: _Map__WithDefault__K) -> 'Map.WithDefault'[_Map__WithDefault__K, _Map__WithDefault__V]: ...
        _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
        _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
        @typing.overload
        def $plus(self, elem1: scala.Tuple2[_Map__WithDefault__K, _.plus_0__V1], elem2: scala.Tuple2[_Map__WithDefault__K, _.plus_0__V1], elems: scala.collection.Seq[scala.Tuple2[_Map__WithDefault__K, _.plus_0__V1]]) -> 'Map'[_Map__WithDefault__K, _.plus_0__V1]: ...
        @typing.overload
        def $plus(self, kv: scala.Tuple2[_Map__WithDefault__K, _.plus_1__V1]) -> 'Map.WithDefault'[_Map__WithDefault__K, _.plus_1__V1]: ...
        _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
        _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
        _$plus$plus_1__V1 = typing.TypeVar('_$plus$plus_1__V1')  # <V1>
        @typing.overload
        def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus_0__B], bf: scala.collection.generic.CanBuildFrom[scala.collection.Traversable[typing.Any], _.plus.plus_0__B, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
        @typing.overload
        def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[_Map__WithDefault__K, _.plus.plus_1__V1]]) -> 'Map'[_Map__WithDefault__K, _.plus.plus_1__V1]: ...
        def companion(self) -> scala.collection.generic.GenericCompanion[Iterable]: ...
        def empty(self) -> 'Map.WithDefault'[_Map__WithDefault__K, _Map__WithDefault__V]: ...
        def filterKeys(self, p: scala.Function1[_Map__WithDefault__K, typing.Any]) -> 'Map'[_Map__WithDefault__K, _Map__WithDefault__V]: ...
        def filterNot(self, p: scala.Function1[scala.Tuple2[_Map__WithDefault__K, _Map__WithDefault__V], typing.Any]) -> scala.collection.Map[_Map__WithDefault__K, _Map__WithDefault__V]: ...
        _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
        def groupBy(self, f: scala.Function1[typing.Any, typing.Any]) -> 'Map'[typing.Any, scala.collection.Traversable[typing.Any]]: ...
        def keySet(self) -> 'Set'[_Map__WithDefault__K]: ...
        def keys(self) -> scala.collection.Iterable[_Map__WithDefault__K]: ...
        _mapValues__W = typing.TypeVar('_mapValues__W')  # <W>
        def mapValues(self, f: scala.Function1[_Map__WithDefault__V, _mapValues__W]) -> 'Map'[_Map__WithDefault__K, _mapValues__W]: ...
        def parCombiner(self) -> scala.collection.parallel.Combiner[scala.Tuple2[_Map__WithDefault__K, _Map__WithDefault__V], scala.collection.parallel.immutable.ParMap[_Map__WithDefault__K, _Map__WithDefault__V]]: ...
        def repr(self) -> typing.Any: ...
        def seq(self) -> 'Map'[_Map__WithDefault__K, _Map__WithDefault__V]: ...
        def thisCollection(self) -> scala.collection.Iterable[typing.Any]: ...
        def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
        def toIterable(self) -> scala.collection.Iterable[typing.Any]: ...
        _toMap__T = typing.TypeVar('_toMap__T')  # <T>
        _toMap__U = typing.TypeVar('_toMap__U')  # <U>
        def toMap(self, ev: scala.Predef..less.colon.less[scala.Tuple2[_Map__WithDefault__K, _Map__WithDefault__V], scala.Tuple2[_toMap__T, _toMap__U]]) -> 'Map'[_toMap__T, _toMap__U]: ...
        def toSeq(self) -> scala.collection.Seq[scala.Tuple2[_Map__WithDefault__K, _Map__WithDefault__V]]: ...
        def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
        _transform__W = typing.TypeVar('_transform__W')  # <W>
        _transform__That = typing.TypeVar('_transform__That')  # <That>
        def transform(self, f: scala.Function2[_Map__WithDefault__K, _Map__WithDefault__V, _transform__W], bf: scala.collection.generic.CanBuildFrom['Map'[_Map__WithDefault__K, _Map__WithDefault__V], scala.Tuple2[_Map__WithDefault__K, _transform__W], _transform__That]) -> _transform__That: ...
        _updated__V1 = typing.TypeVar('_updated__V1')  # <V1>
        def updated(self, key: _Map__WithDefault__K, value: _updated__V1) -> 'Map.WithDefault'[_Map__WithDefault__K, _updated__V1]: ...
        def values(self) -> scala.collection.Iterable[_Map__WithDefault__V]: ...
        @typing.overload
        def view(self) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
        @typing.overload
        def view(self, from_: int, until: int) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
        _withDefault__V1 = typing.TypeVar('_withDefault__V1')  # <V1>
        def withDefault(self, d: scala.Function1[_Map__WithDefault__K, _withDefault__V1]) -> 'Map'[_Map__WithDefault__K, _withDefault__V1]: ...
        _withDefaultValue__V1 = typing.TypeVar('_withDefaultValue__V1')  # <V1>
        def withDefaultValue(self, d: _withDefaultValue__V1) -> 'Map'[_Map__WithDefault__K, _withDefaultValue__V1]: ...

_MapLike__K = typing.TypeVar('_MapLike__K')  # <K>
_MapLike__V = typing.TypeVar('_MapLike__V')  # <V>
_MapLike__This = typing.TypeVar('_MapLike__This', bound='MapLike')  # <This>
class MapLike(scala.collection.MapLike[_MapLike__K, _MapLike__V, _MapLike__This], typing.Generic[_MapLike__K, _MapLike__V, _MapLike__This]):
    @staticmethod
    def $init$($this: 'MapLike') -> None: ...
    _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
    _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
    _$plus_2__V1 = typing.TypeVar('_$plus_2__V1')  # <V1>
    _$plus_3__V1 = typing.TypeVar('_$plus_3__V1')  # <V1>
    _$plus_4__V1 = typing.TypeVar('_$plus_4__V1')  # <V1>
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_MapLike__K, _.plus_0__V1]) -> scala.collection.GenMap[_MapLike__K, _.plus_0__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_MapLike__K, _.plus_1__V1]) -> scala.collection.Map[_MapLike__K, _.plus_1__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_MapLike__K, _.plus_2__V1]) -> Map[_MapLike__K, _.plus_2__V1]: ...
    @typing.overload
    def $plus(self, kv1: scala.Tuple2[_MapLike__K, _.plus_3__V1], kv2: scala.Tuple2[_MapLike__K, _.plus_3__V1], kvs: scala.collection.Seq[scala.Tuple2[_MapLike__K, _.plus_3__V1]]) -> scala.collection.Map[_MapLike__K, _.plus_3__V1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[_MapLike__K, _.plus_4__V1], elem2: scala.Tuple2[_MapLike__K, _.plus_4__V1], elems: scala.collection.Seq[scala.Tuple2[_MapLike__K, _.plus_4__V1]]) -> Map[_MapLike__K, _.plus_4__V1]: ...
    _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
    _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
    _$plus$plus_1__V1 = typing.TypeVar('_$plus$plus_1__V1')  # <V1>
    _$plus$plus_2__V1 = typing.TypeVar('_$plus$plus_2__V1')  # <V1>
    @typing.overload
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus_0__B], bf: scala.collection.generic.CanBuildFrom[typing.Any, _.plus.plus_0__B, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[_MapLike__K, _.plus.plus_1__V1]]) -> scala.collection.Map[_MapLike__K, _.plus.plus_1__V1]: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[_MapLike__K, _.plus.plus_2__V1]]) -> Map[_MapLike__K, _.plus.plus_2__V1]: ...
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    def filterKeys(self, p: scala.Function1[_MapLike__K, typing.Any]) -> scala.collection.GenMap[_MapLike__K, _MapLike__V]: ...
    @typing.overload
    def filterKeys(self, p: scala.Function1[_MapLike__K, typing.Any]) -> scala.collection.Map[_MapLike__K, _MapLike__V]: ...
    @typing.overload
    def filterKeys(self, p: scala.Function1[_MapLike__K, typing.Any]) -> Map[_MapLike__K, _MapLike__V]: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def keySet(self) -> scala.collection.GenSet[_MapLike__K]: ...
    @typing.overload
    def keySet(self) -> scala.collection.Set[_MapLike__K]: ...
    @typing.overload
    def keySet(self) -> 'Set'[_MapLike__K]: ...
    _mapValues_0__W = typing.TypeVar('_mapValues_0__W')  # <W>
    _mapValues_1__W = typing.TypeVar('_mapValues_1__W')  # <W>
    _mapValues_2__W = typing.TypeVar('_mapValues_2__W')  # <W>
    @typing.overload
    def mapValues(self, f: scala.Function1[_MapLike__V, _mapValues_0__W]) -> scala.collection.GenMap[_MapLike__K, _mapValues_0__W]: ...
    @typing.overload
    def mapValues(self, f: scala.Function1[_MapLike__V, _mapValues_1__W]) -> scala.collection.Map[_MapLike__K, _mapValues_1__W]: ...
    @typing.overload
    def mapValues(self, f: scala.Function1[_MapLike__V, _mapValues_2__W]) -> Map[_MapLike__K, _mapValues_2__W]: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[scala.Tuple2[_MapLike__K, _MapLike__V], scala.collection.parallel.immutable.ParMap[_MapLike__K, _MapLike__V]]: ...
    def toString(self) -> java.lang.String: ...
    _transform__W = typing.TypeVar('_transform__W')  # <W>
    _transform__That = typing.TypeVar('_transform__That')  # <That>
    def transform(self, f: scala.Function2[_MapLike__K, _MapLike__V, _transform__W], bf: scala.collection.generic.CanBuildFrom[_MapLike__This, scala.Tuple2[_MapLike__K, _transform__W], _transform__That]) -> _transform__That: ...
    _updated_0__V1 = typing.TypeVar('_updated_0__V1')  # <V1>
    _updated_1__V1 = typing.TypeVar('_updated_1__V1')  # <V1>
    @typing.overload
    def updated(self, key: _MapLike__K, value: _updated_0__V1) -> scala.collection.Map[_MapLike__K, _updated_0__V1]: ...
    @typing.overload
    def updated(self, key: _MapLike__K, value: _updated_1__V1) -> Map[_MapLike__K, _updated_1__V1]: ...
    class ImmutableDefaultKeySet(scala.collection.MapLike.DefaultKeySet, scala.collection.immutable.Set[_MapLike__K]):
        def __init__(self, $outer: 'MapLike'): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, elem: _MapLike__K) -> 'Set'[_MapLike__K]: ...
        @typing.overload
        def $plus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq[typing.Any]) -> scala.collection.Set[typing.Any]: ...
        @typing.overload
        def $plus(self, elem: _MapLike__K) -> 'Set'[_MapLike__K]: ...
        def apply(self, elem: typing.Any) -> bool: ...
        def companion(self) -> scala.collection.generic.GenericCompanion['Set']: ...
        def diff(self, that: scala.collection.GenSet[typing.Any]) -> scala.collection.Set[typing.Any]: ...
        def empty(self) -> scala.collection.GenSet: ...
        _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
        def groupBy(self, f: scala.Function1[typing.Any, typing.Any]) -> Map[typing.Any, scala.collection.Traversable[typing.Any]]: ...
        def parCombiner(self) -> scala.collection.parallel.Combiner[_MapLike__K, scala.collection.parallel.immutable.ParSet[_MapLike__K]]: ...
        def repr(self) -> typing.Any: ...
        def seq(self) -> 'Set'[_MapLike__K]: ...
        def thisCollection(self) -> scala.collection.Iterable[typing.Any]: ...
        def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
        def toIterable(self) -> scala.collection.Iterable[typing.Any]: ...
        def toSeq(self) -> scala.collection.Seq[typing.Any]: ...
        _toSet__B = typing.TypeVar('_toSet__B')  # <B>
        def toSet(self) -> 'Set'[_toSet__B]: ...
        def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
        def union(self, that: scala.collection.GenSet[typing.Any]) -> scala.collection.Set[typing.Any]: ...
        @typing.overload
        def view(self) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
        @typing.overload
        def view(self, from_: int, until: int) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...

_MapProxy__A = typing.TypeVar('_MapProxy__A')  # <A>
_MapProxy__B = typing.TypeVar('_MapProxy__B')  # <B>
class MapProxy(Map[_MapProxy__A, _MapProxy__B], scala.collection.MapProxyLike[_MapProxy__A, _MapProxy__B, Map[_MapProxy__A, _MapProxy__B]], typing.Generic[_MapProxy__A, _MapProxy__B]):
    @staticmethod
    def $init$($this: 'MapProxy') -> None: ...
    @typing.overload
    def $minus(self, key: typing.Any) -> typing.Any: ...
    @typing.overload
    def $minus(self, elem: _MapProxy__A) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, key: _MapProxy__A) -> scala.collection.MapLike: ...
    @typing.overload
    def $minus(self, elem1: _MapProxy__A, elem2: _MapProxy__A, elems: scala.collection.Seq[_MapProxy__A]) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, key: _MapProxy__A) -> 'MapProxy'[_MapProxy__A, _MapProxy__B]: ...
    _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
    _$plus_1__B1 = typing.TypeVar('_$plus_1__B1')  # <B1>
    _$plus_2__B1 = typing.TypeVar('_$plus_2__B1')  # <B1>
    _$plus_3__V1 = typing.TypeVar('_$plus_3__V1')  # <V1>
    _$plus_4__B1 = typing.TypeVar('_$plus_4__B1')  # <B1>
    _$plus_5__B1 = typing.TypeVar('_$plus_5__B1')  # <B1>
    @typing.overload
    def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_0__V1]) -> scala.collection.GenMap[typing.Any, _.plus_0__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_MapProxy__A, _.plus_1__B1]) -> scala.collection.Map[_MapProxy__A, _.plus_1__B1]: ...
    @typing.overload
    def $plus(self, kv1: scala.Tuple2[_MapProxy__A, _.plus_2__B1], kv2: scala.Tuple2[_MapProxy__A, _.plus_2__B1], kvs: scala.collection.Seq[scala.Tuple2[_MapProxy__A, _.plus_2__B1]]) -> scala.collection.Map[_MapProxy__A, _.plus_2__B1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[typing.Any, _.plus_3__V1], elem2: scala.Tuple2[typing.Any, _.plus_3__V1], elems: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_3__V1]]) -> Map[typing.Any, _.plus_3__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_MapProxy__A, _.plus_4__B1]) -> Map[_MapProxy__A, _.plus_4__B1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[_MapProxy__A, _.plus_5__B1], elem2: scala.Tuple2[_MapProxy__A, _.plus_5__B1], elems: scala.collection.Seq[scala.Tuple2[_MapProxy__A, _.plus_5__B1]]) -> 'MapProxy'[_MapProxy__A, _.plus_5__B1]: ...
    _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
    _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
    _$plus$plus_1__B1 = typing.TypeVar('_$plus$plus_1__B1')  # <B1>
    _$plus$plus_2__V1 = typing.TypeVar('_$plus$plus_2__V1')  # <V1>
    _$plus$plus_3__B1 = typing.TypeVar('_$plus$plus_3__B1')  # <B1>
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[typing.Any], bf: scala.collection.generic.CanBuildFrom[scala.collection.TraversableLike, typing.Any, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[_MapProxy__A, _.plus.plus_1__B1]]) -> scala.collection.Map[_MapProxy__A, _.plus.plus_1__B1]: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[typing.Any, _.plus.plus_2__V1]]) -> Map[typing.Any, _.plus.plus_2__V1]: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[_MapProxy__A, _.plus.plus_3__B1]]) -> 'MapProxy'[_MapProxy__A, _.plus.plus_3__B1]: ...
    @typing.overload
    def empty(self) -> scala.collection.Map[typing.Any, typing.Any]: ...
    @typing.overload
    def empty(self) -> Map[typing.Any, typing.Any]: ...
    @typing.overload
    def empty(self) -> 'MapProxy'[_MapProxy__A, _MapProxy__B]: ...
    @typing.overload
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    def filterKeys(self, p: scala.Function1[typing.Any, typing.Any]) -> scala.collection.GenMap[typing.Any, typing.Any]: ...
    @typing.overload
    def filterKeys(self, p: scala.Function1[_MapProxy__A, typing.Any]) -> scala.collection.Map[_MapProxy__A, _MapProxy__B]: ...
    @typing.overload
    def filterKeys(self, p: scala.Function1[_MapProxy__A, typing.Any]) -> Map[_MapProxy__A, _MapProxy__B]: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    def keySet(self) -> scala.collection.GenSet[typing.Any]: ...
    @typing.overload
    def keySet(self) -> scala.collection.Set[_MapProxy__A]: ...
    @typing.overload
    def keySet(self) -> 'Set'[_MapProxy__A]: ...
    _mapValues_0__W = typing.TypeVar('_mapValues_0__W')  # <W>
    _mapValues_1__C = typing.TypeVar('_mapValues_1__C')  # <C>
    _mapValues_2__C = typing.TypeVar('_mapValues_2__C')  # <C>
    @typing.overload
    def mapValues(self, f: scala.Function1[typing.Any, _mapValues_0__W]) -> scala.collection.GenMap[typing.Any, _mapValues_0__W]: ...
    @typing.overload
    def mapValues(self, f: scala.Function1[_MapProxy__B, _mapValues_1__C]) -> scala.collection.Map[_MapProxy__A, _mapValues_1__C]: ...
    @typing.overload
    def mapValues(self, f: scala.Function1[_MapProxy__B, _mapValues_2__C]) -> Map[_MapProxy__A, _mapValues_2__C]: ...
    @typing.overload
    def repr(self) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def repr(self) -> typing.Any: ...
    @typing.overload
    def repr(self) -> 'MapProxy'[_MapProxy__A, _MapProxy__B]: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    _updated_0__V1 = typing.TypeVar('_updated_0__V1')  # <V1>
    _updated_1__V1 = typing.TypeVar('_updated_1__V1')  # <V1>
    _updated_2__B1 = typing.TypeVar('_updated_2__B1')  # <B1>
    _updated_3__B1 = typing.TypeVar('_updated_3__B1')  # <B1>
    @typing.overload
    def updated(self, key: typing.Any, value: _updated_0__V1) -> scala.collection.GenMap[typing.Any, _updated_0__V1]: ...
    @typing.overload
    def updated(self, key: typing.Any, value: _updated_1__V1) -> Map[typing.Any, _updated_1__V1]: ...
    @typing.overload
    def updated(self, key: _MapProxy__A, value: _updated_2__B1) -> scala.collection.Map[_MapProxy__A, _updated_2__B1]: ...
    @typing.overload
    def updated(self, key: _MapProxy__A, value: _updated_3__B1) -> 'MapProxy'[_MapProxy__A, _updated_3__B1]: ...

_NumericRange__Exclusive__T = typing.TypeVar('_NumericRange__Exclusive__T')  # <T>
_NumericRange__Inclusive__T = typing.TypeVar('_NumericRange__Inclusive__T')  # <T>
_NumericRange__T = typing.TypeVar('_NumericRange__T')  # <T>
class NumericRange(scala.collection.AbstractSeq[_NumericRange__T], IndexedSeq[_NumericRange__T], scala.Serializable, typing.Generic[_NumericRange__T]):
    def __init__(self, start: _NumericRange__T, end: _NumericRange__T, step: _NumericRange__T, isInclusive: bool, num: scala.math.Integral[_NumericRange__T]): ...
    def apply(self, idx: int) -> _NumericRange__T: ...
    def by(self, newStep: _NumericRange__T) -> 'NumericRange'[_NumericRange__T]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion[IndexedSeq]: ...
    _contains__A1 = typing.TypeVar('_contains__A1')  # <A1>
    def contains(self, x: _contains__A1) -> bool: ...
    def containsTyped(self, x: _NumericRange__T) -> bool: ...
    def copy(self, start: _NumericRange__T, end: _NumericRange__T, step: _NumericRange__T) -> 'NumericRange'[_NumericRange__T]: ...
    def drop(self, n: int) -> 'NumericRange'[_NumericRange__T]: ...
    def end(self) -> _NumericRange__T: ...
    def equals(self, other: typing.Any) -> bool: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[_NumericRange__T, _foreach__U]) -> None: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[typing.Any, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[typing.Any]]: ...
    def hashCode(self) -> int: ...
    _inclusive__T = typing.TypeVar('_inclusive__T')  # <T>
    @staticmethod
    def inclusive(start: _inclusive__T, end: _inclusive__T, step: _inclusive__T, num: scala.math.Integral[_inclusive__T]) -> 'NumericRange.Inclusive'[_inclusive__T]: ...
    def isDefinedAt(self, idx: int) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isInclusive(self) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[_NumericRange__T]: ...
    def last(self) -> _NumericRange__T: ...
    def length(self) -> int: ...
    _mapRange__A = typing.TypeVar('_mapRange__A')  # <A>
    def mapRange(self, fm: scala.Function1[_NumericRange__T, _mapRange__A], unum: scala.math.Integral[_mapRange__A]) -> 'NumericRange'[_mapRange__A]: ...
    _max__T1 = typing.TypeVar('_max__T1')  # <T1>
    def max(self, ord: scala.math.Ordering[_max__T1]) -> _NumericRange__T: ...
    _min__T1 = typing.TypeVar('_min__T1')  # <T1>
    def min(self, ord: scala.math.Ordering[_min__T1]) -> _NumericRange__T: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_NumericRange__T, scala.collection.parallel.immutable.ParSeq[_NumericRange__T]]: ...
    def seq(self) -> IndexedSeq[_NumericRange__T]: ...
    def sizeHintIfCheap(self) -> int: ...
    def start(self) -> _NumericRange__T: ...
    def step(self) -> _NumericRange__T: ...
    _sum__B = typing.TypeVar('_sum__B')  # <B>
    def sum(self, num: scala.math.Numeric[_sum__B]) -> _sum__B: ...
    def take(self, n: int) -> 'NumericRange'[_NumericRange__T]: ...
    def thisCollection(self) -> scala.collection.IndexedSeq[_NumericRange__T]: ...
    _toBuffer__A1 = typing.TypeVar('_toBuffer__A1')  # <A1>
    def toBuffer(self) -> scala.collection.mutable.Buffer[_toBuffer__A1]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.IndexedSeq: ...
    def toIndexedSeq(self) -> IndexedSeq[_NumericRange__T]: ...
    def toIterable(self) -> scala.collection.Iterable[typing.Any]: ...
    def toSeq(self) -> Seq[_NumericRange__T]: ...
    def toString(self) -> java.lang.String: ...
    def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
    @typing.overload
    def view(self) -> scala.collection.SeqView[typing.Any, scala.collection.Seq[typing.Any]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.SeqView[typing.Any, scala.collection.Seq[typing.Any]]: ...
    class Exclusive(scala.collection.immutable.NumericRange[_NumericRange__Exclusive__T], typing.Generic[_NumericRange__Exclusive__T]):
        def __init__(self, start: _NumericRange__Exclusive__T, end: _NumericRange__Exclusive__T, step: _NumericRange__Exclusive__T, num: scala.math.Integral[_NumericRange__Exclusive__T]): ...
        def copy(self, start: _NumericRange__Exclusive__T, end: _NumericRange__Exclusive__T, step: _NumericRange__Exclusive__T) -> 'NumericRange.Exclusive'[_NumericRange__Exclusive__T]: ...
        _inclusive_1__T = typing.TypeVar('_inclusive_1__T')  # <T>
        @typing.overload
        def inclusive(self) -> 'NumericRange.Inclusive'[_NumericRange__Exclusive__T]: ...
        @typing.overload
        @staticmethod
        def inclusive(start: _inclusive_1__T, end: _inclusive_1__T, step: _inclusive_1__T, num: scala.math.Integral[_inclusive_1__T]) -> 'NumericRange.Inclusive'[_inclusive_1__T]: ...
    class Inclusive(scala.collection.immutable.NumericRange[_NumericRange__Inclusive__T], typing.Generic[_NumericRange__Inclusive__T]):
        def __init__(self, start: _NumericRange__Inclusive__T, end: _NumericRange__Inclusive__T, step: _NumericRange__Inclusive__T, num: scala.math.Integral[_NumericRange__Inclusive__T]): ...
        def copy(self, start: _NumericRange__Inclusive__T, end: _NumericRange__Inclusive__T, step: _NumericRange__Inclusive__T) -> 'NumericRange.Inclusive'[_NumericRange__Inclusive__T]: ...
        def exclusive(self) -> 'NumericRange.Exclusive'[_NumericRange__Inclusive__T]: ...

_Queue__A = typing.TypeVar('_Queue__A')  # <A>
class Queue(scala.collection.AbstractSeq[_Queue__A], LinearSeq[_Queue__A], scala.Serializable, typing.Generic[_Queue__A]):
    serialVersionUID: typing.ClassVar[int] = ...
    def __init__(self, in_: List[_Queue__A], out: List[_Queue__A]): ...
    _$colon$plus__B = typing.TypeVar('_$colon$plus__B')  # <B>
    _$colon$plus__That = typing.TypeVar('_$colon$plus__That')  # <That>
    def $colon$plus(self, elem: _.colon.plus__B, bf: scala.collection.generic.CanBuildFrom['Queue'[_Queue__A], _.colon.plus__B, _.colon.plus__That]) -> _.colon.plus__That: ...
    _$plus$colon__B = typing.TypeVar('_$plus$colon__B')  # <B>
    _$plus$colon__That = typing.TypeVar('_$plus$colon__That')  # <That>
    def $plus$colon(self, elem: _.plus.colon__B, bf: scala.collection.generic.CanBuildFrom['Queue'[_Queue__A], _.plus.colon__B, _.plus.colon__That]) -> _.plus.colon__That: ...
    _$plus$plus__B = typing.TypeVar('_$plus$plus__B')  # <B>
    _$plus$plus__That = typing.TypeVar('_$plus$plus__That')  # <That>
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus__B], bf: scala.collection.generic.CanBuildFrom['Queue'[_Queue__A], _.plus.plus__B, _.plus.plus__That]) -> _.plus.plus__That: ...
    @staticmethod
    def ReusableCBF() -> scala.collection.generic.GenTraversableFactory.GenericCanBuildFrom[scala.runtime.Nothing.]: ...
    def apply(self, n: int) -> _Queue__A: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['Queue'[typing.Any], _canBuildFrom__A, 'Queue'[_canBuildFrom__A]]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['Queue']: ...
    @staticmethod
    def concat(xss: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    _corresponds__B = typing.TypeVar('_corresponds__B')  # <B>
    def corresponds(self, that: scala.collection.GenSeq[_corresponds__B], p: scala.Function2[_Queue__A, _corresponds__B, typing.Any]) -> bool: ...
    def dequeue(self) -> scala.Tuple2[_Queue__A, 'Queue'[_Queue__A]]: ...
    def dequeueOption(self) -> scala.Option[scala.Tuple2[_Queue__A, 'Queue'[_Queue__A]]]: ...
    _empty__A = typing.TypeVar('_empty__A')  # <A>
    @staticmethod
    def empty() -> 'Queue'[_empty__A]: ...
    _enqueue_0__B = typing.TypeVar('_enqueue_0__B')  # <B>
    _enqueue_1__B = typing.TypeVar('_enqueue_1__B')  # <B>
    @typing.overload
    def enqueue(self, elem: _enqueue_0__B) -> 'Queue'[_enqueue_0__B]: ...
    @typing.overload
    def enqueue(self, iter: Iterable[_enqueue_1__B]) -> 'Queue'[_enqueue_1__B]: ...
    def exists(self, p: scala.Function1[_Queue__A, typing.Any]) -> bool: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, n5: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    def forall(self, p: scala.Function1[_Queue__A, typing.Any]) -> bool: ...
    def front(self) -> _Queue__A: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[_Queue__A, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[_Queue__A]]: ...
    def hashCode(self) -> int: ...
    def head(self) -> _Queue__A: ...
    def isDefinedAt(self, idx: int) -> bool: ...
    def isEmpty(self) -> bool: ...
    @staticmethod
    def iterate(start: typing.Any, len: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def iterator(self) -> scala.collection.Iterator[_Queue__A]: ...
    def length(self) -> int: ...
    def out(self) -> List[_Queue__A]: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_Queue__A, scala.collection.parallel.immutable.ParSeq[_Queue__A]]: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, step: typing.Any, evidence$2: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, evidence$1: scala.math.Integral) -> scala.collection.GenTraversable: ...
    def seq(self) -> LinearSeq[_Queue__A]: ...
    def stringPrefix(self) -> java.lang.String: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, n5: int, f: scala.Function5) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, f: scala.Function4) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, f: scala.Function3) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, f: scala.Function2) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def tail(self) -> 'Queue'[_Queue__A]: ...
    def thisCollection(self) -> scala.collection.LinearSeq[_Queue__A]: ...
    def toCollection(self, repr: scala.collection.LinearSeqLike) -> scala.collection.LinearSeq: ...
    def toIterable(self) -> scala.collection.Iterable[_Queue__A]: ...
    def toSeq(self) -> Seq[_Queue__A]: ...
    def toString(self) -> java.lang.String: ...
    def toTraversable(self) -> scala.collection.Traversable[_Queue__A]: ...
    @staticmethod
    def unapplySeq(x: scala.collection.Seq) -> scala.Some: ...
    @typing.overload
    def view(self) -> scala.collection.SeqView[_Queue__A, scala.collection.Seq[_Queue__A]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.SeqView[_Queue__A, scala.collection.Seq[_Queue__A]]: ...
    class EmptyQueue$(scala.collection.immutable.Queue[scala.runtime.Nothing.]):
        MODULE$: typing.ClassVar['Queue.EmptyQueue.'] = ...
        def __init__(self): ...

_Range__Partial__T = typing.TypeVar('_Range__Partial__T')  # <T>
_Range__Partial__U = typing.TypeVar('_Range__Partial__U')  # <U>
class Range(scala.collection.AbstractSeq[typing.Any], IndexedSeq[typing.Any], scala.collection.CustomParallelizable[typing.Any, scala.collection.parallel.immutable.ParRange], scala.Serializable):
    serialVersionUID: typing.ClassVar[int] = ...
    def __init__(self, start: int, end: int, step: int): ...
    def apply(self, idx: int) -> int: ...
    def apply$mcII$sp(self, idx: int) -> int: ...
    def by(self, step: int) -> 'Range': ...
    def companion(self) -> scala.collection.generic.GenericCompanion[IndexedSeq]: ...
    _contains_0__A1 = typing.TypeVar('_contains_0__A1')  # <A1>
    @typing.overload
    def contains(self, elem: _contains_0__A1) -> bool: ...
    @typing.overload
    def contains(self, x: int) -> bool: ...
    def copy(self, start: int, end: int, step: int) -> 'Range': ...
    def drop(self, n: int) -> 'Range': ...
    def dropRight(self, n: int) -> 'Range': ...
    def dropWhile(self, p: scala.Function1[typing.Any, typing.Any]) -> 'Range': ...
    def end(self) -> int: ...
    def equals(self, other: typing.Any) -> bool: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[typing.Any, _foreach__U]) -> None: ...
    def foreach$mVc$sp(self, f: scala.Function1[typing.Any, scala.runtime.BoxedUnit]) -> None: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[typing.Any, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[typing.Any]]: ...
    def hashCode(self) -> int: ...
    def head(self) -> int: ...
    def inclusive(self) -> 'Range': ...
    def init(self) -> 'Range': ...
    def isDefinedAt(self, idx: int) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isInclusive(self) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def last(self) -> int: ...
    def length(self) -> int: ...
    _max__A1 = typing.TypeVar('_max__A1')  # <A1>
    def max(self, ord: scala.math.Ordering[_max__A1]) -> int: ...
    _min__A1 = typing.TypeVar('_min__A1')  # <A1>
    def min(self, ord: scala.math.Ordering[_min__A1]) -> int: ...
    def par(self) -> scala.collection.parallel.immutable.ParRange: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[typing.Any, scala.collection.parallel.immutable.ParRange]: ...
    def reverse(self) -> 'Range': ...
    def scala$collection$immutable$Range$$lastElement(self) -> int: ...
    def scala$collection$immutable$Range$$numRangeElements(self) -> int: ...
    def scala$collection$immutable$Range$$validateMaxLength(self) -> None: ...
    def seq(self) -> IndexedSeq[typing.Any]: ...
    def size(self) -> int: ...
    def sizeHintIfCheap(self) -> int: ...
    def slice(self, from_: int, until: int) -> 'Range': ...
    def span(self, p: scala.Function1[typing.Any, typing.Any]) -> scala.Tuple2['Range', 'Range']: ...
    def splitAt(self, n: int) -> scala.Tuple2['Range', 'Range']: ...
    def start(self) -> int: ...
    def step(self) -> int: ...
    _sum__B = typing.TypeVar('_sum__B')  # <B>
    def sum(self, num: scala.math.Numeric[_sum__B]) -> int: ...
    def tail(self) -> 'Range': ...
    def take(self, n: int) -> 'Range': ...
    def takeRight(self, n: int) -> 'Range': ...
    def takeWhile(self, p: scala.Function1[typing.Any, typing.Any]) -> 'Range': ...
    def thisCollection(self) -> scala.collection.IndexedSeq[typing.Any]: ...
    _toBuffer__A1 = typing.TypeVar('_toBuffer__A1')  # <A1>
    def toBuffer(self) -> scala.collection.mutable.Buffer[_toBuffer__A1]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.IndexedSeq: ...
    def toIndexedSeq(self) -> IndexedSeq[typing.Any]: ...
    def toIterable(self) -> 'Range': ...
    def toSeq(self) -> 'Range': ...
    def toString(self) -> java.lang.String: ...
    def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
    @typing.overload
    def view(self) -> scala.collection.SeqView[typing.Any, scala.collection.Seq[typing.Any]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.SeqView[typing.Any, scala.collection.Seq[typing.Any]]: ...
    class BigDecimal$:
        MODULE$: typing.ClassVar['Range.BigDecimal.'] = ...
        def __init__(self): ...
        def apply(self, start: scala.math.BigDecimal, end: scala.math.BigDecimal, step: scala.math.BigDecimal) -> NumericRange.Exclusive[scala.math.BigDecimal]: ...
        def bigDecAsIntegral(self) -> scala.math.Numeric.BigDecimalAsIfIntegral.: ...
        def inclusive(self, start: scala.math.BigDecimal, end: scala.math.BigDecimal, step: scala.math.BigDecimal) -> NumericRange.Inclusive[scala.math.BigDecimal]: ...
    class BigInt$:
        MODULE$: typing.ClassVar['Range.BigInt.'] = ...
        def __init__(self): ...
        def apply(self, start: scala.math.BigInt, end: scala.math.BigInt, step: scala.math.BigInt) -> NumericRange.Exclusive[scala.math.BigInt]: ...
        def inclusive(self, start: scala.math.BigInt, end: scala.math.BigInt, step: scala.math.BigInt) -> NumericRange.Inclusive[scala.math.BigInt]: ...
    class Double$:
        MODULE$: typing.ClassVar['Range.Double.'] = ...
        def __init__(self): ...
        def apply(self, start: float, end: float, step: float) -> NumericRange[typing.Any]: ...
        def bigDecAsIntegral(self) -> scala.math.Numeric.BigDecimalAsIfIntegral.: ...
        def doubleAsIntegral(self) -> scala.math.Numeric.DoubleAsIfIntegral.: ...
        def inclusive(self, start: float, end: float, step: float) -> NumericRange[typing.Any]: ...
        def toBD(self, x: float) -> scala.math.BigDecimal: ...
    class Inclusive(scala.collection.immutable.Range):
        def __init__(self, start: int, end: int, step: int): ...
        def copy(self, start: int, end: int, step: int) -> 'Range': ...
        def isInclusive(self) -> bool: ...
    class Int$:
        MODULE$: typing.ClassVar['Range.Int.'] = ...
        def __init__(self): ...
        def apply(self, start: int, end: int, step: int) -> NumericRange.Exclusive[typing.Any]: ...
        def inclusive(self, start: int, end: int, step: int) -> NumericRange.Inclusive[typing.Any]: ...
    class Long$:
        MODULE$: typing.ClassVar['Range.Long.'] = ...
        def __init__(self): ...
        def apply(self, start: int, end: int, step: int) -> NumericRange.Exclusive[typing.Any]: ...
        def inclusive(self, start: int, end: int, step: int) -> NumericRange.Inclusive[typing.Any]: ...
    class Partial(typing.Generic[_Range__Partial__T, _Range__Partial__U]):
        def __init__(self, f: scala.Function1[_Range__Partial__T, _Range__Partial__U]): ...
        def by(self, x: _Range__Partial__T) -> _Range__Partial__U: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def scala$collection$immutable$Range$Partial$$f(self) -> scala.Function1[_Range__Partial__T, _Range__Partial__U]: ...
        def toString(self) -> java.lang.String: ...
    class Partial$:
        MODULE$: typing.ClassVar['Range.Partial.'] = ...
        def __init__(self): ...
        _by$extension__T = typing.TypeVar('_by$extension__T')  # <T>
        _by$extension__U = typing.TypeVar('_by$extension__U')  # <U>
        def by$extension(self, $this: scala.Function1[_by.extension__T, _by.extension__U], x: _by.extension__T) -> _by.extension__U: ...
        _equals$extension__T = typing.TypeVar('_equals$extension__T')  # <T>
        _equals$extension__U = typing.TypeVar('_equals$extension__U')  # <U>
        def equals$extension(self, $this: scala.Function1[_equals.extension__T, _equals.extension__U], x$1: typing.Any) -> bool: ...
        _hashCode$extension__T = typing.TypeVar('_hashCode$extension__T')  # <T>
        _hashCode$extension__U = typing.TypeVar('_hashCode$extension__U')  # <U>
        def hashCode$extension(self, $this: scala.Function1[_hashCode.extension__T, _hashCode.extension__U]) -> int: ...
        _toString$extension__T = typing.TypeVar('_toString$extension__T')  # <T>
        _toString$extension__U = typing.TypeVar('_toString$extension__U')  # <U>
        def toString$extension(self, $this: scala.Function1[_toString.extension__T, _toString.extension__U]) -> java.lang.String: ...

_RedBlackTree__BlackTree__A = typing.TypeVar('_RedBlackTree__BlackTree__A')  # <A>
_RedBlackTree__BlackTree__B = typing.TypeVar('_RedBlackTree__BlackTree__B')  # <B>
_RedBlackTree__EntriesIterator__A = typing.TypeVar('_RedBlackTree__EntriesIterator__A')  # <A>
_RedBlackTree__EntriesIterator__B = typing.TypeVar('_RedBlackTree__EntriesIterator__B')  # <B>
_RedBlackTree__KeysIterator__A = typing.TypeVar('_RedBlackTree__KeysIterator__A')  # <A>
_RedBlackTree__KeysIterator__B = typing.TypeVar('_RedBlackTree__KeysIterator__B')  # <B>
_RedBlackTree__NList__A = typing.TypeVar('_RedBlackTree__NList__A')  # <A>
_RedBlackTree__RedTree__A = typing.TypeVar('_RedBlackTree__RedTree__A')  # <A>
_RedBlackTree__RedTree__B = typing.TypeVar('_RedBlackTree__RedTree__B')  # <B>
_RedBlackTree__Tree__A = typing.TypeVar('_RedBlackTree__Tree__A')  # <A>
_RedBlackTree__Tree__B = typing.TypeVar('_RedBlackTree__Tree__B')  # <B>
_RedBlackTree__TreeIterator__A = typing.TypeVar('_RedBlackTree__TreeIterator__A')  # <A>
_RedBlackTree__TreeIterator__B = typing.TypeVar('_RedBlackTree__TreeIterator__B')  # <B>
_RedBlackTree__TreeIterator__R = typing.TypeVar('_RedBlackTree__TreeIterator__R')  # <R>
_RedBlackTree__ValuesIterator__A = typing.TypeVar('_RedBlackTree__ValuesIterator__A')  # <A>
_RedBlackTree__ValuesIterator__B = typing.TypeVar('_RedBlackTree__ValuesIterator__B')  # <B>
class RedBlackTree:
    _contains__A = typing.TypeVar('_contains__A')  # <A>
    @staticmethod
    def contains(tree: 'RedBlackTree.Tree'[_contains__A, typing.Any], x: _contains__A, evidence$1: scala.math.Ordering[_contains__A]) -> bool: ...
    @staticmethod
    def count(tree: 'RedBlackTree.Tree'[typing.Any, typing.Any]) -> int: ...
    _countInRange__A = typing.TypeVar('_countInRange__A')  # <A>
    @staticmethod
    def countInRange(tree: 'RedBlackTree.Tree'[_countInRange__A, typing.Any], from_: scala.Option[_countInRange__A], to: scala.Option[_countInRange__A], ordering: scala.math.Ordering[_countInRange__A]) -> int: ...
    _delete__A = typing.TypeVar('_delete__A')  # <A>
    _delete__B = typing.TypeVar('_delete__B')  # <B>
    @staticmethod
    def delete(tree: 'RedBlackTree.Tree'[_delete__A, _delete__B], k: _delete__A, evidence$4: scala.math.Ordering[_delete__A]) -> 'RedBlackTree.Tree'[_delete__A, _delete__B]: ...
    _drop__A = typing.TypeVar('_drop__A')  # <A>
    _drop__B = typing.TypeVar('_drop__B')  # <B>
    @staticmethod
    def drop(tree: 'RedBlackTree.Tree'[_drop__A, _drop__B], n: int, evidence$10: scala.math.Ordering[_drop__A]) -> 'RedBlackTree.Tree'[_drop__A, _drop__B]: ...
    _foreach__A = typing.TypeVar('_foreach__A')  # <A>
    _foreach__B = typing.TypeVar('_foreach__B')  # <B>
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    @staticmethod
    def foreach(tree: 'RedBlackTree.Tree'[_foreach__A, _foreach__B], f: scala.Function1[scala.Tuple2[_foreach__A, _foreach__B], _foreach__U]) -> None: ...
    _foreachKey__A = typing.TypeVar('_foreachKey__A')  # <A>
    _foreachKey__U = typing.TypeVar('_foreachKey__U')  # <U>
    @staticmethod
    def foreachKey(tree: 'RedBlackTree.Tree'[_foreachKey__A, typing.Any], f: scala.Function1[_foreachKey__A, _foreachKey__U]) -> None: ...
    _get__A = typing.TypeVar('_get__A')  # <A>
    _get__B = typing.TypeVar('_get__B')  # <B>
    @staticmethod
    def get(tree: 'RedBlackTree.Tree'[_get__A, _get__B], x: _get__A, evidence$2: scala.math.Ordering[_get__A]) -> scala.Option[_get__B]: ...
    _greatest__A = typing.TypeVar('_greatest__A')  # <A>
    _greatest__B = typing.TypeVar('_greatest__B')  # <B>
    @staticmethod
    def greatest(tree: 'RedBlackTree.Tree'[_greatest__A, _greatest__B]) -> 'RedBlackTree.Tree'[_greatest__A, _greatest__B]: ...
    @staticmethod
    def isBlack(tree: 'RedBlackTree.Tree'[typing.Any, typing.Any]) -> bool: ...
    @staticmethod
    def isEmpty(tree: 'RedBlackTree.Tree'[typing.Any, typing.Any]) -> bool: ...
    _iterator__A = typing.TypeVar('_iterator__A')  # <A>
    _iterator__B = typing.TypeVar('_iterator__B')  # <B>
    @staticmethod
    def iterator(tree: 'RedBlackTree.Tree'[_iterator__A, _iterator__B], start: scala.Option[_iterator__A], evidence$13: scala.math.Ordering[_iterator__A]) -> scala.collection.Iterator[scala.Tuple2[_iterator__A, _iterator__B]]: ...
    _iterator$default$2__A = typing.TypeVar('_iterator$default$2__A')  # <A>
    _iterator$default$2__B = typing.TypeVar('_iterator$default$2__B')  # <B>
    @staticmethod
    def iterator$default$2() -> scala.None.: ...
    _keysIterator__A = typing.TypeVar('_keysIterator__A')  # <A>
    @staticmethod
    def keysIterator(tree: 'RedBlackTree.Tree'[_keysIterator__A, typing.Any], start: scala.Option[_keysIterator__A], evidence$14: scala.math.Ordering[_keysIterator__A]) -> scala.collection.Iterator[_keysIterator__A]: ...
    _keysIterator$default$2__A = typing.TypeVar('_keysIterator$default$2__A')  # <A>
    @staticmethod
    def keysIterator$default$2() -> scala.None.: ...
    _lookup__A = typing.TypeVar('_lookup__A')  # <A>
    _lookup__B = typing.TypeVar('_lookup__B')  # <B>
    @staticmethod
    def lookup(tree: 'RedBlackTree.Tree'[_lookup__A, _lookup__B], x: _lookup__A, ordering: scala.math.Ordering[_lookup__A]) -> 'RedBlackTree.Tree'[_lookup__A, _lookup__B]: ...
    _nth__A = typing.TypeVar('_nth__A')  # <A>
    _nth__B = typing.TypeVar('_nth__B')  # <B>
    @staticmethod
    def nth(tree: 'RedBlackTree.Tree'[_nth__A, _nth__B], n: int) -> 'RedBlackTree.Tree'[_nth__A, _nth__B]: ...
    _range__A = typing.TypeVar('_range__A')  # <A>
    _range__B = typing.TypeVar('_range__B')  # <B>
    @staticmethod
    def range(tree: 'RedBlackTree.Tree'[_range__A, _range__B], from_: _range__A, until: _range__A, evidence$6: scala.math.Ordering[_range__A]) -> 'RedBlackTree.Tree'[_range__A, _range__B]: ...
    _rangeImpl__A = typing.TypeVar('_rangeImpl__A')  # <A>
    _rangeImpl__B = typing.TypeVar('_rangeImpl__B')  # <B>
    @staticmethod
    def rangeImpl(tree: 'RedBlackTree.Tree'[_rangeImpl__A, _rangeImpl__B], from_: scala.Option[_rangeImpl__A], until: scala.Option[_rangeImpl__A], evidence$5: scala.math.Ordering[_rangeImpl__A]) -> 'RedBlackTree.Tree'[_rangeImpl__A, _rangeImpl__B]: ...
    _slice__A = typing.TypeVar('_slice__A')  # <A>
    _slice__B = typing.TypeVar('_slice__B')  # <B>
    @staticmethod
    def slice(tree: 'RedBlackTree.Tree'[_slice__A, _slice__B], from_: int, until: int, evidence$12: scala.math.Ordering[_slice__A]) -> 'RedBlackTree.Tree'[_slice__A, _slice__B]: ...
    _smallest__A = typing.TypeVar('_smallest__A')  # <A>
    _smallest__B = typing.TypeVar('_smallest__B')  # <B>
    @staticmethod
    def smallest(tree: 'RedBlackTree.Tree'[_smallest__A, _smallest__B]) -> 'RedBlackTree.Tree'[_smallest__A, _smallest__B]: ...
    _take__A = typing.TypeVar('_take__A')  # <A>
    _take__B = typing.TypeVar('_take__B')  # <B>
    @staticmethod
    def take(tree: 'RedBlackTree.Tree'[_take__A, _take__B], n: int, evidence$11: scala.math.Ordering[_take__A]) -> 'RedBlackTree.Tree'[_take__A, _take__B]: ...
    _to__A = typing.TypeVar('_to__A')  # <A>
    _to__B = typing.TypeVar('_to__B')  # <B>
    @staticmethod
    def to(tree: 'RedBlackTree.Tree'[_to__A, _to__B], to: _to__A, evidence$8: scala.math.Ordering[_to__A]) -> 'RedBlackTree.Tree'[_to__A, _to__B]: ...
    _until__A = typing.TypeVar('_until__A')  # <A>
    _until__B = typing.TypeVar('_until__B')  # <B>
    @staticmethod
    def until(tree: 'RedBlackTree.Tree'[_until__A, _until__B], key: _until__A, evidence$9: scala.math.Ordering[_until__A]) -> 'RedBlackTree.Tree'[_until__A, _until__B]: ...
    _update__A = typing.TypeVar('_update__A')  # <A>
    _update__B = typing.TypeVar('_update__B')  # <B>
    _update__B1 = typing.TypeVar('_update__B1')  # <B1>
    @staticmethod
    def update(tree: 'RedBlackTree.Tree'[_update__A, _update__B], k: _update__A, v: _update__B1, overwrite: bool, evidence$3: scala.math.Ordering[_update__A]) -> 'RedBlackTree.Tree'[_update__A, _update__B1]: ...
    _valuesIterator__A = typing.TypeVar('_valuesIterator__A')  # <A>
    _valuesIterator__B = typing.TypeVar('_valuesIterator__B')  # <B>
    @staticmethod
    def valuesIterator(tree: 'RedBlackTree.Tree'[_valuesIterator__A, _valuesIterator__B], start: scala.Option[_valuesIterator__A], evidence$15: scala.math.Ordering[_valuesIterator__A]) -> scala.collection.Iterator[_valuesIterator__B]: ...
    _valuesIterator$default$2__A = typing.TypeVar('_valuesIterator$default$2__A')  # <A>
    _valuesIterator$default$2__B = typing.TypeVar('_valuesIterator$default$2__B')  # <B>
    @staticmethod
    def valuesIterator$default$2() -> scala.None.: ...
    class BlackTree(scala.collection.immutable.RedBlackTree.Tree[_RedBlackTree__BlackTree__A, _RedBlackTree__BlackTree__B], typing.Generic[_RedBlackTree__BlackTree__A, _RedBlackTree__BlackTree__B]):
        def __init__(self, key: _RedBlackTree__BlackTree__A, value: _RedBlackTree__BlackTree__B, left: 'RedBlackTree.Tree'[_RedBlackTree__BlackTree__A, _RedBlackTree__BlackTree__B], right: 'RedBlackTree.Tree'[_RedBlackTree__BlackTree__A, _RedBlackTree__BlackTree__B]): ...
        def black(self) -> 'RedBlackTree.Tree'[_RedBlackTree__BlackTree__A, _RedBlackTree__BlackTree__B]: ...
        def red(self) -> 'RedBlackTree.Tree'[_RedBlackTree__BlackTree__A, _RedBlackTree__BlackTree__B]: ...
        def toString(self) -> java.lang.String: ...
    class BlackTree$(scala.Serializable):
        MODULE$: typing.ClassVar['RedBlackTree.BlackTree.'] = ...
        def __init__(self): ...
        _apply__A = typing.TypeVar('_apply__A')  # <A>
        _apply__B = typing.TypeVar('_apply__B')  # <B>
        def apply(self, key: _apply__A, value: _apply__B, left: 'RedBlackTree.Tree'[_apply__A, _apply__B], right: 'RedBlackTree.Tree'[_apply__A, _apply__B]) -> 'RedBlackTree.BlackTree'[_apply__A, _apply__B]: ...
        _unapply__A = typing.TypeVar('_unapply__A')  # <A>
        _unapply__B = typing.TypeVar('_unapply__B')  # <B>
        def unapply(self, t: 'RedBlackTree.BlackTree'[_unapply__A, _unapply__B]) -> scala.Some[scala.Tuple4[_unapply__A, _unapply__B, 'RedBlackTree.Tree'[_unapply__A, _unapply__B], 'RedBlackTree.Tree'[_unapply__A, _unapply__B]]]: ...
    class EntriesIterator(scala.collection.immutable.RedBlackTree.TreeIterator[_RedBlackTree__EntriesIterator__A, _RedBlackTree__EntriesIterator__B, scala.Tuple2[_RedBlackTree__EntriesIterator__A, _RedBlackTree__EntriesIterator__B]], typing.Generic[_RedBlackTree__EntriesIterator__A, _RedBlackTree__EntriesIterator__B]):
        def __init__(self, tree: 'RedBlackTree.Tree'[_RedBlackTree__EntriesIterator__A, _RedBlackTree__EntriesIterator__B], focus: scala.Option[_RedBlackTree__EntriesIterator__A], evidence$16: scala.math.Ordering[_RedBlackTree__EntriesIterator__A]): ...
        def nextResult(self, tree: 'RedBlackTree.Tree'[_RedBlackTree__EntriesIterator__A, _RedBlackTree__EntriesIterator__B]) -> scala.Tuple2[_RedBlackTree__EntriesIterator__A, _RedBlackTree__EntriesIterator__B]: ...
    class KeysIterator(scala.collection.immutable.RedBlackTree.TreeIterator[_RedBlackTree__KeysIterator__A, _RedBlackTree__KeysIterator__B, _RedBlackTree__KeysIterator__A], typing.Generic[_RedBlackTree__KeysIterator__A, _RedBlackTree__KeysIterator__B]):
        def __init__(self, tree: 'RedBlackTree.Tree'[_RedBlackTree__KeysIterator__A, _RedBlackTree__KeysIterator__B], focus: scala.Option[_RedBlackTree__KeysIterator__A], evidence$17: scala.math.Ordering[_RedBlackTree__KeysIterator__A]): ...
        def nextResult(self, tree: 'RedBlackTree.Tree'[_RedBlackTree__KeysIterator__A, _RedBlackTree__KeysIterator__B]) -> _RedBlackTree__KeysIterator__A: ...
    class NList(typing.Generic[_RedBlackTree__NList__A]):
        def __init__(self, head: _RedBlackTree__NList__A, tail: 'RedBlackTree.NList'[_RedBlackTree__NList__A]): ...
        def head(self) -> _RedBlackTree__NList__A: ...
        def tail(self) -> 'RedBlackTree.NList'[_RedBlackTree__NList__A]: ...
    class NList$:
        MODULE$: typing.ClassVar['RedBlackTree.NList.'] = ...
        def __init__(self): ...
        _cons__B = typing.TypeVar('_cons__B')  # <B>
        def cons(self, x: _cons__B, xs: 'RedBlackTree.NList'[_cons__B]) -> 'RedBlackTree.NList'[_cons__B]: ...
        _foldLeft__A = typing.TypeVar('_foldLeft__A')  # <A>
        _foldLeft__B = typing.TypeVar('_foldLeft__B')  # <B>
        def foldLeft(self, xs: 'RedBlackTree.NList'[_foldLeft__A], z: _foldLeft__B, op: scala.Function2[_foldLeft__B, _foldLeft__A, _foldLeft__B]) -> _foldLeft__B: ...
    class RedTree(scala.collection.immutable.RedBlackTree.Tree[_RedBlackTree__RedTree__A, _RedBlackTree__RedTree__B], typing.Generic[_RedBlackTree__RedTree__A, _RedBlackTree__RedTree__B]):
        def __init__(self, key: _RedBlackTree__RedTree__A, value: _RedBlackTree__RedTree__B, left: 'RedBlackTree.Tree'[_RedBlackTree__RedTree__A, _RedBlackTree__RedTree__B], right: 'RedBlackTree.Tree'[_RedBlackTree__RedTree__A, _RedBlackTree__RedTree__B]): ...
        def black(self) -> 'RedBlackTree.Tree'[_RedBlackTree__RedTree__A, _RedBlackTree__RedTree__B]: ...
        def red(self) -> 'RedBlackTree.Tree'[_RedBlackTree__RedTree__A, _RedBlackTree__RedTree__B]: ...
        def toString(self) -> java.lang.String: ...
    class RedTree$(scala.Serializable):
        MODULE$: typing.ClassVar['RedBlackTree.RedTree.'] = ...
        def __init__(self): ...
        _apply__A = typing.TypeVar('_apply__A')  # <A>
        _apply__B = typing.TypeVar('_apply__B')  # <B>
        def apply(self, key: _apply__A, value: _apply__B, left: 'RedBlackTree.Tree'[_apply__A, _apply__B], right: 'RedBlackTree.Tree'[_apply__A, _apply__B]) -> 'RedBlackTree.RedTree'[_apply__A, _apply__B]: ...
        _unapply__A = typing.TypeVar('_unapply__A')  # <A>
        _unapply__B = typing.TypeVar('_unapply__B')  # <B>
        def unapply(self, t: 'RedBlackTree.RedTree'[_unapply__A, _unapply__B]) -> scala.Some[scala.Tuple4[_unapply__A, _unapply__B, 'RedBlackTree.Tree'[_unapply__A, _unapply__B], 'RedBlackTree.Tree'[_unapply__A, _unapply__B]]]: ...
    class Tree(scala.Serializable, typing.Generic[_RedBlackTree__Tree__A, _RedBlackTree__Tree__B]):
        def __init__(self, key: _RedBlackTree__Tree__A, value: _RedBlackTree__Tree__B, left: 'RedBlackTree.Tree'[_RedBlackTree__Tree__A, _RedBlackTree__Tree__B], right: 'RedBlackTree.Tree'[_RedBlackTree__Tree__A, _RedBlackTree__Tree__B]): ...
        def black(self) -> 'RedBlackTree.Tree'[_RedBlackTree__Tree__A, _RedBlackTree__Tree__B]: ...
        def count(self) -> int: ...
        def key(self) -> _RedBlackTree__Tree__A: ...
        def left(self) -> 'RedBlackTree.Tree'[_RedBlackTree__Tree__A, _RedBlackTree__Tree__B]: ...
        def red(self) -> 'RedBlackTree.Tree'[_RedBlackTree__Tree__A, _RedBlackTree__Tree__B]: ...
        def right(self) -> 'RedBlackTree.Tree'[_RedBlackTree__Tree__A, _RedBlackTree__Tree__B]: ...
        def value(self) -> _RedBlackTree__Tree__B: ...
    class TreeIterator(scala.collection.Iterator[_RedBlackTree__TreeIterator__R], typing.Generic[_RedBlackTree__TreeIterator__A, _RedBlackTree__TreeIterator__B, _RedBlackTree__TreeIterator__R]):
        def __init__(self, root: 'RedBlackTree.Tree'[_RedBlackTree__TreeIterator__A, _RedBlackTree__TreeIterator__B], start: scala.Option[_RedBlackTree__TreeIterator__A], ordering: scala.math.Ordering[_RedBlackTree__TreeIterator__A]): ...
        _$colon$bslash__B = typing.TypeVar('_$colon$bslash__B')  # <B>
        def $colon$bslash(self, z: typing.Any, op: scala.Function2[_RedBlackTree__TreeIterator__R, typing.Any, typing.Any]) -> typing.Any: ...
        _$div$colon__B = typing.TypeVar('_$div$colon__B')  # <B>
        def $div$colon(self, z: typing.Any, op: scala.Function2[typing.Any, _RedBlackTree__TreeIterator__R, typing.Any]) -> typing.Any: ...
        _$plus$plus__B = typing.TypeVar('_$plus$plus__B')  # <B>
        def $plus$plus(self, that: scala.Function0[scala.collection.GenTraversableOnce[typing.Any]]) -> scala.collection.Iterator[typing.Any]: ...
        @typing.overload
        def addString(self, b: scala.collection.mutable.StringBuilder) -> scala.collection.mutable.StringBuilder: ...
        @typing.overload
        def addString(self, b: scala.collection.mutable.StringBuilder, sep: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
        @typing.overload
        def addString(self, b: scala.collection.mutable.StringBuilder, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
        _aggregate__B = typing.TypeVar('_aggregate__B')  # <B>
        def aggregate(self, z: scala.Function0[typing.Any], seqop: scala.Function2[typing.Any, _RedBlackTree__TreeIterator__R, typing.Any], combop: scala.Function2[typing.Any, typing.Any, typing.Any]) -> typing.Any: ...
        def buffered(self) -> scala.collection.BufferedIterator[_RedBlackTree__TreeIterator__R]: ...
        _collect__B = typing.TypeVar('_collect__B')  # <B>
        def collect(self, pf: scala.PartialFunction[_RedBlackTree__TreeIterator__R, typing.Any]) -> scala.collection.Iterator[typing.Any]: ...
        _collectFirst__B = typing.TypeVar('_collectFirst__B')  # <B>
        def collectFirst(self, pf: scala.PartialFunction[_RedBlackTree__TreeIterator__R, typing.Any]) -> scala.Option[typing.Any]: ...
        def contains(self, elem: typing.Any) -> bool: ...
        _copyToArray_0__B = typing.TypeVar('_copyToArray_0__B')  # <B>
        _copyToArray_1__B = typing.TypeVar('_copyToArray_1__B')  # <B>
        _copyToArray_2__B = typing.TypeVar('_copyToArray_2__B')  # <B>
        @typing.overload
        def copyToArray(self, xs: typing.Any) -> None: ...
        @typing.overload
        def copyToArray(self, xs: typing.Any, start: int) -> None: ...
        @typing.overload
        def copyToArray(self, xs: typing.Any, start: int, len: int) -> None: ...
        _copyToBuffer__B = typing.TypeVar('_copyToBuffer__B')  # <B>
        def copyToBuffer(self, dest: scala.collection.mutable.Buffer[typing.Any]) -> None: ...
        _corresponds__B = typing.TypeVar('_corresponds__B')  # <B>
        def corresponds(self, that: scala.collection.GenTraversableOnce[typing.Any], p: scala.Function2[_RedBlackTree__TreeIterator__R, typing.Any, typing.Any]) -> bool: ...
        def count(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> int: ...
        def drop(self, n: int) -> scala.collection.Iterator[_RedBlackTree__TreeIterator__R]: ...
        def dropWhile(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> scala.collection.Iterator[_RedBlackTree__TreeIterator__R]: ...
        def duplicate(self) -> scala.Tuple2[scala.collection.Iterator[_RedBlackTree__TreeIterator__R], scala.collection.Iterator[_RedBlackTree__TreeIterator__R]]: ...
        def exists(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> bool: ...
        def filter(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> scala.collection.Iterator[_RedBlackTree__TreeIterator__R]: ...
        def filterNot(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> scala.collection.Iterator[_RedBlackTree__TreeIterator__R]: ...
        def find(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> scala.Option[_RedBlackTree__TreeIterator__R]: ...
        _flatMap__B = typing.TypeVar('_flatMap__B')  # <B>
        def flatMap(self, f: scala.Function1[_RedBlackTree__TreeIterator__R, scala.collection.GenTraversableOnce[typing.Any]]) -> scala.collection.Iterator[typing.Any]: ...
        _fold__A1 = typing.TypeVar('_fold__A1')  # <A1>
        def fold(self, z: _fold__A1, op: scala.Function2[_fold__A1, _fold__A1, _fold__A1]) -> _fold__A1: ...
        _foldLeft__B = typing.TypeVar('_foldLeft__B')  # <B>
        def foldLeft(self, z: typing.Any, op: scala.Function2[typing.Any, _RedBlackTree__TreeIterator__R, typing.Any]) -> typing.Any: ...
        _foldRight__B = typing.TypeVar('_foldRight__B')  # <B>
        def foldRight(self, z: typing.Any, op: scala.Function2[_RedBlackTree__TreeIterator__R, typing.Any, typing.Any]) -> typing.Any: ...
        def forall(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> bool: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[_RedBlackTree__TreeIterator__R, _foreach__U]) -> None: ...
        _grouped__B = typing.TypeVar('_grouped__B')  # <B>
        def grouped(self, size: int) -> scala.collection.Iterator.GroupedIterator[typing.Any]: ...
        def hasDefiniteSize(self) -> bool: ...
        def hasNext(self) -> bool: ...
        _indexOf_0__B = typing.TypeVar('_indexOf_0__B')  # <B>
        _indexOf_1__B = typing.TypeVar('_indexOf_1__B')  # <B>
        @typing.overload
        def indexOf(self, elem: typing.Any) -> int: ...
        @typing.overload
        def indexOf(self, elem: typing.Any, from_: int) -> int: ...
        @typing.overload
        def indexWhere(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> int: ...
        @typing.overload
        def indexWhere(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any], from_: int) -> int: ...
        def isEmpty(self) -> bool: ...
        def isTraversableAgain(self) -> bool: ...
        def length(self) -> int: ...
        _map__B = typing.TypeVar('_map__B')  # <B>
        def map(self, f: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> scala.collection.Iterator[typing.Any]: ...
        _max__B = typing.TypeVar('_max__B')  # <B>
        def max(self, cmp: scala.math.Ordering[typing.Any]) -> _RedBlackTree__TreeIterator__R: ...
        _maxBy__B = typing.TypeVar('_maxBy__B')  # <B>
        def maxBy(self, f: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any], cmp: scala.math.Ordering[typing.Any]) -> _RedBlackTree__TreeIterator__R: ...
        _min__B = typing.TypeVar('_min__B')  # <B>
        def min(self, cmp: scala.math.Ordering[typing.Any]) -> _RedBlackTree__TreeIterator__R: ...
        _minBy__B = typing.TypeVar('_minBy__B')  # <B>
        def minBy(self, f: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any], cmp: scala.math.Ordering[typing.Any]) -> _RedBlackTree__TreeIterator__R: ...
        @typing.overload
        def mkString(self) -> java.lang.String: ...
        @typing.overload
        def mkString(self, sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
        @typing.overload
        def mkString(self, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> java.lang.String: ...
        def next(self) -> _RedBlackTree__TreeIterator__R: ...
        def nextResult(self, tree: 'RedBlackTree.Tree'[_RedBlackTree__TreeIterator__A, _RedBlackTree__TreeIterator__B]) -> _RedBlackTree__TreeIterator__R: ...
        def nonEmpty(self) -> bool: ...
        _padTo__A1 = typing.TypeVar('_padTo__A1')  # <A1>
        def padTo(self, len: int, elem: _padTo__A1) -> scala.collection.Iterator[_padTo__A1]: ...
        def partition(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> scala.Tuple2[scala.collection.Iterator[_RedBlackTree__TreeIterator__R], scala.collection.Iterator[_RedBlackTree__TreeIterator__R]]: ...
        _patch__B = typing.TypeVar('_patch__B')  # <B>
        def patch(self, from_: int, patchElems: scala.collection.Iterator[typing.Any], replaced: int) -> scala.collection.Iterator[typing.Any]: ...
        _product__B = typing.TypeVar('_product__B')  # <B>
        def product(self, num: scala.math.Numeric[typing.Any]) -> typing.Any: ...
        _reduce__A1 = typing.TypeVar('_reduce__A1')  # <A1>
        def reduce(self, op: scala.Function2[_reduce__A1, _reduce__A1, _reduce__A1]) -> _reduce__A1: ...
        _reduceLeft__B = typing.TypeVar('_reduceLeft__B')  # <B>
        def reduceLeft(self, op: scala.Function2[typing.Any, _RedBlackTree__TreeIterator__R, typing.Any]) -> typing.Any: ...
        _reduceLeftOption__B = typing.TypeVar('_reduceLeftOption__B')  # <B>
        def reduceLeftOption(self, op: scala.Function2[typing.Any, _RedBlackTree__TreeIterator__R, typing.Any]) -> scala.Option[typing.Any]: ...
        _reduceOption__A1 = typing.TypeVar('_reduceOption__A1')  # <A1>
        def reduceOption(self, op: scala.Function2[_reduceOption__A1, _reduceOption__A1, _reduceOption__A1]) -> scala.Option[_reduceOption__A1]: ...
        _reduceRight__B = typing.TypeVar('_reduceRight__B')  # <B>
        def reduceRight(self, op: scala.Function2[_RedBlackTree__TreeIterator__R, typing.Any, typing.Any]) -> typing.Any: ...
        _reduceRightOption__B = typing.TypeVar('_reduceRightOption__B')  # <B>
        def reduceRightOption(self, op: scala.Function2[_RedBlackTree__TreeIterator__R, typing.Any, typing.Any]) -> scala.Option[typing.Any]: ...
        def reversed(self) -> List[_RedBlackTree__TreeIterator__R]: ...
        def sameElements(self, that: scala.collection.Iterator[typing.Any]) -> bool: ...
        _scanLeft__B = typing.TypeVar('_scanLeft__B')  # <B>
        def scanLeft(self, z: typing.Any, op: scala.Function2[typing.Any, _RedBlackTree__TreeIterator__R, typing.Any]) -> scala.collection.Iterator[typing.Any]: ...
        _scanRight__B = typing.TypeVar('_scanRight__B')  # <B>
        def scanRight(self, z: typing.Any, op: scala.Function2[_RedBlackTree__TreeIterator__R, typing.Any, typing.Any]) -> scala.collection.Iterator[typing.Any]: ...
        def seq(self) -> scala.collection.Iterator[_RedBlackTree__TreeIterator__R]: ...
        def size(self) -> int: ...
        def sizeHintIfCheap(self) -> int: ...
        def slice(self, from_: int, until: int) -> scala.collection.Iterator[_RedBlackTree__TreeIterator__R]: ...
        def sliceIterator(self, from_: int, until: int) -> scala.collection.Iterator[_RedBlackTree__TreeIterator__R]: ...
        _sliding__B = typing.TypeVar('_sliding__B')  # <B>
        def sliding(self, size: int, step: int) -> scala.collection.Iterator.GroupedIterator[typing.Any]: ...
        _sliding$default$2__B = typing.TypeVar('_sliding$default$2__B')  # <B>
        def sliding$default$2(self) -> int: ...
        def span(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> scala.Tuple2[scala.collection.Iterator[_RedBlackTree__TreeIterator__R], scala.collection.Iterator[_RedBlackTree__TreeIterator__R]]: ...
        _sum__B = typing.TypeVar('_sum__B')  # <B>
        def sum(self, num: scala.math.Numeric[typing.Any]) -> typing.Any: ...
        def take(self, n: int) -> scala.collection.Iterator[_RedBlackTree__TreeIterator__R]: ...
        def takeWhile(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> scala.collection.Iterator[_RedBlackTree__TreeIterator__R]: ...
        _to__Col = typing.TypeVar('_to__Col')  # <Col>
        def to(self, cbf: scala.collection.generic.CanBuildFrom[scala.runtime.Nothing., _RedBlackTree__TreeIterator__R, _to__Col]) -> _to__Col: ...
        _toArray__B = typing.TypeVar('_toArray__B')  # <B>
        def toArray(self, evidence$1: scala.reflect.ClassTag[typing.Any]) -> typing.Any: ...
        _toBuffer__B = typing.TypeVar('_toBuffer__B')  # <B>
        def toBuffer(self) -> scala.collection.mutable.Buffer[typing.Any]: ...
        def toIndexedSeq(self) -> IndexedSeq[_RedBlackTree__TreeIterator__R]: ...
        def toIterable(self) -> scala.collection.Iterable[_RedBlackTree__TreeIterator__R]: ...
        def toIterator(self) -> scala.collection.Iterator[_RedBlackTree__TreeIterator__R]: ...
        def toList(self) -> List[_RedBlackTree__TreeIterator__R]: ...
        _toMap__T = typing.TypeVar('_toMap__T')  # <T>
        _toMap__U = typing.TypeVar('_toMap__U')  # <U>
        def toMap(self, ev: scala.Predef..less.colon.less[_RedBlackTree__TreeIterator__R, scala.Tuple2[_toMap__T, _toMap__U]]) -> Map[_toMap__T, _toMap__U]: ...
        def toSeq(self) -> scala.collection.Seq[_RedBlackTree__TreeIterator__R]: ...
        _toSet__B = typing.TypeVar('_toSet__B')  # <B>
        def toSet(self) -> 'Set'[typing.Any]: ...
        def toStream(self) -> 'Stream'[_RedBlackTree__TreeIterator__R]: ...
        def toString(self) -> java.lang.String: ...
        def toTraversable(self) -> scala.collection.Traversable[_RedBlackTree__TreeIterator__R]: ...
        def toVector(self) -> 'Vector'[_RedBlackTree__TreeIterator__R]: ...
        def withFilter(self, p: scala.Function1[_RedBlackTree__TreeIterator__R, typing.Any]) -> scala.collection.Iterator[_RedBlackTree__TreeIterator__R]: ...
        _zip__B = typing.TypeVar('_zip__B')  # <B>
        def zip(self, that: scala.collection.Iterator[typing.Any]) -> scala.collection.Iterator[scala.Tuple2[_RedBlackTree__TreeIterator__R, typing.Any]]: ...
        _zipAll__B = typing.TypeVar('_zipAll__B')  # <B>
        _zipAll__A1 = typing.TypeVar('_zipAll__A1')  # <A1>
        _zipAll__B1 = typing.TypeVar('_zipAll__B1')  # <B1>
        def zipAll(self, that: scala.collection.Iterator[typing.Any], thisElem: _zipAll__A1, thatElem: _zipAll__B1) -> scala.collection.Iterator[scala.Tuple2[_zipAll__A1, _zipAll__B1]]: ...
        def zipWithIndex(self) -> scala.collection.Iterator[scala.Tuple2[_RedBlackTree__TreeIterator__R, typing.Any]]: ...
    class ValuesIterator(scala.collection.immutable.RedBlackTree.TreeIterator[_RedBlackTree__ValuesIterator__A, _RedBlackTree__ValuesIterator__B, _RedBlackTree__ValuesIterator__B], typing.Generic[_RedBlackTree__ValuesIterator__A, _RedBlackTree__ValuesIterator__B]):
        def __init__(self, tree: 'RedBlackTree.Tree'[_RedBlackTree__ValuesIterator__A, _RedBlackTree__ValuesIterator__B], focus: scala.Option[_RedBlackTree__ValuesIterator__A], evidence$18: scala.math.Ordering[_RedBlackTree__ValuesIterator__A]): ...
        def nextResult(self, tree: 'RedBlackTree.Tree'[_RedBlackTree__ValuesIterator__A, _RedBlackTree__ValuesIterator__B]) -> _RedBlackTree__ValuesIterator__B: ...

_Set__Set1__A = typing.TypeVar('_Set__Set1__A')  # <A>
_Set__Set2__A = typing.TypeVar('_Set__Set2__A')  # <A>
_Set__Set3__A = typing.TypeVar('_Set__Set3__A')  # <A>
_Set__Set4__A = typing.TypeVar('_Set__Set4__A')  # <A>
_Set__A = typing.TypeVar('_Set__A')  # <A>
class Set(Iterable[_Set__A], scala.collection.Set[_Set__A], typing.Generic[_Set__A]):
    @staticmethod
    def $init$($this: 'Set') -> None: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['Set'[typing.Any], _canBuildFrom__A, 'Set'[_canBuildFrom__A]]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['Set']: ...
    def equals(self, that: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_Set__A, scala.collection.parallel.immutable.ParSet[_Set__A]]: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_Set__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.TraversableOnce[_Set__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Iterable[_Set__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Set[_Set__A]: ...
    @typing.overload
    def seq(self) -> scala.collection.Traversable[_Set__A]: ...
    @typing.overload
    def seq(self) -> Iterable[_Set__A]: ...
    @typing.overload
    def seq(self) -> 'Set'[_Set__A]: ...
    @typing.overload
    def seq(self) -> Traversable[_Set__A]: ...
    _setCanBuildFrom__A = typing.TypeVar('_setCanBuildFrom__A')  # <A>
    @staticmethod
    def setCanBuildFrom() -> scala.collection.generic.CanBuildFrom['Set'[typing.Any], _setCanBuildFrom__A, 'Set'[_setCanBuildFrom__A]]: ...
    _toSet_0__A1 = typing.TypeVar('_toSet_0__A1')  # <A1>
    _toSet_1__B = typing.TypeVar('_toSet_1__B')  # <B>
    @typing.overload
    def toSet(self) -> scala.collection.GenSet[_toSet_0__A1]: ...
    @typing.overload
    def toSet(self) -> 'Set'[_toSet_1__B]: ...
    def toString(self) -> java.lang.String: ...
    class EmptySet$(scala.collection.AbstractSet[typing.Any], scala.collection.immutable.Set[typing.Any], scala.Serializable):
        MODULE$: typing.ClassVar['Set.EmptySet.'] = ...
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, elem: typing.Any) -> 'Set'[typing.Any]: ...
        @typing.overload
        def $plus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq[typing.Any]) -> scala.collection.Set[typing.Any]: ...
        @typing.overload
        def $plus(self, elem: typing.Any) -> 'Set'[typing.Any]: ...
        def apply(self, elem: typing.Any) -> bool: ...
        def companion(self) -> scala.collection.generic.GenericCompanion['Set']: ...
        def contains(self, elem: typing.Any) -> bool: ...
        def diff(self, that: scala.collection.GenSet[typing.Any]) -> scala.collection.Set[typing.Any]: ...
        def empty(self) -> scala.collection.GenSet: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[typing.Any, _foreach__U]) -> None: ...
        _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
        def groupBy(self, f: scala.Function1[typing.Any, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[typing.Any]]: ...
        def iterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def parCombiner(self) -> scala.collection.parallel.Combiner[typing.Any, scala.collection.parallel.immutable.ParSet[typing.Any]]: ...
        def repr(self) -> typing.Any: ...
        def seq(self) -> 'Set'[typing.Any]: ...
        def size(self) -> int: ...
        def thisCollection(self) -> scala.collection.Iterable[typing.Any]: ...
        def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
        def toIterable(self) -> scala.collection.Iterable[typing.Any]: ...
        def toSeq(self) -> scala.collection.Seq[typing.Any]: ...
        _toSet__B = typing.TypeVar('_toSet__B')  # <B>
        def toSet(self) -> 'Set'[_toSet__B]: ...
        def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
        def union(self, that: scala.collection.GenSet[typing.Any]) -> scala.collection.Set[typing.Any]: ...
        @typing.overload
        def view(self) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
        @typing.overload
        def view(self, from_: int, until: int) -> scala.collection.IterableView[typing.Any, scala.collection.Iterable[typing.Any]]: ...
    class Set1(scala.collection.AbstractSet[_Set__Set1__A], scala.collection.immutable.Set[_Set__Set1__A], scala.Serializable, typing.Generic[_Set__Set1__A]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, elem1: _Set__Set1__A): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, elem: _Set__Set1__A) -> 'Set'[_Set__Set1__A]: ...
        @typing.overload
        def $plus(self, elem1: _Set__Set1__A, elem2: _Set__Set1__A, elems: scala.collection.Seq[_Set__Set1__A]) -> scala.collection.Set[_Set__Set1__A]: ...
        @typing.overload
        def $plus(self, elem: _Set__Set1__A) -> 'Set'[_Set__Set1__A]: ...
        def apply(self, elem: _Set__Set1__A) -> bool: ...
        def companion(self) -> scala.collection.generic.GenericCompanion['Set']: ...
        def contains(self, elem: _Set__Set1__A) -> bool: ...
        def diff(self, that: scala.collection.GenSet[_Set__Set1__A]) -> scala.collection.Set[_Set__Set1__A]: ...
        def empty(self) -> scala.collection.GenSet: ...
        def exists(self, p: scala.Function1[_Set__Set1__A, typing.Any]) -> bool: ...
        def find(self, p: scala.Function1[_Set__Set1__A, typing.Any]) -> scala.Option[_Set__Set1__A]: ...
        def forall(self, p: scala.Function1[_Set__Set1__A, typing.Any]) -> bool: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[_Set__Set1__A, _foreach__U]) -> None: ...
        _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
        def groupBy(self, f: scala.Function1[_Set__Set1__A, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[_Set__Set1__A]]: ...
        def head(self) -> _Set__Set1__A: ...
        def iterator(self) -> scala.collection.Iterator[_Set__Set1__A]: ...
        def parCombiner(self) -> scala.collection.parallel.Combiner[_Set__Set1__A, scala.collection.parallel.immutable.ParSet[_Set__Set1__A]]: ...
        def repr(self) -> typing.Any: ...
        def seq(self) -> 'Set'[_Set__Set1__A]: ...
        def size(self) -> int: ...
        def tail(self) -> 'Set'[_Set__Set1__A]: ...
        def thisCollection(self) -> scala.collection.Iterable[_Set__Set1__A]: ...
        def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
        def toIterable(self) -> scala.collection.Iterable[_Set__Set1__A]: ...
        def toSeq(self) -> scala.collection.Seq[_Set__Set1__A]: ...
        _toSet__B = typing.TypeVar('_toSet__B')  # <B>
        def toSet(self) -> 'Set'[_toSet__B]: ...
        def toTraversable(self) -> scala.collection.Traversable[_Set__Set1__A]: ...
        def union(self, that: scala.collection.GenSet[_Set__Set1__A]) -> scala.collection.Set[_Set__Set1__A]: ...
        @typing.overload
        def view(self) -> scala.collection.IterableView[_Set__Set1__A, scala.collection.Iterable[_Set__Set1__A]]: ...
        @typing.overload
        def view(self, from_: int, until: int) -> scala.collection.IterableView[_Set__Set1__A, scala.collection.Iterable[_Set__Set1__A]]: ...
    class Set2(scala.collection.AbstractSet[_Set__Set2__A], scala.collection.immutable.Set[_Set__Set2__A], scala.Serializable, typing.Generic[_Set__Set2__A]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, elem1: _Set__Set2__A, elem2: _Set__Set2__A): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, elem: _Set__Set2__A) -> 'Set'[_Set__Set2__A]: ...
        @typing.overload
        def $plus(self, elem1: _Set__Set2__A, elem2: _Set__Set2__A, elems: scala.collection.Seq[_Set__Set2__A]) -> scala.collection.Set[_Set__Set2__A]: ...
        @typing.overload
        def $plus(self, elem: _Set__Set2__A) -> 'Set'[_Set__Set2__A]: ...
        def apply(self, elem: _Set__Set2__A) -> bool: ...
        def companion(self) -> scala.collection.generic.GenericCompanion['Set']: ...
        def contains(self, elem: _Set__Set2__A) -> bool: ...
        def diff(self, that: scala.collection.GenSet[_Set__Set2__A]) -> scala.collection.Set[_Set__Set2__A]: ...
        def empty(self) -> scala.collection.GenSet: ...
        def exists(self, p: scala.Function1[_Set__Set2__A, typing.Any]) -> bool: ...
        def find(self, p: scala.Function1[_Set__Set2__A, typing.Any]) -> scala.Option[_Set__Set2__A]: ...
        def forall(self, p: scala.Function1[_Set__Set2__A, typing.Any]) -> bool: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[_Set__Set2__A, _foreach__U]) -> None: ...
        _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
        def groupBy(self, f: scala.Function1[_Set__Set2__A, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[_Set__Set2__A]]: ...
        def head(self) -> _Set__Set2__A: ...
        def iterator(self) -> scala.collection.Iterator[_Set__Set2__A]: ...
        def parCombiner(self) -> scala.collection.parallel.Combiner[_Set__Set2__A, scala.collection.parallel.immutable.ParSet[_Set__Set2__A]]: ...
        def repr(self) -> typing.Any: ...
        def seq(self) -> 'Set'[_Set__Set2__A]: ...
        def size(self) -> int: ...
        def tail(self) -> 'Set'[_Set__Set2__A]: ...
        def thisCollection(self) -> scala.collection.Iterable[_Set__Set2__A]: ...
        def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
        def toIterable(self) -> scala.collection.Iterable[_Set__Set2__A]: ...
        def toSeq(self) -> scala.collection.Seq[_Set__Set2__A]: ...
        _toSet__B = typing.TypeVar('_toSet__B')  # <B>
        def toSet(self) -> 'Set'[_toSet__B]: ...
        def toTraversable(self) -> scala.collection.Traversable[_Set__Set2__A]: ...
        def union(self, that: scala.collection.GenSet[_Set__Set2__A]) -> scala.collection.Set[_Set__Set2__A]: ...
        @typing.overload
        def view(self) -> scala.collection.IterableView[_Set__Set2__A, scala.collection.Iterable[_Set__Set2__A]]: ...
        @typing.overload
        def view(self, from_: int, until: int) -> scala.collection.IterableView[_Set__Set2__A, scala.collection.Iterable[_Set__Set2__A]]: ...
    class Set3(scala.collection.AbstractSet[_Set__Set3__A], scala.collection.immutable.Set[_Set__Set3__A], scala.Serializable, typing.Generic[_Set__Set3__A]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, elem1: _Set__Set3__A, elem2: _Set__Set3__A, elem3: _Set__Set3__A): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, elem: _Set__Set3__A) -> 'Set'[_Set__Set3__A]: ...
        @typing.overload
        def $plus(self, elem1: _Set__Set3__A, elem2: _Set__Set3__A, elems: scala.collection.Seq[_Set__Set3__A]) -> scala.collection.Set[_Set__Set3__A]: ...
        @typing.overload
        def $plus(self, elem: _Set__Set3__A) -> 'Set'[_Set__Set3__A]: ...
        def apply(self, elem: _Set__Set3__A) -> bool: ...
        def companion(self) -> scala.collection.generic.GenericCompanion['Set']: ...
        def contains(self, elem: _Set__Set3__A) -> bool: ...
        def diff(self, that: scala.collection.GenSet[_Set__Set3__A]) -> scala.collection.Set[_Set__Set3__A]: ...
        def empty(self) -> scala.collection.GenSet: ...
        def exists(self, p: scala.Function1[_Set__Set3__A, typing.Any]) -> bool: ...
        def find(self, p: scala.Function1[_Set__Set3__A, typing.Any]) -> scala.Option[_Set__Set3__A]: ...
        def forall(self, p: scala.Function1[_Set__Set3__A, typing.Any]) -> bool: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[_Set__Set3__A, _foreach__U]) -> None: ...
        _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
        def groupBy(self, f: scala.Function1[_Set__Set3__A, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[_Set__Set3__A]]: ...
        def head(self) -> _Set__Set3__A: ...
        def iterator(self) -> scala.collection.Iterator[_Set__Set3__A]: ...
        def parCombiner(self) -> scala.collection.parallel.Combiner[_Set__Set3__A, scala.collection.parallel.immutable.ParSet[_Set__Set3__A]]: ...
        def repr(self) -> typing.Any: ...
        def seq(self) -> 'Set'[_Set__Set3__A]: ...
        def size(self) -> int: ...
        def tail(self) -> 'Set'[_Set__Set3__A]: ...
        def thisCollection(self) -> scala.collection.Iterable[_Set__Set3__A]: ...
        def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
        def toIterable(self) -> scala.collection.Iterable[_Set__Set3__A]: ...
        def toSeq(self) -> scala.collection.Seq[_Set__Set3__A]: ...
        _toSet__B = typing.TypeVar('_toSet__B')  # <B>
        def toSet(self) -> 'Set'[_toSet__B]: ...
        def toTraversable(self) -> scala.collection.Traversable[_Set__Set3__A]: ...
        def union(self, that: scala.collection.GenSet[_Set__Set3__A]) -> scala.collection.Set[_Set__Set3__A]: ...
        @typing.overload
        def view(self) -> scala.collection.IterableView[_Set__Set3__A, scala.collection.Iterable[_Set__Set3__A]]: ...
        @typing.overload
        def view(self, from_: int, until: int) -> scala.collection.IterableView[_Set__Set3__A, scala.collection.Iterable[_Set__Set3__A]]: ...
    class Set4(scala.collection.AbstractSet[_Set__Set4__A], scala.collection.immutable.Set[_Set__Set4__A], scala.Serializable, typing.Generic[_Set__Set4__A]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, elem1: _Set__Set4__A, elem2: _Set__Set4__A, elem3: _Set__Set4__A, elem4: _Set__Set4__A): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, elem: _Set__Set4__A) -> 'Set'[_Set__Set4__A]: ...
        @typing.overload
        def $plus(self, elem1: _Set__Set4__A, elem2: _Set__Set4__A, elems: scala.collection.Seq[_Set__Set4__A]) -> scala.collection.Set[_Set__Set4__A]: ...
        @typing.overload
        def $plus(self, elem: _Set__Set4__A) -> 'Set'[_Set__Set4__A]: ...
        def apply(self, elem: _Set__Set4__A) -> bool: ...
        def companion(self) -> scala.collection.generic.GenericCompanion['Set']: ...
        def contains(self, elem: _Set__Set4__A) -> bool: ...
        def diff(self, that: scala.collection.GenSet[_Set__Set4__A]) -> scala.collection.Set[_Set__Set4__A]: ...
        def empty(self) -> scala.collection.GenSet: ...
        def exists(self, p: scala.Function1[_Set__Set4__A, typing.Any]) -> bool: ...
        def find(self, p: scala.Function1[_Set__Set4__A, typing.Any]) -> scala.Option[_Set__Set4__A]: ...
        def forall(self, p: scala.Function1[_Set__Set4__A, typing.Any]) -> bool: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[_Set__Set4__A, _foreach__U]) -> None: ...
        _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
        def groupBy(self, f: scala.Function1[_Set__Set4__A, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[_Set__Set4__A]]: ...
        def head(self) -> _Set__Set4__A: ...
        def iterator(self) -> scala.collection.Iterator[_Set__Set4__A]: ...
        def parCombiner(self) -> scala.collection.parallel.Combiner[_Set__Set4__A, scala.collection.parallel.immutable.ParSet[_Set__Set4__A]]: ...
        def repr(self) -> typing.Any: ...
        def seq(self) -> 'Set'[_Set__Set4__A]: ...
        def size(self) -> int: ...
        def tail(self) -> 'Set'[_Set__Set4__A]: ...
        def thisCollection(self) -> scala.collection.Iterable[_Set__Set4__A]: ...
        def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
        def toIterable(self) -> scala.collection.Iterable[_Set__Set4__A]: ...
        def toSeq(self) -> scala.collection.Seq[_Set__Set4__A]: ...
        _toSet__B = typing.TypeVar('_toSet__B')  # <B>
        def toSet(self) -> 'Set'[_toSet__B]: ...
        def toTraversable(self) -> scala.collection.Traversable[_Set__Set4__A]: ...
        def union(self, that: scala.collection.GenSet[_Set__Set4__A]) -> scala.collection.Set[_Set__Set4__A]: ...
        @typing.overload
        def view(self) -> scala.collection.IterableView[_Set__Set4__A, scala.collection.Iterable[_Set__Set4__A]]: ...
        @typing.overload
        def view(self, from_: int, until: int) -> scala.collection.IterableView[_Set__Set4__A, scala.collection.Iterable[_Set__Set4__A]]: ...

_SetProxy__A = typing.TypeVar('_SetProxy__A')  # <A>
class SetProxy(Set[_SetProxy__A], scala.collection.SetProxyLike[_SetProxy__A, Set[_SetProxy__A]], typing.Generic[_SetProxy__A]):
    @staticmethod
    def $init$($this: 'SetProxy') -> None: ...
    @typing.overload
    def $minus(self, elem: _SetProxy__A) -> typing.Any: ...
    @typing.overload
    def $minus(self, elem: _SetProxy__A) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, elem: _SetProxy__A) -> scala.collection.SetLike: ...
    @typing.overload
    def $minus(self, elem1: _SetProxy__A, elem2: _SetProxy__A, elems: scala.collection.Seq[_SetProxy__A]) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, elem: _SetProxy__A) -> 'SetProxy'[_SetProxy__A]: ...
    @typing.overload
    def $plus(self, elem: _SetProxy__A) -> typing.Any: ...
    @typing.overload
    def $plus(self, elem1: _SetProxy__A, elem2: _SetProxy__A, elems: scala.collection.Seq[_SetProxy__A]) -> scala.collection.SetLike: ...
    @typing.overload
    def $plus(self, elem: _SetProxy__A) -> scala.collection.SetLike: ...
    @typing.overload
    def $plus(self, elem: _SetProxy__A) -> 'SetProxy'[_SetProxy__A]: ...
    @typing.overload
    def empty(self) -> scala.collection.SetLike: ...
    @typing.overload
    def empty(self) -> scala.collection.GenSet: ...
    @typing.overload
    def empty(self) -> 'SetProxy'[_SetProxy__A]: ...
    @typing.overload
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    def hashCode(self) -> int: ...
    @typing.overload
    def repr(self) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def repr(self) -> typing.Any: ...
    @typing.overload
    def repr(self) -> 'SetProxy'[_SetProxy__A]: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...

_SortedMap__Default__A = typing.TypeVar('_SortedMap__Default__A')  # <A>
_SortedMap__Default__B = typing.TypeVar('_SortedMap__Default__B')  # <B>
_SortedMap__A = typing.TypeVar('_SortedMap__A')  # <A>
_SortedMap__B = typing.TypeVar('_SortedMap__B')  # <B>
class SortedMap(Map[_SortedMap__A, _SortedMap__B], scala.collection.SortedMap[_SortedMap__A, _SortedMap__B], typing.Generic[_SortedMap__A, _SortedMap__B]):
    @staticmethod
    def $init$($this: 'SortedMap') -> None: ...
    _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
    _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
    _$plus_2__B1 = typing.TypeVar('_$plus_2__B1')  # <B1>
    _$plus_3__V1 = typing.TypeVar('_$plus_3__V1')  # <V1>
    _$plus_4__V1 = typing.TypeVar('_$plus_4__V1')  # <V1>
    _$plus_5__B1 = typing.TypeVar('_$plus_5__B1')  # <B1>
    _$plus_6__V1 = typing.TypeVar('_$plus_6__V1')  # <V1>
    _$plus_7__B1 = typing.TypeVar('_$plus_7__B1')  # <B1>
    _$plus_8__B1 = typing.TypeVar('_$plus_8__B1')  # <B1>
    @typing.overload
    def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_0__V1]) -> scala.collection.GenMap[typing.Any, _.plus_0__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_1__V1]) -> scala.collection.Map[typing.Any, _.plus_1__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_SortedMap__A, _.plus_2__B1]) -> scala.collection.SortedMap[_SortedMap__A, _.plus_2__B1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_3__V1]) -> Map[typing.Any, _.plus_3__V1]: ...
    @typing.overload
    def $plus(self, kv1: scala.Tuple2[typing.Any, _.plus_4__V1], kv2: scala.Tuple2[typing.Any, _.plus_4__V1], kvs: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_4__V1]]) -> scala.collection.Map[typing.Any, _.plus_4__V1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[_SortedMap__A, _.plus_5__B1], elem2: scala.Tuple2[_SortedMap__A, _.plus_5__B1], elems: scala.collection.Seq[scala.Tuple2[_SortedMap__A, _.plus_5__B1]]) -> scala.collection.SortedMap[_SortedMap__A, _.plus_5__B1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[typing.Any, _.plus_6__V1], elem2: scala.Tuple2[typing.Any, _.plus_6__V1], elems: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_6__V1]]) -> Map[typing.Any, _.plus_6__V1]: ...
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_SortedMap__A, _.plus_7__B1]) -> 'SortedMap'[_SortedMap__A, _.plus_7__B1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[_SortedMap__A, _.plus_8__B1], elem2: scala.Tuple2[_SortedMap__A, _.plus_8__B1], elems: scala.collection.Seq[scala.Tuple2[_SortedMap__A, _.plus_8__B1]]) -> 'SortedMap'[_SortedMap__A, _.plus_8__B1]: ...
    _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
    _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
    _$plus$plus_1__V1 = typing.TypeVar('_$plus$plus_1__V1')  # <V1>
    _$plus$plus_2__B1 = typing.TypeVar('_$plus$plus_2__B1')  # <B1>
    _$plus$plus_3__V1 = typing.TypeVar('_$plus$plus_3__V1')  # <V1>
    _$plus$plus_4__B1 = typing.TypeVar('_$plus$plus_4__B1')  # <B1>
    @typing.overload
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[typing.Any], bf: scala.collection.generic.CanBuildFrom[typing.Any, typing.Any, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[typing.Any, _.plus.plus_1__V1]]) -> scala.collection.Map[typing.Any, _.plus.plus_1__V1]: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[_SortedMap__A, _.plus.plus_2__B1]]) -> scala.collection.SortedMap[_SortedMap__A, _.plus.plus_2__B1]: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[typing.Any, _.plus.plus_3__V1]]) -> Map[typing.Any, _.plus.plus_3__V1]: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[_SortedMap__A, _.plus.plus_4__B1]]) -> 'SortedMap'[_SortedMap__A, _.plus.plus_4__B1]: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    _canBuildFrom__B = typing.TypeVar('_canBuildFrom__B')  # <B>
    @staticmethod
    def canBuildFrom(ord: scala.math.Ordering[_canBuildFrom__A]) -> scala.collection.generic.CanBuildFrom['SortedMap'[typing.Any, typing.Any], scala.Tuple2[_canBuildFrom__A, _canBuildFrom__B], 'SortedMap'[_canBuildFrom__A, _canBuildFrom__B]]: ...
    @typing.overload
    def empty(self) -> scala.collection.Map[typing.Any, typing.Any]: ...
    @typing.overload
    def empty(self) -> scala.collection.SortedMap[_SortedMap__A, _SortedMap__B]: ...
    @typing.overload
    def empty(self) -> Map[typing.Any, typing.Any]: ...
    @typing.overload
    def empty(self) -> 'SortedMap'[_SortedMap__A, _SortedMap__B]: ...
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    def filterKeys(self, p: scala.Function1[typing.Any, typing.Any]) -> scala.collection.GenMap[typing.Any, typing.Any]: ...
    @typing.overload
    def filterKeys(self, p: scala.Function1[typing.Any, typing.Any]) -> scala.collection.Map[typing.Any, typing.Any]: ...
    @typing.overload
    def filterKeys(self, p: scala.Function1[_SortedMap__A, typing.Any]) -> scala.collection.SortedMap[_SortedMap__A, _SortedMap__B]: ...
    @typing.overload
    def filterKeys(self, p: scala.Function1[typing.Any, typing.Any]) -> Map[typing.Any, typing.Any]: ...
    @typing.overload
    def filterKeys(self, p: scala.Function1[_SortedMap__A, typing.Any]) -> 'SortedMap'[_SortedMap__A, _SortedMap__B]: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def keySet(self) -> scala.collection.GenSet[typing.Any]: ...
    @typing.overload
    def keySet(self) -> scala.collection.Set[typing.Any]: ...
    @typing.overload
    def keySet(self) -> scala.collection.SortedSet[_SortedMap__A]: ...
    @typing.overload
    def keySet(self) -> Set[typing.Any]: ...
    @typing.overload
    def keySet(self) -> 'SortedSet'[_SortedMap__A]: ...
    _mapValues_0__W = typing.TypeVar('_mapValues_0__W')  # <W>
    _mapValues_1__W = typing.TypeVar('_mapValues_1__W')  # <W>
    _mapValues_2__C = typing.TypeVar('_mapValues_2__C')  # <C>
    _mapValues_3__W = typing.TypeVar('_mapValues_3__W')  # <W>
    _mapValues_4__C = typing.TypeVar('_mapValues_4__C')  # <C>
    @typing.overload
    def mapValues(self, f: scala.Function1[typing.Any, _mapValues_0__W]) -> scala.collection.GenMap[typing.Any, _mapValues_0__W]: ...
    @typing.overload
    def mapValues(self, f: scala.Function1[typing.Any, _mapValues_1__W]) -> scala.collection.Map[typing.Any, _mapValues_1__W]: ...
    @typing.overload
    def mapValues(self, f: scala.Function1[_SortedMap__B, _mapValues_2__C]) -> scala.collection.SortedMap[_SortedMap__A, _mapValues_2__C]: ...
    @typing.overload
    def mapValues(self, f: scala.Function1[typing.Any, _mapValues_3__W]) -> Map[typing.Any, _mapValues_3__W]: ...
    @typing.overload
    def mapValues(self, f: scala.Function1[_SortedMap__B, _mapValues_4__C]) -> 'SortedMap'[_SortedMap__A, _mapValues_4__C]: ...
    def newBuilder(self) -> scala.collection.mutable.Builder[scala.Tuple2[_SortedMap__A, _SortedMap__B], 'SortedMap'[_SortedMap__A, _SortedMap__B]]: ...
    def toString(self) -> java.lang.String: ...
    _updated_0__V1 = typing.TypeVar('_updated_0__V1')  # <V1>
    _updated_1__V1 = typing.TypeVar('_updated_1__V1')  # <V1>
    _updated_2__V1 = typing.TypeVar('_updated_2__V1')  # <V1>
    _updated_3__B1 = typing.TypeVar('_updated_3__B1')  # <B1>
    _updated_4__B1 = typing.TypeVar('_updated_4__B1')  # <B1>
    @typing.overload
    def updated(self, key: typing.Any, value: _updated_0__V1) -> scala.collection.GenMap[typing.Any, _updated_0__V1]: ...
    @typing.overload
    def updated(self, key: typing.Any, value: _updated_1__V1) -> Map[typing.Any, _updated_1__V1]: ...
    @typing.overload
    def updated(self, key: typing.Any, value: _updated_2__V1) -> scala.collection.Map[typing.Any, _updated_2__V1]: ...
    @typing.overload
    def updated(self, key: _SortedMap__A, value: _updated_3__B1) -> scala.collection.SortedMap[_SortedMap__A, _updated_3__B1]: ...
    @typing.overload
    def updated(self, key: _SortedMap__A, value: _updated_4__B1) -> 'SortedMap'[_SortedMap__A, _updated_4__B1]: ...
    class Default(scala.collection.immutable.SortedMap[_SortedMap__Default__A, _SortedMap__Default__B], scala.collection.SortedMap.Default[_SortedMap__Default__A, _SortedMap__Default__B], typing.Generic[_SortedMap__Default__A, _SortedMap__Default__B]):
        @staticmethod
        def $init$($this: 'SortedMap.Default') -> None: ...
        @typing.overload
        def $minus(self, key: typing.Any) -> typing.Any: ...
        @typing.overload
        def $minus(self, key: typing.Any) -> scala.collection.MapLike: ...
        @typing.overload
        def $minus(self, elem: _SortedMap__Default__A) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, key: _SortedMap__Default__A) -> scala.collection.SortedMap[_SortedMap__Default__A, _SortedMap__Default__B]: ...
        @typing.overload
        def $minus(self, elem1: _SortedMap__Default__A, elem2: _SortedMap__Default__A, elems: scala.collection.Seq[_SortedMap__Default__A]) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, key: _SortedMap__Default__A) -> 'SortedMap'[_SortedMap__Default__A, _SortedMap__Default__B]: ...
        _$plus_0__V1 = typing.TypeVar('_$plus_0__V1')  # <V1>
        _$plus_1__V1 = typing.TypeVar('_$plus_1__V1')  # <V1>
        _$plus_2__V1 = typing.TypeVar('_$plus_2__V1')  # <V1>
        _$plus_3__V1 = typing.TypeVar('_$plus_3__V1')  # <V1>
        _$plus_4__B1 = typing.TypeVar('_$plus_4__B1')  # <B1>
        _$plus_5__B1 = typing.TypeVar('_$plus_5__B1')  # <B1>
        _$plus_6__V1 = typing.TypeVar('_$plus_6__V1')  # <V1>
        _$plus_7__B1 = typing.TypeVar('_$plus_7__B1')  # <B1>
        _$plus_8__B1 = typing.TypeVar('_$plus_8__B1')  # <B1>
        @typing.overload
        def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_0__V1]) -> scala.collection.GenMap[typing.Any, _.plus_0__V1]: ...
        @typing.overload
        def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_1__V1]) -> scala.collection.Map[typing.Any, _.plus_1__V1]: ...
        @typing.overload
        def $plus(self, kv: scala.Tuple2[typing.Any, _.plus_2__V1]) -> Map[typing.Any, _.plus_2__V1]: ...
        @typing.overload
        def $plus(self, kv1: scala.Tuple2[typing.Any, _.plus_3__V1], kv2: scala.Tuple2[typing.Any, _.plus_3__V1], kvs: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_3__V1]]) -> scala.collection.Map[typing.Any, _.plus_3__V1]: ...
        @typing.overload
        def $plus(self, kv: scala.Tuple2[_SortedMap__Default__A, _.plus_4__B1]) -> scala.collection.SortedMap[_SortedMap__Default__A, _.plus_4__B1]: ...
        @typing.overload
        def $plus(self, elem1: scala.Tuple2[_SortedMap__Default__A, _.plus_5__B1], elem2: scala.Tuple2[_SortedMap__Default__A, _.plus_5__B1], elems: scala.collection.Seq[scala.Tuple2[_SortedMap__Default__A, _.plus_5__B1]]) -> scala.collection.SortedMap[_SortedMap__Default__A, _.plus_5__B1]: ...
        @typing.overload
        def $plus(self, elem1: scala.Tuple2[typing.Any, _.plus_6__V1], elem2: scala.Tuple2[typing.Any, _.plus_6__V1], elems: scala.collection.Seq[scala.Tuple2[typing.Any, _.plus_6__V1]]) -> Map[typing.Any, _.plus_6__V1]: ...
        @typing.overload
        def $plus(self, kv: scala.Tuple2[_SortedMap__Default__A, _.plus_7__B1]) -> 'SortedMap'[_SortedMap__Default__A, _.plus_7__B1]: ...
        @typing.overload
        def $plus(self, elem1: scala.Tuple2[_SortedMap__Default__A, _.plus_8__B1], elem2: scala.Tuple2[_SortedMap__Default__A, _.plus_8__B1], elems: scala.collection.Seq[scala.Tuple2[_SortedMap__Default__A, _.plus_8__B1]]) -> 'SortedMap'[_SortedMap__Default__A, _.plus_8__B1]: ...
        def equals(self, that: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def toString(self) -> java.lang.String: ...
    class DefaultKeySortedSet(scala.collection.SortedMapLike.DefaultKeySortedSet, scala.collection.immutable.SortedSet[_SortedMap__A]):
        def __init__(self, $outer: 'SortedMap'): ...
        @typing.overload
        def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
        @typing.overload
        def $minus(self, elem: _SortedMap__A) -> 'SortedSet'[_SortedMap__A]: ...
        @typing.overload
        def $plus(self, elem1: _SortedMap__A, elem2: _SortedMap__A, elems: scala.collection.Seq[_SortedMap__A]) -> scala.collection.Set[_SortedMap__A]: ...
        @typing.overload
        def $plus(self, elem: _SortedMap__A) -> 'SortedSet'[_SortedMap__A]: ...
        def apply(self, elem: _SortedMap__A) -> bool: ...
        def companion(self) -> scala.collection.generic.GenericCompanion[Set]: ...
        def diff(self, that: scala.collection.GenSet[_SortedMap__A]) -> scala.collection.Set[_SortedMap__A]: ...
        def empty(self) -> 'SortedSet'[_SortedMap__A]: ...
        _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
        def groupBy(self, f: scala.Function1[_SortedMap__A, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[_SortedMap__A]]: ...
        def parCombiner(self) -> scala.collection.parallel.Combiner[_SortedMap__A, scala.collection.parallel.immutable.ParSet[_SortedMap__A]]: ...
        def range(self, from_: _SortedMap__A, until: _SortedMap__A) -> scala.collection.SortedSet[_SortedMap__A]: ...
        def rangeImpl(self, from_: scala.Option[_SortedMap__A], until: scala.Option[_SortedMap__A]) -> 'SortedSet'[_SortedMap__A]: ...
        def repr(self) -> typing.Any: ...
        def seq(self) -> Set[_SortedMap__A]: ...
        def thisCollection(self) -> scala.collection.Iterable[_SortedMap__A]: ...
        def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
        def toIterable(self) -> scala.collection.Iterable[_SortedMap__A]: ...
        def toSeq(self) -> scala.collection.Seq[_SortedMap__A]: ...
        _toSet__C = typing.TypeVar('_toSet__C')  # <C>
        def toSet(self) -> Set[_toSet__C]: ...
        def toTraversable(self) -> scala.collection.Traversable[_SortedMap__A]: ...
        def union(self, that: scala.collection.GenSet[_SortedMap__A]) -> scala.collection.Set[_SortedMap__A]: ...
        def until(self, until: _SortedMap__A) -> scala.collection.SortedSet[_SortedMap__A]: ...
        @typing.overload
        def view(self) -> scala.collection.IterableView[_SortedMap__A, scala.collection.Iterable[_SortedMap__A]]: ...
        @typing.overload
        def view(self, from_: int, until: int) -> scala.collection.IterableView[_SortedMap__A, scala.collection.Iterable[_SortedMap__A]]: ...

_SortedSet__A = typing.TypeVar('_SortedSet__A')  # <A>
class SortedSet(Set[_SortedSet__A], scala.collection.SortedSet[_SortedSet__A], typing.Generic[_SortedSet__A]):
    @staticmethod
    def $init$($this: 'SortedSet') -> None: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom(ord: scala.math.Ordering[_canBuildFrom__A]) -> scala.collection.generic.CanBuildFrom['SortedSet'[typing.Any], _canBuildFrom__A, 'SortedSet'[_canBuildFrom__A]]: ...
    @typing.overload
    def empty(self) -> scala.collection.SetLike: ...
    @typing.overload
    def empty(self) -> scala.collection.GenSet: ...
    @typing.overload
    def empty(self) -> scala.collection.SortedSet[_SortedSet__A]: ...
    @typing.overload
    def empty(self) -> 'SortedSet'[_SortedSet__A]: ...
    def equals(self, that: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    _newCanBuildFrom__A = typing.TypeVar('_newCanBuildFrom__A')  # <A>
    @staticmethod
    def newCanBuildFrom(ord: scala.math.Ordering[_newCanBuildFrom__A]) -> scala.collection.generic.CanBuildFrom['SortedSet'[typing.Any], _newCanBuildFrom__A, 'SortedSet'[_newCanBuildFrom__A]]: ...
    def toString(self) -> java.lang.String: ...

_Stream__Cons__A = typing.TypeVar('_Stream__Cons__A')  # <A>
_Stream__ConsWrapper__A = typing.TypeVar('_Stream__ConsWrapper__A')  # <A>
_Stream__StreamBuilder__A = typing.TypeVar('_Stream__StreamBuilder__A')  # <A>
_Stream__StreamCanBuildFrom__A = typing.TypeVar('_Stream__StreamCanBuildFrom__A')  # <A>
_Stream__StreamWithFilter__A = typing.TypeVar('_Stream__StreamWithFilter__A')  # <A>
_Stream__A = typing.TypeVar('_Stream__A')  # <A>
class Stream(scala.collection.AbstractSeq[_Stream__A], LinearSeq[_Stream__A], scala.collection.LinearSeqOptimized[_Stream__A, 'Stream'[_Stream__A]], scala.Serializable, typing.Generic[_Stream__A]):
    def __init__(self): ...
    _$plus$colon__B = typing.TypeVar('_$plus$colon__B')  # <B>
    _$plus$colon__That = typing.TypeVar('_$plus$colon__That')  # <That>
    def $plus$colon(self, elem: _.plus.colon__B, bf: scala.collection.generic.CanBuildFrom['Stream'[_Stream__A], _.plus.colon__B, _.plus.colon__That]) -> _.plus.colon__That: ...
    _$plus$plus__B = typing.TypeVar('_$plus$plus__B')  # <B>
    _$plus$plus__That = typing.TypeVar('_$plus$plus__That')  # <That>
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus__B], bf: scala.collection.generic.CanBuildFrom['Stream'[_Stream__A], _.plus.plus__B, _.plus.plus__That]) -> _.plus.plus__That: ...
    @staticmethod
    def ReusableCBF() -> scala.collection.generic.GenTraversableFactory.GenericCanBuildFrom[scala.runtime.Nothing.]: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder, sep: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    _append__B = typing.TypeVar('_append__B')  # <B>
    def append(self, rest: scala.Function0[scala.collection.TraversableOnce[_append__B]]) -> 'Stream'[_append__B]: ...
    def apply(self, n: int) -> _Stream__A: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['Stream'[typing.Any], _canBuildFrom__A, 'Stream'[_canBuildFrom__A]]: ...
    _collect__B = typing.TypeVar('_collect__B')  # <B>
    _collect__That = typing.TypeVar('_collect__That')  # <That>
    def collect(self, pf: scala.PartialFunction[_Stream__A, _collect__B], bf: scala.collection.generic.CanBuildFrom['Stream'[_Stream__A], _collect__B, _collect__That]) -> _collect__That: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['Stream']: ...
    @staticmethod
    def concat(xss: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    _consWrapper__A = typing.TypeVar('_consWrapper__A')  # <A>
    @staticmethod
    def consWrapper(stream: scala.Function0['Stream'[_consWrapper__A]]) -> 'Stream.ConsWrapper'[_consWrapper__A]: ...
    _contains__A1 = typing.TypeVar('_contains__A1')  # <A1>
    def contains(self, elem: _contains__A1) -> bool: ...
    _continually__A = typing.TypeVar('_continually__A')  # <A>
    @staticmethod
    def continually(elem: scala.Function0[_continually__A]) -> 'Stream'[_continually__A]: ...
    _corresponds__B = typing.TypeVar('_corresponds__B')  # <B>
    def corresponds(self, that: scala.collection.GenSeq[_corresponds__B], p: scala.Function2[_Stream__A, _corresponds__B, typing.Any]) -> bool: ...
    def distinct(self) -> 'Stream'[_Stream__A]: ...
    def drop(self, n: int) -> 'Stream'[_Stream__A]: ...
    def dropRight(self, n: int) -> 'Stream'[_Stream__A]: ...
    def dropWhile(self, p: scala.Function1[_Stream__A, typing.Any]) -> 'Stream'[_Stream__A]: ...
    _empty__A = typing.TypeVar('_empty__A')  # <A>
    @staticmethod
    def empty() -> 'Stream'[_empty__A]: ...
    def equals(self, that: typing.Any) -> bool: ...
    def exists(self, p: scala.Function1[_Stream__A, typing.Any]) -> bool: ...
    _fill_4__A = typing.TypeVar('_fill_4__A')  # <A>
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, n5: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n: int, elem: scala.Function0[_fill_4__A]) -> 'Stream'[_fill_4__A]: ...
    def filterImpl(self, p: scala.Function1[_Stream__A, typing.Any], isFlipped: bool) -> 'Stream'[_Stream__A]: ...
    def find(self, p: scala.Function1[_Stream__A, typing.Any]) -> scala.Option[_Stream__A]: ...
    _flatMap__B = typing.TypeVar('_flatMap__B')  # <B>
    _flatMap__That = typing.TypeVar('_flatMap__That')  # <That>
    def flatMap(self, f: scala.Function1[_Stream__A, scala.collection.GenTraversableOnce[_flatMap__B]], bf: scala.collection.generic.CanBuildFrom['Stream'[_Stream__A], _flatMap__B, _flatMap__That]) -> _flatMap__That: ...
    _flatten__B = typing.TypeVar('_flatten__B')  # <B>
    def flatten(self, asTraversable: scala.Function1[_Stream__A, scala.collection.GenTraversableOnce[_flatten__B]]) -> 'Stream'[_flatten__B]: ...
    _foldLeft__B = typing.TypeVar('_foldLeft__B')  # <B>
    def foldLeft(self, z: _foldLeft__B, op: scala.Function2[_foldLeft__B, _Stream__A, _foldLeft__B]) -> _foldLeft__B: ...
    _foldRight__B = typing.TypeVar('_foldRight__B')  # <B>
    def foldRight(self, z: _foldRight__B, op: scala.Function2[_Stream__A, _foldRight__B, _foldRight__B]) -> _foldRight__B: ...
    def forall(self, p: scala.Function1[_Stream__A, typing.Any]) -> bool: ...
    def force(self) -> 'Stream'[_Stream__A]: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[_Stream__A, _foreach__U]) -> None: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[_Stream__A, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[_Stream__A]]: ...
    def hasDefiniteSize(self) -> bool: ...
    def hashCode(self) -> int: ...
    def head(self) -> _Stream__A: ...
    @typing.overload
    def indexWhere(self, p: scala.Function1[_Stream__A, typing.Any]) -> int: ...
    @typing.overload
    def indexWhere(self, p: scala.Function1[_Stream__A, typing.Any], from_: int) -> int: ...
    def init(self) -> 'Stream'[_Stream__A]: ...
    def isDefinedAt(self, x: int) -> bool: ...
    def isEmpty(self) -> bool: ...
    _iterate_0__A = typing.TypeVar('_iterate_0__A')  # <A>
    _iterate_1__A = typing.TypeVar('_iterate_1__A')  # <A>
    @typing.overload
    @staticmethod
    def iterate(start: _iterate_0__A, len: int, f: scala.Function1[_iterate_0__A, _iterate_0__A]) -> 'Stream'[_iterate_0__A]: ...
    @typing.overload
    @staticmethod
    def iterate(start: _iterate_1__A, f: scala.Function1[_iterate_1__A, _iterate_1__A]) -> 'Stream'[_iterate_1__A]: ...
    def iterator(self) -> scala.collection.Iterator[_Stream__A]: ...
    def last(self) -> _Stream__A: ...
    @typing.overload
    def lastIndexWhere(self, p: scala.Function1[_Stream__A, typing.Any]) -> int: ...
    @typing.overload
    def lastIndexWhere(self, p: scala.Function1[_Stream__A, typing.Any], end: int) -> int: ...
    def length(self) -> int: ...
    def lengthCompare(self, len: int) -> int: ...
    _map__B = typing.TypeVar('_map__B')  # <B>
    _map__That = typing.TypeVar('_map__That')  # <That>
    def map(self, f: scala.Function1[_Stream__A, _map__B], bf: scala.collection.generic.CanBuildFrom['Stream'[_Stream__A], _map__B, _map__That]) -> _map__That: ...
    @typing.overload
    def mkString(self) -> java.lang.String: ...
    @typing.overload
    def mkString(self, sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def mkString(self, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    _padTo__B = typing.TypeVar('_padTo__B')  # <B>
    _padTo__That = typing.TypeVar('_padTo__That')  # <That>
    def padTo(self, len: int, elem: _padTo__B, bf: scala.collection.generic.CanBuildFrom['Stream'[_Stream__A], _padTo__B, _padTo__That]) -> _padTo__That: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_Stream__A, scala.collection.parallel.immutable.ParSeq[_Stream__A]]: ...
    def partition(self, p: scala.Function1[_Stream__A, typing.Any]) -> scala.Tuple2['Stream'[_Stream__A], 'Stream'[_Stream__A]]: ...
    _range_1__T = typing.TypeVar('_range_1__T')  # <T>
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, evidence$1: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: _range_1__T, end: _range_1__T, step: _range_1__T, evidence$1: scala.math.Integral[_range_1__T]) -> 'Stream'[_range_1__T]: ...
    _reduceLeft__B = typing.TypeVar('_reduceLeft__B')  # <B>
    def reduceLeft(self, f: scala.Function2[_reduceLeft__B, _Stream__A, _reduceLeft__B]) -> _reduceLeft__B: ...
    _reduceRight__B = typing.TypeVar('_reduceRight__B')  # <B>
    def reduceRight(self, op: scala.Function2[_Stream__A, _reduceRight__B, _reduceRight__B]) -> _reduceRight__B: ...
    def reverse(self) -> 'Stream'[_Stream__A]: ...
    _sameElements__B = typing.TypeVar('_sameElements__B')  # <B>
    def sameElements(self, that: scala.collection.GenIterable[_sameElements__B]) -> bool: ...
    _scanLeft__B = typing.TypeVar('_scanLeft__B')  # <B>
    _scanLeft__That = typing.TypeVar('_scanLeft__That')  # <That>
    def scanLeft(self, z: _scanLeft__B, op: scala.Function2[_scanLeft__B, _Stream__A, _scanLeft__B], bf: scala.collection.generic.CanBuildFrom['Stream'[_Stream__A], _scanLeft__B, _scanLeft__That]) -> _scanLeft__That: ...
    def segmentLength(self, p: scala.Function1[_Stream__A, typing.Any], from_: int) -> int: ...
    def seq(self) -> LinearSeq[_Stream__A]: ...
    def slice(self, from_: int, until: int) -> 'Stream'[_Stream__A]: ...
    def span(self, p: scala.Function1[_Stream__A, typing.Any]) -> scala.Tuple2['Stream'[_Stream__A], 'Stream'[_Stream__A]]: ...
    def splitAt(self, n: int) -> scala.Tuple2['Stream'[_Stream__A], 'Stream'[_Stream__A]]: ...
    def stringPrefix(self) -> java.lang.String: ...
    _tabulate_4__A = typing.TypeVar('_tabulate_4__A')  # <A>
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, n5: int, f: scala.Function5) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, f: scala.Function4) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, f: scala.Function3) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, f: scala.Function2) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n: int, f: scala.Function1[typing.Any, _tabulate_4__A]) -> 'Stream'[_tabulate_4__A]: ...
    def tail(self) -> typing.Any: ...
    def tailDefined(self) -> bool: ...
    def tails(self) -> scala.collection.Iterator['Stream'[_Stream__A]]: ...
    def take(self, n: int) -> 'Stream'[_Stream__A]: ...
    def takeRight(self, n: int) -> 'Stream'[_Stream__A]: ...
    def takeWhile(self, p: scala.Function1[_Stream__A, typing.Any]) -> 'Stream'[_Stream__A]: ...
    def thisCollection(self) -> scala.collection.LinearSeq[_Stream__A]: ...
    def toCollection(self, repr: scala.collection.LinearSeqLike) -> scala.collection.LinearSeq: ...
    def toIterable(self) -> scala.collection.Iterable[_Stream__A]: ...
    def toSeq(self) -> Seq[_Stream__A]: ...
    def toStream(self) -> 'Stream'[_Stream__A]: ...
    def toString(self) -> java.lang.String: ...
    def toTraversable(self) -> scala.collection.Traversable[_Stream__A]: ...
    @staticmethod
    def unapplySeq(x: scala.collection.Seq) -> scala.Some: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.SeqView[_Stream__A, scala.collection.Seq[_Stream__A]]: ...
    @typing.overload
    def view(self) -> 'StreamView'[_Stream__A, 'Stream'[_Stream__A]]: ...
    def withFilter(self, p: scala.Function1[_Stream__A, typing.Any]) -> scala.collection.generic.FilterMonadic[_Stream__A, 'Stream'[_Stream__A]]: ...
    _zip__A1 = typing.TypeVar('_zip__A1')  # <A1>
    _zip__B = typing.TypeVar('_zip__B')  # <B>
    _zip__That = typing.TypeVar('_zip__That')  # <That>
    def zip(self, that: scala.collection.GenIterable[_zip__B], bf: scala.collection.generic.CanBuildFrom['Stream'[_Stream__A], scala.Tuple2[_zip__A1, _zip__B], _zip__That]) -> _zip__That: ...
    _zipWithIndex__A1 = typing.TypeVar('_zipWithIndex__A1')  # <A1>
    _zipWithIndex__That = typing.TypeVar('_zipWithIndex__That')  # <That>
    def zipWithIndex(self, bf: scala.collection.generic.CanBuildFrom['Stream'[_Stream__A], scala.Tuple2[_zipWithIndex__A1, typing.Any], _zipWithIndex__That]) -> _zipWithIndex__That: ...
    class $hash$colon$colon$:
        MODULE$: typing.ClassVar['Stream..hash.colon.colon.'] = ...
        def __init__(self): ...
        _unapply__A = typing.TypeVar('_unapply__A')  # <A>
        def unapply(self, xs: 'Stream'[_unapply__A]) -> scala.Option[scala.Tuple2[_unapply__A, 'Stream'[_unapply__A]]]: ...
    class Cons(scala.collection.immutable.Stream[_Stream__Cons__A], typing.Generic[_Stream__Cons__A]):
        serialVersionUID: typing.ClassVar[int] = ...
        def __init__(self, hd: _Stream__Cons__A, tl: scala.Function0['Stream'[_Stream__Cons__A]]): ...
        def head(self) -> _Stream__Cons__A: ...
        def isEmpty(self) -> bool: ...
        _sameElements__B = typing.TypeVar('_sameElements__B')  # <B>
        def sameElements(self, that: scala.collection.GenIterable[_sameElements__B]) -> bool: ...
        def tail(self) -> 'Stream'[_Stream__Cons__A]: ...
        def tailDefined(self) -> bool: ...
    class ConsWrapper(typing.Generic[_Stream__ConsWrapper__A]):
        def __init__(self, tl: scala.Function0['Stream'[_Stream__ConsWrapper__A]]): ...
        _$hash$colon$colon__B = typing.TypeVar('_$hash$colon$colon__B')  # <B>
        def $hash$colon$colon(self, hd: _.hash.colon.colon__B) -> 'Stream'[_.hash.colon.colon__B]: ...
        _$hash$colon$colon$colon__B = typing.TypeVar('_$hash$colon$colon$colon__B')  # <B>
        def $hash$colon$colon$colon(self, prefix: 'Stream'[_.hash.colon.colon.colon__B]) -> 'Stream'[_.hash.colon.colon.colon__B]: ...
    class Empty$(scala.collection.immutable.Stream[scala.runtime.Nothing.]):
        MODULE$: typing.ClassVar['Stream.Empty.'] = ...
        def __init__(self): ...
        def head(self) -> scala.runtime.Nothing.: ...
        def isEmpty(self) -> bool: ...
        def tail(self) -> scala.runtime.Nothing.: ...
        def tailDefined(self) -> bool: ...
    class StreamBuilder(scala.collection.mutable.LazyBuilder[_Stream__StreamBuilder__A, 'Stream'[_Stream__StreamBuilder__A]], typing.Generic[_Stream__StreamBuilder__A]):
        def __init__(self): ...
        def result(self) -> 'Stream'[_Stream__StreamBuilder__A]: ...
    class StreamCanBuildFrom(scala.collection.generic.GenTraversableFactory.GenericCanBuildFrom[_Stream__StreamCanBuildFrom__A], typing.Generic[_Stream__StreamCanBuildFrom__A]):
        def __init__(self): ...
    class StreamWithFilter(scala.collection.generic.FilterMonadic[_Stream__StreamWithFilter__A, 'Stream'[_Stream__StreamWithFilter__A]], typing.Generic[_Stream__StreamWithFilter__A]):
        def __init__(self, sl: scala.Function0['Stream'[_Stream__StreamWithFilter__A]], p: scala.Function1[_Stream__StreamWithFilter__A, typing.Any]): ...
        _flatMap__B = typing.TypeVar('_flatMap__B')  # <B>
        _flatMap__That = typing.TypeVar('_flatMap__That')  # <That>
        def flatMap(self, f: scala.Function1[_Stream__StreamWithFilter__A, scala.collection.GenTraversableOnce[_flatMap__B]], bf: scala.collection.generic.CanBuildFrom['Stream'[_Stream__StreamWithFilter__A], _flatMap__B, _flatMap__That]) -> _flatMap__That: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[_Stream__StreamWithFilter__A, _foreach__U]) -> None: ...
        _map__B = typing.TypeVar('_map__B')  # <B>
        _map__That = typing.TypeVar('_map__That')  # <That>
        def map(self, f: scala.Function1[_Stream__StreamWithFilter__A, _map__B], bf: scala.collection.generic.CanBuildFrom['Stream'[_Stream__StreamWithFilter__A], _map__B, _map__That]) -> _map__That: ...
        def withFilter(self, q: scala.Function1[_Stream__StreamWithFilter__A, typing.Any]) -> scala.collection.generic.FilterMonadic[_Stream__StreamWithFilter__A, 'Stream'[_Stream__StreamWithFilter__A]]: ...
    class cons$:
        MODULE$: typing.ClassVar['Stream.cons.'] = ...
        def __init__(self): ...
        _apply__A = typing.TypeVar('_apply__A')  # <A>
        def apply(self, hd: _apply__A, tl: scala.Function0['Stream'[_apply__A]]) -> 'Stream.Cons'[_apply__A]: ...
        _unapply__A = typing.TypeVar('_unapply__A')  # <A>
        def unapply(self, xs: 'Stream'[_unapply__A]) -> scala.Option[scala.Tuple2[_unapply__A, 'Stream'[_unapply__A]]]: ...

_StreamView__A = typing.TypeVar('_StreamView__A')  # <A>
_StreamView__Coll = typing.TypeVar('_StreamView__Coll')  # <Coll>
class StreamView(scala.collection.immutable.StreamViewLike[_StreamView__A, _StreamView__Coll, 'StreamView'[_StreamView__A, _StreamView__Coll]], typing.Generic[_StreamView__A, _StreamView__Coll]):
    def equals(self, that: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...

_TreeMap__A = typing.TypeVar('_TreeMap__A')  # <A>
_TreeMap__B = typing.TypeVar('_TreeMap__B')  # <B>
class TreeMap(SortedMap[_TreeMap__A, _TreeMap__B], scala.Serializable, typing.Generic[_TreeMap__A, _TreeMap__B]):
    def __init__(self, ordering: scala.math.Ordering[_TreeMap__A]): ...
    _$colon$bslash__B = typing.TypeVar('_$colon$bslash__B')  # <B>
    def $colon$bslash(self, z: typing.Any, op: scala.Function2[scala.Tuple2[_TreeMap__A, typing.Any], typing.Any, typing.Any]) -> typing.Any: ...
    _$div$colon__B = typing.TypeVar('_$div$colon__B')  # <B>
    def $div$colon(self, z: typing.Any, op: scala.Function2[typing.Any, scala.Tuple2[_TreeMap__A, typing.Any], typing.Any]) -> typing.Any: ...
    @typing.overload
    def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, key: _TreeMap__A) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def $minus$minus(self, xs: scala.collection.GenTraversableOnce) -> scala.collection.generic.Subtractable: ...
    _$plus_0__B1 = typing.TypeVar('_$plus_0__B1')  # <B1>
    _$plus_1__B1 = typing.TypeVar('_$plus_1__B1')  # <B1>
    @typing.overload
    def $plus(self, kv: scala.Tuple2[_TreeMap__A, _.plus_0__B1]) -> 'TreeMap'[_TreeMap__A, _.plus_0__B1]: ...
    @typing.overload
    def $plus(self, elem1: scala.Tuple2[_TreeMap__A, _.plus_1__B1], elem2: scala.Tuple2[_TreeMap__A, _.plus_1__B1], elems: scala.collection.Seq[scala.Tuple2[_TreeMap__A, _.plus_1__B1]]) -> 'TreeMap'[_TreeMap__A, _.plus_1__B1]: ...
    _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
    _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
    _$plus$plus_1__B1 = typing.TypeVar('_$plus$plus_1__B1')  # <B1>
    @typing.overload
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[typing.Any], bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, typing.Any], typing.Any, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
    @typing.overload
    def $plus$plus(self, xs: scala.collection.GenTraversableOnce[scala.Tuple2[_TreeMap__A, _.plus.plus_1__B1]]) -> 'TreeMap'[_TreeMap__A, _.plus.plus_1__B1]: ...
    _$plus$plus$colon_0__B = typing.TypeVar('_$plus$plus$colon_0__B')  # <B>
    _$plus$plus$colon_0__That = typing.TypeVar('_$plus$plus$colon_0__That')  # <That>
    _$plus$plus$colon_1__B = typing.TypeVar('_$plus$plus$colon_1__B')  # <B>
    _$plus$plus$colon_1__That = typing.TypeVar('_$plus$plus$colon_1__That')  # <That>
    @typing.overload
    def $plus$plus$colon(self, that: scala.collection.Traversable[typing.Any], bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, typing.Any], typing.Any, _.plus.plus.colon_0__That]) -> _.plus.plus.colon_0__That: ...
    @typing.overload
    def $plus$plus$colon(self, that: scala.collection.TraversableOnce[typing.Any], bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, typing.Any], typing.Any, _.plus.plus.colon_1__That]) -> _.plus.plus.colon_1__That: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder, sep: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    _aggregate__B = typing.TypeVar('_aggregate__B')  # <B>
    def aggregate(self, z: scala.Function0[typing.Any], seqop: scala.Function2[typing.Any, scala.Tuple2[_TreeMap__A, typing.Any], typing.Any], combop: scala.Function2[typing.Any, typing.Any, typing.Any]) -> typing.Any: ...
    _andThen__C = typing.TypeVar('_andThen__C')  # <C>
    def andThen(self, k: scala.Function1[_TreeMap__B, _andThen__C]) -> scala.PartialFunction[_TreeMap__A, _andThen__C]: ...
    def apply(self, key: _TreeMap__A) -> _TreeMap__B: ...
    def apply$mcDD$sp(self, v1: float) -> float: ...
    def apply$mcDF$sp(self, v1: float) -> float: ...
    def apply$mcDI$sp(self, v1: int) -> float: ...
    def apply$mcDJ$sp(self, v1: int) -> float: ...
    def apply$mcFD$sp(self, v1: float) -> float: ...
    def apply$mcFF$sp(self, v1: float) -> float: ...
    def apply$mcFI$sp(self, v1: int) -> float: ...
    def apply$mcFJ$sp(self, v1: int) -> float: ...
    def apply$mcID$sp(self, v1: float) -> int: ...
    def apply$mcIF$sp(self, v1: float) -> int: ...
    def apply$mcII$sp(self, v1: int) -> int: ...
    def apply$mcIJ$sp(self, v1: int) -> int: ...
    def apply$mcJD$sp(self, v1: float) -> int: ...
    def apply$mcJF$sp(self, v1: float) -> int: ...
    def apply$mcJI$sp(self, v1: int) -> int: ...
    def apply$mcJJ$sp(self, v1: int) -> int: ...
    def apply$mcVD$sp(self, v1: float) -> None: ...
    def apply$mcVF$sp(self, v1: float) -> None: ...
    def apply$mcVI$sp(self, v1: int) -> None: ...
    def apply$mcVJ$sp(self, v1: int) -> None: ...
    def apply$mcZD$sp(self, v1: float) -> bool: ...
    def apply$mcZF$sp(self, v1: float) -> bool: ...
    def apply$mcZI$sp(self, v1: int) -> bool: ...
    def apply$mcZJ$sp(self, v1: int) -> bool: ...
    _applyOrElse__K1 = typing.TypeVar('_applyOrElse__K1')  # <K1>
    _applyOrElse__V1 = typing.TypeVar('_applyOrElse__V1')  # <V1>
    def applyOrElse(self, x: _applyOrElse__K1, default: scala.Function1[_applyOrElse__K1, _applyOrElse__V1]) -> _applyOrElse__V1: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    _canBuildFrom__B = typing.TypeVar('_canBuildFrom__B')  # <B>
    @staticmethod
    def canBuildFrom(ord: scala.math.Ordering[_canBuildFrom__A]) -> scala.collection.generic.CanBuildFrom['TreeMap'[typing.Any, typing.Any], scala.Tuple2[_canBuildFrom__A, _canBuildFrom__B], 'TreeMap'[_canBuildFrom__A, _canBuildFrom__B]]: ...
    def canEqual(self, that: typing.Any) -> bool: ...
    _collect__B = typing.TypeVar('_collect__B')  # <B>
    _collect__That = typing.TypeVar('_collect__That')  # <That>
    def collect(self, pf: scala.PartialFunction[scala.Tuple2[_TreeMap__A, typing.Any], typing.Any], bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, typing.Any], typing.Any, _collect__That]) -> _collect__That: ...
    _collectFirst__B = typing.TypeVar('_collectFirst__B')  # <B>
    def collectFirst(self, pf: scala.PartialFunction[scala.Tuple2[_TreeMap__A, typing.Any], typing.Any]) -> scala.Option[typing.Any]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion[Iterable]: ...
    def compare(self, k0: _TreeMap__A, k1: _TreeMap__A) -> int: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    def compose(self, g: scala.Function1[typing.Any, typing.Any]) -> scala.Function1[typing.Any, _TreeMap__B]: ...
    def contains(self, key: _TreeMap__A) -> bool: ...
    _copyToArray_0__B = typing.TypeVar('_copyToArray_0__B')  # <B>
    _copyToArray_1__B = typing.TypeVar('_copyToArray_1__B')  # <B>
    _copyToArray_2__B = typing.TypeVar('_copyToArray_2__B')  # <B>
    @typing.overload
    def copyToArray(self, xs: typing.Any) -> None: ...
    @typing.overload
    def copyToArray(self, xs: typing.Any, start: int) -> None: ...
    @typing.overload
    def copyToArray(self, xs: typing.Any, start: int, len: int) -> None: ...
    _copyToBuffer__B = typing.TypeVar('_copyToBuffer__B')  # <B>
    def copyToBuffer(self, dest: scala.collection.mutable.Buffer[typing.Any]) -> None: ...
    def count(self, p: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], typing.Any]) -> int: ...
    def default(self, key: _TreeMap__A) -> _TreeMap__B: ...
    def drop(self, n: int) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def dropRight(self, n: int) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def dropWhile(self, p: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], typing.Any]) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def empty(self) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def equals(self, that: typing.Any) -> bool: ...
    def exists(self, p: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], typing.Any]) -> bool: ...
    def filter(self, p: scala.Function1) -> typing.Any: ...
    def filterImpl(self, p: scala.Function1, isFlipped: bool) -> typing.Any: ...
    def filterKeys(self, p: scala.Function1[_TreeMap__A, typing.Any]) -> SortedMap[_TreeMap__A, _TreeMap__B]: ...
    def filterNot(self, p: scala.Function1) -> scala.collection.Map: ...
    def find(self, p: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], typing.Any]) -> scala.Option[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    def firstKey(self) -> _TreeMap__A: ...
    _flatMap__B = typing.TypeVar('_flatMap__B')  # <B>
    _flatMap__That = typing.TypeVar('_flatMap__That')  # <That>
    def flatMap(self, f: scala.Function1[scala.Tuple2[_TreeMap__A, typing.Any], scala.collection.GenTraversableOnce[typing.Any]], bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, typing.Any], typing.Any, _flatMap__That]) -> _flatMap__That: ...
    def flatten(self, asTraversable: scala.Function1) -> scala.collection.GenTraversable: ...
    _fold__A1 = typing.TypeVar('_fold__A1')  # <A1>
    def fold(self, z: _fold__A1, op: scala.Function2[_fold__A1, _fold__A1, _fold__A1]) -> _fold__A1: ...
    _foldLeft__B = typing.TypeVar('_foldLeft__B')  # <B>
    def foldLeft(self, z: typing.Any, op: scala.Function2[typing.Any, scala.Tuple2[_TreeMap__A, typing.Any], typing.Any]) -> typing.Any: ...
    _foldRight__B = typing.TypeVar('_foldRight__B')  # <B>
    def foldRight(self, z: typing.Any, op: scala.Function2[scala.Tuple2[_TreeMap__A, typing.Any], typing.Any, typing.Any]) -> typing.Any: ...
    def forall(self, p: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], typing.Any]) -> bool: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], _foreach__U]) -> None: ...
    _genericBuilder__B = typing.TypeVar('_genericBuilder__B')  # <B>
    def genericBuilder(self) -> scala.collection.mutable.Builder[typing.Any, Iterable[typing.Any]]: ...
    def get(self, key: _TreeMap__A) -> scala.Option[_TreeMap__B]: ...
    _getOrElse__V1 = typing.TypeVar('_getOrElse__V1')  # <V1>
    def getOrElse(self, key: _TreeMap__A, default: scala.Function0[_getOrElse__V1]) -> _getOrElse__V1: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], _groupBy__K]) -> Map[_groupBy__K, 'TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    def grouped(self, size: int) -> scala.collection.Iterator['TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    def hasAll(self, j: scala.collection.Iterator[_TreeMap__A]) -> bool: ...
    def hasDefiniteSize(self) -> bool: ...
    def hashCode(self) -> int: ...
    def head(self) -> scala.Tuple2[_TreeMap__A, _TreeMap__B]: ...
    def headOption(self) -> scala.Option[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    def init(self) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def inits(self) -> scala.collection.Iterator['TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    _insert__B1 = typing.TypeVar('_insert__B1')  # <B1>
    def insert(self, key: _TreeMap__A, value: _insert__B1) -> 'TreeMap'[_TreeMap__A, _insert__B1]: ...
    def isDefinedAt(self, key: _TreeMap__A) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isTraversableAgain(self) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    def iteratorFrom(self, start: _TreeMap__A) -> scala.collection.Iterator[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    def keySet(self) -> SortedSet[_TreeMap__A]: ...
    def keys(self) -> scala.collection.Iterable[_TreeMap__A]: ...
    def keysIterator(self) -> scala.collection.Iterator[_TreeMap__A]: ...
    def keysIteratorFrom(self, start: _TreeMap__A) -> scala.collection.Iterator[_TreeMap__A]: ...
    def last(self) -> scala.Tuple2[_TreeMap__A, _TreeMap__B]: ...
    def lastKey(self) -> _TreeMap__A: ...
    def lastOption(self) -> scala.Option[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    def lift(self) -> scala.Function1[_TreeMap__A, scala.Option[_TreeMap__B]]: ...
    _map__B = typing.TypeVar('_map__B')  # <B>
    _map__That = typing.TypeVar('_map__That')  # <That>
    def map(self, f: scala.Function1[scala.Tuple2[_TreeMap__A, typing.Any], typing.Any], bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, typing.Any], typing.Any, _map__That]) -> _map__That: ...
    _mapValues__C = typing.TypeVar('_mapValues__C')  # <C>
    def mapValues(self, f: scala.Function1[_TreeMap__B, _mapValues__C]) -> SortedMap[_TreeMap__A, _mapValues__C]: ...
    def max(self, cmp: scala.math.Ordering) -> typing.Any: ...
    def maxBy(self, f: scala.Function1, cmp: scala.math.Ordering) -> typing.Any: ...
    def min(self, cmp: scala.math.Ordering) -> typing.Any: ...
    def minBy(self, f: scala.Function1, cmp: scala.math.Ordering) -> typing.Any: ...
    @typing.overload
    def mkString(self) -> java.lang.String: ...
    @typing.overload
    def mkString(self, sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def mkString(self, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def newBuilder(self) -> scala.collection.mutable.Builder[scala.Tuple2[_TreeMap__A, _TreeMap__B], 'TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    def nonEmpty(self) -> bool: ...
    _orElse__A1 = typing.TypeVar('_orElse__A1')  # <A1>
    _orElse__B1 = typing.TypeVar('_orElse__B1')  # <B1>
    def orElse(self, that: scala.PartialFunction[_orElse__A1, _orElse__B1]) -> scala.PartialFunction[_orElse__A1, _orElse__B1]: ...
    def ordering(self) -> scala.math.Ordering[_TreeMap__A]: ...
    def par(self) -> scala.collection.Parallel: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[scala.Tuple2[_TreeMap__A, _TreeMap__B], scala.collection.parallel.immutable.ParMap[_TreeMap__A, _TreeMap__B]]: ...
    def partition(self, p: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], typing.Any]) -> scala.Tuple2['TreeMap'[_TreeMap__A, _TreeMap__B], 'TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    _product__B = typing.TypeVar('_product__B')  # <B>
    def product(self, num: scala.math.Numeric[typing.Any]) -> typing.Any: ...
    def range(self, from_: _TreeMap__A, until: _TreeMap__A) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def rangeImpl(self, from_: scala.Option[_TreeMap__A], until: scala.Option[_TreeMap__A]) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    _reduce__A1 = typing.TypeVar('_reduce__A1')  # <A1>
    def reduce(self, op: scala.Function2[_reduce__A1, _reduce__A1, _reduce__A1]) -> _reduce__A1: ...
    _reduceLeft__B = typing.TypeVar('_reduceLeft__B')  # <B>
    def reduceLeft(self, op: scala.Function2[typing.Any, scala.Tuple2[_TreeMap__A, typing.Any], typing.Any]) -> typing.Any: ...
    _reduceLeftOption__B = typing.TypeVar('_reduceLeftOption__B')  # <B>
    def reduceLeftOption(self, op: scala.Function2[typing.Any, scala.Tuple2[_TreeMap__A, typing.Any], typing.Any]) -> scala.Option[typing.Any]: ...
    _reduceOption__A1 = typing.TypeVar('_reduceOption__A1')  # <A1>
    def reduceOption(self, op: scala.Function2[_reduceOption__A1, _reduceOption__A1, _reduceOption__A1]) -> scala.Option[_reduceOption__A1]: ...
    _reduceRight__B = typing.TypeVar('_reduceRight__B')  # <B>
    def reduceRight(self, op: scala.Function2[scala.Tuple2[_TreeMap__A, typing.Any], typing.Any, typing.Any]) -> typing.Any: ...
    _reduceRightOption__B = typing.TypeVar('_reduceRightOption__B')  # <B>
    def reduceRightOption(self, op: scala.Function2[scala.Tuple2[_TreeMap__A, typing.Any], typing.Any, typing.Any]) -> scala.Option[typing.Any]: ...
    def repr(self) -> typing.Any: ...
    def reversed(self) -> List[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    _runWith__U = typing.TypeVar('_runWith__U')  # <U>
    def runWith(self, action: scala.Function1[_TreeMap__B, _runWith__U]) -> scala.Function1[_TreeMap__A, typing.Any]: ...
    _sameElements__B = typing.TypeVar('_sameElements__B')  # <B>
    def sameElements(self, that: scala.collection.GenIterable[typing.Any]) -> bool: ...
    _scan__B = typing.TypeVar('_scan__B')  # <B>
    _scan__That = typing.TypeVar('_scan__That')  # <That>
    def scan(self, z: typing.Any, op: scala.Function2[typing.Any, typing.Any, typing.Any], cbf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, typing.Any], typing.Any, _scan__That]) -> _scan__That: ...
    _scanLeft__B = typing.TypeVar('_scanLeft__B')  # <B>
    _scanLeft__That = typing.TypeVar('_scanLeft__That')  # <That>
    def scanLeft(self, z: typing.Any, op: scala.Function2[typing.Any, scala.Tuple2[_TreeMap__A, typing.Any], typing.Any], bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, typing.Any], typing.Any, _scanLeft__That]) -> _scanLeft__That: ...
    _scanRight__B = typing.TypeVar('_scanRight__B')  # <B>
    _scanRight__That = typing.TypeVar('_scanRight__That')  # <That>
    def scanRight(self, z: typing.Any, op: scala.Function2[scala.Tuple2[_TreeMap__A, typing.Any], typing.Any, typing.Any], bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, typing.Any], typing.Any, _scanRight__That]) -> _scanRight__That: ...
    def seq(self) -> Map[_TreeMap__A, _TreeMap__B]: ...
    def size(self) -> int: ...
    def sizeHintIfCheap(self) -> int: ...
    def slice(self, from_: int, until: int) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def sliceWithKnownBound(self, from_: int, until: int) -> typing.Any: ...
    def sliceWithKnownDelta(self, from_: int, until: int, delta: int) -> typing.Any: ...
    @typing.overload
    def sliding(self, size: int) -> scala.collection.Iterator['TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    @typing.overload
    def sliding(self, size: int, step: int) -> scala.collection.Iterator['TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    def span(self, p: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], typing.Any]) -> scala.Tuple2['TreeMap'[_TreeMap__A, _TreeMap__B], 'TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    def splitAt(self, n: int) -> scala.Tuple2['TreeMap'[_TreeMap__A, _TreeMap__B], 'TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    def stringPrefix(self) -> java.lang.String: ...
    _sum__B = typing.TypeVar('_sum__B')  # <B>
    def sum(self, num: scala.math.Numeric[typing.Any]) -> typing.Any: ...
    def tail(self) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def tails(self) -> scala.collection.Iterator['TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    def take(self, n: int) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def takeRight(self, n: int) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def takeWhile(self, p: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], typing.Any]) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    def thisCollection(self) -> scala.collection.Iterable[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    _to_0__Col = typing.TypeVar('_to_0__Col')  # <Col>
    @typing.overload
    def to(self, cbf: scala.collection.generic.CanBuildFrom[scala.runtime.Nothing., scala.Tuple2[_TreeMap__A, _TreeMap__B], _to_0__Col]) -> _to_0__Col: ...
    @typing.overload
    def to(self, to: _TreeMap__A) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    _toArray__B = typing.TypeVar('_toArray__B')  # <B>
    def toArray(self, evidence$1: scala.reflect.ClassTag[typing.Any]) -> typing.Any: ...
    _toBuffer__E = typing.TypeVar('_toBuffer__E')  # <E>
    def toBuffer(self) -> scala.collection.mutable.Buffer[_toBuffer__E]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
    def toIndexedSeq(self) -> IndexedSeq[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    def toIterable(self) -> scala.collection.Iterable[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    def toIterator(self) -> scala.collection.Iterator[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    def toList(self) -> List[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    _toMap__T = typing.TypeVar('_toMap__T')  # <T>
    _toMap__U = typing.TypeVar('_toMap__U')  # <U>
    def toMap(self, ev: scala.Predef..less.colon.less[scala.Tuple2[_TreeMap__A, _TreeMap__B], scala.Tuple2[_toMap__T, _toMap__U]]) -> Map[_toMap__T, _toMap__U]: ...
    def toSeq(self) -> scala.collection.Seq[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    _toSet__B = typing.TypeVar('_toSet__B')  # <B>
    def toSet(self) -> Set[typing.Any]: ...
    def toStream(self) -> Stream[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    def toString(self) -> java.lang.String: ...
    def toTraversable(self) -> scala.collection.Traversable[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    def toVector(self) -> 'Vector'[scala.Tuple2[_TreeMap__A, _TreeMap__B]]: ...
    _transform__W = typing.TypeVar('_transform__W')  # <W>
    _transform__That = typing.TypeVar('_transform__That')  # <That>
    def transform(self, f: scala.Function2[_TreeMap__A, _TreeMap__B, _transform__W], bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, _TreeMap__B], scala.Tuple2[_TreeMap__A, _transform__W], _transform__That]) -> _transform__That: ...
    def transpose(self, asTraversable: scala.Function1) -> scala.collection.GenTraversable: ...
    def until(self, until: _TreeMap__A) -> 'TreeMap'[_TreeMap__A, _TreeMap__B]: ...
    _unzip__A1 = typing.TypeVar('_unzip__A1')  # <A1>
    _unzip__A2 = typing.TypeVar('_unzip__A2')  # <A2>
    def unzip(self, asPair: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], scala.Tuple2[_unzip__A1, _unzip__A2]]) -> scala.Tuple2[Iterable[_unzip__A1], Iterable[_unzip__A2]]: ...
    _unzip3__A1 = typing.TypeVar('_unzip3__A1')  # <A1>
    _unzip3__A2 = typing.TypeVar('_unzip3__A2')  # <A2>
    _unzip3__A3 = typing.TypeVar('_unzip3__A3')  # <A3>
    def unzip3(self, asTriple: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], scala.Tuple3[_unzip3__A1, _unzip3__A2, _unzip3__A3]]) -> scala.Tuple3[Iterable[_unzip3__A1], Iterable[_unzip3__A2], Iterable[_unzip3__A3]]: ...
    _updated__B1 = typing.TypeVar('_updated__B1')  # <B1>
    def updated(self, key: _TreeMap__A, value: _updated__B1) -> 'TreeMap'[_TreeMap__A, _updated__B1]: ...
    def values(self) -> scala.collection.Iterable[_TreeMap__B]: ...
    def valuesIterator(self) -> scala.collection.Iterator[_TreeMap__B]: ...
    def valuesIteratorFrom(self, start: _TreeMap__A) -> scala.collection.Iterator[_TreeMap__B]: ...
    @typing.overload
    def view(self) -> scala.collection.IterableView[scala.Tuple2[_TreeMap__A, _TreeMap__B], 'TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.IterableView[scala.Tuple2[_TreeMap__A, _TreeMap__B], 'TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    _withDefault__V1 = typing.TypeVar('_withDefault__V1')  # <V1>
    def withDefault(self, d: scala.Function1[_TreeMap__A, _withDefault__V1]) -> Map[_TreeMap__A, _withDefault__V1]: ...
    _withDefaultValue__V1 = typing.TypeVar('_withDefaultValue__V1')  # <V1>
    def withDefaultValue(self, d: _withDefaultValue__V1) -> Map[_TreeMap__A, _withDefaultValue__V1]: ...
    def withFilter(self, p: scala.Function1[scala.Tuple2[_TreeMap__A, _TreeMap__B], typing.Any]) -> scala.collection.generic.FilterMonadic[scala.Tuple2[_TreeMap__A, _TreeMap__B], 'TreeMap'[_TreeMap__A, _TreeMap__B]]: ...
    _zip__A1 = typing.TypeVar('_zip__A1')  # <A1>
    _zip__B = typing.TypeVar('_zip__B')  # <B>
    _zip__That = typing.TypeVar('_zip__That')  # <That>
    def zip(self, that: scala.collection.GenIterable[typing.Any], bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, typing.Any], scala.Tuple2[_zip__A1, typing.Any], _zip__That]) -> _zip__That: ...
    _zipAll__B = typing.TypeVar('_zipAll__B')  # <B>
    _zipAll__A1 = typing.TypeVar('_zipAll__A1')  # <A1>
    _zipAll__That = typing.TypeVar('_zipAll__That')  # <That>
    def zipAll(self, that: scala.collection.GenIterable[typing.Any], thisElem: _zipAll__A1, thatElem: typing.Any, bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, typing.Any], scala.Tuple2[_zipAll__A1, typing.Any], _zipAll__That]) -> _zipAll__That: ...
    _zipWithIndex__A1 = typing.TypeVar('_zipWithIndex__A1')  # <A1>
    _zipWithIndex__That = typing.TypeVar('_zipWithIndex__That')  # <That>
    def zipWithIndex(self, bf: scala.collection.generic.CanBuildFrom['TreeMap'[_TreeMap__A, _TreeMap__B], scala.Tuple2[_zipWithIndex__A1, typing.Any], _zipWithIndex__That]) -> _zipWithIndex__That: ...

_TreeSet__A = typing.TypeVar('_TreeSet__A')  # <A>
class TreeSet(SortedSet[_TreeSet__A], scala.Serializable, typing.Generic[_TreeSet__A]):
    serialVersionUID: typing.ClassVar[int] = ...
    def __init__(self, ordering: scala.math.Ordering[_TreeSet__A]): ...
    def $amp(self, that: scala.collection.GenSet) -> typing.Any: ...
    def $amp$tilde(self, that: scala.collection.GenSet) -> typing.Any: ...
    def $bar(self, that: scala.collection.GenSet) -> typing.Any: ...
    _$colon$bslash__B = typing.TypeVar('_$colon$bslash__B')  # <B>
    def $colon$bslash(self, z: _.colon.bslash__B, op: scala.Function2[_TreeSet__A, _.colon.bslash__B, _.colon.bslash__B]) -> _.colon.bslash__B: ...
    _$div$colon__B = typing.TypeVar('_$div$colon__B')  # <B>
    def $div$colon(self, z: _.div.colon__B, op: scala.Function2[_.div.colon__B, _TreeSet__A, _.div.colon__B]) -> _.div.colon__B: ...
    @typing.overload
    def $minus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $minus(self, elem: _TreeSet__A) -> 'TreeSet'[_TreeSet__A]: ...
    def $minus$minus(self, xs: scala.collection.GenTraversableOnce) -> scala.collection.generic.Subtractable: ...
    @typing.overload
    def $plus(self, elem1: typing.Any, elem2: typing.Any, elems: scala.collection.Seq) -> scala.collection.Set: ...
    @typing.overload
    def $plus(self, elem: _TreeSet__A) -> 'TreeSet'[_TreeSet__A]: ...
    _$plus$plus_0__B = typing.TypeVar('_$plus$plus_0__B')  # <B>
    _$plus$plus_0__That = typing.TypeVar('_$plus$plus_0__That')  # <That>
    @typing.overload
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus_0__B], bf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], _.plus.plus_0__B, _.plus.plus_0__That]) -> _.plus.plus_0__That: ...
    @typing.overload
    def $plus$plus(self, elems: scala.collection.GenTraversableOnce) -> scala.collection.Set: ...
    _$plus$plus$colon_0__B = typing.TypeVar('_$plus$plus$colon_0__B')  # <B>
    _$plus$plus$colon_0__That = typing.TypeVar('_$plus$plus$colon_0__That')  # <That>
    _$plus$plus$colon_1__B = typing.TypeVar('_$plus$plus$colon_1__B')  # <B>
    _$plus$plus$colon_1__That = typing.TypeVar('_$plus$plus$colon_1__That')  # <That>
    @typing.overload
    def $plus$plus$colon(self, that: scala.collection.Traversable[_.plus.plus.colon_0__B], bf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], _.plus.plus.colon_0__B, _.plus.plus.colon_0__That]) -> _.plus.plus.colon_0__That: ...
    @typing.overload
    def $plus$plus$colon(self, that: scala.collection.TraversableOnce[_.plus.plus.colon_1__B], bf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], _.plus.plus.colon_1__B, _.plus.plus.colon_1__That]) -> _.plus.plus.colon_1__That: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder, sep: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    @typing.overload
    def addString(self, b: scala.collection.mutable.StringBuilder, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> scala.collection.mutable.StringBuilder: ...
    _aggregate__B = typing.TypeVar('_aggregate__B')  # <B>
    def aggregate(self, z: scala.Function0[_aggregate__B], seqop: scala.Function2[_aggregate__B, _TreeSet__A, _aggregate__B], combop: scala.Function2[_aggregate__B, _aggregate__B, _aggregate__B]) -> _aggregate__B: ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    def andThen(self, g: scala.Function1[typing.Any, typing.Any]) -> scala.Function1[typing.Any, typing.Any]: ...
    def apply(self, elem: _TreeSet__A) -> bool: ...
    def apply$mcDD$sp(self, v1: float) -> float: ...
    def apply$mcDF$sp(self, v1: float) -> float: ...
    def apply$mcDI$sp(self, v1: int) -> float: ...
    def apply$mcDJ$sp(self, v1: int) -> float: ...
    def apply$mcFD$sp(self, v1: float) -> float: ...
    def apply$mcFF$sp(self, v1: float) -> float: ...
    def apply$mcFI$sp(self, v1: int) -> float: ...
    def apply$mcFJ$sp(self, v1: int) -> float: ...
    def apply$mcID$sp(self, v1: float) -> int: ...
    def apply$mcIF$sp(self, v1: float) -> int: ...
    def apply$mcII$sp(self, v1: int) -> int: ...
    def apply$mcIJ$sp(self, v1: int) -> int: ...
    def apply$mcJD$sp(self, v1: float) -> int: ...
    def apply$mcJF$sp(self, v1: float) -> int: ...
    def apply$mcJI$sp(self, v1: int) -> int: ...
    def apply$mcJJ$sp(self, v1: int) -> int: ...
    def apply$mcVD$sp(self, v1: float) -> None: ...
    def apply$mcVF$sp(self, v1: float) -> None: ...
    def apply$mcVI$sp(self, v1: int) -> None: ...
    def apply$mcVJ$sp(self, v1: int) -> None: ...
    def apply$mcZD$sp(self, v1: float) -> bool: ...
    def apply$mcZF$sp(self, v1: float) -> bool: ...
    def apply$mcZI$sp(self, v1: int) -> bool: ...
    def apply$mcZJ$sp(self, v1: int) -> bool: ...
    def canEqual(self, that: typing.Any) -> bool: ...
    _collect__B = typing.TypeVar('_collect__B')  # <B>
    _collect__That = typing.TypeVar('_collect__That')  # <That>
    def collect(self, pf: scala.PartialFunction[_TreeSet__A, _collect__B], bf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], _collect__B, _collect__That]) -> _collect__That: ...
    _collectFirst__B = typing.TypeVar('_collectFirst__B')  # <B>
    def collectFirst(self, pf: scala.PartialFunction[_TreeSet__A, _collectFirst__B]) -> scala.Option[_collectFirst__B]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion[Set]: ...
    def compare(self, k0: _TreeSet__A, k1: _TreeSet__A) -> int: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    def compose(self, g: scala.Function1[typing.Any, typing.Any]) -> scala.Function1[typing.Any, typing.Any]: ...
    def contains(self, elem: _TreeSet__A) -> bool: ...
    _copyToArray_0__B = typing.TypeVar('_copyToArray_0__B')  # <B>
    _copyToArray_1__B = typing.TypeVar('_copyToArray_1__B')  # <B>
    _copyToArray_2__B = typing.TypeVar('_copyToArray_2__B')  # <B>
    @typing.overload
    def copyToArray(self, xs: typing.Any) -> None: ...
    @typing.overload
    def copyToArray(self, xs: typing.Any, start: int) -> None: ...
    @typing.overload
    def copyToArray(self, xs: typing.Any, start: int, len: int) -> None: ...
    _copyToBuffer__B = typing.TypeVar('_copyToBuffer__B')  # <B>
    def copyToBuffer(self, dest: scala.collection.mutable.Buffer[_copyToBuffer__B]) -> None: ...
    def count(self, p: scala.Function1[_TreeSet__A, typing.Any]) -> int: ...
    def diff(self, that: scala.collection.GenSet) -> scala.collection.Set: ...
    def drop(self, n: int) -> 'TreeSet'[_TreeSet__A]: ...
    def dropRight(self, n: int) -> 'TreeSet'[_TreeSet__A]: ...
    def dropWhile(self, p: scala.Function1[_TreeSet__A, typing.Any]) -> 'TreeSet'[_TreeSet__A]: ...
    def empty(self) -> 'TreeSet'[_TreeSet__A]: ...
    def equals(self, that: typing.Any) -> bool: ...
    def exists(self, p: scala.Function1[_TreeSet__A, typing.Any]) -> bool: ...
    def filter(self, p: scala.Function1) -> typing.Any: ...
    def filterImpl(self, p: scala.Function1, isFlipped: bool) -> typing.Any: ...
    def filterNot(self, p: scala.Function1) -> typing.Any: ...
    def find(self, p: scala.Function1[_TreeSet__A, typing.Any]) -> scala.Option[_TreeSet__A]: ...
    def firstKey(self) -> _TreeSet__A: ...
    _flatMap__B = typing.TypeVar('_flatMap__B')  # <B>
    _flatMap__That = typing.TypeVar('_flatMap__That')  # <That>
    def flatMap(self, f: scala.Function1[_TreeSet__A, scala.collection.GenTraversableOnce[_flatMap__B]], bf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], _flatMap__B, _flatMap__That]) -> _flatMap__That: ...
    def flatten(self, asTraversable: scala.Function1) -> scala.collection.GenTraversable: ...
    _fold__A1 = typing.TypeVar('_fold__A1')  # <A1>
    def fold(self, z: _fold__A1, op: scala.Function2[_fold__A1, _fold__A1, _fold__A1]) -> _fold__A1: ...
    _foldLeft__B = typing.TypeVar('_foldLeft__B')  # <B>
    def foldLeft(self, z: _foldLeft__B, op: scala.Function2[_foldLeft__B, _TreeSet__A, _foldLeft__B]) -> _foldLeft__B: ...
    _foldRight__B = typing.TypeVar('_foldRight__B')  # <B>
    def foldRight(self, z: _foldRight__B, op: scala.Function2[_TreeSet__A, _foldRight__B, _foldRight__B]) -> _foldRight__B: ...
    def forall(self, p: scala.Function1[_TreeSet__A, typing.Any]) -> bool: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[_TreeSet__A, _foreach__U]) -> None: ...
    _genericBuilder__B = typing.TypeVar('_genericBuilder__B')  # <B>
    def genericBuilder(self) -> scala.collection.mutable.Builder[_genericBuilder__B, Set[_genericBuilder__B]]: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[_TreeSet__A, _groupBy__K]) -> Map[_groupBy__K, 'TreeSet'[_TreeSet__A]]: ...
    def grouped(self, size: int) -> scala.collection.Iterator['TreeSet'[_TreeSet__A]]: ...
    def hasAll(self, j: scala.collection.Iterator[_TreeSet__A]) -> bool: ...
    def hasDefiniteSize(self) -> bool: ...
    def hashCode(self) -> int: ...
    def head(self) -> _TreeSet__A: ...
    def headOption(self) -> scala.Option[_TreeSet__A]: ...
    _implicitBuilder__A = typing.TypeVar('_implicitBuilder__A')  # <A>
    @staticmethod
    def implicitBuilder(ordering: scala.math.Ordering[_implicitBuilder__A]) -> scala.collection.mutable.Builder[_implicitBuilder__A, 'TreeSet'[_implicitBuilder__A]]: ...
    def init(self) -> 'TreeSet'[_TreeSet__A]: ...
    def inits(self) -> scala.collection.Iterator['TreeSet'[_TreeSet__A]]: ...
    def insert(self, elem: _TreeSet__A) -> 'TreeSet'[_TreeSet__A]: ...
    def intersect(self, that: scala.collection.GenSet) -> typing.Any: ...
    def isEmpty(self) -> bool: ...
    def isTraversableAgain(self) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[_TreeSet__A]: ...
    def iteratorFrom(self, start: _TreeSet__A) -> scala.collection.Iterator[_TreeSet__A]: ...
    def keySet(self) -> scala.collection.SortedSet: ...
    def keysIteratorFrom(self, start: _TreeSet__A) -> scala.collection.Iterator[_TreeSet__A]: ...
    def last(self) -> _TreeSet__A: ...
    def lastKey(self) -> _TreeSet__A: ...
    def lastOption(self) -> scala.Option[_TreeSet__A]: ...
    _map__B = typing.TypeVar('_map__B')  # <B>
    _map__That = typing.TypeVar('_map__That')  # <That>
    def map(self, f: scala.Function1[_TreeSet__A, _map__B], bf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], _map__B, _map__That]) -> _map__That: ...
    _max__A1 = typing.TypeVar('_max__A1')  # <A1>
    def max(self, ord: scala.math.Ordering[_max__A1]) -> _TreeSet__A: ...
    _maxBy__B = typing.TypeVar('_maxBy__B')  # <B>
    def maxBy(self, f: scala.Function1[_TreeSet__A, _maxBy__B], cmp: scala.math.Ordering[_maxBy__B]) -> _TreeSet__A: ...
    _min__A1 = typing.TypeVar('_min__A1')  # <A1>
    def min(self, ord: scala.math.Ordering[_min__A1]) -> _TreeSet__A: ...
    _minBy__B = typing.TypeVar('_minBy__B')  # <B>
    def minBy(self, f: scala.Function1[_TreeSet__A, _minBy__B], cmp: scala.math.Ordering[_minBy__B]) -> _TreeSet__A: ...
    @typing.overload
    def mkString(self) -> java.lang.String: ...
    @typing.overload
    def mkString(self, sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def mkString(self, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def newBuilder(self) -> scala.collection.mutable.Builder[_TreeSet__A, 'TreeSet'[_TreeSet__A]]: ...
    _newCanBuildFrom__A = typing.TypeVar('_newCanBuildFrom__A')  # <A>
    @staticmethod
    def newCanBuildFrom(ord: scala.math.Ordering[_newCanBuildFrom__A]) -> scala.collection.generic.CanBuildFrom['TreeSet'[typing.Any], _newCanBuildFrom__A, 'TreeSet'[_newCanBuildFrom__A]]: ...
    def nonEmpty(self) -> bool: ...
    def ordering(self) -> scala.math.Ordering[_TreeSet__A]: ...
    def par(self) -> scala.collection.Parallel: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_TreeSet__A, scala.collection.parallel.immutable.ParSet[_TreeSet__A]]: ...
    def partition(self, p: scala.Function1[_TreeSet__A, typing.Any]) -> scala.Tuple2['TreeSet'[_TreeSet__A], 'TreeSet'[_TreeSet__A]]: ...
    _product__B = typing.TypeVar('_product__B')  # <B>
    def product(self, num: scala.math.Numeric[_product__B]) -> _product__B: ...
    def range(self, from_: _TreeSet__A, until: _TreeSet__A) -> 'TreeSet'[_TreeSet__A]: ...
    def rangeImpl(self, from_: scala.Option[_TreeSet__A], until: scala.Option[_TreeSet__A]) -> 'TreeSet'[_TreeSet__A]: ...
    _reduce__A1 = typing.TypeVar('_reduce__A1')  # <A1>
    def reduce(self, op: scala.Function2[_reduce__A1, _reduce__A1, _reduce__A1]) -> _reduce__A1: ...
    _reduceLeft__B = typing.TypeVar('_reduceLeft__B')  # <B>
    def reduceLeft(self, op: scala.Function2[_reduceLeft__B, _TreeSet__A, _reduceLeft__B]) -> _reduceLeft__B: ...
    _reduceLeftOption__B = typing.TypeVar('_reduceLeftOption__B')  # <B>
    def reduceLeftOption(self, op: scala.Function2[_reduceLeftOption__B, _TreeSet__A, _reduceLeftOption__B]) -> scala.Option[_reduceLeftOption__B]: ...
    _reduceOption__A1 = typing.TypeVar('_reduceOption__A1')  # <A1>
    def reduceOption(self, op: scala.Function2[_reduceOption__A1, _reduceOption__A1, _reduceOption__A1]) -> scala.Option[_reduceOption__A1]: ...
    _reduceRight__B = typing.TypeVar('_reduceRight__B')  # <B>
    def reduceRight(self, op: scala.Function2[_TreeSet__A, _reduceRight__B, _reduceRight__B]) -> _reduceRight__B: ...
    _reduceRightOption__B = typing.TypeVar('_reduceRightOption__B')  # <B>
    def reduceRightOption(self, op: scala.Function2[_TreeSet__A, _reduceRightOption__B, _reduceRightOption__B]) -> scala.Option[_reduceRightOption__B]: ...
    def repr(self) -> typing.Any: ...
    def reversed(self) -> List[_TreeSet__A]: ...
    _sameElements__B = typing.TypeVar('_sameElements__B')  # <B>
    def sameElements(self, that: scala.collection.GenIterable[_sameElements__B]) -> bool: ...
    _scan__B = typing.TypeVar('_scan__B')  # <B>
    _scan__That = typing.TypeVar('_scan__That')  # <That>
    def scan(self, z: _scan__B, op: scala.Function2[_scan__B, _scan__B, _scan__B], cbf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], _scan__B, _scan__That]) -> _scan__That: ...
    _scanLeft__B = typing.TypeVar('_scanLeft__B')  # <B>
    _scanLeft__That = typing.TypeVar('_scanLeft__That')  # <That>
    def scanLeft(self, z: _scanLeft__B, op: scala.Function2[_scanLeft__B, _TreeSet__A, _scanLeft__B], bf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], _scanLeft__B, _scanLeft__That]) -> _scanLeft__That: ...
    _scanRight__B = typing.TypeVar('_scanRight__B')  # <B>
    _scanRight__That = typing.TypeVar('_scanRight__That')  # <That>
    def scanRight(self, z: _scanRight__B, op: scala.Function2[_TreeSet__A, _scanRight__B, _scanRight__B], bf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], _scanRight__B, _scanRight__That]) -> _scanRight__That: ...
    def seq(self) -> Set[_TreeSet__A]: ...
    def size(self) -> int: ...
    def sizeHintIfCheap(self) -> int: ...
    def slice(self, from_: int, until: int) -> 'TreeSet'[_TreeSet__A]: ...
    def sliceWithKnownBound(self, from_: int, until: int) -> typing.Any: ...
    def sliceWithKnownDelta(self, from_: int, until: int, delta: int) -> typing.Any: ...
    @typing.overload
    def sliding(self, size: int) -> scala.collection.Iterator['TreeSet'[_TreeSet__A]]: ...
    @typing.overload
    def sliding(self, size: int, step: int) -> scala.collection.Iterator['TreeSet'[_TreeSet__A]]: ...
    def span(self, p: scala.Function1[_TreeSet__A, typing.Any]) -> scala.Tuple2['TreeSet'[_TreeSet__A], 'TreeSet'[_TreeSet__A]]: ...
    def splitAt(self, n: int) -> scala.Tuple2['TreeSet'[_TreeSet__A], 'TreeSet'[_TreeSet__A]]: ...
    def stringPrefix(self) -> java.lang.String: ...
    def subsetOf(self, that: scala.collection.GenSet[_TreeSet__A]) -> bool: ...
    @typing.overload
    def subsets(self) -> scala.collection.Iterator['TreeSet'[_TreeSet__A]]: ...
    @typing.overload
    def subsets(self, len: int) -> scala.collection.Iterator['TreeSet'[_TreeSet__A]]: ...
    _sum__B = typing.TypeVar('_sum__B')  # <B>
    def sum(self, num: scala.math.Numeric[_sum__B]) -> _sum__B: ...
    def tail(self) -> 'TreeSet'[_TreeSet__A]: ...
    def tails(self) -> scala.collection.Iterator['TreeSet'[_TreeSet__A]]: ...
    def take(self, n: int) -> 'TreeSet'[_TreeSet__A]: ...
    def takeRight(self, n: int) -> 'TreeSet'[_TreeSet__A]: ...
    def takeWhile(self, p: scala.Function1[_TreeSet__A, typing.Any]) -> 'TreeSet'[_TreeSet__A]: ...
    def thisCollection(self) -> scala.collection.Iterable[_TreeSet__A]: ...
    _to_0__Col = typing.TypeVar('_to_0__Col')  # <Col>
    @typing.overload
    def to(self, cbf: scala.collection.generic.CanBuildFrom[scala.runtime.Nothing., _TreeSet__A, _to_0__Col]) -> _to_0__Col: ...
    @typing.overload
    def to(self, to: _TreeSet__A) -> 'TreeSet'[_TreeSet__A]: ...
    _toArray__B = typing.TypeVar('_toArray__B')  # <B>
    def toArray(self, evidence$1: scala.reflect.ClassTag[_toArray__B]) -> typing.Any: ...
    _toBuffer__A1 = typing.TypeVar('_toBuffer__A1')  # <A1>
    def toBuffer(self) -> scala.collection.mutable.Buffer[_toBuffer__A1]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.Iterable: ...
    def toIndexedSeq(self) -> IndexedSeq[_TreeSet__A]: ...
    def toIterable(self) -> scala.collection.Iterable[_TreeSet__A]: ...
    def toIterator(self) -> scala.collection.Iterator[_TreeSet__A]: ...
    def toList(self) -> List[_TreeSet__A]: ...
    _toMap__T = typing.TypeVar('_toMap__T')  # <T>
    _toMap__U = typing.TypeVar('_toMap__U')  # <U>
    def toMap(self, ev: scala.Predef..less.colon.less[_TreeSet__A, scala.Tuple2[_toMap__T, _toMap__U]]) -> Map[_toMap__T, _toMap__U]: ...
    def toSeq(self) -> scala.collection.Seq[_TreeSet__A]: ...
    _toSet__B = typing.TypeVar('_toSet__B')  # <B>
    def toSet(self) -> Set[_toSet__B]: ...
    def toStream(self) -> Stream[_TreeSet__A]: ...
    def toString(self) -> java.lang.String: ...
    def toTraversable(self) -> scala.collection.Traversable[_TreeSet__A]: ...
    def toVector(self) -> 'Vector'[_TreeSet__A]: ...
    def transpose(self, asTraversable: scala.Function1) -> scala.collection.GenTraversable: ...
    def union(self, that: scala.collection.GenSet) -> scala.collection.Set: ...
    def until(self, until: _TreeSet__A) -> 'TreeSet'[_TreeSet__A]: ...
    _unzip__A1 = typing.TypeVar('_unzip__A1')  # <A1>
    _unzip__A2 = typing.TypeVar('_unzip__A2')  # <A2>
    def unzip(self, asPair: scala.Function1[_TreeSet__A, scala.Tuple2[_unzip__A1, _unzip__A2]]) -> scala.Tuple2[Set[_unzip__A1], Set[_unzip__A2]]: ...
    _unzip3__A1 = typing.TypeVar('_unzip3__A1')  # <A1>
    _unzip3__A2 = typing.TypeVar('_unzip3__A2')  # <A2>
    _unzip3__A3 = typing.TypeVar('_unzip3__A3')  # <A3>
    def unzip3(self, asTriple: scala.Function1[_TreeSet__A, scala.Tuple3[_unzip3__A1, _unzip3__A2, _unzip3__A3]]) -> scala.Tuple3[Set[_unzip3__A1], Set[_unzip3__A2], Set[_unzip3__A3]]: ...
    @typing.overload
    def view(self) -> scala.collection.IterableView[_TreeSet__A, 'TreeSet'[_TreeSet__A]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.IterableView[_TreeSet__A, 'TreeSet'[_TreeSet__A]]: ...
    def withFilter(self, p: scala.Function1[_TreeSet__A, typing.Any]) -> scala.collection.generic.FilterMonadic[_TreeSet__A, 'TreeSet'[_TreeSet__A]]: ...
    _zip__A1 = typing.TypeVar('_zip__A1')  # <A1>
    _zip__B = typing.TypeVar('_zip__B')  # <B>
    _zip__That = typing.TypeVar('_zip__That')  # <That>
    def zip(self, that: scala.collection.GenIterable[_zip__B], bf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], scala.Tuple2[_zip__A1, _zip__B], _zip__That]) -> _zip__That: ...
    _zipAll__B = typing.TypeVar('_zipAll__B')  # <B>
    _zipAll__A1 = typing.TypeVar('_zipAll__A1')  # <A1>
    _zipAll__That = typing.TypeVar('_zipAll__That')  # <That>
    def zipAll(self, that: scala.collection.GenIterable[_zipAll__B], thisElem: _zipAll__A1, thatElem: _zipAll__B, bf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], scala.Tuple2[_zipAll__A1, _zipAll__B], _zipAll__That]) -> _zipAll__That: ...
    _zipWithIndex__A1 = typing.TypeVar('_zipWithIndex__A1')  # <A1>
    _zipWithIndex__That = typing.TypeVar('_zipWithIndex__That')  # <That>
    def zipWithIndex(self, bf: scala.collection.generic.CanBuildFrom['TreeSet'[_TreeSet__A], scala.Tuple2[_zipWithIndex__A1, typing.Any], _zipWithIndex__That]) -> _zipWithIndex__That: ...

_TrieIterator__T = typing.TypeVar('_TrieIterator__T')  # <T>
class TrieIterator(scala.collection.AbstractIterator[_TrieIterator__T], typing.Generic[_TrieIterator__T]):
    scala$collection$immutable$TrieIterator$$depth: int = ...
    scala$collection$immutable$TrieIterator$$arrayStack: typing.List[typing.List[Iterable]] = ...
    scala$collection$immutable$TrieIterator$$posStack: typing.List[int] = ...
    scala$collection$immutable$TrieIterator$$arrayD: typing.List[Iterable] = ...
    scala$collection$immutable$TrieIterator$$posD: int = ...
    scala$collection$immutable$TrieIterator$$subIter: scala.collection.Iterator = ...
    def __init__(self, elems: typing.List[Iterable[_TrieIterator__T]]): ...
    def dupIterator(self) -> 'TrieIterator'[_TrieIterator__T]: ...
    def getElem(self, x: typing.Any) -> _TrieIterator__T: ...
    def hasNext(self) -> bool: ...
    def initArrayD(self) -> typing.List[Iterable[_TrieIterator__T]]: ...
    def initArrayStack(self) -> typing.List[typing.List[Iterable[_TrieIterator__T]]]: ...
    def initDepth(self) -> int: ...
    def initPosD(self) -> int: ...
    def initPosStack(self) -> typing.List[int]: ...
    def initSubIter(self) -> scala.collection.Iterator[_TrieIterator__T]: ...
    def next(self) -> _TrieIterator__T: ...
    def split(self) -> scala.Tuple2[scala.Tuple2[scala.collection.Iterator[_TrieIterator__T], typing.Any], scala.collection.Iterator[_TrieIterator__T]]: ...
    class DupIterator(scala.collection.immutable.TrieIterator[_TrieIterator__T]):
        def __init__(self, $outer: 'TrieIterator', xs: typing.List[Iterable[_TrieIterator__T]]): ...
        def getElem(self, x: typing.Any) -> _TrieIterator__T: ...
        def initArrayD(self) -> typing.List[Iterable[_TrieIterator__T]]: ...
        def initArrayStack(self) -> typing.List[typing.List[Iterable[_TrieIterator__T]]]: ...
        def initDepth(self) -> int: ...
        def initPosD(self) -> int: ...
        def initPosStack(self) -> typing.List[int]: ...
        def initSubIter(self) -> scala.collection.Iterator[_TrieIterator__T]: ...

_Vector__A = typing.TypeVar('_Vector__A')  # <A>
class Vector(scala.collection.AbstractSeq[_Vector__A], IndexedSeq[_Vector__A], VectorPointer[_Vector__A], scala.Serializable, scala.collection.CustomParallelizable[_Vector__A, scala.collection.parallel.immutable.ParVector[_Vector__A]], typing.Generic[_Vector__A]):
    serialVersionUID: typing.ClassVar[int] = ...
    def __init__(self, startIndex: int, endIndex: int, focus: int): ...
    _$colon$plus__B = typing.TypeVar('_$colon$plus__B')  # <B>
    _$colon$plus__That = typing.TypeVar('_$colon$plus__That')  # <That>
    def $colon$plus(self, elem: _.colon.plus__B, bf: scala.collection.generic.CanBuildFrom['Vector'[_Vector__A], _.colon.plus__B, _.colon.plus__That]) -> _.colon.plus__That: ...
    _$plus$colon__B = typing.TypeVar('_$plus$colon__B')  # <B>
    _$plus$colon__That = typing.TypeVar('_$plus$colon__That')  # <That>
    def $plus$colon(self, elem: _.plus.colon__B, bf: scala.collection.generic.CanBuildFrom['Vector'[_Vector__A], _.plus.colon__B, _.plus.colon__That]) -> _.plus.colon__That: ...
    _$plus$plus__B = typing.TypeVar('_$plus$plus__B')  # <B>
    _$plus$plus__That = typing.TypeVar('_$plus$plus__That')  # <That>
    def $plus$plus(self, that: scala.collection.GenTraversableOnce[_.plus.plus__B], bf: scala.collection.generic.CanBuildFrom['Vector'[_Vector__A], _.plus.plus__B, _.plus.plus__That]) -> _.plus.plus__That: ...
    @staticmethod
    def ReusableCBF() -> scala.collection.generic.GenTraversableFactory.GenericCanBuildFrom[scala.runtime.Nothing.]: ...
    _appendBack__B = typing.TypeVar('_appendBack__B')  # <B>
    def appendBack(self, value: _appendBack__B) -> 'Vector'[_appendBack__B]: ...
    _appendFront__B = typing.TypeVar('_appendFront__B')  # <B>
    def appendFront(self, value: _appendFront__B) -> 'Vector'[_appendFront__B]: ...
    def apply(self, index: int) -> _Vector__A: ...
    _canBuildFrom__A = typing.TypeVar('_canBuildFrom__A')  # <A>
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['Vector'[typing.Any], _canBuildFrom__A, 'Vector'[_canBuildFrom__A]]: ...
    def companion(self) -> scala.collection.generic.GenericCompanion['Vector']: ...
    @staticmethod
    def concat(xss: scala.collection.Seq) -> scala.collection.GenTraversable: ...
    def copyOf(self, a: typing.List[typing.Any]) -> typing.List[typing.Any]: ...
    def copyRange(self, array: typing.List[typing.Any], oldLeft: int, newLeft: int) -> typing.List[typing.Any]: ...
    def depth(self) -> int: ...
    def depth_$eq(self, x$1: int) -> None: ...
    def dirty(self) -> bool: ...
    def dirty_$eq(self, x$1: bool) -> None: ...
    def display0(self) -> typing.List[typing.Any]: ...
    def display0_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display1(self) -> typing.List[typing.Any]: ...
    def display1_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display2(self) -> typing.List[typing.Any]: ...
    def display2_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display3(self) -> typing.List[typing.Any]: ...
    def display3_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display4(self) -> typing.List[typing.Any]: ...
    def display4_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def display5(self) -> typing.List[typing.Any]: ...
    def display5_$eq(self, x$1: typing.List[typing.Any]) -> None: ...
    def drop(self, n: int) -> 'Vector'[_Vector__A]: ...
    def dropRight(self, n: int) -> 'Vector'[_Vector__A]: ...
    _empty__A = typing.TypeVar('_empty__A')  # <A>
    @staticmethod
    def empty() -> 'Vector'[_empty__A]: ...
    def endIndex(self) -> int: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, n5: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, n4: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, n3: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n1: int, n2: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def fill(n: int, elem: scala.Function0) -> scala.collection.GenTraversable: ...
    def getElem(self, index: int, xor: int) -> _Vector__A: ...
    def gotoFreshPosWritable0(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    def gotoFreshPosWritable1(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    def gotoNextBlockStart(self, index: int, xor: int) -> None: ...
    def gotoNextBlockStartWritable(self, index: int, xor: int) -> None: ...
    def gotoPos(self, index: int, xor: int) -> None: ...
    def gotoPosWritable0(self, newIndex: int, xor: int) -> None: ...
    def gotoPosWritable1(self, oldIndex: int, newIndex: int, xor: int) -> None: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[_Vector__A, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[_Vector__A]]: ...
    def hashCode(self) -> int: ...
    def head(self) -> _Vector__A: ...
    def init(self) -> 'Vector'[_Vector__A]: ...
    _initFrom_0__U = typing.TypeVar('_initFrom_0__U')  # <U>
    _initFrom_1__U = typing.TypeVar('_initFrom_1__U')  # <U>
    @typing.overload
    def initFrom(self, that: VectorPointer[_initFrom_0__U]) -> None: ...
    @typing.overload
    def initFrom(self, that: VectorPointer[_initFrom_1__U], depth: int) -> None: ...
    _initIterator__B = typing.TypeVar('_initIterator__B')  # <B>
    def initIterator(self, s: VectorIterator[_initIterator__B]) -> None: ...
    def isDefinedAt(self, idx: int) -> bool: ...
    @staticmethod
    def iterate(start: typing.Any, len: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def iterator(self) -> VectorIterator[_Vector__A]: ...
    def last(self) -> _Vector__A: ...
    def length(self) -> int: ...
    def lengthCompare(self, len: int) -> int: ...
    def nullSlotAndCopy(self, array: typing.List[typing.Any], index: int) -> typing.List[typing.Any]: ...
    def par(self) -> scala.collection.parallel.immutable.ParVector[_Vector__A]: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[_Vector__A, scala.collection.parallel.immutable.ParVector[_Vector__A]]: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, step: typing.Any, evidence$2: scala.math.Integral) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def range(start: typing.Any, end: typing.Any, evidence$1: scala.math.Integral) -> scala.collection.GenTraversable: ...
    def reverseIterator(self) -> scala.collection.Iterator[_Vector__A]: ...
    def seq(self) -> IndexedSeq[_Vector__A]: ...
    def sizeHintIfCheap(self) -> int: ...
    def slice(self, from_: int, until: int) -> 'Vector'[_Vector__A]: ...
    def splitAt(self, n: int) -> scala.Tuple2['Vector'[_Vector__A], 'Vector'[_Vector__A]]: ...
    def stabilize(self, index: int) -> None: ...
    def startIndex(self) -> int: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, n5: int, f: scala.Function5) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, n4: int, f: scala.Function4) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, n3: int, f: scala.Function3) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n1: int, n2: int, f: scala.Function2) -> scala.collection.GenTraversable: ...
    @typing.overload
    @staticmethod
    def tabulate(n: int, f: scala.Function1) -> scala.collection.GenTraversable: ...
    def tail(self) -> 'Vector'[_Vector__A]: ...
    def take(self, n: int) -> 'Vector'[_Vector__A]: ...
    def takeRight(self, n: int) -> 'Vector'[_Vector__A]: ...
    def thisCollection(self) -> scala.collection.IndexedSeq[_Vector__A]: ...
    _toBuffer__A1 = typing.TypeVar('_toBuffer__A1')  # <A1>
    def toBuffer(self) -> scala.collection.mutable.Buffer[_toBuffer__A1]: ...
    def toCollection(self, repr: typing.Any) -> scala.collection.IndexedSeq: ...
    def toIndexedSeq(self) -> IndexedSeq[_Vector__A]: ...
    def toIterable(self) -> scala.collection.Iterable[_Vector__A]: ...
    def toSeq(self) -> Seq[_Vector__A]: ...
    def toTraversable(self) -> scala.collection.Traversable[_Vector__A]: ...
    def toVector(self) -> 'Vector'[_Vector__A]: ...
    @staticmethod
    def unapplySeq(x: scala.collection.Seq) -> scala.Some: ...
    _updateAt__B = typing.TypeVar('_updateAt__B')  # <B>
    def updateAt(self, index: int, elem: _updateAt__B) -> 'Vector'[_updateAt__B]: ...
    _updated__B = typing.TypeVar('_updated__B')  # <B>
    _updated__That = typing.TypeVar('_updated__That')  # <That>
    def updated(self, index: int, elem: _updated__B, bf: scala.collection.generic.CanBuildFrom['Vector'[_Vector__A], _updated__B, _updated__That]) -> _updated__That: ...
    @typing.overload
    def view(self) -> scala.collection.SeqView[_Vector__A, scala.collection.Seq[_Vector__A]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.SeqView[_Vector__A, scala.collection.Seq[_Vector__A]]: ...

class WrappedString(scala.collection.AbstractSeq[typing.Any], IndexedSeq[typing.Any], StringLike['WrappedString']):
    def __init__(self, self): ...
    def $greater(self, that: typing.Any) -> bool: ...
    def $greater$eq(self, that: typing.Any) -> bool: ...
    def $less(self, that: typing.Any) -> bool: ...
    def $less$eq(self, that: typing.Any) -> bool: ...
    def $times(self, n: int) -> java.lang.String: ...
    def apply(self, n: int) -> str: ...
    @staticmethod
    def canBuildFrom() -> scala.collection.generic.CanBuildFrom['WrappedString', typing.Any, 'WrappedString']: ...
    def capitalize(self) -> java.lang.String: ...
    def companion(self) -> scala.collection.generic.GenericCompanion[IndexedSeq]: ...
    def compare(self, other: typing.Union[java.lang.String, str]) -> int: ...
    def compareTo(self, that: typing.Any) -> int: ...
    _copyToArray_0__B = typing.TypeVar('_copyToArray_0__B')  # <B>
    _copyToArray_1__B = typing.TypeVar('_copyToArray_1__B')  # <B>
    _copyToArray_2__B = typing.TypeVar('_copyToArray_2__B')  # <B>
    @typing.overload
    def copyToArray(self, xs: typing.Any) -> None: ...
    @typing.overload
    def copyToArray(self, xs: typing.Any, start: int) -> None: ...
    @typing.overload
    def copyToArray(self, xs: typing.Any, start: int, len: int) -> None: ...
    def drop(self, n: int) -> typing.Any: ...
    def dropRight(self, n: int) -> typing.Any: ...
    def dropWhile(self, p: scala.Function1) -> typing.Any: ...
    _endsWith__B = typing.TypeVar('_endsWith__B')  # <B>
    def endsWith(self, that: scala.collection.GenSeq[_endsWith__B]) -> bool: ...
    def exists(self, p: scala.Function1[typing.Any, typing.Any]) -> bool: ...
    def find(self, p: scala.Function1[typing.Any, typing.Any]) -> scala.Option[typing.Any]: ...
    _foldLeft__B = typing.TypeVar('_foldLeft__B')  # <B>
    def foldLeft(self, z: _foldLeft__B, op: scala.Function2[_foldLeft__B, typing.Any, _foldLeft__B]) -> _foldLeft__B: ...
    _foldRight__B = typing.TypeVar('_foldRight__B')  # <B>
    def foldRight(self, z: _foldRight__B, op: scala.Function2[typing.Any, _foldRight__B, _foldRight__B]) -> _foldRight__B: ...
    def forall(self, p: scala.Function1[typing.Any, typing.Any]) -> bool: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[typing.Any, _foreach__U]) -> None: ...
    def format(self, args: scala.collection.Seq[typing.Any]) -> java.lang.String: ...
    def formatLocal(self, l: java.util.Locale, args: scala.collection.Seq[typing.Any]) -> java.lang.String: ...
    _groupBy__K = typing.TypeVar('_groupBy__K')  # <K>
    def groupBy(self, f: scala.Function1[typing.Any, _groupBy__K]) -> Map[_groupBy__K, scala.collection.Traversable[typing.Any]]: ...
    def hashCode(self) -> int: ...
    def head(self) -> typing.Any: ...
    @typing.overload
    def indexWhere(self, p: scala.Function1[typing.Any, typing.Any]) -> int: ...
    @typing.overload
    def indexWhere(self, p: scala.Function1[typing.Any, typing.Any], from_: int) -> int: ...
    def init(self) -> typing.Any: ...
    def isDefinedAt(self, idx: int) -> bool: ...
    def isEmpty(self) -> bool: ...
    def iterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def last(self) -> typing.Any: ...
    @typing.overload
    def lastIndexWhere(self, p: scala.Function1[typing.Any, typing.Any]) -> int: ...
    @typing.overload
    def lastIndexWhere(self, p: scala.Function1[typing.Any, typing.Any], end: int) -> int: ...
    def length(self) -> int: ...
    def lengthCompare(self, len: int) -> int: ...
    def lines(self) -> scala.collection.Iterator[java.lang.String]: ...
    def linesIterator(self) -> scala.collection.Iterator[java.lang.String]: ...
    def linesWithSeparators(self) -> scala.collection.Iterator[java.lang.String]: ...
    @typing.overload
    def mkString(self, sep: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def mkString(self, start: typing.Union[java.lang.String, str], sep: typing.Union[java.lang.String, str], end: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    @typing.overload
    def mkString(self) -> java.lang.String: ...
    def newBuilder(self) -> scala.collection.mutable.Builder[typing.Any, 'WrappedString']: ...
    def parCombiner(self) -> scala.collection.parallel.Combiner[typing.Any, scala.collection.parallel.immutable.ParSeq[typing.Any]]: ...
    @typing.overload
    def r(self) -> scala.util.matching.Regex: ...
    @typing.overload
    def r(self, groupNames: scala.collection.Seq[typing.Union[java.lang.String, str]]) -> scala.util.matching.Regex: ...
    _reduceLeft__B = typing.TypeVar('_reduceLeft__B')  # <B>
    def reduceLeft(self, op: scala.Function2[_reduceLeft__B, typing.Any, _reduceLeft__B]) -> _reduceLeft__B: ...
    _reduceRight__B = typing.TypeVar('_reduceRight__B')  # <B>
    def reduceRight(self, op: scala.Function2[typing.Any, _reduceRight__B, _reduceRight__B]) -> _reduceRight__B: ...
    def replaceAllLiterally(self, literal: typing.Union[java.lang.String, str], replacement: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def reverse(self) -> typing.Any: ...
    def reverseIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    _sameElements__B = typing.TypeVar('_sameElements__B')  # <B>
    def sameElements(self, that: scala.collection.GenIterable[_sameElements__B]) -> bool: ...
    def segmentLength(self, p: scala.Function1[typing.Any, typing.Any], from_: int) -> int: ...
    def self(self) -> java.lang.String: ...
    def seq(self) -> IndexedSeq[typing.Any]: ...
    def sizeHintIfCheap(self) -> int: ...
    def slice(self, from_: int, until: int) -> 'WrappedString': ...
    def span(self, p: scala.Function1[typing.Any, typing.Any]) -> scala.Tuple2['WrappedString', 'WrappedString']: ...
    @typing.overload
    def split(self, separator: str) -> typing.List[java.lang.String]: ...
    @typing.overload
    def split(self, separators: typing.List[str]) -> typing.List[java.lang.String]: ...
    def splitAt(self, n: int) -> scala.Tuple2['WrappedString', 'WrappedString']: ...
    _startsWith_0__B = typing.TypeVar('_startsWith_0__B')  # <B>
    _startsWith_1__B = typing.TypeVar('_startsWith_1__B')  # <B>
    @typing.overload
    def startsWith(self, that: scala.collection.GenSeq[_startsWith_0__B]) -> bool: ...
    @typing.overload
    def startsWith(self, that: scala.collection.GenSeq[_startsWith_1__B], offset: int) -> bool: ...
    def stripLineEnd(self) -> java.lang.String: ...
    @typing.overload
    def stripMargin(self) -> java.lang.String: ...
    @typing.overload
    def stripMargin(self, marginChar: str) -> java.lang.String: ...
    def stripPrefix(self, prefix: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def stripSuffix(self, suffix: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    def tail(self) -> typing.Any: ...
    def take(self, n: int) -> typing.Any: ...
    def takeRight(self, n: int) -> typing.Any: ...
    def takeWhile(self, p: scala.Function1) -> typing.Any: ...
    def thisCollection(self) -> 'WrappedString': ...
    _toArray__B = typing.TypeVar('_toArray__B')  # <B>
    def toArray(self, evidence$1: scala.reflect.ClassTag[_toArray__B]) -> typing.Any: ...
    def toBoolean(self) -> bool: ...
    _toBuffer__A1 = typing.TypeVar('_toBuffer__A1')  # <A1>
    def toBuffer(self) -> scala.collection.mutable.Buffer[_toBuffer__A1]: ...
    def toByte(self) -> int: ...
    def toCollection(self, repr: 'WrappedString') -> 'WrappedString': ...
    def toDouble(self) -> float: ...
    def toFloat(self) -> float: ...
    def toIndexedSeq(self) -> IndexedSeq[typing.Any]: ...
    def toInt(self) -> int: ...
    def toIterable(self) -> scala.collection.Iterable[typing.Any]: ...
    def toList(self) -> List[typing.Any]: ...
    def toLong(self) -> int: ...
    def toSeq(self) -> Seq[typing.Any]: ...
    def toShort(self) -> int: ...
    def toString(self) -> java.lang.String: ...
    def toTraversable(self) -> scala.collection.Traversable[typing.Any]: ...
    @typing.overload
    def view(self) -> scala.collection.SeqView[typing.Any, scala.collection.Seq[typing.Any]]: ...
    @typing.overload
    def view(self, from_: int, until: int) -> scala.collection.SeqView[typing.Any, scala.collection.Seq[typing.Any]]: ...
    _zip__A1 = typing.TypeVar('_zip__A1')  # <A1>
    _zip__B = typing.TypeVar('_zip__B')  # <B>
    _zip__That = typing.TypeVar('_zip__That')  # <That>
    def zip(self, that: scala.collection.GenIterable[_zip__B], bf: scala.collection.generic.CanBuildFrom['WrappedString', scala.Tuple2[_zip__A1, _zip__B], _zip__That]) -> _zip__That: ...
    _zipWithIndex__A1 = typing.TypeVar('_zipWithIndex__A1')  # <A1>
    _zipWithIndex__That = typing.TypeVar('_zipWithIndex__That')  # <That>
    def zipWithIndex(self, bf: scala.collection.generic.CanBuildFrom['WrappedString', scala.Tuple2[_zipWithIndex__A1, typing.Any], _zipWithIndex__That]) -> _zipWithIndex__That: ...

class StreamViewLike: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("scala.collection.immutable")``.

    AbstractMap: typing.Type[AbstractMap]
    BitSet: typing.Type[BitSet]
    DefaultMap: typing.Type[DefaultMap]
    HashMap: typing.Type[HashMap]
    HashSet: typing.Type[HashSet]
    IndexedSeq: typing.Type[IndexedSeq]
    IntMap: typing.Type[IntMap]
    IntMapEntryIterator: typing.Type[IntMapEntryIterator]
    IntMapIterator: typing.Type[IntMapIterator]
    IntMapKeyIterator: typing.Type[IntMapKeyIterator]
    IntMapUtils: typing.Type[IntMapUtils]
    IntMapValueIterator: typing.Type[IntMapValueIterator]
    Iterable: typing.Type[Iterable]
    LinearSeq: typing.Type[LinearSeq]
    List: typing.Type[List]
    ListMap: typing.Type[ListMap]
    ListSerializeEnd: typing.Type[ListSerializeEnd]
    ListSet: typing.Type[ListSet]
    LongMap: typing.Type[LongMap]
    LongMapEntryIterator: typing.Type[LongMapEntryIterator]
    LongMapIterator: typing.Type[LongMapIterator]
    LongMapKeyIterator: typing.Type[LongMapKeyIterator]
    LongMapUtils: typing.Type[LongMapUtils]
    LongMapValueIterator: typing.Type[LongMapValueIterator]
    Map: typing.Type[Map]
    MapLike: typing.Type[MapLike]
    MapProxy: typing.Type[MapProxy]
    Nil: typing.Type[Nil]
    NumericRange: typing.Type[NumericRange]
    Page: typing.Type[Page]
    PagedSeq: typing.Type[PagedSeq]
    Queue: typing.Type[Queue]
    Range: typing.Type[Range]
    RedBlackTree: typing.Type[RedBlackTree]
    Seq: typing.Type[Seq]
    Set: typing.Type[Set]
    SetProxy: typing.Type[SetProxy]
    SortedMap: typing.Type[SortedMap]
    SortedSet: typing.Type[SortedSet]
    Stack: typing.Type[Stack]
    Stream: typing.Type[Stream]
    StreamIterator: typing.Type[StreamIterator]
    StreamView: typing.Type[StreamView]
    StreamViewLike: typing.Type[StreamViewLike]
    StringLike: typing.Type[StringLike]
    StringOps: typing.Type[StringOps]
    Traversable: typing.Type[Traversable]
    TreeMap: typing.Type[TreeMap]
    TreeSet: typing.Type[TreeSet]
    TrieIterator: typing.Type[TrieIterator]
    Vector: typing.Type[Vector]
    VectorBuilder: typing.Type[VectorBuilder]
    VectorIterator: typing.Type[VectorIterator]
    VectorPointer: typing.Type[VectorPointer]
    WrappedString: typing.Type[WrappedString]
