import java.lang
import java.util.concurrent
import scala
import scala.collection
import scala.collection.generic
import scala.collection.immutable
import scala.concurrent.duration
import scala.concurrent.forkjoin
import scala.concurrent.impl
import scala.reflect
import scala.runtime
import scala.util
import typing



class Await:
    _ready__T = typing.TypeVar('_ready__T')  # <T>
    @staticmethod
    def ready(awaitable: 'Awaitable'[_ready__T], atMost: scala.concurrent.duration.Duration) -> 'Awaitable'[_ready__T]: ...
    _result__T = typing.TypeVar('_result__T')  # <T>
    @staticmethod
    def result(awaitable: 'Awaitable'[_result__T], atMost: scala.concurrent.duration.Duration) -> _result__T: ...

class AwaitPermission: ...

_Awaitable__T = typing.TypeVar('_Awaitable__T')  # <T>
class Awaitable(typing.Generic[_Awaitable__T]):
    def ready(self, atMost: scala.concurrent.duration.Duration, permit: 'CanAwait') -> 'Awaitable'[_Awaitable__T]: ...
    def result(self, atMost: scala.concurrent.duration.Duration, permit: 'CanAwait') -> _Awaitable__T: ...

class CanAwait: ...

_Channel__LinkedList__A = typing.TypeVar('_Channel__LinkedList__A')  # <A>
_Channel__A = typing.TypeVar('_Channel__A')  # <A>
class Channel(typing.Generic[_Channel__A]):
    def __init__(self): ...
    def read(self) -> _Channel__A: ...
    def write(self, x: _Channel__A) -> None: ...
    class LinkedList(typing.Generic[_Channel__LinkedList__A]):
        $outer: 'Channel' = ...
        def __init__(self, $outer: 'Channel'): ...
        def elem(self) -> typing.Any: ...
        def elem_$eq(self, x$1: typing.Any) -> None: ...
        def next(self) -> 'Channel.LinkedList'[typing.Any]: ...
        def next_$eq(self, x$1: 'Channel.LinkedList'[typing.Any]) -> None: ...

_DelayedLazyVal__T = typing.TypeVar('_DelayedLazyVal__T')  # <T>
class DelayedLazyVal(typing.Generic[_DelayedLazyVal__T]):
    scala$concurrent$DelayedLazyVal$$body: scala.Function0 = ...
    scala$concurrent$DelayedLazyVal$$_isDone: bool = ...
    def __init__(self, f: scala.Function0[_DelayedLazyVal__T], body: scala.Function0[scala.runtime.BoxedUnit], exec_: 'ExecutionContext'): ...
    def apply(self) -> _DelayedLazyVal__T: ...
    def isDone(self) -> bool: ...

class ExecutionContext:
    @staticmethod
    def $init$($this: 'ExecutionContext') -> None: ...
    @staticmethod
    def defaultReporter() -> scala.Function1[java.lang.Throwable, scala.runtime.BoxedUnit]: ...
    def execute(self, runnable: typing.Union[java.lang.Runnable, typing.Callable]) -> None: ...
    @typing.overload
    @staticmethod
    def fromExecutor(e: java.util.concurrent.Executor) -> 'ExecutionContextExecutor': ...
    @typing.overload
    @staticmethod
    def fromExecutor(e: java.util.concurrent.Executor, reporter: scala.Function1[java.lang.Throwable, scala.runtime.BoxedUnit]) -> 'ExecutionContextExecutor': ...
    @typing.overload
    @staticmethod
    def fromExecutorService(e: java.util.concurrent.ExecutorService) -> 'ExecutionContextExecutorService': ...
    @typing.overload
    @staticmethod
    def fromExecutorService(e: java.util.concurrent.ExecutorService, reporter: scala.Function1[java.lang.Throwable, scala.runtime.BoxedUnit]) -> 'ExecutionContextExecutorService': ...
    def prepare(self) -> 'ExecutionContext': ...
    def reportFailure(self, cause: java.lang.Throwable) -> None: ...
    class Implicits$:
        MODULE$: typing.ClassVar['ExecutionContext.Implicits.'] = ...
        def __init__(self): ...

class JavaConversions:
    @typing.overload
    @staticmethod
    def asExecutionContext(exec_: java.util.concurrent.Executor) -> 'ExecutionContextExecutor': ...
    @typing.overload
    @staticmethod
    def asExecutionContext(exec_: java.util.concurrent.ExecutorService) -> 'ExecutionContextExecutorService': ...

class Lock:
    def __init__(self): ...
    def acquire(self) -> None: ...
    def available(self) -> bool: ...
    def available_$eq(self, x$1: bool) -> None: ...
    def release(self) -> None: ...

class OnCompleteRunnable: ...

_Promise__T = typing.TypeVar('_Promise__T')  # <T>
class Promise(typing.Generic[_Promise__T]):
    @staticmethod
    def $init$($this: 'Promise') -> None: ...
    _apply__T = typing.TypeVar('_apply__T')  # <T>
    @staticmethod
    def apply() -> 'Promise'[_apply__T]: ...
    def complete(self, result: scala.util.Try[_Promise__T]) -> 'Promise'[_Promise__T]: ...
    def completeWith(self, other: 'Future'[_Promise__T]) -> 'Promise'[_Promise__T]: ...
    _failed__T = typing.TypeVar('_failed__T')  # <T>
    @staticmethod
    def failed(exception: java.lang.Throwable) -> 'Promise'[_failed__T]: ...
    def failure(self, cause: java.lang.Throwable) -> 'Promise'[_Promise__T]: ...
    _fromTry__T = typing.TypeVar('_fromTry__T')  # <T>
    @staticmethod
    def fromTry(result: scala.util.Try[_fromTry__T]) -> 'Promise'[_fromTry__T]: ...
    def future(self) -> 'Future'[_Promise__T]: ...
    def isCompleted(self) -> bool: ...
    def success(self, value: _Promise__T) -> 'Promise'[_Promise__T]: ...
    _successful__T = typing.TypeVar('_successful__T')  # <T>
    @staticmethod
    def successful(result: _successful__T) -> 'Promise'[_successful__T]: ...
    def tryComplete(self, result: scala.util.Try[_Promise__T]) -> bool: ...
    def tryCompleteWith(self, other: 'Future'[_Promise__T]) -> 'Promise'[_Promise__T]: ...
    def tryFailure(self, cause: java.lang.Throwable) -> bool: ...
    def trySuccess(self, value: _Promise__T) -> bool: ...

_SyncChannel__A = typing.TypeVar('_SyncChannel__A')  # <A>
class SyncChannel(typing.Generic[_SyncChannel__A]):
    def __init__(self): ...
    def read(self) -> _SyncChannel__A: ...
    def write(self, data: _SyncChannel__A) -> None: ...

_SyncVar__A = typing.TypeVar('_SyncVar__A')  # <A>
class SyncVar(typing.Generic[_SyncVar__A]):
    def __init__(self): ...
    @typing.overload
    def get(self) -> _SyncVar__A: ...
    @typing.overload
    def get(self, timeout: int) -> scala.Option[_SyncVar__A]: ...
    def isSet(self) -> bool: ...
    def put(self, x: _SyncVar__A) -> None: ...
    def set(self, x: _SyncVar__A) -> None: ...
    @typing.overload
    def take(self) -> _SyncVar__A: ...
    @typing.overload
    def take(self, timeout: int) -> _SyncVar__A: ...
    def unset(self) -> None: ...

class package:
    _blocking__T = typing.TypeVar('_blocking__T')  # <T>
    @staticmethod
    def blocking(body: scala.Function0[_blocking__T]) -> _blocking__T: ...
    _future__T = typing.TypeVar('_future__T')  # <T>
    @staticmethod
    def future(body: scala.Function0[_future__T], executor: ExecutionContext) -> 'Future'[_future__T]: ...
    _promise__T = typing.TypeVar('_promise__T')  # <T>
    @staticmethod
    def promise() -> Promise[_promise__T]: ...

class ExecutionContextExecutor(ExecutionContext, java.util.concurrent.Executor): ...

class ExecutionContextExecutorService(ExecutionContextExecutor, java.util.concurrent.ExecutorService): ...

class BatchingExecutor(java.util.concurrent.Executor):
    @staticmethod
    def $init$($this: 'BatchingExecutor') -> None: ...
    def batchable(self, runnable: typing.Union[java.lang.Runnable, typing.Callable]) -> bool: ...
    def execute(self, runnable: typing.Union[java.lang.Runnable, typing.Callable]) -> None: ...
    def scala$concurrent$BatchingExecutor$$_tasksLocal(self) -> java.lang.ThreadLocal[scala.collection.immutable.List[java.lang.Runnable]]: ...
    def scala$concurrent$BatchingExecutor$_setter_$scala$concurrent$BatchingExecutor$$_tasksLocal_$eq(self, x$1: java.lang.ThreadLocal[scala.collection.immutable.List[typing.Union[java.lang.Runnable, typing.Callable]]]) -> None: ...
    def unbatchedExecute(self, r: typing.Union[java.lang.Runnable, typing.Callable]) -> None: ...
    class Batch(java.lang.Runnable, scala.concurrent.BlockContext):
        $outer: 'BatchingExecutor' = ...
        def __init__(self, $outer: 'BatchingExecutor', initial: scala.collection.immutable.List[typing.Union[java.lang.Runnable, typing.Callable]]): ...
        _blockOn__T = typing.TypeVar('_blockOn__T')  # <T>
        def blockOn(self, thunk: scala.Function0[_blockOn__T], permission: CanAwait) -> _blockOn__T: ...
        def initial(self) -> scala.collection.immutable.List[java.lang.Runnable]: ...
        def run(self) -> None: ...

class BlockContext:
    _blockOn__T = typing.TypeVar('_blockOn__T')  # <T>
    def blockOn(self, thunk: scala.Function0[_blockOn__T], permission: CanAwait) -> _blockOn__T: ...
    @staticmethod
    def current() -> 'BlockContext': ...
    @staticmethod
    def defaultBlockContext() -> 'BlockContext': ...
    _withBlockContext__T = typing.TypeVar('_withBlockContext__T')  # <T>
    @staticmethod
    def withBlockContext(blockContext: 'BlockContext', body: scala.Function0[_withBlockContext__T]) -> _withBlockContext__T: ...
    class DefaultBlockContext$(scala.concurrent.BlockContext):
        MODULE$: typing.ClassVar['BlockContext.DefaultBlockContext.'] = ...
        def __init__(self): ...
        _blockOn__T = typing.TypeVar('_blockOn__T')  # <T>
        def blockOn(self, thunk: scala.Function0[_blockOn__T], permission: CanAwait) -> _blockOn__T: ...

_Future__T = typing.TypeVar('_Future__T')  # <T>
class Future(Awaitable[_Future__T], typing.Generic[_Future__T]):
    @staticmethod
    def $init$($this: 'Future') -> None: ...
    _andThen__U = typing.TypeVar('_andThen__U')  # <U>
    def andThen(self, pf: scala.PartialFunction[scala.util.Try[_Future__T], _andThen__U], executor: ExecutionContext) -> 'Future'[_Future__T]: ...
    _apply__T = typing.TypeVar('_apply__T')  # <T>
    @staticmethod
    def apply(body: scala.Function0[_apply__T], executor: ExecutionContext) -> 'Future'[_apply__T]: ...
    _collect__S = typing.TypeVar('_collect__S')  # <S>
    def collect(self, pf: scala.PartialFunction[_Future__T, _collect__S], executor: ExecutionContext) -> 'Future'[_collect__S]: ...
    def failed(self) -> 'Future'[java.lang.Throwable]: ...
    _fallbackTo__U = typing.TypeVar('_fallbackTo__U')  # <U>
    def fallbackTo(self, that: 'Future'[_fallbackTo__U]) -> 'Future'[_fallbackTo__U]: ...
    def filter(self, p: scala.Function1[_Future__T, typing.Any], executor: ExecutionContext) -> 'Future'[_Future__T]: ...
    _find_0__T = typing.TypeVar('_find_0__T')  # <T>
    _find_1__T = typing.TypeVar('_find_1__T')  # <T>
    @typing.overload
    @staticmethod
    def find(futures: scala.collection.TraversableOnce['Future'[_find_0__T]], p: scala.Function1[_find_0__T, typing.Any], executor: ExecutionContext) -> 'Future'[scala.Option[_find_0__T]]: ...
    @typing.overload
    @staticmethod
    def find(futures: scala.collection.immutable.Iterable['Future'[_find_1__T]], p: scala.Function1[_find_1__T, typing.Any], executor: ExecutionContext) -> 'Future'[scala.Option[_find_1__T]]: ...
    _firstCompletedOf__T = typing.TypeVar('_firstCompletedOf__T')  # <T>
    @staticmethod
    def firstCompletedOf(futures: scala.collection.TraversableOnce['Future'[_firstCompletedOf__T]], executor: ExecutionContext) -> 'Future'[_firstCompletedOf__T]: ...
    _flatMap__S = typing.TypeVar('_flatMap__S')  # <S>
    def flatMap(self, f: scala.Function1[_Future__T, 'Future'[_flatMap__S]], executor: ExecutionContext) -> 'Future'[_flatMap__S]: ...
    _flatten__S = typing.TypeVar('_flatten__S')  # <S>
    def flatten(self, ev: scala.Predef..less.colon.less[_Future__T, 'Future'[_flatten__S]]) -> 'Future'[_flatten__S]: ...
    _fold__T = typing.TypeVar('_fold__T')  # <T>
    _fold__R = typing.TypeVar('_fold__R')  # <R>
    @staticmethod
    def fold(futures: scala.collection.TraversableOnce['Future'[_fold__T]], zero: _fold__R, op: scala.Function2[_fold__R, _fold__T, _fold__R], executor: ExecutionContext) -> 'Future'[_fold__R]: ...
    _foldLeft__T = typing.TypeVar('_foldLeft__T')  # <T>
    _foldLeft__R = typing.TypeVar('_foldLeft__R')  # <R>
    @staticmethod
    def foldLeft(futures: scala.collection.immutable.Iterable['Future'[_foldLeft__T]], zero: _foldLeft__R, op: scala.Function2[_foldLeft__R, _foldLeft__T, _foldLeft__R], executor: ExecutionContext) -> 'Future'[_foldLeft__R]: ...
    _foreach__U = typing.TypeVar('_foreach__U')  # <U>
    def foreach(self, f: scala.Function1[_Future__T, _foreach__U], executor: ExecutionContext) -> None: ...
    _fromTry__T = typing.TypeVar('_fromTry__T')  # <T>
    @staticmethod
    def fromTry(result: scala.util.Try[_fromTry__T]) -> 'Future'[_fromTry__T]: ...
    def isCompleted(self) -> bool: ...
    _map__S = typing.TypeVar('_map__S')  # <S>
    def map(self, f: scala.Function1[_Future__T, _map__S], executor: ExecutionContext) -> 'Future'[_map__S]: ...
    _mapTo__S = typing.TypeVar('_mapTo__S')  # <S>
    def mapTo(self, tag: scala.reflect.ClassTag[_mapTo__S]) -> 'Future'[_mapTo__S]: ...
    _onComplete__U = typing.TypeVar('_onComplete__U')  # <U>
    def onComplete(self, f: scala.Function1[scala.util.Try[_Future__T], _onComplete__U], executor: ExecutionContext) -> None: ...
    _onFailure__U = typing.TypeVar('_onFailure__U')  # <U>
    def onFailure(self, pf: scala.PartialFunction[java.lang.Throwable, _onFailure__U], executor: ExecutionContext) -> None: ...
    _onSuccess__U = typing.TypeVar('_onSuccess__U')  # <U>
    def onSuccess(self, pf: scala.PartialFunction[_Future__T, _onSuccess__U], executor: ExecutionContext) -> None: ...
    _recover__U = typing.TypeVar('_recover__U')  # <U>
    def recover(self, pf: scala.PartialFunction[java.lang.Throwable, _recover__U], executor: ExecutionContext) -> 'Future'[_recover__U]: ...
    _recoverWith__U = typing.TypeVar('_recoverWith__U')  # <U>
    def recoverWith(self, pf: scala.PartialFunction[java.lang.Throwable, 'Future'[_recoverWith__U]], executor: ExecutionContext) -> 'Future'[_recoverWith__U]: ...
    _reduce__T = typing.TypeVar('_reduce__T')  # <T>
    _reduce__R = typing.TypeVar('_reduce__R')  # <R>
    @staticmethod
    def reduce(futures: scala.collection.TraversableOnce['Future'[_reduce__T]], op: scala.Function2[_reduce__R, _reduce__T, _reduce__R], executor: ExecutionContext) -> 'Future'[_reduce__R]: ...
    _reduceLeft__T = typing.TypeVar('_reduceLeft__T')  # <T>
    _reduceLeft__R = typing.TypeVar('_reduceLeft__R')  # <R>
    @staticmethod
    def reduceLeft(futures: scala.collection.immutable.Iterable['Future'[_reduceLeft__T]], op: scala.Function2[_reduceLeft__R, _reduceLeft__T, _reduceLeft__R], executor: ExecutionContext) -> 'Future'[_reduceLeft__R]: ...
    _sequence__A = typing.TypeVar('_sequence__A')  # <A>
    _sequence__M = typing.TypeVar('_sequence__M', bound=scala.collection.TraversableOnce)  # <M>
    @staticmethod
    def sequence(in_: _sequence__M, cbf: scala.collection.generic.CanBuildFrom[_sequence__M, _sequence__A, _sequence__M], executor: ExecutionContext) -> 'Future'[_sequence__M]: ...
    _successful__T = typing.TypeVar('_successful__T')  # <T>
    @staticmethod
    def successful(result: _successful__T) -> 'Future'[_successful__T]: ...
    _transform_0__S = typing.TypeVar('_transform_0__S')  # <S>
    _transform_1__S = typing.TypeVar('_transform_1__S')  # <S>
    @typing.overload
    def transform(self, f: scala.Function1[scala.util.Try[_Future__T], scala.util.Try[_transform_0__S]], executor: ExecutionContext) -> 'Future'[_transform_0__S]: ...
    @typing.overload
    def transform(self, s: scala.Function1[_Future__T, _transform_1__S], f: scala.Function1[java.lang.Throwable, java.lang.Throwable], executor: ExecutionContext) -> 'Future'[_transform_1__S]: ...
    _transformWith__S = typing.TypeVar('_transformWith__S')  # <S>
    def transformWith(self, f: scala.Function1[scala.util.Try[_Future__T], 'Future'[_transformWith__S]], executor: ExecutionContext) -> 'Future'[_transformWith__S]: ...
    _traverse__A = typing.TypeVar('_traverse__A')  # <A>
    _traverse__B = typing.TypeVar('_traverse__B')  # <B>
    _traverse__M = typing.TypeVar('_traverse__M', bound=scala.collection.TraversableOnce)  # <M>
    @staticmethod
    def traverse(in_: _traverse__M, fn: scala.Function1[_traverse__A, 'Future'[_traverse__B]], cbf: scala.collection.generic.CanBuildFrom[_traverse__M, _traverse__B, _traverse__M], executor: ExecutionContext) -> 'Future'[_traverse__M]: ...
    @staticmethod
    def unit() -> 'Future'[scala.runtime.BoxedUnit]: ...
    def value(self) -> scala.Option[scala.util.Try[_Future__T]]: ...
    def withFilter(self, p: scala.Function1[_Future__T, typing.Any], executor: ExecutionContext) -> 'Future'[_Future__T]: ...
    _zip__U = typing.TypeVar('_zip__U')  # <U>
    def zip(self, that: 'Future'[_zip__U]) -> 'Future'[scala.Tuple2[_Future__T, _zip__U]]: ...
    _zipWith__U = typing.TypeVar('_zipWith__U')  # <U>
    _zipWith__R = typing.TypeVar('_zipWith__R')  # <R>
    def zipWith(self, that: 'Future'[_zipWith__U], f: scala.Function2[_Future__T, _zipWith__U, _zipWith__R], executor: ExecutionContext) -> 'Future'[_zipWith__R]: ...
    class InternalCallbackExecutor$(ExecutionContext, BatchingExecutor):
        MODULE$: typing.ClassVar['Future.InternalCallbackExecutor.'] = ...
        def __init__(self): ...
        def batchable(self, runnable: typing.Union[java.lang.Runnable, typing.Callable]) -> bool: ...
        def execute(self, runnable: typing.Union[java.lang.Runnable, typing.Callable]) -> None: ...
        def prepare(self) -> ExecutionContext: ...
        def reportFailure(self, t: java.lang.Throwable) -> None: ...
        def scala$concurrent$BatchingExecutor$$_tasksLocal(self) -> java.lang.ThreadLocal[scala.collection.immutable.List[java.lang.Runnable]]: ...
        def scala$concurrent$BatchingExecutor$_setter_$scala$concurrent$BatchingExecutor$$_tasksLocal_$eq(self, x$1: java.lang.ThreadLocal[scala.collection.immutable.List[typing.Union[java.lang.Runnable, typing.Callable]]]) -> None: ...
        def unbatchedExecute(self, r: typing.Union[java.lang.Runnable, typing.Callable]) -> None: ...
    class never$(scala.concurrent.Future[scala.runtime.Nothing.]):
        MODULE$: typing.ClassVar['Future.never.'] = ...
        def __init__(self): ...
        _andThen__U = typing.TypeVar('_andThen__U')  # <U>
        def andThen(self, pf: scala.PartialFunction[scala.util.Try[scala.runtime.Nothing.], _andThen__U], executor: ExecutionContext) -> 'Future'[scala.runtime.Nothing.]: ...
        _collect__S = typing.TypeVar('_collect__S')  # <S>
        def collect(self, pf: scala.PartialFunction[scala.runtime.Nothing., _collect__S], executor: ExecutionContext) -> 'Future'[_collect__S]: ...
        def failed(self) -> 'Future'[java.lang.Throwable]: ...
        _fallbackTo__U = typing.TypeVar('_fallbackTo__U')  # <U>
        def fallbackTo(self, that: 'Future'[_fallbackTo__U]) -> 'Future'[_fallbackTo__U]: ...
        def filter(self, p: scala.Function1[scala.runtime.Nothing., typing.Any], executor: ExecutionContext) -> 'Future'[scala.runtime.Nothing.]: ...
        _flatMap__S = typing.TypeVar('_flatMap__S')  # <S>
        def flatMap(self, f: scala.Function1[scala.runtime.Nothing., 'Future'[_flatMap__S]], executor: ExecutionContext) -> 'Future'[_flatMap__S]: ...
        _flatten__S = typing.TypeVar('_flatten__S')  # <S>
        def flatten(self, ev: scala.Predef..less.colon.less[scala.runtime.Nothing., 'Future'[_flatten__S]]) -> 'Future'[_flatten__S]: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[scala.runtime.Nothing., _foreach__U], executor: ExecutionContext) -> None: ...
        def isCompleted(self) -> bool: ...
        _map__S = typing.TypeVar('_map__S')  # <S>
        def map(self, f: scala.Function1[scala.runtime.Nothing., _map__S], executor: ExecutionContext) -> 'Future'[_map__S]: ...
        _mapTo__S = typing.TypeVar('_mapTo__S')  # <S>
        def mapTo(self, tag: scala.reflect.ClassTag[_mapTo__S]) -> 'Future'[_mapTo__S]: ...
        _onComplete__U = typing.TypeVar('_onComplete__U')  # <U>
        def onComplete(self, f: scala.Function1[scala.util.Try[scala.runtime.Nothing.], _onComplete__U], executor: ExecutionContext) -> None: ...
        _onFailure__U = typing.TypeVar('_onFailure__U')  # <U>
        def onFailure(self, pf: scala.PartialFunction[java.lang.Throwable, _onFailure__U], executor: ExecutionContext) -> None: ...
        _onSuccess__U = typing.TypeVar('_onSuccess__U')  # <U>
        def onSuccess(self, pf: scala.PartialFunction[scala.runtime.Nothing., _onSuccess__U], executor: ExecutionContext) -> None: ...
        def ready(self, atMost: scala.concurrent.duration.Duration, permit: CanAwait) -> 'Future.never.': ...
        _recover__U = typing.TypeVar('_recover__U')  # <U>
        def recover(self, pf: scala.PartialFunction[java.lang.Throwable, _recover__U], executor: ExecutionContext) -> 'Future'[_recover__U]: ...
        _recoverWith__U = typing.TypeVar('_recoverWith__U')  # <U>
        def recoverWith(self, pf: scala.PartialFunction[java.lang.Throwable, 'Future'[_recoverWith__U]], executor: ExecutionContext) -> 'Future'[_recoverWith__U]: ...
        def result(self, atMost: scala.concurrent.duration.Duration, permit: CanAwait) -> scala.runtime.Nothing.: ...
        def toString(self) -> str: ...
        _transform_0__S = typing.TypeVar('_transform_0__S')  # <S>
        _transform_1__S = typing.TypeVar('_transform_1__S')  # <S>
        @typing.overload
        def transform(self, s: scala.Function1[scala.runtime.Nothing., _transform_0__S], f: scala.Function1[java.lang.Throwable, java.lang.Throwable], executor: ExecutionContext) -> 'Future'[_transform_0__S]: ...
        @typing.overload
        def transform(self, f: scala.Function1[scala.util.Try[scala.runtime.Nothing.], scala.util.Try[_transform_1__S]], executor: ExecutionContext) -> 'Future'[_transform_1__S]: ...
        _transformWith__S = typing.TypeVar('_transformWith__S')  # <S>
        def transformWith(self, f: scala.Function1[scala.util.Try[scala.runtime.Nothing.], 'Future'[_transformWith__S]], executor: ExecutionContext) -> 'Future'[_transformWith__S]: ...
        def value(self) -> scala.Option[scala.util.Try[scala.runtime.Nothing.]]: ...
        def withFilter(self, p: scala.Function1[scala.runtime.Nothing., typing.Any], executor: ExecutionContext) -> 'Future'[scala.runtime.Nothing.]: ...
        _zip__U = typing.TypeVar('_zip__U')  # <U>
        def zip(self, that: 'Future'[_zip__U]) -> 'Future'[scala.Tuple2[scala.runtime.Nothing., _zip__U]]: ...
        _zipWith__U = typing.TypeVar('_zipWith__U')  # <U>
        _zipWith__R = typing.TypeVar('_zipWith__R')  # <R>
        def zipWith(self, that: 'Future'[_zipWith__U], f: scala.Function2[scala.runtime.Nothing., _zipWith__U, _zipWith__R], executor: ExecutionContext) -> 'Future'[_zipWith__R]: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("scala.concurrent")``.

    Await: typing.Type[Await]
    AwaitPermission: typing.Type[AwaitPermission]
    Awaitable: typing.Type[Awaitable]
    BatchingExecutor: typing.Type[BatchingExecutor]
    BlockContext: typing.Type[BlockContext]
    CanAwait: typing.Type[CanAwait]
    Channel: typing.Type[Channel]
    DelayedLazyVal: typing.Type[DelayedLazyVal]
    ExecutionContext: typing.Type[ExecutionContext]
    ExecutionContextExecutor: typing.Type[ExecutionContextExecutor]
    ExecutionContextExecutorService: typing.Type[ExecutionContextExecutorService]
    Future: typing.Type[Future]
    JavaConversions: typing.Type[JavaConversions]
    Lock: typing.Type[Lock]
    OnCompleteRunnable: typing.Type[OnCompleteRunnable]
    Promise: typing.Type[Promise]
    SyncChannel: typing.Type[SyncChannel]
    SyncVar: typing.Type[SyncVar]
    package: typing.Type[package]
    duration: scala.concurrent.duration.__module_protocol__
    forkjoin: scala.concurrent.forkjoin.__module_protocol__
    impl: scala.concurrent.impl.__module_protocol__
