import java.lang
import java.util.concurrent
import java.util.concurrent.atomic
import java.util.concurrent.locks
import scala
import scala.concurrent
import scala.concurrent.duration
import scala.reflect
import scala.runtime
import scala.util
import typing



_CallbackRunnable__T = typing.TypeVar('_CallbackRunnable__T')  # <T>
class CallbackRunnable(java.lang.Runnable, scala.concurrent.OnCompleteRunnable, typing.Generic[_CallbackRunnable__T]):
    def __init__(self, executor: scala.concurrent.ExecutionContext, onComplete: scala.Function1[scala.util.Try[_CallbackRunnable__T], typing.Any]): ...
    def executeWithValue(self, v: scala.util.Try[_CallbackRunnable__T]) -> None: ...
    def executor(self) -> scala.concurrent.ExecutionContext: ...
    def onComplete(self) -> scala.Function1[scala.util.Try[_CallbackRunnable__T], typing.Any]: ...
    def run(self) -> None: ...
    def value(self) -> scala.util.Try[_CallbackRunnable__T]: ...
    def value_$eq(self, x$1: scala.util.Try[_CallbackRunnable__T]) -> None: ...

class ExecutionContextImpl(scala.concurrent.ExecutionContextExecutor):
    def __init__(self, executor: java.util.concurrent.Executor, reporter: scala.Function1[java.lang.Throwable, scala.runtime.BoxedUnit]): ...
    @staticmethod
    def createDefaultExecutorService(reporter: scala.Function1[java.lang.Throwable, scala.runtime.BoxedUnit]) -> java.util.concurrent.ExecutorService: ...
    def execute(self, runnable: typing.Union[java.lang.Runnable, typing.Callable]) -> None: ...
    def executor(self) -> java.util.concurrent.Executor: ...
    @staticmethod
    def fromExecutor(e: java.util.concurrent.Executor, reporter: scala.Function1[java.lang.Throwable, scala.runtime.BoxedUnit]) -> 'ExecutionContextImpl': ...
    @staticmethod
    def fromExecutor$default$2() -> scala.Function1[java.lang.Throwable, scala.runtime.BoxedUnit]: ...
    @staticmethod
    def fromExecutorService(es: java.util.concurrent.ExecutorService, reporter: scala.Function1[java.lang.Throwable, scala.runtime.BoxedUnit]) -> 'ExecutionContextImpl': ...
    @staticmethod
    def fromExecutorService$default$2() -> scala.Function1[java.lang.Throwable, scala.runtime.BoxedUnit]: ...
    def prepare(self) -> scala.concurrent.ExecutionContext: ...
    def reportFailure(self, t: java.lang.Throwable) -> None: ...
    def reporter(self) -> scala.Function1[java.lang.Throwable, scala.runtime.BoxedUnit]: ...
    class DefaultThreadFactory(java.util.concurrent.ThreadFactory, java.util.concurrent.ForkJoinPool.ForkJoinWorkerThreadFactory):
        def __init__(self, daemonic: bool, maxBlockers: int, prefix: str, uncaught: typing.Union[java.lang.Thread.UncaughtExceptionHandler, typing.Callable]): ...
        @typing.overload
        def newThread(self, runnable: typing.Union[java.lang.Runnable, typing.Callable]) -> java.lang.Thread: ...
        @typing.overload
        def newThread(self, fjp: java.util.concurrent.ForkJoinPool) -> java.util.concurrent.ForkJoinWorkerThread: ...
        def scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$freeBlocker(self) -> bool: ...
        def scala$concurrent$impl$ExecutionContextImpl$DefaultThreadFactory$$newBlocker(self) -> bool: ...
        _wire__T = typing.TypeVar('_wire__T', bound=java.lang.Thread)  # <T>
        def wire(self, thread: _wire__T) -> _wire__T: ...

_Promise__CompletionLatch__T = typing.TypeVar('_Promise__CompletionLatch__T')  # <T>
_Promise__DefaultPromise__T = typing.TypeVar('_Promise__DefaultPromise__T')  # <T>
_Promise__KeptPromise__Failed__T = typing.TypeVar('_Promise__KeptPromise__Failed__T')  # <T>
_Promise__KeptPromise__Kept__T = typing.TypeVar('_Promise__KeptPromise__Kept__T')  # <T>
_Promise__KeptPromise__Successful__T = typing.TypeVar('_Promise__KeptPromise__Successful__T')  # <T>
_Promise__T = typing.TypeVar('_Promise__T')  # <T>
class Promise(scala.concurrent.Promise[_Promise__T], scala.concurrent.Future[_Promise__T], typing.Generic[_Promise__T]):
    @staticmethod
    def $init$($this: 'Promise') -> None: ...
    @typing.overload
    def future(self) -> scala.concurrent.Future[_Promise__T]: ...
    @typing.overload
    def future(self) -> 'Promise'[_Promise__T]: ...
    def toString(self) -> str: ...
    _transform_0__S = typing.TypeVar('_transform_0__S')  # <S>
    _transform_1__S = typing.TypeVar('_transform_1__S')  # <S>
    @typing.overload
    def transform(self, s: scala.Function1[_Promise__T, _transform_0__S], f: scala.Function1[java.lang.Throwable, java.lang.Throwable], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transform_0__S]: ...
    @typing.overload
    def transform(self, f: scala.Function1[scala.util.Try[_Promise__T], scala.util.Try[_transform_1__S]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transform_1__S]: ...
    _transformWith__S = typing.TypeVar('_transformWith__S')  # <S>
    def transformWith(self, f: scala.Function1[scala.util.Try[_Promise__T], scala.concurrent.Future[_transformWith__S]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transformWith__S]: ...
    class CompletionLatch(java.util.concurrent.locks.AbstractQueuedSynchronizer, scala.Function1[scala.util.Try[_Promise__CompletionLatch__T], scala.runtime.BoxedUnit], typing.Generic[_Promise__CompletionLatch__T]):
        def __init__(self): ...
        _andThen__A = typing.TypeVar('_andThen__A')  # <A>
        def andThen(self, g: scala.Function1[scala.runtime.BoxedUnit, _andThen__A]) -> scala.Function1[scala.util.Try[_Promise__CompletionLatch__T], _andThen__A]: ...
        def apply(self, ignored: scala.util.Try[_Promise__CompletionLatch__T]) -> None: ...
        def apply$mcDD$sp(self, v1: float) -> float: ...
        def apply$mcDF$sp(self, v1: float) -> float: ...
        def apply$mcDI$sp(self, v1: int) -> float: ...
        def apply$mcDJ$sp(self, v1: int) -> float: ...
        def apply$mcFD$sp(self, v1: float) -> float: ...
        def apply$mcFF$sp(self, v1: float) -> float: ...
        def apply$mcFI$sp(self, v1: int) -> float: ...
        def apply$mcFJ$sp(self, v1: int) -> float: ...
        def apply$mcID$sp(self, v1: float) -> int: ...
        def apply$mcIF$sp(self, v1: float) -> int: ...
        def apply$mcII$sp(self, v1: int) -> int: ...
        def apply$mcIJ$sp(self, v1: int) -> int: ...
        def apply$mcJD$sp(self, v1: float) -> int: ...
        def apply$mcJF$sp(self, v1: float) -> int: ...
        def apply$mcJI$sp(self, v1: int) -> int: ...
        def apply$mcJJ$sp(self, v1: int) -> int: ...
        def apply$mcVD$sp(self, v1: float) -> None: ...
        def apply$mcVF$sp(self, v1: float) -> None: ...
        def apply$mcVI$sp(self, v1: int) -> None: ...
        def apply$mcVJ$sp(self, v1: int) -> None: ...
        def apply$mcZD$sp(self, v1: float) -> bool: ...
        def apply$mcZF$sp(self, v1: float) -> bool: ...
        def apply$mcZI$sp(self, v1: int) -> bool: ...
        def apply$mcZJ$sp(self, v1: int) -> bool: ...
        _compose__A = typing.TypeVar('_compose__A')  # <A>
        def compose(self, g: scala.Function1[_compose__A, scala.util.Try[_Promise__CompletionLatch__T]]) -> scala.Function1[_compose__A, scala.runtime.BoxedUnit]: ...
        def toString(self) -> str: ...
        def tryAcquireShared(self, ignored: int) -> int: ...
        def tryReleaseShared(self, ignore: int) -> bool: ...
    class DefaultPromise(java.util.concurrent.atomic.AtomicReference[typing.Any], scala.concurrent.impl.Promise[_Promise__DefaultPromise__T], typing.Generic[_Promise__DefaultPromise__T]):
        def __init__(self): ...
        _andThen__U = typing.TypeVar('_andThen__U')  # <U>
        def andThen(self, pf: scala.PartialFunction[scala.util.Try[_Promise__DefaultPromise__T], _andThen__U], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_Promise__DefaultPromise__T]: ...
        _collect__S = typing.TypeVar('_collect__S')  # <S>
        def collect(self, pf: scala.PartialFunction[_Promise__DefaultPromise__T, _collect__S], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_collect__S]: ...
        def complete(self, result: scala.util.Try[_Promise__DefaultPromise__T]) -> scala.concurrent.Promise[_Promise__DefaultPromise__T]: ...
        def completeWith(self, other: scala.concurrent.Future[_Promise__DefaultPromise__T]) -> scala.concurrent.Promise[_Promise__DefaultPromise__T]: ...
        def failed(self) -> scala.concurrent.Future[java.lang.Throwable]: ...
        def failure(self, cause: java.lang.Throwable) -> scala.concurrent.Promise[_Promise__DefaultPromise__T]: ...
        _fallbackTo__U = typing.TypeVar('_fallbackTo__U')  # <U>
        def fallbackTo(self, that: scala.concurrent.Future[_fallbackTo__U]) -> scala.concurrent.Future[_fallbackTo__U]: ...
        def filter(self, p: scala.Function1[_Promise__DefaultPromise__T, typing.Any], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_Promise__DefaultPromise__T]: ...
        _flatMap__S = typing.TypeVar('_flatMap__S')  # <S>
        def flatMap(self, f: scala.Function1[_Promise__DefaultPromise__T, scala.concurrent.Future[_flatMap__S]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_flatMap__S]: ...
        _flatten__S = typing.TypeVar('_flatten__S')  # <S>
        def flatten(self, ev: scala.Predef..less.colon.less[_Promise__DefaultPromise__T, scala.concurrent.Future[_flatten__S]]) -> scala.concurrent.Future[_flatten__S]: ...
        _foreach__U = typing.TypeVar('_foreach__U')  # <U>
        def foreach(self, f: scala.Function1[_Promise__DefaultPromise__T, _foreach__U], executor: scala.concurrent.ExecutionContext) -> None: ...
        def future(self) -> 'Promise'[_Promise__DefaultPromise__T]: ...
        def isCompleted(self) -> bool: ...
        def linkRootOf(self, target: 'Promise.DefaultPromise'[_Promise__DefaultPromise__T]) -> None: ...
        _map__S = typing.TypeVar('_map__S')  # <S>
        def map(self, f: scala.Function1[_Promise__DefaultPromise__T, _map__S], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_map__S]: ...
        _mapTo__S = typing.TypeVar('_mapTo__S')  # <S>
        def mapTo(self, tag: scala.reflect.ClassTag[_mapTo__S]) -> scala.concurrent.Future[_mapTo__S]: ...
        _onComplete__U = typing.TypeVar('_onComplete__U')  # <U>
        def onComplete(self, func: scala.Function1[scala.util.Try[_Promise__DefaultPromise__T], _onComplete__U], executor: scala.concurrent.ExecutionContext) -> None: ...
        _onFailure__U = typing.TypeVar('_onFailure__U')  # <U>
        def onFailure(self, pf: scala.PartialFunction[java.lang.Throwable, _onFailure__U], executor: scala.concurrent.ExecutionContext) -> None: ...
        _onSuccess__U = typing.TypeVar('_onSuccess__U')  # <U>
        def onSuccess(self, pf: scala.PartialFunction[_Promise__DefaultPromise__T, _onSuccess__U], executor: scala.concurrent.ExecutionContext) -> None: ...
        def ready(self, atMost: scala.concurrent.duration.Duration, permit: scala.concurrent.CanAwait) -> 'Promise.DefaultPromise'[_Promise__DefaultPromise__T]: ...
        _recover__U = typing.TypeVar('_recover__U')  # <U>
        def recover(self, pf: scala.PartialFunction[java.lang.Throwable, _recover__U], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_recover__U]: ...
        _recoverWith__U = typing.TypeVar('_recoverWith__U')  # <U>
        def recoverWith(self, pf: scala.PartialFunction[java.lang.Throwable, scala.concurrent.Future[_recoverWith__U]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_recoverWith__U]: ...
        def result(self, atMost: scala.concurrent.duration.Duration, permit: scala.concurrent.CanAwait) -> _Promise__DefaultPromise__T: ...
        def success(self, value: _Promise__DefaultPromise__T) -> scala.concurrent.Promise[_Promise__DefaultPromise__T]: ...
        def toString(self) -> str: ...
        _transform_0__S = typing.TypeVar('_transform_0__S')  # <S>
        _transform_1__S = typing.TypeVar('_transform_1__S')  # <S>
        @typing.overload
        def transform(self, s: scala.Function1[_Promise__DefaultPromise__T, _transform_0__S], f: scala.Function1[java.lang.Throwable, java.lang.Throwable], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transform_0__S]: ...
        @typing.overload
        def transform(self, f: scala.Function1[scala.util.Try[_Promise__DefaultPromise__T], scala.util.Try[_transform_1__S]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transform_1__S]: ...
        _transformWith__S = typing.TypeVar('_transformWith__S')  # <S>
        def transformWith(self, f: scala.Function1[scala.util.Try[_Promise__DefaultPromise__T], scala.concurrent.Future[_transformWith__S]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transformWith__S]: ...
        def tryAwait(self, atMost: scala.concurrent.duration.Duration) -> bool: ...
        def tryComplete(self, value: scala.util.Try[_Promise__DefaultPromise__T]) -> bool: ...
        def tryCompleteWith(self, other: scala.concurrent.Future[_Promise__DefaultPromise__T]) -> scala.concurrent.Promise[_Promise__DefaultPromise__T]: ...
        def tryFailure(self, cause: java.lang.Throwable) -> bool: ...
        def trySuccess(self, value: _Promise__DefaultPromise__T) -> bool: ...
        def value(self) -> scala.Option[scala.util.Try[_Promise__DefaultPromise__T]]: ...
        def withFilter(self, p: scala.Function1[_Promise__DefaultPromise__T, typing.Any], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_Promise__DefaultPromise__T]: ...
        _zip__U = typing.TypeVar('_zip__U')  # <U>
        def zip(self, that: scala.concurrent.Future[_zip__U]) -> scala.concurrent.Future[scala.Tuple2[_Promise__DefaultPromise__T, _zip__U]]: ...
        _zipWith__U = typing.TypeVar('_zipWith__U')  # <U>
        _zipWith__R = typing.TypeVar('_zipWith__R')  # <R>
        def zipWith(self, that: scala.concurrent.Future[_zipWith__U], f: scala.Function2[_Promise__DefaultPromise__T, _zipWith__U, _zipWith__R], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_zipWith__R]: ...
    class KeptPromise$:
        MODULE$: typing.ClassVar['Promise.KeptPromise.'] = ...
        def __init__(self): ...
        _apply__T = typing.TypeVar('_apply__T')  # <T>
        def apply(self, result: scala.util.Try[_apply__T]) -> scala.concurrent.Promise[_apply__T]: ...
        class Failed(scala.concurrent.impl.Promise.KeptPromise.Kept[_Promise__KeptPromise__Failed__T], typing.Generic[_Promise__KeptPromise__Failed__T]):
            def __init__(self, result: scala.util.Failure[_Promise__KeptPromise__Failed__T]): ...
            _andThen__U = typing.TypeVar('_andThen__U')  # <U>
            def andThen(self, pf: scala.PartialFunction[scala.util.Try[_Promise__KeptPromise__Failed__T], _andThen__U], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_Promise__KeptPromise__Failed__T]: ...
            _collect__S = typing.TypeVar('_collect__S')  # <S>
            def collect(self, pf: scala.PartialFunction[_Promise__KeptPromise__Failed__T, _collect__S], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_collect__S]: ...
            def complete(self, result: scala.util.Try[_Promise__KeptPromise__Failed__T]) -> scala.concurrent.Promise[_Promise__KeptPromise__Failed__T]: ...
            def completeWith(self, other: scala.concurrent.Future[_Promise__KeptPromise__Failed__T]) -> scala.concurrent.Promise[_Promise__KeptPromise__Failed__T]: ...
            def failed(self) -> scala.concurrent.Future[java.lang.Throwable]: ...
            def failure(self, cause: java.lang.Throwable) -> scala.concurrent.Promise[_Promise__KeptPromise__Failed__T]: ...
            _fallbackTo__U = typing.TypeVar('_fallbackTo__U')  # <U>
            def fallbackTo(self, that: scala.concurrent.Future[_fallbackTo__U]) -> scala.concurrent.Future[_fallbackTo__U]: ...
            def filter(self, p: scala.Function1[_Promise__KeptPromise__Failed__T, typing.Any], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_Promise__KeptPromise__Failed__T]: ...
            _flatMap__S = typing.TypeVar('_flatMap__S')  # <S>
            def flatMap(self, f: scala.Function1[_Promise__KeptPromise__Failed__T, scala.concurrent.Future[_flatMap__S]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_flatMap__S]: ...
            _flatten__S = typing.TypeVar('_flatten__S')  # <S>
            def flatten(self, ev: scala.Predef..less.colon.less[_Promise__KeptPromise__Failed__T, scala.concurrent.Future[_flatten__S]]) -> scala.concurrent.Future[_flatten__S]: ...
            _foreach__U = typing.TypeVar('_foreach__U')  # <U>
            def foreach(self, f: scala.Function1[_Promise__KeptPromise__Failed__T, _foreach__U], executor: scala.concurrent.ExecutionContext) -> None: ...
            def future(self) -> 'Promise'[_Promise__KeptPromise__Failed__T]: ...
            def isCompleted(self) -> bool: ...
            _map__S = typing.TypeVar('_map__S')  # <S>
            def map(self, f: scala.Function1[_Promise__KeptPromise__Failed__T, _map__S], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_map__S]: ...
            _mapTo__S = typing.TypeVar('_mapTo__S')  # <S>
            def mapTo(self, tag: scala.reflect.ClassTag[_mapTo__S]) -> scala.concurrent.Future[_mapTo__S]: ...
            _onComplete__U = typing.TypeVar('_onComplete__U')  # <U>
            def onComplete(self, func: scala.Function1[scala.util.Try[_Promise__KeptPromise__Failed__T], _onComplete__U], executor: scala.concurrent.ExecutionContext) -> None: ...
            _onFailure__U = typing.TypeVar('_onFailure__U')  # <U>
            def onFailure(self, pf: scala.PartialFunction[java.lang.Throwable, _onFailure__U], executor: scala.concurrent.ExecutionContext) -> None: ...
            _onSuccess__U = typing.TypeVar('_onSuccess__U')  # <U>
            def onSuccess(self, pf: scala.PartialFunction[_Promise__KeptPromise__Failed__T, _onSuccess__U], executor: scala.concurrent.ExecutionContext) -> None: ...
            def ready(self, atMost: scala.concurrent.duration.Duration, permit: scala.concurrent.CanAwait) -> 'Promise.KeptPromise.Kept'[_Promise__KeptPromise__Failed__T]: ...
            _recover__U = typing.TypeVar('_recover__U')  # <U>
            def recover(self, pf: scala.PartialFunction[java.lang.Throwable, _recover__U], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_recover__U]: ...
            _recoverWith__U = typing.TypeVar('_recoverWith__U')  # <U>
            def recoverWith(self, pf: scala.PartialFunction[java.lang.Throwable, scala.concurrent.Future[_recoverWith__U]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_recoverWith__U]: ...
            @typing.overload
            def result(self, atMost: scala.concurrent.duration.Duration, permit: scala.concurrent.CanAwait) -> _Promise__KeptPromise__Failed__T: ...
            @typing.overload
            def result(self) -> scala.util.Failure[_Promise__KeptPromise__Failed__T]: ...
            def success(self, value: _Promise__KeptPromise__Failed__T) -> scala.concurrent.Promise[_Promise__KeptPromise__Failed__T]: ...
            def toString(self) -> str: ...
            _transform_0__S = typing.TypeVar('_transform_0__S')  # <S>
            _transform_1__S = typing.TypeVar('_transform_1__S')  # <S>
            @typing.overload
            def transform(self, s: scala.Function1[_Promise__KeptPromise__Failed__T, _transform_0__S], f: scala.Function1[java.lang.Throwable, java.lang.Throwable], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transform_0__S]: ...
            @typing.overload
            def transform(self, f: scala.Function1[scala.util.Try[_Promise__KeptPromise__Failed__T], scala.util.Try[_transform_1__S]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transform_1__S]: ...
            _transformWith__S = typing.TypeVar('_transformWith__S')  # <S>
            def transformWith(self, f: scala.Function1[scala.util.Try[_Promise__KeptPromise__Failed__T], scala.concurrent.Future[_transformWith__S]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transformWith__S]: ...
            def tryComplete(self, value: scala.util.Try[_Promise__KeptPromise__Failed__T]) -> bool: ...
            def tryCompleteWith(self, other: scala.concurrent.Future[_Promise__KeptPromise__Failed__T]) -> scala.concurrent.Promise[_Promise__KeptPromise__Failed__T]: ...
            def tryFailure(self, cause: java.lang.Throwable) -> bool: ...
            def trySuccess(self, value: _Promise__KeptPromise__Failed__T) -> bool: ...
            def value(self) -> scala.Option[scala.util.Try[_Promise__KeptPromise__Failed__T]]: ...
            def withFilter(self, p: scala.Function1[_Promise__KeptPromise__Failed__T, typing.Any], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_Promise__KeptPromise__Failed__T]: ...
            _zip__U = typing.TypeVar('_zip__U')  # <U>
            def zip(self, that: scala.concurrent.Future[_zip__U]) -> scala.concurrent.Future[scala.Tuple2[_Promise__KeptPromise__Failed__T, _zip__U]]: ...
            _zipWith__U = typing.TypeVar('_zipWith__U')  # <U>
            _zipWith__R = typing.TypeVar('_zipWith__R')  # <R>
            def zipWith(self, that: scala.concurrent.Future[_zipWith__U], f: scala.Function2[_Promise__KeptPromise__Failed__T, _zipWith__U, _zipWith__R], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_zipWith__R]: ...
        class Kept(scala.concurrent.impl.Promise[_Promise__KeptPromise__Kept__T], typing.Generic[_Promise__KeptPromise__Kept__T]):
            @staticmethod
            def $init$($this: 'Promise.KeptPromise.Kept') -> None: ...
            def isCompleted(self) -> bool: ...
            _onComplete__U = typing.TypeVar('_onComplete__U')  # <U>
            def onComplete(self, func: scala.Function1[scala.util.Try[_Promise__KeptPromise__Kept__T], _onComplete__U], executor: scala.concurrent.ExecutionContext) -> None: ...
            @typing.overload
            def ready(self, atMost: scala.concurrent.duration.Duration, permit: scala.concurrent.CanAwait) -> scala.concurrent.Awaitable[_Promise__KeptPromise__Kept__T]: ...
            @typing.overload
            def ready(self, atMost: scala.concurrent.duration.Duration, permit: scala.concurrent.CanAwait) -> 'Promise.KeptPromise.Kept'[_Promise__KeptPromise__Kept__T]: ...
            @typing.overload
            def result(self) -> scala.util.Try[_Promise__KeptPromise__Kept__T]: ...
            @typing.overload
            def result(self, atMost: scala.concurrent.duration.Duration, permit: scala.concurrent.CanAwait) -> _Promise__KeptPromise__Kept__T: ...
            def toString(self) -> str: ...
            def tryComplete(self, value: scala.util.Try[_Promise__KeptPromise__Kept__T]) -> bool: ...
            def value(self) -> scala.Option[scala.util.Try[_Promise__KeptPromise__Kept__T]]: ...
        class Successful(scala.concurrent.impl.Promise.KeptPromise.Kept[_Promise__KeptPromise__Successful__T], typing.Generic[_Promise__KeptPromise__Successful__T]):
            def __init__(self, result: scala.util.Success[_Promise__KeptPromise__Successful__T]): ...
            _andThen__U = typing.TypeVar('_andThen__U')  # <U>
            def andThen(self, pf: scala.PartialFunction[scala.util.Try[_Promise__KeptPromise__Successful__T], _andThen__U], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_Promise__KeptPromise__Successful__T]: ...
            _collect__S = typing.TypeVar('_collect__S')  # <S>
            def collect(self, pf: scala.PartialFunction[_Promise__KeptPromise__Successful__T, _collect__S], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_collect__S]: ...
            def complete(self, result: scala.util.Try[_Promise__KeptPromise__Successful__T]) -> scala.concurrent.Promise[_Promise__KeptPromise__Successful__T]: ...
            def completeWith(self, other: scala.concurrent.Future[_Promise__KeptPromise__Successful__T]) -> scala.concurrent.Promise[_Promise__KeptPromise__Successful__T]: ...
            def failed(self) -> scala.concurrent.Future[java.lang.Throwable]: ...
            def failure(self, cause: java.lang.Throwable) -> scala.concurrent.Promise[_Promise__KeptPromise__Successful__T]: ...
            _fallbackTo__U = typing.TypeVar('_fallbackTo__U')  # <U>
            def fallbackTo(self, that: scala.concurrent.Future[_fallbackTo__U]) -> scala.concurrent.Future[_fallbackTo__U]: ...
            def filter(self, p: scala.Function1[_Promise__KeptPromise__Successful__T, typing.Any], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_Promise__KeptPromise__Successful__T]: ...
            _flatMap__S = typing.TypeVar('_flatMap__S')  # <S>
            def flatMap(self, f: scala.Function1[_Promise__KeptPromise__Successful__T, scala.concurrent.Future[_flatMap__S]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_flatMap__S]: ...
            _flatten__S = typing.TypeVar('_flatten__S')  # <S>
            def flatten(self, ev: scala.Predef..less.colon.less[_Promise__KeptPromise__Successful__T, scala.concurrent.Future[_flatten__S]]) -> scala.concurrent.Future[_flatten__S]: ...
            _foreach__U = typing.TypeVar('_foreach__U')  # <U>
            def foreach(self, f: scala.Function1[_Promise__KeptPromise__Successful__T, _foreach__U], executor: scala.concurrent.ExecutionContext) -> None: ...
            def future(self) -> 'Promise'[_Promise__KeptPromise__Successful__T]: ...
            def isCompleted(self) -> bool: ...
            _map__S = typing.TypeVar('_map__S')  # <S>
            def map(self, f: scala.Function1[_Promise__KeptPromise__Successful__T, _map__S], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_map__S]: ...
            _mapTo__S = typing.TypeVar('_mapTo__S')  # <S>
            def mapTo(self, tag: scala.reflect.ClassTag[_mapTo__S]) -> scala.concurrent.Future[_mapTo__S]: ...
            _onComplete__U = typing.TypeVar('_onComplete__U')  # <U>
            def onComplete(self, func: scala.Function1[scala.util.Try[_Promise__KeptPromise__Successful__T], _onComplete__U], executor: scala.concurrent.ExecutionContext) -> None: ...
            _onFailure__U = typing.TypeVar('_onFailure__U')  # <U>
            def onFailure(self, pf: scala.PartialFunction[java.lang.Throwable, _onFailure__U], executor: scala.concurrent.ExecutionContext) -> None: ...
            _onSuccess__U = typing.TypeVar('_onSuccess__U')  # <U>
            def onSuccess(self, pf: scala.PartialFunction[_Promise__KeptPromise__Successful__T, _onSuccess__U], executor: scala.concurrent.ExecutionContext) -> None: ...
            def ready(self, atMost: scala.concurrent.duration.Duration, permit: scala.concurrent.CanAwait) -> 'Promise.KeptPromise.Kept'[_Promise__KeptPromise__Successful__T]: ...
            _recover__U = typing.TypeVar('_recover__U')  # <U>
            def recover(self, pf: scala.PartialFunction[java.lang.Throwable, _recover__U], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_recover__U]: ...
            _recoverWith__U = typing.TypeVar('_recoverWith__U')  # <U>
            def recoverWith(self, pf: scala.PartialFunction[java.lang.Throwable, scala.concurrent.Future[_recoverWith__U]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_recoverWith__U]: ...
            @typing.overload
            def result(self, atMost: scala.concurrent.duration.Duration, permit: scala.concurrent.CanAwait) -> _Promise__KeptPromise__Successful__T: ...
            @typing.overload
            def result(self) -> scala.util.Success[_Promise__KeptPromise__Successful__T]: ...
            def success(self, value: _Promise__KeptPromise__Successful__T) -> scala.concurrent.Promise[_Promise__KeptPromise__Successful__T]: ...
            def toString(self) -> str: ...
            _transform_0__S = typing.TypeVar('_transform_0__S')  # <S>
            _transform_1__S = typing.TypeVar('_transform_1__S')  # <S>
            @typing.overload
            def transform(self, s: scala.Function1[_Promise__KeptPromise__Successful__T, _transform_0__S], f: scala.Function1[java.lang.Throwable, java.lang.Throwable], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transform_0__S]: ...
            @typing.overload
            def transform(self, f: scala.Function1[scala.util.Try[_Promise__KeptPromise__Successful__T], scala.util.Try[_transform_1__S]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transform_1__S]: ...
            _transformWith__S = typing.TypeVar('_transformWith__S')  # <S>
            def transformWith(self, f: scala.Function1[scala.util.Try[_Promise__KeptPromise__Successful__T], scala.concurrent.Future[_transformWith__S]], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_transformWith__S]: ...
            def tryComplete(self, value: scala.util.Try[_Promise__KeptPromise__Successful__T]) -> bool: ...
            def tryCompleteWith(self, other: scala.concurrent.Future[_Promise__KeptPromise__Successful__T]) -> scala.concurrent.Promise[_Promise__KeptPromise__Successful__T]: ...
            def tryFailure(self, cause: java.lang.Throwable) -> bool: ...
            def trySuccess(self, value: _Promise__KeptPromise__Successful__T) -> bool: ...
            def value(self) -> scala.Option[scala.util.Try[_Promise__KeptPromise__Successful__T]]: ...
            def withFilter(self, p: scala.Function1[_Promise__KeptPromise__Successful__T, typing.Any], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_Promise__KeptPromise__Successful__T]: ...
            _zip__U = typing.TypeVar('_zip__U')  # <U>
            def zip(self, that: scala.concurrent.Future[_zip__U]) -> scala.concurrent.Future[scala.Tuple2[_Promise__KeptPromise__Successful__T, _zip__U]]: ...
            _zipWith__U = typing.TypeVar('_zipWith__U')  # <U>
            _zipWith__R = typing.TypeVar('_zipWith__R')  # <R>
            def zipWith(self, that: scala.concurrent.Future[_zipWith__U], f: scala.Function2[_Promise__KeptPromise__Successful__T, _zipWith__U, _zipWith__R], executor: scala.concurrent.ExecutionContext) -> scala.concurrent.Future[_zipWith__R]: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("scala.concurrent.impl")``.

    CallbackRunnable: typing.Type[CallbackRunnable]
    ExecutionContextImpl: typing.Type[ExecutionContextImpl]
    Promise: typing.Type[Promise]
