import decimal
import java.lang
import java.math
import java.util
import scala
import scala.collection
import scala.collection.immutable
import scala.runtime
import scala.util
import typing



_Equiv__T = typing.TypeVar('_Equiv__T')  # <T>
class Equiv(scala.Serializable, typing.Generic[_Equiv__T]):
    _apply__T = typing.TypeVar('_apply__T')  # <T>
    @staticmethod
    def apply(evidence$2: 'Equiv'[_apply__T]) -> 'Equiv'[_apply__T]: ...
    _by__T = typing.TypeVar('_by__T')  # <T>
    _by__S = typing.TypeVar('_by__S')  # <S>
    @staticmethod
    def by(f: scala.Function1[_by__T, _by__S], evidence$1: 'Equiv'[_by__S]) -> 'Equiv'[_by__T]: ...
    def equiv(self, x: _Equiv__T, y: _Equiv__T) -> bool: ...
    _fromComparator__T = typing.TypeVar('_fromComparator__T')  # <T>
    @staticmethod
    def fromComparator(cmp: typing.Union[java.util.Comparator[_fromComparator__T], typing.Callable[[_fromComparator__T, _fromComparator__T], int]]) -> 'Equiv'[_fromComparator__T]: ...
    _fromFunction__T = typing.TypeVar('_fromFunction__T')  # <T>
    @staticmethod
    def fromFunction(cmp: scala.Function2[_fromFunction__T, _fromFunction__T, typing.Any]) -> 'Equiv'[_fromFunction__T]: ...
    _reference__T = typing.TypeVar('_reference__T')  # <T>
    @staticmethod
    def reference() -> 'Equiv'[_reference__T]: ...
    _universal__T = typing.TypeVar('_universal__T')  # <T>
    @staticmethod
    def universal() -> 'Equiv'[_universal__T]: ...
    _universalEquiv__T = typing.TypeVar('_universalEquiv__T')  # <T>
    @staticmethod
    def universalEquiv() -> 'Equiv'[_universalEquiv__T]: ...

class LowPriorityEquiv:
    @staticmethod
    def $init$($this: 'LowPriorityEquiv') -> None: ...
    _universalEquiv__T = typing.TypeVar('_universalEquiv__T')  # <T>
    def universalEquiv(self) -> Equiv[_universalEquiv__T]: ...

class LowPriorityOrderingImplicits:
    @staticmethod
    def $init$($this: 'LowPriorityOrderingImplicits') -> None: ...
    _comparatorToOrdering__A = typing.TypeVar('_comparatorToOrdering__A')  # <A>
    def comparatorToOrdering(self, cmp: typing.Union[java.util.Comparator[_comparatorToOrdering__A], typing.Callable[[_comparatorToOrdering__A, _comparatorToOrdering__A], int]]) -> 'Ordering'[_comparatorToOrdering__A]: ...
    _ordered__A = typing.TypeVar('_ordered__A')  # <A>
    def ordered(self, evidence$1: scala.Function1[_ordered__A, java.lang.Comparable[_ordered__A]]) -> 'Ordering'[_ordered__A]: ...

_Ordered__A = typing.TypeVar('_Ordered__A')  # <A>
class Ordered(java.lang.Comparable[_Ordered__A], typing.Generic[_Ordered__A]):
    def $greater(self, that: _Ordered__A) -> bool: ...
    def $greater$eq(self, that: _Ordered__A) -> bool: ...
    @staticmethod
    def $init$($this: 'Ordered') -> None: ...
    def $less(self, that: _Ordered__A) -> bool: ...
    def $less$eq(self, that: _Ordered__A) -> bool: ...
    def compare(self, that: _Ordered__A) -> int: ...
    def compareTo(self, that: _Ordered__A) -> int: ...
    _orderingToOrdered__T = typing.TypeVar('_orderingToOrdered__T')  # <T>
    @staticmethod
    def orderingToOrdered(x: _orderingToOrdered__T, ord: 'Ordering'[_orderingToOrdered__T]) -> 'Ordered'[_orderingToOrdered__T]: ...

_PartiallyOrdered__A = typing.TypeVar('_PartiallyOrdered__A')  # <A>
class PartiallyOrdered(typing.Generic[_PartiallyOrdered__A]):
    _$greater__B = typing.TypeVar('_$greater__B')  # <B>
    def $greater(self, that: _.greater__B, evidence$3: scala.Function1[_.greater__B, 'PartiallyOrdered'[_.greater__B]]) -> bool: ...
    _$greater$eq__B = typing.TypeVar('_$greater$eq__B')  # <B>
    def $greater$eq(self, that: _.greater.eq__B, evidence$5: scala.Function1[_.greater.eq__B, 'PartiallyOrdered'[_.greater.eq__B]]) -> bool: ...
    @staticmethod
    def $init$($this: 'PartiallyOrdered') -> None: ...
    _$less__B = typing.TypeVar('_$less__B')  # <B>
    def $less(self, that: _.less__B, evidence$2: scala.Function1[_.less__B, 'PartiallyOrdered'[_.less__B]]) -> bool: ...
    _$less$eq__B = typing.TypeVar('_$less$eq__B')  # <B>
    def $less$eq(self, that: _.less.eq__B, evidence$4: scala.Function1[_.less.eq__B, 'PartiallyOrdered'[_.less.eq__B]]) -> bool: ...
    _tryCompareTo__B = typing.TypeVar('_tryCompareTo__B')  # <B>
    def tryCompareTo(self, that: _tryCompareTo__B, evidence$1: scala.Function1[_tryCompareTo__B, 'PartiallyOrdered'[_tryCompareTo__B]]) -> scala.Option[typing.Any]: ...

class ScalaNumber(java.lang.Number):
    def __init__(self): ...
    def underlying(self) -> typing.Any: ...

class ScalaNumericAnyConversions:
    @staticmethod
    def $init$($this: 'ScalaNumericAnyConversions') -> None: ...
    def byteValue(self) -> int: ...
    def doubleValue(self) -> float: ...
    def floatValue(self) -> float: ...
    def intValue(self) -> int: ...
    def isValidByte(self) -> bool: ...
    def isValidChar(self) -> bool: ...
    def isValidInt(self) -> bool: ...
    def isValidShort(self) -> bool: ...
    def isWhole(self) -> bool: ...
    def longValue(self) -> int: ...
    def shortValue(self) -> int: ...
    def toByte(self) -> int: ...
    def toChar(self) -> str: ...
    def toDouble(self) -> float: ...
    def toFloat(self) -> float: ...
    def toInt(self) -> int: ...
    def toLong(self) -> int: ...
    def toShort(self) -> int: ...
    def underlying(self) -> typing.Any: ...
    def unifiedPrimitiveEquals(self, x: typing.Any) -> bool: ...
    def unifiedPrimitiveHashcode(self) -> int: ...

class package:
    @staticmethod
    def E() -> float: ...
    @staticmethod
    def IEEEremainder(x: float, y: float) -> float: ...
    @staticmethod
    def Pi() -> float: ...
    @typing.overload
    @staticmethod
    def abs(x: float) -> float: ...
    @typing.overload
    @staticmethod
    def abs(x: float) -> float: ...
    @typing.overload
    @staticmethod
    def abs(x: int) -> int: ...
    @typing.overload
    @staticmethod
    def abs(x: int) -> int: ...
    @staticmethod
    def acos(x: float) -> float: ...
    @staticmethod
    def asin(x: float) -> float: ...
    @staticmethod
    def atan(x: float) -> float: ...
    @staticmethod
    def atan2(y: float, x: float) -> float: ...
    @staticmethod
    def cbrt(x: float) -> float: ...
    @staticmethod
    def ceil(x: float) -> float: ...
    @staticmethod
    def cos(x: float) -> float: ...
    @staticmethod
    def cosh(x: float) -> float: ...
    @staticmethod
    def exp(x: float) -> float: ...
    @staticmethod
    def expm1(x: float) -> float: ...
    @staticmethod
    def floor(x: float) -> float: ...
    @staticmethod
    def hypot(x: float, y: float) -> float: ...
    @staticmethod
    def log(x: float) -> float: ...
    @staticmethod
    def log10(x: float) -> float: ...
    @staticmethod
    def log1p(x: float) -> float: ...
    @typing.overload
    @staticmethod
    def max(x: float, y: float) -> float: ...
    @typing.overload
    @staticmethod
    def max(x: float, y: float) -> float: ...
    @typing.overload
    @staticmethod
    def max(x: int, y: int) -> int: ...
    @typing.overload
    @staticmethod
    def max(x: int, y: int) -> int: ...
    @typing.overload
    @staticmethod
    def min(x: float, y: float) -> float: ...
    @typing.overload
    @staticmethod
    def min(x: float, y: float) -> float: ...
    @typing.overload
    @staticmethod
    def min(x: int, y: int) -> int: ...
    @typing.overload
    @staticmethod
    def min(x: int, y: int) -> int: ...
    @staticmethod
    def pow(x: float, y: float) -> float: ...
    @staticmethod
    def random() -> float: ...
    @staticmethod
    def rint(x: float) -> float: ...
    @typing.overload
    @staticmethod
    def round(x: float) -> int: ...
    @typing.overload
    @staticmethod
    def round(x: float) -> int: ...
    @typing.overload
    @staticmethod
    def round(x: int) -> int: ...
    @typing.overload
    @staticmethod
    def signum(x: float) -> float: ...
    @typing.overload
    @staticmethod
    def signum(x: float) -> float: ...
    @typing.overload
    @staticmethod
    def signum(x: int) -> int: ...
    @typing.overload
    @staticmethod
    def signum(x: int) -> int: ...
    @staticmethod
    def sin(x: float) -> float: ...
    @staticmethod
    def sinh(x: float) -> float: ...
    @staticmethod
    def sqrt(x: float) -> float: ...
    @staticmethod
    def tan(x: float) -> float: ...
    @staticmethod
    def tanh(x: float) -> float: ...
    @staticmethod
    def toDegrees(x: float) -> float: ...
    @staticmethod
    def toRadians(x: float) -> float: ...
    @typing.overload
    @staticmethod
    def ulp(x: float) -> float: ...
    @typing.overload
    @staticmethod
    def ulp(x: float) -> float: ...

_PartialOrdering__T = typing.TypeVar('_PartialOrdering__T')  # <T>
class PartialOrdering(Equiv[_PartialOrdering__T], typing.Generic[_PartialOrdering__T]):
    @staticmethod
    def $init$($this: 'PartialOrdering') -> None: ...
    def equiv(self, x: _PartialOrdering__T, y: _PartialOrdering__T) -> bool: ...
    def gt(self, x: _PartialOrdering__T, y: _PartialOrdering__T) -> bool: ...
    def gteq(self, x: _PartialOrdering__T, y: _PartialOrdering__T) -> bool: ...
    def lt(self, x: _PartialOrdering__T, y: _PartialOrdering__T) -> bool: ...
    def lteq(self, x: _PartialOrdering__T, y: _PartialOrdering__T) -> bool: ...
    def reverse(self) -> 'PartialOrdering'[_PartialOrdering__T]: ...
    def tryCompare(self, x: _PartialOrdering__T, y: _PartialOrdering__T) -> scala.Option[typing.Any]: ...

class ScalaNumericConversions(ScalaNumericAnyConversions):
    def underlying(self) -> typing.Any: ...

class BigDecimal(ScalaNumber, ScalaNumericConversions, scala.Serializable, Ordered['BigDecimal']):
    @typing.overload
    def __init__(self, bigDecimal: typing.Union[java.math.BigDecimal, decimal.Decimal]): ...
    @typing.overload
    def __init__(self, bigDecimal: typing.Union[java.math.BigDecimal, decimal.Decimal], mc: java.math.MathContext): ...
    def $div(self, that: 'BigDecimal') -> 'BigDecimal': ...
    def $div$percent(self, that: 'BigDecimal') -> scala.Tuple2['BigDecimal', 'BigDecimal']: ...
    def $greater(self, that: typing.Any) -> bool: ...
    def $greater$eq(self, that: typing.Any) -> bool: ...
    def $less(self, that: typing.Any) -> bool: ...
    def $less$eq(self, that: typing.Any) -> bool: ...
    def $minus(self, that: 'BigDecimal') -> 'BigDecimal': ...
    def $percent(self, that: 'BigDecimal') -> 'BigDecimal': ...
    def $plus(self, that: 'BigDecimal') -> 'BigDecimal': ...
    def $times(self, that: 'BigDecimal') -> 'BigDecimal': ...
    def abs(self) -> 'BigDecimal': ...
    def apply(self, mc: java.math.MathContext) -> 'BigDecimal': ...
    def bigDecimal(self) -> java.math.BigDecimal: ...
    @typing.overload
    @staticmethod
    def binary(d: float) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def binary(d: float, mc: java.math.MathContext) -> 'BigDecimal': ...
    def byteValue(self) -> int: ...
    def charValue(self) -> str: ...
    def compare(self, that: 'BigDecimal') -> int: ...
    def compareTo(self, that: typing.Any) -> int: ...
    @typing.overload
    @staticmethod
    def decimal(d: float) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def decimal(d: float, mc: java.math.MathContext) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def decimal(f: float) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def decimal(f: float, mc: java.math.MathContext) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def decimal(bd: typing.Union[java.math.BigDecimal, decimal.Decimal], mc: java.math.MathContext) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def decimal(l: int) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def decimal(l: int, mc: java.math.MathContext) -> 'BigDecimal': ...
    @staticmethod
    def defaultMathContext() -> java.math.MathContext: ...
    @staticmethod
    def double2bigDecimal(d: float) -> 'BigDecimal': ...
    def doubleValue(self) -> float: ...
    @typing.overload
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    def equals(self, that: 'BigDecimal') -> bool: ...
    @typing.overload
    @staticmethod
    def exact(cs: typing.List[str]) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def exact(d: float) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def exact(s: typing.Union[java.lang.String, str]) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def exact(repr: typing.Union[java.math.BigDecimal, decimal.Decimal]) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def exact(l: int) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def exact(bi: 'BigInt') -> 'BigDecimal': ...
    def floatValue(self) -> float: ...
    def hashCode(self) -> int: ...
    @staticmethod
    def int2bigDecimal(i: int) -> 'BigDecimal': ...
    def intValue(self) -> int: ...
    def isBinaryDouble(self) -> bool: ...
    def isBinaryFloat(self) -> bool: ...
    def isDecimalDouble(self) -> bool: ...
    def isDecimalFloat(self) -> bool: ...
    def isExactDouble(self) -> bool: ...
    def isExactFloat(self) -> bool: ...
    def isValidByte(self) -> bool: ...
    def isValidChar(self) -> bool: ...
    def isValidDouble(self) -> bool: ...
    def isValidFloat(self) -> bool: ...
    def isValidInt(self) -> bool: ...
    def isValidLong(self) -> bool: ...
    def isValidShort(self) -> bool: ...
    def isWhole(self) -> bool: ...
    @staticmethod
    def javaBigDecimal2bigDecimal(x: typing.Union[java.math.BigDecimal, decimal.Decimal]) -> 'BigDecimal': ...
    @staticmethod
    def long2bigDecimal(l: int) -> 'BigDecimal': ...
    def longValue(self) -> int: ...
    def max(self, that: 'BigDecimal') -> 'BigDecimal': ...
    def mc(self) -> java.math.MathContext: ...
    def min(self, that: 'BigDecimal') -> 'BigDecimal': ...
    def pow(self, n: int) -> 'BigDecimal': ...
    def precision(self) -> int: ...
    def quot(self, that: 'BigDecimal') -> 'BigDecimal': ...
    def remainder(self, that: 'BigDecimal') -> 'BigDecimal': ...
    def round(self, mc: java.math.MathContext) -> 'BigDecimal': ...
    def rounded(self) -> 'BigDecimal': ...
    def scale(self) -> int: ...
    @typing.overload
    def setScale(self, scale: int) -> 'BigDecimal': ...
    @typing.overload
    def setScale(self, scale: int, mode: scala.Enumeration.Value) -> 'BigDecimal': ...
    def shortValue(self) -> int: ...
    def signum(self) -> int: ...
    @typing.overload
    def to(self, end: 'BigDecimal') -> scala.Function1['BigDecimal', scala.collection.immutable.NumericRange.Inclusive['BigDecimal']]: ...
    @typing.overload
    def to(self, end: 'BigDecimal', step: 'BigDecimal') -> scala.collection.immutable.NumericRange.Inclusive['BigDecimal']: ...
    def toBigInt(self) -> 'BigInt': ...
    def toBigIntExact(self) -> scala.Option['BigInt']: ...
    def toByte(self) -> int: ...
    def toByteExact(self) -> int: ...
    def toChar(self) -> str: ...
    def toDouble(self) -> float: ...
    def toFloat(self) -> float: ...
    def toInt(self) -> int: ...
    def toIntExact(self) -> int: ...
    def toLong(self) -> int: ...
    def toLongExact(self) -> int: ...
    def toShort(self) -> int: ...
    def toShortExact(self) -> int: ...
    def toString(self) -> java.lang.String: ...
    def ulp(self) -> 'BigDecimal': ...
    def unary_$minus(self) -> 'BigDecimal': ...
    def underlying(self) -> java.math.BigDecimal: ...
    def unifiedPrimitiveEquals(self, x: typing.Any) -> bool: ...
    def unifiedPrimitiveHashcode(self) -> int: ...
    @typing.overload
    def until(self, end: 'BigDecimal') -> scala.Function1['BigDecimal', scala.collection.immutable.NumericRange.Exclusive['BigDecimal']]: ...
    @typing.overload
    def until(self, end: 'BigDecimal', step: 'BigDecimal') -> scala.collection.immutable.NumericRange.Exclusive['BigDecimal']: ...
    @typing.overload
    @staticmethod
    def valueOf(d: float) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def valueOf(d: float, mc: java.math.MathContext) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def valueOf(f: float) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def valueOf(f: float, mc: java.math.MathContext) -> 'BigDecimal': ...
    @typing.overload
    @staticmethod
    def valueOf(x: int) -> 'BigDecimal': ...
    class RoundingMode$(scala.Enumeration):
        MODULE$: typing.ClassVar['BigDecimal.RoundingMode.'] = ...
        def __init__(self): ...
        def CEILING(self) -> scala.Enumeration.Value: ...
        def DOWN(self) -> scala.Enumeration.Value: ...
        def FLOOR(self) -> scala.Enumeration.Value: ...
        def HALF_DOWN(self) -> scala.Enumeration.Value: ...
        def HALF_EVEN(self) -> scala.Enumeration.Value: ...
        def HALF_UP(self) -> scala.Enumeration.Value: ...
        def UNNECESSARY(self) -> scala.Enumeration.Value: ...
        def UP(self) -> scala.Enumeration.Value: ...

class BigInt(ScalaNumber, ScalaNumericConversions, scala.Serializable, Ordered['BigInt']):
    def __init__(self, bigInteger: java.math.BigInteger): ...
    def $amp(self, that: 'BigInt') -> 'BigInt': ...
    def $amp$tilde(self, that: 'BigInt') -> 'BigInt': ...
    def $bar(self, that: 'BigInt') -> 'BigInt': ...
    def $div(self, that: 'BigInt') -> 'BigInt': ...
    def $div$percent(self, that: 'BigInt') -> scala.Tuple2['BigInt', 'BigInt']: ...
    def $greater(self, that: typing.Any) -> bool: ...
    def $greater$eq(self, that: typing.Any) -> bool: ...
    def $greater$greater(self, n: int) -> 'BigInt': ...
    def $less(self, that: typing.Any) -> bool: ...
    def $less$eq(self, that: typing.Any) -> bool: ...
    def $less$less(self, n: int) -> 'BigInt': ...
    def $minus(self, that: 'BigInt') -> 'BigInt': ...
    def $percent(self, that: 'BigInt') -> 'BigInt': ...
    def $plus(self, that: 'BigInt') -> 'BigInt': ...
    def $times(self, that: 'BigInt') -> 'BigInt': ...
    def $up(self, that: 'BigInt') -> 'BigInt': ...
    def abs(self) -> 'BigInt': ...
    @typing.overload
    @staticmethod
    def apply(x: typing.List[int]) -> 'BigInt': ...
    @typing.overload
    @staticmethod
    def apply(i: int) -> 'BigInt': ...
    @typing.overload
    @staticmethod
    def apply(signum: int, magnitude: typing.List[int]) -> 'BigInt': ...
    @typing.overload
    @staticmethod
    def apply(bitlength: int, certainty: int, rnd: scala.util.Random) -> 'BigInt': ...
    @typing.overload
    @staticmethod
    def apply(numbits: int, rnd: scala.util.Random) -> 'BigInt': ...
    @typing.overload
    @staticmethod
    def apply(x: typing.Union[java.lang.String, str]) -> 'BigInt': ...
    @typing.overload
    @staticmethod
    def apply(x: typing.Union[java.lang.String, str], radix: int) -> 'BigInt': ...
    @typing.overload
    @staticmethod
    def apply(x: java.math.BigInteger) -> 'BigInt': ...
    @typing.overload
    @staticmethod
    def apply(l: int) -> 'BigInt': ...
    def bigInteger(self) -> java.math.BigInteger: ...
    def bitCount(self) -> int: ...
    def bitLength(self) -> int: ...
    def byteValue(self) -> int: ...
    def charValue(self) -> str: ...
    def clearBit(self, n: int) -> 'BigInt': ...
    def compare(self, that: 'BigInt') -> int: ...
    def compareTo(self, that: typing.Any) -> int: ...
    def doubleValue(self) -> float: ...
    @typing.overload
    def equals(self, that: typing.Any) -> bool: ...
    @typing.overload
    def equals(self, that: 'BigInt') -> bool: ...
    def flipBit(self, n: int) -> 'BigInt': ...
    def floatValue(self) -> float: ...
    def gcd(self, that: 'BigInt') -> 'BigInt': ...
    def hashCode(self) -> int: ...
    @staticmethod
    def int2bigInt(i: int) -> 'BigInt': ...
    def intValue(self) -> int: ...
    def isProbablePrime(self, certainty: int) -> bool: ...
    def isValidByte(self) -> bool: ...
    def isValidChar(self) -> bool: ...
    def isValidDouble(self) -> bool: ...
    def isValidFloat(self) -> bool: ...
    def isValidInt(self) -> bool: ...
    def isValidLong(self) -> bool: ...
    def isValidShort(self) -> bool: ...
    def isWhole(self) -> bool: ...
    @staticmethod
    def javaBigInteger2bigInt(x: java.math.BigInteger) -> 'BigInt': ...
    @staticmethod
    def long2bigInt(l: int) -> 'BigInt': ...
    def longValue(self) -> int: ...
    def lowestSetBit(self) -> int: ...
    def max(self, that: 'BigInt') -> 'BigInt': ...
    def min(self, that: 'BigInt') -> 'BigInt': ...
    def mod(self, that: 'BigInt') -> 'BigInt': ...
    def modInverse(self, m: 'BigInt') -> 'BigInt': ...
    def modPow(self, exp: 'BigInt', m: 'BigInt') -> 'BigInt': ...
    def pow(self, exp: int) -> 'BigInt': ...
    @staticmethod
    def probablePrime(bitLength: int, rnd: scala.util.Random) -> 'BigInt': ...
    def setBit(self, n: int) -> 'BigInt': ...
    def shortValue(self) -> int: ...
    def signum(self) -> int: ...
    def testBit(self, n: int) -> bool: ...
    def to(self, end: 'BigInt', step: 'BigInt') -> scala.collection.immutable.NumericRange.Inclusive['BigInt']: ...
    def to$default$2(self) -> 'BigInt': ...
    def toByte(self) -> int: ...
    def toByteArray(self) -> typing.List[int]: ...
    def toChar(self) -> str: ...
    def toDouble(self) -> float: ...
    def toFloat(self) -> float: ...
    def toInt(self) -> int: ...
    def toLong(self) -> int: ...
    def toShort(self) -> int: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def toString(self, radix: int) -> java.lang.String: ...
    def unary_$minus(self) -> 'BigInt': ...
    def unary_$tilde(self) -> 'BigInt': ...
    def underlying(self) -> java.math.BigInteger: ...
    def unifiedPrimitiveEquals(self, x: typing.Any) -> bool: ...
    def unifiedPrimitiveHashcode(self) -> int: ...
    def until(self, end: 'BigInt', step: 'BigInt') -> scala.collection.immutable.NumericRange.Exclusive['BigInt']: ...
    def until$default$2(self) -> 'BigInt': ...

_Fractional__T = typing.TypeVar('_Fractional__T')  # <T>
class Fractional(scala.math.Numeric[_Fractional__T], typing.Generic[_Fractional__T]):
    @staticmethod
    def $init$($this: 'Fractional') -> None: ...
    def div(self, x: _Fractional__T, y: _Fractional__T) -> _Fractional__T: ...
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    def mkNumericOps(self, lhs: _Fractional__T) -> 'Fractional.FractionalOps': ...
    @typing.overload
    def mkNumericOps(self, lhs: _Fractional__T) -> 'Numeric.Ops': ...
    class ExtraImplicits:
        @staticmethod
        def $init$($this: 'Fractional.ExtraImplicits') -> None: ...
        _infixFractionalOps__T = typing.TypeVar('_infixFractionalOps__T')  # <T>
        def infixFractionalOps(self, x: _infixFractionalOps__T, num: 'Fractional'[_infixFractionalOps__T]) -> 'Fractional.FractionalOps': ...
    class FractionalOps(scala.math.Numeric.Ops):
        def __init__(self, $outer: 'Fractional', lhs: _Fractional__T): ...
        def $div(self, rhs: _Fractional__T) -> _Fractional__T: ...
    class Implicits$(scala.math.Fractional.ExtraImplicits):
        MODULE$: typing.ClassVar['Fractional.Implicits.'] = ...
        def __init__(self): ...
        _infixFractionalOps__T = typing.TypeVar('_infixFractionalOps__T')  # <T>
        def infixFractionalOps(self, x: _infixFractionalOps__T, num: 'Fractional'[_infixFractionalOps__T]) -> 'Fractional.FractionalOps': ...

_Integral__T = typing.TypeVar('_Integral__T')  # <T>
class Integral(scala.math.Numeric[_Integral__T], typing.Generic[_Integral__T]):
    @staticmethod
    def $init$($this: 'Integral') -> None: ...
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    def mkNumericOps(self, lhs: _Integral__T) -> 'Integral.IntegralOps': ...
    @typing.overload
    def mkNumericOps(self, lhs: _Integral__T) -> 'Numeric.Ops': ...
    def quot(self, x: _Integral__T, y: _Integral__T) -> _Integral__T: ...
    def rem(self, x: _Integral__T, y: _Integral__T) -> _Integral__T: ...
    class ExtraImplicits:
        @staticmethod
        def $init$($this: 'Integral.ExtraImplicits') -> None: ...
        _infixIntegralOps__T = typing.TypeVar('_infixIntegralOps__T')  # <T>
        def infixIntegralOps(self, x: _infixIntegralOps__T, num: 'Integral'[_infixIntegralOps__T]) -> 'Integral.IntegralOps': ...
    class Implicits$(scala.math.Integral.ExtraImplicits):
        MODULE$: typing.ClassVar['Integral.Implicits.'] = ...
        def __init__(self): ...
        _infixIntegralOps__T = typing.TypeVar('_infixIntegralOps__T')  # <T>
        def infixIntegralOps(self, x: _infixIntegralOps__T, num: 'Integral'[_infixIntegralOps__T]) -> 'Integral.IntegralOps': ...
    class IntegralOps(scala.math.Numeric.Ops):
        def __init__(self, $outer: 'Integral', lhs: _Integral__T): ...
        def $div(self, rhs: _Integral__T) -> _Integral__T: ...
        def $div$percent(self, rhs: _Integral__T) -> scala.Tuple2[_Integral__T, _Integral__T]: ...
        def $percent(self, rhs: _Integral__T) -> _Integral__T: ...

_Numeric__T = typing.TypeVar('_Numeric__T')  # <T>
class Numeric(scala.math.Ordering[_Numeric__T], typing.Generic[_Numeric__T]):
    @staticmethod
    def $init$($this: 'Numeric') -> None: ...
    def abs(self, x: _Numeric__T) -> _Numeric__T: ...
    def equals(self, object: typing.Any) -> bool: ...
    def fromInt(self, x: int) -> _Numeric__T: ...
    def minus(self, x: _Numeric__T, y: _Numeric__T) -> _Numeric__T: ...
    def mkNumericOps(self, lhs: _Numeric__T) -> 'Numeric.Ops': ...
    def negate(self, x: _Numeric__T) -> _Numeric__T: ...
    def one(self) -> _Numeric__T: ...
    def plus(self, x: _Numeric__T, y: _Numeric__T) -> _Numeric__T: ...
    def signum(self, x: _Numeric__T) -> int: ...
    def times(self, x: _Numeric__T, y: _Numeric__T) -> _Numeric__T: ...
    def toDouble(self, x: _Numeric__T) -> float: ...
    def toFloat(self, x: _Numeric__T) -> float: ...
    def toInt(self, x: _Numeric__T) -> int: ...
    def toLong(self, x: _Numeric__T) -> int: ...
    def zero(self) -> _Numeric__T: ...
    class BigDecimalAsIfIntegral(scala.math.Numeric.BigDecimalIsConflicted, Integral[BigDecimal]):
        @staticmethod
        def $init$($this: 'Numeric.BigDecimalAsIfIntegral') -> None: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def quot(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def quot(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        @typing.overload
        def rem(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def rem(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
    class BigDecimalAsIfIntegral$(scala.math.Numeric.BigDecimalAsIfIntegral, scala.math.Ordering.BigDecimalOrdering):
        MODULE$: typing.ClassVar['Numeric.BigDecimalAsIfIntegral.'] = ...
        def __init__(self): ...
        def abs(self, x: typing.Any) -> typing.Any: ...
        def compare(self, x: BigDecimal, y: BigDecimal) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def fromInt(self, x: int) -> BigDecimal: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def minus(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        def mkNumericOps(self, lhs: typing.Any) -> Integral.IntegralOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: BigDecimal) -> BigDecimal: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, BigDecimal]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        def quot(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        def rem(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        def reverse(self) -> 'Ordering'[BigDecimal]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        def toDouble(self, x: BigDecimal) -> float: ...
        def toFloat(self, x: BigDecimal) -> float: ...
        def toInt(self, x: BigDecimal) -> int: ...
        def toLong(self, x: BigDecimal) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...
    class BigDecimalIsConflicted(scala.math.Numeric[BigDecimal]):
        @staticmethod
        def $init$($this: 'Numeric.BigDecimalIsConflicted') -> None: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def fromInt(self, x: int) -> typing.Any: ...
        @typing.overload
        def fromInt(self, x: int) -> BigDecimal: ...
        @typing.overload
        def minus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def minus(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        @typing.overload
        def negate(self, x: typing.Any) -> typing.Any: ...
        @typing.overload
        def negate(self, x: BigDecimal) -> BigDecimal: ...
        @typing.overload
        def plus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def plus(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        @typing.overload
        def times(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def times(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        @typing.overload
        def toDouble(self, x: typing.Any) -> float: ...
        @typing.overload
        def toDouble(self, x: BigDecimal) -> float: ...
        @typing.overload
        def toFloat(self, x: typing.Any) -> float: ...
        @typing.overload
        def toFloat(self, x: BigDecimal) -> float: ...
        @typing.overload
        def toInt(self, x: typing.Any) -> int: ...
        @typing.overload
        def toInt(self, x: BigDecimal) -> int: ...
        @typing.overload
        def toLong(self, x: typing.Any) -> int: ...
        @typing.overload
        def toLong(self, x: BigDecimal) -> int: ...
    class BigDecimalIsFractional(scala.math.Numeric.BigDecimalIsConflicted, Fractional[BigDecimal]):
        @staticmethod
        def $init$($this: 'Numeric.BigDecimalIsFractional') -> None: ...
        @typing.overload
        def div(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def div(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        def equals(self, object: typing.Any) -> bool: ...
    class BigDecimalIsFractional$(scala.math.Numeric.BigDecimalIsFractional, scala.math.Ordering.BigDecimalOrdering):
        MODULE$: typing.ClassVar['Numeric.BigDecimalIsFractional.'] = ...
        def __init__(self): ...
        def abs(self, x: typing.Any) -> typing.Any: ...
        def compare(self, x: BigDecimal, y: BigDecimal) -> int: ...
        def div(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def fromInt(self, x: int) -> BigDecimal: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def minus(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        def mkNumericOps(self, lhs: typing.Any) -> Fractional.FractionalOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: BigDecimal) -> BigDecimal: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, BigDecimal]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        def reverse(self) -> 'Ordering'[BigDecimal]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: BigDecimal, y: BigDecimal) -> BigDecimal: ...
        def toDouble(self, x: BigDecimal) -> float: ...
        def toFloat(self, x: BigDecimal) -> float: ...
        def toInt(self, x: BigDecimal) -> int: ...
        def toLong(self, x: BigDecimal) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...
    class BigIntIsIntegral(Integral[BigInt]):
        @staticmethod
        def $init$($this: 'Numeric.BigIntIsIntegral') -> None: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def fromInt(self, x: int) -> typing.Any: ...
        @typing.overload
        def fromInt(self, x: int) -> BigInt: ...
        @typing.overload
        def minus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def minus(self, x: BigInt, y: BigInt) -> BigInt: ...
        @typing.overload
        def negate(self, x: typing.Any) -> typing.Any: ...
        @typing.overload
        def negate(self, x: BigInt) -> BigInt: ...
        @typing.overload
        def plus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def plus(self, x: BigInt, y: BigInt) -> BigInt: ...
        @typing.overload
        def quot(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def quot(self, x: BigInt, y: BigInt) -> BigInt: ...
        @typing.overload
        def rem(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def rem(self, x: BigInt, y: BigInt) -> BigInt: ...
        @typing.overload
        def times(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def times(self, x: BigInt, y: BigInt) -> BigInt: ...
        @typing.overload
        def toDouble(self, x: typing.Any) -> float: ...
        @typing.overload
        def toDouble(self, x: BigInt) -> float: ...
        @typing.overload
        def toFloat(self, x: typing.Any) -> float: ...
        @typing.overload
        def toFloat(self, x: BigInt) -> float: ...
        @typing.overload
        def toInt(self, x: typing.Any) -> int: ...
        @typing.overload
        def toInt(self, x: BigInt) -> int: ...
        @typing.overload
        def toLong(self, x: typing.Any) -> int: ...
        @typing.overload
        def toLong(self, x: BigInt) -> int: ...
    class BigIntIsIntegral$(scala.math.Numeric.BigIntIsIntegral, scala.math.Ordering.BigIntOrdering):
        MODULE$: typing.ClassVar['Numeric.BigIntIsIntegral.'] = ...
        def __init__(self): ...
        def abs(self, x: typing.Any) -> typing.Any: ...
        def compare(self, x: BigInt, y: BigInt) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def fromInt(self, x: int) -> BigInt: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def minus(self, x: BigInt, y: BigInt) -> BigInt: ...
        def mkNumericOps(self, lhs: typing.Any) -> Integral.IntegralOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: BigInt) -> BigInt: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, BigInt]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: BigInt, y: BigInt) -> BigInt: ...
        def quot(self, x: BigInt, y: BigInt) -> BigInt: ...
        def rem(self, x: BigInt, y: BigInt) -> BigInt: ...
        def reverse(self) -> 'Ordering'[BigInt]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: BigInt, y: BigInt) -> BigInt: ...
        def toDouble(self, x: BigInt) -> float: ...
        def toFloat(self, x: BigInt) -> float: ...
        def toInt(self, x: BigInt) -> int: ...
        def toLong(self, x: BigInt) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...
    class ByteIsIntegral(Integral[typing.Any]):
        @staticmethod
        def $init$($this: 'Numeric.ByteIsIntegral') -> None: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def fromInt(self, x: int) -> typing.Any: ...
        @typing.overload
        def fromInt(self, x: int) -> int: ...
        @typing.overload
        def minus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def minus(self, x: int, y: int) -> int: ...
        @typing.overload
        def negate(self, x: typing.Any) -> typing.Any: ...
        @typing.overload
        def negate(self, x: int) -> int: ...
        @typing.overload
        def plus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def plus(self, x: int, y: int) -> int: ...
        @typing.overload
        def quot(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def quot(self, x: int, y: int) -> int: ...
        @typing.overload
        def rem(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def rem(self, x: int, y: int) -> int: ...
        @typing.overload
        def times(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def times(self, x: int, y: int) -> int: ...
        @typing.overload
        def toDouble(self, x: typing.Any) -> float: ...
        @typing.overload
        def toDouble(self, x: int) -> float: ...
        @typing.overload
        def toFloat(self, x: typing.Any) -> float: ...
        @typing.overload
        def toFloat(self, x: int) -> float: ...
        @typing.overload
        def toInt(self, x: typing.Any) -> int: ...
        @typing.overload
        def toInt(self, x: int) -> int: ...
        @typing.overload
        def toLong(self, x: typing.Any) -> int: ...
        @typing.overload
        def toLong(self, x: int) -> int: ...
    class ByteIsIntegral$(scala.math.Numeric.ByteIsIntegral, scala.math.Ordering.ByteOrdering):
        MODULE$: typing.ClassVar['Numeric.ByteIsIntegral.'] = ...
        def __init__(self): ...
        def abs(self, x: typing.Any) -> typing.Any: ...
        def compare(self, x: int, y: int) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def fromInt(self, x: int) -> int: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def minus(self, x: int, y: int) -> int: ...
        def mkNumericOps(self, lhs: typing.Any) -> Integral.IntegralOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: int) -> int: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: int, y: int) -> int: ...
        def quot(self, x: int, y: int) -> int: ...
        def rem(self, x: int, y: int) -> int: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: int, y: int) -> int: ...
        def toDouble(self, x: int) -> float: ...
        def toFloat(self, x: int) -> float: ...
        def toInt(self, x: int) -> int: ...
        def toLong(self, x: int) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...
    class CharIsIntegral(Integral[typing.Any]):
        @staticmethod
        def $init$($this: 'Numeric.CharIsIntegral') -> None: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def fromInt(self, x: int) -> typing.Any: ...
        @typing.overload
        def fromInt(self, x: int) -> str: ...
        @typing.overload
        def minus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def minus(self, x: str, y: str) -> str: ...
        @typing.overload
        def negate(self, x: typing.Any) -> typing.Any: ...
        @typing.overload
        def negate(self, x: str) -> str: ...
        @typing.overload
        def plus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def plus(self, x: str, y: str) -> str: ...
        @typing.overload
        def quot(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def quot(self, x: str, y: str) -> str: ...
        @typing.overload
        def rem(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def rem(self, x: str, y: str) -> str: ...
        @typing.overload
        def times(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def times(self, x: str, y: str) -> str: ...
        @typing.overload
        def toDouble(self, x: typing.Any) -> float: ...
        @typing.overload
        def toDouble(self, x: str) -> float: ...
        @typing.overload
        def toFloat(self, x: typing.Any) -> float: ...
        @typing.overload
        def toFloat(self, x: str) -> float: ...
        @typing.overload
        def toInt(self, x: typing.Any) -> int: ...
        @typing.overload
        def toInt(self, x: str) -> int: ...
        @typing.overload
        def toLong(self, x: typing.Any) -> int: ...
        @typing.overload
        def toLong(self, x: str) -> int: ...
    class CharIsIntegral$(scala.math.Numeric.CharIsIntegral, scala.math.Ordering.CharOrdering):
        MODULE$: typing.ClassVar['Numeric.CharIsIntegral.'] = ...
        def __init__(self): ...
        def abs(self, x: typing.Any) -> typing.Any: ...
        def compare(self, x: str, y: str) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def fromInt(self, x: int) -> str: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def minus(self, x: str, y: str) -> str: ...
        def mkNumericOps(self, lhs: typing.Any) -> Integral.IntegralOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: str) -> str: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: str, y: str) -> str: ...
        def quot(self, x: str, y: str) -> str: ...
        def rem(self, x: str, y: str) -> str: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: str, y: str) -> str: ...
        def toDouble(self, x: str) -> float: ...
        def toFloat(self, x: str) -> float: ...
        def toInt(self, x: str) -> int: ...
        def toLong(self, x: str) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...
    class DoubleAsIfIntegral(scala.math.Numeric.DoubleIsConflicted, Integral[typing.Any]):
        @staticmethod
        def $init$($this: 'Numeric.DoubleAsIfIntegral') -> None: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def quot(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def quot(self, x: float, y: float) -> float: ...
        @typing.overload
        def rem(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def rem(self, x: float, y: float) -> float: ...
    class DoubleAsIfIntegral$(scala.math.Numeric.DoubleAsIfIntegral, scala.math.Ordering.DoubleOrdering):
        MODULE$: typing.ClassVar['Numeric.DoubleAsIfIntegral.'] = ...
        def __init__(self): ...
        def abs(self, x: float) -> float: ...
        def compare(self, x: float, y: float) -> int: ...
        def equiv(self, x: float, y: float) -> bool: ...
        def fromInt(self, x: int) -> float: ...
        def gt(self, x: float, y: float) -> bool: ...
        def gteq(self, x: float, y: float) -> bool: ...
        def lt(self, x: float, y: float) -> bool: ...
        def lteq(self, x: float, y: float) -> bool: ...
        def max(self, x: float, y: float) -> float: ...
        def min(self, x: float, y: float) -> float: ...
        def minus(self, x: float, y: float) -> float: ...
        def mkNumericOps(self, lhs: typing.Any) -> Integral.IntegralOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: float) -> float: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: float, y: float) -> float: ...
        def quot(self, x: float, y: float) -> float: ...
        def rem(self, x: float, y: float) -> float: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: float, y: float) -> float: ...
        def toDouble(self, x: float) -> float: ...
        def toFloat(self, x: float) -> float: ...
        def toInt(self, x: float) -> int: ...
        def toLong(self, x: float) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...
    class DoubleIsConflicted(scala.math.Numeric[typing.Any]):
        @staticmethod
        def $init$($this: 'Numeric.DoubleIsConflicted') -> None: ...
        @typing.overload
        def abs(self, x: float) -> float: ...
        @typing.overload
        def abs(self, x: typing.Any) -> typing.Any: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def fromInt(self, x: int) -> typing.Any: ...
        @typing.overload
        def fromInt(self, x: int) -> float: ...
        @typing.overload
        def minus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def minus(self, x: float, y: float) -> float: ...
        @typing.overload
        def negate(self, x: typing.Any) -> typing.Any: ...
        @typing.overload
        def negate(self, x: float) -> float: ...
        @typing.overload
        def plus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def plus(self, x: float, y: float) -> float: ...
        @typing.overload
        def times(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def times(self, x: float, y: float) -> float: ...
        @typing.overload
        def toDouble(self, x: typing.Any) -> float: ...
        @typing.overload
        def toDouble(self, x: float) -> float: ...
        @typing.overload
        def toFloat(self, x: typing.Any) -> float: ...
        @typing.overload
        def toFloat(self, x: float) -> float: ...
        @typing.overload
        def toInt(self, x: typing.Any) -> int: ...
        @typing.overload
        def toInt(self, x: float) -> int: ...
        @typing.overload
        def toLong(self, x: typing.Any) -> int: ...
        @typing.overload
        def toLong(self, x: float) -> int: ...
    class DoubleIsFractional(scala.math.Numeric.DoubleIsConflicted, Fractional[typing.Any]):
        @staticmethod
        def $init$($this: 'Numeric.DoubleIsFractional') -> None: ...
        @typing.overload
        def div(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def div(self, x: float, y: float) -> float: ...
        def equals(self, object: typing.Any) -> bool: ...
    class DoubleIsFractional$(scala.math.Numeric.DoubleIsFractional, scala.math.Ordering.DoubleOrdering):
        MODULE$: typing.ClassVar['Numeric.DoubleIsFractional.'] = ...
        def __init__(self): ...
        def abs(self, x: float) -> float: ...
        def compare(self, x: float, y: float) -> int: ...
        def div(self, x: float, y: float) -> float: ...
        def equiv(self, x: float, y: float) -> bool: ...
        def fromInt(self, x: int) -> float: ...
        def gt(self, x: float, y: float) -> bool: ...
        def gteq(self, x: float, y: float) -> bool: ...
        def lt(self, x: float, y: float) -> bool: ...
        def lteq(self, x: float, y: float) -> bool: ...
        def max(self, x: float, y: float) -> float: ...
        def min(self, x: float, y: float) -> float: ...
        def minus(self, x: float, y: float) -> float: ...
        def mkNumericOps(self, lhs: typing.Any) -> Fractional.FractionalOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: float) -> float: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: float, y: float) -> float: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: float, y: float) -> float: ...
        def toDouble(self, x: float) -> float: ...
        def toFloat(self, x: float) -> float: ...
        def toInt(self, x: float) -> int: ...
        def toLong(self, x: float) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...
    class ExtraImplicits:
        @staticmethod
        def $init$($this: 'Numeric.ExtraImplicits') -> None: ...
        _infixNumericOps__T = typing.TypeVar('_infixNumericOps__T')  # <T>
        def infixNumericOps(self, x: _infixNumericOps__T, num: 'Numeric'[_infixNumericOps__T]) -> 'Numeric.Ops': ...
    class FloatAsIfIntegral(scala.math.Numeric.FloatIsConflicted, Integral[typing.Any]):
        @staticmethod
        def $init$($this: 'Numeric.FloatAsIfIntegral') -> None: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def quot(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def quot(self, x: float, y: float) -> float: ...
        @typing.overload
        def rem(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def rem(self, x: float, y: float) -> float: ...
    class FloatAsIfIntegral$(scala.math.Numeric.FloatAsIfIntegral, scala.math.Ordering.FloatOrdering):
        MODULE$: typing.ClassVar['Numeric.FloatAsIfIntegral.'] = ...
        def __init__(self): ...
        def abs(self, x: float) -> float: ...
        def compare(self, x: float, y: float) -> int: ...
        def equiv(self, x: float, y: float) -> bool: ...
        def fromInt(self, x: int) -> float: ...
        def gt(self, x: float, y: float) -> bool: ...
        def gteq(self, x: float, y: float) -> bool: ...
        def lt(self, x: float, y: float) -> bool: ...
        def lteq(self, x: float, y: float) -> bool: ...
        def max(self, x: float, y: float) -> float: ...
        def min(self, x: float, y: float) -> float: ...
        def minus(self, x: float, y: float) -> float: ...
        def mkNumericOps(self, lhs: typing.Any) -> Integral.IntegralOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: float) -> float: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: float, y: float) -> float: ...
        def quot(self, x: float, y: float) -> float: ...
        def rem(self, x: float, y: float) -> float: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: float, y: float) -> float: ...
        def toDouble(self, x: float) -> float: ...
        def toFloat(self, x: float) -> float: ...
        def toInt(self, x: float) -> int: ...
        def toLong(self, x: float) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...
    class FloatIsConflicted(scala.math.Numeric[typing.Any]):
        @staticmethod
        def $init$($this: 'Numeric.FloatIsConflicted') -> None: ...
        @typing.overload
        def abs(self, x: float) -> float: ...
        @typing.overload
        def abs(self, x: typing.Any) -> typing.Any: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def fromInt(self, x: int) -> typing.Any: ...
        @typing.overload
        def fromInt(self, x: int) -> float: ...
        @typing.overload
        def minus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def minus(self, x: float, y: float) -> float: ...
        @typing.overload
        def negate(self, x: typing.Any) -> typing.Any: ...
        @typing.overload
        def negate(self, x: float) -> float: ...
        @typing.overload
        def plus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def plus(self, x: float, y: float) -> float: ...
        @typing.overload
        def times(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def times(self, x: float, y: float) -> float: ...
        @typing.overload
        def toDouble(self, x: typing.Any) -> float: ...
        @typing.overload
        def toDouble(self, x: float) -> float: ...
        @typing.overload
        def toFloat(self, x: typing.Any) -> float: ...
        @typing.overload
        def toFloat(self, x: float) -> float: ...
        @typing.overload
        def toInt(self, x: typing.Any) -> int: ...
        @typing.overload
        def toInt(self, x: float) -> int: ...
        @typing.overload
        def toLong(self, x: typing.Any) -> int: ...
        @typing.overload
        def toLong(self, x: float) -> int: ...
    class FloatIsFractional(scala.math.Numeric.FloatIsConflicted, Fractional[typing.Any]):
        @staticmethod
        def $init$($this: 'Numeric.FloatIsFractional') -> None: ...
        @typing.overload
        def div(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def div(self, x: float, y: float) -> float: ...
        def equals(self, object: typing.Any) -> bool: ...
    class FloatIsFractional$(scala.math.Numeric.FloatIsFractional, scala.math.Ordering.FloatOrdering):
        MODULE$: typing.ClassVar['Numeric.FloatIsFractional.'] = ...
        def __init__(self): ...
        def abs(self, x: float) -> float: ...
        def compare(self, x: float, y: float) -> int: ...
        def div(self, x: float, y: float) -> float: ...
        def equiv(self, x: float, y: float) -> bool: ...
        def fromInt(self, x: int) -> float: ...
        def gt(self, x: float, y: float) -> bool: ...
        def gteq(self, x: float, y: float) -> bool: ...
        def lt(self, x: float, y: float) -> bool: ...
        def lteq(self, x: float, y: float) -> bool: ...
        def max(self, x: float, y: float) -> float: ...
        def min(self, x: float, y: float) -> float: ...
        def minus(self, x: float, y: float) -> float: ...
        def mkNumericOps(self, lhs: typing.Any) -> Fractional.FractionalOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: float) -> float: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: float, y: float) -> float: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: float, y: float) -> float: ...
        def toDouble(self, x: float) -> float: ...
        def toFloat(self, x: float) -> float: ...
        def toInt(self, x: float) -> int: ...
        def toLong(self, x: float) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...
    class Implicits$(scala.math.Numeric.ExtraImplicits):
        MODULE$: typing.ClassVar['Numeric.Implicits.'] = ...
        def __init__(self): ...
        _infixNumericOps__T = typing.TypeVar('_infixNumericOps__T')  # <T>
        def infixNumericOps(self, x: _infixNumericOps__T, num: 'Numeric'[_infixNumericOps__T]) -> 'Numeric.Ops': ...
    class IntIsIntegral(Integral[typing.Any]):
        @staticmethod
        def $init$($this: 'Numeric.IntIsIntegral') -> None: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def fromInt(self, x: int) -> typing.Any: ...
        @typing.overload
        def fromInt(self, x: int) -> int: ...
        @typing.overload
        def minus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def minus(self, x: int, y: int) -> int: ...
        @typing.overload
        def negate(self, x: typing.Any) -> typing.Any: ...
        @typing.overload
        def negate(self, x: int) -> int: ...
        @typing.overload
        def plus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def plus(self, x: int, y: int) -> int: ...
        @typing.overload
        def quot(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def quot(self, x: int, y: int) -> int: ...
        @typing.overload
        def rem(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def rem(self, x: int, y: int) -> int: ...
        @typing.overload
        def times(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def times(self, x: int, y: int) -> int: ...
        @typing.overload
        def toDouble(self, x: typing.Any) -> float: ...
        @typing.overload
        def toDouble(self, x: int) -> float: ...
        @typing.overload
        def toFloat(self, x: typing.Any) -> float: ...
        @typing.overload
        def toFloat(self, x: int) -> float: ...
        @typing.overload
        def toInt(self, x: typing.Any) -> int: ...
        @typing.overload
        def toInt(self, x: int) -> int: ...
        @typing.overload
        def toLong(self, x: typing.Any) -> int: ...
        @typing.overload
        def toLong(self, x: int) -> int: ...
    class IntIsIntegral$(scala.math.Numeric.IntIsIntegral, scala.math.Ordering.IntOrdering):
        MODULE$: typing.ClassVar['Numeric.IntIsIntegral.'] = ...
        def __init__(self): ...
        def abs(self, x: typing.Any) -> typing.Any: ...
        def compare(self, x: int, y: int) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def fromInt(self, x: int) -> int: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def minus(self, x: int, y: int) -> int: ...
        def mkNumericOps(self, lhs: typing.Any) -> Integral.IntegralOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: int) -> int: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: int, y: int) -> int: ...
        def quot(self, x: int, y: int) -> int: ...
        def rem(self, x: int, y: int) -> int: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: int, y: int) -> int: ...
        def toDouble(self, x: int) -> float: ...
        def toFloat(self, x: int) -> float: ...
        def toInt(self, x: int) -> int: ...
        def toLong(self, x: int) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...
    class LongIsIntegral(Integral[typing.Any]):
        @staticmethod
        def $init$($this: 'Numeric.LongIsIntegral') -> None: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def fromInt(self, x: int) -> typing.Any: ...
        @typing.overload
        def fromInt(self, x: int) -> int: ...
        @typing.overload
        def minus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def minus(self, x: int, y: int) -> int: ...
        @typing.overload
        def negate(self, x: typing.Any) -> typing.Any: ...
        @typing.overload
        def negate(self, x: int) -> int: ...
        @typing.overload
        def plus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def plus(self, x: int, y: int) -> int: ...
        @typing.overload
        def quot(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def quot(self, x: int, y: int) -> int: ...
        @typing.overload
        def rem(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def rem(self, x: int, y: int) -> int: ...
        @typing.overload
        def times(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def times(self, x: int, y: int) -> int: ...
        @typing.overload
        def toDouble(self, x: typing.Any) -> float: ...
        @typing.overload
        def toDouble(self, x: int) -> float: ...
        @typing.overload
        def toFloat(self, x: typing.Any) -> float: ...
        @typing.overload
        def toFloat(self, x: int) -> float: ...
        @typing.overload
        def toInt(self, x: typing.Any) -> int: ...
        @typing.overload
        def toInt(self, x: int) -> int: ...
        @typing.overload
        def toLong(self, x: typing.Any) -> int: ...
        @typing.overload
        def toLong(self, x: int) -> int: ...
    class LongIsIntegral$(scala.math.Numeric.LongIsIntegral, scala.math.Ordering.LongOrdering):
        MODULE$: typing.ClassVar['Numeric.LongIsIntegral.'] = ...
        def __init__(self): ...
        def abs(self, x: typing.Any) -> typing.Any: ...
        def compare(self, x: int, y: int) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def fromInt(self, x: int) -> int: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def minus(self, x: int, y: int) -> int: ...
        def mkNumericOps(self, lhs: typing.Any) -> Integral.IntegralOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: int) -> int: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: int, y: int) -> int: ...
        def quot(self, x: int, y: int) -> int: ...
        def rem(self, x: int, y: int) -> int: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: int, y: int) -> int: ...
        def toDouble(self, x: int) -> float: ...
        def toFloat(self, x: int) -> float: ...
        def toInt(self, x: int) -> int: ...
        def toLong(self, x: int) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...
    class Ops:
        $outer: 'Numeric' = ...
        def __init__(self, $outer: 'Numeric', lhs: _Numeric__T): ...
        def $minus(self, rhs: _Numeric__T) -> _Numeric__T: ...
        def $plus(self, rhs: _Numeric__T) -> _Numeric__T: ...
        def $times(self, rhs: _Numeric__T) -> _Numeric__T: ...
        def abs(self) -> _Numeric__T: ...
        def signum(self) -> int: ...
        def toDouble(self) -> float: ...
        def toFloat(self) -> float: ...
        def toInt(self) -> int: ...
        def toLong(self) -> int: ...
        def unary_$minus(self) -> _Numeric__T: ...
    class ShortIsIntegral(Integral[typing.Any]):
        @staticmethod
        def $init$($this: 'Numeric.ShortIsIntegral') -> None: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def fromInt(self, x: int) -> typing.Any: ...
        @typing.overload
        def fromInt(self, x: int) -> int: ...
        @typing.overload
        def minus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def minus(self, x: int, y: int) -> int: ...
        @typing.overload
        def negate(self, x: typing.Any) -> typing.Any: ...
        @typing.overload
        def negate(self, x: int) -> int: ...
        @typing.overload
        def plus(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def plus(self, x: int, y: int) -> int: ...
        @typing.overload
        def quot(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def quot(self, x: int, y: int) -> int: ...
        @typing.overload
        def rem(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def rem(self, x: int, y: int) -> int: ...
        @typing.overload
        def times(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def times(self, x: int, y: int) -> int: ...
        @typing.overload
        def toDouble(self, x: typing.Any) -> float: ...
        @typing.overload
        def toDouble(self, x: int) -> float: ...
        @typing.overload
        def toFloat(self, x: typing.Any) -> float: ...
        @typing.overload
        def toFloat(self, x: int) -> float: ...
        @typing.overload
        def toInt(self, x: typing.Any) -> int: ...
        @typing.overload
        def toInt(self, x: int) -> int: ...
        @typing.overload
        def toLong(self, x: typing.Any) -> int: ...
        @typing.overload
        def toLong(self, x: int) -> int: ...
    class ShortIsIntegral$(scala.math.Numeric.ShortIsIntegral, scala.math.Ordering.ShortOrdering):
        MODULE$: typing.ClassVar['Numeric.ShortIsIntegral.'] = ...
        def __init__(self): ...
        def abs(self, x: typing.Any) -> typing.Any: ...
        def compare(self, x: int, y: int) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def fromInt(self, x: int) -> int: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def minus(self, x: int, y: int) -> int: ...
        def mkNumericOps(self, lhs: typing.Any) -> Integral.IntegralOps: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        def negate(self, x: int) -> int: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def one(self) -> typing.Any: ...
        def plus(self, x: int, y: int) -> int: ...
        def quot(self, x: int, y: int) -> int: ...
        def rem(self, x: int, y: int) -> int: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def signum(self, x: typing.Any) -> int: ...
        def times(self, x: int, y: int) -> int: ...
        def toDouble(self, x: int) -> float: ...
        def toFloat(self, x: int) -> float: ...
        def toInt(self, x: int) -> int: ...
        def toLong(self, x: int) -> int: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
        def zero(self) -> typing.Any: ...

_Ordering__OptionOrdering__T = typing.TypeVar('_Ordering__OptionOrdering__T')  # <T>
_Ordering__T = typing.TypeVar('_Ordering__T')  # <T>
class Ordering(java.util.Comparator[_Ordering__T], PartialOrdering[_Ordering__T], typing.Generic[_Ordering__T]):
    @staticmethod
    def $init$($this: 'Ordering') -> None: ...
    _Iterable__T = typing.TypeVar('_Iterable__T')  # <T>
    @staticmethod
    def Iterable(ord: 'Ordering'[_Iterable__T]) -> 'Ordering'[scala.collection.Iterable[_Iterable__T]]: ...
    _Option__T = typing.TypeVar('_Option__T')  # <T>
    @staticmethod
    def Option(ord: 'Ordering'[_Option__T]) -> 'Ordering'[scala.Option[_Option__T]]: ...
    _Tuple2__T1 = typing.TypeVar('_Tuple2__T1')  # <T1>
    _Tuple2__T2 = typing.TypeVar('_Tuple2__T2')  # <T2>
    @staticmethod
    def Tuple2(ord1: 'Ordering'[_Tuple2__T1], ord2: 'Ordering'[_Tuple2__T2]) -> 'Ordering'[scala.Tuple2[_Tuple2__T1, _Tuple2__T2]]: ...
    _Tuple3__T1 = typing.TypeVar('_Tuple3__T1')  # <T1>
    _Tuple3__T2 = typing.TypeVar('_Tuple3__T2')  # <T2>
    _Tuple3__T3 = typing.TypeVar('_Tuple3__T3')  # <T3>
    @staticmethod
    def Tuple3(ord1: 'Ordering'[_Tuple3__T1], ord2: 'Ordering'[_Tuple3__T2], ord3: 'Ordering'[_Tuple3__T3]) -> 'Ordering'[scala.Tuple3[_Tuple3__T1, _Tuple3__T2, _Tuple3__T3]]: ...
    _Tuple4__T1 = typing.TypeVar('_Tuple4__T1')  # <T1>
    _Tuple4__T2 = typing.TypeVar('_Tuple4__T2')  # <T2>
    _Tuple4__T3 = typing.TypeVar('_Tuple4__T3')  # <T3>
    _Tuple4__T4 = typing.TypeVar('_Tuple4__T4')  # <T4>
    @staticmethod
    def Tuple4(ord1: 'Ordering'[_Tuple4__T1], ord2: 'Ordering'[_Tuple4__T2], ord3: 'Ordering'[_Tuple4__T3], ord4: 'Ordering'[_Tuple4__T4]) -> 'Ordering'[scala.Tuple4[_Tuple4__T1, _Tuple4__T2, _Tuple4__T3, _Tuple4__T4]]: ...
    _Tuple5__T1 = typing.TypeVar('_Tuple5__T1')  # <T1>
    _Tuple5__T2 = typing.TypeVar('_Tuple5__T2')  # <T2>
    _Tuple5__T3 = typing.TypeVar('_Tuple5__T3')  # <T3>
    _Tuple5__T4 = typing.TypeVar('_Tuple5__T4')  # <T4>
    _Tuple5__T5 = typing.TypeVar('_Tuple5__T5')  # <T5>
    @staticmethod
    def Tuple5(ord1: 'Ordering'[_Tuple5__T1], ord2: 'Ordering'[_Tuple5__T2], ord3: 'Ordering'[_Tuple5__T3], ord4: 'Ordering'[_Tuple5__T4], ord5: 'Ordering'[_Tuple5__T5]) -> 'Ordering'[scala.Tuple5[_Tuple5__T1, _Tuple5__T2, _Tuple5__T3, _Tuple5__T4, _Tuple5__T5]]: ...
    _Tuple6__T1 = typing.TypeVar('_Tuple6__T1')  # <T1>
    _Tuple6__T2 = typing.TypeVar('_Tuple6__T2')  # <T2>
    _Tuple6__T3 = typing.TypeVar('_Tuple6__T3')  # <T3>
    _Tuple6__T4 = typing.TypeVar('_Tuple6__T4')  # <T4>
    _Tuple6__T5 = typing.TypeVar('_Tuple6__T5')  # <T5>
    _Tuple6__T6 = typing.TypeVar('_Tuple6__T6')  # <T6>
    @staticmethod
    def Tuple6(ord1: 'Ordering'[_Tuple6__T1], ord2: 'Ordering'[_Tuple6__T2], ord3: 'Ordering'[_Tuple6__T3], ord4: 'Ordering'[_Tuple6__T4], ord5: 'Ordering'[_Tuple6__T5], ord6: 'Ordering'[_Tuple6__T6]) -> 'Ordering'[scala.Tuple6[_Tuple6__T1, _Tuple6__T2, _Tuple6__T3, _Tuple6__T4, _Tuple6__T5, _Tuple6__T6]]: ...
    _Tuple7__T1 = typing.TypeVar('_Tuple7__T1')  # <T1>
    _Tuple7__T2 = typing.TypeVar('_Tuple7__T2')  # <T2>
    _Tuple7__T3 = typing.TypeVar('_Tuple7__T3')  # <T3>
    _Tuple7__T4 = typing.TypeVar('_Tuple7__T4')  # <T4>
    _Tuple7__T5 = typing.TypeVar('_Tuple7__T5')  # <T5>
    _Tuple7__T6 = typing.TypeVar('_Tuple7__T6')  # <T6>
    _Tuple7__T7 = typing.TypeVar('_Tuple7__T7')  # <T7>
    @staticmethod
    def Tuple7(ord1: 'Ordering'[_Tuple7__T1], ord2: 'Ordering'[_Tuple7__T2], ord3: 'Ordering'[_Tuple7__T3], ord4: 'Ordering'[_Tuple7__T4], ord5: 'Ordering'[_Tuple7__T5], ord6: 'Ordering'[_Tuple7__T6], ord7: 'Ordering'[_Tuple7__T7]) -> 'Ordering'[scala.Tuple7[_Tuple7__T1, _Tuple7__T2, _Tuple7__T3, _Tuple7__T4, _Tuple7__T5, _Tuple7__T6, _Tuple7__T7]]: ...
    _Tuple8__T1 = typing.TypeVar('_Tuple8__T1')  # <T1>
    _Tuple8__T2 = typing.TypeVar('_Tuple8__T2')  # <T2>
    _Tuple8__T3 = typing.TypeVar('_Tuple8__T3')  # <T3>
    _Tuple8__T4 = typing.TypeVar('_Tuple8__T4')  # <T4>
    _Tuple8__T5 = typing.TypeVar('_Tuple8__T5')  # <T5>
    _Tuple8__T6 = typing.TypeVar('_Tuple8__T6')  # <T6>
    _Tuple8__T7 = typing.TypeVar('_Tuple8__T7')  # <T7>
    _Tuple8__T8 = typing.TypeVar('_Tuple8__T8')  # <T8>
    @staticmethod
    def Tuple8(ord1: 'Ordering'[_Tuple8__T1], ord2: 'Ordering'[_Tuple8__T2], ord3: 'Ordering'[_Tuple8__T3], ord4: 'Ordering'[_Tuple8__T4], ord5: 'Ordering'[_Tuple8__T5], ord6: 'Ordering'[_Tuple8__T6], ord7: 'Ordering'[_Tuple8__T7], ord8: 'Ordering'[_Tuple8__T8]) -> 'Ordering'[scala.Tuple8[_Tuple8__T1, _Tuple8__T2, _Tuple8__T3, _Tuple8__T4, _Tuple8__T5, _Tuple8__T6, _Tuple8__T7, _Tuple8__T8]]: ...
    _Tuple9__T1 = typing.TypeVar('_Tuple9__T1')  # <T1>
    _Tuple9__T2 = typing.TypeVar('_Tuple9__T2')  # <T2>
    _Tuple9__T3 = typing.TypeVar('_Tuple9__T3')  # <T3>
    _Tuple9__T4 = typing.TypeVar('_Tuple9__T4')  # <T4>
    _Tuple9__T5 = typing.TypeVar('_Tuple9__T5')  # <T5>
    _Tuple9__T6 = typing.TypeVar('_Tuple9__T6')  # <T6>
    _Tuple9__T7 = typing.TypeVar('_Tuple9__T7')  # <T7>
    _Tuple9__T8 = typing.TypeVar('_Tuple9__T8')  # <T8>
    _Tuple9__T9 = typing.TypeVar('_Tuple9__T9')  # <T9>
    @staticmethod
    def Tuple9(ord1: 'Ordering'[_Tuple9__T1], ord2: 'Ordering'[_Tuple9__T2], ord3: 'Ordering'[_Tuple9__T3], ord4: 'Ordering'[_Tuple9__T4], ord5: 'Ordering'[_Tuple9__T5], ord6: 'Ordering'[_Tuple9__T6], ord7: 'Ordering'[_Tuple9__T7], ord8: 'Ordering'[_Tuple9__T8], ord9: 'Ordering'[_Tuple9__T9]) -> 'Ordering'[scala.Tuple9[_Tuple9__T1, _Tuple9__T2, _Tuple9__T3, _Tuple9__T4, _Tuple9__T5, _Tuple9__T6, _Tuple9__T7, _Tuple9__T8, _Tuple9__T9]]: ...
    _apply__T = typing.TypeVar('_apply__T')  # <T>
    @staticmethod
    def apply(ord: 'Ordering'[_apply__T]) -> 'Ordering'[_apply__T]: ...
    _by__T = typing.TypeVar('_by__T')  # <T>
    _by__S = typing.TypeVar('_by__S')  # <S>
    @staticmethod
    def by(f: scala.Function1[_by__T, _by__S], ord: 'Ordering'[_by__S]) -> 'Ordering'[_by__T]: ...
    _comparatorToOrdering__A = typing.TypeVar('_comparatorToOrdering__A')  # <A>
    @staticmethod
    def comparatorToOrdering(cmp: typing.Union[java.util.Comparator[_comparatorToOrdering__A], typing.Callable[[_comparatorToOrdering__A, _comparatorToOrdering__A], int]]) -> 'Ordering'[_comparatorToOrdering__A]: ...
    def compare(self, x: _Ordering__T, y: _Ordering__T) -> int: ...
    def equals(self, object: typing.Any) -> bool: ...
    def equiv(self, x: _Ordering__T, y: _Ordering__T) -> bool: ...
    _fromLessThan__T = typing.TypeVar('_fromLessThan__T')  # <T>
    @staticmethod
    def fromLessThan(cmp: scala.Function2[_fromLessThan__T, _fromLessThan__T, typing.Any]) -> 'Ordering'[_fromLessThan__T]: ...
    def gt(self, x: _Ordering__T, y: _Ordering__T) -> bool: ...
    def gteq(self, x: _Ordering__T, y: _Ordering__T) -> bool: ...
    def lt(self, x: _Ordering__T, y: _Ordering__T) -> bool: ...
    def lteq(self, x: _Ordering__T, y: _Ordering__T) -> bool: ...
    def max(self, x: _Ordering__T, y: _Ordering__T) -> _Ordering__T: ...
    def min(self, x: _Ordering__T, y: _Ordering__T) -> _Ordering__T: ...
    def mkOrderingOps(self, lhs: _Ordering__T) -> 'Ordering.Ops': ...
    _on__U = typing.TypeVar('_on__U')  # <U>
    def on(self, f: scala.Function1[_on__U, _Ordering__T]) -> 'Ordering'[_on__U]: ...
    _ordered__A = typing.TypeVar('_ordered__A')  # <A>
    @staticmethod
    def ordered(evidence$1: scala.Function1[_ordered__A, java.lang.Comparable[_ordered__A]]) -> 'Ordering'[_ordered__A]: ...
    @typing.overload
    def reverse(self) -> 'Ordering'[_Ordering__T]: ...
    @typing.overload
    def reverse(self) -> PartialOrdering[_Ordering__T]: ...
    @typing.overload
    def tryCompare(self, x: _Ordering__T, y: _Ordering__T) -> scala.Option[typing.Any]: ...
    @typing.overload
    def tryCompare(self, x: _Ordering__T, y: _Ordering__T) -> scala.Some[typing.Any]: ...
    class BigDecimal$(scala.math.Ordering.BigDecimalOrdering):
        MODULE$: typing.ClassVar['Ordering.BigDecimal.'] = ...
        def __init__(self): ...
        def compare(self, x: BigDecimal, y: BigDecimal) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, BigDecimal]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[BigDecimal]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class BigDecimalOrdering(scala.math.Ordering[BigDecimal]):
        @staticmethod
        def $init$($this: 'Ordering.BigDecimalOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: BigDecimal, y: BigDecimal) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
    class BigInt$(scala.math.Ordering.BigIntOrdering):
        MODULE$: typing.ClassVar['Ordering.BigInt.'] = ...
        def __init__(self): ...
        def compare(self, x: BigInt, y: BigInt) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, BigInt]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[BigInt]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class BigIntOrdering(scala.math.Ordering[BigInt]):
        @staticmethod
        def $init$($this: 'Ordering.BigIntOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: BigInt, y: BigInt) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
    class Boolean$(scala.math.Ordering.BooleanOrdering):
        MODULE$: typing.ClassVar['Ordering.Boolean.'] = ...
        def __init__(self): ...
        def compare(self, x: bool, y: bool) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class BooleanOrdering(scala.math.Ordering[typing.Any]):
        @staticmethod
        def $init$($this: 'Ordering.BooleanOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: bool, y: bool) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
    class Byte$(scala.math.Ordering.ByteOrdering):
        MODULE$: typing.ClassVar['Ordering.Byte.'] = ...
        def __init__(self): ...
        def compare(self, x: int, y: int) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class ByteOrdering(scala.math.Ordering[typing.Any]):
        @staticmethod
        def $init$($this: 'Ordering.ByteOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: int, y: int) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
    class Char$(scala.math.Ordering.CharOrdering):
        MODULE$: typing.ClassVar['Ordering.Char.'] = ...
        def __init__(self): ...
        def compare(self, x: str, y: str) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class CharOrdering(scala.math.Ordering[typing.Any]):
        @staticmethod
        def $init$($this: 'Ordering.CharOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: str, y: str) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
    class Double$(scala.math.Ordering.DoubleOrdering):
        MODULE$: typing.ClassVar['Ordering.Double.'] = ...
        def __init__(self): ...
        def compare(self, x: float, y: float) -> int: ...
        def equiv(self, x: float, y: float) -> bool: ...
        def gt(self, x: float, y: float) -> bool: ...
        def gteq(self, x: float, y: float) -> bool: ...
        def lt(self, x: float, y: float) -> bool: ...
        def lteq(self, x: float, y: float) -> bool: ...
        def max(self, x: float, y: float) -> float: ...
        def min(self, x: float, y: float) -> float: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class DoubleOrdering(scala.math.Ordering[typing.Any]):
        @staticmethod
        def $init$($this: 'Ordering.DoubleOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: float, y: float) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def equiv(self, x: float, y: float) -> bool: ...
        @typing.overload
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        @typing.overload
        def gt(self, x: float, y: float) -> bool: ...
        @typing.overload
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        @typing.overload
        def gteq(self, x: float, y: float) -> bool: ...
        @typing.overload
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        @typing.overload
        def lt(self, x: float, y: float) -> bool: ...
        @typing.overload
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        @typing.overload
        def lteq(self, x: float, y: float) -> bool: ...
        @typing.overload
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        @typing.overload
        def max(self, x: float, y: float) -> float: ...
        @typing.overload
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def min(self, x: float, y: float) -> float: ...
        @typing.overload
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        @typing.overload
        def reverse(self) -> PartialOrdering[typing.Any]: ...
    class ExtraImplicits:
        @staticmethod
        def $init$($this: 'Ordering.ExtraImplicits') -> None: ...
        _infixOrderingOps__T = typing.TypeVar('_infixOrderingOps__T')  # <T>
        def infixOrderingOps(self, x: _infixOrderingOps__T, ord: 'Ordering'[_infixOrderingOps__T]) -> 'Ordering.Ops': ...
        _seqDerivedOrdering__CC = typing.TypeVar('_seqDerivedOrdering__CC', bound=scala.collection.Seq)  # <CC>
        _seqDerivedOrdering__T = typing.TypeVar('_seqDerivedOrdering__T')  # <T>
        def seqDerivedOrdering(self, ord: 'Ordering'[_seqDerivedOrdering__T]) -> 'Ordering'[_seqDerivedOrdering__CC]: ...
    class Float$(scala.math.Ordering.FloatOrdering):
        MODULE$: typing.ClassVar['Ordering.Float.'] = ...
        def __init__(self): ...
        def compare(self, x: float, y: float) -> int: ...
        def equiv(self, x: float, y: float) -> bool: ...
        def gt(self, x: float, y: float) -> bool: ...
        def gteq(self, x: float, y: float) -> bool: ...
        def lt(self, x: float, y: float) -> bool: ...
        def lteq(self, x: float, y: float) -> bool: ...
        def max(self, x: float, y: float) -> float: ...
        def min(self, x: float, y: float) -> float: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class FloatOrdering(scala.math.Ordering[typing.Any]):
        @staticmethod
        def $init$($this: 'Ordering.FloatOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: float, y: float) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
        @typing.overload
        def equiv(self, x: float, y: float) -> bool: ...
        @typing.overload
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        @typing.overload
        def gt(self, x: float, y: float) -> bool: ...
        @typing.overload
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        @typing.overload
        def gteq(self, x: float, y: float) -> bool: ...
        @typing.overload
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        @typing.overload
        def lt(self, x: float, y: float) -> bool: ...
        @typing.overload
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        @typing.overload
        def lteq(self, x: float, y: float) -> bool: ...
        @typing.overload
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        @typing.overload
        def max(self, x: float, y: float) -> float: ...
        @typing.overload
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def min(self, x: float, y: float) -> float: ...
        @typing.overload
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        @typing.overload
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        @typing.overload
        def reverse(self) -> PartialOrdering[typing.Any]: ...
    class Implicits$(scala.math.Ordering.ExtraImplicits):
        MODULE$: typing.ClassVar['Ordering.Implicits.'] = ...
        def __init__(self): ...
        _infixOrderingOps__T = typing.TypeVar('_infixOrderingOps__T')  # <T>
        def infixOrderingOps(self, x: _infixOrderingOps__T, ord: 'Ordering'[_infixOrderingOps__T]) -> 'Ordering.Ops': ...
        _seqDerivedOrdering__CC = typing.TypeVar('_seqDerivedOrdering__CC', bound=scala.collection.Seq)  # <CC>
        _seqDerivedOrdering__T = typing.TypeVar('_seqDerivedOrdering__T')  # <T>
        def seqDerivedOrdering(self, ord: 'Ordering'[_seqDerivedOrdering__T]) -> 'Ordering'[_seqDerivedOrdering__CC]: ...
    class Int$(scala.math.Ordering.IntOrdering):
        MODULE$: typing.ClassVar['Ordering.Int.'] = ...
        def __init__(self): ...
        def compare(self, x: int, y: int) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class IntOrdering(scala.math.Ordering[typing.Any]):
        @staticmethod
        def $init$($this: 'Ordering.IntOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: int, y: int) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
    class Long$(scala.math.Ordering.LongOrdering):
        MODULE$: typing.ClassVar['Ordering.Long.'] = ...
        def __init__(self): ...
        def compare(self, x: int, y: int) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class LongOrdering(scala.math.Ordering[typing.Any]):
        @staticmethod
        def $init$($this: 'Ordering.LongOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: int, y: int) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
    class Ops:
        $outer: 'Ordering' = ...
        def __init__(self, $outer: 'Ordering', lhs: _Ordering__T): ...
        def $greater(self, rhs: _Ordering__T) -> bool: ...
        def $greater$eq(self, rhs: _Ordering__T) -> bool: ...
        def $less(self, rhs: _Ordering__T) -> bool: ...
        def $less$eq(self, rhs: _Ordering__T) -> bool: ...
        def equiv(self, rhs: _Ordering__T) -> bool: ...
        def max(self, rhs: _Ordering__T) -> _Ordering__T: ...
        def min(self, rhs: _Ordering__T) -> _Ordering__T: ...
    class OptionOrdering(scala.math.Ordering[scala.Option[_Ordering__OptionOrdering__T]], typing.Generic[_Ordering__OptionOrdering__T]):
        @staticmethod
        def $init$($this: 'Ordering.OptionOrdering') -> None: ...
        @typing.overload
        def compare(self, x: _Ordering__OptionOrdering__T, y: _Ordering__OptionOrdering__T) -> int: ...
        @typing.overload
        def compare(self, x: scala.Option[_Ordering__OptionOrdering__T], y: scala.Option[_Ordering__OptionOrdering__T]) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
        def optionOrdering(self) -> 'Ordering'[_Ordering__OptionOrdering__T]: ...
    class Short$(scala.math.Ordering.ShortOrdering):
        MODULE$: typing.ClassVar['Ordering.Short.'] = ...
        def __init__(self): ...
        def compare(self, x: int, y: int) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Any]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[typing.Any]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class ShortOrdering(scala.math.Ordering[typing.Any]):
        @staticmethod
        def $init$($this: 'Ordering.ShortOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: int, y: int) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
    class String$(scala.math.Ordering.StringOrdering):
        MODULE$: typing.ClassVar['Ordering.String.'] = ...
        def __init__(self): ...
        def compare(self, x: typing.Union[java.lang.String, str], y: typing.Union[java.lang.String, str]) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, typing.Union[java.lang.String, str]]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[java.lang.String]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class StringOrdering(scala.math.Ordering[java.lang.String]):
        @staticmethod
        def $init$($this: 'Ordering.StringOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: typing.Union[java.lang.String, str], y: typing.Union[java.lang.String, str]) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...
    class Unit$(scala.math.Ordering.UnitOrdering):
        MODULE$: typing.ClassVar['Ordering.Unit.'] = ...
        def __init__(self): ...
        def compare(self, x: scala.runtime.BoxedUnit, y: scala.runtime.BoxedUnit) -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> 'Ordering.Ops': ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, scala.runtime.BoxedUnit]) -> 'Ordering'[_on__U]: ...
        def reverse(self) -> 'Ordering'[scala.runtime.BoxedUnit]: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class UnitOrdering(scala.math.Ordering[scala.runtime.BoxedUnit]):
        @staticmethod
        def $init$($this: 'Ordering.UnitOrdering') -> None: ...
        @typing.overload
        def compare(self, x: typing.Any, y: typing.Any) -> int: ...
        @typing.overload
        def compare(self, x: scala.runtime.BoxedUnit, y: scala.runtime.BoxedUnit) -> int: ...
        def equals(self, object: typing.Any) -> bool: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("scala.math")``.

    BigDecimal: typing.Type[BigDecimal]
    BigInt: typing.Type[BigInt]
    Equiv: typing.Type[Equiv]
    Fractional: typing.Type[Fractional]
    Integral: typing.Type[Integral]
    LowPriorityEquiv: typing.Type[LowPriorityEquiv]
    LowPriorityOrderingImplicits: typing.Type[LowPriorityOrderingImplicits]
    Numeric: typing.Type[Numeric]
    Ordered: typing.Type[Ordered]
    Ordering: typing.Type[Ordering]
    PartialOrdering: typing.Type[PartialOrdering]
    PartiallyOrdered: typing.Type[PartiallyOrdered]
    ScalaNumber: typing.Type[ScalaNumber]
    ScalaNumericAnyConversions: typing.Type[ScalaNumericAnyConversions]
    ScalaNumericConversions: typing.Type[ScalaNumericConversions]
    package: typing.Type[package]
