import java.lang
import java.lang.ref
import scala
import typing



_Reference__T = typing.TypeVar('_Reference__T')  # <T>
class Reference(scala.Function0[_Reference__T], typing.Generic[_Reference__T]):
    @staticmethod
    def $init$($this: 'Reference') -> None: ...
    def apply(self) -> _Reference__T: ...
    def clear(self) -> None: ...
    def enqueue(self) -> bool: ...
    def get(self) -> scala.Option[_Reference__T]: ...
    def isEnqueued(self) -> bool: ...
    def toString(self) -> java.lang.String: ...

_ReferenceQueue__T = typing.TypeVar('_ReferenceQueue__T')  # <T>
class ReferenceQueue(typing.Generic[_ReferenceQueue__T]):
    def __init__(self): ...
    def Wrapper(self, jref: java.lang.ref.Reference[typing.Any]) -> scala.Option[Reference[_ReferenceQueue__T]]: ...
    def poll(self) -> scala.Option[Reference[_ReferenceQueue__T]]: ...
    @typing.overload
    def remove(self) -> scala.Option[Reference[_ReferenceQueue__T]]: ...
    @typing.overload
    def remove(self, timeout: int) -> scala.Option[Reference[_ReferenceQueue__T]]: ...
    def toString(self) -> java.lang.String: ...
    def underlying(self) -> java.lang.ref.ReferenceQueue[_ReferenceQueue__T]: ...

_ReferenceWithWrapper__T = typing.TypeVar('_ReferenceWithWrapper__T')  # <T>
class ReferenceWithWrapper(typing.Generic[_ReferenceWithWrapper__T]):
    def wrapper(self) -> 'ReferenceWrapper'[_ReferenceWithWrapper__T]: ...

_PhantomReferenceWithWrapper__T = typing.TypeVar('_PhantomReferenceWithWrapper__T')  # <T>
class PhantomReferenceWithWrapper(java.lang.ref.PhantomReference[_PhantomReferenceWithWrapper__T], ReferenceWithWrapper[_PhantomReferenceWithWrapper__T], typing.Generic[_PhantomReferenceWithWrapper__T]):
    def __init__(self, value: _PhantomReferenceWithWrapper__T, queue: ReferenceQueue[_PhantomReferenceWithWrapper__T], wrapper: 'PhantomReference'[_PhantomReferenceWithWrapper__T]): ...
    def wrapper(self) -> 'PhantomReference'[_PhantomReferenceWithWrapper__T]: ...

_ReferenceWrapper__T = typing.TypeVar('_ReferenceWrapper__T')  # <T>
class ReferenceWrapper(Reference[_ReferenceWrapper__T], scala.Proxy, typing.Generic[_ReferenceWrapper__T]):
    @staticmethod
    def $init$($this: 'ReferenceWrapper') -> None: ...
    def apply(self) -> _ReferenceWrapper__T: ...
    def clear(self) -> None: ...
    def enqueue(self) -> bool: ...
    def equals(self, that: typing.Any) -> bool: ...
    def get(self) -> scala.Option[_ReferenceWrapper__T]: ...
    def hashCode(self) -> int: ...
    def isEnqueued(self) -> bool: ...
    @typing.overload
    def self(self) -> typing.Any: ...
    @typing.overload
    def self(self) -> java.lang.ref.Reference[_ReferenceWrapper__T]: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    def underlying(self) -> java.lang.ref.Reference[_ReferenceWrapper__T]: ...

_SoftReferenceWithWrapper__T = typing.TypeVar('_SoftReferenceWithWrapper__T')  # <T>
class SoftReferenceWithWrapper(java.lang.ref.SoftReference[_SoftReferenceWithWrapper__T], ReferenceWithWrapper[_SoftReferenceWithWrapper__T], typing.Generic[_SoftReferenceWithWrapper__T]):
    def __init__(self, value: _SoftReferenceWithWrapper__T, queue: ReferenceQueue[_SoftReferenceWithWrapper__T], wrapper: 'SoftReference'[_SoftReferenceWithWrapper__T]): ...
    def wrapper(self) -> 'SoftReference'[_SoftReferenceWithWrapper__T]: ...

_WeakReferenceWithWrapper__T = typing.TypeVar('_WeakReferenceWithWrapper__T')  # <T>
class WeakReferenceWithWrapper(java.lang.ref.WeakReference[_WeakReferenceWithWrapper__T], ReferenceWithWrapper[_WeakReferenceWithWrapper__T], typing.Generic[_WeakReferenceWithWrapper__T]):
    def __init__(self, value: _WeakReferenceWithWrapper__T, queue: ReferenceQueue[_WeakReferenceWithWrapper__T], wrapper: 'WeakReference'[_WeakReferenceWithWrapper__T]): ...
    def wrapper(self) -> 'WeakReference'[_WeakReferenceWithWrapper__T]: ...

_PhantomReference__T = typing.TypeVar('_PhantomReference__T')  # <T>
class PhantomReference(ReferenceWrapper[_PhantomReference__T], typing.Generic[_PhantomReference__T]):
    def __init__(self, value: _PhantomReference__T, queue: ReferenceQueue[_PhantomReference__T]): ...
    def apply(self) -> _PhantomReference__T: ...
    def apply$mcB$sp(self) -> int: ...
    def apply$mcC$sp(self) -> str: ...
    def apply$mcD$sp(self) -> float: ...
    def apply$mcF$sp(self) -> float: ...
    def apply$mcI$sp(self) -> int: ...
    def apply$mcJ$sp(self) -> int: ...
    def apply$mcS$sp(self) -> int: ...
    def apply$mcV$sp(self) -> None: ...
    def apply$mcZ$sp(self) -> bool: ...
    def clear(self) -> None: ...
    def enqueue(self) -> bool: ...
    def equals(self, that: typing.Any) -> bool: ...
    def get(self) -> scala.Option[_PhantomReference__T]: ...
    def hashCode(self) -> int: ...
    def isEnqueued(self) -> bool: ...
    def self(self) -> java.lang.ref.Reference[_PhantomReference__T]: ...
    def toString(self) -> java.lang.String: ...
    def underlying(self) -> java.lang.ref.PhantomReference[_PhantomReference__T]: ...

_SoftReference__T = typing.TypeVar('_SoftReference__T')  # <T>
class SoftReference(ReferenceWrapper[_SoftReference__T], typing.Generic[_SoftReference__T]):
    @typing.overload
    def __init__(self, value: _SoftReference__T): ...
    @typing.overload
    def __init__(self, value: _SoftReference__T, queue: ReferenceQueue[_SoftReference__T]): ...
    def apply(self) -> _SoftReference__T: ...
    def apply$mcB$sp(self) -> int: ...
    def apply$mcC$sp(self) -> str: ...
    def apply$mcD$sp(self) -> float: ...
    def apply$mcF$sp(self) -> float: ...
    def apply$mcI$sp(self) -> int: ...
    def apply$mcJ$sp(self) -> int: ...
    def apply$mcS$sp(self) -> int: ...
    def apply$mcV$sp(self) -> None: ...
    def apply$mcZ$sp(self) -> bool: ...
    def clear(self) -> None: ...
    def enqueue(self) -> bool: ...
    def equals(self, that: typing.Any) -> bool: ...
    def get(self) -> scala.Option[_SoftReference__T]: ...
    def hashCode(self) -> int: ...
    def isEnqueued(self) -> bool: ...
    def self(self) -> java.lang.ref.Reference[_SoftReference__T]: ...
    def toString(self) -> java.lang.String: ...
    _unapply__T = typing.TypeVar('_unapply__T')  # <T>
    @staticmethod
    def unapply(sr: 'SoftReference'[_unapply__T]) -> scala.Option[_unapply__T]: ...
    def underlying(self) -> java.lang.ref.SoftReference[_SoftReference__T]: ...

_WeakReference__T = typing.TypeVar('_WeakReference__T')  # <T>
class WeakReference(ReferenceWrapper[_WeakReference__T], typing.Generic[_WeakReference__T]):
    @typing.overload
    def __init__(self, value: _WeakReference__T): ...
    @typing.overload
    def __init__(self, value: _WeakReference__T, queue: ReferenceQueue[_WeakReference__T]): ...
    def apply(self) -> _WeakReference__T: ...
    def apply$mcB$sp(self) -> int: ...
    def apply$mcC$sp(self) -> str: ...
    def apply$mcD$sp(self) -> float: ...
    def apply$mcF$sp(self) -> float: ...
    def apply$mcI$sp(self) -> int: ...
    def apply$mcJ$sp(self) -> int: ...
    def apply$mcS$sp(self) -> int: ...
    def apply$mcV$sp(self) -> None: ...
    def apply$mcZ$sp(self) -> bool: ...
    def clear(self) -> None: ...
    def enqueue(self) -> bool: ...
    def equals(self, that: typing.Any) -> bool: ...
    def get(self) -> scala.Option[_WeakReference__T]: ...
    def hashCode(self) -> int: ...
    def isEnqueued(self) -> bool: ...
    def self(self) -> java.lang.ref.Reference[_WeakReference__T]: ...
    def toString(self) -> java.lang.String: ...
    _unapply__T = typing.TypeVar('_unapply__T')  # <T>
    @staticmethod
    def unapply(wr: 'WeakReference'[_unapply__T]) -> scala.Option[_unapply__T]: ...
    def underlying(self) -> java.lang.ref.WeakReference[_WeakReference__T]: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("scala.ref")``.

    PhantomReference: typing.Type[PhantomReference]
    PhantomReferenceWithWrapper: typing.Type[PhantomReferenceWithWrapper]
    Reference: typing.Type[Reference]
    ReferenceQueue: typing.Type[ReferenceQueue]
    ReferenceWithWrapper: typing.Type[ReferenceWithWrapper]
    ReferenceWrapper: typing.Type[ReferenceWrapper]
    SoftReference: typing.Type[SoftReference]
    SoftReferenceWithWrapper: typing.Type[SoftReferenceWithWrapper]
    WeakReference: typing.Type[WeakReference]
    WeakReferenceWithWrapper: typing.Type[WeakReferenceWithWrapper]
