import java.util.concurrent
import scala
import scala.collection
import scala.math
import typing



class Deadline(scala.math.Ordered['Deadline'], scala.Product, scala.Serializable):
    def __init__(self, time: 'FiniteDuration'): ...
    def $greater(self, that: typing.Any) -> bool: ...
    def $greater$eq(self, that: typing.Any) -> bool: ...
    def $less(self, that: typing.Any) -> bool: ...
    def $less$eq(self, that: typing.Any) -> bool: ...
    @typing.overload
    def $minus(self, other: 'FiniteDuration') -> 'Deadline': ...
    @typing.overload
    def $minus(self, other: 'Deadline') -> 'FiniteDuration': ...
    def $plus(self, other: 'FiniteDuration') -> 'Deadline': ...
    @staticmethod
    def apply(time: 'FiniteDuration') -> 'Deadline': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def compare(self, other: 'Deadline') -> int: ...
    def compareTo(self, that: typing.Any) -> int: ...
    def copy(self, time: 'FiniteDuration') -> 'Deadline': ...
    def copy$default$1(self) -> 'FiniteDuration': ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hasTimeLeft(self) -> bool: ...
    def hashCode(self) -> int: ...
    def isOverdue(self) -> bool: ...
    @staticmethod
    def now() -> 'Deadline': ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> str: ...
    def time(self) -> 'FiniteDuration': ...
    def timeLeft(self) -> 'FiniteDuration': ...
    def toString(self) -> str: ...
    @staticmethod
    def unapply(x$0: 'Deadline') -> scala.Option['FiniteDuration']: ...
    class DeadlineIsOrdered$(scala.math.Ordering['Deadline']):
        MODULE$: typing.ClassVar['Deadline.DeadlineIsOrdered.'] = ...
        def __init__(self): ...
        def compare(self, a: 'Deadline', b: 'Deadline') -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> scala.math.Ordering.Ops: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, 'Deadline']) -> scala.math.Ordering[_on__U]: ...
        def reverse(self) -> scala.math.Ordering['Deadline']: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...

class Duration(scala.Serializable, scala.math.Ordered['Duration']):
    def __init__(self): ...
    @typing.overload
    def $div(self, divisor: 'Duration') -> float: ...
    @typing.overload
    def $div(self, divisor: float) -> 'Duration': ...
    def $greater(self, that: typing.Any) -> bool: ...
    def $greater$eq(self, that: typing.Any) -> bool: ...
    def $less(self, that: typing.Any) -> bool: ...
    def $less$eq(self, that: typing.Any) -> bool: ...
    def $minus(self, other: 'Duration') -> 'Duration': ...
    def $plus(self, other: 'Duration') -> 'Duration': ...
    def $times(self, factor: float) -> 'Duration': ...
    @staticmethod
    def Inf() -> 'Duration.Infinite': ...
    @staticmethod
    def MinusInf() -> 'Duration.Infinite': ...
    @staticmethod
    def Undefined() -> 'Duration.Infinite': ...
    @staticmethod
    def Zero() -> 'FiniteDuration': ...
    @typing.overload
    @staticmethod
    def apply(length: float, unit: java.util.concurrent.TimeUnit) -> 'Duration': ...
    @typing.overload
    @staticmethod
    def apply(s: str) -> 'Duration': ...
    @typing.overload
    @staticmethod
    def apply(length: int, unit: str) -> 'FiniteDuration': ...
    @typing.overload
    @staticmethod
    def apply(length: int, unit: java.util.concurrent.TimeUnit) -> 'FiniteDuration': ...
    def compareTo(self, that: typing.Any) -> int: ...
    @typing.overload
    @staticmethod
    def create(length: float, unit: java.util.concurrent.TimeUnit) -> 'Duration': ...
    @typing.overload
    @staticmethod
    def create(s: str) -> 'Duration': ...
    @typing.overload
    @staticmethod
    def create(length: int, unit: str) -> 'FiniteDuration': ...
    @typing.overload
    @staticmethod
    def create(length: int, unit: java.util.concurrent.TimeUnit) -> 'FiniteDuration': ...
    @typing.overload
    def div(self, other: 'Duration') -> float: ...
    @typing.overload
    def div(self, divisor: float) -> 'Duration': ...
    @typing.overload
    @staticmethod
    def fromNanos(nanos: float) -> 'Duration': ...
    @typing.overload
    @staticmethod
    def fromNanos(nanos: int) -> 'FiniteDuration': ...
    def gt(self, other: 'Duration') -> bool: ...
    def gteq(self, other: 'Duration') -> bool: ...
    def isFinite(self) -> bool: ...
    def length(self) -> int: ...
    def lt(self, other: 'Duration') -> bool: ...
    def lteq(self, other: 'Duration') -> bool: ...
    def max(self, other: 'Duration') -> 'Duration': ...
    def min(self, other: 'Duration') -> 'Duration': ...
    def minus(self, other: 'Duration') -> 'Duration': ...
    def mul(self, factor: float) -> 'Duration': ...
    def neg(self) -> 'Duration': ...
    def plus(self, other: 'Duration') -> 'Duration': ...
    def toCoarsest(self) -> 'Duration': ...
    def toDays(self) -> int: ...
    def toHours(self) -> int: ...
    def toMicros(self) -> int: ...
    def toMillis(self) -> int: ...
    def toMinutes(self) -> int: ...
    def toNanos(self) -> int: ...
    def toSeconds(self) -> int: ...
    def toUnit(self, unit: java.util.concurrent.TimeUnit) -> float: ...
    @typing.overload
    @staticmethod
    def unapply(s: str) -> scala.Option[scala.Tuple2[typing.Any, java.util.concurrent.TimeUnit]]: ...
    @typing.overload
    @staticmethod
    def unapply(d: 'Duration') -> scala.Option[scala.Tuple2[typing.Any, java.util.concurrent.TimeUnit]]: ...
    def unary_$minus(self) -> 'Duration': ...
    def unit(self) -> java.util.concurrent.TimeUnit: ...
    class DurationIsOrdered$(scala.math.Ordering['Duration']):
        MODULE$: typing.ClassVar['Duration.DurationIsOrdered.'] = ...
        def __init__(self): ...
        def compare(self, a: 'Duration', b: 'Duration') -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> scala.math.Ordering.Ops: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, 'Duration']) -> scala.math.Ordering[_on__U]: ...
        def reverse(self) -> scala.math.Ordering['Duration']: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...
    class Infinite(scala.concurrent.duration.Duration):
        def __init__(self): ...
        @typing.overload
        def $div(self, divisor: 'Duration') -> float: ...
        @typing.overload
        def $div(self, divisor: float) -> 'Duration': ...
        def $minus(self, other: 'Duration') -> 'Duration': ...
        def $plus(self, other: 'Duration') -> 'Duration': ...
        def $times(self, factor: float) -> 'Duration': ...
        def isFinite(self) -> bool: ...
        def length(self) -> int: ...
        def toCoarsest(self) -> 'Duration': ...
        def toDays(self) -> int: ...
        def toHours(self) -> int: ...
        def toMicros(self) -> int: ...
        def toMillis(self) -> int: ...
        def toMinutes(self) -> int: ...
        def toNanos(self) -> int: ...
        def toSeconds(self) -> int: ...
        def unit(self) -> java.util.concurrent.TimeUnit: ...

_DurationConversions__Classifier__C = typing.TypeVar('_DurationConversions__Classifier__C')  # <C>
class DurationConversions:
    @staticmethod
    def $init$($this: 'DurationConversions') -> None: ...
    _day_0__C = typing.TypeVar('_day_0__C')  # <C>
    @typing.overload
    def day(self, c: _day_0__C, ev: 'DurationConversions.Classifier'[_day_0__C]) -> typing.Any: ...
    @typing.overload
    def day(self) -> 'FiniteDuration': ...
    _days_0__C = typing.TypeVar('_days_0__C')  # <C>
    @typing.overload
    def days(self, c: _days_0__C, ev: 'DurationConversions.Classifier'[_days_0__C]) -> typing.Any: ...
    @typing.overload
    def days(self) -> 'FiniteDuration': ...
    def durationIn(self, unit: java.util.concurrent.TimeUnit) -> 'FiniteDuration': ...
    _hour_0__C = typing.TypeVar('_hour_0__C')  # <C>
    @typing.overload
    def hour(self, c: _hour_0__C, ev: 'DurationConversions.Classifier'[_hour_0__C]) -> typing.Any: ...
    @typing.overload
    def hour(self) -> 'FiniteDuration': ...
    _hours_0__C = typing.TypeVar('_hours_0__C')  # <C>
    @typing.overload
    def hours(self, c: _hours_0__C, ev: 'DurationConversions.Classifier'[_hours_0__C]) -> typing.Any: ...
    @typing.overload
    def hours(self) -> 'FiniteDuration': ...
    _micro_0__C = typing.TypeVar('_micro_0__C')  # <C>
    @typing.overload
    def micro(self, c: _micro_0__C, ev: 'DurationConversions.Classifier'[_micro_0__C]) -> typing.Any: ...
    @typing.overload
    def micro(self) -> 'FiniteDuration': ...
    _micros_0__C = typing.TypeVar('_micros_0__C')  # <C>
    @typing.overload
    def micros(self, c: _micros_0__C, ev: 'DurationConversions.Classifier'[_micros_0__C]) -> typing.Any: ...
    @typing.overload
    def micros(self) -> 'FiniteDuration': ...
    _microsecond_0__C = typing.TypeVar('_microsecond_0__C')  # <C>
    @typing.overload
    def microsecond(self, c: _microsecond_0__C, ev: 'DurationConversions.Classifier'[_microsecond_0__C]) -> typing.Any: ...
    @typing.overload
    def microsecond(self) -> 'FiniteDuration': ...
    _microseconds_0__C = typing.TypeVar('_microseconds_0__C')  # <C>
    @typing.overload
    def microseconds(self, c: _microseconds_0__C, ev: 'DurationConversions.Classifier'[_microseconds_0__C]) -> typing.Any: ...
    @typing.overload
    def microseconds(self) -> 'FiniteDuration': ...
    _milli_0__C = typing.TypeVar('_milli_0__C')  # <C>
    @typing.overload
    def milli(self, c: _milli_0__C, ev: 'DurationConversions.Classifier'[_milli_0__C]) -> typing.Any: ...
    @typing.overload
    def milli(self) -> 'FiniteDuration': ...
    _millis_0__C = typing.TypeVar('_millis_0__C')  # <C>
    @typing.overload
    def millis(self, c: _millis_0__C, ev: 'DurationConversions.Classifier'[_millis_0__C]) -> typing.Any: ...
    @typing.overload
    def millis(self) -> 'FiniteDuration': ...
    _millisecond_0__C = typing.TypeVar('_millisecond_0__C')  # <C>
    @typing.overload
    def millisecond(self, c: _millisecond_0__C, ev: 'DurationConversions.Classifier'[_millisecond_0__C]) -> typing.Any: ...
    @typing.overload
    def millisecond(self) -> 'FiniteDuration': ...
    _milliseconds_0__C = typing.TypeVar('_milliseconds_0__C')  # <C>
    @typing.overload
    def milliseconds(self, c: _milliseconds_0__C, ev: 'DurationConversions.Classifier'[_milliseconds_0__C]) -> typing.Any: ...
    @typing.overload
    def milliseconds(self) -> 'FiniteDuration': ...
    _minute_0__C = typing.TypeVar('_minute_0__C')  # <C>
    @typing.overload
    def minute(self, c: _minute_0__C, ev: 'DurationConversions.Classifier'[_minute_0__C]) -> typing.Any: ...
    @typing.overload
    def minute(self) -> 'FiniteDuration': ...
    _minutes_0__C = typing.TypeVar('_minutes_0__C')  # <C>
    @typing.overload
    def minutes(self, c: _minutes_0__C, ev: 'DurationConversions.Classifier'[_minutes_0__C]) -> typing.Any: ...
    @typing.overload
    def minutes(self) -> 'FiniteDuration': ...
    _nano_0__C = typing.TypeVar('_nano_0__C')  # <C>
    @typing.overload
    def nano(self, c: _nano_0__C, ev: 'DurationConversions.Classifier'[_nano_0__C]) -> typing.Any: ...
    @typing.overload
    def nano(self) -> 'FiniteDuration': ...
    _nanos_0__C = typing.TypeVar('_nanos_0__C')  # <C>
    @typing.overload
    def nanos(self, c: _nanos_0__C, ev: 'DurationConversions.Classifier'[_nanos_0__C]) -> typing.Any: ...
    @typing.overload
    def nanos(self) -> 'FiniteDuration': ...
    _nanosecond_0__C = typing.TypeVar('_nanosecond_0__C')  # <C>
    @typing.overload
    def nanosecond(self, c: _nanosecond_0__C, ev: 'DurationConversions.Classifier'[_nanosecond_0__C]) -> typing.Any: ...
    @typing.overload
    def nanosecond(self) -> 'FiniteDuration': ...
    _nanoseconds_0__C = typing.TypeVar('_nanoseconds_0__C')  # <C>
    @typing.overload
    def nanoseconds(self, c: _nanoseconds_0__C, ev: 'DurationConversions.Classifier'[_nanoseconds_0__C]) -> typing.Any: ...
    @typing.overload
    def nanoseconds(self) -> 'FiniteDuration': ...
    _second_0__C = typing.TypeVar('_second_0__C')  # <C>
    @typing.overload
    def second(self, c: _second_0__C, ev: 'DurationConversions.Classifier'[_second_0__C]) -> typing.Any: ...
    @typing.overload
    def second(self) -> 'FiniteDuration': ...
    _seconds_0__C = typing.TypeVar('_seconds_0__C')  # <C>
    @typing.overload
    def seconds(self, c: _seconds_0__C, ev: 'DurationConversions.Classifier'[_seconds_0__C]) -> typing.Any: ...
    @typing.overload
    def seconds(self) -> 'FiniteDuration': ...
    class Classifier(typing.Generic[_DurationConversions__Classifier__C]):
        def convert(self, d: 'FiniteDuration') -> typing.Any: ...
    class fromNowConvert$(scala.concurrent.duration.DurationConversions.Classifier['package.fromNow.']):
        MODULE$: typing.ClassVar['DurationConversions.fromNowConvert.'] = ...
        def __init__(self): ...
        def convert(self, d: 'FiniteDuration') -> Deadline: ...
    class spanConvert$(scala.concurrent.duration.DurationConversions.Classifier['package.span.']):
        MODULE$: typing.ClassVar['DurationConversions.spanConvert.'] = ...
        def __init__(self): ...
        def convert(self, d: 'FiniteDuration') -> 'FiniteDuration': ...

class FiniteDuration(Duration):
    def __init__(self, length: int, unit: java.util.concurrent.TimeUnit): ...
    @typing.overload
    def $div(self, divisor: Duration) -> float: ...
    @typing.overload
    def $div(self, divisor: float) -> Duration: ...
    @typing.overload
    def $div(self, divisor: int) -> 'FiniteDuration': ...
    @typing.overload
    def $minus(self, other: Duration) -> Duration: ...
    @typing.overload
    def $minus(self, other: 'FiniteDuration') -> 'FiniteDuration': ...
    @typing.overload
    def $plus(self, other: Duration) -> Duration: ...
    @typing.overload
    def $plus(self, other: 'FiniteDuration') -> 'FiniteDuration': ...
    @typing.overload
    def $times(self, factor: float) -> Duration: ...
    @typing.overload
    def $times(self, factor: int) -> 'FiniteDuration': ...
    @typing.overload
    @staticmethod
    def apply(length: float, unit: java.util.concurrent.TimeUnit) -> Duration: ...
    @typing.overload
    @staticmethod
    def apply(s: str) -> Duration: ...
    @typing.overload
    @staticmethod
    def apply(length: int, unit: str) -> 'FiniteDuration': ...
    @typing.overload
    @staticmethod
    def apply(length: int, unit: java.util.concurrent.TimeUnit) -> 'FiniteDuration': ...
    def compare(self, other: Duration) -> int: ...
    @typing.overload
    def div(self, other: Duration) -> float: ...
    @typing.overload
    def div(self, divisor: float) -> Duration: ...
    @typing.overload
    def div(self, divisor: int) -> 'FiniteDuration': ...
    def equals(self, other: typing.Any) -> bool: ...
    def fromNow(self) -> Deadline: ...
    def hashCode(self) -> int: ...
    def isFinite(self) -> bool: ...
    def length(self) -> int: ...
    @typing.overload
    def max(self, other: Duration) -> Duration: ...
    @typing.overload
    def max(self, other: 'FiniteDuration') -> 'FiniteDuration': ...
    @typing.overload
    def min(self, other: Duration) -> Duration: ...
    @typing.overload
    def min(self, other: 'FiniteDuration') -> 'FiniteDuration': ...
    @typing.overload
    def minus(self, other: Duration) -> Duration: ...
    @typing.overload
    def minus(self, other: 'FiniteDuration') -> 'FiniteDuration': ...
    @typing.overload
    def mul(self, factor: float) -> Duration: ...
    @typing.overload
    def mul(self, factor: int) -> 'FiniteDuration': ...
    @typing.overload
    def plus(self, other: Duration) -> Duration: ...
    @typing.overload
    def plus(self, other: 'FiniteDuration') -> 'FiniteDuration': ...
    def toCoarsest(self) -> 'FiniteDuration': ...
    def toDays(self) -> int: ...
    def toHours(self) -> int: ...
    def toMicros(self) -> int: ...
    def toMillis(self) -> int: ...
    def toMinutes(self) -> int: ...
    def toNanos(self) -> int: ...
    def toSeconds(self) -> int: ...
    def toString(self) -> str: ...
    def toUnit(self, u: java.util.concurrent.TimeUnit) -> float: ...
    def unary_$minus(self) -> 'FiniteDuration': ...
    def unit(self) -> java.util.concurrent.TimeUnit: ...
    class FiniteDurationIsOrdered$(scala.math.Ordering['FiniteDuration']):
        MODULE$: typing.ClassVar['FiniteDuration.FiniteDurationIsOrdered.'] = ...
        def __init__(self): ...
        def compare(self, a: 'FiniteDuration', b: 'FiniteDuration') -> int: ...
        def equiv(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def gteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lt(self, x: typing.Any, y: typing.Any) -> bool: ...
        def lteq(self, x: typing.Any, y: typing.Any) -> bool: ...
        def max(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def min(self, x: typing.Any, y: typing.Any) -> typing.Any: ...
        def mkOrderingOps(self, lhs: typing.Any) -> scala.math.Ordering.Ops: ...
        _on__U = typing.TypeVar('_on__U')  # <U>
        def on(self, f: scala.Function1[_on__U, 'FiniteDuration']) -> scala.math.Ordering[_on__U]: ...
        def reverse(self) -> scala.math.Ordering['FiniteDuration']: ...
        def tryCompare(self, x: typing.Any, y: typing.Any) -> scala.Some: ...

class package:
    @staticmethod
    def DAYS() -> java.util.concurrent.TimeUnit: ...
    @staticmethod
    def HOURS() -> java.util.concurrent.TimeUnit: ...
    @staticmethod
    def MICROSECONDS() -> java.util.concurrent.TimeUnit: ...
    @staticmethod
    def MILLISECONDS() -> java.util.concurrent.TimeUnit: ...
    @staticmethod
    def MINUTES() -> java.util.concurrent.TimeUnit: ...
    @staticmethod
    def NANOSECONDS() -> java.util.concurrent.TimeUnit: ...
    @staticmethod
    def SECONDS() -> java.util.concurrent.TimeUnit: ...
    @staticmethod
    def durationToPair(d: Duration) -> scala.Tuple2[typing.Any, java.util.concurrent.TimeUnit]: ...
    @staticmethod
    def pairIntToDuration(p: scala.Tuple2[typing.Any, java.util.concurrent.TimeUnit]) -> Duration: ...
    @staticmethod
    def pairLongToDuration(p: scala.Tuple2[typing.Any, java.util.concurrent.TimeUnit]) -> FiniteDuration: ...
    class DoubleMult:
        def __init__(self, f: float): ...
        def $times(self, d: Duration) -> Duration: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def scala$concurrent$duration$DoubleMult$$f(self) -> float: ...
    class DoubleMult$:
        MODULE$: typing.ClassVar['package.DoubleMult.'] = ...
        def __init__(self): ...
        def $times$extension(self, $this: float, d: Duration) -> Duration: ...
        def equals$extension(self, $this: float, x$1: typing.Any) -> bool: ...
        def hashCode$extension(self, $this: float) -> int: ...
    class DurationDouble(DurationConversions):
        def __init__(self, d: float): ...
        _day_0__C = typing.TypeVar('_day_0__C')  # <C>
        @typing.overload
        def day(self, c: _day_0__C, ev: DurationConversions.Classifier[_day_0__C]) -> typing.Any: ...
        @typing.overload
        def day(self) -> FiniteDuration: ...
        _days_0__C = typing.TypeVar('_days_0__C')  # <C>
        @typing.overload
        def days(self, c: _days_0__C, ev: DurationConversions.Classifier[_days_0__C]) -> typing.Any: ...
        @typing.overload
        def days(self) -> FiniteDuration: ...
        def durationIn(self, unit: java.util.concurrent.TimeUnit) -> FiniteDuration: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        _hour_0__C = typing.TypeVar('_hour_0__C')  # <C>
        @typing.overload
        def hour(self, c: _hour_0__C, ev: DurationConversions.Classifier[_hour_0__C]) -> typing.Any: ...
        @typing.overload
        def hour(self) -> FiniteDuration: ...
        _hours_0__C = typing.TypeVar('_hours_0__C')  # <C>
        @typing.overload
        def hours(self, c: _hours_0__C, ev: DurationConversions.Classifier[_hours_0__C]) -> typing.Any: ...
        @typing.overload
        def hours(self) -> FiniteDuration: ...
        _micro_0__C = typing.TypeVar('_micro_0__C')  # <C>
        @typing.overload
        def micro(self, c: _micro_0__C, ev: DurationConversions.Classifier[_micro_0__C]) -> typing.Any: ...
        @typing.overload
        def micro(self) -> FiniteDuration: ...
        _micros_0__C = typing.TypeVar('_micros_0__C')  # <C>
        @typing.overload
        def micros(self, c: _micros_0__C, ev: DurationConversions.Classifier[_micros_0__C]) -> typing.Any: ...
        @typing.overload
        def micros(self) -> FiniteDuration: ...
        _microsecond_0__C = typing.TypeVar('_microsecond_0__C')  # <C>
        @typing.overload
        def microsecond(self, c: _microsecond_0__C, ev: DurationConversions.Classifier[_microsecond_0__C]) -> typing.Any: ...
        @typing.overload
        def microsecond(self) -> FiniteDuration: ...
        _microseconds_0__C = typing.TypeVar('_microseconds_0__C')  # <C>
        @typing.overload
        def microseconds(self, c: _microseconds_0__C, ev: DurationConversions.Classifier[_microseconds_0__C]) -> typing.Any: ...
        @typing.overload
        def microseconds(self) -> FiniteDuration: ...
        _milli_0__C = typing.TypeVar('_milli_0__C')  # <C>
        @typing.overload
        def milli(self, c: _milli_0__C, ev: DurationConversions.Classifier[_milli_0__C]) -> typing.Any: ...
        @typing.overload
        def milli(self) -> FiniteDuration: ...
        _millis_0__C = typing.TypeVar('_millis_0__C')  # <C>
        @typing.overload
        def millis(self, c: _millis_0__C, ev: DurationConversions.Classifier[_millis_0__C]) -> typing.Any: ...
        @typing.overload
        def millis(self) -> FiniteDuration: ...
        _millisecond_0__C = typing.TypeVar('_millisecond_0__C')  # <C>
        @typing.overload
        def millisecond(self, c: _millisecond_0__C, ev: DurationConversions.Classifier[_millisecond_0__C]) -> typing.Any: ...
        @typing.overload
        def millisecond(self) -> FiniteDuration: ...
        _milliseconds_0__C = typing.TypeVar('_milliseconds_0__C')  # <C>
        @typing.overload
        def milliseconds(self, c: _milliseconds_0__C, ev: DurationConversions.Classifier[_milliseconds_0__C]) -> typing.Any: ...
        @typing.overload
        def milliseconds(self) -> FiniteDuration: ...
        _minute_0__C = typing.TypeVar('_minute_0__C')  # <C>
        @typing.overload
        def minute(self, c: _minute_0__C, ev: DurationConversions.Classifier[_minute_0__C]) -> typing.Any: ...
        @typing.overload
        def minute(self) -> FiniteDuration: ...
        _minutes_0__C = typing.TypeVar('_minutes_0__C')  # <C>
        @typing.overload
        def minutes(self, c: _minutes_0__C, ev: DurationConversions.Classifier[_minutes_0__C]) -> typing.Any: ...
        @typing.overload
        def minutes(self) -> FiniteDuration: ...
        _nano_0__C = typing.TypeVar('_nano_0__C')  # <C>
        @typing.overload
        def nano(self, c: _nano_0__C, ev: DurationConversions.Classifier[_nano_0__C]) -> typing.Any: ...
        @typing.overload
        def nano(self) -> FiniteDuration: ...
        _nanos_0__C = typing.TypeVar('_nanos_0__C')  # <C>
        @typing.overload
        def nanos(self, c: _nanos_0__C, ev: DurationConversions.Classifier[_nanos_0__C]) -> typing.Any: ...
        @typing.overload
        def nanos(self) -> FiniteDuration: ...
        _nanosecond_0__C = typing.TypeVar('_nanosecond_0__C')  # <C>
        @typing.overload
        def nanosecond(self, c: _nanosecond_0__C, ev: DurationConversions.Classifier[_nanosecond_0__C]) -> typing.Any: ...
        @typing.overload
        def nanosecond(self) -> FiniteDuration: ...
        _nanoseconds_0__C = typing.TypeVar('_nanoseconds_0__C')  # <C>
        @typing.overload
        def nanoseconds(self, c: _nanoseconds_0__C, ev: DurationConversions.Classifier[_nanoseconds_0__C]) -> typing.Any: ...
        @typing.overload
        def nanoseconds(self) -> FiniteDuration: ...
        def scala$concurrent$duration$DurationDouble$$d(self) -> float: ...
        _second_0__C = typing.TypeVar('_second_0__C')  # <C>
        @typing.overload
        def second(self, c: _second_0__C, ev: DurationConversions.Classifier[_second_0__C]) -> typing.Any: ...
        @typing.overload
        def second(self) -> FiniteDuration: ...
        _seconds_0__C = typing.TypeVar('_seconds_0__C')  # <C>
        @typing.overload
        def seconds(self, c: _seconds_0__C, ev: DurationConversions.Classifier[_seconds_0__C]) -> typing.Any: ...
        @typing.overload
        def seconds(self) -> FiniteDuration: ...
    class DurationDouble$:
        MODULE$: typing.ClassVar['package.DurationDouble.'] = ...
        def __init__(self): ...
        def durationIn$extension(self, $this: float, unit: java.util.concurrent.TimeUnit) -> FiniteDuration: ...
        def equals$extension(self, $this: float, x$1: typing.Any) -> bool: ...
        def hashCode$extension(self, $this: float) -> int: ...
    class DurationInt(DurationConversions):
        def __init__(self, n: int): ...
        _day_0__C = typing.TypeVar('_day_0__C')  # <C>
        @typing.overload
        def day(self, c: _day_0__C, ev: DurationConversions.Classifier[_day_0__C]) -> typing.Any: ...
        @typing.overload
        def day(self) -> FiniteDuration: ...
        _days_0__C = typing.TypeVar('_days_0__C')  # <C>
        @typing.overload
        def days(self, c: _days_0__C, ev: DurationConversions.Classifier[_days_0__C]) -> typing.Any: ...
        @typing.overload
        def days(self) -> FiniteDuration: ...
        def durationIn(self, unit: java.util.concurrent.TimeUnit) -> FiniteDuration: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        _hour_0__C = typing.TypeVar('_hour_0__C')  # <C>
        @typing.overload
        def hour(self, c: _hour_0__C, ev: DurationConversions.Classifier[_hour_0__C]) -> typing.Any: ...
        @typing.overload
        def hour(self) -> FiniteDuration: ...
        _hours_0__C = typing.TypeVar('_hours_0__C')  # <C>
        @typing.overload
        def hours(self, c: _hours_0__C, ev: DurationConversions.Classifier[_hours_0__C]) -> typing.Any: ...
        @typing.overload
        def hours(self) -> FiniteDuration: ...
        _micro_0__C = typing.TypeVar('_micro_0__C')  # <C>
        @typing.overload
        def micro(self, c: _micro_0__C, ev: DurationConversions.Classifier[_micro_0__C]) -> typing.Any: ...
        @typing.overload
        def micro(self) -> FiniteDuration: ...
        _micros_0__C = typing.TypeVar('_micros_0__C')  # <C>
        @typing.overload
        def micros(self, c: _micros_0__C, ev: DurationConversions.Classifier[_micros_0__C]) -> typing.Any: ...
        @typing.overload
        def micros(self) -> FiniteDuration: ...
        _microsecond_0__C = typing.TypeVar('_microsecond_0__C')  # <C>
        @typing.overload
        def microsecond(self, c: _microsecond_0__C, ev: DurationConversions.Classifier[_microsecond_0__C]) -> typing.Any: ...
        @typing.overload
        def microsecond(self) -> FiniteDuration: ...
        _microseconds_0__C = typing.TypeVar('_microseconds_0__C')  # <C>
        @typing.overload
        def microseconds(self, c: _microseconds_0__C, ev: DurationConversions.Classifier[_microseconds_0__C]) -> typing.Any: ...
        @typing.overload
        def microseconds(self) -> FiniteDuration: ...
        _milli_0__C = typing.TypeVar('_milli_0__C')  # <C>
        @typing.overload
        def milli(self, c: _milli_0__C, ev: DurationConversions.Classifier[_milli_0__C]) -> typing.Any: ...
        @typing.overload
        def milli(self) -> FiniteDuration: ...
        _millis_0__C = typing.TypeVar('_millis_0__C')  # <C>
        @typing.overload
        def millis(self, c: _millis_0__C, ev: DurationConversions.Classifier[_millis_0__C]) -> typing.Any: ...
        @typing.overload
        def millis(self) -> FiniteDuration: ...
        _millisecond_0__C = typing.TypeVar('_millisecond_0__C')  # <C>
        @typing.overload
        def millisecond(self, c: _millisecond_0__C, ev: DurationConversions.Classifier[_millisecond_0__C]) -> typing.Any: ...
        @typing.overload
        def millisecond(self) -> FiniteDuration: ...
        _milliseconds_0__C = typing.TypeVar('_milliseconds_0__C')  # <C>
        @typing.overload
        def milliseconds(self, c: _milliseconds_0__C, ev: DurationConversions.Classifier[_milliseconds_0__C]) -> typing.Any: ...
        @typing.overload
        def milliseconds(self) -> FiniteDuration: ...
        _minute_0__C = typing.TypeVar('_minute_0__C')  # <C>
        @typing.overload
        def minute(self, c: _minute_0__C, ev: DurationConversions.Classifier[_minute_0__C]) -> typing.Any: ...
        @typing.overload
        def minute(self) -> FiniteDuration: ...
        _minutes_0__C = typing.TypeVar('_minutes_0__C')  # <C>
        @typing.overload
        def minutes(self, c: _minutes_0__C, ev: DurationConversions.Classifier[_minutes_0__C]) -> typing.Any: ...
        @typing.overload
        def minutes(self) -> FiniteDuration: ...
        _nano_0__C = typing.TypeVar('_nano_0__C')  # <C>
        @typing.overload
        def nano(self, c: _nano_0__C, ev: DurationConversions.Classifier[_nano_0__C]) -> typing.Any: ...
        @typing.overload
        def nano(self) -> FiniteDuration: ...
        _nanos_0__C = typing.TypeVar('_nanos_0__C')  # <C>
        @typing.overload
        def nanos(self, c: _nanos_0__C, ev: DurationConversions.Classifier[_nanos_0__C]) -> typing.Any: ...
        @typing.overload
        def nanos(self) -> FiniteDuration: ...
        _nanosecond_0__C = typing.TypeVar('_nanosecond_0__C')  # <C>
        @typing.overload
        def nanosecond(self, c: _nanosecond_0__C, ev: DurationConversions.Classifier[_nanosecond_0__C]) -> typing.Any: ...
        @typing.overload
        def nanosecond(self) -> FiniteDuration: ...
        _nanoseconds_0__C = typing.TypeVar('_nanoseconds_0__C')  # <C>
        @typing.overload
        def nanoseconds(self, c: _nanoseconds_0__C, ev: DurationConversions.Classifier[_nanoseconds_0__C]) -> typing.Any: ...
        @typing.overload
        def nanoseconds(self) -> FiniteDuration: ...
        def scala$concurrent$duration$DurationInt$$n(self) -> int: ...
        _second_0__C = typing.TypeVar('_second_0__C')  # <C>
        @typing.overload
        def second(self, c: _second_0__C, ev: DurationConversions.Classifier[_second_0__C]) -> typing.Any: ...
        @typing.overload
        def second(self) -> FiniteDuration: ...
        _seconds_0__C = typing.TypeVar('_seconds_0__C')  # <C>
        @typing.overload
        def seconds(self, c: _seconds_0__C, ev: DurationConversions.Classifier[_seconds_0__C]) -> typing.Any: ...
        @typing.overload
        def seconds(self) -> FiniteDuration: ...
    class DurationInt$:
        MODULE$: typing.ClassVar['package.DurationInt.'] = ...
        def __init__(self): ...
        def durationIn$extension(self, $this: int, unit: java.util.concurrent.TimeUnit) -> FiniteDuration: ...
        def equals$extension(self, $this: int, x$1: typing.Any) -> bool: ...
        def hashCode$extension(self, $this: int) -> int: ...
    class DurationLong(DurationConversions):
        def __init__(self, n: int): ...
        _day_0__C = typing.TypeVar('_day_0__C')  # <C>
        @typing.overload
        def day(self, c: _day_0__C, ev: DurationConversions.Classifier[_day_0__C]) -> typing.Any: ...
        @typing.overload
        def day(self) -> FiniteDuration: ...
        _days_0__C = typing.TypeVar('_days_0__C')  # <C>
        @typing.overload
        def days(self, c: _days_0__C, ev: DurationConversions.Classifier[_days_0__C]) -> typing.Any: ...
        @typing.overload
        def days(self) -> FiniteDuration: ...
        def durationIn(self, unit: java.util.concurrent.TimeUnit) -> FiniteDuration: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        _hour_0__C = typing.TypeVar('_hour_0__C')  # <C>
        @typing.overload
        def hour(self, c: _hour_0__C, ev: DurationConversions.Classifier[_hour_0__C]) -> typing.Any: ...
        @typing.overload
        def hour(self) -> FiniteDuration: ...
        _hours_0__C = typing.TypeVar('_hours_0__C')  # <C>
        @typing.overload
        def hours(self, c: _hours_0__C, ev: DurationConversions.Classifier[_hours_0__C]) -> typing.Any: ...
        @typing.overload
        def hours(self) -> FiniteDuration: ...
        _micro_0__C = typing.TypeVar('_micro_0__C')  # <C>
        @typing.overload
        def micro(self, c: _micro_0__C, ev: DurationConversions.Classifier[_micro_0__C]) -> typing.Any: ...
        @typing.overload
        def micro(self) -> FiniteDuration: ...
        _micros_0__C = typing.TypeVar('_micros_0__C')  # <C>
        @typing.overload
        def micros(self, c: _micros_0__C, ev: DurationConversions.Classifier[_micros_0__C]) -> typing.Any: ...
        @typing.overload
        def micros(self) -> FiniteDuration: ...
        _microsecond_0__C = typing.TypeVar('_microsecond_0__C')  # <C>
        @typing.overload
        def microsecond(self, c: _microsecond_0__C, ev: DurationConversions.Classifier[_microsecond_0__C]) -> typing.Any: ...
        @typing.overload
        def microsecond(self) -> FiniteDuration: ...
        _microseconds_0__C = typing.TypeVar('_microseconds_0__C')  # <C>
        @typing.overload
        def microseconds(self, c: _microseconds_0__C, ev: DurationConversions.Classifier[_microseconds_0__C]) -> typing.Any: ...
        @typing.overload
        def microseconds(self) -> FiniteDuration: ...
        _milli_0__C = typing.TypeVar('_milli_0__C')  # <C>
        @typing.overload
        def milli(self, c: _milli_0__C, ev: DurationConversions.Classifier[_milli_0__C]) -> typing.Any: ...
        @typing.overload
        def milli(self) -> FiniteDuration: ...
        _millis_0__C = typing.TypeVar('_millis_0__C')  # <C>
        @typing.overload
        def millis(self, c: _millis_0__C, ev: DurationConversions.Classifier[_millis_0__C]) -> typing.Any: ...
        @typing.overload
        def millis(self) -> FiniteDuration: ...
        _millisecond_0__C = typing.TypeVar('_millisecond_0__C')  # <C>
        @typing.overload
        def millisecond(self, c: _millisecond_0__C, ev: DurationConversions.Classifier[_millisecond_0__C]) -> typing.Any: ...
        @typing.overload
        def millisecond(self) -> FiniteDuration: ...
        _milliseconds_0__C = typing.TypeVar('_milliseconds_0__C')  # <C>
        @typing.overload
        def milliseconds(self, c: _milliseconds_0__C, ev: DurationConversions.Classifier[_milliseconds_0__C]) -> typing.Any: ...
        @typing.overload
        def milliseconds(self) -> FiniteDuration: ...
        _minute_0__C = typing.TypeVar('_minute_0__C')  # <C>
        @typing.overload
        def minute(self, c: _minute_0__C, ev: DurationConversions.Classifier[_minute_0__C]) -> typing.Any: ...
        @typing.overload
        def minute(self) -> FiniteDuration: ...
        _minutes_0__C = typing.TypeVar('_minutes_0__C')  # <C>
        @typing.overload
        def minutes(self, c: _minutes_0__C, ev: DurationConversions.Classifier[_minutes_0__C]) -> typing.Any: ...
        @typing.overload
        def minutes(self) -> FiniteDuration: ...
        _nano_0__C = typing.TypeVar('_nano_0__C')  # <C>
        @typing.overload
        def nano(self, c: _nano_0__C, ev: DurationConversions.Classifier[_nano_0__C]) -> typing.Any: ...
        @typing.overload
        def nano(self) -> FiniteDuration: ...
        _nanos_0__C = typing.TypeVar('_nanos_0__C')  # <C>
        @typing.overload
        def nanos(self, c: _nanos_0__C, ev: DurationConversions.Classifier[_nanos_0__C]) -> typing.Any: ...
        @typing.overload
        def nanos(self) -> FiniteDuration: ...
        _nanosecond_0__C = typing.TypeVar('_nanosecond_0__C')  # <C>
        @typing.overload
        def nanosecond(self, c: _nanosecond_0__C, ev: DurationConversions.Classifier[_nanosecond_0__C]) -> typing.Any: ...
        @typing.overload
        def nanosecond(self) -> FiniteDuration: ...
        _nanoseconds_0__C = typing.TypeVar('_nanoseconds_0__C')  # <C>
        @typing.overload
        def nanoseconds(self, c: _nanoseconds_0__C, ev: DurationConversions.Classifier[_nanoseconds_0__C]) -> typing.Any: ...
        @typing.overload
        def nanoseconds(self) -> FiniteDuration: ...
        def scala$concurrent$duration$DurationLong$$n(self) -> int: ...
        _second_0__C = typing.TypeVar('_second_0__C')  # <C>
        @typing.overload
        def second(self, c: _second_0__C, ev: DurationConversions.Classifier[_second_0__C]) -> typing.Any: ...
        @typing.overload
        def second(self) -> FiniteDuration: ...
        _seconds_0__C = typing.TypeVar('_seconds_0__C')  # <C>
        @typing.overload
        def seconds(self, c: _seconds_0__C, ev: DurationConversions.Classifier[_seconds_0__C]) -> typing.Any: ...
        @typing.overload
        def seconds(self) -> FiniteDuration: ...
    class DurationLong$:
        MODULE$: typing.ClassVar['package.DurationLong.'] = ...
        def __init__(self): ...
        def durationIn$extension(self, $this: int, unit: java.util.concurrent.TimeUnit) -> FiniteDuration: ...
        def equals$extension(self, $this: int, x$1: typing.Any) -> bool: ...
        def hashCode$extension(self, $this: int) -> int: ...
    class IntMult:
        def __init__(self, i: int): ...
        @typing.overload
        def $times(self, d: Duration) -> Duration: ...
        @typing.overload
        def $times(self, d: FiniteDuration) -> FiniteDuration: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def scala$concurrent$duration$IntMult$$i(self) -> int: ...
    class IntMult$:
        MODULE$: typing.ClassVar['package.IntMult.'] = ...
        def __init__(self): ...
        def $times$extension0(self, $this: int, d: Duration) -> Duration: ...
        def $times$extension1(self, $this: int, d: FiniteDuration) -> FiniteDuration: ...
        def equals$extension(self, $this: int, x$1: typing.Any) -> bool: ...
        def hashCode$extension(self, $this: int) -> int: ...
    class LongMult:
        def __init__(self, i: int): ...
        @typing.overload
        def $times(self, d: Duration) -> Duration: ...
        @typing.overload
        def $times(self, d: FiniteDuration) -> FiniteDuration: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def scala$concurrent$duration$LongMult$$i(self) -> int: ...
    class LongMult$:
        MODULE$: typing.ClassVar['package.LongMult.'] = ...
        def __init__(self): ...
        def $times$extension0(self, $this: int, d: Duration) -> Duration: ...
        def $times$extension1(self, $this: int, d: FiniteDuration) -> FiniteDuration: ...
        def equals$extension(self, $this: int, x$1: typing.Any) -> bool: ...
        def hashCode$extension(self, $this: int) -> int: ...
    class fromNow$:
        MODULE$: typing.ClassVar['package.fromNow.'] = ...
        def __init__(self): ...
    class span$:
        MODULE$: typing.ClassVar['package.span.'] = ...
        def __init__(self): ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("scala.concurrent.duration")``.

    Deadline: typing.Type[Deadline]
    Duration: typing.Type[Duration]
    DurationConversions: typing.Type[DurationConversions]
    FiniteDuration: typing.Type[FiniteDuration]
    package: typing.Type[package]
