import java.lang
import scala
import scala.collection
import scala.util
import scorex.crypto.authds
import scorex.crypto.authds.avltree.batch
import scorex.crypto.authds.legacy.treap
import scorex.crypto.hash
import scorex.util.encode
import typing



class AVLModifyProof(scorex.crypto.authds.TwoPartyProof, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int], proofSeq: scala.collection.Seq[scorex.crypto.authds.AVLProofElement], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]): ...
    @staticmethod
    def apply(key: typing.List[int], proofSeq: scala.collection.Seq[scorex.crypto.authds.AVLProofElement], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'AVLModifyProof': ...
    def bytes(self) -> typing.List[int]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    @staticmethod
    def combineBytes(b1: int, b2: int) -> int: ...
    def copy(self, key: typing.List[int], proofSeq: scala.collection.Seq[scorex.crypto.authds.AVLProofElement], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'AVLModifyProof': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> scala.collection.Seq[scorex.crypto.authds.AVLProofElement]: ...
    def dequeueBalance(self) -> int: ...
    def dequeueDirection(self) -> scorex.crypto.authds.Direction: ...
    def dequeueKey(self) -> typing.List[int]: ...
    def dequeueLeftLabel(self) -> typing.List[int]: ...
    def dequeueLevel(self) -> scorex.crypto.authds.legacy.treap.Level: ...
    def dequeueNextLeafKey(self) -> typing.List[int]: ...
    def dequeueRightLabel(self) -> typing.List[int]: ...
    def dequeueValue(self) -> typing.List[int]: ...
    @staticmethod
    def directionBalanceByte(dir: scorex.crypto.authds.ProofDirection, balance: scorex.crypto.authds.ProofBalance) -> int: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def initializeIterator(self) -> None: ...
    def key(self) -> typing.List[int]: ...
    @staticmethod
    def parseBytes(bytes: typing.List[int], keyLength: int, digestSize: int, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> scala.util.Try['AVLModifyProof']: ...
    @staticmethod
    def parseBytes$default$2(bytes: typing.List[int]) -> int: ...
    @staticmethod
    def parseBytes$default$3(bytes: typing.List[int]) -> int: ...
    @staticmethod
    def parseBytes$default$4(bytes: typing.List[int]) -> scorex.crypto.hash.CryptographicHash[typing.List[int]]: ...
    @staticmethod
    def parseDirectionBalance(b: int) -> scala.Tuple2[scorex.crypto.authds.ProofDirection, scorex.crypto.authds.ProofBalance]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def proofSeq(self) -> scala.collection.Seq[scorex.crypto.authds.AVLProofElement]: ...
    def scorex$crypto$authds$ProofIterator$$i(self) -> int: ...
    def scorex$crypto$authds$ProofIterator$$i_$eq(self, x$1: int) -> None: ...
    @staticmethod
    def splitBytes(b: int) -> scala.Tuple2[typing.Any, typing.Any]: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'AVLModifyProof') -> scala.Option[scala.Tuple2[typing.List[int], scala.collection.Seq[scorex.crypto.authds.AVLProofElement]]]: ...
    @typing.overload
    def verify(self, digest: typing.List[int], updateFn: scala.Function1[scala.Option[typing.List[int]], scala.util.Try[scala.Option[typing.List[int]]]]) -> scala.Option[typing.List[int]]: ...
    @typing.overload
    def verify(self, digest: typing.List[int], modification: scorex.crypto.authds.avltree.batch.Modification) -> scala.Option[typing.List[int]]: ...
    def verifyLookup(self, digest: typing.List[int], existence: bool) -> scala.Option[typing.List[int]]: ...

_AVLTree__HF = typing.TypeVar('_AVLTree__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
class AVLTree(scorex.crypto.authds.TwoPartyDictionary, typing.Generic[_AVLTree__HF]):
    def __init__(self, keyLength: int, valueLength: int, rootOpt: scala.Option['ProverNodes'], hf: _AVLTree__HF): ...
    _$lessinit$greater$default$2__HF = typing.TypeVar('_$lessinit$greater$default$2__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$2() -> int: ...
    _$lessinit$greater$default$3__HF = typing.TypeVar('_$lessinit$greater$default$3__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$3() -> scala.Option['ProverNodes']: ...
    _$lessinit$greater$default$4__HF = typing.TypeVar('_$lessinit$greater$default$4__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$4(keyLength: int, valueLength: int, rootOpt: scala.Option['ProverNodes']) -> scorex.crypto.hash.Blake2b256.: ...
    def DefaultTopNode(self) -> 'Leaf': ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def rootHash(self) -> typing.List[int]: ...
    _run__O = typing.TypeVar('_run__O', bound=scorex.crypto.authds.avltree.batch.Operation)  # <O>
    def run(self, operation: _run__O) -> scala.util.Try[AVLModifyProof]: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...

class Node(scorex.crypto.authds.avltree.batch.ToStringHelper):
    @staticmethod
    def $init$($this: 'Node') -> None: ...
    def computeLabel(self) -> typing.List[int]: ...
    def label(self) -> typing.List[int]: ...
    def labelOpt(self) -> scala.Option[typing.List[int]]: ...
    def labelOpt_$eq(self, x$1: scala.Option[typing.List[int]]) -> None: ...

class InternalNode(Node):
    @staticmethod
    def $init$($this: 'InternalNode') -> None: ...
    def _balance(self) -> int: ...
    def _balance_$eq(self, x$1: int) -> None: ...
    def balance(self) -> int: ...
    def balance_$eq(self, balance: int) -> None: ...
    def computeLabel(self) -> typing.List[int]: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[typing.List[int]]: ...
    def leftLabel(self) -> typing.List[int]: ...
    def rightLabel(self) -> typing.List[int]: ...

class LabelOnlyNode(Node, scala.Product, scala.Serializable):
    def __init__(self, l: typing.List[int]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['LabelOnlyNode', _andThen__A]) -> scala.Function1[typing.List[int], _andThen__A]: ...
    @staticmethod
    def apply(l: typing.List[int]) -> 'LabelOnlyNode': ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.List[int]]) -> scala.Function1[_compose__A, 'LabelOnlyNode']: ...
    def computeLabel(self) -> typing.List[int]: ...
    def copy(self, l: typing.List[int]) -> 'LabelOnlyNode': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def l(self) -> typing.List[int]: ...
    def label(self) -> typing.List[int]: ...
    def labelOpt(self) -> scala.Option[typing.List[int]]: ...
    def labelOpt_$eq(self, x$1: scala.Option[typing.List[int]]) -> None: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'LabelOnlyNode') -> scala.Option[typing.List[int]]: ...

class ProverNodes(Node):
    @staticmethod
    def $init$($this: 'ProverNodes') -> None: ...
    def height(self) -> int: ...
    def height_$eq(self, x$1: int) -> None: ...
    def isNew(self) -> bool: ...
    def isNew_$eq(self, x$1: bool) -> None: ...
    def key(self) -> typing.List[int]: ...
    def visited(self) -> bool: ...
    def visited_$eq(self, x$1: bool) -> None: ...

class VerifierNodes(Node): ...

class Leaf(ProverNodes, VerifierNodes, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int], _value: typing.List[int], _nextLeafKey: typing.List[int], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]): ...
    def _nextLeafKey$access$2(self) -> typing.List[int]: ...
    def _value$access$1(self) -> typing.List[int]: ...
    @staticmethod
    def apply(key: typing.List[int], _value: typing.List[int], _nextLeafKey: typing.List[int], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'Leaf': ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def computeLabel(self) -> typing.List[int]: ...
    def copy(self, key: typing.List[int], _value: typing.List[int], _nextLeafKey: typing.List[int], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'Leaf': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> typing.List[int]: ...
    def copy$default$3(self) -> typing.List[int]: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def height(self) -> int: ...
    def height_$eq(self, x$1: int) -> None: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[typing.List[int]]: ...
    def isNew(self) -> bool: ...
    def isNew_$eq(self, x$1: bool) -> None: ...
    def key(self) -> typing.List[int]: ...
    def label(self) -> typing.List[int]: ...
    def labelOpt(self) -> scala.Option[typing.List[int]]: ...
    def labelOpt_$eq(self, x$1: scala.Option[typing.List[int]]) -> None: ...
    def nextLeafKey(self) -> typing.List[int]: ...
    def nextLeafKey_$eq(self, newNextLeafKey: typing.List[int]) -> None: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def scorex$crypto$authds$legacy$avltree$Leaf$$_nextLeafKey(self) -> typing.List[int]: ...
    def scorex$crypto$authds$legacy$avltree$Leaf$$_value(self) -> typing.List[int]: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'Leaf') -> scala.Option[scala.Tuple3[typing.List[int], typing.List[int], typing.List[int]]]: ...
    def value(self) -> typing.List[int]: ...
    def value_$eq(self, newValue: typing.List[int]) -> None: ...
    def visited(self) -> bool: ...
    def visited_$eq(self, x$1: bool) -> None: ...

class ProverNode(ProverNodes, InternalNode, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int], _left: ProverNodes, _right: ProverNodes, _balance: int, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]): ...
    @staticmethod
    def $lessinit$greater$default$4() -> int: ...
    def _balance(self) -> int: ...
    def _balance$access$3(self) -> int: ...
    def _balance_$eq(self, x$1: int) -> None: ...
    def _left$access$1(self) -> ProverNodes: ...
    def _right$access$2(self) -> ProverNodes: ...
    @staticmethod
    def apply(key: typing.List[int], _left: ProverNodes, _right: ProverNodes, _balance: int, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'ProverNode': ...
    @staticmethod
    def apply$default$4() -> int: ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def balance(self) -> int: ...
    def balance_$eq(self, balance: int) -> None: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def checkHeight(self) -> bool: ...
    def computeLabel(self) -> typing.List[int]: ...
    def copy(self, key: typing.List[int], _left: ProverNodes, _right: ProverNodes, _balance: int, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'ProverNode': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> ProverNodes: ...
    def copy$default$3(self) -> ProverNodes: ...
    def copy$default$4(self) -> int: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def height(self) -> int: ...
    def height_$eq(self, x$1: int) -> None: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[typing.List[int]]: ...
    def isNew(self) -> bool: ...
    def isNew_$eq(self, x$1: bool) -> None: ...
    def key(self) -> typing.List[int]: ...
    def label(self) -> typing.List[int]: ...
    def labelOpt(self) -> scala.Option[typing.List[int]]: ...
    def labelOpt_$eq(self, x$1: scala.Option[typing.List[int]]) -> None: ...
    def left(self) -> ProverNodes: ...
    def leftLabel(self) -> typing.List[int]: ...
    def left_$eq(self, newLeft: ProverNodes) -> None: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def right(self) -> ProverNodes: ...
    def rightLabel(self) -> typing.List[int]: ...
    def right_$eq(self, newRight: ProverNodes) -> None: ...
    def scorex$crypto$authds$legacy$avltree$ProverNode$$_left(self) -> ProverNodes: ...
    def scorex$crypto$authds$legacy$avltree$ProverNode$$_right(self) -> ProverNodes: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ProverNode') -> scala.Option[scala.Tuple4[typing.List[int], ProverNodes, ProverNodes, typing.Any]]: ...
    def visited(self) -> bool: ...
    def visited_$eq(self, x$1: bool) -> None: ...

class VerifierNode(VerifierNodes, InternalNode, scala.Product, scala.Serializable):
    def __init__(self, _left: Node, _right: Node, _balance: int, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]): ...
    def _balance(self) -> int: ...
    def _balance$access$2(self) -> int: ...
    def _balance_$eq(self, x$1: int) -> None: ...
    def _left$access$0(self) -> Node: ...
    def _right$access$1(self) -> Node: ...
    @staticmethod
    def apply(_left: Node, _right: Node, _balance: int, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'VerifierNode': ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def balance(self) -> int: ...
    def balance_$eq(self, balance: int) -> None: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def computeLabel(self) -> typing.List[int]: ...
    def copy(self, _left: Node, _right: Node, _balance: int, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'VerifierNode': ...
    def copy$default$1(self) -> Node: ...
    def copy$default$2(self) -> Node: ...
    def copy$default$3(self) -> int: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[typing.List[int]]: ...
    def label(self) -> typing.List[int]: ...
    def labelOpt(self) -> scala.Option[typing.List[int]]: ...
    def labelOpt_$eq(self, x$1: scala.Option[typing.List[int]]) -> None: ...
    def left(self) -> Node: ...
    def leftLabel(self) -> typing.List[int]: ...
    def left_$eq(self, newLeft: Node) -> None: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def right(self) -> Node: ...
    def rightLabel(self) -> typing.List[int]: ...
    def right_$eq(self, newRight: Node) -> None: ...
    def scorex$crypto$authds$legacy$avltree$VerifierNode$$_left(self) -> Node: ...
    def scorex$crypto$authds$legacy$avltree$VerifierNode$$_right(self) -> Node: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'VerifierNode') -> scala.Option[scala.Tuple3[Node, Node, typing.Any]]: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("scorex.crypto.authds.legacy.avltree")``.

    AVLModifyProof: typing.Type[AVLModifyProof]
    AVLTree: typing.Type[AVLTree]
    InternalNode: typing.Type[InternalNode]
    LabelOnlyNode: typing.Type[LabelOnlyNode]
    Leaf: typing.Type[Leaf]
    Node: typing.Type[Node]
    ProverNode: typing.Type[ProverNode]
    ProverNodes: typing.Type[ProverNodes]
    VerifierNode: typing.Type[VerifierNode]
    VerifierNodes: typing.Type[VerifierNodes]
