import java.lang
import java.nio
import scala
import scala.runtime
import scala.util
import scorex.util
import typing



class Reader:
    def __init__(self): ...
    def consumed(self) -> int: ...
    def getBits(self, size: int) -> typing.List[bool]: ...
    def getByte(self) -> int: ...
    def getBytes(self, size: int) -> typing.List[int]: ...
    def getChunk(self, size: int) -> typing.Any: ...
    def getInt(self) -> int: ...
    def getLong(self) -> int: ...
    _getOption__T = typing.TypeVar('_getOption__T')  # <T>
    def getOption(self, getValue: scala.Function0[_getOption__T]) -> scala.Option[_getOption__T]: ...
    def getShort(self) -> int: ...
    def getShortString(self) -> java.lang.String: ...
    def getUByte(self) -> int: ...
    def getUInt(self) -> int: ...
    def getULong(self) -> int: ...
    def getUShort(self) -> int: ...
    def mark(self) -> 'Reader': ...
    def newReader(self, chunk: typing.Any) -> 'Reader': ...
    def peekByte(self) -> int: ...
    def position(self) -> int: ...
    def position_$eq(self, p: int) -> None: ...
    def remaining(self) -> int: ...

_Serializer__TFamily = typing.TypeVar('_Serializer__TFamily')  # <TFamily>
_Serializer__T = typing.TypeVar('_Serializer__T')  # <T>
_Serializer__R = typing.TypeVar('_Serializer__R', bound=Reader)  # <R>
_Serializer__W = typing.TypeVar('_Serializer__W', bound='Writer')  # <W>
class Serializer(typing.Generic[_Serializer__TFamily, _Serializer__T, _Serializer__R, _Serializer__W]):
    def __init__(self): ...
    def parse(self, r: _Serializer__R) -> _Serializer__TFamily: ...
    def parseTry(self, r: _Serializer__R) -> scala.util.Try[_Serializer__TFamily]: ...
    def serialize(self, obj: _Serializer__T, w: _Serializer__W) -> None: ...

class VLQReader:
    @staticmethod
    def $init$($this: 'VLQReader') -> None: ...
    def getBits(self, size: int) -> typing.List[bool]: ...
    def getInt(self) -> int: ...
    def getLong(self) -> int: ...
    _getOption__T = typing.TypeVar('_getOption__T')  # <T>
    def getOption(self, getValue: scala.Function0[_getOption__T]) -> scala.Option[_getOption__T]: ...
    def getShort(self) -> int: ...
    def getShortString(self) -> java.lang.String: ...
    def getUByte(self) -> int: ...
    def getUInt(self) -> int: ...
    def getULong(self) -> int: ...
    def getUShort(self) -> int: ...

class VLQWriter:
    @staticmethod
    def $init$($this: 'VLQWriter') -> None: ...
    def putBits(self, xs: typing.List[bool]) -> 'VLQWriter': ...
    def putInt(self, x: int) -> 'VLQWriter': ...
    def putLong(self, x: int) -> 'VLQWriter': ...
    _putOption__T = typing.TypeVar('_putOption__T')  # <T>
    def putOption(self, x: scala.Option[_putOption__T], putValue: scala.Function2['VLQWriter', _putOption__T, scala.runtime.BoxedUnit]) -> 'VLQWriter': ...
    def putShort(self, x: int) -> 'VLQWriter': ...
    def putShortString(self, s: typing.Union[java.lang.String, str]) -> 'VLQWriter': ...
    def putUInt(self, x: int) -> 'VLQWriter': ...
    def putULong(self, x: int) -> 'VLQWriter': ...
    def putUShort(self, x: int) -> 'VLQWriter': ...
    def toBytes(self) -> typing.List[int]: ...

class Writer:
    def __init__(self): ...
    def append(self, writer: 'Writer') -> 'Writer': ...
    def length(self) -> int: ...
    def newWriter(self) -> 'Writer': ...
    def put(self, x: int) -> 'Writer': ...
    def putBits(self, xs: typing.List[bool]) -> 'Writer': ...
    def putBoolean(self, x: bool) -> 'Writer': ...
    @typing.overload
    def putBytes(self, xs: typing.List[int]) -> 'Writer': ...
    @typing.overload
    def putBytes(self, xs: typing.List[int], offset: int, length: int) -> 'Writer': ...
    def putChunk(self, chunk: typing.Any) -> 'Writer': ...
    def putInt(self, x: int) -> 'Writer': ...
    def putLong(self, x: int) -> 'Writer': ...
    _putOption__T = typing.TypeVar('_putOption__T')  # <T>
    def putOption(self, x: scala.Option[_putOption__T], putValue: scala.Function2['Writer', _putOption__T, scala.runtime.BoxedUnit]) -> 'Writer': ...
    def putShort(self, x: int) -> 'Writer': ...
    def putShortString(self, s: typing.Union[java.lang.String, str]) -> 'Writer': ...
    def putUByte(self, x: int) -> 'Writer': ...
    def putUInt(self, x: int) -> 'Writer': ...
    def putULong(self, x: int) -> 'Writer': ...
    def putUShort(self, x: int) -> 'Writer': ...
    def result(self) -> typing.Any: ...

class VLQByteBufferReader(Reader, VLQReader):
    scorex$util$serialization$VLQByteBufferReader$$buf: java.nio.ByteBuffer = ...
    def __init__(self, buf: java.nio.ByteBuffer): ...
    def consumed(self) -> int: ...
    def getBits(self, size: int) -> typing.List[bool]: ...
    def getByte(self) -> int: ...
    def getBytes(self, size: int) -> typing.List[int]: ...
    def getChunk(self, size: int) -> java.nio.ByteBuffer: ...
    def getInt(self) -> int: ...
    def getLong(self) -> int: ...
    _getOption__T = typing.TypeVar('_getOption__T')  # <T>
    def getOption(self, getValue: scala.Function0[_getOption__T]) -> scala.Option[_getOption__T]: ...
    def getShort(self) -> int: ...
    def getShortString(self) -> java.lang.String: ...
    def getUByte(self) -> int: ...
    def getUInt(self) -> int: ...
    def getULong(self) -> int: ...
    def getUShort(self) -> int: ...
    def mark(self) -> 'VLQByteBufferReader': ...
    def newReader(self, chunk: java.nio.ByteBuffer) -> Reader: ...
    def peekByte(self) -> int: ...
    def position(self) -> int: ...
    def position_$eq(self, p: int) -> None: ...
    def remaining(self) -> int: ...
    def scorex$util$serialization$VLQByteBufferReader$$_mark(self) -> int: ...
    def scorex$util$serialization$VLQByteBufferReader$$_mark_$eq(self, x$1: int) -> None: ...

class VLQByteBufferWriter(Writer, VLQWriter):
    scorex$util$serialization$VLQByteBufferWriter$$b: scorex.util.ByteArrayBuilder = ...
    def __init__(self, b: scorex.util.ByteArrayBuilder): ...
    def length(self) -> int: ...
    def newWriter(self) -> Writer: ...
    def put(self, x: int) -> 'VLQByteBufferWriter': ...
    def putBits(self, xs: typing.List[bool]) -> VLQWriter: ...
    def putBoolean(self, x: bool) -> 'VLQByteBufferWriter': ...
    @typing.overload
    def putBytes(self, xs: typing.List[int]) -> 'VLQByteBufferWriter': ...
    @typing.overload
    def putBytes(self, xs: typing.List[int], offset: int, length: int) -> 'VLQByteBufferWriter': ...
    def putChunk(self, chunk: scorex.util.ByteArrayBuilder) -> 'VLQByteBufferWriter': ...
    def putInt(self, x: int) -> VLQWriter: ...
    def putLong(self, x: int) -> VLQWriter: ...
    _putOption__T = typing.TypeVar('_putOption__T')  # <T>
    def putOption(self, x: scala.Option[_putOption__T], putValue: scala.Function2[VLQWriter, _putOption__T, scala.runtime.BoxedUnit]) -> VLQWriter: ...
    def putShort(self, x: int) -> VLQWriter: ...
    def putShortString(self, s: typing.Union[java.lang.String, str]) -> VLQWriter: ...
    def putUInt(self, x: int) -> VLQWriter: ...
    def putULong(self, x: int) -> VLQWriter: ...
    def putUShort(self, x: int) -> VLQWriter: ...
    def result(self) -> scorex.util.ByteArrayBuilder: ...
    def toBytes(self) -> typing.List[int]: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("scorex.util.serialization")``.

    Reader: typing.Type[Reader]
    Serializer: typing.Type[Serializer]
    VLQByteBufferReader: typing.Type[VLQByteBufferReader]
    VLQByteBufferWriter: typing.Type[VLQByteBufferWriter]
    VLQReader: typing.Type[VLQReader]
    VLQWriter: typing.Type[VLQWriter]
    Writer: typing.Type[Writer]
