import com.google.common.cache
import java.lang
import java.math
import java.security
import java.util
import java.util.concurrent.atomic
import org.bitbucket.inkytonik.kiama.attribution
import org.bitbucket.inkytonik.kiama.rewriting
import org.bouncycastle.math.ec.custom.sec
import org.ergoplatform
import org.ergoplatform.validation
import scala
import scala.collection
import scala.collection.immutable
import scala.collection.mutable
import scala.runtime
import scala.util
import scalan
import scorex.util
import sigmastate
import sigmastate.basics
import sigmastate.eval
import sigmastate.lang
import sigmastate.serialization
import sigmastate.utils
import special.sigma
import typing



class CacheKey(scala.Product, scala.Serializable):
    def __init__(self, ergoTreeBytes: scala.collection.Seq[typing.Any], vs: org.ergoplatform.validation.SigmaValidationSettings): ...
    @staticmethod
    def apply(ergoTreeBytes: scala.collection.Seq[typing.Any], vs: org.ergoplatform.validation.SigmaValidationSettings) -> 'CacheKey': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, ergoTreeBytes: scala.collection.Seq[typing.Any], vs: org.ergoplatform.validation.SigmaValidationSettings) -> 'CacheKey': ...
    def copy$default$1(self) -> scala.collection.Seq[typing.Any]: ...
    def copy$default$2(self) -> org.ergoplatform.validation.SigmaValidationSettings: ...
    @staticmethod
    def curried() -> scala.Function1[scala.collection.Seq[typing.Any], scala.Function1[org.ergoplatform.validation.SigmaValidationSettings, 'CacheKey']]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def ergoTreeBytes(self) -> scala.collection.Seq[typing.Any]: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[scala.collection.Seq[typing.Any], org.ergoplatform.validation.SigmaValidationSettings], 'CacheKey']: ...
    @staticmethod
    def unapply(x$0: 'CacheKey') -> scala.Option[scala.Tuple2[scala.collection.Seq[typing.Any], org.ergoplatform.validation.SigmaValidationSettings]]: ...
    def vs(self) -> org.ergoplatform.validation.SigmaValidationSettings: ...

class ContextExtension(scala.Product, scala.Serializable):
    def __init__(self, values: scala.collection.immutable.Map[typing.Any, sigmastate.Values.EvaluatedValue[sigmastate.SType]]): ...
    def add(self, bindings: scala.collection.Seq[scala.Tuple2[typing.Any, sigmastate.Values.EvaluatedValue[sigmastate.SType]]]) -> 'ContextExtension': ...
    @staticmethod
    def apply(values: scala.collection.immutable.Map[typing.Any, sigmastate.Values.EvaluatedValue[sigmastate.SType]]) -> 'ContextExtension': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, values: scala.collection.immutable.Map[typing.Any, sigmastate.Values.EvaluatedValue[sigmastate.SType]]) -> 'ContextExtension': ...
    def copy$default$1(self) -> scala.collection.immutable.Map[typing.Any, sigmastate.Values.EvaluatedValue[sigmastate.SType]]: ...
    @staticmethod
    def empty() -> 'ContextExtension': ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ContextExtension') -> scala.Option[scala.collection.immutable.Map[typing.Any, sigmastate.Values.EvaluatedValue[sigmastate.SType]]]: ...
    def values(self) -> scala.collection.immutable.Map[typing.Any, sigmastate.Values.EvaluatedValue[sigmastate.SType]]: ...
    class serializer$(sigmastate.serialization.SigmaSerializer['ContextExtension', 'ContextExtension']):
        MODULE$: typing.ClassVar['ContextExtension.serializer.'] = ...
        def __init__(self): ...
        def parse(self, r: sigmastate.utils.SigmaByteReader) -> 'ContextExtension': ...
        def serialize(self, obj: 'ContextExtension', w: sigmastate.utils.SigmaByteWriter) -> None: ...

class CostCounter:
    def __init__(self, initialCost: int): ...
    def $plus$eq(self, n: int) -> None: ...
    def currentCost(self) -> int: ...
    def initialCost(self) -> int: ...
    def resetCost(self) -> None: ...
    def sigmastate$interpreter$CostCounter$$_currentCost(self) -> int: ...
    def sigmastate$interpreter$CostCounter$$_currentCost_$eq(self, x$1: int) -> None: ...

class CostDetails:
    def __init__(self): ...
    @staticmethod
    def EmptyTrace() -> scala.collection.Seq['CostItem']: ...
    @staticmethod
    def ZeroCost() -> 'TracedCost': ...
    def actualTimeNano(self) -> scala.Option[typing.Any]: ...
    @staticmethod
    def apply(trace: scala.collection.Seq['CostItem']) -> 'CostDetails': ...
    def cost(self) -> int: ...
    def trace(self) -> scala.collection.Seq['CostItem']: ...
    @staticmethod
    def unapply(d: 'CostDetails') -> scala.Option[scala.Tuple2[typing.Any, scala.collection.Seq['CostItem']]]: ...

class CostItem:
    def __init__(self): ...
    def cost(self) -> int: ...
    def opName(self) -> java.lang.String: ...

class CryptoConstants:
    @staticmethod
    def EncodedGroupElementLength() -> int: ...
    @staticmethod
    def dlogGroup() -> sigmastate.basics.BcDlogGroup[org.bouncycastle.math.ec.custom.sec.SecP256K1Point]: ...
    @staticmethod
    def groupOrder() -> java.math.BigInteger: ...
    @staticmethod
    def groupSize() -> int: ...
    @staticmethod
    def groupSizeBits() -> int: ...
    @staticmethod
    def hashLength() -> int: ...
    @staticmethod
    def hashLengthBits() -> int: ...
    @staticmethod
    def secureRandom() -> java.security.SecureRandom: ...
    @staticmethod
    def secureRandomBytes(howMany: int) -> typing.List[int]: ...
    @staticmethod
    def soundnessBits() -> int: ...

class CryptoFunctions:
    @staticmethod
    def hashFn(input: typing.List[int]) -> typing.List[int]: ...
    @staticmethod
    def soundnessBytes() -> int: ...

class ErgoTreeEvaluator:
    def __init__(self, context: special.sigma.Context, constants: scala.collection.Seq[sigmastate.Values.Constant[sigmastate.SType]], coster: 'CostAccumulator', profiler: sigmastate.eval.Profiler, settings: 'EvalSettings'): ...
    @staticmethod
    def DataBlockSize() -> int: ...
    @staticmethod
    def DefaultEvalSettings() -> 'EvalSettings': ...
    @staticmethod
    def DefaultProfiler() -> sigmastate.eval.Profiler: ...
    @staticmethod
    def EmptyDataEnv() -> scala.collection.immutable.Map[typing.Any, typing.Any]: ...
    @typing.overload
    def addCost(self, costKind: sigmastate.FixedCost, opDesc: 'OperationDesc') -> None: ...
    @typing.overload
    def addCost(self, costInfo: 'OperationCostInfo'[sigmastate.FixedCost]) -> None: ...
    @typing.overload
    def addFixedCost(self, costKind: sigmastate.FixedCost, opDesc: 'OperationDesc', block: scala.Function0[scala.runtime.BoxedUnit]) -> None: ...
    @typing.overload
    def addFixedCost(self, costInfo: 'OperationCostInfo'[sigmastate.FixedCost], block: scala.Function0[scala.runtime.BoxedUnit]) -> None: ...
    _addSeqCost_0__R = typing.TypeVar('_addSeqCost_0__R')  # <R>
    _addSeqCost_1__R = typing.TypeVar('_addSeqCost_1__R')  # <R>
    @typing.overload
    def addSeqCost(self, costKind: sigmastate.PerItemCost, nItems: int, opDesc: 'OperationDesc', block: scala.Function0[_addSeqCost_0__R]) -> _addSeqCost_0__R: ...
    @typing.overload
    def addSeqCost(self, costInfo: 'OperationCostInfo'[sigmastate.PerItemCost], nItems: int, block: scala.Function0[_addSeqCost_1__R]) -> _addSeqCost_1__R: ...
    @typing.overload
    def addSeqCost(self, costKind: sigmastate.PerItemCost, opDesc: 'OperationDesc', block: scala.Function0[typing.Any]) -> None: ...
    @typing.overload
    def addSeqCost(self, costInfo: 'OperationCostInfo'[sigmastate.PerItemCost], block: scala.Function0[typing.Any]) -> None: ...
    def addSeqCostNoOp(self, costKind: sigmastate.PerItemCost, nItems: int, opDesc: 'OperationDesc') -> None: ...
    _addTypeBasedCost__R = typing.TypeVar('_addTypeBasedCost__R')  # <R>
    def addTypeBasedCost(self, costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType, opDesc: 'OperationDesc', block: scala.Function0[_addTypeBasedCost__R]) -> _addTypeBasedCost__R: ...
    @staticmethod
    def calcCost(mc: sigmastate.lang.Terms.MethodCall, obj: typing.Any, args: typing.List[typing.Any], E: 'ErgoTreeEvaluator') -> CostDetails: ...
    def constants(self) -> scala.collection.Seq[sigmastate.Values.Constant[sigmastate.SType]]: ...
    def context(self) -> special.sigma.Context: ...
    def coster(self) -> 'CostAccumulator': ...
    @staticmethod
    def error(msg: typing.Union[java.lang.String, str]) -> scala.runtime.Nothing.: ...
    def eval(self, env: scala.collection.immutable.Map[typing.Any, typing.Any], exp: sigmastate.Values.Value[sigmastate.SType]) -> typing.Any: ...
    @staticmethod
    def evalToCrypto(context: org.ergoplatform.ErgoLikeContext, ergoTree: sigmastate.Values.ErgoTree, evalSettings: 'EvalSettings') -> 'Interpreter.ReductionResult': ...
    def evalWithCost(self, env: scala.collection.immutable.Map[typing.Any, typing.Any], exp: sigmastate.Values.Value[sigmastate.SType]) -> scala.Tuple2[typing.Any, typing.Any]: ...
    @staticmethod
    def forProfiling(profiler: sigmastate.eval.Profiler, evalSettings: 'EvalSettings') -> 'ErgoTreeEvaluator': ...
    @staticmethod
    def getCurrentEvaluator() -> 'ErgoTreeEvaluator': ...
    def profiler(self) -> sigmastate.eval.Profiler: ...
    def settings(self) -> 'EvalSettings': ...
    def sigmastate$interpreter$ErgoTreeEvaluator$$costTrace(self) -> scala.collection.mutable.ArrayBuilder[CostItem]: ...

class EvalSettings(scala.Product, scala.Serializable):
    def __init__(self, isMeasureOperationTime: bool, isMeasureScriptTime: bool, isDebug: bool, isLogEnabled: bool, costTracingEnabled: bool, profilerOpt: scala.Option[sigmastate.eval.Profiler], isTestRun: bool, printTestVectors: bool): ...
    @staticmethod
    def $lessinit$greater$default$3() -> bool: ...
    @staticmethod
    def $lessinit$greater$default$4() -> bool: ...
    @staticmethod
    def $lessinit$greater$default$5() -> bool: ...
    @staticmethod
    def $lessinit$greater$default$6() -> scala.Option[sigmastate.eval.Profiler]: ...
    @staticmethod
    def $lessinit$greater$default$7() -> bool: ...
    @staticmethod
    def $lessinit$greater$default$8() -> bool: ...
    @staticmethod
    def apply(isMeasureOperationTime: bool, isMeasureScriptTime: bool, isDebug: bool, isLogEnabled: bool, costTracingEnabled: bool, profilerOpt: scala.Option[sigmastate.eval.Profiler], isTestRun: bool, printTestVectors: bool) -> 'EvalSettings': ...
    @staticmethod
    def apply$default$3() -> bool: ...
    @staticmethod
    def apply$default$4() -> bool: ...
    @staticmethod
    def apply$default$5() -> bool: ...
    @staticmethod
    def apply$default$6() -> scala.Option[sigmastate.eval.Profiler]: ...
    @staticmethod
    def apply$default$7() -> bool: ...
    @staticmethod
    def apply$default$8() -> bool: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, isMeasureOperationTime: bool, isMeasureScriptTime: bool, isDebug: bool, isLogEnabled: bool, costTracingEnabled: bool, profilerOpt: scala.Option[sigmastate.eval.Profiler], isTestRun: bool, printTestVectors: bool) -> 'EvalSettings': ...
    def copy$default$1(self) -> bool: ...
    def copy$default$2(self) -> bool: ...
    def copy$default$3(self) -> bool: ...
    def copy$default$4(self) -> bool: ...
    def copy$default$5(self) -> bool: ...
    def copy$default$6(self) -> scala.Option[sigmastate.eval.Profiler]: ...
    def copy$default$7(self) -> bool: ...
    def copy$default$8(self) -> bool: ...
    def costTracingEnabled(self) -> bool: ...
    @staticmethod
    def curried() -> scala.Function1[typing.Any, scala.Function1[typing.Any, scala.Function1[typing.Any, scala.Function1[typing.Any, scala.Function1[typing.Any, scala.Function1[scala.Option[sigmastate.eval.Profiler], scala.Function1[typing.Any, scala.Function1[typing.Any, 'EvalSettings']]]]]]]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def isDebug(self) -> bool: ...
    def isLogEnabled(self) -> bool: ...
    def isMeasureOperationTime(self) -> bool: ...
    def isMeasureScriptTime(self) -> bool: ...
    def isTestRun(self) -> bool: ...
    def printTestVectors(self) -> bool: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def profilerOpt(self) -> scala.Option[sigmastate.eval.Profiler]: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple8[typing.Any, typing.Any, typing.Any, typing.Any, typing.Any, scala.Option[sigmastate.eval.Profiler], typing.Any, typing.Any], 'EvalSettings']: ...
    @staticmethod
    def unapply(x$0: 'EvalSettings') -> scala.Option[scala.Tuple8[typing.Any, typing.Any, typing.Any, typing.Any, typing.Any, scala.Option[sigmastate.eval.Profiler], typing.Any, typing.Any]]: ...

class Hint:
    def position(self) -> sigmastate.NodePosition: ...

class HintsBag(scala.Product, scala.Serializable):
    def __init__(self, hints: scala.collection.Seq[Hint]): ...
    def $plus$plus(self, other: 'HintsBag') -> 'HintsBag': ...
    def addHint(self, hint: Hint) -> 'HintsBag': ...
    def addHints(self, newHints: scala.collection.Seq[Hint]) -> 'HintsBag': ...
    @staticmethod
    def apply(hints: scala.collection.Seq[Hint]) -> 'HintsBag': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def commitments(self) -> scala.collection.Seq['CommitmentHint']: ...
    def copy(self, hints: scala.collection.Seq[Hint]) -> 'HintsBag': ...
    def copy$default$1(self) -> scala.collection.Seq[Hint]: ...
    @staticmethod
    def empty() -> 'HintsBag': ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def hints(self) -> scala.collection.Seq[Hint]: ...
    def ownCommitments(self) -> scala.collection.Seq['OwnCommitment']: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def proofs(self) -> scala.collection.Seq['SecretProven']: ...
    def realCommitments(self) -> scala.collection.Seq['RealCommitment']: ...
    def realImages(self) -> scala.collection.Seq[sigmastate.Values.SigmaBoolean]: ...
    def realProofs(self) -> scala.collection.Seq['RealSecretProof']: ...
    def simulatedProofs(self) -> scala.collection.Seq['SimulatedSecretProof']: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'HintsBag') -> scala.Option[scala.collection.Seq[Hint]]: ...

_Interpreter__MutableCell__T = typing.TypeVar('_Interpreter__MutableCell__T')  # <T>
class Interpreter(scorex.util.ScorexLogging):
    @staticmethod
    def $init$($this: 'Interpreter') -> None: ...
    def IR(self) -> sigmastate.eval.IRContext: ...
    @staticmethod
    def MaxSupportedScriptVersion() -> int: ...
    @staticmethod
    def ScriptNameProp() -> java.lang.String: ...
    @staticmethod
    def WhenSoftForkReductionResult(cost: int) -> 'Interpreter.ReductionResult': ...
    def applyDeserializeContext(self, context: 'InterpreterContext', exp: sigmastate.Values.Value[sigmastate.SType]) -> scala.Tuple2[sigmastate.Values.Value[sigmastate.SBoolean.], 'InterpreterContext']: ...
    @staticmethod
    def calcResult(IR: sigmastate.eval.IRContext, context: special.sigma.Context, calcF: scalan.Base.Ref[scala.Function1[special.sigma.SigmaDsl.Context, typing.Any]]) -> special.sigma.SigmaProp: ...
    def computeCommitments(self) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    def deserializeMeasured(self, context: 'InterpreterContext', scriptBytes: typing.List[int]) -> scala.Tuple2['InterpreterContext', sigmastate.Values.Value[sigmastate.SType]]: ...
    @staticmethod
    def emptyEnv() -> scala.collection.immutable.Map[java.lang.String, typing.Any]: ...
    @staticmethod
    def error(msg: typing.Union[java.lang.String, str]) -> scala.runtime.Nothing.: ...
    def fullReduction(self, ergoTree: sigmastate.Values.ErgoTree, context: 'InterpreterContext', env: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any]) -> 'Interpreter.ReductionResult': ...
    def precompiledScriptProcessor(self) -> 'PrecompiledScriptProcessor': ...
    def propositionFromErgoTree(self, ergoTree: sigmastate.Values.ErgoTree, context: 'InterpreterContext') -> sigmastate.Values.Value[sigmastate.SSigmaProp.]: ...
    @typing.overload
    def reduceToCrypto(self, context: 'InterpreterContext', env: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any], exp: sigmastate.Values.Value[sigmastate.SType]) -> scala.util.Try['Interpreter.ReductionResult']: ...
    @typing.overload
    def reduceToCrypto(self, context: 'InterpreterContext', exp: sigmastate.Values.Value[sigmastate.SType]) -> scala.util.Try['Interpreter.ReductionResult']: ...
    def sigmastate$interpreter$Interpreter$_setter_$computeCommitments_$eq(self, x$1: org.bitbucket.inkytonik.kiama.rewriting.Strategy) -> None: ...
    def substDeserialize(self, context: 'InterpreterContext', updateContext: scala.Function1['InterpreterContext', scala.runtime.BoxedUnit], node: sigmastate.Values.Value[sigmastate.SType]) -> scala.Option[sigmastate.Values.Value[sigmastate.SType]]: ...
    @staticmethod
    def toValidScriptType(exp: sigmastate.Values.Value[sigmastate.SType]) -> sigmastate.Values.Value[sigmastate.SBoolean.]: ...
    @typing.overload
    def verify(self, env: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any], ergoTree: sigmastate.Values.ErgoTree, context: 'InterpreterContext', proof: typing.List[int], message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...
    @typing.overload
    def verify(self, env: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any], ergoTree: sigmastate.Values.ErgoTree, context: 'InterpreterContext', proverResult: 'ProverResult', message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...
    @typing.overload
    def verify(self, ergoTree: sigmastate.Values.ErgoTree, context: 'InterpreterContext', proof: sigmastate.UncheckedTree, message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...
    @typing.overload
    def verify(self, ergoTree: sigmastate.Values.ErgoTree, context: 'InterpreterContext', proverResult: 'ProverResult', message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...
    def verifySignature(self, sigmaTree: sigmastate.Values.SigmaBoolean, message: typing.List[int], signature: typing.List[int]) -> bool: ...
    class MutableCell(typing.Generic[_Interpreter__MutableCell__T]):
        $outer: 'Interpreter' = ...
        def __init__(self, $outer: 'Interpreter', value: _Interpreter__MutableCell__T): ...
        def value(self) -> _Interpreter__MutableCell__T: ...
        def value_$eq(self, x$1: _Interpreter__MutableCell__T) -> None: ...
    class ReductionResult(scala.Product, scala.Serializable):
        def __init__(self, value: sigmastate.Values.SigmaBoolean, cost: int): ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def copy(self, value: sigmastate.Values.SigmaBoolean, cost: int) -> 'Interpreter.ReductionResult': ...
        def copy$default$1(self) -> sigmastate.Values.SigmaBoolean: ...
        def copy$default$2(self) -> int: ...
        def cost(self) -> int: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def toString(self) -> java.lang.String: ...
        def value(self) -> sigmastate.Values.SigmaBoolean: ...
    class ReductionResult$(scala.runtime.AbstractFunction2[sigmastate.Values.SigmaBoolean, typing.Any, 'Interpreter.ReductionResult'], scala.Serializable):
        MODULE$: typing.ClassVar['Interpreter.ReductionResult.'] = ...
        def __init__(self): ...
        def apply(self, value: sigmastate.Values.SigmaBoolean, cost: int) -> 'Interpreter.ReductionResult': ...
        def toString(self) -> java.lang.String: ...
        def unapply(self, x$0: 'Interpreter.ReductionResult') -> scala.Option[scala.Tuple2[sigmastate.Values.SigmaBoolean, typing.Any]]: ...

class InterpreterContext:
    @staticmethod
    def $init$($this: 'InterpreterContext') -> None: ...
    def activatedScriptVersion(self) -> int: ...
    def costLimit(self) -> int: ...
    def extension(self) -> ContextExtension: ...
    def initCost(self) -> int: ...
    def toSigmaContext(self, isCost: bool, extensions: scala.collection.immutable.Map[typing.Any, special.sigma.AnyValue]) -> special.sigma.Context: ...
    def toSigmaContext$default$2(self) -> scala.collection.immutable.Map[typing.Any, special.sigma.AnyValue]: ...
    def validationSettings(self) -> org.ergoplatform.validation.SigmaValidationSettings: ...
    def withBindings(self, bindings: scala.collection.Seq[scala.Tuple2[typing.Any, sigmastate.Values.EvaluatedValue[sigmastate.SType]]]) -> 'InterpreterContext': ...
    def withCostLimit(self, newCostLimit: int) -> 'InterpreterContext': ...
    def withExtension(self, newExtension: ContextExtension) -> 'InterpreterContext': ...
    def withInitCost(self, newCost: int) -> 'InterpreterContext': ...
    def withValidationSettings(self, newVs: org.ergoplatform.validation.SigmaValidationSettings) -> 'InterpreterContext': ...

_OperationCostInfo__C = typing.TypeVar('_OperationCostInfo__C', bound=sigmastate.CostKind)  # <C>
class OperationCostInfo(scala.Product, scala.Serializable, typing.Generic[_OperationCostInfo__C]):
    def __init__(self, costKind: _OperationCostInfo__C, opDesc: 'OperationDesc'): ...
    _apply__C = typing.TypeVar('_apply__C', bound=sigmastate.CostKind)  # <C>
    @staticmethod
    def apply(costKind: _apply__C, opDesc: 'OperationDesc') -> 'OperationCostInfo'[_apply__C]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _copy__C = typing.TypeVar('_copy__C', bound=sigmastate.CostKind)  # <C>
    def copy(self, costKind: sigmastate.CostKind, opDesc: 'OperationDesc') -> 'OperationCostInfo'[sigmastate.CostKind]: ...
    _copy$default$1__C = typing.TypeVar('_copy$default$1__C', bound=sigmastate.CostKind)  # <C>
    def copy$default$1(self) -> sigmastate.CostKind: ...
    _copy$default$2__C = typing.TypeVar('_copy$default$2__C', bound=sigmastate.CostKind)  # <C>
    def copy$default$2(self) -> 'OperationDesc': ...
    def costKind(self) -> _OperationCostInfo__C: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> 'OperationDesc': ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    _unapply__C = typing.TypeVar('_unapply__C', bound=sigmastate.CostKind)  # <C>
    @staticmethod
    def unapply(x$0: 'OperationCostInfo'[_unapply__C]) -> scala.Option[scala.Tuple2[_unapply__C, 'OperationDesc']]: ...

class OperationDesc:
    def __init__(self): ...
    def operationName(self) -> java.lang.String: ...

class PrecompiledScriptProcessor:
    def __init__(self, settings: 'ScriptProcessorSettings'): ...
    @staticmethod
    def Default() -> 'PrecompiledScriptProcessor': ...
    def cache(self) -> com.google.common.cache.LoadingCache[CacheKey, 'ScriptReducer']: ...
    def cacheListener(self) -> com.google.common.cache.RemovalListener[CacheKey, 'ScriptReducer']: ...
    def cacheLoader(self) -> com.google.common.cache.CacheLoader[CacheKey, 'ScriptReducer']: ...
    def createIR(self) -> sigmastate.eval.IRContext: ...
    def getPredefStats(self) -> scala.collection.Seq[typing.Any]: ...
    @typing.overload
    def getReducer(self, ergoTree: sigmastate.Values.ErgoTree, vs: org.ergoplatform.validation.SigmaValidationSettings) -> 'ScriptReducer': ...
    @typing.overload
    def getReducer(self, key: CacheKey) -> 'ScriptReducer': ...
    def getStats(self) -> 'ProcessorStats': ...
    def onEvictedCacheEntry(self, key: CacheKey) -> None: ...
    def onReportStats(self, stats: 'ProcessorStats') -> None: ...
    def predefReducers(self) -> java.util.HashMap[CacheKey, scala.Tuple2['ScriptReducer', java.util.concurrent.atomic.AtomicInteger]]: ...
    def settings(self) -> 'ScriptProcessorSettings': ...

class ProcessorStats(scala.Product, scala.Serializable):
    def __init__(self, cacheStats: com.google.common.cache.CacheStats, predefHits: scala.collection.Seq[typing.Any]): ...
    @staticmethod
    def apply(cacheStats: com.google.common.cache.CacheStats, predefHits: scala.collection.Seq[typing.Any]) -> 'ProcessorStats': ...
    def cacheStats(self) -> com.google.common.cache.CacheStats: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, cacheStats: com.google.common.cache.CacheStats, predefHits: scala.collection.Seq[typing.Any]) -> 'ProcessorStats': ...
    def copy$default$1(self) -> com.google.common.cache.CacheStats: ...
    def copy$default$2(self) -> scala.collection.Seq[typing.Any]: ...
    @staticmethod
    def curried() -> scala.Function1[com.google.common.cache.CacheStats, scala.Function1[scala.collection.Seq[typing.Any], 'ProcessorStats']]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def predefHits(self) -> scala.collection.Seq[typing.Any]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[com.google.common.cache.CacheStats, scala.collection.Seq[typing.Any]], 'ProcessorStats']: ...
    @staticmethod
    def unapply(x$0: 'ProcessorStats') -> scala.Option[scala.Tuple2[com.google.common.cache.CacheStats, scala.collection.Seq[typing.Any]]]: ...

class ProverResult:
    def __init__(self, proof: typing.List[int], extension: ContextExtension): ...
    @staticmethod
    def apply(proof: typing.List[int], extension: ContextExtension) -> 'ProverResult': ...
    @staticmethod
    def empty() -> 'ProverResult': ...
    def equals(self, obj: typing.Any) -> bool: ...
    def extension(self) -> ContextExtension: ...
    def hashCode(self) -> int: ...
    def proof(self) -> typing.List[int]: ...
    def toString(self) -> java.lang.String: ...
    class serializer$(sigmastate.serialization.SigmaSerializer['ProverResult', 'ProverResult']):
        MODULE$: typing.ClassVar['ProverResult.serializer.'] = ...
        def __init__(self): ...
        def parse(self, r: sigmastate.utils.SigmaByteReader) -> 'ProverResult': ...
        def serialize(self, obj: 'ProverResult', w: sigmastate.utils.SigmaByteWriter) -> None: ...

class ScriptProcessorSettings(scala.Product, scala.Serializable):
    def __init__(self, predefScripts: scala.collection.Seq[CacheKey], maxCacheSize: int, recordCacheStats: bool, reportingInterval: int): ...
    @staticmethod
    def $lessinit$greater$default$2() -> int: ...
    @staticmethod
    def $lessinit$greater$default$3() -> bool: ...
    @staticmethod
    def $lessinit$greater$default$4() -> int: ...
    @staticmethod
    def apply(predefScripts: scala.collection.Seq[CacheKey], maxCacheSize: int, recordCacheStats: bool, reportingInterval: int) -> 'ScriptProcessorSettings': ...
    @staticmethod
    def apply$default$2() -> int: ...
    @staticmethod
    def apply$default$3() -> bool: ...
    @staticmethod
    def apply$default$4() -> int: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, predefScripts: scala.collection.Seq[CacheKey], maxCacheSize: int, recordCacheStats: bool, reportingInterval: int) -> 'ScriptProcessorSettings': ...
    def copy$default$1(self) -> scala.collection.Seq[CacheKey]: ...
    def copy$default$2(self) -> int: ...
    def copy$default$3(self) -> bool: ...
    def copy$default$4(self) -> int: ...
    @staticmethod
    def curried() -> scala.Function1[scala.collection.Seq[CacheKey], scala.Function1[typing.Any, scala.Function1[typing.Any, scala.Function1[typing.Any, 'ScriptProcessorSettings']]]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def maxCacheSize(self) -> int: ...
    def predefScripts(self) -> scala.collection.Seq[CacheKey]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def recordCacheStats(self) -> bool: ...
    def reportingInterval(self) -> int: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple4[scala.collection.Seq[CacheKey], typing.Any, typing.Any, typing.Any], 'ScriptProcessorSettings']: ...
    @staticmethod
    def unapply(x$0: 'ScriptProcessorSettings') -> scala.Option[scala.Tuple4[scala.collection.Seq[CacheKey], typing.Any, typing.Any, typing.Any]]: ...

class ScriptReducer:
    def reduce(self, context: InterpreterContext) -> Interpreter.ReductionResult: ...

class WhenSoftForkReducer:
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def reduce(context: InterpreterContext) -> Interpreter.ReductionResult: ...
    @staticmethod
    def toString() -> java.lang.String: ...

class CommitmentHint(Hint):
    def __init__(self): ...
    def commitment(self) -> sigmastate.basics.FirstProverMessage: ...
    def image(self) -> sigmastate.Values.SigmaBoolean: ...

class CompanionDesc(OperationDesc, scala.Product, scala.Serializable):
    def __init__(self, companion: sigmastate.Values.ValueCompanion): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['CompanionDesc', _andThen__A]) -> scala.Function1[sigmastate.Values.ValueCompanion, _andThen__A]: ...
    @staticmethod
    def apply(companion: sigmastate.Values.ValueCompanion) -> 'CompanionDesc': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def companion(self) -> sigmastate.Values.ValueCompanion: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, sigmastate.Values.ValueCompanion]) -> scala.Function1[_compose__A, 'CompanionDesc']: ...
    def copy(self, companion: sigmastate.Values.ValueCompanion) -> 'CompanionDesc': ...
    def copy$default$1(self) -> sigmastate.Values.ValueCompanion: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def operationName(self) -> java.lang.String: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'CompanionDesc') -> scala.Option[sigmastate.Values.ValueCompanion]: ...

class CostAccumulator:
    sigmastate$interpreter$CostAccumulator$$initialCost: int = ...
    def __init__(self, initialCost: int, costLimit: scala.Option[typing.Any]): ...
    def add(self, opCost: int) -> None: ...
    def currentScope(self) -> 'CostAccumulator.Scope': ...
    def reset(self) -> None: ...
    def sigmastate$interpreter$CostAccumulator$$_scopeStack(self) -> scala.collection.immutable.List['CostAccumulator.Scope']: ...
    def sigmastate$interpreter$CostAccumulator$$_scopeStack_$eq(self, x$1: scala.collection.immutable.List['CostAccumulator.Scope']) -> None: ...
    def sigmastate$interpreter$CostAccumulator$$initialStack(self) -> scala.collection.immutable.List['CostAccumulator.Scope']: ...
    def totalCost(self) -> int: ...
    class Scope(CostCounter):
        $outer: 'CostAccumulator' = ...
        def __init__(self, $outer: 'CostAccumulator', initialCost: int): ...
        def add(self, opCost: int) -> None: ...
        def childScopeResult(self) -> int: ...
        def childScopeResult_$eq(self, resultCost: int) -> None: ...
        def sigmastate$interpreter$CostAccumulator$Scope$$_resultRegister(self) -> int: ...
        def sigmastate$interpreter$CostAccumulator$Scope$$_resultRegister_$eq(self, x$1: int) -> None: ...

class CostedProverResult(ProverResult, scala.Product, scala.Serializable):
    def __init__(self, proof: typing.List[int], extension: ContextExtension, cost: int): ...
    @typing.overload
    @staticmethod
    def apply(proof: typing.List[int], extension: ContextExtension, cost: int) -> 'CostedProverResult': ...
    @typing.overload
    @staticmethod
    def apply(proof: typing.List[int], extension: ContextExtension) -> ProverResult: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, proof: typing.List[int], extension: ContextExtension, cost: int) -> 'CostedProverResult': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> ContextExtension: ...
    def copy$default$3(self) -> int: ...
    def cost(self) -> int: ...
    @staticmethod
    def curried() -> scala.Function1[typing.List[int], scala.Function1[ContextExtension, scala.Function1[typing.Any, 'CostedProverResult']]]: ...
    def extension(self) -> ContextExtension: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def proof(self) -> typing.List[int]: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple3[typing.List[int], ContextExtension, typing.Any], 'CostedProverResult']: ...
    @staticmethod
    def unapply(x$0: 'CostedProverResult') -> scala.Option[scala.Tuple3[typing.List[int], ContextExtension, typing.Any]]: ...

class FixedCostItem(CostItem, scala.Product, scala.Serializable):
    def __init__(self, opDesc: OperationDesc, costKind: sigmastate.FixedCost): ...
    @typing.overload
    @staticmethod
    def apply(method: sigmastate.SMethod, costKind: sigmastate.FixedCost) -> 'FixedCostItem': ...
    @typing.overload
    @staticmethod
    def apply(companion: sigmastate.Values.FixedCostValueCompanion) -> 'FixedCostItem': ...
    @typing.overload
    @staticmethod
    def apply(opDesc: OperationDesc, costKind: sigmastate.FixedCost) -> 'FixedCostItem': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, opDesc: OperationDesc, costKind: sigmastate.FixedCost) -> 'FixedCostItem': ...
    def copy$default$1(self) -> OperationDesc: ...
    def copy$default$2(self) -> sigmastate.FixedCost: ...
    def cost(self) -> int: ...
    def costKind(self) -> sigmastate.FixedCost: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> OperationDesc: ...
    def opName(self) -> java.lang.String: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'FixedCostItem') -> scala.Option[scala.Tuple2[OperationDesc, sigmastate.FixedCost]]: ...

class GivenCost(CostDetails, scala.Product, scala.Serializable):
    def __init__(self, cost: int, actualTimeNano: scala.Option[typing.Any]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[typing.Any]: ...
    def actualTimeNano(self) -> scala.Option[typing.Any]: ...
    @typing.overload
    @staticmethod
    def apply(trace: scala.collection.Seq[CostItem]) -> CostDetails: ...
    @typing.overload
    @staticmethod
    def apply(cost: int, actualTimeNano: scala.Option[typing.Any]) -> 'GivenCost': ...
    @staticmethod
    def apply$default$2() -> scala.Option[typing.Any]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, cost: int, actualTimeNano: scala.Option[typing.Any]) -> 'GivenCost': ...
    def copy$default$1(self) -> int: ...
    def copy$default$2(self) -> scala.Option[typing.Any]: ...
    def cost(self) -> int: ...
    @staticmethod
    def curried() -> scala.Function1[typing.Any, scala.Function1[scala.Option[typing.Any], 'GivenCost']]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def trace(self) -> scala.collection.Seq[CostItem]: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[typing.Any, scala.Option[typing.Any]], 'GivenCost']: ...
    @typing.overload
    @staticmethod
    def unapply(d: CostDetails) -> scala.Option[scala.Tuple2[typing.Any, scala.collection.Seq[CostItem]]]: ...
    @typing.overload
    @staticmethod
    def unapply(x$0: 'GivenCost') -> scala.Option[scala.Tuple2[typing.Any, scala.Option[typing.Any]]]: ...

class MethodCallCostItem(CostItem, scala.Product, scala.Serializable):
    def __init__(self, items: CostDetails): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['MethodCallCostItem', _andThen__A]) -> scala.Function1[CostDetails, _andThen__A]: ...
    @staticmethod
    def apply(items: CostDetails) -> 'MethodCallCostItem': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, CostDetails]) -> scala.Function1[_compose__A, 'MethodCallCostItem']: ...
    def copy(self, items: CostDetails) -> 'MethodCallCostItem': ...
    def copy$default$1(self) -> CostDetails: ...
    def cost(self) -> int: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def items(self) -> CostDetails: ...
    def opName(self) -> java.lang.String: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'MethodCallCostItem') -> scala.Option[CostDetails]: ...

class MethodDesc(OperationDesc, scala.Product, scala.Serializable):
    def __init__(self, method: sigmastate.SMethod): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['MethodDesc', _andThen__A]) -> scala.Function1[sigmastate.SMethod, _andThen__A]: ...
    @staticmethod
    def apply(method: sigmastate.SMethod) -> 'MethodDesc': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, sigmastate.SMethod]) -> scala.Function1[_compose__A, 'MethodDesc']: ...
    def copy(self, method: sigmastate.SMethod) -> 'MethodDesc': ...
    def copy$default$1(self) -> sigmastate.SMethod: ...
    def equals(self, obj: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def method(self) -> sigmastate.SMethod: ...
    def operationName(self) -> java.lang.String: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'MethodDesc') -> scala.Option[sigmastate.SMethod]: ...

class NamedDesc(OperationDesc, scala.Product, scala.Serializable):
    def __init__(self, operationName: typing.Union[java.lang.String, str]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['NamedDesc', _andThen__A]) -> scala.Function1[java.lang.String, _andThen__A]: ...
    @staticmethod
    def apply(operationName: typing.Union[java.lang.String, str]) -> 'NamedDesc': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.Union[java.lang.String, str]]) -> scala.Function1[_compose__A, 'NamedDesc']: ...
    def copy(self, operationName: typing.Union[java.lang.String, str]) -> 'NamedDesc': ...
    def copy$default$1(self) -> java.lang.String: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def operationName(self) -> java.lang.String: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'NamedDesc') -> scala.Option[java.lang.String]: ...

class PrecompiledScriptReducer(ScriptReducer, scala.Product, scala.Serializable):
    def __init__(self, scriptBytes: scala.collection.Seq[typing.Any], IR: sigmastate.eval.IRContext): ...
    def IR(self) -> sigmastate.eval.IRContext: ...
    @staticmethod
    def apply(scriptBytes: scala.collection.Seq[typing.Any], IR: sigmastate.eval.IRContext) -> 'PrecompiledScriptReducer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, scriptBytes: scala.collection.Seq[typing.Any], IR: sigmastate.eval.IRContext) -> 'PrecompiledScriptReducer': ...
    def copy$default$1(self) -> scala.collection.Seq[typing.Any]: ...
    def costingRes(self) -> sigmastate.eval.IRContext.RCostingResultEx[typing.Any]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def reduce(self, context: InterpreterContext) -> Interpreter.ReductionResult: ...
    def scriptBytes(self) -> scala.collection.Seq[typing.Any]: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'PrecompiledScriptReducer') -> scala.Option[scala.collection.Seq[typing.Any]]: ...

class ProverUtils(Interpreter):
    @staticmethod
    def $init$($this: 'ProverUtils') -> None: ...
    @typing.overload
    def bagForMultisig(self, context: InterpreterContext, ergoTree: sigmastate.Values.ErgoTree, proof: typing.List[int], realSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean], simulatedSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> HintsBag: ...
    @typing.overload
    def bagForMultisig(self, context: InterpreterContext, sigmaTree: sigmastate.Values.SigmaBoolean, proof: typing.List[int], realSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean], simulatedSecretsToExtract: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> HintsBag: ...
    def bagForMultisig$default$5(self) -> scala.collection.Seq[sigmastate.Values.SigmaBoolean]: ...
    @typing.overload
    def generateCommitmentsFor(self, ergoTree: sigmastate.Values.ErgoTree, context: InterpreterContext, generateFor: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> HintsBag: ...
    @typing.overload
    def generateCommitmentsFor(self, sigmaTree: sigmastate.Values.SigmaBoolean, generateFor: scala.collection.Seq[sigmastate.Values.SigmaBoolean]) -> HintsBag: ...

class SecretProven(Hint):
    def __init__(self): ...
    def challenge(self) -> typing.List[int]: ...
    def image(self) -> sigmastate.Values.SigmaBoolean: ...
    def uncheckedTree(self) -> sigmastate.UncheckedTree: ...

class SeqCostItem(CostItem, scala.Product, scala.Serializable):
    def __init__(self, opDesc: OperationDesc, costKind: sigmastate.PerItemCost, nItems: int): ...
    @typing.overload
    @staticmethod
    def apply(companion: sigmastate.Values.PerItemCostValueCompanion, nItems: int) -> 'SeqCostItem': ...
    @typing.overload
    @staticmethod
    def apply(opDesc: OperationDesc, costKind: sigmastate.PerItemCost, nItems: int) -> 'SeqCostItem': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def chunks(self) -> int: ...
    def copy(self, opDesc: OperationDesc, costKind: sigmastate.PerItemCost, nItems: int) -> 'SeqCostItem': ...
    def copy$default$1(self) -> OperationDesc: ...
    def copy$default$2(self) -> sigmastate.PerItemCost: ...
    def copy$default$3(self) -> int: ...
    def cost(self) -> int: ...
    def costKind(self) -> sigmastate.PerItemCost: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def nItems(self) -> int: ...
    def opDesc(self) -> OperationDesc: ...
    def opName(self) -> java.lang.String: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'SeqCostItem') -> scala.Option[scala.Tuple3[OperationDesc, sigmastate.PerItemCost, typing.Any]]: ...

class TracedCost(CostDetails, scala.Product, scala.Serializable):
    def __init__(self, trace: scala.collection.Seq[CostItem], actualTimeNano: scala.Option[typing.Any]): ...
    @staticmethod
    def $lessinit$greater$default$2() -> scala.Option[typing.Any]: ...
    def actualTimeNano(self) -> scala.Option[typing.Any]: ...
    @typing.overload
    @staticmethod
    def apply(trace: scala.collection.Seq[CostItem]) -> CostDetails: ...
    @typing.overload
    @staticmethod
    def apply(trace: scala.collection.Seq[CostItem], actualTimeNano: scala.Option[typing.Any]) -> 'TracedCost': ...
    @staticmethod
    def apply$default$2() -> scala.Option[typing.Any]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, trace: scala.collection.Seq[CostItem], actualTimeNano: scala.Option[typing.Any]) -> 'TracedCost': ...
    def copy$default$1(self) -> scala.collection.Seq[CostItem]: ...
    def copy$default$2(self) -> scala.Option[typing.Any]: ...
    def cost(self) -> int: ...
    @staticmethod
    def curried() -> scala.Function1[scala.collection.Seq[CostItem], scala.Function1[scala.Option[typing.Any], 'TracedCost']]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def trace(self) -> scala.collection.Seq[CostItem]: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[scala.collection.Seq[CostItem], scala.Option[typing.Any]], 'TracedCost']: ...
    @typing.overload
    @staticmethod
    def unapply(d: CostDetails) -> scala.Option[scala.Tuple2[typing.Any, scala.collection.Seq[CostItem]]]: ...
    @typing.overload
    @staticmethod
    def unapply(x$0: 'TracedCost') -> scala.Option[scala.Tuple2[scala.collection.Seq[CostItem], scala.Option[typing.Any]]]: ...

class TypeBasedCostItem(CostItem, scala.Product, scala.Serializable):
    def __init__(self, opDesc: OperationDesc, costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType): ...
    @typing.overload
    @staticmethod
    def apply(companion: sigmastate.Values.ValueCompanion, tpe: sigmastate.SType) -> 'TypeBasedCostItem': ...
    @typing.overload
    @staticmethod
    def apply(opDesc: OperationDesc, costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType) -> 'TypeBasedCostItem': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, opDesc: OperationDesc, costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType) -> 'TypeBasedCostItem': ...
    def copy$default$1(self) -> OperationDesc: ...
    def copy$default$2(self) -> sigmastate.TypeBasedCost: ...
    def copy$default$3(self) -> sigmastate.SType: ...
    def cost(self) -> int: ...
    def costKind(self) -> sigmastate.TypeBasedCost: ...
    def equals(self, obj: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> OperationDesc: ...
    def opName(self) -> java.lang.String: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def tpe(self) -> sigmastate.SType: ...
    @staticmethod
    def unapply(x$0: 'TypeBasedCostItem') -> scala.Option[scala.Tuple3[OperationDesc, sigmastate.TypeBasedCost, sigmastate.SType]]: ...

class OwnCommitment(CommitmentHint, scala.Product, scala.Serializable):
    def __init__(self, image: sigmastate.Values.SigmaBoolean, secretRandomness: java.math.BigInteger, commitment: sigmastate.basics.FirstProverMessage, position: sigmastate.NodePosition): ...
    @staticmethod
    def apply(image: sigmastate.Values.SigmaBoolean, secretRandomness: java.math.BigInteger, commitment: sigmastate.basics.FirstProverMessage, position: sigmastate.NodePosition) -> 'OwnCommitment': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def commitment(self) -> sigmastate.basics.FirstProverMessage: ...
    def copy(self, image: sigmastate.Values.SigmaBoolean, secretRandomness: java.math.BigInteger, commitment: sigmastate.basics.FirstProverMessage, position: sigmastate.NodePosition) -> 'OwnCommitment': ...
    def copy$default$1(self) -> sigmastate.Values.SigmaBoolean: ...
    def copy$default$2(self) -> java.math.BigInteger: ...
    def copy$default$3(self) -> sigmastate.basics.FirstProverMessage: ...
    def copy$default$4(self) -> sigmastate.NodePosition: ...
    @staticmethod
    def curried() -> scala.Function1[sigmastate.Values.SigmaBoolean, scala.Function1[java.math.BigInteger, scala.Function1[sigmastate.basics.FirstProverMessage, scala.Function1[sigmastate.NodePosition, 'OwnCommitment']]]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def image(self) -> sigmastate.Values.SigmaBoolean: ...
    def position(self) -> sigmastate.NodePosition: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def secretRandomness(self) -> java.math.BigInteger: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple4[sigmastate.Values.SigmaBoolean, java.math.BigInteger, sigmastate.basics.FirstProverMessage, sigmastate.NodePosition], 'OwnCommitment']: ...
    @staticmethod
    def unapply(x$0: 'OwnCommitment') -> scala.Option[scala.Tuple4[sigmastate.Values.SigmaBoolean, java.math.BigInteger, sigmastate.basics.FirstProverMessage, sigmastate.NodePosition]]: ...

class ProverInterpreter(ProverUtils, org.bitbucket.inkytonik.kiama.attribution.AttributionCore):
    @staticmethod
    def $init$($this: 'ProverInterpreter') -> None: ...
    def convertToUnchecked(self) -> scala.Function1[sigmastate.ProofTree, sigmastate.UncheckedSigmaTree]: ...
    def convertToUnproven(self, sigmaTree: sigmastate.Values.SigmaBoolean) -> sigmastate.UnprovenTree: ...
    @typing.overload
    def generateCommitments(self, ergoTree: sigmastate.Values.ErgoTree, ctx: InterpreterContext) -> HintsBag: ...
    @typing.overload
    def generateCommitments(self, sigmaTree: sigmastate.Values.SigmaBoolean) -> HintsBag: ...
    def generateProof(self, sb: sigmastate.Values.SigmaBoolean, message: typing.List[int], hintsBag: HintsBag) -> typing.List[int]: ...
    def markReal(self, hintsBag: HintsBag) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    def polishSimulated(self) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    @typing.overload
    def prove(self, env: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any], ergoTree: sigmastate.Values.ErgoTree, context: InterpreterContext, message: typing.List[int], hintsBag: HintsBag) -> scala.util.Try[CostedProverResult]: ...
    @typing.overload
    def prove(self, ergoTree: sigmastate.Values.ErgoTree, context: InterpreterContext, message: typing.List[int]) -> scala.util.Try[CostedProverResult]: ...
    @typing.overload
    def prove(self, ergoTree: sigmastate.Values.ErgoTree, context: InterpreterContext, message: typing.List[int], hintsBag: HintsBag) -> scala.util.Try[CostedProverResult]: ...
    @typing.overload
    def prove(self, unprovenTree: sigmastate.UnprovenTree, message: typing.List[int], hintsBag: HintsBag) -> sigmastate.UncheckedTree: ...
    def prove$default$5(self) -> HintsBag: ...
    def proving(self, hintsBag: HintsBag) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    def publicKeys(self) -> scala.collection.Seq[sigmastate.Values.SigmaBoolean]: ...
    def secrets(self) -> scala.collection.Seq[sigmastate.basics.SigmaProtocolPrivateInput[typing.Any, typing.Any]]: ...
    def setPositions(self, uc: sigmastate.UnprovenConjecture) -> sigmastate.UnprovenConjecture: ...
    def sigmastate$interpreter$ProverInterpreter$$extractChallenge(self, pt: sigmastate.ProofTree) -> scala.Option[typing.List[int]]: ...
    def sigmastate$interpreter$ProverInterpreter$_setter_$convertToUnchecked_$eq(self, x$1: scala.Function1[sigmastate.ProofTree, sigmastate.UncheckedSigmaTree]) -> None: ...
    def sigmastate$interpreter$ProverInterpreter$_setter_$polishSimulated_$eq(self, x$1: org.bitbucket.inkytonik.kiama.rewriting.Strategy) -> None: ...
    def signMessage(self, sigmaTree: sigmastate.Values.SigmaBoolean, message: typing.List[int], hintsBag: HintsBag) -> scala.util.Try[typing.List[int]]: ...
    def simulateAndCommit(self, hintsBag: HintsBag) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...

class RealCommitment(CommitmentHint, scala.Product, scala.Serializable):
    def __init__(self, image: sigmastate.Values.SigmaBoolean, commitment: sigmastate.basics.FirstProverMessage, position: sigmastate.NodePosition): ...
    @staticmethod
    def apply(image: sigmastate.Values.SigmaBoolean, commitment: sigmastate.basics.FirstProverMessage, position: sigmastate.NodePosition) -> 'RealCommitment': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def commitment(self) -> sigmastate.basics.FirstProverMessage: ...
    def copy(self, image: sigmastate.Values.SigmaBoolean, commitment: sigmastate.basics.FirstProverMessage, position: sigmastate.NodePosition) -> 'RealCommitment': ...
    def copy$default$1(self) -> sigmastate.Values.SigmaBoolean: ...
    def copy$default$2(self) -> sigmastate.basics.FirstProverMessage: ...
    def copy$default$3(self) -> sigmastate.NodePosition: ...
    @staticmethod
    def curried() -> scala.Function1[sigmastate.Values.SigmaBoolean, scala.Function1[sigmastate.basics.FirstProverMessage, scala.Function1[sigmastate.NodePosition, 'RealCommitment']]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def image(self) -> sigmastate.Values.SigmaBoolean: ...
    def position(self) -> sigmastate.NodePosition: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple3[sigmastate.Values.SigmaBoolean, sigmastate.basics.FirstProverMessage, sigmastate.NodePosition], 'RealCommitment']: ...
    @staticmethod
    def unapply(x$0: 'RealCommitment') -> scala.Option[scala.Tuple3[sigmastate.Values.SigmaBoolean, sigmastate.basics.FirstProverMessage, sigmastate.NodePosition]]: ...

class RealSecretProof(SecretProven, scala.Product, scala.Serializable):
    def __init__(self, image: sigmastate.Values.SigmaBoolean, challenge: typing.List[int], uncheckedTree: sigmastate.UncheckedTree, position: sigmastate.NodePosition): ...
    @staticmethod
    def apply(image: sigmastate.Values.SigmaBoolean, challenge: typing.List[int], uncheckedTree: sigmastate.UncheckedTree, position: sigmastate.NodePosition) -> 'RealSecretProof': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def challenge(self) -> typing.List[int]: ...
    def copy(self, image: sigmastate.Values.SigmaBoolean, challenge: typing.List[int], uncheckedTree: sigmastate.UncheckedTree, position: sigmastate.NodePosition) -> 'RealSecretProof': ...
    def copy$default$1(self) -> sigmastate.Values.SigmaBoolean: ...
    def copy$default$2(self) -> typing.List[int]: ...
    def copy$default$3(self) -> sigmastate.UncheckedTree: ...
    def copy$default$4(self) -> sigmastate.NodePosition: ...
    @staticmethod
    def curried() -> scala.Function1[sigmastate.Values.SigmaBoolean, scala.Function1[typing.List[int], scala.Function1[sigmastate.UncheckedTree, scala.Function1[sigmastate.NodePosition, 'RealSecretProof']]]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def image(self) -> sigmastate.Values.SigmaBoolean: ...
    def position(self) -> sigmastate.NodePosition: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple4[sigmastate.Values.SigmaBoolean, typing.List[int], sigmastate.UncheckedTree, sigmastate.NodePosition], 'RealSecretProof']: ...
    @staticmethod
    def unapply(x$0: 'RealSecretProof') -> scala.Option[scala.Tuple4[sigmastate.Values.SigmaBoolean, typing.List[int], sigmastate.UncheckedTree, sigmastate.NodePosition]]: ...
    def uncheckedTree(self) -> sigmastate.UncheckedTree: ...

class SimulatedCommitment(CommitmentHint, scala.Product, scala.Serializable):
    def __init__(self, image: sigmastate.Values.SigmaBoolean, commitment: sigmastate.basics.FirstProverMessage, position: sigmastate.NodePosition): ...
    @staticmethod
    def apply(image: sigmastate.Values.SigmaBoolean, commitment: sigmastate.basics.FirstProverMessage, position: sigmastate.NodePosition) -> 'SimulatedCommitment': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def commitment(self) -> sigmastate.basics.FirstProverMessage: ...
    def copy(self, image: sigmastate.Values.SigmaBoolean, commitment: sigmastate.basics.FirstProverMessage, position: sigmastate.NodePosition) -> 'SimulatedCommitment': ...
    def copy$default$1(self) -> sigmastate.Values.SigmaBoolean: ...
    def copy$default$2(self) -> sigmastate.basics.FirstProverMessage: ...
    def copy$default$3(self) -> sigmastate.NodePosition: ...
    @staticmethod
    def curried() -> scala.Function1[sigmastate.Values.SigmaBoolean, scala.Function1[sigmastate.basics.FirstProverMessage, scala.Function1[sigmastate.NodePosition, 'SimulatedCommitment']]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def image(self) -> sigmastate.Values.SigmaBoolean: ...
    def position(self) -> sigmastate.NodePosition: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple3[sigmastate.Values.SigmaBoolean, sigmastate.basics.FirstProverMessage, sigmastate.NodePosition], 'SimulatedCommitment']: ...
    @staticmethod
    def unapply(x$0: 'SimulatedCommitment') -> scala.Option[scala.Tuple3[sigmastate.Values.SigmaBoolean, sigmastate.basics.FirstProverMessage, sigmastate.NodePosition]]: ...

class SimulatedSecretProof(SecretProven, scala.Product, scala.Serializable):
    def __init__(self, image: sigmastate.Values.SigmaBoolean, challenge: typing.List[int], uncheckedTree: sigmastate.UncheckedTree, position: sigmastate.NodePosition): ...
    @staticmethod
    def apply(image: sigmastate.Values.SigmaBoolean, challenge: typing.List[int], uncheckedTree: sigmastate.UncheckedTree, position: sigmastate.NodePosition) -> 'SimulatedSecretProof': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def challenge(self) -> typing.List[int]: ...
    def copy(self, image: sigmastate.Values.SigmaBoolean, challenge: typing.List[int], uncheckedTree: sigmastate.UncheckedTree, position: sigmastate.NodePosition) -> 'SimulatedSecretProof': ...
    def copy$default$1(self) -> sigmastate.Values.SigmaBoolean: ...
    def copy$default$2(self) -> typing.List[int]: ...
    def copy$default$3(self) -> sigmastate.UncheckedTree: ...
    def copy$default$4(self) -> sigmastate.NodePosition: ...
    @staticmethod
    def curried() -> scala.Function1[sigmastate.Values.SigmaBoolean, scala.Function1[typing.List[int], scala.Function1[sigmastate.UncheckedTree, scala.Function1[sigmastate.NodePosition, 'SimulatedSecretProof']]]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def image(self) -> sigmastate.Values.SigmaBoolean: ...
    def position(self) -> sigmastate.NodePosition: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple4[sigmastate.Values.SigmaBoolean, typing.List[int], sigmastate.UncheckedTree, sigmastate.NodePosition], 'SimulatedSecretProof']: ...
    @staticmethod
    def unapply(x$0: 'SimulatedSecretProof') -> scala.Option[scala.Tuple4[sigmastate.Values.SigmaBoolean, typing.List[int], sigmastate.UncheckedTree, sigmastate.NodePosition]]: ...
    def uncheckedTree(self) -> sigmastate.UncheckedTree: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("sigmastate.interpreter")``.

    CacheKey: typing.Type[CacheKey]
    CommitmentHint: typing.Type[CommitmentHint]
    CompanionDesc: typing.Type[CompanionDesc]
    ContextExtension: typing.Type[ContextExtension]
    CostAccumulator: typing.Type[CostAccumulator]
    CostCounter: typing.Type[CostCounter]
    CostDetails: typing.Type[CostDetails]
    CostItem: typing.Type[CostItem]
    CostedProverResult: typing.Type[CostedProverResult]
    CryptoConstants: typing.Type[CryptoConstants]
    CryptoFunctions: typing.Type[CryptoFunctions]
    ErgoTreeEvaluator: typing.Type[ErgoTreeEvaluator]
    EvalSettings: typing.Type[EvalSettings]
    FixedCostItem: typing.Type[FixedCostItem]
    GivenCost: typing.Type[GivenCost]
    Hint: typing.Type[Hint]
    HintsBag: typing.Type[HintsBag]
    Interpreter: typing.Type[Interpreter]
    InterpreterContext: typing.Type[InterpreterContext]
    MethodCallCostItem: typing.Type[MethodCallCostItem]
    MethodDesc: typing.Type[MethodDesc]
    NamedDesc: typing.Type[NamedDesc]
    OperationCostInfo: typing.Type[OperationCostInfo]
    OperationDesc: typing.Type[OperationDesc]
    OwnCommitment: typing.Type[OwnCommitment]
    PrecompiledScriptProcessor: typing.Type[PrecompiledScriptProcessor]
    PrecompiledScriptReducer: typing.Type[PrecompiledScriptReducer]
    ProcessorStats: typing.Type[ProcessorStats]
    ProverInterpreter: typing.Type[ProverInterpreter]
    ProverResult: typing.Type[ProverResult]
    ProverUtils: typing.Type[ProverUtils]
    RealCommitment: typing.Type[RealCommitment]
    RealSecretProof: typing.Type[RealSecretProof]
    ScriptProcessorSettings: typing.Type[ScriptProcessorSettings]
    ScriptReducer: typing.Type[ScriptReducer]
    SecretProven: typing.Type[SecretProven]
    SeqCostItem: typing.Type[SeqCostItem]
    SimulatedCommitment: typing.Type[SimulatedCommitment]
    SimulatedSecretProof: typing.Type[SimulatedSecretProof]
    TracedCost: typing.Type[TracedCost]
    TypeBasedCostItem: typing.Type[TypeBasedCostItem]
    WhenSoftForkReducer: typing.Type[WhenSoftForkReducer]
