import debox
import io.circe
import java.lang
import org.bouncycastle.math.ec.custom.sec
import org.ergoplatform.validation
import scala
import scala.collection
import scala.collection.immutable
import scala.collection.mutable
import scala.math
import scala.reflect
import scala.runtime
import scala.util
import scorex.util.serialization
import sigmastate
import sigmastate.basics
import sigmastate.lang
import sigmastate.serialization.transformers
import sigmastate.serialization.trees
import sigmastate.utils
import sigmastate.utxo
import special.collection
import special.sigma
import supertagged
import typing



class ConstantStore:
    def __init__(self, constants: scala.collection.IndexedSeq[sigmastate.Values.Constant[sigmastate.SType]]): ...
    @staticmethod
    def $lessinit$greater$default$1() -> scala.collection.IndexedSeq[sigmastate.Values.Constant[sigmastate.SType]]: ...
    def get(self, index: int) -> sigmastate.Values.Constant[sigmastate.SType]: ...
    def getAll(self) -> scala.collection.IndexedSeq[sigmastate.Values.Constant[sigmastate.SType]]: ...
    _put__T = typing.TypeVar('_put__T', bound=sigmastate.SType)  # <T>
    def put(self, c: sigmastate.Values.Constant[_put__T], builder: sigmastate.lang.SigmaBuilder) -> sigmastate.Values.ConstantPlaceholder[_put__T]: ...
    def sigmastate$serialization$ConstantStore$$store(self) -> debox.Buffer[sigmastate.Values.Constant[sigmastate.SType]]: ...

class DataJsonEncoder:
    @staticmethod
    def decode(json: io.circe.Json) -> typing.Any: ...
    @staticmethod
    def decodeAnyValue(json: io.circe.Json) -> special.sigma.AnyValue: ...
    _encode__T = typing.TypeVar('_encode__T', bound=sigmastate.SType)  # <T>
    @staticmethod
    def encode(v: typing.Any, tpe: _encode__T) -> io.circe.Json: ...
    @staticmethod
    def encodeAnyValue(v: special.sigma.AnyValue) -> io.circe.Json: ...

class DataSerializer:
    _deserialize__T = typing.TypeVar('_deserialize__T', bound=sigmastate.SType)  # <T>
    @staticmethod
    def deserialize(tpe: _deserialize__T, r: sigmastate.utils.SigmaByteReader) -> typing.Any: ...
    _deserializeColl__T = typing.TypeVar('_deserializeColl__T', bound=sigmastate.SType)  # <T>
    @staticmethod
    def deserializeColl(len: int, tpeElem: _deserializeColl__T, r: sigmastate.utils.SigmaByteReader) -> special.collection.Coll[typing.Any]: ...
    _serialize__T = typing.TypeVar('_serialize__T', bound=sigmastate.SType)  # <T>
    @staticmethod
    def serialize(v: typing.Any, tpe: _serialize__T, w: sigmastate.utils.SigmaByteWriter) -> None: ...

class ErgoTreeSerializer:
    def __init__(self): ...
    @staticmethod
    def DefaultSerializer() -> 'ErgoTreeSerializer': ...
    @typing.overload
    def deserializeErgoTree(self, bytes: typing.List[int]) -> sigmastate.Values.ErgoTree: ...
    @typing.overload
    def deserializeErgoTree(self, r: sigmastate.utils.SigmaByteReader, maxTreeSizeBytes: int) -> sigmastate.Values.ErgoTree: ...
    @typing.overload
    def deserializeErgoTree(self, r: sigmastate.utils.SigmaByteReader, maxTreeSizeBytes: int, checkType: bool) -> sigmastate.Values.ErgoTree: ...
    def deserializeHeaderWithTreeBytes(self, r: sigmastate.utils.SigmaByteReader) -> scala.Tuple4[typing.Any, scala.Option[typing.Any], scala.collection.IndexedSeq[sigmastate.Values.Constant[sigmastate.SType]], typing.List[int]]: ...
    def serializeErgoTree(self, ergoTree: sigmastate.Values.ErgoTree) -> typing.List[int]: ...
    def substituteConstants(self, scriptBytes: typing.List[int], positions: typing.List[int], newVals: typing.List[sigmastate.Values.Value[sigmastate.SType]], vs: org.ergoplatform.validation.SigmaValidationSettings) -> scala.Tuple2[typing.List[int], typing.Any]: ...

class GroupElementSerializer:
    @staticmethod
    def error(msg: typing.Union[java.lang.String, str]) -> scala.runtime.Nothing.: ...
    @staticmethod
    def fromBytes(bytes: typing.List[int]) -> typing.Any: ...
    @typing.overload
    @staticmethod
    def parse(bytes: typing.List[int]) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    @typing.overload
    @staticmethod
    def parse(r: sigmastate.utils.SigmaByteReader) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    @staticmethod
    def parseTry(r: scorex.util.serialization.Reader) -> scala.util.Try: ...
    @staticmethod
    def parseWithGenericReader(r: scorex.util.serialization.Reader, vs: org.ergoplatform.validation.SigmaValidationSettings) -> typing.Any: ...
    @staticmethod
    def serialize(point: org.bouncycastle.math.ec.custom.sec.SecP256K1Point, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    @staticmethod
    def serializeWithGenericWriter(obj: typing.Any, w: scorex.util.serialization.Writer) -> None: ...
    @staticmethod
    def toBytes(obj: typing.Any) -> typing.List[int]: ...

class ModQSerializer:
    @staticmethod
    def companion() -> 'ValueSerializer.': ...
    @staticmethod
    def complexity() -> int: ...
    @staticmethod
    def error(msg: typing.Union[java.lang.String, str]) -> scala.runtime.Nothing.: ...
    @staticmethod
    def fromBytes(bytes: typing.List[int]) -> typing.Any: ...
    @staticmethod
    def getComplexity() -> int: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.ModQ.: ...
    @staticmethod
    def parse(r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    @staticmethod
    def parseTry(r: scorex.util.serialization.Reader) -> scala.util.Try: ...
    @staticmethod
    def parseWithGenericReader(r: scorex.util.serialization.Reader, vs: org.ergoplatform.validation.SigmaValidationSettings) -> typing.Any: ...
    @staticmethod
    def serialize(obj: sigmastate.ModQ, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    @staticmethod
    def serializeWithGenericWriter(obj: typing.Any, w: scorex.util.serialization.Writer) -> None: ...
    @staticmethod
    def toBytes(obj: typing.Any) -> typing.List[int]: ...

class OpCodes:
    @staticmethod
    def AndCode() -> int: ...
    @staticmethod
    def AppendCode() -> int: ...
    @staticmethod
    def AtLeastCode() -> int: ...
    @staticmethod
    def AvlTreeCode() -> int: ...
    @staticmethod
    def AvlTreeGetCode() -> int: ...
    @staticmethod
    def BinAndCode() -> int: ...
    @staticmethod
    def BinOrCode() -> int: ...
    @staticmethod
    def BinXorCode() -> int: ...
    @staticmethod
    def BitAndCode() -> int: ...
    @staticmethod
    def BitInversionCode() -> int: ...
    @staticmethod
    def BitOrCode() -> int: ...
    @staticmethod
    def BitShiftLeftCode() -> int: ...
    @staticmethod
    def BitShiftRightCode() -> int: ...
    @staticmethod
    def BitShiftRightZeroedCode() -> int: ...
    @staticmethod
    def BitXorCode() -> int: ...
    @staticmethod
    def BlockValueCode() -> int: ...
    @staticmethod
    def BoolToSigmaPropCode() -> int: ...
    @staticmethod
    def ByIndexCode() -> int: ...
    @staticmethod
    def ByteArrayToBigIntCode() -> int: ...
    @staticmethod
    def ByteArrayToLongCode() -> int: ...
    @staticmethod
    def CBMFromItemsCode() -> int: ...
    @staticmethod
    def CBMReplicateCode() -> int: ...
    @staticmethod
    def CReplCollCtorCode() -> int: ...
    @staticmethod
    def CSizeAnyValueCtorCode() -> int: ...
    @staticmethod
    def CSizeBoxCtorCode() -> int: ...
    @staticmethod
    def CSizeCollCtorCode() -> int: ...
    @staticmethod
    def CSizeContextCtorCode() -> int: ...
    @staticmethod
    def CSizeFuncCtorCode() -> int: ...
    @staticmethod
    def CSizeOptionCtorCode() -> int: ...
    @staticmethod
    def CSizePairCtorCode() -> int: ...
    @staticmethod
    def CalcBlake2b256Code() -> int: ...
    @staticmethod
    def CalcSha256Code() -> int: ...
    @staticmethod
    def CastCode() -> int: ...
    @staticmethod
    def CollMSumCode() -> int: ...
    @staticmethod
    def CollRotateLeftCode() -> int: ...
    @staticmethod
    def CollRotateRightCode() -> int: ...
    @staticmethod
    def CollShiftLeftCode() -> int: ...
    @staticmethod
    def CollShiftRightCode() -> int: ...
    @staticmethod
    def CollShiftRightZeroedCode() -> int: ...
    @staticmethod
    def ConcreteCollectionBooleanConstantCode() -> int: ...
    @staticmethod
    def ConcreteCollectionCode() -> int: ...
    @staticmethod
    def ConstantCode() -> int: ...
    @staticmethod
    def ConstantPlaceholderCode() -> int: ...
    @staticmethod
    def ContextCode() -> int: ...
    @staticmethod
    def CostOfCode() -> int: ...
    @staticmethod
    def DecodePointCode() -> int: ...
    @staticmethod
    def DeserializeContextCode() -> int: ...
    @staticmethod
    def DeserializeRegisterCode() -> int: ...
    @staticmethod
    def DivisionCode() -> int: ...
    @staticmethod
    def DowncastCode() -> int: ...
    @staticmethod
    def EqCode() -> int: ...
    @staticmethod
    def ExistsCode() -> int: ...
    @staticmethod
    def ExponentiateCode() -> int: ...
    @staticmethod
    def ExtractAmountCode() -> int: ...
    @staticmethod
    def ExtractBytesCode() -> int: ...
    @staticmethod
    def ExtractBytesWithNoRefCode() -> int: ...
    @staticmethod
    def ExtractCreationInfoCode() -> int: ...
    @staticmethod
    def ExtractIdCode() -> int: ...
    @staticmethod
    def ExtractRegisterAs() -> int: ...
    @staticmethod
    def ExtractScriptBytesCode() -> int: ...
    @staticmethod
    def FalseCode() -> int: ...
    @staticmethod
    def FilterCode() -> int: ...
    @staticmethod
    def FirstDataType() -> int: ...
    @staticmethod
    def FirstFuncType() -> int: ...
    @staticmethod
    def FlatMapCollectionCode() -> int: ...
    @staticmethod
    def FoldCode() -> int: ...
    @staticmethod
    def ForAllCode() -> int: ...
    @staticmethod
    def FunDefCode() -> int: ...
    @staticmethod
    def FuncApplyCode() -> int: ...
    @staticmethod
    def FuncValueCode() -> int: ...
    @staticmethod
    def GeCode() -> int: ...
    @staticmethod
    def GetVarCode() -> int: ...
    @staticmethod
    def GlobalCode() -> int: ...
    @staticmethod
    def GroupGeneratorCode() -> int: ...
    @staticmethod
    def GtCode() -> int: ...
    @staticmethod
    def HeightCode() -> int: ...
    @staticmethod
    def IfCode() -> int: ...
    @staticmethod
    def InputsCode() -> int: ...
    @staticmethod
    def IntPlusMonoidCode() -> int: ...
    @staticmethod
    def LastBlockUtxoRootHashCode() -> int: ...
    @staticmethod
    def LastConstantCode() -> int: ...
    @staticmethod
    def LastDataType() -> int: ...
    @staticmethod
    def LastFuncType() -> int: ...
    @staticmethod
    def LeCode() -> int: ...
    @staticmethod
    def LogicalNotCode() -> int: ...
    @staticmethod
    def LongToByteArrayCode() -> int: ...
    @staticmethod
    def LtCode() -> int: ...
    @staticmethod
    def MapCollectionCode() -> int: ...
    @staticmethod
    def MaxCode() -> int: ...
    @staticmethod
    def MethodCallCode() -> int: ...
    @staticmethod
    def MinCode() -> int: ...
    @staticmethod
    def MinerPubkeyCode() -> int: ...
    @staticmethod
    def MinusCode() -> int: ...
    @staticmethod
    def MinusModQCode() -> int: ...
    @staticmethod
    def ModQCode() -> int: ...
    @staticmethod
    def ModuloCode() -> int: ...
    @staticmethod
    def MultiplyCode() -> int: ...
    @staticmethod
    def MultiplyGroupCode() -> int: ...
    @staticmethod
    def NegationCode() -> int: ...
    @staticmethod
    def NeqCode() -> int: ...
    @staticmethod
    def NoneValueCode() -> int: ...
    @staticmethod
    def OpCostCode() -> int: ...
    @staticmethod
    def OptionGetCode() -> int: ...
    @staticmethod
    def OptionGetOrElseCode() -> int: ...
    @staticmethod
    def OptionIsDefinedCode() -> int: ...
    @staticmethod
    def OrCode() -> int: ...
    @staticmethod
    def OutputsCode() -> int: ...
    @staticmethod
    def PairOfColsCtorCode() -> int: ...
    @staticmethod
    def PerKbCostOfCode() -> int: ...
    @staticmethod
    def PlusCode() -> int: ...
    @staticmethod
    def PlusModQCode() -> int: ...
    @staticmethod
    def PropertyCallCode() -> int: ...
    @staticmethod
    def ProveDiffieHellmanTupleCode() -> int: ...
    @staticmethod
    def ProveDlogCode() -> int: ...
    @staticmethod
    def SAVMTValCode() -> int: ...
    @staticmethod
    def SAVMValueSizeCode() -> int: ...
    @staticmethod
    def SBMBytesCode() -> int: ...
    @staticmethod
    def SBMBytesWithoutRefCode() -> int: ...
    @staticmethod
    def SBMGetRegCode() -> int: ...
    @staticmethod
    def SBMPropositionBytesCode() -> int: ...
    @staticmethod
    def SBMRegistersCode() -> int: ...
    @staticmethod
    def SBMTokensCode() -> int: ...
    @staticmethod
    def SCMDataInputsCode() -> int: ...
    @staticmethod
    def SCMGetVarCode() -> int: ...
    @staticmethod
    def SCMHeadersCode() -> int: ...
    @staticmethod
    def SCMInputsCode() -> int: ...
    @staticmethod
    def SCMLastBlockUtxoRootHashCode() -> int: ...
    @staticmethod
    def SCMOutputsCode() -> int: ...
    @staticmethod
    def SCMPreHeaderCode() -> int: ...
    @staticmethod
    def SCMSelfBoxCode() -> int: ...
    @staticmethod
    def SCollMSizesCode() -> int: ...
    @staticmethod
    def SFuncMSizeEnvCode() -> int: ...
    @staticmethod
    def SOptMSizeOptCode() -> int: ...
    @staticmethod
    def SPCMSomeCode() -> int: ...
    @staticmethod
    def SPairLCode() -> int: ...
    @staticmethod
    def SPairRCode() -> int: ...
    @staticmethod
    def SSPMPropBytesCode() -> int: ...
    @staticmethod
    def Select1Code() -> int: ...
    @staticmethod
    def Select2Code() -> int: ...
    @staticmethod
    def Select3Code() -> int: ...
    @staticmethod
    def Select4Code() -> int: ...
    @staticmethod
    def Select5Code() -> int: ...
    @staticmethod
    def SelectFieldCode() -> int: ...
    @staticmethod
    def SelfCode() -> int: ...
    @staticmethod
    def SigmaAndCode() -> int: ...
    @staticmethod
    def SigmaOrCode() -> int: ...
    @staticmethod
    def SigmaPropBytesCode() -> int: ...
    @staticmethod
    def SigmaPropIsProvenCode() -> int: ...
    @staticmethod
    def SizeMDataSizeCode() -> int: ...
    @staticmethod
    def SizeOfCode() -> int: ...
    @staticmethod
    def SliceCode() -> int: ...
    @staticmethod
    def SomeValueCode() -> int: ...
    @staticmethod
    def SubstConstantsCode() -> int: ...
    @staticmethod
    def TaggedVariableCode() -> int: ...
    @staticmethod
    def ThunkDefCode() -> int: ...
    @staticmethod
    def ThunkForceCode() -> int: ...
    @staticmethod
    def TrivialPropFalseCode() -> int: ...
    @staticmethod
    def TrivialPropTrueCode() -> int: ...
    @staticmethod
    def TrueCode() -> int: ...
    @staticmethod
    def TupleCode() -> int: ...
    @staticmethod
    def UOSizeOfCode() -> int: ...
    @staticmethod
    def Undefined() -> int: ...
    @staticmethod
    def UnitConstantCode() -> int: ...
    @staticmethod
    def UpcastCode() -> int: ...
    @staticmethod
    def ValDefCode() -> int: ...
    @staticmethod
    def ValUseCode() -> int: ...
    @staticmethod
    def XorCode() -> int: ...
    @staticmethod
    def XorOfCode() -> int: ...
    @staticmethod
    def toExtra(oc: int) -> int: ...
    class OpCode$(supertagged.package.TaggedType[typing.Any]):
        MODULE$: typing.ClassVar['OpCodes.OpCode.'] = ...
        def __init__(self): ...
        _$at$at__TagIn = typing.TypeVar('_$at$at__TagIn')  # <TagIn>
        _$at$at__Sub = typing.TypeVar('_$at$at__Sub')  # <Sub>
        _$at$at__C = typing.TypeVar('_$at$at__C')  # <C>
        def $at$at(self, c: _.at.at__C, tagger: supertagged.package.Tagger[_.at.at__TagIn, typing.Any, supertagged.package.TaggedType, _.at.at__Sub, _.at.at__C]) -> typing.Any: ...
        _$bang$at$at__TagIn = typing.TypeVar('_$bang$at$at__TagIn')  # <TagIn>
        _$bang$at$at__Sub = typing.TypeVar('_$bang$at$at__Sub')  # <Sub>
        _$bang$at$at__C = typing.TypeVar('_$bang$at$at__C')  # <C>
        def $bang$at$at(self, c: _.bang.at.at__C, tagger: supertagged.package.Tagger[_.bang.at.at__TagIn, typing.Any, supertagged.package.TaggedType, _.bang.at.at__Sub, _.bang.at.at__C]) -> typing.Any: ...
        _apply__TagIn = typing.TypeVar('_apply__TagIn')  # <TagIn>
        _apply__Sub = typing.TypeVar('_apply__Sub')  # <Sub>
        _apply__C = typing.TypeVar('_apply__C')  # <C>
        def apply(self, c: _apply__C, tagger: supertagged.package.Tagger[_apply__TagIn, typing.Any, supertagged.package.TaggedType, _apply__Sub, _apply__C]) -> typing.Any: ...
        _ordering__U = typing.TypeVar('_ordering__U')  # <U>
        def ordering(self, origin: scala.math.Ordering[typing.Any]) -> scala.math.Ordering[typing.Any]: ...
        def raw(self, c: typing.Any) -> typing.Any: ...
        _untag__TagIn = typing.TypeVar('_untag__TagIn')  # <TagIn>
        _untag__Sub = typing.TypeVar('_untag__Sub')  # <Sub>
        _untag__C = typing.TypeVar('_untag__C')  # <C>
        def untag(self, c: _untag__C, tagger: supertagged.package.Tagger[_untag__TagIn, typing.Any, supertagged.package.TaggedType, _untag__Sub, _untag__C]) -> typing.Any: ...
    class OpCodeExtra$(supertagged.package.TaggedType[typing.Any]):
        MODULE$: typing.ClassVar['OpCodes.OpCodeExtra.'] = ...
        def __init__(self): ...
        _$at$at__TagIn = typing.TypeVar('_$at$at__TagIn')  # <TagIn>
        _$at$at__Sub = typing.TypeVar('_$at$at__Sub')  # <Sub>
        _$at$at__C = typing.TypeVar('_$at$at__C')  # <C>
        def $at$at(self, c: _.at.at__C, tagger: supertagged.package.Tagger[_.at.at__TagIn, typing.Any, supertagged.package.TaggedType, _.at.at__Sub, _.at.at__C]) -> typing.Any: ...
        _$bang$at$at__TagIn = typing.TypeVar('_$bang$at$at__TagIn')  # <TagIn>
        _$bang$at$at__Sub = typing.TypeVar('_$bang$at$at__Sub')  # <Sub>
        _$bang$at$at__C = typing.TypeVar('_$bang$at$at__C')  # <C>
        def $bang$at$at(self, c: _.bang.at.at__C, tagger: supertagged.package.Tagger[_.bang.at.at__TagIn, typing.Any, supertagged.package.TaggedType, _.bang.at.at__Sub, _.bang.at.at__C]) -> typing.Any: ...
        _apply__TagIn = typing.TypeVar('_apply__TagIn')  # <TagIn>
        _apply__Sub = typing.TypeVar('_apply__Sub')  # <Sub>
        _apply__C = typing.TypeVar('_apply__C')  # <C>
        def apply(self, c: _apply__C, tagger: supertagged.package.Tagger[_apply__TagIn, typing.Any, supertagged.package.TaggedType, _apply__Sub, _apply__C]) -> typing.Any: ...
        _ordering__U = typing.TypeVar('_ordering__U')  # <U>
        def ordering(self, origin: scala.math.Ordering[typing.Any]) -> scala.math.Ordering[typing.Any]: ...
        def raw(self, c: typing.Any) -> typing.Any: ...
        _untag__TagIn = typing.TypeVar('_untag__TagIn')  # <TagIn>
        _untag__Sub = typing.TypeVar('_untag__Sub')  # <Sub>
        _untag__C = typing.TypeVar('_untag__C')  # <C>
        def untag(self, c: _untag__C, tagger: supertagged.package.Tagger[_untag__TagIn, typing.Any, supertagged.package.TaggedType, _untag__Sub, _untag__C]) -> typing.Any: ...

class SigmaPropBytesSerializer:
    @staticmethod
    def companion() -> 'ValueSerializer.': ...
    @staticmethod
    def complexity() -> int: ...
    @staticmethod
    def error(msg: typing.Union[java.lang.String, str]) -> scala.runtime.Nothing.: ...
    @staticmethod
    def fromBytes(bytes: typing.List[int]) -> typing.Any: ...
    @staticmethod
    def getComplexity() -> int: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.utxo.SigmaPropBytes.: ...
    @staticmethod
    def parse(r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    @staticmethod
    def parseTry(r: scorex.util.serialization.Reader) -> scala.util.Try: ...
    @staticmethod
    def parseWithGenericReader(r: scorex.util.serialization.Reader, vs: org.ergoplatform.validation.SigmaValidationSettings) -> typing.Any: ...
    @staticmethod
    def serialize(obj: sigmastate.utxo.SigmaPropBytes, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    @staticmethod
    def serializeWithGenericWriter(obj: typing.Any, w: scorex.util.serialization.Writer) -> None: ...
    @staticmethod
    def thisInfo() -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    @staticmethod
    def toBytes(obj: typing.Any) -> typing.List[int]: ...

class SigmaPropIsProvenSerializer:
    @staticmethod
    def companion() -> 'ValueSerializer.': ...
    @staticmethod
    def complexity() -> int: ...
    @staticmethod
    def error(msg: typing.Union[java.lang.String, str]) -> scala.runtime.Nothing.: ...
    @staticmethod
    def fromBytes(bytes: typing.List[int]) -> typing.Any: ...
    @staticmethod
    def getComplexity() -> int: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.utxo.SigmaPropIsProven.: ...
    @staticmethod
    def parse(r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    @staticmethod
    def parseTry(r: scorex.util.serialization.Reader) -> scala.util.Try: ...
    @staticmethod
    def parseWithGenericReader(r: scorex.util.serialization.Reader, vs: org.ergoplatform.validation.SigmaValidationSettings) -> typing.Any: ...
    @staticmethod
    def serialize(obj: sigmastate.utxo.SigmaPropIsProven, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    @staticmethod
    def serializeWithGenericWriter(obj: typing.Any, w: scorex.util.serialization.Writer) -> None: ...
    @staticmethod
    def toBytes(obj: typing.Any) -> typing.List[int]: ...

_SigmaSerializer__TFamily = typing.TypeVar('_SigmaSerializer__TFamily')  # <TFamily>
_SigmaSerializer__T = typing.TypeVar('_SigmaSerializer__T')  # <T>
class SigmaSerializer(scorex.util.serialization.Serializer[_SigmaSerializer__TFamily, _SigmaSerializer__T, sigmastate.utils.SigmaByteReader, sigmastate.utils.SigmaByteWriter], typing.Generic[_SigmaSerializer__TFamily, _SigmaSerializer__T]):
    def __init__(self): ...
    @staticmethod
    def MaxPropositionSize() -> int: ...
    @staticmethod
    def MaxTreeDepth() -> int: ...
    def error(self, msg: typing.Union[java.lang.String, str]) -> scala.runtime.Nothing.: ...
    def fromBytes(self, bytes: typing.List[int]) -> _SigmaSerializer__TFamily: ...
    def parseWithGenericReader(self, r: scorex.util.serialization.Reader, vs: org.ergoplatform.validation.SigmaValidationSettings) -> _SigmaSerializer__TFamily: ...
    def serializeWithGenericWriter(self, obj: _SigmaSerializer__T, w: scorex.util.serialization.Writer) -> None: ...
    @typing.overload
    @staticmethod
    def startReader(bytes: typing.List[int], pos: int) -> sigmastate.utils.SigmaByteReader: ...
    @typing.overload
    @staticmethod
    def startReader(bytes: typing.List[int], constantStore: ConstantStore, resolvePlaceholdersToConstants: bool, vs: org.ergoplatform.validation.SigmaValidationSettings) -> sigmastate.utils.SigmaByteReader: ...
    @staticmethod
    def startReader$default$2() -> int: ...
    @typing.overload
    @staticmethod
    def startWriter() -> sigmastate.utils.SigmaByteWriter: ...
    @typing.overload
    @staticmethod
    def startWriter(constantExtractionStore: ConstantStore) -> sigmastate.utils.SigmaByteWriter: ...
    def toBytes(self, obj: _SigmaSerializer__T) -> typing.List[int]: ...

_SigmaSerializerCompanion__TFamily = typing.TypeVar('_SigmaSerializerCompanion__TFamily')  # <TFamily>
class SigmaSerializerCompanion(typing.Generic[_SigmaSerializerCompanion__TFamily]):
    @staticmethod
    def $init$($this: 'SigmaSerializerCompanion') -> None: ...
    def MaxArrayLength(self) -> int: ...
    def deserialize(self, r: sigmastate.utils.SigmaByteReader) -> _SigmaSerializerCompanion__TFamily: ...
    def getSerializer(self, opCode: int) -> SigmaSerializer[_SigmaSerializerCompanion__TFamily, _SigmaSerializerCompanion__TFamily]: ...
    _newArray__A = typing.TypeVar('_newArray__A')  # <A>
    def newArray(self, len: int, tA: scala.reflect.ClassTag[_newArray__A]) -> typing.Any: ...
    def serialize(self, v: _SigmaSerializerCompanion__TFamily, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def sigmastate$serialization$SigmaSerializerCompanion$_setter_$MaxArrayLength_$eq(self, x$1: int) -> None: ...

class SubstConstantsSerializer:
    @staticmethod
    def companion() -> 'ValueSerializer.': ...
    @staticmethod
    def complexity() -> int: ...
    @staticmethod
    def error(msg: typing.Union[java.lang.String, str]) -> scala.runtime.Nothing.: ...
    @staticmethod
    def fromBytes(bytes: typing.List[int]) -> typing.Any: ...
    @staticmethod
    def getComplexity() -> int: ...
    @staticmethod
    def newValuesInfo() -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.SubstConstants.: ...
    @staticmethod
    def parse(r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    @staticmethod
    def parseTry(r: scorex.util.serialization.Reader) -> scala.util.Try: ...
    @staticmethod
    def parseWithGenericReader(r: scorex.util.serialization.Reader, vs: org.ergoplatform.validation.SigmaValidationSettings) -> typing.Any: ...
    @staticmethod
    def positionsInfo() -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    @staticmethod
    def scriptBytesInfo() -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    @staticmethod
    def serialize(obj: sigmastate.SubstConstants[sigmastate.SType], w: sigmastate.utils.SigmaByteWriter) -> None: ...
    @staticmethod
    def serializeWithGenericWriter(obj: typing.Any, w: scorex.util.serialization.Writer) -> None: ...
    @staticmethod
    def toBytes(obj: typing.Any) -> typing.List[int]: ...

class TypeCodes:
    @staticmethod
    def $init$($this: 'TypeCodes') -> None: ...
    def FirstDataType(self) -> int: ...
    def FirstFuncType(self) -> int: ...
    def LastDataType(self) -> int: ...
    def LastFuncType(self) -> int: ...
    def sigmastate$serialization$TypeCodes$_setter_$FirstDataType_$eq(self, x$1: int) -> None: ...
    def sigmastate$serialization$TypeCodes$_setter_$FirstFuncType_$eq(self, x$1: int) -> None: ...
    def sigmastate$serialization$TypeCodes$_setter_$LastDataType_$eq(self, x$1: int) -> None: ...
    def sigmastate$serialization$TypeCodes$_setter_$LastFuncType_$eq(self, x$1: int) -> None: ...

class TypeSerializer:
    @staticmethod
    def deserialize(r: sigmastate.utils.SigmaByteReader) -> sigmastate.SType: ...
    @staticmethod
    def embeddableIdToType() -> typing.List[sigmastate.SType]: ...
    @staticmethod
    def getEmbeddableType(code: int) -> sigmastate.SType: ...
    @staticmethod
    def serialize(tpe: sigmastate.SType, w: sigmastate.utils.SigmaByteWriter) -> None: ...

class ValDefTypeStore:
    def __init__(self): ...
    def apply(self, id: int) -> sigmastate.SType: ...
    def update(self, id: int, tpe: sigmastate.SType) -> None: ...

class ProveDlogSerializer(SigmaSerializer[sigmastate.basics.DLogProtocol.ProveDlog, sigmastate.basics.DLogProtocol.ProveDlog], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function1[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, sigmastate.basics.DLogProtocol.ProveDlog]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['ProveDlogSerializer', _andThen__A]) -> scala.Function1[scala.Function1[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, sigmastate.basics.DLogProtocol.ProveDlog], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function1[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, sigmastate.basics.DLogProtocol.ProveDlog]) -> 'ProveDlogSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function1[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, sigmastate.basics.DLogProtocol.ProveDlog]]) -> scala.Function1[_compose__A, 'ProveDlogSerializer']: ...
    def cons(self) -> scala.Function1[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, sigmastate.basics.DLogProtocol.ProveDlog]: ...
    def copy(self, cons: scala.Function1[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, sigmastate.basics.DLogProtocol.ProveDlog]) -> 'ProveDlogSerializer': ...
    def copy$default$1(self) -> scala.Function1[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, sigmastate.basics.DLogProtocol.ProveDlog]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.basics.DLogProtocol.ProveDlog: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.basics.DLogProtocol.ProveDlog, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ProveDlogSerializer') -> scala.Option[scala.Function1[org.bouncycastle.math.ec.custom.sec.SecP256K1Point, sigmastate.basics.DLogProtocol.ProveDlog]]: ...

class ValueCodes(TypeCodes):
    @staticmethod
    def $init$($this: 'ValueCodes') -> None: ...
    def ConstantCode(self) -> int: ...
    def LastConstantCode(self) -> int: ...
    def sigmastate$serialization$ValueCodes$_setter_$ConstantCode_$eq(self, x$1: int) -> None: ...
    def sigmastate$serialization$ValueCodes$_setter_$LastConstantCode_$eq(self, x$1: int) -> None: ...

class ApplySerializer(sigmastate.serialization.ValueSerializer[sigmastate.lang.Terms.Apply], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function2[sigmastate.Values.Value[sigmastate.SType], scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['ApplySerializer', _andThen__A]) -> scala.Function1[scala.Function2[sigmastate.Values.Value[sigmastate.SType], scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function2[sigmastate.Values.Value[sigmastate.SType], scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]) -> 'ApplySerializer': ...
    def argsInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[scala.collection.Seq[sigmastate.Values.Value[sigmastate.SType]]]: ...
    def argsItemInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function2[sigmastate.Values.Value[sigmastate.SType], scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]]) -> scala.Function1[_compose__A, 'ApplySerializer']: ...
    def cons(self) -> scala.Function2[sigmastate.Values.Value[sigmastate.SType], scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]: ...
    def copy(self, cons: scala.Function2[sigmastate.Values.Value[sigmastate.SType], scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]) -> 'ApplySerializer': ...
    def copy$default$1(self) -> scala.Function2[sigmastate.Values.Value[sigmastate.SType], scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def funcInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> sigmastate.lang.Terms.Apply.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.lang.Terms.Apply, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ApplySerializer') -> scala.Option[scala.Function2[sigmastate.Values.Value[sigmastate.SType], scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]]: ...

class BlockValueSerializer(sigmastate.serialization.ValueSerializer[sigmastate.Values.BlockValue], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.BlockItem], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['BlockValueSerializer', _andThen__A]) -> scala.Function1[scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.BlockItem], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.BlockItem], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'BlockValueSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.BlockItem], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]]) -> scala.Function1[_compose__A, 'BlockValueSerializer']: ...
    def cons(self) -> scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.BlockItem], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def copy(self, cons: scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.BlockItem], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'BlockValueSerializer': ...
    def copy$default$1(self) -> scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.BlockItem], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def itemInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def numItemsInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.utils.SigmaByteWriter.Vlq[sigmastate.utils.SigmaByteWriter.U[typing.Any]]]: ...
    def opDesc(self) -> sigmastate.Values.BlockValue.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def resultInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def serialize(self, obj: sigmastate.Values.BlockValue, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'BlockValueSerializer') -> scala.Option[scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.BlockItem], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]]: ...

class BoolToSigmaPropSerializer(sigmastate.serialization.ValueSerializer[sigmastate.BoolToSigmaProp], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['BoolToSigmaPropSerializer', _andThen__A]) -> scala.Function1[scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SSigmaProp.]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]) -> 'BoolToSigmaPropSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]]) -> scala.Function1[_compose__A, 'BoolToSigmaPropSerializer']: ...
    def conditionInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def cons(self) -> scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]: ...
    def copy(self, cons: scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]) -> 'BoolToSigmaPropSerializer': ...
    def copy$default$1(self) -> scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> sigmastate.BoolToSigmaProp.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.BoolToSigmaProp, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'BoolToSigmaPropSerializer') -> scala.Option[scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]]: ...

_CaseObjectSerialization__V = typing.TypeVar('_CaseObjectSerialization__V', bound=sigmastate.Values.Value)  # <V>
class CaseObjectSerialization(sigmastate.serialization.ValueSerializer[_CaseObjectSerialization__V], scala.Product, scala.Serializable, typing.Generic[_CaseObjectSerialization__V]):
    def __init__(self, opDesc: sigmastate.Values.ValueCompanion, obj: _CaseObjectSerialization__V): ...
    _apply__V = typing.TypeVar('_apply__V', bound=sigmastate.Values.Value)  # <V>
    @staticmethod
    def apply(opDesc: sigmastate.Values.ValueCompanion, obj: _apply__V) -> 'CaseObjectSerialization'[_apply__V]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _copy__V = typing.TypeVar('_copy__V', bound=sigmastate.Values.Value)  # <V>
    def copy(self, opDesc: sigmastate.Values.ValueCompanion, obj: sigmastate.Values.Value) -> 'CaseObjectSerialization'[sigmastate.Values.Value]: ...
    _copy$default$1__V = typing.TypeVar('_copy$default$1__V', bound=sigmastate.Values.Value)  # <V>
    def copy$default$1(self) -> sigmastate.Values.ValueCompanion: ...
    _copy$default$2__V = typing.TypeVar('_copy$default$2__V', bound=sigmastate.Values.Value)  # <V>
    def copy$default$2(self) -> sigmastate.Values.Value: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def obj(self) -> _CaseObjectSerialization__V: ...
    def opDesc(self) -> sigmastate.Values.ValueCompanion: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> _CaseObjectSerialization__V: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: _CaseObjectSerialization__V, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    _unapply__V = typing.TypeVar('_unapply__V', bound=sigmastate.Values.Value)  # <V>
    @staticmethod
    def unapply(x$0: 'CaseObjectSerialization'[_unapply__V]) -> scala.Option[scala.Tuple2[sigmastate.Values.ValueCompanion, _unapply__V]]: ...

class ConcreteCollectionBooleanConstantSerializer(sigmastate.serialization.ValueSerializer[sigmastate.Values.ConcreteCollection[sigmastate.SBoolean.]], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SBoolean.]], sigmastate.SBoolean., sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SBoolean.]]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['ConcreteCollectionBooleanConstantSerializer', _andThen__A]) -> scala.Function1[scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SBoolean.]], sigmastate.SBoolean., sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SBoolean.]]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SBoolean.]], sigmastate.SBoolean., sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SBoolean.]]]) -> 'ConcreteCollectionBooleanConstantSerializer': ...
    def bitsInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.utils.SigmaByteWriter.Bits]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SBoolean.]], sigmastate.SBoolean., sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SBoolean.]]]]) -> scala.Function1[_compose__A, 'ConcreteCollectionBooleanConstantSerializer']: ...
    def cons(self) -> scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SBoolean.]], sigmastate.SBoolean., sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SBoolean.]]]: ...
    def copy(self, cons: scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SBoolean.]], sigmastate.SBoolean., sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SBoolean.]]]) -> 'ConcreteCollectionBooleanConstantSerializer': ...
    def copy$default$1(self) -> scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SBoolean.]], sigmastate.SBoolean., sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SBoolean.]]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def numBitsInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.utils.SigmaByteWriter.Vlq[sigmastate.utils.SigmaByteWriter.U[typing.Any]]]: ...
    def opDesc(self) -> sigmastate.Values.ConcreteCollectionBooleanConstant.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SBoolean.]]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, cc: sigmastate.Values.ConcreteCollection[sigmastate.SBoolean.], w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ConcreteCollectionBooleanConstantSerializer') -> scala.Option[scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SBoolean.]], sigmastate.SBoolean., sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SBoolean.]]]]: ...

class ConcreteCollectionSerializer(sigmastate.serialization.ValueSerializer[sigmastate.Values.ConcreteCollection[sigmastate.SType]], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.SType, sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SType]]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['ConcreteCollectionSerializer', _andThen__A]) -> scala.Function1[scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.SType, sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SType]]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.SType, sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SType]]]) -> 'ConcreteCollectionSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.SType, sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SType]]]]) -> scala.Function1[_compose__A, 'ConcreteCollectionSerializer']: ...
    def cons(self) -> scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.SType, sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SType]]]: ...
    def copy(self, cons: scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.SType, sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SType]]]) -> 'ConcreteCollectionSerializer': ...
    def copy$default$1(self) -> scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.SType, sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SType]]]: ...
    def elementTypeInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.SType]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def itemInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def numItemsInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.utils.SigmaByteWriter.Vlq[sigmastate.utils.SigmaByteWriter.U[typing.Any]]]: ...
    def opDesc(self) -> sigmastate.Values.ConcreteCollection.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SType]]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, cc: sigmastate.Values.ConcreteCollection[sigmastate.SType], w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ConcreteCollectionSerializer') -> scala.Option[scala.Function2[scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.SType, sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SType]]]]: ...

class ConstantPlaceholderSerializer(sigmastate.serialization.ValueSerializer[sigmastate.Values.ConstantPlaceholder[sigmastate.SType]], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['ConstantPlaceholderSerializer', _andThen__A]) -> scala.Function1[scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]) -> 'ConstantPlaceholderSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]]) -> scala.Function1[_compose__A, 'ConstantPlaceholderSerializer']: ...
    def cons(self) -> scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]: ...
    def copy(self, cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]) -> 'ConstantPlaceholderSerializer': ...
    def copy$default$1(self) -> scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> sigmastate.Values.ConstantPlaceholder.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.Values.ConstantPlaceholder[sigmastate.SType], w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ConstantPlaceholderSerializer') -> scala.Option[scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]]: ...

class ConstantSerializer(sigmastate.serialization.ValueSerializer[sigmastate.Values.Constant[sigmastate.SType]], scala.Product, scala.Serializable):
    def __init__(self, builder: sigmastate.lang.SigmaBuilder): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['ConstantSerializer', _andThen__A]) -> scala.Function1[sigmastate.lang.SigmaBuilder, _andThen__A]: ...
    @staticmethod
    def apply(builder: sigmastate.lang.SigmaBuilder) -> 'ConstantSerializer': ...
    def builder(self) -> sigmastate.lang.SigmaBuilder: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, sigmastate.lang.SigmaBuilder]) -> scala.Function1[_compose__A, 'ConstantSerializer']: ...
    def copy(self, builder: sigmastate.lang.SigmaBuilder) -> 'ConstantSerializer': ...
    def copy$default$1(self) -> sigmastate.lang.SigmaBuilder: ...
    @typing.overload
    def deserialize(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Constant[sigmastate.SType]: ...
    @typing.overload
    @staticmethod
    def deserialize(bytes: typing.List[int], pos: int) -> sigmastate.Values.Value[sigmastate.SType]: ...
    @typing.overload
    @staticmethod
    def deserialize(r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> sigmastate.Values.Constant.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, c: sigmastate.Values.Constant[sigmastate.SType], w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ConstantSerializer') -> scala.Option[sigmastate.lang.SigmaBuilder]: ...

class CreateAvlTreeSerializer(sigmastate.serialization.ValueSerializer[sigmastate.CreateAvlTree], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function4[sigmastate.Values.Value[sigmastate.SByte.], sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SByte.]], sigmastate.Values.Value[sigmastate.SInt.], sigmastate.Values.Value[sigmastate.SOption[sigmastate.SInt.]], sigmastate.Values.Value[sigmastate.SAvlTree.]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['CreateAvlTreeSerializer', _andThen__A]) -> scala.Function1[scala.Function4[sigmastate.Values.Value[sigmastate.SByte.], sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SByte.]], sigmastate.Values.Value[sigmastate.SInt.], sigmastate.Values.Value[sigmastate.SOption[sigmastate.SInt.]], sigmastate.Values.Value[sigmastate.SAvlTree.]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function4[sigmastate.Values.Value[sigmastate.SByte.], sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SByte.]], sigmastate.Values.Value[sigmastate.SInt.], sigmastate.Values.Value[sigmastate.SOption[sigmastate.SInt.]], sigmastate.Values.Value[sigmastate.SAvlTree.]]) -> 'CreateAvlTreeSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function4[sigmastate.Values.Value[sigmastate.SByte.], sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SByte.]], sigmastate.Values.Value[sigmastate.SInt.], sigmastate.Values.Value[sigmastate.SOption[sigmastate.SInt.]], sigmastate.Values.Value[sigmastate.SAvlTree.]]]) -> scala.Function1[_compose__A, 'CreateAvlTreeSerializer']: ...
    def cons(self) -> scala.Function4[sigmastate.Values.Value[sigmastate.SByte.], sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SByte.]], sigmastate.Values.Value[sigmastate.SInt.], sigmastate.Values.Value[sigmastate.SOption[sigmastate.SInt.]], sigmastate.Values.Value[sigmastate.SAvlTree.]]: ...
    def copy(self, cons: scala.Function4[sigmastate.Values.Value[sigmastate.SByte.], sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SByte.]], sigmastate.Values.Value[sigmastate.SInt.], sigmastate.Values.Value[sigmastate.SOption[sigmastate.SInt.]], sigmastate.Values.Value[sigmastate.SAvlTree.]]) -> 'CreateAvlTreeSerializer': ...
    def copy$default$1(self) -> scala.Function4[sigmastate.Values.Value[sigmastate.SByte.], sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SByte.]], sigmastate.Values.Value[sigmastate.SInt.], sigmastate.Values.Value[sigmastate.SOption[sigmastate.SInt.]], sigmastate.Values.Value[sigmastate.SAvlTree.]]: ...
    def digestInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def keyLengthInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def opDesc(self) -> sigmastate.CreateAvlTree.: ...
    def operationFlagsInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SAvlTree.]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.CreateAvlTree, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'CreateAvlTreeSerializer') -> scala.Option[scala.Function4[sigmastate.Values.Value[sigmastate.SByte.], sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SByte.]], sigmastate.Values.Value[sigmastate.SInt.], sigmastate.Values.Value[sigmastate.SOption[sigmastate.SInt.]], sigmastate.Values.Value[sigmastate.SAvlTree.]]]: ...
    def valueLengthOptInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...

class CreateProveDlogSerializer(sigmastate.serialization.ValueSerializer[sigmastate.CreateProveDlog], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function1[sigmastate.Values.Value[sigmastate.SGroupElement.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['CreateProveDlogSerializer', _andThen__A]) -> scala.Function1[scala.Function1[sigmastate.Values.Value[sigmastate.SGroupElement.], sigmastate.Values.Value[sigmastate.SSigmaProp.]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function1[sigmastate.Values.Value[sigmastate.SGroupElement.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]) -> 'CreateProveDlogSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function1[sigmastate.Values.Value[sigmastate.SGroupElement.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]]) -> scala.Function1[_compose__A, 'CreateProveDlogSerializer']: ...
    def cons(self) -> scala.Function1[sigmastate.Values.Value[sigmastate.SGroupElement.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]: ...
    def copy(self, cons: scala.Function1[sigmastate.Values.Value[sigmastate.SGroupElement.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]) -> 'CreateProveDlogSerializer': ...
    def copy$default$1(self) -> scala.Function1[sigmastate.Values.Value[sigmastate.SGroupElement.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> sigmastate.CreateProveDlog.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SSigmaProp.]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.CreateProveDlog, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'CreateProveDlogSerializer') -> scala.Option[scala.Function1[sigmastate.Values.Value[sigmastate.SGroupElement.], sigmastate.Values.Value[sigmastate.SSigmaProp.]]]: ...
    def valueInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...

class FuncValueSerializer(sigmastate.serialization.ValueSerializer[sigmastate.Values.FuncValue], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function2[scala.collection.IndexedSeq[scala.Tuple2[typing.Any, sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['FuncValueSerializer', _andThen__A]) -> scala.Function1[scala.Function2[scala.collection.IndexedSeq[scala.Tuple2[typing.Any, sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function2[scala.collection.IndexedSeq[scala.Tuple2[typing.Any, sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'FuncValueSerializer': ...
    def bodyInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function2[scala.collection.IndexedSeq[scala.Tuple2[typing.Any, sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]]) -> scala.Function1[_compose__A, 'FuncValueSerializer']: ...
    def cons(self) -> scala.Function2[scala.collection.IndexedSeq[scala.Tuple2[typing.Any, sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def copy(self, cons: scala.Function2[scala.collection.IndexedSeq[scala.Tuple2[typing.Any, sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'FuncValueSerializer': ...
    def copy$default$1(self) -> scala.Function2[scala.collection.IndexedSeq[scala.Tuple2[typing.Any, sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def idInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.utils.SigmaByteWriter.Vlq[sigmastate.utils.SigmaByteWriter.U[typing.Any]]]: ...
    def numArgsInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.utils.SigmaByteWriter.Vlq[sigmastate.utils.SigmaByteWriter.U[typing.Any]]]: ...
    def opDesc(self) -> sigmastate.Values.FuncValue.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.Values.FuncValue, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    def typeInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.SType]: ...
    @staticmethod
    def unapply(x$0: 'FuncValueSerializer') -> scala.Option[scala.Function2[scala.collection.IndexedSeq[scala.Tuple2[typing.Any, sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]]: ...

class GetVarSerializer(sigmastate.serialization.ValueSerializer[sigmastate.utxo.GetVar[sigmastate.SType]], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['GetVarSerializer', _andThen__A]) -> scala.Function1[scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]]]) -> 'GetVarSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]]]]) -> scala.Function1[_compose__A, 'GetVarSerializer']: ...
    def cons(self) -> scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]]]: ...
    def copy(self, cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]]]) -> 'GetVarSerializer': ...
    def copy$default$1(self) -> scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> sigmastate.utxo.GetVar.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.utxo.GetVar[sigmastate.SType], w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    def typeInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.SType]: ...
    @staticmethod
    def unapply(x$0: 'GetVarSerializer') -> scala.Option[scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]]]]: ...
    def varIdInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]: ...

class LogicalNotSerializer(sigmastate.serialization.ValueSerializer[sigmastate.LogicalNot], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SBoolean.]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['LogicalNotSerializer', _andThen__A]) -> scala.Function1[scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SBoolean.]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SBoolean.]]) -> 'LogicalNotSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SBoolean.]]]) -> scala.Function1[_compose__A, 'LogicalNotSerializer']: ...
    def cons(self) -> scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SBoolean.]]: ...
    def copy(self, cons: scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SBoolean.]]) -> 'LogicalNotSerializer': ...
    def copy$default$1(self) -> scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SBoolean.]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def inputInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def opDesc(self) -> sigmastate.LogicalNot.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SBoolean.]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.LogicalNot, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'LogicalNotSerializer') -> scala.Option[scala.Function1[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.Values.Value[sigmastate.SBoolean.]]]: ...

class MethodCallSerializer(sigmastate.serialization.ValueSerializer[sigmastate.lang.Terms.MethodCall], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['MethodCallSerializer', _andThen__A]) -> scala.Function1[scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'MethodCallSerializer': ...
    def argsInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[scala.collection.Seq[sigmastate.Values.Value[sigmastate.SType]]]: ...
    def argsItemInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]]) -> scala.Function1[_compose__A, 'MethodCallSerializer']: ...
    def cons(self) -> scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def copy(self, cons: scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'MethodCallSerializer': ...
    def copy$default$1(self) -> scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def getComplexity(self) -> int: ...
    def hashCode(self) -> int: ...
    def methodCodeInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]: ...
    def objInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def opDesc(self) -> sigmastate.Values.ValueCompanion: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, mc: sigmastate.lang.Terms.MethodCall, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    def typeCodeInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]: ...
    @staticmethod
    def unapply(x$0: 'MethodCallSerializer') -> scala.Option[scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]]: ...

class ModQArithOpSerializer(sigmastate.serialization.ValueSerializer[sigmastate.ModQArithOp], scala.Product, scala.Serializable):
    def __init__(self, opDesc: sigmastate.ModQArithOpCompanion, cons: scala.Function2[sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.]]): ...
    @staticmethod
    def apply(opDesc: sigmastate.ModQArithOpCompanion, cons: scala.Function2[sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.]]) -> 'ModQArithOpSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def cons(self) -> scala.Function2[sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.]]: ...
    def copy(self, opDesc: sigmastate.ModQArithOpCompanion, cons: scala.Function2[sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.]]) -> 'ModQArithOpSerializer': ...
    def copy$default$1(self) -> sigmastate.ModQArithOpCompanion: ...
    def copy$default$2(self) -> scala.Function2[sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.]]: ...
    @staticmethod
    def curried() -> scala.Function1[sigmastate.ModQArithOpCompanion, scala.Function1[scala.Function2[sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.]], 'ModQArithOpSerializer']]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def leftInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def opDesc(self) -> sigmastate.ModQArithOpCompanion: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def rightInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def serialize(self, obj: sigmastate.ModQArithOp, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[sigmastate.ModQArithOpCompanion, scala.Function2[sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.]]], 'ModQArithOpSerializer']: ...
    @staticmethod
    def unapply(x$0: 'ModQArithOpSerializer') -> scala.Option[scala.Tuple2[sigmastate.ModQArithOpCompanion, scala.Function2[sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.], sigmastate.Values.Value[sigmastate.SBigInt.]]]]: ...

_OneArgumentOperationSerializer__T = typing.TypeVar('_OneArgumentOperationSerializer__T', bound=sigmastate.SType)  # <T>
class OneArgumentOperationSerializer(sigmastate.serialization.ValueSerializer[sigmastate.OneArgumentOperation[_OneArgumentOperationSerializer__T, sigmastate.SType]], scala.Product, scala.Serializable, typing.Generic[_OneArgumentOperationSerializer__T]):
    def __init__(self, opDesc: sigmastate.OneArgumentOperationCompanion, cons: scala.Function1[sigmastate.Values.Value[_OneArgumentOperationSerializer__T], sigmastate.Values.Value[sigmastate.SType]]): ...
    _apply__T = typing.TypeVar('_apply__T', bound=sigmastate.SType)  # <T>
    @staticmethod
    def apply(opDesc: sigmastate.OneArgumentOperationCompanion, cons: scala.Function1[sigmastate.Values.Value[_apply__T], sigmastate.Values.Value[sigmastate.SType]]) -> 'OneArgumentOperationSerializer'[_apply__T]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def cons(self) -> scala.Function1[sigmastate.Values.Value[_OneArgumentOperationSerializer__T], sigmastate.Values.Value[sigmastate.SType]]: ...
    _copy__T = typing.TypeVar('_copy__T', bound=sigmastate.SType)  # <T>
    def copy(self, opDesc: sigmastate.OneArgumentOperationCompanion, cons: scala.Function1[sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'OneArgumentOperationSerializer'[sigmastate.SType]: ...
    _copy$default$1__T = typing.TypeVar('_copy$default$1__T', bound=sigmastate.SType)  # <T>
    def copy$default$1(self) -> sigmastate.OneArgumentOperationCompanion: ...
    _copy$default$2__T = typing.TypeVar('_copy$default$2__T', bound=sigmastate.SType)  # <T>
    def copy$default$2(self) -> scala.Function1[sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def objInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def opDesc(self) -> sigmastate.OneArgumentOperationCompanion: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.OneArgumentOperation[_OneArgumentOperationSerializer__T, sigmastate.SType], w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    _unapply__T = typing.TypeVar('_unapply__T', bound=sigmastate.SType)  # <T>
    @staticmethod
    def unapply(x$0: 'OneArgumentOperationSerializer'[_unapply__T]) -> scala.Option[scala.Tuple2[sigmastate.OneArgumentOperationCompanion, scala.Function1[sigmastate.Values.Value[_unapply__T], sigmastate.Values.Value[sigmastate.SType]]]]: ...

class OptionGetOrElseSerializer(sigmastate.serialization.ValueSerializer[sigmastate.utxo.OptionGetOrElse[sigmastate.SType]], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function2[sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['OptionGetOrElseSerializer', _andThen__A]) -> scala.Function1[scala.Function2[sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function2[sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'OptionGetOrElseSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function2[sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]]) -> scala.Function1[_compose__A, 'OptionGetOrElseSerializer']: ...
    def cons(self) -> scala.Function2[sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def copy(self, cons: scala.Function2[sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'OptionGetOrElseSerializer': ...
    def copy$default$1(self) -> scala.Function2[sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def defaultInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> sigmastate.utxo.OptionGetOrElse.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.utxo.OptionGetOrElse[sigmastate.SType], w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def thisInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'OptionGetOrElseSerializer') -> scala.Option[scala.Function2[sigmastate.Values.Value[sigmastate.SOption[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]]: ...

class PropertyCallSerializer(sigmastate.serialization.ValueSerializer[sigmastate.lang.Terms.MethodCall], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['PropertyCallSerializer', _andThen__A]) -> scala.Function1[scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'PropertyCallSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]]) -> scala.Function1[_compose__A, 'PropertyCallSerializer']: ...
    def cons(self) -> scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def copy(self, cons: scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'PropertyCallSerializer': ...
    def copy$default$1(self) -> scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def getComplexity(self) -> int: ...
    def hashCode(self) -> int: ...
    def methodCodeInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]: ...
    def objInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def opDesc(self) -> sigmastate.Values.ValueCompanion: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, mc: sigmastate.lang.Terms.MethodCall, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    def typeCodeInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]: ...
    @staticmethod
    def unapply(x$0: 'PropertyCallSerializer') -> scala.Option[scala.Function4[sigmastate.Values.Value[sigmastate.SType], sigmastate.SMethod, scala.collection.IndexedSeq[sigmastate.Values.Value[sigmastate.SType]], scala.collection.immutable.Map[sigmastate.STypeVar, sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]]: ...

class SelectFieldSerializer(sigmastate.serialization.ValueSerializer[sigmastate.utxo.SelectField], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function2[sigmastate.Values.Value[sigmastate.STuple], typing.Any, sigmastate.Values.Value[sigmastate.SType]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['SelectFieldSerializer', _andThen__A]) -> scala.Function1[scala.Function2[sigmastate.Values.Value[sigmastate.STuple], typing.Any, sigmastate.Values.Value[sigmastate.SType]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function2[sigmastate.Values.Value[sigmastate.STuple], typing.Any, sigmastate.Values.Value[sigmastate.SType]]) -> 'SelectFieldSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function2[sigmastate.Values.Value[sigmastate.STuple], typing.Any, sigmastate.Values.Value[sigmastate.SType]]]) -> scala.Function1[_compose__A, 'SelectFieldSerializer']: ...
    def cons(self) -> scala.Function2[sigmastate.Values.Value[sigmastate.STuple], typing.Any, sigmastate.Values.Value[sigmastate.SType]]: ...
    def copy(self, cons: scala.Function2[sigmastate.Values.Value[sigmastate.STuple], typing.Any, sigmastate.Values.Value[sigmastate.SType]]) -> 'SelectFieldSerializer': ...
    def copy$default$1(self) -> scala.Function2[sigmastate.Values.Value[sigmastate.STuple], typing.Any, sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def fieldIndexInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]: ...
    def hashCode(self) -> int: ...
    def inputInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def opDesc(self) -> sigmastate.utxo.SelectField.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.utxo.SelectField, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'SelectFieldSerializer') -> scala.Option[scala.Function2[sigmastate.Values.Value[sigmastate.STuple], typing.Any, sigmastate.Values.Value[sigmastate.SType]]]: ...

class TaggedVariableSerializer(sigmastate.serialization.ValueSerializer[sigmastate.Values.TaggedVariable[sigmastate.SType]], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['TaggedVariableSerializer', _andThen__A]) -> scala.Function1[scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]) -> 'TaggedVariableSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]]) -> scala.Function1[_compose__A, 'TaggedVariableSerializer']: ...
    def cons(self) -> scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]: ...
    def copy(self, cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]) -> 'TaggedVariableSerializer': ...
    def copy$default$1(self) -> scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> sigmastate.Values.TaggedVariable.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.Values.TaggedVariable[sigmastate.SType], w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'TaggedVariableSerializer') -> scala.Option[scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]]: ...

class TupleSerializer(sigmastate.serialization.ValueSerializer[sigmastate.Values.Tuple], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function1[scala.collection.Seq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['TupleSerializer', _andThen__A]) -> scala.Function1[scala.Function1[scala.collection.Seq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function1[scala.collection.Seq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]) -> 'TupleSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function1[scala.collection.Seq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]]) -> scala.Function1[_compose__A, 'TupleSerializer']: ...
    def cons(self) -> scala.Function1[scala.collection.Seq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]: ...
    def copy(self, cons: scala.Function1[scala.collection.Seq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]) -> 'TupleSerializer': ...
    def copy$default$1(self) -> scala.Function1[scala.collection.Seq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def itemInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def numItemsInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.utils.SigmaByteWriter.U[typing.Any]]: ...
    def opDesc(self) -> sigmastate.Values.Tuple.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.Values.Tuple, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'TupleSerializer') -> scala.Option[scala.Function1[scala.collection.Seq[sigmastate.Values.Value[sigmastate.SType]], sigmastate.Values.Value[sigmastate.SType]]]: ...

_TwoArgumentsSerializer__LIV = typing.TypeVar('_TwoArgumentsSerializer__LIV', bound=sigmastate.SType)  # <LIV>
_TwoArgumentsSerializer__RIV = typing.TypeVar('_TwoArgumentsSerializer__RIV', bound=sigmastate.SType)  # <RIV>
_TwoArgumentsSerializer__OV = typing.TypeVar('_TwoArgumentsSerializer__OV', bound=sigmastate.Values.Value)  # <OV>
class TwoArgumentsSerializer(sigmastate.serialization.ValueSerializer[_TwoArgumentsSerializer__OV], scala.Product, scala.Serializable, typing.Generic[_TwoArgumentsSerializer__LIV, _TwoArgumentsSerializer__RIV, _TwoArgumentsSerializer__OV]):
    def __init__(self, opDesc: sigmastate.TwoArgumentOperationCompanion, constructor: scala.Function2[sigmastate.Values.Value[_TwoArgumentsSerializer__LIV], sigmastate.Values.Value[_TwoArgumentsSerializer__RIV], sigmastate.Values.Value[sigmastate.SType]]): ...
    _apply__LIV = typing.TypeVar('_apply__LIV', bound=sigmastate.SType)  # <LIV>
    _apply__RIV = typing.TypeVar('_apply__RIV', bound=sigmastate.SType)  # <RIV>
    _apply__OV = typing.TypeVar('_apply__OV', bound=sigmastate.Values.Value)  # <OV>
    @staticmethod
    def apply(opDesc: sigmastate.TwoArgumentOperationCompanion, constructor: scala.Function2[sigmastate.Values.Value[_apply__LIV], sigmastate.Values.Value[_apply__RIV], sigmastate.Values.Value[sigmastate.SType]]) -> 'TwoArgumentsSerializer'[_apply__LIV, _apply__RIV, _apply__OV]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def constructor(self) -> scala.Function2[sigmastate.Values.Value[_TwoArgumentsSerializer__LIV], sigmastate.Values.Value[_TwoArgumentsSerializer__RIV], sigmastate.Values.Value[sigmastate.SType]]: ...
    _copy__LIV = typing.TypeVar('_copy__LIV', bound=sigmastate.SType)  # <LIV>
    _copy__RIV = typing.TypeVar('_copy__RIV', bound=sigmastate.SType)  # <RIV>
    _copy__OV = typing.TypeVar('_copy__OV', bound=sigmastate.Values.Value)  # <OV>
    def copy(self, opDesc: sigmastate.TwoArgumentOperationCompanion, constructor: scala.Function2[sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]) -> 'TwoArgumentsSerializer'[sigmastate.SType, sigmastate.SType, sigmastate.Values.Value]: ...
    _copy$default$1__LIV = typing.TypeVar('_copy$default$1__LIV', bound=sigmastate.SType)  # <LIV>
    _copy$default$1__RIV = typing.TypeVar('_copy$default$1__RIV', bound=sigmastate.SType)  # <RIV>
    _copy$default$1__OV = typing.TypeVar('_copy$default$1__OV', bound=sigmastate.Values.Value)  # <OV>
    def copy$default$1(self) -> sigmastate.TwoArgumentOperationCompanion: ...
    _copy$default$2__LIV = typing.TypeVar('_copy$default$2__LIV', bound=sigmastate.SType)  # <LIV>
    _copy$default$2__RIV = typing.TypeVar('_copy$default$2__RIV', bound=sigmastate.SType)  # <RIV>
    _copy$default$2__OV = typing.TypeVar('_copy$default$2__OV', bound=sigmastate.Values.Value)  # <OV>
    def copy$default$2(self) -> scala.Function2[sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType], sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def leftInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def opDesc(self) -> sigmastate.TwoArgumentOperationCompanion: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def rightInfo(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[sigmastate.Values.Value[sigmastate.SType]]: ...
    def serialize(self, obj: _TwoArgumentsSerializer__OV, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    _unapply__LIV = typing.TypeVar('_unapply__LIV', bound=sigmastate.SType)  # <LIV>
    _unapply__RIV = typing.TypeVar('_unapply__RIV', bound=sigmastate.SType)  # <RIV>
    _unapply__OV = typing.TypeVar('_unapply__OV', bound=sigmastate.Values.Value)  # <OV>
    @staticmethod
    def unapply(x$0: 'TwoArgumentsSerializer'[_unapply__LIV, _unapply__RIV, _unapply__OV]) -> scala.Option[scala.Tuple2[sigmastate.TwoArgumentOperationCompanion, scala.Function2[sigmastate.Values.Value[_unapply__LIV], sigmastate.Values.Value[_unapply__RIV], sigmastate.Values.Value[sigmastate.SType]]]]: ...

class ValDefSerializer(sigmastate.serialization.ValueSerializer[sigmastate.Values.ValDef], scala.Product, scala.Serializable):
    def __init__(self, opDesc: sigmastate.Values.ValueCompanion): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['ValDefSerializer', _andThen__A]) -> scala.Function1[sigmastate.Values.ValueCompanion, _andThen__A]: ...
    @staticmethod
    def apply(opDesc: sigmastate.Values.ValueCompanion) -> 'ValDefSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, sigmastate.Values.ValueCompanion]) -> scala.Function1[_compose__A, 'ValDefSerializer']: ...
    def copy(self, opDesc: sigmastate.Values.ValueCompanion) -> 'ValDefSerializer': ...
    def copy$default$1(self) -> sigmastate.Values.ValueCompanion: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> sigmastate.Values.ValueCompanion: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.Values.ValDef, w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ValDefSerializer') -> scala.Option[sigmastate.Values.ValueCompanion]: ...

class ValUseSerializer(sigmastate.serialization.ValueSerializer[sigmastate.Values.ValUse[sigmastate.SType]], scala.Product, scala.Serializable):
    def __init__(self, cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['ValUseSerializer', _andThen__A]) -> scala.Function1[scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]], _andThen__A]: ...
    @staticmethod
    def apply(cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]) -> 'ValUseSerializer': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]]) -> scala.Function1[_compose__A, 'ValUseSerializer']: ...
    def cons(self) -> scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]: ...
    def copy(self, cons: scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]) -> 'ValUseSerializer': ...
    def copy$default$1(self) -> scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def opDesc(self) -> sigmastate.Values.ValUse.: ...
    def parse(self, r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def serialize(self, obj: sigmastate.Values.ValUse[sigmastate.SType], w: sigmastate.utils.SigmaByteWriter) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ValUseSerializer') -> scala.Option[scala.Function2[typing.Any, sigmastate.SType, sigmastate.Values.Value[sigmastate.SType]]]: ...

_ValueSerializer__V = typing.TypeVar('_ValueSerializer__V', bound=sigmastate.Values.Value)  # <V>
class ValueSerializer(SigmaSerializer[sigmastate.Values.Value[sigmastate.SType], _ValueSerializer__V], typing.Generic[_ValueSerializer__V]):
    def __init__(self): ...
    @staticmethod
    def MaxArrayLength() -> int: ...
    _addArgInfo__T = typing.TypeVar('_addArgInfo__T')  # <T>
    @staticmethod
    def addArgInfo(prop: sigmastate.utils.SigmaByteWriter.DataInfo[_addArgInfo__T]) -> None: ...
    @staticmethod
    def addSerializer(opCode: int, ser: 'ValueSerializer'[sigmastate.Values.Value[sigmastate.SType]]) -> None: ...
    @staticmethod
    def cases(matchExpr: typing.Union[java.lang.String, str], block: scala.Function0[scala.runtime.BoxedUnit]) -> None: ...
    @staticmethod
    def collectSerInfo() -> bool: ...
    def companion(self) -> 'ValueSerializer.': ...
    def complexity(self) -> int: ...
    @typing.overload
    @staticmethod
    def deserialize(bytes: typing.List[int], pos: int) -> sigmastate.Values.Value[sigmastate.SType]: ...
    @typing.overload
    @staticmethod
    def deserialize(r: sigmastate.utils.SigmaByteReader) -> sigmastate.Values.Value[sigmastate.SType]: ...
    @staticmethod
    def deserialize$default$2() -> int: ...
    _foreach__T = typing.TypeVar('_foreach__T')  # <T>
    @staticmethod
    def foreach(sizeVar: typing.Union[java.lang.String, str], seq: scala.collection.Seq[_foreach__T], f: scala.Function1[_foreach__T, scala.runtime.BoxedUnit]) -> None: ...
    def getComplexity(self) -> int: ...
    @staticmethod
    def getSerializer(opCode: int) -> 'ValueSerializer'[sigmastate.Values.Value[sigmastate.SType]]: ...
    @staticmethod
    def newArray(len: int, tA: scala.reflect.ClassTag) -> typing.Any: ...
    def opCode(self) -> int: ...
    def opDesc(self) -> sigmastate.Values.ValueCompanion: ...
    _opt__T = typing.TypeVar('_opt__T')  # <T>
    @staticmethod
    def opt(w: sigmastate.utils.SigmaByteWriter, name: typing.Union[java.lang.String, str], o: scala.Option[_opt__T], f: scala.Function2[sigmastate.utils.SigmaByteWriter, _opt__T, scala.runtime.BoxedUnit]) -> None: ...
    @staticmethod
    def optional(name: typing.Union[java.lang.String, str], block: scala.Function0[scala.runtime.BoxedUnit]) -> None: ...
    @staticmethod
    def otherwise(block: scala.Function0[scala.runtime.BoxedUnit]) -> None: ...
    @staticmethod
    def otherwiseCondition() -> java.lang.String: ...
    @staticmethod
    def printSerInfo() -> java.lang.String: ...
    @staticmethod
    def removeSerializer(opCode: int) -> None: ...
    @staticmethod
    def serializerInfo() -> scala.collection.mutable.Map[typing.Any, 'ValueSerializer.SerScope']: ...
    @staticmethod
    def serializers() -> sigmastate.utils.SparseArrayContainer['ValueSerializer'[sigmastate.Values.Value[sigmastate.SType]]]: ...
    @staticmethod
    def when(pos: int, condition: typing.Union[java.lang.String, str], block: scala.Function0[scala.runtime.BoxedUnit]) -> None: ...
    class CasesScope(sigmastate.serialization.ValueSerializer.Scope, scala.Product, scala.Serializable):
        def __init__(self, parent: 'ValueSerializer.Scope', matchExpr: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]): ...
        def add(self, name: typing.Union[java.lang.String, str], s: 'ValueSerializer.Scope') -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def cases(self) -> scala.collection.Seq['ValueSerializer.WhenScope']: ...
        def children(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def copy(self, parent: 'ValueSerializer.Scope', matchExpr: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.CasesScope': ...
        def copy$default$1(self) -> 'ValueSerializer.Scope': ...
        def copy$default$2(self) -> java.lang.String: ...
        def copy$default$3(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def get(self, name: typing.Union[java.lang.String, str]) -> scala.Option['ValueSerializer.Scope']: ...
        def hashCode(self) -> int: ...
        def matchExpr(self) -> java.lang.String: ...
        def name(self) -> java.lang.String: ...
        def parent(self) -> 'ValueSerializer.Scope': ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def provideScope(self, n: typing.Union[java.lang.String, str], createNewScope: scala.Function0['ValueSerializer.Scope']) -> 'ValueSerializer.Scope': ...
        def showInScope(self, v: typing.Union[java.lang.String, str]) -> java.lang.String: ...
        def toString(self) -> java.lang.String: ...
    class CasesScope$(scala.runtime.AbstractFunction3['ValueSerializer.Scope', java.lang.String, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']], 'ValueSerializer.CasesScope'], scala.Serializable):
        MODULE$: typing.ClassVar['ValueSerializer.CasesScope.'] = ...
        def __init__(self): ...
        def apply(self, parent: 'ValueSerializer.Scope', matchExpr: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.CasesScope': ...
        def toString(self) -> java.lang.String: ...
        def unapply(self, x$0: 'ValueSerializer.CasesScope') -> scala.Option[scala.Tuple3['ValueSerializer.Scope', java.lang.String, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]]]: ...
    class DataScope(sigmastate.serialization.ValueSerializer.Scope, scala.Product, scala.Serializable):
        def __init__(self, parent: 'ValueSerializer.Scope', data: sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]): ...
        def add(self, name: typing.Union[java.lang.String, str], s: 'ValueSerializer.Scope') -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def children(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def copy(self, parent: 'ValueSerializer.Scope', data: sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]) -> 'ValueSerializer.DataScope': ...
        def copy$default$1(self) -> 'ValueSerializer.Scope': ...
        def copy$default$2(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]: ...
        def data(self) -> sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def get(self, name: typing.Union[java.lang.String, str]) -> scala.Option['ValueSerializer.Scope']: ...
        def hashCode(self) -> int: ...
        def name(self) -> java.lang.String: ...
        def parent(self) -> 'ValueSerializer.Scope': ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def provideScope(self, n: typing.Union[java.lang.String, str], createNewScope: scala.Function0['ValueSerializer.Scope']) -> 'ValueSerializer.Scope': ...
        def showInScope(self, v: typing.Union[java.lang.String, str]) -> java.lang.String: ...
        def toString(self) -> java.lang.String: ...
    class DataScope$(scala.runtime.AbstractFunction2['ValueSerializer.Scope', sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any], 'ValueSerializer.DataScope'], scala.Serializable):
        MODULE$: typing.ClassVar['ValueSerializer.DataScope.'] = ...
        def __init__(self): ...
        def apply(self, parent: 'ValueSerializer.Scope', data: sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]) -> 'ValueSerializer.DataScope': ...
        def toString(self) -> java.lang.String: ...
        def unapply(self, x$0: 'ValueSerializer.DataScope') -> scala.Option[scala.Tuple2['ValueSerializer.Scope', sigmastate.utils.SigmaByteWriter.DataInfo[typing.Any]]]: ...
    class ForScope(sigmastate.serialization.ValueSerializer.Scope, scala.Product, scala.Serializable):
        def __init__(self, parent: 'ValueSerializer.Scope', name: typing.Union[java.lang.String, str], limitVar: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]): ...
        def add(self, name: typing.Union[java.lang.String, str], s: 'ValueSerializer.Scope') -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def children(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def copy(self, parent: 'ValueSerializer.Scope', name: typing.Union[java.lang.String, str], limitVar: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.ForScope': ...
        def copy$default$1(self) -> 'ValueSerializer.Scope': ...
        def copy$default$2(self) -> java.lang.String: ...
        def copy$default$3(self) -> java.lang.String: ...
        def copy$default$4(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def get(self, name: typing.Union[java.lang.String, str]) -> scala.Option['ValueSerializer.Scope']: ...
        def hashCode(self) -> int: ...
        def limitVar(self) -> java.lang.String: ...
        def name(self) -> java.lang.String: ...
        def parent(self) -> 'ValueSerializer.Scope': ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def provideScope(self, n: typing.Union[java.lang.String, str], createNewScope: scala.Function0['ValueSerializer.Scope']) -> 'ValueSerializer.Scope': ...
        def showInScope(self, v: typing.Union[java.lang.String, str]) -> java.lang.String: ...
        def toString(self) -> java.lang.String: ...
    class ForScope$(scala.runtime.AbstractFunction4['ValueSerializer.Scope', java.lang.String, java.lang.String, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']], 'ValueSerializer.ForScope'], scala.Serializable):
        MODULE$: typing.ClassVar['ValueSerializer.ForScope.'] = ...
        def __init__(self): ...
        def apply(self, parent: 'ValueSerializer.Scope', name: typing.Union[java.lang.String, str], limitVar: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.ForScope': ...
        def toString(self) -> java.lang.String: ...
        def unapply(self, x$0: 'ValueSerializer.ForScope') -> scala.Option[scala.Tuple4['ValueSerializer.Scope', java.lang.String, java.lang.String, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]]]: ...
    class OptionScope(sigmastate.serialization.ValueSerializer.Scope, scala.Product, scala.Serializable):
        def __init__(self, parent: 'ValueSerializer.Scope', name: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]): ...
        def add(self, name: typing.Union[java.lang.String, str], s: 'ValueSerializer.Scope') -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def children(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def copy(self, parent: 'ValueSerializer.Scope', name: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.OptionScope': ...
        def copy$default$1(self) -> 'ValueSerializer.Scope': ...
        def copy$default$2(self) -> java.lang.String: ...
        def copy$default$3(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def get(self, name: typing.Union[java.lang.String, str]) -> scala.Option['ValueSerializer.Scope']: ...
        def hashCode(self) -> int: ...
        def name(self) -> java.lang.String: ...
        def parent(self) -> 'ValueSerializer.Scope': ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def provideScope(self, n: typing.Union[java.lang.String, str], createNewScope: scala.Function0['ValueSerializer.Scope']) -> 'ValueSerializer.Scope': ...
        def showInScope(self, v: typing.Union[java.lang.String, str]) -> java.lang.String: ...
        def toString(self) -> java.lang.String: ...
    class OptionScope$(scala.runtime.AbstractFunction3['ValueSerializer.Scope', java.lang.String, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']], 'ValueSerializer.OptionScope'], scala.Serializable):
        MODULE$: typing.ClassVar['ValueSerializer.OptionScope.'] = ...
        def __init__(self): ...
        def apply(self, parent: 'ValueSerializer.Scope', name: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.OptionScope': ...
        def toString(self) -> java.lang.String: ...
        def unapply(self, x$0: 'ValueSerializer.OptionScope') -> scala.Option[scala.Tuple3['ValueSerializer.Scope', java.lang.String, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]]]: ...
    class OptionalScope(sigmastate.serialization.ValueSerializer.Scope, scala.Product, scala.Serializable):
        def __init__(self, parent: 'ValueSerializer.Scope', name: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]): ...
        def add(self, name: typing.Union[java.lang.String, str], s: 'ValueSerializer.Scope') -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def children(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def copy(self, parent: 'ValueSerializer.Scope', name: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.OptionalScope': ...
        def copy$default$1(self) -> 'ValueSerializer.Scope': ...
        def copy$default$2(self) -> java.lang.String: ...
        def copy$default$3(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def get(self, name: typing.Union[java.lang.String, str]) -> scala.Option['ValueSerializer.Scope']: ...
        def hashCode(self) -> int: ...
        def name(self) -> java.lang.String: ...
        def parent(self) -> 'ValueSerializer.Scope': ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def provideScope(self, n: typing.Union[java.lang.String, str], createNewScope: scala.Function0['ValueSerializer.Scope']) -> 'ValueSerializer.Scope': ...
        def showInScope(self, v: typing.Union[java.lang.String, str]) -> java.lang.String: ...
        def toString(self) -> java.lang.String: ...
    class OptionalScope$(scala.runtime.AbstractFunction3['ValueSerializer.Scope', java.lang.String, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']], 'ValueSerializer.OptionalScope'], scala.Serializable):
        MODULE$: typing.ClassVar['ValueSerializer.OptionalScope.'] = ...
        def __init__(self): ...
        def apply(self, parent: 'ValueSerializer.Scope', name: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.OptionalScope': ...
        def toString(self) -> java.lang.String: ...
        def unapply(self, x$0: 'ValueSerializer.OptionalScope') -> scala.Option[scala.Tuple3['ValueSerializer.Scope', java.lang.String, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]]]: ...
    class Scope:
        @staticmethod
        def $init$($this: 'ValueSerializer.Scope') -> None: ...
        def add(self, name: typing.Union[java.lang.String, str], s: 'ValueSerializer.Scope') -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def children(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def get(self, name: typing.Union[java.lang.String, str]) -> scala.Option['ValueSerializer.Scope']: ...
        def name(self) -> java.lang.String: ...
        def parent(self) -> 'ValueSerializer.Scope': ...
        def provideScope(self, n: typing.Union[java.lang.String, str], createNewScope: scala.Function0['ValueSerializer.Scope']) -> 'ValueSerializer.Scope': ...
        def showInScope(self, v: typing.Union[java.lang.String, str]) -> java.lang.String: ...
    class SerScope(sigmastate.serialization.ValueSerializer.Scope, scala.Product, scala.Serializable):
        def __init__(self, opCode: int, children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]): ...
        def add(self, name: typing.Union[java.lang.String, str], s: 'ValueSerializer.Scope') -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def children(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def copy(self, opCode: int, children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.SerScope': ...
        def copy$default$1(self) -> int: ...
        def copy$default$2(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def get(self, name: typing.Union[java.lang.String, str]) -> scala.Option['ValueSerializer.Scope']: ...
        def hashCode(self) -> int: ...
        def name(self) -> java.lang.String: ...
        def opCode(self) -> int: ...
        def parent(self) -> 'ValueSerializer.Scope': ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def provideScope(self, n: typing.Union[java.lang.String, str], createNewScope: scala.Function0['ValueSerializer.Scope']) -> 'ValueSerializer.Scope': ...
        def serializer(self) -> 'ValueSerializer'[sigmastate.Values.Value[sigmastate.SType]]: ...
        def showInScope(self, v: typing.Union[java.lang.String, str]) -> java.lang.String: ...
        def toString(self) -> java.lang.String: ...
    class SerScope$(scala.runtime.AbstractFunction2[typing.Any, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']], 'ValueSerializer.SerScope'], scala.Serializable):
        MODULE$: typing.ClassVar['ValueSerializer.SerScope.'] = ...
        def __init__(self): ...
        def apply(self, opCode: int, children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.SerScope': ...
        def toString(self) -> java.lang.String: ...
        def unapply(self, x$0: 'ValueSerializer.SerScope') -> scala.Option[scala.Tuple2[typing.Any, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]]]: ...
    class WhenScope(sigmastate.serialization.ValueSerializer.Scope, scala.Product, scala.Serializable):
        def __init__(self, parent: 'ValueSerializer.Scope', pos: int, condition: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]): ...
        def add(self, name: typing.Union[java.lang.String, str], s: 'ValueSerializer.Scope') -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def canEqual(self, x$1: typing.Any) -> bool: ...
        def children(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def condition(self) -> java.lang.String: ...
        def copy(self, parent: 'ValueSerializer.Scope', pos: int, condition: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.WhenScope': ...
        def copy$default$1(self) -> 'ValueSerializer.Scope': ...
        def copy$default$2(self) -> int: ...
        def copy$default$3(self) -> java.lang.String: ...
        def copy$default$4(self) -> scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]: ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def get(self, name: typing.Union[java.lang.String, str]) -> scala.Option['ValueSerializer.Scope']: ...
        def hashCode(self) -> int: ...
        def isOtherwise(self) -> bool: ...
        def name(self) -> java.lang.String: ...
        def parent(self) -> 'ValueSerializer.Scope': ...
        def pos(self) -> int: ...
        def productArity(self) -> int: ...
        def productElement(self, x$1: int) -> typing.Any: ...
        def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
        def productPrefix(self) -> java.lang.String: ...
        def provideScope(self, n: typing.Union[java.lang.String, str], createNewScope: scala.Function0['ValueSerializer.Scope']) -> 'ValueSerializer.Scope': ...
        def showInScope(self, v: typing.Union[java.lang.String, str]) -> java.lang.String: ...
        def toString(self) -> java.lang.String: ...
    class WhenScope$(scala.runtime.AbstractFunction4['ValueSerializer.Scope', typing.Any, java.lang.String, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']], 'ValueSerializer.WhenScope'], scala.Serializable):
        MODULE$: typing.ClassVar['ValueSerializer.WhenScope.'] = ...
        def __init__(self): ...
        def apply(self, parent: 'ValueSerializer.Scope', pos: int, condition: typing.Union[java.lang.String, str], children: scala.collection.mutable.ArrayBuffer[scala.Tuple2[typing.Union[java.lang.String, str], 'ValueSerializer.Scope']]) -> 'ValueSerializer.WhenScope': ...
        def toString(self) -> java.lang.String: ...
        def unapply(self, x$0: 'ValueSerializer.WhenScope') -> scala.Option[scala.Tuple4['ValueSerializer.Scope', typing.Any, java.lang.String, scala.collection.mutable.ArrayBuffer[scala.Tuple2[java.lang.String, 'ValueSerializer.Scope']]]]: ...
    class : ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("sigmastate.serialization")``.

    ApplySerializer: typing.Type[ApplySerializer]
    BlockValueSerializer: typing.Type[BlockValueSerializer]
    BoolToSigmaPropSerializer: typing.Type[BoolToSigmaPropSerializer]
    CaseObjectSerialization: typing.Type[CaseObjectSerialization]
    ConcreteCollectionBooleanConstantSerializer: typing.Type[ConcreteCollectionBooleanConstantSerializer]
    ConcreteCollectionSerializer: typing.Type[ConcreteCollectionSerializer]
    ConstantPlaceholderSerializer: typing.Type[ConstantPlaceholderSerializer]
    ConstantSerializer: typing.Type[ConstantSerializer]
    ConstantStore: typing.Type[ConstantStore]
    CreateAvlTreeSerializer: typing.Type[CreateAvlTreeSerializer]
    CreateProveDlogSerializer: typing.Type[CreateProveDlogSerializer]
    DataJsonEncoder: typing.Type[DataJsonEncoder]
    DataSerializer: typing.Type[DataSerializer]
    ErgoTreeSerializer: typing.Type[ErgoTreeSerializer]
    FuncValueSerializer: typing.Type[FuncValueSerializer]
    GetVarSerializer: typing.Type[GetVarSerializer]
    GroupElementSerializer: typing.Type[GroupElementSerializer]
    LogicalNotSerializer: typing.Type[LogicalNotSerializer]
    MethodCallSerializer: typing.Type[MethodCallSerializer]
    ModQArithOpSerializer: typing.Type[ModQArithOpSerializer]
    ModQSerializer: typing.Type[ModQSerializer]
    OneArgumentOperationSerializer: typing.Type[OneArgumentOperationSerializer]
    OpCodes: typing.Type[OpCodes]
    OptionGetOrElseSerializer: typing.Type[OptionGetOrElseSerializer]
    PropertyCallSerializer: typing.Type[PropertyCallSerializer]
    ProveDlogSerializer: typing.Type[ProveDlogSerializer]
    SelectFieldSerializer: typing.Type[SelectFieldSerializer]
    SigmaPropBytesSerializer: typing.Type[SigmaPropBytesSerializer]
    SigmaPropIsProvenSerializer: typing.Type[SigmaPropIsProvenSerializer]
    SigmaSerializer: typing.Type[SigmaSerializer]
    SigmaSerializerCompanion: typing.Type[SigmaSerializerCompanion]
    SubstConstantsSerializer: typing.Type[SubstConstantsSerializer]
    TaggedVariableSerializer: typing.Type[TaggedVariableSerializer]
    TupleSerializer: typing.Type[TupleSerializer]
    TwoArgumentsSerializer: typing.Type[TwoArgumentsSerializer]
    TypeCodes: typing.Type[TypeCodes]
    TypeSerializer: typing.Type[TypeSerializer]
    ValDefSerializer: typing.Type[ValDefSerializer]
    ValDefTypeStore: typing.Type[ValDefTypeStore]
    ValUseSerializer: typing.Type[ValUseSerializer]
    ValueCodes: typing.Type[ValueCodes]
    ValueSerializer: typing.Type[ValueSerializer]
    transformers: sigmastate.serialization.transformers.__module_protocol__
    trees: sigmastate.serialization.trees.__module_protocol__
