import java.lang
import java.math
import org.bouncycastle.asn1.x9
import org.bouncycastle.math.ec
import org.bouncycastle.math.ec.custom.sec
import scala
import scala.collection
import scala.util
import scalan
import scalan.primitives
import scorex.crypto.authds.avltree.batch
import special.collection
import special.sigma.impl
import special.sigma.wrappers
import typing
import wrappers.scala
import wrappers.scalan



class AnyValue:
    def tVal(self) -> scalan.RType[typing.Any]: ...
    def value(self) -> typing.Any: ...

class AvlTree:
    def contains(self, key: special.collection.Coll[typing.Any], proof: special.collection.Coll[typing.Any]) -> bool: ...
    def createVerifier(self, proof: special.collection.Coll[typing.Any]) -> 'AvlTreeVerifier': ...
    def digest(self) -> special.collection.Coll[typing.Any]: ...
    def enabledOperations(self) -> int: ...
    def get(self, key: special.collection.Coll[typing.Any], proof: special.collection.Coll[typing.Any]) -> scala.Option[special.collection.Coll[typing.Any]]: ...
    def getMany(self, keys: special.collection.Coll[special.collection.Coll[typing.Any]], proof: special.collection.Coll[typing.Any]) -> special.collection.Coll[scala.Option[special.collection.Coll[typing.Any]]]: ...
    def insert(self, operations: special.collection.Coll[scala.Tuple2[special.collection.Coll[typing.Any], special.collection.Coll[typing.Any]]], proof: special.collection.Coll[typing.Any]) -> scala.Option['AvlTree']: ...
    def isInsertAllowed(self) -> bool: ...
    def isRemoveAllowed(self) -> bool: ...
    def isUpdateAllowed(self) -> bool: ...
    def keyLength(self) -> int: ...
    def remove(self, operations: special.collection.Coll[special.collection.Coll[typing.Any]], proof: special.collection.Coll[typing.Any]) -> scala.Option['AvlTree']: ...
    def update(self, operations: special.collection.Coll[scala.Tuple2[special.collection.Coll[typing.Any], special.collection.Coll[typing.Any]]], proof: special.collection.Coll[typing.Any]) -> scala.Option['AvlTree']: ...
    def updateDigest(self, newDigest: special.collection.Coll[typing.Any]) -> 'AvlTree': ...
    def updateOperations(self, newOperations: int) -> 'AvlTree': ...
    def valueLengthOpt(self) -> scala.Option[typing.Any]: ...

class AvlTreeVerifier:
    def digest(self) -> scala.Option[typing.List[int]]: ...
    def performOneOperation(self, operation: scorex.crypto.authds.avltree.batch.Operation) -> scala.util.Try[scala.Option[typing.List[int]]]: ...
    def treeHeight(self) -> int: ...

class BigInt:
    def $amp(self, that: 'BigInt') -> 'BigInt': ...
    def $bar(self, that: 'BigInt') -> 'BigInt': ...
    def $div(self, that: 'BigInt') -> 'BigInt': ...
    @staticmethod
    def $init$($this: 'BigInt') -> None: ...
    def $minus(self, that: 'BigInt') -> 'BigInt': ...
    def $percent(self, m: 'BigInt') -> 'BigInt': ...
    def $plus(self, that: 'BigInt') -> 'BigInt': ...
    def $times(self, that: 'BigInt') -> 'BigInt': ...
    def add(self, that: 'BigInt') -> 'BigInt': ...
    def compareTo(self, that: 'BigInt') -> int: ...
    def divide(self, that: 'BigInt') -> 'BigInt': ...
    def inverseModQ(self) -> 'BigInt': ...
    def max(self, that: 'BigInt') -> 'BigInt': ...
    def min(self, that: 'BigInt') -> 'BigInt': ...
    def minusModQ(self, other: 'BigInt') -> 'BigInt': ...
    def mod(self, m: 'BigInt') -> 'BigInt': ...
    def modQ(self) -> 'BigInt': ...
    def multModQ(self, other: 'BigInt') -> 'BigInt': ...
    def multiply(self, that: 'BigInt') -> 'BigInt': ...
    def negate(self) -> 'BigInt': ...
    def plusModQ(self, other: 'BigInt') -> 'BigInt': ...
    def remainder(self, that: 'BigInt') -> 'BigInt': ...
    def signum(self) -> int: ...
    def subtract(self, that: 'BigInt') -> 'BigInt': ...
    def toAbs(self) -> 'BigInt': ...
    def toBits(self) -> special.collection.Coll[typing.Any]: ...
    def toByte(self) -> int: ...
    def toBytes(self) -> special.collection.Coll[typing.Any]: ...
    def toInt(self) -> int: ...
    def toLong(self) -> int: ...
    def toShort(self) -> int: ...
    def value(self) -> java.math.BigInteger: ...

class Box:
    @staticmethod
    def $init$($this: 'Box') -> None: ...
    _R0__T = typing.TypeVar('_R0__T')  # <T>
    def R0(self, cT: scalan.RType[_R0__T]) -> scala.Option[_R0__T]: ...
    _R1__T = typing.TypeVar('_R1__T')  # <T>
    def R1(self, cT: scalan.RType[_R1__T]) -> scala.Option[_R1__T]: ...
    _R2__T = typing.TypeVar('_R2__T')  # <T>
    def R2(self, cT: scalan.RType[_R2__T]) -> scala.Option[_R2__T]: ...
    _R3__T = typing.TypeVar('_R3__T')  # <T>
    def R3(self, cT: scalan.RType[_R3__T]) -> scala.Option[_R3__T]: ...
    _R4__T = typing.TypeVar('_R4__T')  # <T>
    def R4(self, cT: scalan.RType[_R4__T]) -> scala.Option[_R4__T]: ...
    _R5__T = typing.TypeVar('_R5__T')  # <T>
    def R5(self, cT: scalan.RType[_R5__T]) -> scala.Option[_R5__T]: ...
    _R6__T = typing.TypeVar('_R6__T')  # <T>
    def R6(self, cT: scalan.RType[_R6__T]) -> scala.Option[_R6__T]: ...
    _R7__T = typing.TypeVar('_R7__T')  # <T>
    def R7(self, cT: scalan.RType[_R7__T]) -> scala.Option[_R7__T]: ...
    _R8__T = typing.TypeVar('_R8__T')  # <T>
    def R8(self, cT: scalan.RType[_R8__T]) -> scala.Option[_R8__T]: ...
    _R9__T = typing.TypeVar('_R9__T')  # <T>
    def R9(self, cT: scalan.RType[_R9__T]) -> scala.Option[_R9__T]: ...
    def bytes(self) -> special.collection.Coll[typing.Any]: ...
    def bytesWithoutRef(self) -> special.collection.Coll[typing.Any]: ...
    def creationInfo(self) -> scala.Tuple2[typing.Any, special.collection.Coll[typing.Any]]: ...
    _executeFromRegister__T = typing.TypeVar('_executeFromRegister__T')  # <T>
    def executeFromRegister(self, regId: int, cT: scalan.RType[_executeFromRegister__T]) -> _executeFromRegister__T: ...
    _getReg__T = typing.TypeVar('_getReg__T')  # <T>
    def getReg(self, i: int, cT: scalan.RType[_getReg__T]) -> scala.Option[_getReg__T]: ...
    def id(self) -> special.collection.Coll[typing.Any]: ...
    def propositionBytes(self) -> special.collection.Coll[typing.Any]: ...
    def registers(self) -> special.collection.Coll[AnyValue]: ...
    def toString(self) -> java.lang.String: ...
    def tokens(self) -> special.collection.Coll[scala.Tuple2[special.collection.Coll[typing.Any], typing.Any]]: ...
    def value(self) -> int: ...

class Context:
    def HEIGHT(self) -> int: ...
    def INPUTS(self) -> special.collection.Coll[Box]: ...
    def LastBlockUtxoRootHash(self) -> AvlTree: ...
    def OUTPUTS(self) -> special.collection.Coll[Box]: ...
    def SELF(self) -> Box: ...
    def activatedScriptVersion(self) -> int: ...
    def builder(self) -> 'SigmaDslBuilder': ...
    def dataInputs(self) -> special.collection.Coll[Box]: ...
    _getVar__T = typing.TypeVar('_getVar__T')  # <T>
    def getVar(self, id: int, cT: scalan.RType[_getVar__T]) -> scala.Option[_getVar__T]: ...
    def headers(self) -> special.collection.Coll['Header']: ...
    def minerPubKey(self) -> special.collection.Coll[typing.Any]: ...
    def preHeader(self) -> 'PreHeader': ...
    def selfBoxIndex(self) -> int: ...
    def vars(self) -> special.collection.Coll[AnyValue]: ...

class CostModel:
    def AccessAvlTree(self) -> int: ...
    def AccessBox(self) -> int: ...
    def AccessKiloByteOfData(self) -> int: ...
    def CollectionConst(self) -> int: ...
    def DeserializeRegister(self) -> int: ...
    def DeserializeVar(self) -> int: ...
    def GetRegister(self) -> int: ...
    def GetVar(self) -> int: ...
    def PubKeySize(self) -> int: ...
    def SelectField(self) -> int: ...

class CostedObjects:
    @staticmethod
    def $init$($this: 'CostedObjects') -> None: ...
    class SizeAnyValue(special.collection.Sizes.Size['SigmaDsl.AnyValue']):
        def tVal(self) -> scalan.Base.Ref[wrappers.scalan.WRTypes.WRType[typing.Any]]: ...
        def valueSize(self) -> scalan.Base.Ref[special.collection.Sizes.Size[typing.Any]]: ...
    class SizeAnyValueCompanion: ...
    class SizeBox(special.collection.Sizes.Size['SigmaDsl.Box']):
        def bytes(self) -> scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll[typing.Any]]]: ...
        def bytesWithoutRef(self) -> scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll[typing.Any]]]: ...
        _getReg__T = typing.TypeVar('_getReg__T')  # <T>
        def getReg(self, id: scalan.Base.Ref[typing.Any], tT: scalan.TypeDescs.Elem[_getReg__T]) -> scalan.Base.Ref[special.collection.Sizes.Size[wrappers.scala.WOptions.WOption[_getReg__T]]]: ...
        def propositionBytes(self) -> scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll[typing.Any]]]: ...
        def registers(self) -> scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll[wrappers.scala.WOptions.WOption['SigmaDsl.AnyValue']]]]: ...
        def tokens(self) -> scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll[scala.Tuple2[special.collection.Colls.Coll[typing.Any], typing.Any]]]]: ...
    class SizeBoxCompanion: ...
    class SizeBuilder(scalan.Base.Def['CostedObjects.SizeBuilder']):
        def mkSizeAnyValue(self, tVal: scalan.Base.Ref[wrappers.scalan.WRTypes.WRType[typing.Any]], valueSize: scalan.Base.Ref[special.collection.Sizes.Size[typing.Any]]) -> scalan.Base.Ref['CostedObjects.SizeAnyValue']: ...
        def mkSizeBox(self, propositionBytes: scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll[typing.Any]]], bytes: scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll[typing.Any]]], bytesWithoutRef: scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll[typing.Any]]], registers: scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll[wrappers.scala.WOptions.WOption['SigmaDsl.AnyValue']]]], tokens: scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll[scala.Tuple2[special.collection.Colls.Coll[typing.Any], typing.Any]]]]) -> scalan.Base.Ref['CostedObjects.SizeBox']: ...
        def mkSizeContext(self, outputs: scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll['SigmaDsl.Box']]], inputs: scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll['SigmaDsl.Box']]], dataInputs: scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll['SigmaDsl.Box']]], selfBox: scalan.Base.Ref[special.collection.Sizes.Size['SigmaDsl.Box']], lastBlockUtxoRootHash: scalan.Base.Ref[special.collection.Sizes.Size['SigmaDsl.AvlTree']], headers: scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll['SigmaDsl.Header']]], preHeader: scalan.Base.Ref[special.collection.Sizes.Size['SigmaDsl.PreHeader']], vars: scalan.Base.Ref[special.collection.Colls.Coll[special.collection.Sizes.Size['SigmaDsl.AnyValue']]]) -> scalan.Base.Ref['CostedObjects.SizeContext']: ...
    class SizeBuilderCompanion: ...
    class SizeContext(special.collection.Sizes.Size['SigmaDsl.Context']):
        def dataInputs(self) -> scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll['SigmaDsl.Box']]]: ...
        _getVar__T = typing.TypeVar('_getVar__T')  # <T>
        def getVar(self, id: scalan.Base.Ref[typing.Any], tT: scalan.TypeDescs.Elem[_getVar__T]) -> scalan.Base.Ref[special.collection.Sizes.Size[wrappers.scala.WOptions.WOption[_getVar__T]]]: ...
        def headers(self) -> scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll['SigmaDsl.Header']]]: ...
        def inputs(self) -> scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll['SigmaDsl.Box']]]: ...
        def lastBlockUtxoRootHash(self) -> scalan.Base.Ref[special.collection.Sizes.Size['SigmaDsl.AvlTree']]: ...
        def outputs(self) -> scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll['SigmaDsl.Box']]]: ...
        def preHeader(self) -> scalan.Base.Ref[special.collection.Sizes.Size['SigmaDsl.PreHeader']]: ...
        def selfBox(self) -> scalan.Base.Ref[special.collection.Sizes.Size['SigmaDsl.Box']]: ...
    class SizeContextCompanion: ...
    class SizeSigmaProp(special.collection.Sizes.Size['SigmaDsl.SigmaProp']):
        def propBytes(self) -> scalan.Base.Ref[special.collection.Sizes.Size[special.collection.Colls.Coll[typing.Any]]]: ...
    class SizeSigmaPropCompanion: ...

class CostedObjectsModule(special.sigma.impl.CostedObjectsDefs): ...

class DslSyntaxExtensions:
    special$sigma$DslSyntaxExtensions$$dsl: 'SigmaDslBuilder' = ...
    def __init__(self, dsl: 'SigmaDslBuilder'): ...
    class BooleanOps:
        $outer: 'DslSyntaxExtensions' = ...
        def __init__(self, $outer: 'DslSyntaxExtensions', source: bool): ...
        def $amp$amp(self, prop: 'SigmaProp') -> 'SigmaProp': ...
        def $bar$bar(self, prop: 'SigmaProp') -> 'SigmaProp': ...

class Extensions:
    @staticmethod
    def showECPoint(p: org.bouncycastle.math.ec.ECPoint) -> java.lang.String: ...
    class GroupElementOps:
        def __init__(self, source: 'GroupElement'): ...
        def equals(self, x$1: typing.Any) -> bool: ...
        def hashCode(self) -> int: ...
        def showToString(self) -> java.lang.String: ...
        def source(self) -> 'GroupElement': ...
    class GroupElementOps$:
        MODULE$: typing.ClassVar['Extensions.GroupElementOps.'] = ...
        def __init__(self): ...
        def equals$extension(self, $this: 'GroupElement', x$1: typing.Any) -> bool: ...
        def hashCode$extension(self, $this: 'GroupElement') -> int: ...
        def showToString$extension(self, $this: 'GroupElement') -> java.lang.String: ...

class GroupElement:
    def exp(self, k: BigInt) -> 'GroupElement': ...
    def getEncoded(self) -> special.collection.Coll[typing.Any]: ...
    def isInfinity(self) -> bool: ...
    def multiply(self, that: 'GroupElement') -> 'GroupElement': ...
    def negate(self) -> 'GroupElement': ...
    def value(self) -> org.bouncycastle.math.ec.ECPoint: ...

class Header:
    def ADProofsRoot(self) -> special.collection.Coll[typing.Any]: ...
    def extensionRoot(self) -> special.collection.Coll[typing.Any]: ...
    def height(self) -> int: ...
    def id(self) -> special.collection.Coll[typing.Any]: ...
    def minerPk(self) -> GroupElement: ...
    def nBits(self) -> int: ...
    def parentId(self) -> special.collection.Coll[typing.Any]: ...
    def powDistance(self) -> BigInt: ...
    def powNonce(self) -> special.collection.Coll[typing.Any]: ...
    def powOnetimePk(self) -> GroupElement: ...
    def stateRoot(self) -> AvlTree: ...
    def timestamp(self) -> int: ...
    def transactionsRoot(self) -> special.collection.Coll[typing.Any]: ...
    def version(self) -> int: ...
    def votes(self) -> special.collection.Coll[typing.Any]: ...

class InvalidType(java.lang.Exception):
    def __init__(self, message: typing.Union[java.lang.String, str]): ...

class PreHeader:
    def height(self) -> int: ...
    def minerPk(self) -> GroupElement: ...
    def nBits(self) -> int: ...
    def parentId(self) -> special.collection.Coll[typing.Any]: ...
    def timestamp(self) -> int: ...
    def version(self) -> int: ...
    def votes(self) -> special.collection.Coll[typing.Any]: ...

class SigmaContract:
    @staticmethod
    def $init$($this: 'SigmaContract') -> None: ...
    _Collection__T = typing.TypeVar('_Collection__T')  # <T>
    def Collection(self, items: scala.collection.Seq[_Collection__T], cT: scalan.RType[_Collection__T]) -> special.collection.Coll[_Collection__T]: ...
    def allOf(self, conditions: special.collection.Coll[typing.Any]) -> bool: ...
    def allZK(self, conditions: special.collection.Coll['SigmaProp']) -> 'SigmaProp': ...
    def anyOf(self, conditions: special.collection.Coll[typing.Any]) -> bool: ...
    def anyZK(self, conditions: special.collection.Coll['SigmaProp']) -> 'SigmaProp': ...
    def atLeast(self, bound: int, props: special.collection.Coll['SigmaProp']) -> 'SigmaProp': ...
    def blake2b256(self, bytes: special.collection.Coll[typing.Any]) -> special.collection.Coll[typing.Any]: ...
    def builder(self) -> 'SigmaDslBuilder': ...
    def byteArrayToBigInt(self, bytes: special.collection.Coll[typing.Any]) -> BigInt: ...
    def byteArrayToLong(self, bytes: special.collection.Coll[typing.Any]) -> int: ...
    def decodePoint(self, encoded: special.collection.Coll[typing.Any]) -> GroupElement: ...
    def groupGenerator(self) -> GroupElement: ...
    def longToByteArray(self, l: int) -> special.collection.Coll[typing.Any]: ...
    def proveDHTuple(self, g: GroupElement, h: GroupElement, u: GroupElement, v: GroupElement) -> 'SigmaProp': ...
    def proveDlog(self, g: GroupElement) -> 'SigmaProp': ...
    def sha256(self, bytes: special.collection.Coll[typing.Any]) -> special.collection.Coll[typing.Any]: ...
    def sigmaProp(self, b: bool) -> 'SigmaProp': ...
    _substConstants__T = typing.TypeVar('_substConstants__T')  # <T>
    def substConstants(self, scriptBytes: special.collection.Coll[typing.Any], positions: special.collection.Coll[typing.Any], newValues: special.collection.Coll[_substConstants__T]) -> special.collection.Coll[typing.Any]: ...
    def verifyZK(self, cond: scala.Function0['SigmaProp']) -> bool: ...
    def xorOf(self, conditions: special.collection.Coll[typing.Any]) -> bool: ...

class SigmaDsl:
    @staticmethod
    def $init$($this: 'SigmaDsl') -> None: ...
    class AnyValue(scalan.Base.Def['SigmaDsl.AnyValue']):
        def tVal(self) -> scalan.Base.Ref[wrappers.scalan.WRTypes.WRType[typing.Any]]: ...
        def value(self) -> scalan.Base.Ref[typing.Any]: ...
    class AnyValueCompanion: ...
    class AvlTree(scalan.Base.Def['SigmaDsl.AvlTree']):
        def contains(self, key: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]], proof: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[typing.Any]: ...
        def digest(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def enabledOperations(self) -> scalan.Base.Ref[typing.Any]: ...
        def get(self, key: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]], proof: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[special.collection.Colls.Coll[typing.Any]]]: ...
        def getMany(self, keys: scalan.Base.Ref[special.collection.Colls.Coll[special.collection.Colls.Coll[typing.Any]]], proof: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[special.collection.Colls.Coll[wrappers.scala.WOptions.WOption[special.collection.Colls.Coll[typing.Any]]]]: ...
        def insert(self, operations: scalan.Base.Ref[special.collection.Colls.Coll[scala.Tuple2[special.collection.Colls.Coll[typing.Any], special.collection.Colls.Coll[typing.Any]]]], proof: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption['SigmaDsl.AvlTree']]: ...
        def isInsertAllowed(self) -> scalan.Base.Ref[typing.Any]: ...
        def isRemoveAllowed(self) -> scalan.Base.Ref[typing.Any]: ...
        def isUpdateAllowed(self) -> scalan.Base.Ref[typing.Any]: ...
        def keyLength(self) -> scalan.Base.Ref[typing.Any]: ...
        def remove(self, operations: scalan.Base.Ref[special.collection.Colls.Coll[special.collection.Colls.Coll[typing.Any]]], proof: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption['SigmaDsl.AvlTree']]: ...
        def update(self, operations: scalan.Base.Ref[special.collection.Colls.Coll[scala.Tuple2[special.collection.Colls.Coll[typing.Any], special.collection.Colls.Coll[typing.Any]]]], proof: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption['SigmaDsl.AvlTree']]: ...
        def updateDigest(self, newDigest: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref['SigmaDsl.AvlTree']: ...
        def updateOperations(self, newOperations: scalan.Base.Ref[typing.Any]) -> scalan.Base.Ref['SigmaDsl.AvlTree']: ...
        def valueLengthOpt(self) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[typing.Any]]: ...
    class AvlTreeCompanion: ...
    class BigInt(scalan.Base.Def['SigmaDsl.BigInt']):
        def add(self, that: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def compareTo(self, that: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref[typing.Any]: ...
        def divide(self, that: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def inverseModQ(self) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def max(self, that: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def min(self, that: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def minusModQ(self, other: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def mod(self, m: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def modQ(self) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def multModQ(self, other: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def multiply(self, that: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def negate(self) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def plusModQ(self, other: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def remainder(self, that: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def signum(self) -> scalan.Base.Ref[typing.Any]: ...
        def subtract(self, that: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def toAbs(self) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def toBits(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def toByte(self) -> scalan.Base.Ref[typing.Any]: ...
        def toBytes(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def toInt(self) -> scalan.Base.Ref[typing.Any]: ...
        def toLong(self) -> scalan.Base.Ref[typing.Any]: ...
        def toShort(self) -> scalan.Base.Ref[typing.Any]: ...
    class BigIntCompanion: ...
    class Box(scalan.Base.Def['SigmaDsl.Box']):
        @staticmethod
        def $init$($this: 'SigmaDsl.Box') -> None: ...
        _R0__T = typing.TypeVar('_R0__T')  # <T>
        def R0(self, cT: scalan.TypeDescs.Elem[_R0__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_R0__T]]: ...
        _R1__T = typing.TypeVar('_R1__T')  # <T>
        def R1(self, cT: scalan.TypeDescs.Elem[_R1__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_R1__T]]: ...
        _R2__T = typing.TypeVar('_R2__T')  # <T>
        def R2(self, cT: scalan.TypeDescs.Elem[_R2__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_R2__T]]: ...
        _R3__T = typing.TypeVar('_R3__T')  # <T>
        def R3(self, cT: scalan.TypeDescs.Elem[_R3__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_R3__T]]: ...
        _R4__T = typing.TypeVar('_R4__T')  # <T>
        def R4(self, cT: scalan.TypeDescs.Elem[_R4__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_R4__T]]: ...
        _R5__T = typing.TypeVar('_R5__T')  # <T>
        def R5(self, cT: scalan.TypeDescs.Elem[_R5__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_R5__T]]: ...
        _R6__T = typing.TypeVar('_R6__T')  # <T>
        def R6(self, cT: scalan.TypeDescs.Elem[_R6__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_R6__T]]: ...
        _R7__T = typing.TypeVar('_R7__T')  # <T>
        def R7(self, cT: scalan.TypeDescs.Elem[_R7__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_R7__T]]: ...
        _R8__T = typing.TypeVar('_R8__T')  # <T>
        def R8(self, cT: scalan.TypeDescs.Elem[_R8__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_R8__T]]: ...
        _R9__T = typing.TypeVar('_R9__T')  # <T>
        def R9(self, cT: scalan.TypeDescs.Elem[_R9__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_R9__T]]: ...
        def bytes(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def bytesWithoutRef(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def creationInfo(self) -> scalan.Base.Ref[scala.Tuple2[typing.Any, special.collection.Colls.Coll[typing.Any]]]: ...
        _executeFromRegister__T = typing.TypeVar('_executeFromRegister__T')  # <T>
        def executeFromRegister(self, regId: scalan.Base.Ref[typing.Any], cT: scalan.TypeDescs.Elem[_executeFromRegister__T]) -> scalan.Base.Ref[_executeFromRegister__T]: ...
        _getReg__T = typing.TypeVar('_getReg__T')  # <T>
        def getReg(self, i: scalan.Base.Ref[typing.Any], cT: scalan.TypeDescs.Elem[_getReg__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_getReg__T]]: ...
        def id(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def propositionBytes(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def registers(self) -> scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.AnyValue']]: ...
        def tokens(self) -> scalan.Base.Ref[special.collection.Colls.Coll[scala.Tuple2[special.collection.Colls.Coll[typing.Any], typing.Any]]]: ...
        def value(self) -> scalan.Base.Ref[typing.Any]: ...
    class BoxCompanion: ...
    class Context(scalan.Base.Def['SigmaDsl.Context']):
        def HEIGHT(self) -> scalan.Base.Ref[typing.Any]: ...
        def INPUTS(self) -> scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.Box']]: ...
        def LastBlockUtxoRootHash(self) -> scalan.Base.Ref['SigmaDsl.AvlTree']: ...
        def OUTPUTS(self) -> scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.Box']]: ...
        def SELF(self) -> scalan.Base.Ref['SigmaDsl.Box']: ...
        def builder(self) -> scalan.Base.Ref['SigmaDsl.SigmaDslBuilder']: ...
        def dataInputs(self) -> scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.Box']]: ...
        _getVar__T = typing.TypeVar('_getVar__T')  # <T>
        def getVar(self, id: scalan.Base.Ref[typing.Any], cT: scalan.TypeDescs.Elem[_getVar__T]) -> scalan.Base.Ref[wrappers.scala.WOptions.WOption[_getVar__T]]: ...
        def headers(self) -> scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.Header']]: ...
        def minerPubKey(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def preHeader(self) -> scalan.Base.Ref['SigmaDsl.PreHeader']: ...
        def selfBoxIndex(self) -> scalan.Base.Ref[typing.Any]: ...
        def vars(self) -> scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.AnyValue']]: ...
    class ContextCompanion: ...
    class CostModel(scalan.Base.Def['SigmaDsl.CostModel']):
        def AccessAvlTree(self) -> scalan.Base.Ref[typing.Any]: ...
        def AccessBox(self) -> scalan.Base.Ref[typing.Any]: ...
        def AccessKiloByteOfData(self) -> scalan.Base.Ref[typing.Any]: ...
        def CollectionConst(self) -> scalan.Base.Ref[typing.Any]: ...
        def DeserializeRegister(self) -> scalan.Base.Ref[typing.Any]: ...
        def DeserializeVar(self) -> scalan.Base.Ref[typing.Any]: ...
        def GetRegister(self) -> scalan.Base.Ref[typing.Any]: ...
        def GetVar(self) -> scalan.Base.Ref[typing.Any]: ...
        def PubKeySize(self) -> scalan.Base.Ref[typing.Any]: ...
        def SelectField(self) -> scalan.Base.Ref[typing.Any]: ...
    class CostModelCompanion: ...
    class GroupElement(scalan.Base.Def['SigmaDsl.GroupElement']):
        def exp(self, k: scalan.Base.Ref['SigmaDsl.BigInt']) -> scalan.Base.Ref['SigmaDsl.GroupElement']: ...
        def getEncoded(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def isInfinity(self) -> scalan.Base.Ref[typing.Any]: ...
        def multiply(self, that: scalan.Base.Ref['SigmaDsl.GroupElement']) -> scalan.Base.Ref['SigmaDsl.GroupElement']: ...
        def negate(self) -> scalan.Base.Ref['SigmaDsl.GroupElement']: ...
    class GroupElementCompanion: ...
    class Header(scalan.Base.Def['SigmaDsl.Header']):
        def ADProofsRoot(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def extensionRoot(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def height(self) -> scalan.Base.Ref[typing.Any]: ...
        def id(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def minerPk(self) -> scalan.Base.Ref['SigmaDsl.GroupElement']: ...
        def nBits(self) -> scalan.Base.Ref[typing.Any]: ...
        def parentId(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def powDistance(self) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def powNonce(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def powOnetimePk(self) -> scalan.Base.Ref['SigmaDsl.GroupElement']: ...
        def stateRoot(self) -> scalan.Base.Ref['SigmaDsl.AvlTree']: ...
        def timestamp(self) -> scalan.Base.Ref[typing.Any]: ...
        def transactionsRoot(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def version(self) -> scalan.Base.Ref[typing.Any]: ...
        def votes(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
    class HeaderCompanion: ...
    class PreHeader(scalan.Base.Def['SigmaDsl.PreHeader']):
        def height(self) -> scalan.Base.Ref[typing.Any]: ...
        def minerPk(self) -> scalan.Base.Ref['SigmaDsl.GroupElement']: ...
        def nBits(self) -> scalan.Base.Ref[typing.Any]: ...
        def parentId(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def timestamp(self) -> scalan.Base.Ref[typing.Any]: ...
        def version(self) -> scalan.Base.Ref[typing.Any]: ...
        def votes(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
    class PreHeaderCompanion: ...
    class SigmaContract(scalan.Base.Def['SigmaDsl.SigmaContract']):
        @staticmethod
        def $init$($this: 'SigmaDsl.SigmaContract') -> None: ...
        _Collection__T = typing.TypeVar('_Collection__T')  # <T>
        def Collection(self, items: scala.collection.Seq[scalan.Base.Ref[_Collection__T]], cT: scalan.TypeDescs.Elem[_Collection__T]) -> scalan.Base.Ref[special.collection.Colls.Coll[_Collection__T]]: ...
        def allOf(self, conditions: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[typing.Any]: ...
        def allZK(self, conditions: scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.SigmaProp']]) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        def anyOf(self, conditions: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[typing.Any]: ...
        def anyZK(self, conditions: scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.SigmaProp']]) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        def atLeast(self, bound: scalan.Base.Ref[typing.Any], props: scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.SigmaProp']]) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        def blake2b256(self, bytes: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def builder(self) -> scalan.Base.Ref['SigmaDsl.SigmaDslBuilder']: ...
        def byteArrayToBigInt(self, bytes: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def byteArrayToLong(self, bytes: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[typing.Any]: ...
        def decodePoint(self, encoded: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref['SigmaDsl.GroupElement']: ...
        def groupGenerator(self) -> scalan.Base.Ref['SigmaDsl.GroupElement']: ...
        def longToByteArray(self, l: scalan.Base.Ref[typing.Any]) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def proveDHTuple(self, g: scalan.Base.Ref['SigmaDsl.GroupElement'], h: scalan.Base.Ref['SigmaDsl.GroupElement'], u: scalan.Base.Ref['SigmaDsl.GroupElement'], v: scalan.Base.Ref['SigmaDsl.GroupElement']) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        def proveDlog(self, g: scalan.Base.Ref['SigmaDsl.GroupElement']) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        def sha256(self, bytes: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def sigmaProp(self, b: scalan.Base.Ref[typing.Any]) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        _substConstants__T = typing.TypeVar('_substConstants__T')  # <T>
        def substConstants(self, scriptBytes: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]], positions: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]], newValues: scalan.Base.Ref[special.collection.Colls.Coll[_substConstants__T]]) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def verifyZK(self, cond: scalan.Base.Ref[scalan.primitives.Thunks.Thunk['SigmaDsl.SigmaProp']]) -> scalan.Base.Ref[typing.Any]: ...
        def xorOf(self, conditions: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[typing.Any]: ...
    class SigmaContractCompanion: ...
    class SigmaDslBuilder(scalan.Base.Def['SigmaDsl.SigmaDslBuilder']):
        def Colls(self) -> scalan.Base.Ref[special.collection.Colls.CollBuilder]: ...
        def CostModel(self) -> scalan.Base.Ref['SigmaDsl.CostModel']: ...
        def Costing(self) -> scalan.Base.Ref[special.collection.Costs.CostedBuilder]: ...
        def Monoids(self) -> scalan.Base.Ref[special.collection.Monoids.MonoidBuilder]: ...
        def allOf(self, conditions: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[typing.Any]: ...
        def allZK(self, conditions: scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.SigmaProp']]) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        def anyOf(self, conditions: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[typing.Any]: ...
        def anyZK(self, conditions: scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.SigmaProp']]) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        def atLeast(self, bound: scalan.Base.Ref[typing.Any], props: scalan.Base.Ref[special.collection.Colls.Coll['SigmaDsl.SigmaProp']]) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        def avlTree(self, operationFlags: scalan.Base.Ref[typing.Any], digest: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]], keyLength: scalan.Base.Ref[typing.Any], valueLengthOpt: scalan.Base.Ref[wrappers.scala.WOptions.WOption[typing.Any]]) -> scalan.Base.Ref['SigmaDsl.AvlTree']: ...
        def blake2b256(self, bytes: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def byteArrayToBigInt(self, bytes: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref['SigmaDsl.BigInt']: ...
        def byteArrayToLong(self, bytes: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[typing.Any]: ...
        def decodePoint(self, encoded: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref['SigmaDsl.GroupElement']: ...
        def groupGenerator(self) -> scalan.Base.Ref['SigmaDsl.GroupElement']: ...
        def longToByteArray(self, l: scalan.Base.Ref[typing.Any]) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def proveDHTuple(self, g: scalan.Base.Ref['SigmaDsl.GroupElement'], h: scalan.Base.Ref['SigmaDsl.GroupElement'], u: scalan.Base.Ref['SigmaDsl.GroupElement'], v: scalan.Base.Ref['SigmaDsl.GroupElement']) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        def proveDlog(self, g: scalan.Base.Ref['SigmaDsl.GroupElement']) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        def sha256(self, bytes: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def sigmaProp(self, b: scalan.Base.Ref[typing.Any]) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        _substConstants__T = typing.TypeVar('_substConstants__T')  # <T>
        def substConstants(self, scriptBytes: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]], positions: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]], newValues: scalan.Base.Ref[special.collection.Colls.Coll[_substConstants__T]]) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def verifyZK(self, cond: scalan.Base.Ref[scalan.primitives.Thunks.Thunk['SigmaDsl.SigmaProp']]) -> scalan.Base.Ref[typing.Any]: ...
        def xor(self, l: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]], r: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
        def xorOf(self, conditions: scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]) -> scalan.Base.Ref[typing.Any]: ...
    class SigmaDslBuilderCompanion: ...
    class SigmaProp(scalan.Base.Def['SigmaDsl.SigmaProp']):
        @typing.overload
        def $amp$amp(self, other: scalan.Base.Ref['SigmaDsl.SigmaProp']) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        @typing.overload
        def $amp$amp(self, other: scalan.Base.Ref[typing.Any], o: scalan.OverloadHack.Overloaded1) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        @typing.overload
        def $bar$bar(self, other: scalan.Base.Ref['SigmaDsl.SigmaProp']) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        @typing.overload
        def $bar$bar(self, other: scalan.Base.Ref[typing.Any], o: scalan.OverloadHack.Overloaded1) -> scalan.Base.Ref['SigmaDsl.SigmaProp']: ...
        def isValid(self) -> scalan.Base.Ref[typing.Any]: ...
        def propBytes(self) -> scalan.Base.Ref[special.collection.Colls.Coll[typing.Any]]: ...
    class SigmaPropCompanion: ...

class SigmaDslBuilder:
    def BigInt(self, n: java.math.BigInteger) -> BigInt: ...
    def Colls(self) -> special.collection.CollBuilder: ...
    def CostModel(self) -> CostModel: ...
    def Costing(self) -> special.collection.CostedBuilder: ...
    def Monoids(self) -> special.collection.MonoidBuilder: ...
    def allOf(self, conditions: special.collection.Coll[typing.Any]) -> bool: ...
    def allZK(self, conditions: special.collection.Coll['SigmaProp']) -> 'SigmaProp': ...
    def anyOf(self, conditions: special.collection.Coll[typing.Any]) -> bool: ...
    def anyZK(self, conditions: special.collection.Coll['SigmaProp']) -> 'SigmaProp': ...
    def atLeast(self, bound: int, props: special.collection.Coll['SigmaProp']) -> 'SigmaProp': ...
    def avlTree(self, operationFlags: int, digest: special.collection.Coll[typing.Any], keyLength: int, valueLengthOpt: scala.Option[typing.Any]) -> AvlTree: ...
    def blake2b256(self, bytes: special.collection.Coll[typing.Any]) -> special.collection.Coll[typing.Any]: ...
    def byteArrayToBigInt(self, bytes: special.collection.Coll[typing.Any]) -> BigInt: ...
    def byteArrayToLong(self, bytes: special.collection.Coll[typing.Any]) -> int: ...
    def decodePoint(self, encoded: special.collection.Coll[typing.Any]) -> GroupElement: ...
    def groupGenerator(self) -> GroupElement: ...
    def longToByteArray(self, l: int) -> special.collection.Coll[typing.Any]: ...
    def proveDHTuple(self, g: GroupElement, h: GroupElement, u: GroupElement, v: GroupElement) -> 'SigmaProp': ...
    def proveDlog(self, g: GroupElement) -> 'SigmaProp': ...
    def sha256(self, bytes: special.collection.Coll[typing.Any]) -> special.collection.Coll[typing.Any]: ...
    def sigmaProp(self, b: bool) -> 'SigmaProp': ...
    _substConstants__T = typing.TypeVar('_substConstants__T')  # <T>
    def substConstants(self, scriptBytes: special.collection.Coll[typing.Any], positions: special.collection.Coll[typing.Any], newValues: special.collection.Coll[_substConstants__T]) -> special.collection.Coll[typing.Any]: ...
    def toBigInteger(self, n: BigInt) -> java.math.BigInteger: ...
    def verifyZK(self, cond: scala.Function0['SigmaProp']) -> bool: ...
    def xor(self, l: special.collection.Coll[typing.Any], r: special.collection.Coll[typing.Any]) -> special.collection.Coll[typing.Any]: ...
    def xorOf(self, conditions: special.collection.Coll[typing.Any]) -> bool: ...

class SigmaDslModule(special.sigma.impl.SigmaDslDefs): ...

class SigmaProp:
    @typing.overload
    def $amp$amp(self, other: bool) -> 'SigmaProp': ...
    @typing.overload
    def $amp$amp(self, other: 'SigmaProp') -> 'SigmaProp': ...
    @typing.overload
    def $bar$bar(self, other: bool) -> 'SigmaProp': ...
    @typing.overload
    def $bar$bar(self, other: 'SigmaProp') -> 'SigmaProp': ...
    def isValid(self) -> bool: ...
    def propBytes(self) -> special.collection.Coll[typing.Any]: ...

class SizeAnyValue(special.collection.Size[AnyValue]):
    def tVal(self) -> scalan.RType[typing.Any]: ...
    def valueSize(self) -> special.collection.Size[typing.Any]: ...

class SizeBox(special.collection.Size[Box]):
    def bytes(self) -> special.collection.Size[special.collection.Coll[typing.Any]]: ...
    def bytesWithoutRef(self) -> special.collection.Size[special.collection.Coll[typing.Any]]: ...
    _getReg__T = typing.TypeVar('_getReg__T')  # <T>
    def getReg(self, id: int, tT: scalan.RType[_getReg__T]) -> special.collection.Size[scala.Option[_getReg__T]]: ...
    def propositionBytes(self) -> special.collection.Size[special.collection.Coll[typing.Any]]: ...
    def registers(self) -> special.collection.Size[special.collection.Coll[scala.Option[AnyValue]]]: ...
    def tokens(self) -> special.collection.Size[special.collection.Coll[scala.Tuple2[special.collection.Coll[typing.Any], typing.Any]]]: ...

class SizeBuilder:
    def mkSizeAnyValue(self, tVal: scalan.RType[typing.Any], valueSize: special.collection.Size[typing.Any]) -> SizeAnyValue: ...
    def mkSizeBox(self, propositionBytes: special.collection.Size[special.collection.Coll[typing.Any]], bytes: special.collection.Size[special.collection.Coll[typing.Any]], bytesWithoutRef: special.collection.Size[special.collection.Coll[typing.Any]], registers: special.collection.Size[special.collection.Coll[scala.Option[AnyValue]]], tokens: special.collection.Size[special.collection.Coll[scala.Tuple2[special.collection.Coll[typing.Any], typing.Any]]]) -> SizeBox: ...
    def mkSizeContext(self, outputs: special.collection.Size[special.collection.Coll[Box]], inputs: special.collection.Size[special.collection.Coll[Box]], dataInputs: special.collection.Size[special.collection.Coll[Box]], selfBox: special.collection.Size[Box], lastBlockUtxoRootHash: special.collection.Size[AvlTree], headers: special.collection.Size[special.collection.Coll[Header]], preHeader: special.collection.Size[PreHeader], vars: special.collection.Coll[special.collection.Size[AnyValue]]) -> 'SizeContext': ...

class SizeContext(special.collection.Size[Context]):
    def dataInputs(self) -> special.collection.Size[special.collection.Coll[Box]]: ...
    _getVar__T = typing.TypeVar('_getVar__T')  # <T>
    def getVar(self, id: int, tT: scalan.RType[_getVar__T]) -> special.collection.Size[scala.Option[_getVar__T]]: ...
    def headers(self) -> special.collection.Size[special.collection.Coll[Header]]: ...
    def inputs(self) -> special.collection.Size[special.collection.Coll[Box]]: ...
    def lastBlockUtxoRootHash(self) -> special.collection.Size[AvlTree]: ...
    def outputs(self) -> special.collection.Size[special.collection.Coll[Box]]: ...
    def preHeader(self) -> special.collection.Size[PreHeader]: ...
    def selfBox(self) -> special.collection.Size[Box]: ...

class SizeSigmaProp(special.collection.Size[SigmaProp]):
    def propBytes(self) -> special.collection.Size[special.collection.Coll[typing.Any]]: ...

class package:
    @staticmethod
    def AnyValueRType() -> scalan.RType[AnyValue]: ...
    @staticmethod
    def AvlTreeRType() -> scalan.RType[AvlTree]: ...
    @staticmethod
    def BigIntRType() -> scalan.RType[BigInt]: ...
    @staticmethod
    def BigIntegerRType() -> scalan.RType[java.math.BigInteger]: ...
    @staticmethod
    def BoxRType() -> scalan.RType[Box]: ...
    @staticmethod
    def ContextRType() -> scalan.RType[Context]: ...
    @staticmethod
    def CostModelRType() -> scalan.RType[CostModel]: ...
    @staticmethod
    def ECPointRType() -> scalan.RType[org.bouncycastle.math.ec.ECPoint]: ...
    @staticmethod
    def GroupElementRType() -> scalan.RType[GroupElement]: ...
    @staticmethod
    def HeaderRType() -> scalan.RType[Header]: ...
    @staticmethod
    def PreHeaderRType() -> scalan.RType[PreHeader]: ...
    @staticmethod
    def SigmaContractRType() -> scalan.RType[SigmaContract]: ...
    @staticmethod
    def SigmaDslBuilderRType() -> scalan.RType[SigmaDslBuilder]: ...
    @staticmethod
    def SigmaPropRType() -> scalan.RType[SigmaProp]: ...
    @staticmethod
    def SizeAnyValueRType() -> scalan.RType[SizeAnyValue]: ...
    @staticmethod
    def SizeBoxRType() -> scalan.RType[SizeBox]: ...
    @staticmethod
    def SizeBuilderRType() -> scalan.RType[SizeBuilder]: ...
    @staticmethod
    def SizeContextRType() -> scalan.RType[SizeContext]: ...
    @staticmethod
    def SizeSigmaPropRType() -> scalan.RType[SizeSigmaProp]: ...

class CSizeAnyValue(SizeAnyValue):
    def __init__(self, tVal: scalan.RType[typing.Any], valueSize: special.collection.Size[typing.Any]): ...
    def dataSize(self) -> int: ...
    def tVal(self) -> scalan.RType[typing.Any]: ...
    def valueSize(self) -> special.collection.Size[typing.Any]: ...

class CSizeBox(SizeBox):
    def __init__(self, propositionBytes: special.collection.Size[special.collection.Coll[typing.Any]], bytes: special.collection.Size[special.collection.Coll[typing.Any]], bytesWithoutRef: special.collection.Size[special.collection.Coll[typing.Any]], registers: special.collection.Size[special.collection.Coll[scala.Option[AnyValue]]], tokens: special.collection.Size[special.collection.Coll[scala.Tuple2[special.collection.Coll[typing.Any], typing.Any]]]): ...
    def bytes(self) -> special.collection.Size[special.collection.Coll[typing.Any]]: ...
    def bytesWithoutRef(self) -> special.collection.Size[special.collection.Coll[typing.Any]]: ...
    def dataSize(self) -> int: ...
    _getReg__T = typing.TypeVar('_getReg__T')  # <T>
    def getReg(self, id: int, tT: scalan.RType[_getReg__T]) -> special.collection.Size[scala.Option[_getReg__T]]: ...
    def propositionBytes(self) -> special.collection.Size[special.collection.Coll[typing.Any]]: ...
    def registers(self) -> special.collection.Size[special.collection.Coll[scala.Option[AnyValue]]]: ...
    def tokens(self) -> special.collection.Size[special.collection.Coll[scala.Tuple2[special.collection.Coll[typing.Any], typing.Any]]]: ...

class CSizeBuilder(SizeBuilder):
    def __init__(self): ...
    def mkSizeAnyValue(self, tVal: scalan.RType[typing.Any], valueSize: special.collection.Size[typing.Any]) -> SizeAnyValue: ...
    def mkSizeBox(self, propositionBytes: special.collection.Size[special.collection.Coll[typing.Any]], bytes: special.collection.Size[special.collection.Coll[typing.Any]], bytesWithoutRef: special.collection.Size[special.collection.Coll[typing.Any]], registers: special.collection.Size[special.collection.Coll[scala.Option[AnyValue]]], tokens: special.collection.Size[special.collection.Coll[scala.Tuple2[special.collection.Coll[typing.Any], typing.Any]]]) -> SizeBox: ...
    def mkSizeContext(self, outputs: special.collection.Size[special.collection.Coll[Box]], inputs: special.collection.Size[special.collection.Coll[Box]], dataInputs: special.collection.Size[special.collection.Coll[Box]], selfBox: special.collection.Size[Box], lastBlockUtxoRootHash: special.collection.Size[AvlTree], headers: special.collection.Size[special.collection.Coll[Header]], preHeader: special.collection.Size[PreHeader], vars: special.collection.Coll[special.collection.Size[AnyValue]]) -> SizeContext: ...

class CSizeContext(SizeContext):
    def __init__(self, outputs: special.collection.Size[special.collection.Coll[Box]], inputs: special.collection.Size[special.collection.Coll[Box]], dataInputs: special.collection.Size[special.collection.Coll[Box]], selfBox: special.collection.Size[Box], lastBlockUtxoRootHash: special.collection.Size[AvlTree], headers: special.collection.Size[special.collection.Coll[Header]], preHeader: special.collection.Size[PreHeader], vars: special.collection.Coll[special.collection.Size[AnyValue]]): ...
    def dataInputs(self) -> special.collection.Size[special.collection.Coll[Box]]: ...
    def dataSize(self) -> int: ...
    _getVar__T = typing.TypeVar('_getVar__T')  # <T>
    def getVar(self, id: int, tT: scalan.RType[_getVar__T]) -> special.collection.Size[scala.Option[_getVar__T]]: ...
    def headers(self) -> special.collection.Size[special.collection.Coll[Header]]: ...
    def inputs(self) -> special.collection.Size[special.collection.Coll[Box]]: ...
    def lastBlockUtxoRootHash(self) -> special.collection.Size[AvlTree]: ...
    def outputs(self) -> special.collection.Size[special.collection.Coll[Box]]: ...
    def preHeader(self) -> special.collection.Size[PreHeader]: ...
    def selfBox(self) -> special.collection.Size[Box]: ...
    def vars(self) -> special.collection.Coll[special.collection.Size[AnyValue]]: ...

class CSizeSigmaProp(SizeSigmaProp):
    def __init__(self, propBytes: special.collection.Size[special.collection.Coll[typing.Any]]): ...
    def dataSize(self) -> int: ...
    def propBytes(self) -> special.collection.Size[special.collection.Coll[typing.Any]]: ...

class MockProveDlog(SigmaProp, scala.Product, scala.Serializable):
    def __init__(self, isValid: bool, propBytes: special.collection.Coll[typing.Any]): ...
    @typing.overload
    def $amp$amp(self, other: bool) -> SigmaProp: ...
    @typing.overload
    def $amp$amp(self, other: SigmaProp) -> SigmaProp: ...
    @typing.overload
    def $bar$bar(self, other: bool) -> SigmaProp: ...
    @typing.overload
    def $bar$bar(self, other: SigmaProp) -> SigmaProp: ...
    @staticmethod
    def apply(isValid: bool, propBytes: special.collection.Coll[typing.Any]) -> 'MockProveDlog': ...
    def builder(self) -> 'TestSigmaDslBuilder': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, isValid: bool, propBytes: special.collection.Coll[typing.Any]) -> 'MockProveDlog': ...
    def copy$default$1(self) -> bool: ...
    def copy$default$2(self) -> special.collection.Coll[typing.Any]: ...
    @staticmethod
    def curried() -> scala.Function1[typing.Any, scala.Function1[special.collection.Coll[typing.Any], 'MockProveDlog']]: ...
    def curve(self) -> org.bouncycastle.asn1.x9.X9ECParameters: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def isValid(self) -> bool: ...
    def isValid_$eq(self, x$1: bool) -> None: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def propBytes(self) -> special.collection.Coll[typing.Any]: ...
    def setValid(self, v: bool) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[typing.Any, special.collection.Coll[typing.Any]], 'MockProveDlog']: ...
    @staticmethod
    def unapply(x$0: 'MockProveDlog') -> scala.Option[scala.Tuple2[typing.Any, special.collection.Coll[typing.Any]]]: ...
    def value(self) -> org.bouncycastle.math.ec.ECPoint: ...

class MockSigma(SigmaProp, scala.Product, scala.Serializable):
    def __init__(self, _isValid: bool): ...
    @typing.overload
    def $amp$amp(self, other: bool) -> SigmaProp: ...
    @typing.overload
    def $amp$amp(self, other: SigmaProp) -> SigmaProp: ...
    @typing.overload
    def $bar$bar(self, other: bool) -> SigmaProp: ...
    @typing.overload
    def $bar$bar(self, other: SigmaProp) -> SigmaProp: ...
    def _isValid(self) -> bool: ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['MockSigma', _andThen__A]) -> scala.Function1[typing.Any, _andThen__A]: ...
    @staticmethod
    def apply(_isValid: bool) -> 'MockSigma': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.Any]) -> scala.Function1[_compose__A, 'MockSigma']: ...
    def copy(self, _isValid: bool) -> 'MockSigma': ...
    def copy$default$1(self) -> bool: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def isValid(self) -> bool: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def propBytes(self) -> special.collection.Coll[typing.Any]: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'MockSigma') -> scala.Option[typing.Any]: ...

class TestBigInt(BigInt):
    def __init__(self, value: java.math.BigInteger): ...
    def $amp(self, that: BigInt) -> BigInt: ...
    def $bar(self, that: BigInt) -> BigInt: ...
    def $div(self, that: BigInt) -> BigInt: ...
    def $minus(self, that: BigInt) -> BigInt: ...
    def $percent(self, m: BigInt) -> BigInt: ...
    def $plus(self, that: BigInt) -> BigInt: ...
    def $times(self, that: BigInt) -> BigInt: ...
    def add(self, that: BigInt) -> BigInt: ...
    def compareTo(self, that: BigInt) -> int: ...
    def divide(self, that: BigInt) -> BigInt: ...
    def dsl(self) -> 'TestSigmaDslBuilder': ...
    def inverseModQ(self) -> BigInt: ...
    def max(self, that: BigInt) -> BigInt: ...
    def min(self, that: BigInt) -> BigInt: ...
    def minusModQ(self, other: BigInt) -> BigInt: ...
    def mod(self, m: BigInt) -> BigInt: ...
    def modQ(self) -> BigInt: ...
    def multModQ(self, other: BigInt) -> BigInt: ...
    def multiply(self, that: BigInt) -> BigInt: ...
    def negate(self) -> BigInt: ...
    def plusModQ(self, other: BigInt) -> BigInt: ...
    def remainder(self, that: BigInt) -> BigInt: ...
    def signum(self) -> int: ...
    def subtract(self, that: BigInt) -> BigInt: ...
    def toAbs(self) -> BigInt: ...
    def toBits(self) -> special.collection.Coll[typing.Any]: ...
    def toByte(self) -> int: ...
    def toBytes(self) -> special.collection.Coll[typing.Any]: ...
    def toInt(self) -> int: ...
    def toLong(self) -> int: ...
    def toShort(self) -> int: ...
    def value(self) -> java.math.BigInteger: ...

class TestGroupElement(GroupElement):
    def __init__(self, value: org.bouncycastle.math.ec.ECPoint): ...
    def dsl(self) -> 'TestSigmaDslBuilder': ...
    def exp(self, k: BigInt) -> GroupElement: ...
    def isInfinity(self) -> bool: ...
    def multiply(self, that: GroupElement) -> GroupElement: ...
    def negate(self) -> GroupElement: ...
    def toString(self) -> java.lang.String: ...
    def value(self) -> org.bouncycastle.math.ec.ECPoint: ...

class TestSigmaDslBuilder(SigmaDslBuilder):
    def __init__(self): ...
    def BigInt(self, n: java.math.BigInteger) -> BigInt: ...
    def Colls(self) -> special.collection.CollBuilder: ...
    def CostModel(self) -> CostModel: ...
    def Costing(self) -> special.collection.CostedBuilder: ...
    def GroupElement(self, p: org.bouncycastle.math.ec.ECPoint) -> GroupElement: ...
    def Monoids(self) -> special.collection.MonoidBuilder: ...
    def __curve__(self) -> org.bouncycastle.asn1.x9.X9ECParameters: ...
    def __g__(self) -> org.bouncycastle.math.ec.custom.sec.SecP256K1Point: ...
    def allOf(self, conditions: special.collection.Coll[typing.Any]) -> bool: ...
    def allZK(self, props: special.collection.Coll[SigmaProp]) -> SigmaProp: ...
    def anyOf(self, conditions: special.collection.Coll[typing.Any]) -> bool: ...
    def anyZK(self, props: special.collection.Coll[SigmaProp]) -> SigmaProp: ...
    def atLeast(self, bound: int, props: special.collection.Coll[SigmaProp]) -> SigmaProp: ...
    def avlTree(self, operationFlags: int, digest: special.collection.Coll[typing.Any], keyLength: int, valueLengthOpt: scala.Option[typing.Any]) -> AvlTree: ...
    def blake2b256(self, bytes: special.collection.Coll[typing.Any]) -> special.collection.Coll[typing.Any]: ...
    def byteArrayToBigInt(self, bytes: special.collection.Coll[typing.Any]) -> BigInt: ...
    def byteArrayToLong(self, bytes: special.collection.Coll[typing.Any]) -> int: ...
    def decodePoint(self, encoded: special.collection.Coll[typing.Any]) -> GroupElement: ...
    def groupGenerator(self) -> GroupElement: ...
    def longToByteArray(self, l: int) -> special.collection.Coll[typing.Any]: ...
    def proveDHTuple(self, g: GroupElement, h: GroupElement, u: GroupElement, v: GroupElement) -> SigmaProp: ...
    def proveDlog(self, g: GroupElement) -> SigmaProp: ...
    def sha256(self, bytes: special.collection.Coll[typing.Any]) -> special.collection.Coll[typing.Any]: ...
    def sigmaProp(self, b: bool) -> SigmaProp: ...
    _substConstants__T = typing.TypeVar('_substConstants__T')  # <T>
    def substConstants(self, scriptBytes: special.collection.Coll[typing.Any], positions: special.collection.Coll[typing.Any], newValues: special.collection.Coll[_substConstants__T]) -> special.collection.Coll[typing.Any]: ...
    def toBigInteger(self, n: BigInt) -> java.math.BigInteger: ...
    def toECPoint(self, ge: GroupElement) -> org.bouncycastle.math.ec.ECPoint: ...
    def verifyZK(self, proof: scala.Function0[SigmaProp]) -> bool: ...
    def xor(self, l: special.collection.Coll[typing.Any], r: special.collection.Coll[typing.Any]) -> special.collection.Coll[typing.Any]: ...
    def xorOf(self, conditions: special.collection.Coll[typing.Any]) -> bool: ...

_TestValue__A = typing.TypeVar('_TestValue__A')  # <A>
class TestValue(AnyValue, scala.Product, scala.Serializable, typing.Generic[_TestValue__A]):
    def __init__(self, value: _TestValue__A, tVal: scalan.RType[typing.Any]): ...
    _apply_0__A = typing.TypeVar('_apply_0__A')  # <A>
    _apply_1__A = typing.TypeVar('_apply_1__A')  # <A>
    @typing.overload
    @staticmethod
    def apply(value: _apply_0__A, tVal: scalan.RType[typing.Any]) -> 'TestValue'[_apply_0__A]: ...
    @typing.overload
    @staticmethod
    def apply(value: _apply_1__A, t: scalan.RType[_apply_1__A], o: scalan.OverloadHack.Overloaded1) -> 'TestValue'[_apply_1__A]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _copy__A = typing.TypeVar('_copy__A')  # <A>
    def copy(self, value: typing.Any, tVal: scalan.RType[typing.Any]) -> 'TestValue'[typing.Any]: ...
    _copy$default$1__A = typing.TypeVar('_copy$default$1__A')  # <A>
    def copy$default$1(self) -> typing.Any: ...
    _copy$default$2__A = typing.TypeVar('_copy$default$2__A')  # <A>
    def copy$default$2(self) -> scalan.RType[typing.Any]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def tA(self) -> scalan.RType[_TestValue__A]: ...
    def tVal(self) -> scalan.RType[typing.Any]: ...
    def toString(self) -> java.lang.String: ...
    _unapply__A = typing.TypeVar('_unapply__A')  # <A>
    @staticmethod
    def unapply(x$0: 'TestValue'[_unapply__A]) -> scala.Option[scala.Tuple2[_unapply__A, scalan.RType[typing.Any]]]: ...
    def value(self) -> _TestValue__A: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("special.sigma")``.

    AnyValue: typing.Type[AnyValue]
    AvlTree: typing.Type[AvlTree]
    AvlTreeVerifier: typing.Type[AvlTreeVerifier]
    BigInt: typing.Type[BigInt]
    Box: typing.Type[Box]
    CSizeAnyValue: typing.Type[CSizeAnyValue]
    CSizeBox: typing.Type[CSizeBox]
    CSizeBuilder: typing.Type[CSizeBuilder]
    CSizeContext: typing.Type[CSizeContext]
    CSizeSigmaProp: typing.Type[CSizeSigmaProp]
    Context: typing.Type[Context]
    CostModel: typing.Type[CostModel]
    CostedObjects: typing.Type[CostedObjects]
    CostedObjectsModule: typing.Type[CostedObjectsModule]
    DslSyntaxExtensions: typing.Type[DslSyntaxExtensions]
    Extensions: typing.Type[Extensions]
    GroupElement: typing.Type[GroupElement]
    Header: typing.Type[Header]
    InvalidType: typing.Type[InvalidType]
    MockProveDlog: typing.Type[MockProveDlog]
    MockSigma: typing.Type[MockSigma]
    PreHeader: typing.Type[PreHeader]
    SigmaContract: typing.Type[SigmaContract]
    SigmaDsl: typing.Type[SigmaDsl]
    SigmaDslBuilder: typing.Type[SigmaDslBuilder]
    SigmaDslModule: typing.Type[SigmaDslModule]
    SigmaProp: typing.Type[SigmaProp]
    SizeAnyValue: typing.Type[SizeAnyValue]
    SizeBox: typing.Type[SizeBox]
    SizeBuilder: typing.Type[SizeBuilder]
    SizeContext: typing.Type[SizeContext]
    SizeSigmaProp: typing.Type[SizeSigmaProp]
    TestBigInt: typing.Type[TestBigInt]
    TestGroupElement: typing.Type[TestGroupElement]
    TestSigmaDslBuilder: typing.Type[TestSigmaDslBuilder]
    TestValue: typing.Type[TestValue]
    package: typing.Type[package]
    wrappers: special.sigma.wrappers.__module_protocol__
