/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ergoplatform.appkit.ErgoType;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.Iso;
import org.ergoplatform.appkit.JavaHelpers;
import scala.collection.IndexedSeq;
import scala.collection.mutable.ArrayOps;
import scorex.crypto.hash.Sha256;
import scorex.util.encode.Base16;
import sigmastate.SType;
import sigmastate.Values;
import sigmastate.serialization.ErgoTreeSerializer;

public class ErgoTreeTemplate {
    private static int[] _noParameters = new int[0];
    private final Values.ErgoTree _tree;
    private final byte[] _templateBytes;
    private int[] _parameterPositions = _noParameters;

    private ErgoTreeTemplate(Values.ErgoTree ergoTree) {
        this._tree = ergoTree;
        this._templateBytes = JavaHelpers.ergoTreeTemplateBytes(this._tree);
    }

    public ErgoTreeTemplate withParameterPositions(int[] nArray) {
        if (Arrays.stream(nArray).distinct().count() != (long)nArray.length) {
            throw new IllegalArgumentException("Duplicate positions: " + new ArrayOps.ofInt(nArray).mkString("[", ",", "]"));
        }
        for (int n : nArray) {
            if (this._tree.constants().isDefinedAt((Values.Constant<SType>)n)) continue;
            throw new IllegalArgumentException("Invalid parameter position " + n);
        }
        this._parameterPositions = nArray;
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ErgoTreeTemplate ergoTreeTemplate = (ErgoTreeTemplate)object;
        return Arrays.equals(this.getBytes(), ergoTreeTemplate.getBytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this._templateBytes);
    }

    public byte[] getBytes() {
        return this._templateBytes;
    }

    public String getEncodedBytes() {
        return Base16.encode(this.getBytes());
    }

    public String getTemplateHashHex() {
        return Base16.encode(Sha256.hash(this._templateBytes));
    }

    public int getParameterCount() {
        return this._parameterPositions.length;
    }

    public List<ErgoType<?>> getParameterTypes() {
        ArrayList arrayList = new ArrayList();
        IndexedSeq<Values.Constant<SType>> indexedSeq = this._tree.constants();
        for (int n : this._parameterPositions) {
            Object s = ((Values.Constant)indexedSeq.apply(n)).tpe();
            arrayList.add(Iso.isoErgoTypeToSType().from((SType)s));
        }
        return arrayList;
    }

    public ErgoValue<?> getParameterValue(int n) {
        Values.Constant constant = (Values.Constant)this._tree.constants().apply(this._parameterPositions[n]);
        return Iso.isoErgoValueToSValue().from(constant);
    }

    public Values.ErgoTree applyParameters(ErgoValue<?> ... ergoValueArray) {
        if (ergoValueArray.length != this._parameterPositions.length) {
            throw new IllegalArgumentException("Wrong number of newValues. Expected " + this._parameterPositions.length + " but was " + ergoValueArray.length);
        }
        return JavaHelpers.substituteErgoTreeConstants(this._tree.bytes(), this._parameterPositions, ergoValueArray);
    }

    public static ErgoTreeTemplate fromErgoTree(Values.ErgoTree ergoTree) {
        return new ErgoTreeTemplate(ergoTree);
    }

    public static ErgoTreeTemplate fromErgoTreeBytes(byte[] byArray) {
        Values.ErgoTree ergoTree = ErgoTreeSerializer.DefaultSerializer().deserializeErgoTree(byArray);
        return ErgoTreeTemplate.fromErgoTree(ergoTree);
    }
}

