/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.babelfee;

import java.util.Objects;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.ErgoId;
import org.ergoplatform.appkit.SigmaProp;
import org.ergoplatform.appkit.babelfee.BabelFeeBoxState;

public class BabelFeeBoxStateBuilder {
    private long pricePerToken;
    private ErgoId tokenId;
    private SigmaProp boxCreator;
    private long value;
    private long tokenAmount;

    public BabelFeeBoxStateBuilder withPricePerToken(long l) {
        this.pricePerToken = l;
        return this;
    }

    public BabelFeeBoxStateBuilder withTokenId(ErgoId ergoId) {
        this.tokenId = ergoId;
        return this;
    }

    public BabelFeeBoxStateBuilder withBoxCreator(SigmaProp sigmaProp) {
        this.boxCreator = sigmaProp;
        return this;
    }

    public BabelFeeBoxStateBuilder withBoxCreator(Address address) {
        this.boxCreator = SigmaProp.createFromAddress(address);
        return this;
    }

    public BabelFeeBoxStateBuilder withValue(long l) {
        this.value = l;
        return this;
    }

    public BabelFeeBoxStateBuilder withTokenAmount(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("pricePerToken must be equal or greater than 0");
        }
        this.tokenAmount = l;
        return this;
    }

    public BabelFeeBoxState build() {
        Objects.requireNonNull(this.boxCreator, "Box creator not set");
        Objects.requireNonNull(this.tokenId, "Token ID not set");
        if (this.value <= 0L) {
            throw new IllegalArgumentException("value must be greater than 0");
        }
        if (this.pricePerToken <= 0L) {
            throw new IllegalArgumentException("pricePerToken must be greater than 0");
        }
        return new BabelFeeBoxState(this.pricePerToken, this.tokenId, this.boxCreator, this.value, this.tokenAmount);
    }
}

