/*
 * Decompiled with CFR 0.152.
 */
package org.ergoplatform.appkit.babelfee;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.ergoplatform.appkit.Address;
import org.ergoplatform.appkit.BlockchainContext;
import org.ergoplatform.appkit.BoxOperations;
import org.ergoplatform.appkit.ContextVar;
import org.ergoplatform.appkit.ErgoId;
import org.ergoplatform.appkit.ErgoToken;
import org.ergoplatform.appkit.ErgoValue;
import org.ergoplatform.appkit.InputBox;
import org.ergoplatform.appkit.OutBox;
import org.ergoplatform.appkit.OutBoxBuilder;
import org.ergoplatform.appkit.UnsignedTransaction;
import org.ergoplatform.appkit.UnsignedTransactionBuilder;
import org.ergoplatform.appkit.babelfee.BabelFeeBoxContract;
import org.ergoplatform.appkit.babelfee.BabelFeeBoxState;
import org.ergoplatform.appkit.impl.ErgoTreeContract;

public class BabelFeeOperations {
    public static UnsignedTransaction createNewBabelContractTx(BoxOperations boxOperations, ErgoId ergoId, long l) {
        BabelFeeBoxState babelFeeBoxState = BabelFeeBoxState.newBuilder().withBoxCreator(boxOperations.getSenders().get(0)).withPricePerToken(l).withTokenId(ergoId).withValue(boxOperations.getAmountToSpend()).build();
        return boxOperations.buildTxWithDefaultInputs(unsignedTransactionBuilder -> {
            OutBox outBox = babelFeeBoxState.buildOutbox((UnsignedTransactionBuilder)unsignedTransactionBuilder, null);
            unsignedTransactionBuilder.outputs(outBox);
            return unsignedTransactionBuilder;
        });
    }

    public static UnsignedTransaction cancelBabelFeeContract(BoxOperations boxOperations, InputBox inputBox) {
        BabelFeeBoxState babelFeeBoxState = new BabelFeeBoxState(inputBox);
        Address address = Address.fromSigmaBoolean(babelFeeBoxState.getBoxCreator().getSigmaBoolean(), boxOperations.getBlockchainContext().getNetworkType());
        List<InputBox> list = babelFeeBoxState.getValue() < boxOperations.getFeeAmount() + 1000000L ? boxOperations.loadTop() : new ArrayList<InputBox>();
        list.add(0, inputBox);
        UnsignedTransactionBuilder unsignedTransactionBuilder = boxOperations.getBlockchainContext().newTxBuilder();
        OutBoxBuilder outBoxBuilder = unsignedTransactionBuilder.outBoxBuilder().value(Math.max(1000000L, babelFeeBoxState.getValue() - boxOperations.getFeeAmount())).contract(address.toErgoContract());
        if (!inputBox.getTokens().isEmpty()) {
            outBoxBuilder.tokens(inputBox.getTokens().get(0));
        }
        return unsignedTransactionBuilder.boxesToSpend(list).fee(boxOperations.getFeeAmount()).sendChangeTo(address).outputs(outBoxBuilder.build()).build();
    }

    @Nullable
    public static InputBox findBabelFeeBox(BlockchainContext blockchainContext, BoxOperations.IUnspentBoxesLoader iUnspentBoxesLoader, ErgoId ergoId, long l, int n) {
        ErgoTreeContract ergoTreeContract = new ErgoTreeContract(new BabelFeeBoxContract(ergoId).getErgoTree(), blockchainContext.getNetworkType());
        Address address = ergoTreeContract.toAddress();
        iUnspentBoxesLoader.prepare(blockchainContext, Collections.singletonList(address), l, new ArrayList<ErgoToken>());
        List<InputBox> list = null;
        InputBox inputBox = null;
        long l2 = 0L;
        for (int i = 0; !(i != 0 && list.isEmpty() || inputBox != null && n != 0 && i >= n); ++i) {
            list = iUnspentBoxesLoader.loadBoxesPage(blockchainContext, address, i);
            for (InputBox inputBox2 : list) {
                try {
                    BabelFeeBoxState babelFeeBoxState = new BabelFeeBoxState(inputBox2);
                    long l3 = babelFeeBoxState.getPricePerToken();
                    if (babelFeeBoxState.getValueAvailableToBuy() < l || l3 <= l2) continue;
                    inputBox = inputBox2;
                    l2 = l3;
                }
                catch (Throwable throwable) {}
            }
        }
        return inputBox;
    }

    public static void addBabelFeeBoxes(UnsignedTransactionBuilder unsignedTransactionBuilder, InputBox inputBox, long l) {
        BabelFeeBoxState babelFeeBoxState = new BabelFeeBoxState(inputBox);
        BabelFeeBoxState babelFeeBoxState2 = babelFeeBoxState.buildSucceedingState(babelFeeBoxState.calcTokensToSellForErgAmount(l));
        OutBox outBox = babelFeeBoxState2.buildOutbox(unsignedTransactionBuilder, inputBox);
        unsignedTransactionBuilder.addInputs(inputBox.withContextVars(ContextVar.of((byte)0, ErgoValue.of(unsignedTransactionBuilder.getOutputBoxes().size()))));
        unsignedTransactionBuilder.addOutputs(outBox);
    }
}

