/*
 * Decompiled with CFR 0.152.
 */
package sigmastate;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import gf2t.GF2_192_Poly;
import java.io.Serializable;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scorex.util.encode.Base16$;
import sigmastate.CAND;
import sigmastate.CAndUncheckedNode;
import sigmastate.COR;
import sigmastate.COrUncheckedNode;
import sigmastate.CTHRESHOLD;
import sigmastate.CThresholdUncheckedNode;
import sigmastate.FixedCost;
import sigmastate.NoProof$;
import sigmastate.PerItemCost;
import sigmastate.UncheckedDiffieHellmanTuple;
import sigmastate.UncheckedSchnorr;
import sigmastate.UncheckedSigmaTree;
import sigmastate.UncheckedTree;
import sigmastate.Values;
import sigmastate.basics.DLogProtocol;
import sigmastate.basics.ProveDHTuple;
import sigmastate.basics.SecondDiffieHellmanTupleProverMessage;
import sigmastate.basics.VerifierMessage$Challenge$;
import sigmastate.interpreter.CryptoConstants$;
import sigmastate.interpreter.ErgoTreeEvaluator;
import sigmastate.interpreter.ErgoTreeEvaluator$;
import sigmastate.interpreter.NamedDesc;
import sigmastate.interpreter.OperationCostInfo;
import sigmastate.lang.exceptions.SerializerException;
import sigmastate.lang.exceptions.SerializerException$;
import sigmastate.package$JitCost$;
import sigmastate.serialization.SigmaSerializer$;
import sigmastate.util$;
import sigmastate.utils.Helpers$;
import sigmastate.utils.SigmaByteReader;
import sigmastate.utils.SigmaByteWriter;
import supertagged.package$Tagger$;

public final class SigSerializer$
implements LazyLogging {
    public static SigSerializer$ MODULE$;
    private final int hashSize;
    private final int order;
    private final OperationCostInfo<FixedCost> ParseChallenge_ProveDlog;
    private final OperationCostInfo<FixedCost> ParseChallenge_ProveDHT;
    private final OperationCostInfo<PerItemCost> ParsePolynomial;
    private final OperationCostInfo<PerItemCost> EvaluatePolynomial;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new SigSerializer$();
    }

    private Logger logger$lzycompute() {
        SigSerializer$ sigSerializer$ = this;
        synchronized (sigSerializer$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public void warn(String msg) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(msg);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public int hashSize() {
        return this.hashSize;
    }

    public int order() {
        return this.order;
    }

    public byte[] toProofBytes(UncheckedTree tree) {
        byte[] byArray;
        UncheckedTree uncheckedTree = tree;
        if (NoProof$.MODULE$.equals(uncheckedTree)) {
            byArray = Array$.MODULE$.emptyByteArray();
        } else if (uncheckedTree instanceof UncheckedSigmaTree) {
            UncheckedSigmaTree uncheckedSigmaTree = (UncheckedSigmaTree)uncheckedTree;
            SigmaByteWriter w = SigmaSerializer$.MODULE$.startWriter();
            this.toProofBytes(uncheckedSigmaTree, w, true);
            byte[] res = w.toBytes();
            byArray = res;
        } else {
            throw new MatchError(uncheckedTree);
        }
        return byArray;
    }

    public void toProofBytes(UncheckedSigmaTree node, SigmaByteWriter w, boolean writeChallenge) {
        block9: {
            UncheckedSigmaTree uncheckedSigmaTree;
            while (true) {
                Object object = writeChallenge ? w.putBytes(node.challenge()) : BoxedUnit.UNIT;
                uncheckedSigmaTree = node;
                if (uncheckedSigmaTree instanceof UncheckedSchnorr) {
                    UncheckedSchnorr uncheckedSchnorr = (UncheckedSchnorr)uncheckedSigmaTree;
                    byte[] z = BigIntegers.asUnsignedByteArray(this.order(), uncheckedSchnorr.secondMessage().z().bigInteger());
                    w.putBytes(z);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (uncheckedSigmaTree instanceof UncheckedDiffieHellmanTuple) {
                    UncheckedDiffieHellmanTuple uncheckedDiffieHellmanTuple = (UncheckedDiffieHellmanTuple)uncheckedSigmaTree;
                    byte[] z = BigIntegers.asUnsignedByteArray(this.order(), uncheckedDiffieHellmanTuple.secondMessage().z());
                    w.putBytes(z);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (uncheckedSigmaTree instanceof CAndUncheckedNode) {
                    CAndUncheckedNode cAndUncheckedNode = (CAndUncheckedNode)uncheckedSigmaTree;
                    UncheckedSigmaTree[] cs = (UncheckedSigmaTree[])cAndUncheckedNode.children().toArray(ClassTag$.MODULE$.apply(UncheckedSigmaTree.class));
                    for (int index$macro$1 = 0; index$macro$1 < cs.length; ++index$macro$1) {
                        UncheckedSigmaTree child = cs[index$macro$1];
                        this.toProofBytes(child, w, false);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (!(uncheckedSigmaTree instanceof COrUncheckedNode)) break;
                COrUncheckedNode cOrUncheckedNode = (COrUncheckedNode)uncheckedSigmaTree;
                UncheckedSigmaTree[] cs = (UncheckedSigmaTree[])cOrUncheckedNode.children().toArray(ClassTag$.MODULE$.apply(UncheckedSigmaTree.class));
                int iLastChild = cs.length - 1;
                for (int index$macro$2 = 0; index$macro$2 < iLastChild; ++index$macro$2) {
                    UncheckedSigmaTree child = cs[index$macro$2];
                    this.toProofBytes(child, w, true);
                }
                writeChallenge = false;
                node = cs[iLastChild];
            }
            if (uncheckedSigmaTree instanceof CThresholdUncheckedNode) {
                CThresholdUncheckedNode cThresholdUncheckedNode = (CThresholdUncheckedNode)uncheckedSigmaTree;
                byte[] poly = cThresholdUncheckedNode.polynomialOpt().get().toByteArray(Predef$.MODULE$.boolean2Boolean(false));
                w.putBytes(poly);
                UncheckedSigmaTree[] cs = (UncheckedSigmaTree[])cThresholdUncheckedNode.children().toArray(ClassTag$.MODULE$.apply(UncheckedSigmaTree.class));
                for (int index$macro$3 = 0; index$macro$3 < cs.length; ++index$macro$3) {
                    UncheckedSigmaTree child = cs[index$macro$3];
                    this.toProofBytes(child, w, false);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new SerializerException(new StringBuilder(35).append("Don't know how to execute toBytes(").append(node).append(")").toString(), SerializerException$.MODULE$.$lessinit$greater$default$2(), SerializerException$.MODULE$.$lessinit$greater$default$3());
            }
        }
    }

    public UncheckedTree parseAndComputeChallenges(Values.SigmaBoolean exp, byte[] proof, ErgoTreeEvaluator E) {
        UncheckedTree uncheckedTree;
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(proof)).isEmpty()) {
            uncheckedTree = NoProof$.MODULE$;
        } else {
            SigmaByteReader r = SigmaSerializer$.MODULE$.startReader(proof, SigmaSerializer$.MODULE$.startReader$default$2());
            UncheckedSigmaTree res = this.parseAndComputeChallenges(exp, r, null, E);
            uncheckedTree = res;
        }
        return uncheckedTree;
    }

    public final OperationCostInfo<FixedCost> ParseChallenge_ProveDlog() {
        return this.ParseChallenge_ProveDlog;
    }

    public final OperationCostInfo<FixedCost> ParseChallenge_ProveDHT() {
        return this.ParseChallenge_ProveDHT;
    }

    public final OperationCostInfo<PerItemCost> ParsePolynomial() {
        return this.ParsePolynomial;
    }

    public final OperationCostInfo<PerItemCost> EvaluatePolynomial() {
        return this.EvaluatePolynomial;
    }

    public byte[] readBytesChecked(SigmaByteReader r, int numRequestedBytes, Function1<String, BoxedUnit> onError2) {
        BoxedUnit boxedUnit;
        byte[] bytes = r.getBytesUnsafe(numRequestedBytes);
        if (bytes.length != numRequestedBytes) {
            String hex = Base16$.MODULE$.encode(r.getAllBufferBytes());
            boxedUnit = onError2.apply(hex);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return bytes;
    }

    public UncheckedSigmaTree parseAndComputeChallenges(Values.SigmaBoolean exp, SigmaByteReader r, byte[] challengeOpt, ErgoTreeEvaluator E) {
        UncheckedSigmaTree uncheckedSigmaTree;
        byte[] challenge = challengeOpt == null ? (byte[])VerifierMessage$Challenge$.MODULE$.$at$at(this.readBytesChecked(r, this.hashSize(), (Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable & scala.Serializable)hex -> {
            SigSerializer$.MODULE$.warn(new StringBuilder(22).append("Invalid challenge in: ").append(hex).toString());
            return BoxedUnit.UNIT;
        }), package$Tagger$.MODULE$.baseRaw()) : challengeOpt;
        Values.SigmaBoolean sigmaBoolean = exp;
        if (sigmaBoolean instanceof DLogProtocol.ProveDlog) {
            DLogProtocol.ProveDlog proveDlog = (DLogProtocol.ProveDlog)sigmaBoolean;
            uncheckedSigmaTree = (UncheckedSigmaTree)ErgoTreeEvaluator$.MODULE$.fixedCostOp(this.ParseChallenge_ProveDlog(), (Function0<UncheckedSchnorr> & Serializable & scala.Serializable)() -> {
                byte[] z_bytes = MODULE$.readBytesChecked(r, MODULE$.order(), (Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable & scala.Serializable)hex -> {
                    SigSerializer$.MODULE$.warn(new StringBuilder(22).append("Invalid z bytes for ").append(proveDlog).append(": ").append(hex).toString());
                    return BoxedUnit.UNIT;
                });
                BigInteger z = BigIntegers.fromUnsignedByteArray(z_bytes);
                return new UncheckedSchnorr(proveDlog, None$.MODULE$, challenge, new DLogProtocol.SecondDLogProverMessage(BigInt$.MODULE$.javaBigInteger2bigInt(z)));
            }, E);
        } else if (sigmaBoolean instanceof ProveDHTuple) {
            ProveDHTuple proveDHTuple = (ProveDHTuple)sigmaBoolean;
            uncheckedSigmaTree = (UncheckedSigmaTree)ErgoTreeEvaluator$.MODULE$.fixedCostOp(this.ParseChallenge_ProveDHT(), (Function0<UncheckedDiffieHellmanTuple> & Serializable & scala.Serializable)() -> {
                byte[] z_bytes = MODULE$.readBytesChecked(r, MODULE$.order(), (Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable & scala.Serializable)hex -> {
                    SigSerializer$.MODULE$.warn(new StringBuilder(22).append("Invalid z bytes for ").append(proveDHTuple).append(": ").append(hex).toString());
                    return BoxedUnit.UNIT;
                });
                BigInteger z = BigIntegers.fromUnsignedByteArray(z_bytes);
                return new UncheckedDiffieHellmanTuple(proveDHTuple, None$.MODULE$, challenge, new SecondDiffieHellmanTupleProverMessage(z));
            }, E);
        } else if (sigmaBoolean instanceof CAND) {
            CAND cAND = (CAND)sigmaBoolean;
            int nChildren = cAND.children().length();
            UncheckedSigmaTree[] children = (UncheckedSigmaTree[])util$.MODULE$.safeNewArray(nChildren, ClassTag$.MODULE$.apply(UncheckedSigmaTree.class));
            for (int index$macro$1 = 0; index$macro$1 < nChildren; ++index$macro$1) {
                children[index$macro$1] = this.parseAndComputeChallenges((Values.SigmaBoolean)cAND.children().apply(index$macro$1), r, challenge, E);
            }
            uncheckedSigmaTree = new CAndUncheckedNode(challenge, Predef$.MODULE$.wrapRefArray((Object[])children));
        } else if (sigmaBoolean instanceof COR) {
            COR cOR = (COR)sigmaBoolean;
            int nChildren = cOR.children().length();
            UncheckedSigmaTree[] children = (UncheckedSigmaTree[])util$.MODULE$.safeNewArray(nChildren, ClassTag$.MODULE$.apply(UncheckedSigmaTree.class));
            byte[] xorBuf = (byte[])challenge.clone();
            int iLastChild = nChildren - 1;
            for (int index$macro$2 = 0; index$macro$2 < iLastChild; ++index$macro$2) {
                UncheckedSigmaTree parsedChild;
                children[index$macro$2] = parsedChild = this.parseAndComputeChallenges((Values.SigmaBoolean)cOR.children().apply(index$macro$2), r, null, E);
                Helpers$.MODULE$.xorU(xorBuf, parsedChild.challenge());
            }
            Values.SigmaBoolean lastChild = (Values.SigmaBoolean)cOR.children().apply(iLastChild);
            children[iLastChild] = this.parseAndComputeChallenges(lastChild, r, (byte[])VerifierMessage$Challenge$.MODULE$.$at$at(xorBuf, package$Tagger$.MODULE$.baseRaw()), E);
            uncheckedSigmaTree = new COrUncheckedNode(challenge, Predef$.MODULE$.wrapRefArray((Object[])children));
        } else if (sigmaBoolean instanceof CTHRESHOLD) {
            CTHRESHOLD cTHRESHOLD = (CTHRESHOLD)sigmaBoolean;
            int nChildren = cTHRESHOLD.children().length();
            int nCoefs = nChildren - cTHRESHOLD.k();
            GF2_192_Poly polynomial = (GF2_192_Poly)ErgoTreeEvaluator$.MODULE$.perItemCostOp(this.ParsePolynomial(), nCoefs, (Function0<GF2_192_Poly> & Serializable & scala.Serializable)() -> {
                byte[] coeffBytes = MODULE$.readBytesChecked(r, MODULE$.hashSize() * nCoefs, (Function1<String, BoxedUnit>)(Function1<String, Object> & Serializable & scala.Serializable)hex -> {
                    SigSerializer$.MODULE$.warn(new StringBuilder(25).append("Invalid coeffBytes for ").append(cTHRESHOLD).append(": ").append(hex).toString());
                    return BoxedUnit.UNIT;
                });
                return GF2_192_Poly.fromByteArray(challenge, coeffBytes);
            }, E);
            UncheckedSigmaTree[] children = (UncheckedSigmaTree[])util$.MODULE$.safeNewArray(nChildren, ClassTag$.MODULE$.apply(UncheckedSigmaTree.class));
            IntRef index$macro$3 = IntRef.create(0);
            while (index$macro$3.elem < nChildren) {
                byte[] c = (byte[])ErgoTreeEvaluator$.MODULE$.perItemCostOp(this.EvaluatePolynomial(), nCoefs, (Function0<byte[]> & Serializable & scala.Serializable)() -> (byte[])VerifierMessage$Challenge$.MODULE$.$at$at(polynomial.evaluate((byte)(index$macro$3$1.elem + 1)).toByteArray(), package$Tagger$.MODULE$.baseRaw()), E);
                children[index$macro$3.elem] = this.parseAndComputeChallenges((Values.SigmaBoolean)cTHRESHOLD.children().apply(index$macro$3.elem), r, c, E);
                ++index$macro$3.elem;
            }
            uncheckedSigmaTree = new CThresholdUncheckedNode(challenge, Predef$.MODULE$.wrapRefArray((Object[])children), Predef$.MODULE$.int2Integer(cTHRESHOLD.k()), new Some<GF2_192_Poly>(polynomial));
        } else {
            throw new MatchError(sigmaBoolean);
        }
        return uncheckedSigmaTree;
    }

    public byte[] parseAndComputeChallenges$default$3() {
        return null;
    }

    private SigSerializer$() {
        MODULE$ = this;
        LazyLogging.$init$(this);
        this.hashSize = CryptoConstants$.MODULE$.soundnessBits() / 8;
        this.order = CryptoConstants$.MODULE$.groupSize();
        this.ParseChallenge_ProveDlog = new OperationCostInfo<FixedCost>(new FixedCost(package$JitCost$.MODULE$.apply(10)), new NamedDesc("ParseChallenge_ProveDlog"));
        this.ParseChallenge_ProveDHT = new OperationCostInfo<FixedCost>(new FixedCost(package$JitCost$.MODULE$.apply(10)), new NamedDesc("ParseChallenge_ProveDHT"));
        this.ParsePolynomial = new OperationCostInfo<PerItemCost>(new PerItemCost(package$JitCost$.MODULE$.apply(10), package$JitCost$.MODULE$.apply(10), 1), new NamedDesc("ParsePolynomial"));
        this.EvaluatePolynomial = new OperationCostInfo<PerItemCost>(new PerItemCost(package$JitCost$.MODULE$.apply(3), package$JitCost$.MODULE$.apply(3), 1), new NamedDesc("EvaluatePolynomial"));
    }
}

