/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.interpreter;

import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import sigmastate.Values;
import sigmastate.interpreter.EvalSettings;
import sigmastate.interpreter.Interpreter;
import sigmastate.interpreter.Interpreter$;

public final class CostingUtils$ {
    public static CostingUtils$ MODULE$;

    static {
        new CostingUtils$();
    }

    public void checkResults(String ergoTreeHex, Interpreter.AotReductionResult aotRes, Interpreter.JitReductionResult jitRes, Function1<String, BoxedUnit> logger, EvalSettings es) {
        BoxedUnit boxedUnit;
        Values.SigmaBoolean aotValue = aotRes.value();
        Values.SigmaBoolean jitValue = jitRes.value();
        Values.SigmaBoolean sigmaBoolean = aotValue;
        Values.SigmaBoolean sigmaBoolean2 = jitValue;
        if (sigmaBoolean == null ? sigmaBoolean2 != null : !sigmaBoolean.equals(sigmaBoolean2)) {
            String msg = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(201).append("Wrong JIT result: -----------------------------------------\n          |ErgoTree: ").append(ergoTreeHex).append("\n          |AOT result: ").append(aotValue).append("\n          |JIT result: ").append(jitValue).append("\n          |------------------------------------------------------------").toString())).stripMargin();
            if (es.isTestRun()) {
                throw Interpreter$.MODULE$.error(msg);
            }
            boxedUnit = es.isLogEnabled() ? logger.apply(msg) : BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.checkCosts(ergoTreeHex, aotRes.cost(), jitRes.cost(), logger, es);
    }

    public void checkCosts(String ergoTreeHex, long aotCost, long jitCost, Function1<String, BoxedUnit> logger, EvalSettings es) {
        block2: {
            if (aotCost >= jitCost) break block2;
            String msg = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(195).append("Wrong JIT cost: -----------------------------------------\n          |ErgoTree: ").append(ergoTreeHex).append("\n          |AOT cost: ").append(aotCost).append("\n          |JIT cost: ").append(jitCost).append("\n          |------------------------------------------------------------").toString())).stripMargin();
            if (es.isTestRun()) {
                throw Interpreter$.MODULE$.error(msg);
            }
            if (es.isLogEnabled()) {
                logger.apply(msg);
            }
        }
    }

    private CostingUtils$() {
        MODULE$ = this;
    }
}

