/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.interpreter;

import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scalan.Base;
import scalan.TypeDescs;
import sigmastate.CAND;
import sigmastate.COR;
import sigmastate.CTHRESHOLD;
import sigmastate.FiatShamirTree$;
import sigmastate.FixedCost;
import sigmastate.SBoolean$;
import sigmastate.SSigmaProp$;
import sigmastate.SType;
import sigmastate.SigSerializer$;
import sigmastate.TrivialProp$;
import sigmastate.Values;
import sigmastate.Values$;
import sigmastate.Values$SigmaPropValueOps$;
import sigmastate.basics.DLogProtocol;
import sigmastate.basics.ProveDHTuple;
import sigmastate.eval.IRContext;
import sigmastate.eval.Profiler;
import sigmastate.interpreter.Interpreter;
import sigmastate.interpreter.NamedDesc;
import sigmastate.interpreter.OperationCostInfo;
import sigmastate.lang.Terms$;
import sigmastate.lang.Terms$ValueOps$;
import sigmastate.lang.exceptions.InterpreterException;
import sigmastate.lang.exceptions.InterpreterException$;
import sigmastate.package$JitCost$;
import special.sigma.Context;
import special.sigma.SigmaDsl;
import special.sigma.SigmaProp;
import special.sigma.impl.SigmaDslDefs;

public final class Interpreter$ {
    public static Interpreter$ MODULE$;
    private final Map<String, Object> emptyEnv;
    private final String ScriptNameProp;
    private final OperationCostInfo<FixedCost> ComputeCommitments_Schnorr;
    private final OperationCostInfo<FixedCost> ComputeCommitments_DHT;
    private final OperationCostInfo<FixedCost> Eval_SigmaPropConstant;
    private final int ProveDlogVerificationCost;
    private final int ProveDHTupleVerificationCost;
    private final Profiler verifySignatureProfiler;

    static {
        new Interpreter$();
    }

    public Map<String, Object> emptyEnv() {
        return this.emptyEnv;
    }

    public String ScriptNameProp() {
        return this.ScriptNameProp;
    }

    public Interpreter.AotReductionResult WhenSoftForkReductionResult(long cost) {
        return new Interpreter.AotReductionResult(TrivialProp$.MODULE$.TrueProp(), cost);
    }

    public Interpreter.JitReductionResult WhenSoftForkJitReductionResult(long cost) {
        return new Interpreter.JitReductionResult(TrivialProp$.MODULE$.TrueProp(), cost);
    }

    public final OperationCostInfo<FixedCost> ComputeCommitments_Schnorr() {
        return this.ComputeCommitments_Schnorr;
    }

    public final OperationCostInfo<FixedCost> ComputeCommitments_DHT() {
        return this.ComputeCommitments_DHT;
    }

    public final OperationCostInfo<FixedCost> Eval_SigmaPropConstant() {
        return this.Eval_SigmaPropConstant;
    }

    public final int ProveDlogVerificationCost() {
        return this.ProveDlogVerificationCost;
    }

    public final int ProveDHTupleVerificationCost() {
        return this.ProveDHTupleVerificationCost;
    }

    public int estimateCryptoVerifyCost(Values.SigmaBoolean sb) {
        int n;
        Values.SigmaBoolean sigmaBoolean = sb;
        if (sigmaBoolean instanceof DLogProtocol.ProveDlog) {
            n = this.ProveDlogVerificationCost();
        } else if (sigmaBoolean instanceof ProveDHTuple) {
            n = this.ProveDHTupleVerificationCost();
        } else if (sigmaBoolean instanceof CAND) {
            CAND cAND = (CAND)sigmaBoolean;
            int nodeC = FiatShamirTree$.MODULE$.ToBytes_ProofTreeConjecture().costKind().cost();
            int childrenC = this.childrenCost$1(cAND.children());
            n = package$JitCost$.MODULE$.$plus$extension(nodeC, childrenC);
        } else if (sigmaBoolean instanceof COR) {
            COR cOR = (COR)sigmaBoolean;
            int nodeC = FiatShamirTree$.MODULE$.ToBytes_ProofTreeConjecture().costKind().cost();
            int childrenC = this.childrenCost$1(cOR.children());
            n = package$JitCost$.MODULE$.$plus$extension(nodeC, childrenC);
        } else if (sigmaBoolean instanceof CTHRESHOLD) {
            CTHRESHOLD cTHRESHOLD = (CTHRESHOLD)sigmaBoolean;
            int nChildren = cTHRESHOLD.children().length();
            int nCoefs = nChildren - cTHRESHOLD.k();
            int parseC = SigSerializer$.MODULE$.ParsePolynomial().costKind().cost(nCoefs);
            int evalC = package$JitCost$.MODULE$.$times$extension(SigSerializer$.MODULE$.EvaluatePolynomial().costKind().cost(nCoefs), nChildren);
            int nodeC = FiatShamirTree$.MODULE$.ToBytes_ProofTreeConjecture().costKind().cost();
            int childernC = this.childrenCost$1(cTHRESHOLD.children());
            n = package$JitCost$.MODULE$.$plus$extension(package$JitCost$.MODULE$.$plus$extension(package$JitCost$.MODULE$.$plus$extension(parseC, evalC), nodeC), childernC);
        } else {
            n = package$JitCost$.MODULE$.apply(0);
        }
        return n;
    }

    public Profiler verifySignatureProfiler() {
        return this.verifySignatureProfiler;
    }

    public SigmaProp calcResult(IRContext IR, Context context, Base.Ref<Function1<SigmaDsl.Context, Object>> calcF) {
        SigmaProp sigmaProp;
        Base.Ref<Function1<SigmaDsl.Context, Object>> ref = calcF;
        TypeDescs.Elem elem = ((TypeDescs)((Object)IR)).FuncElemExtensions(ref.elem()).eRange();
        if (elem instanceof SigmaDslDefs.SigmaProp.SigmaPropElem && ((SigmaDslDefs.SigmaProp.SigmaPropElem)elem).special$sigma$impl$SigmaDslDefs$SigmaProp$SigmaPropElem$$$outer() == IR.SigmaProp()) {
            SigmaProp sp2;
            SigmaProp sp3;
            Function1<Context, Tuple2<SigmaProp, Object>> valueFun = IR.compile(IR.getDataEnv(), ((Base)((Object)IR)).asRep(ref), IR.compile$default$3(), IR.Context().LiftableContext(), IR.SigmaProp().LiftableSigmaProp());
            Tuple2<SigmaProp, Object> tuple2 = valueFun.apply(context);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            SigmaProp sigmaProp2 = sp3 = tuple2._1();
            sigmaProp = sp2 = sigmaProp2;
        } else {
            TypeDescs.Elem<Object> elem2 = ((TypeDescs)((Object)IR)).BooleanElement();
            TypeDescs.Elem elem3 = elem;
            if (!(elem2 != null ? !elem2.equals(elem3) : elem3 != null)) {
                boolean b;
                Function1<Context, Tuple2<Object, Object>> valueFun = IR.compile(IR.getDataEnv(), ((Base)((Object)IR)).asRep(ref), IR.compile$default$3(), IR.Context().LiftableContext(), ((Base)((Object)IR)).Liftables().BooleanIsLiftable());
                Tuple2<Object, Object> tuple2 = valueFun.apply(context);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                boolean bl = b = tuple2._1$mcZ$sp();
                boolean b2 = bl;
                sigmaProp = IR.sigmaDslBuilderValue().sigmaProp(b2);
            } else {
                throw new MatchError(elem);
            }
        }
        SigmaProp res = sigmaProp;
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Values.Value<SBoolean$> toValidScriptType(Values.Value<SType> exp) {
        Values.Value<SType> value = exp;
        if (value instanceof Values.Value) {
            Values.Value<SType> value2 = value;
            SType sType = value2.tpe();
            SBoolean$ sBoolean$ = SBoolean$.MODULE$;
            if (sType == null) {
                if (sBoolean$ == null) return value2;
            } else if (sType.equals(sBoolean$)) {
                return value2;
            }
        }
        if (value == null) throw new Error(new StringBuilder(90).append("Context-dependent pre-processing should produce tree of type Boolean or SigmaProp but was ").append(value).toString());
        Values.Value<SType> value3 = value;
        SType sType = value3.tpe();
        SSigmaProp$ sSigmaProp$ = SSigmaProp$.MODULE$;
        if (sType != null) {
            if (!sType.equals(sSigmaProp$)) throw new Error(new StringBuilder(90).append("Context-dependent pre-processing should produce tree of type Boolean or SigmaProp but was ").append(value).toString());
            return Values$SigmaPropValueOps$.MODULE$.isProven$extension(Values$.MODULE$.SigmaPropValueOps(Terms$ValueOps$.MODULE$.asSigmaProp$extension(Terms$.MODULE$.ValueOps(value3))));
        }
        if (sSigmaProp$ == null) return Values$SigmaPropValueOps$.MODULE$.isProven$extension(Values$.MODULE$.SigmaPropValueOps(Terms$ValueOps$.MODULE$.asSigmaProp$extension(Terms$.MODULE$.ValueOps(value3))));
        throw new Error(new StringBuilder(90).append("Context-dependent pre-processing should produce tree of type Boolean or SigmaProp but was ").append(value).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Values.Value<SSigmaProp$> sigmastate$interpreter$Interpreter$$toValidScriptTypeJITC(Values.Value<SType> exp) {
        Values.Value<SType> value = exp;
        if (value instanceof Values.Value) {
            Values.Value<SType> value2 = value;
            SType sType = value2.tpe();
            SBoolean$ sBoolean$ = SBoolean$.MODULE$;
            if (sType == null) {
                if (sBoolean$ == null) return value2.toSigmaProp();
            } else if (sType.equals(sBoolean$)) {
                return value2.toSigmaProp();
            }
        }
        if (value == null) throw new Error(new StringBuilder(90).append("Context-dependent pre-processing should produce tree of type Boolean or SigmaProp but was ").append(value).toString());
        Values.Value<SType> value3 = value;
        SType sType = value3.tpe();
        SSigmaProp$ sSigmaProp$ = SSigmaProp$.MODULE$;
        if (sType != null) {
            if (!sType.equals(sSigmaProp$)) throw new Error(new StringBuilder(90).append("Context-dependent pre-processing should produce tree of type Boolean or SigmaProp but was ").append(value).toString());
            return Terms$ValueOps$.MODULE$.asSigmaProp$extension(Terms$.MODULE$.ValueOps(value3));
        }
        if (sSigmaProp$ == null) return Terms$ValueOps$.MODULE$.asSigmaProp$extension(Terms$.MODULE$.ValueOps(value3));
        throw new Error(new StringBuilder(90).append("Context-dependent pre-processing should produce tree of type Boolean or SigmaProp but was ").append(value).toString());
    }

    public Nothing$ error(String msg) {
        throw new InterpreterException(msg, InterpreterException$.MODULE$.$lessinit$greater$default$2(), InterpreterException$.MODULE$.$lessinit$greater$default$3());
    }

    private final int childrenCost$1(Seq children) {
        Values.SigmaBoolean[] childrenArr = (Values.SigmaBoolean[])children.toArray(ClassTag$.MODULE$.apply(Values.SigmaBoolean.class));
        int nChildren = childrenArr.length;
        int sum = package$JitCost$.MODULE$.apply(0);
        for (int index$macro$1 = 0; index$macro$1 < nChildren; ++index$macro$1) {
            int c = this.estimateCryptoVerifyCost(childrenArr[index$macro$1]);
            sum = package$JitCost$.MODULE$.$plus$extension(sum, c);
        }
        return sum;
    }

    private Interpreter$() {
        MODULE$ = this;
        this.emptyEnv = Predef$.MODULE$.Map().empty();
        this.ScriptNameProp = "ScriptName";
        this.ComputeCommitments_Schnorr = new OperationCostInfo<FixedCost>(new FixedCost(package$JitCost$.MODULE$.apply(3400)), new NamedDesc("ComputeCommitments_Schnorr"));
        this.ComputeCommitments_DHT = new OperationCostInfo<FixedCost>(new FixedCost(package$JitCost$.MODULE$.apply(6450)), new NamedDesc("ComputeCommitments_DHT"));
        this.Eval_SigmaPropConstant = new OperationCostInfo<FixedCost>(new FixedCost(package$JitCost$.MODULE$.apply(50)), new NamedDesc("Eval_SigmaPropConstant"));
        this.ProveDlogVerificationCost = package$JitCost$.MODULE$.$plus$extension(package$JitCost$.MODULE$.$plus$extension(SigSerializer$.MODULE$.ParseChallenge_ProveDlog().costKind().cost(), this.ComputeCommitments_Schnorr().costKind().cost()), FiatShamirTree$.MODULE$.ToBytes_Schnorr().costKind().cost());
        this.ProveDHTupleVerificationCost = package$JitCost$.MODULE$.$plus$extension(package$JitCost$.MODULE$.$plus$extension(SigSerializer$.MODULE$.ParseChallenge_ProveDHT().costKind().cost(), this.ComputeCommitments_DHT().costKind().cost()), FiatShamirTree$.MODULE$.ToBytes_DHT().costKind().cost());
        this.verifySignatureProfiler = new Profiler();
    }
}

