/*
 * Decompiled with CFR 0.152.
 */
package sigmastate.serialization;

import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Point;
import scala.Array$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction0$mcB$sp;
import sigmastate.basics.BcDlogGroup;
import sigmastate.interpreter.CryptoConstants$;
import sigmastate.serialization.SigmaSerializer;
import sigmastate.serialization.SigmaSerializer$;
import sigmastate.util$;
import sigmastate.utils.SigmaByteReader;
import sigmastate.utils.SigmaByteWriter;

public final class GroupElementSerializer$
extends SigmaSerializer<SecP256K1Point, SecP256K1Point> {
    public static GroupElementSerializer$ MODULE$;
    private byte[] identityPointEncoding;
    private final BcDlogGroup<SecP256K1Point> curve;
    private final int encodingSize;
    private volatile boolean bitmap$0;

    static {
        new GroupElementSerializer$();
    }

    private BcDlogGroup<SecP256K1Point> curve() {
        return this.curve;
    }

    private int encodingSize() {
        return this.encodingSize;
    }

    private byte[] identityPointEncoding$lzycompute() {
        GroupElementSerializer$ groupElementSerializer$ = this;
        synchronized (groupElementSerializer$) {
            if (!this.bitmap$0) {
                this.identityPointEncoding = (byte[])Array$.MODULE$.fill(this.encodingSize(), (JFunction0$mcB$sp & Serializable)() -> 0, ClassTag$.MODULE$.Byte());
                this.bitmap$0 = true;
            }
        }
        return this.identityPointEncoding;
    }

    private byte[] identityPointEncoding() {
        return !this.bitmap$0 ? this.identityPointEncoding$lzycompute() : this.identityPointEncoding;
    }

    @Override
    public void serialize(SecP256K1Point point, SigmaByteWriter w) {
        byte[] byArray;
        if (point.isInfinity()) {
            byArray = this.identityPointEncoding();
        } else {
            ECPoint normed = point.normalize();
            boolean ySign = normed.getAffineYCoord().testBitZero();
            byte[] X = normed.getXCoord().getEncoded();
            byte[] PO = (byte[])util$.MODULE$.safeNewArray(X.length + 1, ClassTag$.MODULE$.Byte());
            PO[0] = (byte)(ySign ? 3 : 2);
            System.arraycopy(X, 0, PO, 1, X.length);
            byArray = PO;
        }
        byte[] bytes = byArray;
        w.putBytes(bytes);
    }

    @Override
    public SecP256K1Point parse(SigmaByteReader r) {
        byte[] encoded = r.getBytes(this.encodingSize());
        return encoded[0] != 0 ? (SecP256K1Point)this.curve().curve().decodePoint(encoded) : this.curve().identity();
    }

    @Override
    public SecP256K1Point parse(byte[] bytes) {
        return this.parse(SigmaSerializer$.MODULE$.startReader(bytes, SigmaSerializer$.MODULE$.startReader$default$2()));
    }

    private GroupElementSerializer$() {
        MODULE$ = this;
        this.curve = CryptoConstants$.MODULE$.dlogGroup();
        this.encodingSize = 1 + CryptoConstants$.MODULE$.groupSize();
    }
}

