import com.typesafe.scalalogging
import io.circe
import java.lang
import org
import org.bitbucket.inkytonik.kiama.rewriting
import org.ergoplatform.appkit
import org.ergoplatform.dsl
import org.ergoplatform.explorer
import org.ergoplatform.mining
import org.ergoplatform.restapi
import org.ergoplatform.settings
import org.ergoplatform.utils
import org.ergoplatform.validation
import org.ergoplatform.wallet
import scala
import scala.collection
import scala.collection.immutable
import scala.math
import scala.runtime
import scala.util
import scorex.util.serialization
import sigmastate
import sigmastate.basics
import sigmastate.eval
import sigmastate.interpreter
import sigmastate.lang
import sigmastate.serialization
import sigmastate.utils
import special.collection
import special.sigma
import typing



class Context:
    _addCost_0__R = typing.TypeVar('_addCost_0__R')  # <R>
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType, block: scala.Function0[_addCost_0__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addCost_0__R: ...
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.FixedCost, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    _addSeqCost__R = typing.TypeVar('_addSeqCost__R')  # <R>
    @staticmethod
    def addSeqCost(costKind: sigmastate.PerItemCost, nItems: int, block: scala.Function0[_addSeqCost__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addSeqCost__R: ...
    @staticmethod
    def addSeqCostNoOp(costKind: sigmastate.PerItemCost, nItems: int, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def companion() -> 'Context.': ...
    @staticmethod
    def costKind() -> sigmastate.FixedCost: ...
    _evalTo__T = typing.TypeVar('_evalTo__T')  # <T>
    @staticmethod
    def evalTo(env: scala.collection.immutable.Map[typing.Any, typing.Any], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _evalTo__T: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def init() -> None: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.interpreter.CompanionDesc: ...
    @staticmethod
    def opName() -> java.lang.String: ...
    @staticmethod
    def opType() -> sigmastate.SFunc: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def sourceContext() -> sigmastate.lang.SourceContext: ...
    @staticmethod
    def sourceContext_$eq(srcCtx: sigmastate.lang.SourceContext) -> None: ...
    @staticmethod
    def toString() -> java.lang.String: ...
    @staticmethod
    def tpe() -> sigmastate.SContext.: ...
    @staticmethod
    def typeName() -> java.lang.String: ...
    class : ...

class DataInput(scala.Product, scala.Serializable):
    def __init__(self, boxId: typing.List[int]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['DataInput', _andThen__A]) -> scala.Function1[typing.List[int], _andThen__A]: ...
    @staticmethod
    def apply(boxId: typing.List[int]) -> 'DataInput': ...
    def boxId(self) -> typing.List[int]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.List[int]]) -> scala.Function1[_compose__A, 'DataInput']: ...
    def copy(self, boxId: typing.List[int]) -> 'DataInput': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def equals(self, obj: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'DataInput') -> scala.Option[typing.List[int]]: ...

class ErgoAddress:
    def addressTypePrefix(self) -> int: ...
    def contentBytes(self) -> typing.List[int]: ...
    def networkPrefix(self) -> int: ...
    def script(self) -> sigmastate.Values.ErgoTree: ...

class ErgoAddressEncoder(scala.Product, scala.Serializable):
    def __init__(self, networkPrefix: int): ...
    @staticmethod
    def ChecksumLength() -> int: ...
    def IsPay2SHAddress(self) -> 'ErgoAddressEncoder.IsPay2SHAddress.': ...
    @staticmethod
    def MainnetNetworkPrefix() -> int: ...
    @staticmethod
    def TestnetNetworkPrefix() -> int: ...
    @staticmethod
    def apply(networkPrefix: int) -> 'ErgoAddressEncoder': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, networkPrefix: int) -> 'ErgoAddressEncoder': ...
    def copy$default$1(self) -> int: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def fromProposition(self, proposition: sigmastate.Values.ErgoTree) -> scala.util.Try[ErgoAddress]: ...
    def fromString(self, addrBase58Str: typing.Union[java.lang.String, str]) -> scala.util.Try[ErgoAddress]: ...
    @staticmethod
    def hash192(input: typing.List[int]) -> typing.List[int]: ...
    @staticmethod
    def hash256(input: typing.List[int]) -> typing.List[int]: ...
    def hashCode(self) -> int: ...
    def isMainnetAddress(self, addrHeadByte: int) -> bool: ...
    def isTestnetAddress(self, addrHeadByte: int) -> bool: ...
    def networkPrefix(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    @typing.overload
    def toString(self) -> java.lang.String: ...
    @typing.overload
    def toString(self, address: ErgoAddress) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ErgoAddressEncoder') -> scala.Option[typing.Any]: ...
    class IsPay2SHAddress$:
        def __init__(self, $outer: 'ErgoAddressEncoder'): ...
        def unapply(self, exp: sigmastate.Values.Value[sigmastate.SSigmaProp.]) -> scala.Option[special.collection.Coll[typing.Any]]: ...

class ErgoBoxAssets:
    def tokens(self) -> scala.collection.immutable.Map[java.lang.String, typing.Any]: ...
    def value(self) -> int: ...

class ErgoBoxReader:
    def byId(self, boxId: typing.List[int]) -> scala.util.Try['ErgoBox']: ...

class ErgoLikeContext(sigmastate.interpreter.InterpreterContext):
    def __init__(self, lastBlockUtxoRoot: sigmastate.AvlTreeData, headers: special.collection.Coll[special.sigma.Header], preHeader: special.sigma.PreHeader, dataBoxes: scala.collection.IndexedSeq['ErgoBox'], boxesToSpend: scala.collection.IndexedSeq['ErgoBox'], spendingTransaction: 'ErgoLikeTransactionTemplate'['UnsignedInput'], selfIndex: int, extension: sigmastate.interpreter.ContextExtension, validationSettings: org.ergoplatform.validation.SigmaValidationSettings, costLimit: int, initCost: int, activatedScriptVersion: int): ...
    @staticmethod
    def MaxHeaders() -> int: ...
    def activatedScriptVersion(self) -> int: ...
    def boxesToSpend(self) -> scala.collection.IndexedSeq['ErgoBox']: ...
    def canEqual(self, other: typing.Any) -> bool: ...
    _copy__T = typing.TypeVar('_copy__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy(ctx: _copy__T, lastBlockUtxoRoot: sigmastate.AvlTreeData, headers: special.collection.Coll[special.sigma.Header], preHeader: special.sigma.PreHeader, dataBoxes: scala.collection.IndexedSeq['ErgoBox'], boxesToSpend: scala.collection.IndexedSeq['ErgoBox'], spendingTransaction: 'ErgoLikeTransactionTemplate'['UnsignedInput'], selfIndex: int, extension: sigmastate.interpreter.ContextExtension, validationSettings: org.ergoplatform.validation.SigmaValidationSettings, costLimit: int, initCost: int, activatedScriptVersion: int) -> 'ErgoLikeContext': ...
    _copy$default$10__T = typing.TypeVar('_copy$default$10__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$10(ctx: _copy.default.10__T) -> org.ergoplatform.validation.SigmaValidationSettings: ...
    _copy$default$11__T = typing.TypeVar('_copy$default$11__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$11(ctx: _copy.default.11__T) -> int: ...
    _copy$default$12__T = typing.TypeVar('_copy$default$12__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$12(ctx: _copy.default.12__T) -> int: ...
    _copy$default$13__T = typing.TypeVar('_copy$default$13__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$13(ctx: _copy.default.13__T) -> int: ...
    _copy$default$2__T = typing.TypeVar('_copy$default$2__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$2(ctx: _copy.default.2__T) -> sigmastate.AvlTreeData: ...
    _copy$default$3__T = typing.TypeVar('_copy$default$3__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$3(ctx: _copy.default.3__T) -> special.collection.Coll[special.sigma.Header]: ...
    _copy$default$4__T = typing.TypeVar('_copy$default$4__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$4(ctx: _copy.default.4__T) -> special.sigma.PreHeader: ...
    _copy$default$5__T = typing.TypeVar('_copy$default$5__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$5(ctx: _copy.default.5__T) -> scala.collection.IndexedSeq['ErgoBox']: ...
    _copy$default$6__T = typing.TypeVar('_copy$default$6__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$6(ctx: _copy.default.6__T) -> scala.collection.IndexedSeq['ErgoBox']: ...
    _copy$default$7__T = typing.TypeVar('_copy$default$7__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$7(ctx: _copy.default.7__T) -> 'ErgoLikeTransactionTemplate'['UnsignedInput']: ...
    _copy$default$8__T = typing.TypeVar('_copy$default$8__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$8(ctx: _copy.default.8__T) -> int: ...
    _copy$default$9__T = typing.TypeVar('_copy$default$9__T', bound='ErgoLikeContext')  # <T>
    @staticmethod
    def copy$default$9(ctx: _copy.default.9__T) -> sigmastate.interpreter.ContextExtension: ...
    def costLimit(self) -> int: ...
    def dataBoxes(self) -> scala.collection.IndexedSeq['ErgoBox']: ...
    def equals(self, other: typing.Any) -> bool: ...
    def extension(self) -> sigmastate.interpreter.ContextExtension: ...
    def hashCode(self) -> int: ...
    def headers(self) -> special.collection.Coll[special.sigma.Header]: ...
    def initCost(self) -> int: ...
    def lastBlockUtxoRoot(self) -> sigmastate.AvlTreeData: ...
    def preHeader(self) -> special.sigma.PreHeader: ...
    def self(self) -> 'ErgoBox': ...
    def selfIndex(self) -> int: ...
    def spendingTransaction(self) -> 'ErgoLikeTransactionTemplate'['UnsignedInput']: ...
    def toSigmaContext(self, isCost: bool, extensions: scala.collection.immutable.Map[typing.Any, special.sigma.AnyValue]) -> special.sigma.Context: ...
    def toSigmaContext$default$2(self) -> scala.collection.immutable.Map[typing.Any, special.sigma.AnyValue]: ...
    def toString(self) -> java.lang.String: ...
    def validationSettings(self) -> org.ergoplatform.validation.SigmaValidationSettings: ...
    def withBindings(self, bindings: scala.collection.Seq[scala.Tuple2[typing.Any, sigmastate.Values.EvaluatedValue[sigmastate.SType]]]) -> sigmastate.interpreter.InterpreterContext: ...
    def withCostLimit(self, newCostLimit: int) -> 'ErgoLikeContext': ...
    def withExtension(self, newExtension: sigmastate.interpreter.ContextExtension) -> 'ErgoLikeContext': ...
    def withInitCost(self, newInitCost: int) -> 'ErgoLikeContext': ...
    def withTransaction(self, newSpendingTransaction: 'ErgoLikeTransactionTemplate'['UnsignedInput']) -> 'ErgoLikeContext': ...
    def withValidationSettings(self, newVs: org.ergoplatform.validation.SigmaValidationSettings) -> 'ErgoLikeContext': ...

class ErgoLikeInterpreter(sigmastate.interpreter.Interpreter):
    def __init__(self, IR: sigmastate.eval.IRContext): ...
    def IR(self) -> sigmastate.eval.IRContext: ...
    def applyDeserializeContext(self, context: sigmastate.interpreter.InterpreterContext, exp: sigmastate.Values.Value[sigmastate.SType]) -> scala.Tuple2[sigmastate.Values.Value[sigmastate.SBoolean.], sigmastate.interpreter.InterpreterContext]: ...
    def com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(self, x$1: com.typesafe.scalalogging.Logger) -> None: ...
    def computeCommitments(self) -> org.bitbucket.inkytonik.kiama.rewriting.Strategy: ...
    def deserializeMeasured(self, context: sigmastate.interpreter.InterpreterContext, scriptBytes: typing.List[int]) -> scala.Tuple2[sigmastate.interpreter.InterpreterContext, sigmastate.Values.Value[sigmastate.SType]]: ...
    def fullReduction(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, env: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any]) -> sigmastate.interpreter.Interpreter.ReductionResult: ...
    def log(self) -> com.typesafe.scalalogging.Logger: ...
    def logger(self) -> com.typesafe.scalalogging.Logger: ...
    def precompiledScriptProcessor(self) -> sigmastate.interpreter.PrecompiledScriptProcessor: ...
    def propositionFromErgoTree(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext) -> sigmastate.Values.Value[sigmastate.SSigmaProp.]: ...
    @typing.overload
    def reduceToCrypto(self, context: sigmastate.interpreter.InterpreterContext, env: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any], exp: sigmastate.Values.Value[sigmastate.SType]) -> scala.util.Try[sigmastate.interpreter.Interpreter.ReductionResult]: ...
    @typing.overload
    def reduceToCrypto(self, context: sigmastate.interpreter.InterpreterContext, exp: sigmastate.Values.Value[sigmastate.SType]) -> scala.util.Try[sigmastate.interpreter.Interpreter.ReductionResult]: ...
    def sigmastate$interpreter$Interpreter$_setter_$computeCommitments_$eq(self, x$1: org.bitbucket.inkytonik.kiama.rewriting.Strategy) -> None: ...
    def substDeserialize(self, context: ErgoLikeContext, updateContext: scala.Function1[ErgoLikeContext, scala.runtime.BoxedUnit], node: sigmastate.Values.Value[sigmastate.SType]) -> scala.Option[sigmastate.Values.Value[sigmastate.SType]]: ...
    @typing.overload
    def verify(self, env: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any], ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, proof: typing.List[int], message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...
    @typing.overload
    def verify(self, env: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any], ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, proverResult: sigmastate.interpreter.ProverResult, message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...
    @typing.overload
    def verify(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, proof: sigmastate.UncheckedTree, message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...
    @typing.overload
    def verify(self, ergoTree: sigmastate.Values.ErgoTree, context: sigmastate.interpreter.InterpreterContext, proverResult: sigmastate.interpreter.ProverResult, message: typing.List[int]) -> scala.util.Try[scala.Tuple2[typing.Any, typing.Any]]: ...
    def verifySignature(self, sigmaTree: sigmastate.Values.SigmaBoolean, message: typing.List[int], signature: typing.List[int]) -> bool: ...

class ErgoLikeTransactionSerializer:
    @staticmethod
    def error(msg: typing.Union[java.lang.String, str]) -> scala.runtime.Nothing.: ...
    @staticmethod
    def fromBytes(bytes: typing.List[int]) -> typing.Any: ...
    @staticmethod
    def parse(r: sigmastate.utils.SigmaByteReader) -> 'ErgoLikeTransaction': ...
    @staticmethod
    def parseTry(r: scorex.util.serialization.Reader) -> scala.util.Try: ...
    @staticmethod
    def parseWithGenericReader(r: scorex.util.serialization.Reader, vs: org.ergoplatform.validation.SigmaValidationSettings) -> typing.Any: ...
    @staticmethod
    def serialize(tx: 'ErgoLikeTransaction', w: sigmastate.utils.SigmaByteWriter) -> None: ...
    @staticmethod
    def serializeWithGenericWriter(obj: typing.Any, w: scorex.util.serialization.Writer) -> None: ...
    @staticmethod
    def toBytes(obj: typing.Any) -> typing.List[int]: ...

_ErgoLikeTransactionTemplate__IT = typing.TypeVar('_ErgoLikeTransactionTemplate__IT', bound='UnsignedInput')  # <IT>
class ErgoLikeTransactionTemplate(typing.Generic[_ErgoLikeTransactionTemplate__IT]):
    @staticmethod
    def $init$($this: 'ErgoLikeTransactionTemplate') -> None: ...
    def dataInputs(self) -> scala.collection.IndexedSeq[DataInput]: ...
    def id(self) -> java.lang.String: ...
    def inputIds(self) -> scala.collection.IndexedSeq[typing.List[int]]: ...
    def inputs(self) -> scala.collection.IndexedSeq[_ErgoLikeTransactionTemplate__IT]: ...
    def messageToSign(self) -> typing.List[int]: ...
    def outputCandidates(self) -> scala.collection.IndexedSeq['ErgoBoxCandidate']: ...
    def outputs(self) -> scala.collection.IndexedSeq['ErgoBox']: ...
    def toString(self) -> java.lang.String: ...

class ErgoScriptPredef:
    @staticmethod
    def FalseProp(headerFlags: int) -> sigmastate.Values.ErgoTree: ...
    @staticmethod
    def TrueProp(headerFlags: int) -> sigmastate.Values.ErgoTree: ...
    @staticmethod
    def boxCreationHeight(box: sigmastate.Values.Value[sigmastate.SBox.]) -> sigmastate.Values.Value[sigmastate.SInt.]: ...
    @staticmethod
    def compileWithCosting(env: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any], code: typing.Union[java.lang.String, str], networkPrefix: int, IR: sigmastate.eval.IRContext) -> sigmastate.Values.Value[sigmastate.SType]: ...
    @staticmethod
    def emissionBoxProp(s: org.ergoplatform.settings.MonetarySettings) -> sigmastate.Values.ErgoTree: ...
    @staticmethod
    def expectedMinerOutScriptBytesVal(delta: int, minerPkBytesVal: sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SByte.]]) -> sigmastate.Values.Value[sigmastate.SCollection[sigmastate.SByte.]]: ...
    @staticmethod
    def feeProposition(delta: int) -> sigmastate.Values.ErgoTree: ...
    @staticmethod
    def feeProposition$default$1() -> int: ...
    @staticmethod
    def foundationScript(s: org.ergoplatform.settings.MonetarySettings) -> sigmastate.Values.ErgoTree: ...
    @staticmethod
    def rewardOutputScript(delta: int, minerPk: sigmastate.basics.DLogProtocol.ProveDlog) -> sigmastate.Values.ErgoTree: ...
    @staticmethod
    def tokenThresholdScript(tokenId: typing.List[int], thresholdAmount: int, networkPrefix: int, IR: sigmastate.eval.IRContext) -> sigmastate.Values.Value[sigmastate.SSigmaProp.]: ...

class Global:
    _addCost_0__R = typing.TypeVar('_addCost_0__R')  # <R>
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType, block: scala.Function0[_addCost_0__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addCost_0__R: ...
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.FixedCost, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    _addSeqCost__R = typing.TypeVar('_addSeqCost__R')  # <R>
    @staticmethod
    def addSeqCost(costKind: sigmastate.PerItemCost, nItems: int, block: scala.Function0[_addSeqCost__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addSeqCost__R: ...
    @staticmethod
    def addSeqCostNoOp(costKind: sigmastate.PerItemCost, nItems: int, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def companion() -> 'Global.': ...
    @staticmethod
    def costKind() -> sigmastate.FixedCost: ...
    _evalTo__T = typing.TypeVar('_evalTo__T')  # <T>
    @staticmethod
    def evalTo(env: scala.collection.immutable.Map[typing.Any, typing.Any], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _evalTo__T: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def init() -> None: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.interpreter.CompanionDesc: ...
    @staticmethod
    def opName() -> java.lang.String: ...
    @staticmethod
    def opType() -> sigmastate.SFunc: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def sourceContext() -> sigmastate.lang.SourceContext: ...
    @staticmethod
    def sourceContext_$eq(srcCtx: sigmastate.lang.SourceContext) -> None: ...
    @staticmethod
    def toString() -> java.lang.String: ...
    @staticmethod
    def tpe() -> sigmastate.SGlobal.: ...
    @staticmethod
    def typeName() -> java.lang.String: ...
    class : ...

class Height:
    _addCost_0__R = typing.TypeVar('_addCost_0__R')  # <R>
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType, block: scala.Function0[_addCost_0__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addCost_0__R: ...
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.FixedCost, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    _addSeqCost__R = typing.TypeVar('_addSeqCost__R')  # <R>
    @staticmethod
    def addSeqCost(costKind: sigmastate.PerItemCost, nItems: int, block: scala.Function0[_addSeqCost__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addSeqCost__R: ...
    @staticmethod
    def addSeqCostNoOp(costKind: sigmastate.PerItemCost, nItems: int, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def companion() -> 'Height.': ...
    @staticmethod
    def costKind() -> sigmastate.FixedCost: ...
    _evalTo__T = typing.TypeVar('_evalTo__T')  # <T>
    @staticmethod
    def evalTo(env: scala.collection.immutable.Map[typing.Any, typing.Any], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _evalTo__T: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def init() -> None: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.interpreter.CompanionDesc: ...
    @staticmethod
    def opName() -> java.lang.String: ...
    @staticmethod
    def opType() -> sigmastate.SFunc: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def sourceContext() -> sigmastate.lang.SourceContext: ...
    @staticmethod
    def sourceContext_$eq(srcCtx: sigmastate.lang.SourceContext) -> None: ...
    @staticmethod
    def toString() -> java.lang.String: ...
    @staticmethod
    def tpe() -> sigmastate.SInt.: ...
    @staticmethod
    def typeName() -> java.lang.String: ...
    class : ...

class Inputs:
    _addCost_0__R = typing.TypeVar('_addCost_0__R')  # <R>
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType, block: scala.Function0[_addCost_0__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addCost_0__R: ...
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.FixedCost, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    _addSeqCost__R = typing.TypeVar('_addSeqCost__R')  # <R>
    @staticmethod
    def addSeqCost(costKind: sigmastate.PerItemCost, nItems: int, block: scala.Function0[_addSeqCost__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addSeqCost__R: ...
    @staticmethod
    def addSeqCostNoOp(costKind: sigmastate.PerItemCost, nItems: int, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def companion() -> 'Inputs.': ...
    @staticmethod
    def costKind() -> sigmastate.FixedCost: ...
    _evalTo__T = typing.TypeVar('_evalTo__T')  # <T>
    @staticmethod
    def evalTo(env: scala.collection.immutable.Map[typing.Any, typing.Any], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _evalTo__T: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def init() -> None: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.interpreter.CompanionDesc: ...
    @staticmethod
    def opName() -> java.lang.String: ...
    @staticmethod
    def opType() -> sigmastate.SFunc: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def sourceContext() -> sigmastate.lang.SourceContext: ...
    @staticmethod
    def sourceContext_$eq(srcCtx: sigmastate.lang.SourceContext) -> None: ...
    @staticmethod
    def toString() -> java.lang.String: ...
    @staticmethod
    def tpe() -> sigmastate.SCollection[sigmastate.SBox.]: ...
    @staticmethod
    def typeName() -> java.lang.String: ...
    class : ...

class JsonCodecs:
    @staticmethod
    def $init$($this: 'JsonCodecs') -> None: ...
    def adDigestDecoder(self) -> io.circe.Decoder[typing.List[int]]: ...
    def adDigestEncoder(self) -> io.circe.Encoder[typing.List[int]]: ...
    def adKeyDecoder(self) -> io.circe.Decoder[typing.List[int]]: ...
    def adKeyEncoder(self) -> io.circe.Encoder[typing.List[int]]: ...
    def anyValueDecoder(self) -> io.circe.Decoder[special.sigma.AnyValue]: ...
    def anyValueEncoder(self) -> io.circe.Encoder[special.sigma.AnyValue]: ...
    def arrayBytesDecoder(self) -> io.circe.Decoder[typing.List[int]]: ...
    def arrayBytesEncoder(self) -> io.circe.Encoder[typing.List[int]]: ...
    def assetDecoder(self) -> io.circe.Decoder[scala.Tuple2[typing.List[int], typing.Any]]: ...
    def assetEncoder(self) -> io.circe.Encoder[scala.Tuple2[typing.List[int], typing.Any]]: ...
    def avlTreeDataDecoder(self) -> io.circe.Decoder[sigmastate.AvlTreeData]: ...
    def avlTreeDataEncoder(self) -> io.circe.Encoder[sigmastate.AvlTreeData]: ...
    def collBytesDecoder(self) -> io.circe.Decoder[special.collection.Coll[typing.Any]]: ...
    def collBytesEncoder(self) -> io.circe.Encoder[special.collection.Coll[typing.Any]]: ...
    def contextExtensionDecoder(self) -> io.circe.Decoder[sigmastate.interpreter.ContextExtension]: ...
    def contextExtensionEncoder(self) -> io.circe.Encoder[sigmastate.interpreter.ContextExtension]: ...
    def dataInputDecoder(self) -> io.circe.Decoder[DataInput]: ...
    def dataInputEncoder(self) -> io.circe.Encoder[DataInput]: ...
    _decodeErgoTree__T = typing.TypeVar('_decodeErgoTree__T')  # <T>
    def decodeErgoTree(self, transform: scala.Function1[sigmastate.Values.ErgoTree, _decodeErgoTree__T]) -> io.circe.Decoder[_decodeErgoTree__T]: ...
    _decodeEvaluatedValue__T = typing.TypeVar('_decodeEvaluatedValue__T')  # <T>
    def decodeEvaluatedValue(self, transform: scala.Function1[sigmastate.Values.EvaluatedValue[sigmastate.SType], _decodeEvaluatedValue__T]) -> io.circe.Decoder[_decodeEvaluatedValue__T]: ...
    def digest32Decoder(self) -> io.circe.Decoder[typing.List[int]]: ...
    def digest32Encoder(self) -> io.circe.Encoder[typing.List[int]]: ...
    def ergoBoxDecoder(self) -> io.circe.Decoder['ErgoBox']: ...
    def ergoBoxEncoder(self) -> io.circe.Encoder['ErgoBox']: ...
    def ergoLikeContextDecoder(self) -> io.circe.Decoder[ErgoLikeContext]: ...
    def ergoLikeContextEncoder(self) -> io.circe.Encoder[ErgoLikeContext]: ...
    def ergoLikeTransactionDecoder(self) -> io.circe.Decoder['ErgoLikeTransaction']: ...
    def ergoLikeTransactionEncoder(self) -> io.circe.Encoder['ErgoLikeTransaction']: ...
    def ergoLikeTransactionTemplateDecoder(self) -> io.circe.Decoder[ErgoLikeTransactionTemplate['UnsignedInput']]: ...
    _ergoLikeTransactionTemplateEncoder__T = typing.TypeVar('_ergoLikeTransactionTemplateEncoder__T', bound='UnsignedInput')  # <T>
    def ergoLikeTransactionTemplateEncoder(self) -> io.circe.Encoder[ErgoLikeTransactionTemplate[_ergoLikeTransactionTemplateEncoder__T]]: ...
    def ergoTreeDecoder(self) -> io.circe.Decoder[sigmastate.Values.ErgoTree]: ...
    def ergoTreeEncoder(self) -> io.circe.Encoder[sigmastate.Values.ErgoTree]: ...
    def evaluatedValueDecoder(self) -> io.circe.Decoder[sigmastate.Values.EvaluatedValue[sigmastate.SType]]: ...
    def evaluatedValueEncoder(self) -> io.circe.Encoder[sigmastate.Values.EvaluatedValue[sigmastate.SType]]: ...
    _fromOption__T = typing.TypeVar('_fromOption__T')  # <T>
    def fromOption(self, maybeResult: scala.Option[_fromOption__T], cursor: io.circe.ACursor) -> scala.util.Either[io.circe.DecodingFailure, _fromOption__T]: ...
    _fromThrows__T = typing.TypeVar('_fromThrows__T')  # <T>
    def fromThrows(self, throwsBlock: scala.Function0[_fromThrows__T], cursor: io.circe.ACursor) -> scala.util.Either[io.circe.DecodingFailure, _fromThrows__T]: ...
    _fromTry__T = typing.TypeVar('_fromTry__T')  # <T>
    def fromTry(self, tryResult: scala.util.Try[_fromTry__T], cursor: io.circe.ACursor) -> scala.util.Either[io.circe.DecodingFailure, _fromTry__T]: ...
    def headerDecoder(self) -> io.circe.Decoder[special.sigma.Header]: ...
    def headerEncoder(self) -> io.circe.Encoder[special.sigma.Header]: ...
    def inputDecoder(self) -> io.circe.Decoder['Input']: ...
    def inputEncoder(self) -> io.circe.Encoder['Input']: ...
    def modifierIdDecoder(self) -> io.circe.Decoder[java.lang.String]: ...
    def modifierIdEncoder(self) -> io.circe.Encoder[java.lang.String]: ...
    def org$ergoplatform$JsonCodecs$_setter_$adDigestDecoder_$eq(self, x$1: io.circe.Decoder[typing.List[int]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$adDigestEncoder_$eq(self, x$1: io.circe.Encoder[typing.List[int]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$adKeyDecoder_$eq(self, x$1: io.circe.Decoder[typing.List[int]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$adKeyEncoder_$eq(self, x$1: io.circe.Encoder[typing.List[int]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$anyValueDecoder_$eq(self, x$1: io.circe.Decoder[special.sigma.AnyValue]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$anyValueEncoder_$eq(self, x$1: io.circe.Encoder[special.sigma.AnyValue]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$arrayBytesDecoder_$eq(self, x$1: io.circe.Decoder[typing.List[int]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$arrayBytesEncoder_$eq(self, x$1: io.circe.Encoder[typing.List[int]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$assetDecoder_$eq(self, x$1: io.circe.Decoder[scala.Tuple2[typing.List[int], typing.Any]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$assetEncoder_$eq(self, x$1: io.circe.Encoder[scala.Tuple2[typing.List[int], typing.Any]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$avlTreeDataDecoder_$eq(self, x$1: io.circe.Decoder[sigmastate.AvlTreeData]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$avlTreeDataEncoder_$eq(self, x$1: io.circe.Encoder[sigmastate.AvlTreeData]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$collBytesDecoder_$eq(self, x$1: io.circe.Decoder[special.collection.Coll[typing.Any]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$collBytesEncoder_$eq(self, x$1: io.circe.Encoder[special.collection.Coll[typing.Any]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$contextExtensionDecoder_$eq(self, x$1: io.circe.Decoder[sigmastate.interpreter.ContextExtension]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$contextExtensionEncoder_$eq(self, x$1: io.circe.Encoder[sigmastate.interpreter.ContextExtension]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$dataInputDecoder_$eq(self, x$1: io.circe.Decoder[DataInput]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$dataInputEncoder_$eq(self, x$1: io.circe.Encoder[DataInput]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$digest32Decoder_$eq(self, x$1: io.circe.Decoder[typing.List[int]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$digest32Encoder_$eq(self, x$1: io.circe.Encoder[typing.List[int]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$ergoBoxDecoder_$eq(self, x$1: io.circe.Decoder['ErgoBox']) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$ergoBoxEncoder_$eq(self, x$1: io.circe.Encoder['ErgoBox']) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$ergoLikeContextDecoder_$eq(self, x$1: io.circe.Decoder[ErgoLikeContext]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$ergoLikeContextEncoder_$eq(self, x$1: io.circe.Encoder[ErgoLikeContext]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$ergoLikeTransactionDecoder_$eq(self, x$1: io.circe.Decoder['ErgoLikeTransaction']) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$ergoLikeTransactionEncoder_$eq(self, x$1: io.circe.Encoder['ErgoLikeTransaction']) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$ergoLikeTransactionTemplateDecoder_$eq(self, x$1: io.circe.Decoder[ErgoLikeTransactionTemplate['UnsignedInput']]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$ergoTreeDecoder_$eq(self, x$1: io.circe.Decoder[sigmastate.Values.ErgoTree]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$ergoTreeEncoder_$eq(self, x$1: io.circe.Encoder[sigmastate.Values.ErgoTree]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$evaluatedValueDecoder_$eq(self, x$1: io.circe.Decoder[sigmastate.Values.EvaluatedValue[sigmastate.SType]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$evaluatedValueEncoder_$eq(self, x$1: io.circe.Encoder[sigmastate.Values.EvaluatedValue[sigmastate.SType]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$headerDecoder_$eq(self, x$1: io.circe.Decoder[special.sigma.Header]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$headerEncoder_$eq(self, x$1: io.circe.Encoder[special.sigma.Header]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$inputDecoder_$eq(self, x$1: io.circe.Decoder['Input']) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$inputEncoder_$eq(self, x$1: io.circe.Encoder['Input']) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$modifierIdDecoder_$eq(self, x$1: io.circe.Decoder[typing.Union[java.lang.String, str]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$modifierIdEncoder_$eq(self, x$1: io.circe.Encoder[typing.Union[java.lang.String, str]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$preHeaderDecoder_$eq(self, x$1: io.circe.Decoder[special.sigma.PreHeader]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$preHeaderEncoder_$eq(self, x$1: io.circe.Encoder[special.sigma.PreHeader]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$proverResultDecoder_$eq(self, x$1: io.circe.Decoder[sigmastate.interpreter.ProverResult]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$proverResultEncoder_$eq(self, x$1: io.circe.Encoder[sigmastate.interpreter.ProverResult]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$registerIdDecoder_$eq(self, x$1: io.circe.KeyDecoder['ErgoBox.NonMandatoryRegisterId']) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$registerIdEncoder_$eq(self, x$1: io.circe.KeyEncoder['ErgoBox.NonMandatoryRegisterId']) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$sigmaBigIntDecoder_$eq(self, x$1: io.circe.Decoder[special.sigma.BigInt]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$sigmaBigIntEncoder_$eq(self, x$1: io.circe.Encoder[special.sigma.BigInt]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$sigmaValidationSettingsDecoder_$eq(self, x$1: io.circe.Decoder[org.ergoplatform.validation.SigmaValidationSettings]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$sigmaValidationSettingsEncoder_$eq(self, x$1: io.circe.Encoder[org.ergoplatform.validation.SigmaValidationSettings]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$transactionOutputsDecoder_$eq(self, x$1: io.circe.Decoder[scala.Tuple2['ErgoBoxCandidate', scala.Option[typing.List[int]]]]) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$unsignedErgoLikeTransactionDecoder_$eq(self, x$1: io.circe.Decoder['UnsignedErgoLikeTransaction']) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$unsignedErgoLikeTransactionEncoder_$eq(self, x$1: io.circe.Encoder['UnsignedErgoLikeTransaction']) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$unsignedInputDecoder_$eq(self, x$1: io.circe.Decoder['UnsignedInput']) -> None: ...
    def org$ergoplatform$JsonCodecs$_setter_$unsignedInputEncoder_$eq(self, x$1: io.circe.Encoder['UnsignedInput']) -> None: ...
    def preHeaderDecoder(self) -> io.circe.Decoder[special.sigma.PreHeader]: ...
    def preHeaderEncoder(self) -> io.circe.Encoder[special.sigma.PreHeader]: ...
    def proverResultDecoder(self) -> io.circe.Decoder[sigmastate.interpreter.ProverResult]: ...
    def proverResultEncoder(self) -> io.circe.Encoder[sigmastate.interpreter.ProverResult]: ...
    def registerIdDecoder(self) -> io.circe.KeyDecoder['ErgoBox.NonMandatoryRegisterId']: ...
    def registerIdEncoder(self) -> io.circe.KeyEncoder['ErgoBox.NonMandatoryRegisterId']: ...
    _registersEncoder__T = typing.TypeVar('_registersEncoder__T', bound=sigmastate.Values.EvaluatedValue)  # <T>
    def registersEncoder(self) -> io.circe.Encoder[scala.collection.immutable.Map['ErgoBox.NonMandatoryRegisterId', _registersEncoder__T]]: ...
    def sigmaBigIntDecoder(self) -> io.circe.Decoder[special.sigma.BigInt]: ...
    def sigmaBigIntEncoder(self) -> io.circe.Encoder[special.sigma.BigInt]: ...
    def sigmaValidationSettingsDecoder(self) -> io.circe.Decoder[org.ergoplatform.validation.SigmaValidationSettings]: ...
    def sigmaValidationSettingsEncoder(self) -> io.circe.Encoder[org.ergoplatform.validation.SigmaValidationSettings]: ...
    def transactionOutputsDecoder(self) -> io.circe.Decoder[scala.Tuple2['ErgoBoxCandidate', scala.Option[typing.List[int]]]]: ...
    def unsignedErgoLikeTransactionDecoder(self) -> io.circe.Decoder['UnsignedErgoLikeTransaction']: ...
    def unsignedErgoLikeTransactionEncoder(self) -> io.circe.Encoder['UnsignedErgoLikeTransaction']: ...
    def unsignedInputDecoder(self) -> io.circe.Decoder['UnsignedInput']: ...
    def unsignedInputEncoder(self) -> io.circe.Encoder['UnsignedInput']: ...

class LastBlockUtxoRootHash:
    _addCost_0__R = typing.TypeVar('_addCost_0__R')  # <R>
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType, block: scala.Function0[_addCost_0__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addCost_0__R: ...
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.FixedCost, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    _addSeqCost__R = typing.TypeVar('_addSeqCost__R')  # <R>
    @staticmethod
    def addSeqCost(costKind: sigmastate.PerItemCost, nItems: int, block: scala.Function0[_addSeqCost__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addSeqCost__R: ...
    @staticmethod
    def addSeqCostNoOp(costKind: sigmastate.PerItemCost, nItems: int, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def companion() -> 'LastBlockUtxoRootHash.': ...
    @staticmethod
    def costKind() -> sigmastate.FixedCost: ...
    _evalTo__T = typing.TypeVar('_evalTo__T')  # <T>
    @staticmethod
    def evalTo(env: scala.collection.immutable.Map[typing.Any, typing.Any], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _evalTo__T: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def init() -> None: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.interpreter.CompanionDesc: ...
    @staticmethod
    def opName() -> java.lang.String: ...
    @staticmethod
    def opType() -> sigmastate.SFunc: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def sourceContext() -> sigmastate.lang.SourceContext: ...
    @staticmethod
    def sourceContext_$eq(srcCtx: sigmastate.lang.SourceContext) -> None: ...
    @staticmethod
    def toString() -> java.lang.String: ...
    @staticmethod
    def tpe() -> sigmastate.SAvlTree.: ...
    @staticmethod
    def typeName() -> java.lang.String: ...
    class : ...

class MinerPubkey:
    _addCost_0__R = typing.TypeVar('_addCost_0__R')  # <R>
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType, block: scala.Function0[_addCost_0__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addCost_0__R: ...
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.FixedCost, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    _addSeqCost__R = typing.TypeVar('_addSeqCost__R')  # <R>
    @staticmethod
    def addSeqCost(costKind: sigmastate.PerItemCost, nItems: int, block: scala.Function0[_addSeqCost__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addSeqCost__R: ...
    @staticmethod
    def addSeqCostNoOp(costKind: sigmastate.PerItemCost, nItems: int, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def companion() -> 'MinerPubkey.': ...
    @staticmethod
    def costKind() -> sigmastate.FixedCost: ...
    _evalTo__T = typing.TypeVar('_evalTo__T')  # <T>
    @staticmethod
    def evalTo(env: scala.collection.immutable.Map[typing.Any, typing.Any], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _evalTo__T: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def init() -> None: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.interpreter.CompanionDesc: ...
    @staticmethod
    def opName() -> java.lang.String: ...
    @staticmethod
    def opType() -> sigmastate.SFunc: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def sourceContext() -> sigmastate.lang.SourceContext: ...
    @staticmethod
    def sourceContext_$eq(srcCtx: sigmastate.lang.SourceContext) -> None: ...
    @staticmethod
    def toString() -> java.lang.String: ...
    @staticmethod
    def tpe() -> sigmastate.SCollection[sigmastate.SByte.]: ...
    @staticmethod
    def typeName() -> java.lang.String: ...
    class : ...

class Outputs:
    _addCost_0__R = typing.TypeVar('_addCost_0__R')  # <R>
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType, block: scala.Function0[_addCost_0__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addCost_0__R: ...
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.FixedCost, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    _addSeqCost__R = typing.TypeVar('_addSeqCost__R')  # <R>
    @staticmethod
    def addSeqCost(costKind: sigmastate.PerItemCost, nItems: int, block: scala.Function0[_addSeqCost__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addSeqCost__R: ...
    @staticmethod
    def addSeqCostNoOp(costKind: sigmastate.PerItemCost, nItems: int, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def companion() -> 'Outputs.': ...
    @staticmethod
    def costKind() -> sigmastate.FixedCost: ...
    _evalTo__T = typing.TypeVar('_evalTo__T')  # <T>
    @staticmethod
    def evalTo(env: scala.collection.immutable.Map[typing.Any, typing.Any], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _evalTo__T: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def init() -> None: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.interpreter.CompanionDesc: ...
    @staticmethod
    def opName() -> java.lang.String: ...
    @staticmethod
    def opType() -> sigmastate.SFunc: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def sourceContext() -> sigmastate.lang.SourceContext: ...
    @staticmethod
    def sourceContext_$eq(srcCtx: sigmastate.lang.SourceContext) -> None: ...
    @staticmethod
    def toString() -> java.lang.String: ...
    @staticmethod
    def tpe() -> sigmastate.SCollection[sigmastate.SBox.]: ...
    @staticmethod
    def typeName() -> java.lang.String: ...
    class : ...

class Self:
    _addCost_0__R = typing.TypeVar('_addCost_0__R')  # <R>
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.TypeBasedCost, tpe: sigmastate.SType, block: scala.Function0[_addCost_0__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addCost_0__R: ...
    @typing.overload
    @staticmethod
    def addCost(costKind: sigmastate.FixedCost, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    _addSeqCost__R = typing.TypeVar('_addSeqCost__R')  # <R>
    @staticmethod
    def addSeqCost(costKind: sigmastate.PerItemCost, nItems: int, block: scala.Function0[_addSeqCost__R], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _addSeqCost__R: ...
    @staticmethod
    def addSeqCostNoOp(costKind: sigmastate.PerItemCost, nItems: int, E: sigmastate.interpreter.ErgoTreeEvaluator) -> None: ...
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def companion() -> 'Self.': ...
    @staticmethod
    def costKind() -> sigmastate.FixedCost: ...
    _evalTo__T = typing.TypeVar('_evalTo__T')  # <T>
    @staticmethod
    def evalTo(env: scala.collection.immutable.Map[typing.Any, typing.Any], E: sigmastate.interpreter.ErgoTreeEvaluator) -> _evalTo__T: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def init() -> None: ...
    @staticmethod
    def opCode() -> int: ...
    @staticmethod
    def opDesc() -> sigmastate.interpreter.CompanionDesc: ...
    @staticmethod
    def opName() -> java.lang.String: ...
    @staticmethod
    def opType() -> sigmastate.SFunc: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def sourceContext() -> sigmastate.lang.SourceContext: ...
    @staticmethod
    def sourceContext_$eq(srcCtx: sigmastate.lang.SourceContext) -> None: ...
    @staticmethod
    def toString() -> java.lang.String: ...
    @staticmethod
    def tpe() -> sigmastate.SBox.: ...
    @staticmethod
    def typeName() -> java.lang.String: ...
    class : ...

_SizeConstant__T = typing.TypeVar('_SizeConstant__T')  # <T>
class SizeConstant(scala.Product, scala.Serializable, typing.Generic[_SizeConstant__T]):
    def __init__(self, value: _SizeConstant__T, id: int, description: typing.Union[java.lang.String, str], evidence$1: scala.math.Numeric[_SizeConstant__T]): ...
    _apply__T = typing.TypeVar('_apply__T')  # <T>
    @staticmethod
    def apply(value: _apply__T, id: int, description: typing.Union[java.lang.String, str], evidence$1: scala.math.Numeric[_apply__T]) -> 'SizeConstant'[_apply__T]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _copy__T = typing.TypeVar('_copy__T')  # <T>
    def copy(self, value: typing.Any, id: int, description: typing.Union[java.lang.String, str], evidence$1: scala.math.Numeric[typing.Any]) -> 'SizeConstant'[typing.Any]: ...
    _copy$default$1__T = typing.TypeVar('_copy$default$1__T')  # <T>
    def copy$default$1(self) -> typing.Any: ...
    _copy$default$2__T = typing.TypeVar('_copy$default$2__T')  # <T>
    def copy$default$2(self) -> int: ...
    _copy$default$3__T = typing.TypeVar('_copy$default$3__T')  # <T>
    def copy$default$3(self) -> java.lang.String: ...
    def description(self) -> java.lang.String: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def id(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    _unapply__T = typing.TypeVar('_unapply__T')  # <T>
    @staticmethod
    def unapply(x$0: 'SizeConstant'[_unapply__T]) -> scala.Option[scala.Tuple3[_unapply__T, typing.Any, java.lang.String]]: ...
    def value(self) -> _SizeConstant__T: ...

class UnsignedInput:
    @typing.overload
    def __init__(self, boxId: typing.List[int]): ...
    @typing.overload
    def __init__(self, boxId: typing.List[int], extension: sigmastate.interpreter.ContextExtension): ...
    def boxId(self) -> typing.List[int]: ...
    def equals(self, obj: typing.Any) -> bool: ...
    def extension(self) -> sigmastate.interpreter.ContextExtension: ...
    def hashCode(self) -> int: ...
    def inputToSign(self) -> 'Input': ...

class ErgoBoxAssetsHolder(ErgoBoxAssets, scala.Product, scala.Serializable):
    def __init__(self, value: int, tokens: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any]): ...
    @typing.overload
    @staticmethod
    def apply(value: int) -> 'ErgoBoxAssetsHolder': ...
    @typing.overload
    @staticmethod
    def apply(value: int, tokens: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any]) -> 'ErgoBoxAssetsHolder': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, value: int, tokens: scala.collection.immutable.Map[typing.Union[java.lang.String, str], typing.Any]) -> 'ErgoBoxAssetsHolder': ...
    def copy$default$1(self) -> int: ...
    def copy$default$2(self) -> scala.collection.immutable.Map[java.lang.String, typing.Any]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    def tokens(self) -> scala.collection.immutable.Map[java.lang.String, typing.Any]: ...
    @staticmethod
    def unapply(x$0: 'ErgoBoxAssetsHolder') -> scala.Option[scala.Tuple2[typing.Any, scala.collection.immutable.Map[java.lang.String, typing.Any]]]: ...
    def value(self) -> int: ...

class ErgoBoxCandidate(ErgoBoxAssets):
    def __init__(self, value: int, ergoTree: sigmastate.Values.ErgoTree, creationHeight: int, additionalTokens: special.collection.Coll[scala.Tuple2[typing.List[int], typing.Any]], additionalRegisters: scala.collection.immutable.Map['ErgoBox.NonMandatoryRegisterId', sigmastate.Values.EvaluatedValue[sigmastate.SType]]): ...
    @staticmethod
    def $lessinit$greater$default$4() -> special.collection.Coll[scala.Tuple2[typing.List[int], typing.Any]]: ...
    @staticmethod
    def $lessinit$greater$default$5() -> scala.collection.immutable.Map['ErgoBox.NonMandatoryRegisterId', sigmastate.Values.EvaluatedValue[sigmastate.SType]]: ...
    @staticmethod
    def UndefinedBoxRef() -> special.collection.Coll[typing.Any]: ...
    def additionalRegisters(self) -> scala.collection.immutable.Map['ErgoBox.NonMandatoryRegisterId', sigmastate.Values.EvaluatedValue[sigmastate.SType]]: ...
    def additionalTokens(self) -> special.collection.Coll[scala.Tuple2[typing.List[int], typing.Any]]: ...
    def bytesWithNoRef(self) -> typing.List[int]: ...
    def creationHeight(self) -> int: ...
    def equals(self, arg: typing.Any) -> bool: ...
    def ergoTree(self) -> sigmastate.Values.ErgoTree: ...
    def get(self, identifier: 'ErgoBox.RegisterId') -> scala.Option[sigmastate.Values.Value[sigmastate.SType]]: ...
    def hashCode(self) -> int: ...
    def proposition(self) -> sigmastate.Values.Value[sigmastate.SSigmaProp.]: ...
    def propositionBytes(self) -> typing.List[int]: ...
    def toBox(self, txId: typing.Union[java.lang.String, str], boxIndex: int) -> 'ErgoBox': ...
    def toString(self) -> java.lang.String: ...
    def tokens(self) -> scala.collection.immutable.Map[java.lang.String, typing.Any]: ...
    def value(self) -> int: ...
    class serializer$(sigmastate.serialization.SigmaSerializer['ErgoBoxCandidate', 'ErgoBoxCandidate']):
        MODULE$: typing.ClassVar['ErgoBoxCandidate.serializer.'] = ...
        def __init__(self): ...
        def parse(self, r: sigmastate.utils.SigmaByteReader) -> 'ErgoBoxCandidate': ...
        def parseBodyWithIndexedDigests(self, digestsInTx: typing.List[typing.List[int]], r: sigmastate.utils.SigmaByteReader) -> 'ErgoBoxCandidate': ...
        def serialize(self, obj: 'ErgoBoxCandidate', w: sigmastate.utils.SigmaByteWriter) -> None: ...
        def serializeBodyWithIndexedDigests(self, box: 'ErgoBoxCandidate', tokensInTx: scala.Option[special.collection.Coll[typing.List[int]]], w: sigmastate.utils.SigmaByteWriter) -> None: ...

class ErgoLikeTransaction(ErgoLikeTransactionTemplate['Input']):
    def __init__(self, inputs: scala.collection.IndexedSeq['Input'], dataInputs: scala.collection.IndexedSeq[DataInput], outputCandidates: scala.collection.IndexedSeq[ErgoBoxCandidate]): ...
    @staticmethod
    def TransactionIdBytesSize() -> int: ...
    @staticmethod
    def apply(inputs: scala.collection.IndexedSeq['Input'], outputCandidates: scala.collection.IndexedSeq[ErgoBoxCandidate]) -> 'ErgoLikeTransaction': ...
    _bytesToSign__IT = typing.TypeVar('_bytesToSign__IT', bound=UnsignedInput)  # <IT>
    @staticmethod
    def bytesToSign(tx: ErgoLikeTransactionTemplate[_bytesToSign__IT]) -> typing.List[int]: ...
    def dataInputs(self) -> scala.collection.IndexedSeq[DataInput]: ...
    def equals(self, obj: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def id(self) -> java.lang.String: ...
    def inputIds(self) -> scala.collection.IndexedSeq[typing.List[int]]: ...
    def inputs(self) -> scala.collection.IndexedSeq['Input']: ...
    def messageToSign(self) -> typing.List[int]: ...
    def outputCandidates(self) -> scala.collection.IndexedSeq[ErgoBoxCandidate]: ...
    def outputs(self) -> scala.collection.IndexedSeq['ErgoBox']: ...
    @staticmethod
    def serializer() -> sigmastate.serialization.SigmaSerializer['ErgoLikeTransaction', 'ErgoLikeTransaction']: ...
    def toString(self) -> java.lang.String: ...

class Input(UnsignedInput, scala.Product, scala.Serializable):
    def __init__(self, boxId: typing.List[int], spendingProof: sigmastate.interpreter.ProverResult): ...
    @staticmethod
    def apply(boxId: typing.List[int], spendingProof: sigmastate.interpreter.ProverResult) -> 'Input': ...
    def boxId(self) -> typing.List[int]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, boxId: typing.List[int], spendingProof: sigmastate.interpreter.ProverResult) -> 'Input': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> sigmastate.interpreter.ProverResult: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def spendingProof(self) -> sigmastate.interpreter.ProverResult: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'Input') -> scala.Option[scala.Tuple2[typing.List[int], sigmastate.interpreter.ProverResult]]: ...
    class serializer$(sigmastate.serialization.SigmaSerializer['Input', 'Input']):
        MODULE$: typing.ClassVar['Input.serializer.'] = ...
        def __init__(self): ...
        def parse(self, r: sigmastate.utils.SigmaByteReader) -> 'Input': ...
        def serialize(self, obj: 'Input', w: sigmastate.utils.SigmaByteWriter) -> None: ...

class P2PKAddress(ErgoAddress):
    def __init__(self, pubkey: sigmastate.basics.DLogProtocol.ProveDlog, pubkeyBytes: typing.List[int], encoder: ErgoAddressEncoder): ...
    def addressTypePrefix(self) -> int: ...
    @staticmethod
    def apply(pubkey: sigmastate.basics.DLogProtocol.ProveDlog, encoder: ErgoAddressEncoder) -> 'P2PKAddress': ...
    def contentBytes(self) -> typing.List[int]: ...
    def encoder(self) -> ErgoAddressEncoder: ...
    def equals(self, obj: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def networkPrefix(self) -> int: ...
    def pubkey(self) -> sigmastate.basics.DLogProtocol.ProveDlog: ...
    def pubkeyBytes(self) -> typing.List[int]: ...
    def script(self) -> sigmastate.Values.ErgoTree: ...
    def toString(self) -> java.lang.String: ...

class Pay2SAddress(ErgoAddress):
    def __init__(self, script: sigmastate.Values.ErgoTree, scriptBytes: typing.List[int], encoder: ErgoAddressEncoder): ...
    def addressTypePrefix(self) -> int: ...
    @staticmethod
    def apply(script: sigmastate.Values.ErgoTree, encoder: ErgoAddressEncoder) -> 'Pay2SAddress': ...
    def contentBytes(self) -> typing.List[int]: ...
    def encoder(self) -> ErgoAddressEncoder: ...
    def equals(self, obj: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def networkPrefix(self) -> int: ...
    def script(self) -> sigmastate.Values.ErgoTree: ...
    def scriptBytes(self) -> typing.List[int]: ...
    def toString(self) -> java.lang.String: ...

class Pay2SHAddress(ErgoAddress):
    def __init__(self, scriptHash: typing.List[int], encoder: ErgoAddressEncoder): ...
    def addressTypePrefix(self) -> int: ...
    @typing.overload
    @staticmethod
    def apply(script: sigmastate.Values.ErgoTree, encoder: ErgoAddressEncoder) -> 'Pay2SHAddress': ...
    @typing.overload
    @staticmethod
    def apply(prop: sigmastate.Values.Value[sigmastate.SSigmaProp.], encoder: ErgoAddressEncoder) -> 'Pay2SHAddress': ...
    def contentBytes(self) -> typing.List[int]: ...
    def encoder(self) -> ErgoAddressEncoder: ...
    def equals(self, obj: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def networkPrefix(self) -> int: ...
    def script(self) -> sigmastate.Values.ErgoTree: ...
    def scriptHash(self) -> typing.List[int]: ...
    @staticmethod
    def scriptId() -> int: ...
    def toString(self) -> java.lang.String: ...

class SigmaConstants:
    @staticmethod
    def ConstTable() -> scala.collection.Seq[SizeConstant[typing.Any]]: ...
    class AutolykosPowSolutionNonceArraySize$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.AutolykosPowSolutionNonceArraySize.'] = ...
        def __init__(self): ...
    class MaxBigIntSizeInBytes$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxBigIntSizeInBytes.'] = ...
        def __init__(self): ...
    class MaxBoxSize$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxBoxSize.'] = ...
        def __init__(self): ...
    class MaxBoxSizeWithoutRefs$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxBoxSizeWithoutRefs.'] = ...
        def __init__(self): ...
    class MaxChildrenCountForAtLeastOp$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxChildrenCountForAtLeastOp.'] = ...
        def __init__(self): ...
    class MaxHeaders$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxHeaders.'] = ...
        def __init__(self): ...
    class MaxLoopLevelInCostFunction$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxLoopLevelInCostFunction.'] = ...
        def __init__(self): ...
    class MaxPropositionBytes$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxPropositionBytes.'] = ...
        def __init__(self): ...
    class MaxRegisters$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxRegisters.'] = ...
        def __init__(self): ...
    class MaxSigmaPropSizeInBytes$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxSigmaPropSizeInBytes.'] = ...
        def __init__(self): ...
    class MaxTokens$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxTokens.'] = ...
        def __init__(self): ...
    class MaxTreeDepth$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxTreeDepth.'] = ...
        def __init__(self): ...
    class MaxTupleLength$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.MaxTupleLength.'] = ...
        def __init__(self): ...
    class ScriptCostLimit$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.ScriptCostLimit.'] = ...
        def __init__(self): ...
    class VotesArraySize$(SizeConstant[typing.Any]):
        MODULE$: typing.ClassVar['SigmaConstants.VotesArraySize.'] = ...
        def __init__(self): ...

class UnsignedErgoLikeTransaction(ErgoLikeTransactionTemplate[UnsignedInput]):
    def __init__(self, inputs: scala.collection.IndexedSeq[UnsignedInput], dataInputs: scala.collection.IndexedSeq[DataInput], outputCandidates: scala.collection.IndexedSeq[ErgoBoxCandidate]): ...
    @typing.overload
    @staticmethod
    def apply(inputs: scala.collection.IndexedSeq[UnsignedInput], outputCandidates: scala.collection.IndexedSeq[ErgoBoxCandidate]) -> 'UnsignedErgoLikeTransaction': ...
    @typing.overload
    @staticmethod
    def apply(inputs: scala.collection.IndexedSeq[UnsignedInput], dataInputs: scala.collection.IndexedSeq[DataInput], outputCandidates: scala.collection.IndexedSeq[ErgoBoxCandidate]) -> 'UnsignedErgoLikeTransaction': ...
    def dataInputs(self) -> scala.collection.IndexedSeq[DataInput]: ...
    def equals(self, obj: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def id(self) -> java.lang.String: ...
    def inputIds(self) -> scala.collection.IndexedSeq[typing.List[int]]: ...
    def inputs(self) -> scala.collection.IndexedSeq[UnsignedInput]: ...
    def messageToSign(self) -> typing.List[int]: ...
    def outputCandidates(self) -> scala.collection.IndexedSeq[ErgoBoxCandidate]: ...
    def outputs(self) -> scala.collection.IndexedSeq['ErgoBox']: ...
    def toSigned(self, proofs: scala.collection.IndexedSeq[sigmastate.interpreter.ProverResult]) -> ErgoLikeTransaction: ...
    def toString(self) -> java.lang.String: ...

class ErgoBox(ErgoBoxCandidate):
    def __init__(self, value: int, ergoTree: sigmastate.Values.ErgoTree, additionalTokens: special.collection.Coll[scala.Tuple2[typing.List[int], typing.Any]], additionalRegisters: scala.collection.immutable.Map['ErgoBox.NonMandatoryRegisterId', sigmastate.Values.EvaluatedValue[sigmastate.SType]], transactionId: typing.Union[java.lang.String, str], index: int, creationHeight: int): ...
    @staticmethod
    def $lessinit$greater$default$3() -> special.collection.Coll[scala.Tuple2[typing.List[int], typing.Any]]: ...
    @typing.overload
    @staticmethod
    def $lessinit$greater$default$4() -> scala.collection.immutable.Map['ErgoBox.NonMandatoryRegisterId', sigmastate.Values.EvaluatedValue[sigmastate.SType]]: ...
    @typing.overload
    @staticmethod
    def $lessinit$greater$default$4() -> special.collection.Coll[scala.Tuple2[typing.List[int], typing.Any]]: ...
    @staticmethod
    def MaxBoxSize() -> int: ...
    @staticmethod
    def MaxTokens() -> int: ...
    @staticmethod
    def ReferenceRegId() -> 'ErgoBox.MandatoryRegisterId': ...
    @staticmethod
    def SReferenceRegType() -> sigmastate.STuple: ...
    @staticmethod
    def STokenType() -> sigmastate.STuple: ...
    @staticmethod
    def STokensRegType() -> sigmastate.SCollection[sigmastate.STuple]: ...
    @staticmethod
    def ScriptRegId() -> 'ErgoBox.MandatoryRegisterId': ...
    @staticmethod
    def TokensRegId() -> 'ErgoBox.MandatoryRegisterId': ...
    @staticmethod
    def ValueRegId() -> 'ErgoBox.MandatoryRegisterId': ...
    def additionalRegisters(self) -> scala.collection.immutable.Map['ErgoBox.NonMandatoryRegisterId', sigmastate.Values.EvaluatedValue[sigmastate.SType]]: ...
    def additionalTokens(self) -> special.collection.Coll[scala.Tuple2[typing.List[int], typing.Any]]: ...
    @staticmethod
    def allRegisters() -> scala.collection.Seq['ErgoBox.RegisterId']: ...
    @staticmethod
    def allZerosModifierId() -> java.lang.String: ...
    def bytes(self) -> typing.List[int]: ...
    def creationHeight(self) -> int: ...
    def equals(self, arg: typing.Any) -> bool: ...
    def ergoTree(self) -> sigmastate.Values.ErgoTree: ...
    @staticmethod
    def findRegisterByIndex(i: int) -> scala.Option['ErgoBox.RegisterId']: ...
    def get(self, identifier: 'ErgoBox.RegisterId') -> scala.Option[sigmastate.Values.Value[sigmastate.SType]]: ...
    def hashCode(self) -> int: ...
    def id(self) -> typing.List[int]: ...
    def index(self) -> int: ...
    @staticmethod
    def mandatoryRegisters() -> scala.collection.Seq['ErgoBox.MandatoryRegisterId']: ...
    @staticmethod
    def mandatoryRegistersCount() -> int: ...
    @staticmethod
    def maxRegisters() -> int: ...
    @staticmethod
    def nonMandatoryRegisters() -> scala.collection.Seq['ErgoBox.NonMandatoryRegisterId']: ...
    @staticmethod
    def nonMandatoryRegistersCount() -> int: ...
    @staticmethod
    def registerByIndex(index: int) -> 'ErgoBox.RegisterId': ...
    @staticmethod
    def registerByName() -> scala.collection.immutable.Map[java.lang.String, 'ErgoBox.RegisterId']: ...
    @staticmethod
    def startingNonMandatoryIndex() -> int: ...
    def toCandidate(self) -> ErgoBoxCandidate: ...
    def toString(self) -> java.lang.String: ...
    def transactionId(self) -> java.lang.String: ...
    def value(self) -> int: ...
    class BoxId$:
        MODULE$: typing.ClassVar['ErgoBox.BoxId.'] = ...
        def __init__(self): ...
        def size(self) -> int: ...
    class MandatoryRegisterId(org.ergoplatform.ErgoBox.RegisterId):
        def __init__(self, number: int, purpose: typing.Union[java.lang.String, str]): ...
        def asIndex(self) -> int: ...
        def number(self) -> int: ...
        def purpose(self) -> java.lang.String: ...
        def toString(self) -> java.lang.String: ...
    class NonMandatoryRegisterId(org.ergoplatform.ErgoBox.RegisterId):
        def __init__(self, number: int): ...
        def asIndex(self) -> int: ...
        def number(self) -> int: ...
        def toString(self) -> java.lang.String: ...
    class R0$(org.ergoplatform.ErgoBox.MandatoryRegisterId):
        MODULE$: typing.ClassVar['ErgoBox.R0.'] = ...
        def __init__(self): ...
    class R1$(org.ergoplatform.ErgoBox.MandatoryRegisterId):
        MODULE$: typing.ClassVar['ErgoBox.R1.'] = ...
        def __init__(self): ...
    class R2$(org.ergoplatform.ErgoBox.MandatoryRegisterId):
        MODULE$: typing.ClassVar['ErgoBox.R2.'] = ...
        def __init__(self): ...
    class R3$(org.ergoplatform.ErgoBox.MandatoryRegisterId):
        MODULE$: typing.ClassVar['ErgoBox.R3.'] = ...
        def __init__(self): ...
    class R4$(org.ergoplatform.ErgoBox.NonMandatoryRegisterId):
        MODULE$: typing.ClassVar['ErgoBox.R4.'] = ...
        def __init__(self): ...
    class R5$(org.ergoplatform.ErgoBox.NonMandatoryRegisterId):
        MODULE$: typing.ClassVar['ErgoBox.R5.'] = ...
        def __init__(self): ...
    class R6$(org.ergoplatform.ErgoBox.NonMandatoryRegisterId):
        MODULE$: typing.ClassVar['ErgoBox.R6.'] = ...
        def __init__(self): ...
    class R7$(org.ergoplatform.ErgoBox.NonMandatoryRegisterId):
        MODULE$: typing.ClassVar['ErgoBox.R7.'] = ...
        def __init__(self): ...
    class R8$(org.ergoplatform.ErgoBox.NonMandatoryRegisterId):
        MODULE$: typing.ClassVar['ErgoBox.R8.'] = ...
        def __init__(self): ...
    class R9$(org.ergoplatform.ErgoBox.NonMandatoryRegisterId):
        MODULE$: typing.ClassVar['ErgoBox.R9.'] = ...
        def __init__(self): ...
    class RegisterId:
        @staticmethod
        def $init$($this: 'ErgoBox.RegisterId') -> None: ...
        def asIndex(self) -> int: ...
        def number(self) -> int: ...
        def toString(self) -> java.lang.String: ...
    class TokenId$:
        MODULE$: typing.ClassVar['ErgoBox.TokenId.'] = ...
        def __init__(self): ...
        def size(self) -> int: ...
    class sigmaSerializer$(sigmastate.serialization.SigmaSerializer['ErgoBox', 'ErgoBox']):
        MODULE$: typing.ClassVar['ErgoBox.sigmaSerializer.'] = ...
        def __init__(self): ...
        def parse(self, r: sigmastate.utils.SigmaByteReader) -> 'ErgoBox': ...
        def serialize(self, obj: 'ErgoBox', w: sigmastate.utils.SigmaByteWriter) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.ergoplatform")``.

    Context: typing.Type[Context]
    DataInput: typing.Type[DataInput]
    ErgoAddress: typing.Type[ErgoAddress]
    ErgoAddressEncoder: typing.Type[ErgoAddressEncoder]
    ErgoBox: typing.Type[ErgoBox]
    ErgoBoxAssets: typing.Type[ErgoBoxAssets]
    ErgoBoxAssetsHolder: typing.Type[ErgoBoxAssetsHolder]
    ErgoBoxCandidate: typing.Type[ErgoBoxCandidate]
    ErgoBoxReader: typing.Type[ErgoBoxReader]
    ErgoLikeContext: typing.Type[ErgoLikeContext]
    ErgoLikeInterpreter: typing.Type[ErgoLikeInterpreter]
    ErgoLikeTransaction: typing.Type[ErgoLikeTransaction]
    ErgoLikeTransactionSerializer: typing.Type[ErgoLikeTransactionSerializer]
    ErgoLikeTransactionTemplate: typing.Type[ErgoLikeTransactionTemplate]
    ErgoScriptPredef: typing.Type[ErgoScriptPredef]
    Global: typing.Type[Global]
    Height: typing.Type[Height]
    Input: typing.Type[Input]
    Inputs: typing.Type[Inputs]
    JsonCodecs: typing.Type[JsonCodecs]
    LastBlockUtxoRootHash: typing.Type[LastBlockUtxoRootHash]
    MinerPubkey: typing.Type[MinerPubkey]
    Outputs: typing.Type[Outputs]
    P2PKAddress: typing.Type[P2PKAddress]
    Pay2SAddress: typing.Type[Pay2SAddress]
    Pay2SHAddress: typing.Type[Pay2SHAddress]
    Self: typing.Type[Self]
    SigmaConstants: typing.Type[SigmaConstants]
    SizeConstant: typing.Type[SizeConstant]
    UnsignedErgoLikeTransaction: typing.Type[UnsignedErgoLikeTransaction]
    UnsignedInput: typing.Type[UnsignedInput]
    appkit: org.ergoplatform.appkit.__module_protocol__
    dsl: org.ergoplatform.dsl.__module_protocol__
    explorer: org.ergoplatform.explorer.__module_protocol__
    mining: org.ergoplatform.mining.__module_protocol__
    restapi: org.ergoplatform.restapi.__module_protocol__
    settings: org.ergoplatform.settings.__module_protocol__
    utils: org.ergoplatform.utils.__module_protocol__
    validation: org.ergoplatform.validation.__module_protocol__
    wallet: org.ergoplatform.wallet.__module_protocol__
