import io.circe
import java.lang
import org.ergoplatform
import org.ergoplatform.validation
import scala
import scala.collection.immutable
import scala.util
import sigmastate
import sigmastate.interpreter
import special.collection
import special.sigma
import typing



_ErgoWalletSerializer__T = typing.TypeVar('_ErgoWalletSerializer__T')  # <T>
class ErgoWalletSerializer(typing.Generic[_ErgoWalletSerializer__T]):
    @staticmethod
    def $init$($this: 'ErgoWalletSerializer') -> None: ...
    def parseBytes(self, bytes: typing.List[int]) -> _ErgoWalletSerializer__T: ...
    def parseBytesTry(self, bytes: typing.List[int]) -> scala.util.Try[_ErgoWalletSerializer__T]: ...
    def toBytes(self, obj: _ErgoWalletSerializer__T) -> typing.List[int]: ...

class JsonCodecsWrapper:
    @staticmethod
    def adDigestDecoder() -> io.circe.Decoder[typing.List[int]]: ...
    @staticmethod
    def adDigestEncoder() -> io.circe.Encoder[typing.List[int]]: ...
    @staticmethod
    def adKeyDecoder() -> io.circe.Decoder[typing.List[int]]: ...
    @staticmethod
    def adKeyEncoder() -> io.circe.Encoder[typing.List[int]]: ...
    @staticmethod
    def anyValueDecoder() -> io.circe.Decoder[special.sigma.AnyValue]: ...
    @staticmethod
    def anyValueEncoder() -> io.circe.Encoder[special.sigma.AnyValue]: ...
    @staticmethod
    def arrayBytesDecoder() -> io.circe.Decoder[typing.List[int]]: ...
    @staticmethod
    def arrayBytesEncoder() -> io.circe.Encoder[typing.List[int]]: ...
    @staticmethod
    def assetDecoder() -> io.circe.Decoder[scala.Tuple2[typing.List[int], typing.Any]]: ...
    @staticmethod
    def assetEncoder() -> io.circe.Encoder[scala.Tuple2[typing.List[int], typing.Any]]: ...
    @staticmethod
    def avlTreeDataDecoder() -> io.circe.Decoder[sigmastate.AvlTreeData]: ...
    @staticmethod
    def avlTreeDataEncoder() -> io.circe.Encoder[sigmastate.AvlTreeData]: ...
    @staticmethod
    def collBytesDecoder() -> io.circe.Decoder[special.collection.Coll[typing.Any]]: ...
    @staticmethod
    def collBytesEncoder() -> io.circe.Encoder[special.collection.Coll[typing.Any]]: ...
    @staticmethod
    def contextExtensionDecoder() -> io.circe.Decoder[sigmastate.interpreter.ContextExtension]: ...
    @staticmethod
    def contextExtensionEncoder() -> io.circe.Encoder[sigmastate.interpreter.ContextExtension]: ...
    @staticmethod
    def dataInputDecoder() -> io.circe.Decoder[org.ergoplatform.DataInput]: ...
    @staticmethod
    def dataInputEncoder() -> io.circe.Encoder[org.ergoplatform.DataInput]: ...
    _decodeErgoTree__T = typing.TypeVar('_decodeErgoTree__T')  # <T>
    @staticmethod
    def decodeErgoTree(transform: scala.Function1[sigmastate.Values.ErgoTree, _decodeErgoTree__T]) -> io.circe.Decoder[_decodeErgoTree__T]: ...
    _decodeEvaluatedValue__T = typing.TypeVar('_decodeEvaluatedValue__T')  # <T>
    @staticmethod
    def decodeEvaluatedValue(transform: scala.Function1[sigmastate.Values.EvaluatedValue[sigmastate.SType], _decodeEvaluatedValue__T]) -> io.circe.Decoder[_decodeEvaluatedValue__T]: ...
    @staticmethod
    def digest32Decoder() -> io.circe.Decoder[typing.List[int]]: ...
    @staticmethod
    def digest32Encoder() -> io.circe.Encoder[typing.List[int]]: ...
    @staticmethod
    def ergoBoxDecoder() -> io.circe.Decoder[org.ergoplatform.ErgoBox]: ...
    @staticmethod
    def ergoBoxEncoder() -> io.circe.Encoder[org.ergoplatform.ErgoBox]: ...
    @staticmethod
    def ergoLikeContextDecoder() -> io.circe.Decoder[org.ergoplatform.ErgoLikeContext]: ...
    @staticmethod
    def ergoLikeContextEncoder() -> io.circe.Encoder[org.ergoplatform.ErgoLikeContext]: ...
    @staticmethod
    def ergoLikeTransactionDecoder() -> io.circe.Decoder[org.ergoplatform.ErgoLikeTransaction]: ...
    @staticmethod
    def ergoLikeTransactionEncoder() -> io.circe.Encoder[org.ergoplatform.ErgoLikeTransaction]: ...
    @staticmethod
    def ergoLikeTransactionTemplateDecoder() -> io.circe.Decoder[org.ergoplatform.ErgoLikeTransactionTemplate[org.ergoplatform.UnsignedInput]]: ...
    _ergoLikeTransactionTemplateEncoder__T = typing.TypeVar('_ergoLikeTransactionTemplateEncoder__T', bound=org.ergoplatform.UnsignedInput)  # <T>
    @staticmethod
    def ergoLikeTransactionTemplateEncoder() -> io.circe.Encoder[org.ergoplatform.ErgoLikeTransactionTemplate[_ergoLikeTransactionTemplateEncoder__T]]: ...
    @staticmethod
    def ergoTreeDecoder() -> io.circe.Decoder[sigmastate.Values.ErgoTree]: ...
    @staticmethod
    def ergoTreeEncoder() -> io.circe.Encoder[sigmastate.Values.ErgoTree]: ...
    @staticmethod
    def evaluatedValueDecoder() -> io.circe.Decoder[sigmastate.Values.EvaluatedValue[sigmastate.SType]]: ...
    @staticmethod
    def evaluatedValueEncoder() -> io.circe.Encoder[sigmastate.Values.EvaluatedValue[sigmastate.SType]]: ...
    _fromOption__T = typing.TypeVar('_fromOption__T')  # <T>
    @staticmethod
    def fromOption(maybeResult: scala.Option[_fromOption__T], cursor: io.circe.ACursor) -> scala.util.Either[io.circe.DecodingFailure, _fromOption__T]: ...
    _fromThrows__T = typing.TypeVar('_fromThrows__T')  # <T>
    @staticmethod
    def fromThrows(throwsBlock: scala.Function0[_fromThrows__T], cursor: io.circe.ACursor) -> scala.util.Either[io.circe.DecodingFailure, _fromThrows__T]: ...
    _fromTry__T = typing.TypeVar('_fromTry__T')  # <T>
    @staticmethod
    def fromTry(tryResult: scala.util.Try[_fromTry__T], cursor: io.circe.ACursor) -> scala.util.Either[io.circe.DecodingFailure, _fromTry__T]: ...
    @staticmethod
    def headerDecoder() -> io.circe.Decoder[special.sigma.Header]: ...
    @staticmethod
    def headerEncoder() -> io.circe.Encoder[special.sigma.Header]: ...
    @staticmethod
    def inputDecoder() -> io.circe.Decoder[org.ergoplatform.Input]: ...
    @staticmethod
    def inputEncoder() -> io.circe.Encoder[org.ergoplatform.Input]: ...
    @staticmethod
    def modifierIdDecoder() -> io.circe.Decoder[java.lang.String]: ...
    @staticmethod
    def modifierIdEncoder() -> io.circe.Encoder[java.lang.String]: ...
    @staticmethod
    def preHeaderDecoder() -> io.circe.Decoder[special.sigma.PreHeader]: ...
    @staticmethod
    def preHeaderEncoder() -> io.circe.Encoder[special.sigma.PreHeader]: ...
    @staticmethod
    def proverResultDecoder() -> io.circe.Decoder[sigmastate.interpreter.ProverResult]: ...
    @staticmethod
    def proverResultEncoder() -> io.circe.Encoder[sigmastate.interpreter.ProverResult]: ...
    @staticmethod
    def registerIdDecoder() -> io.circe.KeyDecoder[org.ergoplatform.ErgoBox.NonMandatoryRegisterId]: ...
    @staticmethod
    def registerIdEncoder() -> io.circe.KeyEncoder[org.ergoplatform.ErgoBox.NonMandatoryRegisterId]: ...
    _registersEncoder__T = typing.TypeVar('_registersEncoder__T', bound=sigmastate.Values.EvaluatedValue)  # <T>
    @staticmethod
    def registersEncoder() -> io.circe.Encoder[scala.collection.immutable.Map[org.ergoplatform.ErgoBox.NonMandatoryRegisterId, _registersEncoder__T]]: ...
    @staticmethod
    def sigmaBigIntDecoder() -> io.circe.Decoder[special.sigma.BigInt]: ...
    @staticmethod
    def sigmaBigIntEncoder() -> io.circe.Encoder[special.sigma.BigInt]: ...
    @staticmethod
    def sigmaValidationSettingsDecoder() -> io.circe.Decoder[org.ergoplatform.validation.SigmaValidationSettings]: ...
    @staticmethod
    def sigmaValidationSettingsEncoder() -> io.circe.Encoder[org.ergoplatform.validation.SigmaValidationSettings]: ...
    @staticmethod
    def transactionOutputsDecoder() -> io.circe.Decoder[scala.Tuple2[org.ergoplatform.ErgoBoxCandidate, scala.Option[typing.List[int]]]]: ...
    @staticmethod
    def unsignedErgoLikeTransactionDecoder() -> io.circe.Decoder[org.ergoplatform.UnsignedErgoLikeTransaction]: ...
    @staticmethod
    def unsignedErgoLikeTransactionEncoder() -> io.circe.Encoder[org.ergoplatform.UnsignedErgoLikeTransaction]: ...
    @staticmethod
    def unsignedInputDecoder() -> io.circe.Decoder[org.ergoplatform.UnsignedInput]: ...
    @staticmethod
    def unsignedInputEncoder() -> io.circe.Encoder[org.ergoplatform.UnsignedInput]: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.ergoplatform.wallet.serialization")``.

    ErgoWalletSerializer: typing.Type[ErgoWalletSerializer]
    JsonCodecsWrapper: typing.Type[JsonCodecsWrapper]
