import com.typesafe.scalalogging
import java.lang
import scala
import scala.collection
import scala.collection.immutable
import scala.collection.mutable
import scala.runtime
import scala.util
import scorex.crypto.authds.avltree.batch.serialization
import scorex.crypto.hash
import scorex.util
import scorex.util.encode
import typing



class BatchProofConstants:
    @staticmethod
    def $init$($this: 'BatchProofConstants') -> None: ...
    def EndOfTreeInPackagedProof(self) -> int: ...
    def LabelInPackagedProof(self) -> int: ...
    def LeafInPackagedProof(self) -> int: ...
    def scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$EndOfTreeInPackagedProof_$eq(self, x$1: int) -> None: ...
    def scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LabelInPackagedProof_$eq(self, x$1: int) -> None: ...
    def scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LeafInPackagedProof_$eq(self, x$1: int) -> None: ...

class KeyInVar:
    @staticmethod
    def $init$($this: 'KeyInVar') -> None: ...
    def k(self) -> typing.List[int]: ...
    def k_$eq(self, x$1: typing.List[int]) -> None: ...
    def key(self) -> typing.List[int]: ...

class Operation:
    def key(self) -> typing.List[int]: ...

_PersistentBatchAVLProver__D = typing.TypeVar('_PersistentBatchAVLProver__D', bound=typing.List[int])  # <D>
_PersistentBatchAVLProver__HF = typing.TypeVar('_PersistentBatchAVLProver__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
class PersistentBatchAVLProver(typing.Generic[_PersistentBatchAVLProver__D, _PersistentBatchAVLProver__HF]):
    def __init__(self): ...
    def avlProver(self) -> 'BatchAVLProver'[_PersistentBatchAVLProver__D, _PersistentBatchAVLProver__HF]: ...
    def avlProver_$eq(self, x$1: 'BatchAVLProver'[_PersistentBatchAVLProver__D, _PersistentBatchAVLProver__HF]) -> None: ...
    def checkTree(self, postProof: bool) -> None: ...
    def checkTree$default$1(self) -> bool: ...
    _create_0__D = typing.TypeVar('_create_0__D', bound=typing.List[int])  # <D>
    _create_0__HF = typing.TypeVar('_create_0__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    _create_1__D = typing.TypeVar('_create_1__D', bound=typing.List[int])  # <D>
    _create_1__HF = typing.TypeVar('_create_1__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    _create_1__K = typing.TypeVar('_create_1__K', bound=typing.List[int])  # <K>
    _create_1__V = typing.TypeVar('_create_1__V', bound=typing.List[int])  # <V>
    @typing.overload
    @staticmethod
    def create(avlBatchProver: 'BatchAVLProver'[_create_0__D, _create_0__HF], versionedStorage: 'VersionedAVLStorage'[_create_0__D], paranoidChecks: bool) -> scala.util.Try['PersistentBatchAVLProver'[_create_0__D, _create_0__HF]]: ...
    @typing.overload
    @staticmethod
    def create(avlBatchProver: 'BatchAVLProver'[_create_1__D, _create_1__HF], versionedStorage: 'VersionedAVLStorage'[_create_1__D], additionalData: scala.collection.Seq[scala.Tuple2[_create_1__K, _create_1__V]], paranoidChecks: bool) -> scala.util.Try['PersistentBatchAVLProver'[_create_1__D, _create_1__HF]]: ...
    _create$default$3__D = typing.TypeVar('_create$default$3__D', bound=typing.List[int])  # <D>
    _create$default$3__HF = typing.TypeVar('_create$default$3__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def create$default$3() -> bool: ...
    def digest(self) -> typing.List[int]: ...
    _generateProofAndUpdateStorage_1__K = typing.TypeVar('_generateProofAndUpdateStorage_1__K', bound=typing.List[int])  # <K>
    _generateProofAndUpdateStorage_1__V = typing.TypeVar('_generateProofAndUpdateStorage_1__V', bound=typing.List[int])  # <V>
    @typing.overload
    def generateProofAndUpdateStorage(self) -> typing.List[int]: ...
    @typing.overload
    def generateProofAndUpdateStorage(self, additionalData: scala.collection.Seq[scala.Tuple2[_generateProofAndUpdateStorage_1__K, _generateProofAndUpdateStorage_1__V]]) -> typing.List[int]: ...
    def height(self) -> int: ...
    def performOneOperation(self, operation: Operation) -> scala.util.Try[scala.Option[typing.List[int]]]: ...
    def prover(self) -> 'BatchAVLProver'[_PersistentBatchAVLProver__D, _PersistentBatchAVLProver__HF]: ...
    def rollback(self, version: typing.List[int]) -> scala.util.Try[scala.runtime.BoxedUnit]: ...
    def storage(self) -> 'VersionedAVLStorage'[_PersistentBatchAVLProver__D]: ...
    def unauthenticatedLookup(self, key: typing.List[int]) -> scala.Option[typing.List[int]]: ...

class ToStringHelper(scorex.util.ScorexEncoding):
    @staticmethod
    def $init$($this: 'ToStringHelper') -> None: ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...

class UnknownModification:
    @staticmethod
    def canEqual(x$1: typing.Any) -> bool: ...
    @staticmethod
    def encoder() -> scorex.util.encode.BytesEncoder: ...
    @staticmethod
    def hashCode() -> int: ...
    @staticmethod
    def key() -> typing.List[int]: ...
    @staticmethod
    def productArity() -> int: ...
    @staticmethod
    def productElement(x$1: int) -> typing.Any: ...
    @staticmethod
    def productIterator() -> scala.collection.Iterator[typing.Any]: ...
    @staticmethod
    def productPrefix() -> java.lang.String: ...
    @staticmethod
    def toString() -> java.lang.String: ...
    @staticmethod
    def updateFn() -> scala.Function1[scala.Option[typing.List[int]], scala.util.Try[scala.Option[typing.List[int]]]]: ...

_VersionedAVLStorage__D = typing.TypeVar('_VersionedAVLStorage__D', bound=typing.List[int])  # <D>
class VersionedAVLStorage(typing.Generic[_VersionedAVLStorage__D]):
    @staticmethod
    def $init$($this: 'VersionedAVLStorage') -> None: ...
    def isEmpty(self) -> bool: ...
    def nonEmpty(self) -> bool: ...
    def rollback(self, version: typing.List[int]) -> scala.util.Try[scala.Tuple2['ProverNodes'[_VersionedAVLStorage__D], typing.Any]]: ...
    def rollbackVersions(self) -> scala.collection.Iterable[typing.List[int]]: ...
    _update_0__K = typing.TypeVar('_update_0__K', bound=typing.List[int])  # <K>
    _update_0__V = typing.TypeVar('_update_0__V', bound=typing.List[int])  # <V>
    @typing.overload
    def update(self, batchProver: 'BatchAVLProver'[_VersionedAVLStorage__D, typing.Any], additionalData: scala.collection.Seq[scala.Tuple2[_update_0__K, _update_0__V]]) -> scala.util.Try[scala.runtime.BoxedUnit]: ...
    @typing.overload
    def update(self, batchProver: 'BatchAVLProver'[_VersionedAVLStorage__D, typing.Any]) -> scala.util.Try[scala.runtime.BoxedUnit]: ...
    def version(self) -> scala.Option[typing.List[int]]: ...

_AuthenticatedTreeOps__D = typing.TypeVar('_AuthenticatedTreeOps__D', bound=typing.List[int])  # <D>
class AuthenticatedTreeOps(BatchProofConstants, ToStringHelper, typing.Generic[_AuthenticatedTreeOps__D]):
    @staticmethod
    def $init$($this: 'AuthenticatedTreeOps') -> None: ...
    def NegativeInfinityKey(self) -> typing.List[int]: ...
    def PositiveInfinityKey(self) -> typing.List[int]: ...
    def addNode(self, r: 'Leaf'[_AuthenticatedTreeOps__D], key: typing.List[int], v: typing.List[int]) -> 'InternalNode'[_AuthenticatedTreeOps__D]: ...
    def changedNodesBuffer(self) -> scala.collection.mutable.ArrayBuffer['ProverNodes'[_AuthenticatedTreeOps__D]]: ...
    def changedNodesBufferToCheck(self) -> scala.collection.mutable.ArrayBuffer['ProverNodes'[_AuthenticatedTreeOps__D]]: ...
    def collectChangedNodes(self) -> bool: ...
    def digest(self, rootNode: 'Node'[_AuthenticatedTreeOps__D]) -> typing.List[int]: ...
    def keyLength(self) -> int: ...
    def keyMatchesLeaf(self, key: typing.List[int], r: 'Leaf'[_AuthenticatedTreeOps__D]) -> bool: ...
    def nextDirectionIsLeft(self, key: typing.List[int], r: 'InternalNode'[_AuthenticatedTreeOps__D]) -> bool: ...
    def onNodeVisit(self, n: 'Node'[_AuthenticatedTreeOps__D], operation: Operation, isRotate: bool) -> None: ...
    def onNodeVisit$default$3(self) -> bool: ...
    def replayComparison(self) -> int: ...
    def returnResultOfOneOperation(self, operation: Operation, rootNode: 'Node'[_AuthenticatedTreeOps__D]) -> scala.util.Try[scala.Tuple2['Node'[_AuthenticatedTreeOps__D], scala.Option[typing.List[int]]]]: ...
    def rootNodeHeight(self) -> int: ...
    def rootNodeHeight_$eq(self, x$1: int) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$NegativeInfinityKey_$eq(self, x$1: typing.List[int]) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$PositiveInfinityKey_$eq(self, x$1: typing.List[int]) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$changedNodesBufferToCheck_$eq(self, x$1: scala.collection.mutable.ArrayBuffer['ProverNodes'[_AuthenticatedTreeOps__D]]) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$changedNodesBuffer_$eq(self, x$1: scala.collection.mutable.ArrayBuffer['ProverNodes'[_AuthenticatedTreeOps__D]]) -> None: ...
    def valueLengthOpt(self) -> scala.Option[typing.Any]: ...

class Lookup(Operation, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['Lookup', _andThen__A]) -> scala.Function1[typing.List[int], _andThen__A]: ...
    @staticmethod
    def apply(key: typing.List[int]) -> 'Lookup': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.List[int]]) -> scala.Function1[_compose__A, 'Lookup']: ...
    def copy(self, key: typing.List[int]) -> 'Lookup': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def key(self) -> typing.List[int]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'Lookup') -> scala.Option[typing.List[int]]: ...

class Modification(Operation, scorex.util.ScorexEncoding):
    def key(self) -> typing.List[int]: ...
    def updateFn(self) -> scala.Function1[scala.Option[typing.List[int]], scala.util.Try[scala.Option[typing.List[int]]]]: ...

_Node__D = typing.TypeVar('_Node__D', bound=typing.List[int])  # <D>
class Node(ToStringHelper, typing.Generic[_Node__D]):
    @staticmethod
    def $init$($this: 'Node') -> None: ...
    def computeLabel(self) -> _Node__D: ...
    def label(self) -> _Node__D: ...
    def labelOpt(self) -> scala.Option[_Node__D]: ...
    def labelOpt_$eq(self, x$1: scala.Option[_Node__D]) -> None: ...
    def visited(self) -> bool: ...
    def visited_$eq(self, x$1: bool) -> None: ...

_BatchAVLProver__D = typing.TypeVar('_BatchAVLProver__D', bound=typing.List[int])  # <D>
_BatchAVLProver__HF = typing.TypeVar('_BatchAVLProver__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
class BatchAVLProver(AuthenticatedTreeOps[_BatchAVLProver__D], scorex.util.ScorexLogging, typing.Generic[_BatchAVLProver__D, _BatchAVLProver__HF]):
    def __init__(self, keyLength: int, valueLengthOpt: scala.Option[typing.Any], oldRootAndHeight: scala.Option[scala.Tuple2['ProverNodes'[_BatchAVLProver__D], typing.Any]], collectChangedNodes: bool, hf: _BatchAVLProver__HF): ...
    _$lessinit$greater$default$3__D = typing.TypeVar('_$lessinit$greater$default$3__D', bound=typing.List[int])  # <D>
    _$lessinit$greater$default$3__HF = typing.TypeVar('_$lessinit$greater$default$3__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$3() -> scala.None.: ...
    _$lessinit$greater$default$4__D = typing.TypeVar('_$lessinit$greater$default$4__D', bound=typing.List[int])  # <D>
    _$lessinit$greater$default$4__HF = typing.TypeVar('_$lessinit$greater$default$4__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$4() -> bool: ...
    _$lessinit$greater$default$5__D = typing.TypeVar('_$lessinit$greater$default$5__D', bound=typing.List[int])  # <D>
    _$lessinit$greater$default$5__HF = typing.TypeVar('_$lessinit$greater$default$5__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$5(keyLength: int, valueLengthOpt: scala.Option[typing.Any], oldRootAndHeight: scala.Option[scala.Tuple2['ProverNodes'[_.lessinit.greater.default.5__D], typing.Any]], collectChangedNodes: bool) -> scorex.crypto.hash.Blake2b256.: ...
    def EndOfTreeInPackagedProof(self) -> int: ...
    def LabelInPackagedProof(self) -> int: ...
    def LeafInPackagedProof(self) -> int: ...
    def NegativeInfinityKey(self) -> typing.List[int]: ...
    def PositiveInfinityKey(self) -> typing.List[int]: ...
    def addNode(self, r: 'Leaf'[_BatchAVLProver__D], key: typing.List[int], v: typing.List[int]) -> 'InternalProverNode'[_BatchAVLProver__D]: ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def changedNodesBuffer(self) -> scala.collection.mutable.ArrayBuffer['ProverNodes'[_BatchAVLProver__D]]: ...
    def changedNodesBufferToCheck(self) -> scala.collection.mutable.ArrayBuffer['ProverNodes'[_BatchAVLProver__D]]: ...
    def checkTree(self, postProof: bool) -> None: ...
    def checkTree$default$1(self) -> bool: ...
    def collectChangedNodes(self) -> bool: ...
    def com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(self, x$1: com.typesafe.scalalogging.Logger) -> None: ...
    @typing.overload
    def contains(self, key: typing.List[int], label: _BatchAVLProver__D) -> bool: ...
    @typing.overload
    def contains(self, node: 'ProverNodes'[_BatchAVLProver__D]) -> bool: ...
    @typing.overload
    def digest(self) -> typing.List[int]: ...
    @typing.overload
    def digest(self, rootNode: Node[_BatchAVLProver__D]) -> typing.List[int]: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def generateProof(self) -> typing.List[int]: ...
    def generateProofForOperations(self, operations: scala.collection.Seq[Operation]) -> scala.util.Try[scala.Tuple2[typing.List[int], typing.List[int]]]: ...
    def hf(self) -> _BatchAVLProver__HF: ...
    def keyLength(self) -> int: ...
    def keyMatchesLeaf(self, key: typing.List[int], r: 'Leaf'[_BatchAVLProver__D]) -> bool: ...
    def labelLength(self) -> int: ...
    def log(self) -> com.typesafe.scalalogging.Logger: ...
    def logger(self) -> com.typesafe.scalalogging.Logger: ...
    def nextDirectionIsLeft(self, key: typing.List[int], r: 'InternalNode'[_BatchAVLProver__D]) -> bool: ...
    def onNodeVisit(self, n: Node[_BatchAVLProver__D], operation: Operation, isRotate: bool) -> None: ...
    def onNodeVisit$default$3(self) -> bool: ...
    def performOneOperation(self, operation: Operation) -> scala.util.Try[scala.Option[typing.List[int]]]: ...
    def randomWalk(self, rand: scala.util.Random) -> scala.Option[scala.Tuple2[typing.List[int], typing.List[int]]]: ...
    def randomWalk$default$1(self) -> scala.util.Random: ...
    def removedNodes(self) -> scala.collection.immutable.List['ProverNodes'[_BatchAVLProver__D]]: ...
    def replayComparison(self) -> int: ...
    def returnResultOfOneOperation(self, operation: Operation, rootNode: Node[_BatchAVLProver__D]) -> scala.util.Try[scala.Tuple2[Node[_BatchAVLProver__D], scala.Option[typing.List[int]]]]: ...
    def rootNodeHeight(self) -> int: ...
    def rootNodeHeight_$eq(self, x$1: int) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$NegativeInfinityKey_$eq(self, x$1: typing.List[int]) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$PositiveInfinityKey_$eq(self, x$1: typing.List[int]) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$changedNodesBufferToCheck_$eq(self, x$1: scala.collection.mutable.ArrayBuffer['ProverNodes'[_BatchAVLProver__D]]) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$changedNodesBuffer_$eq(self, x$1: scala.collection.mutable.ArrayBuffer['ProverNodes'[_BatchAVLProver__D]]) -> None: ...
    def scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$EndOfTreeInPackagedProof_$eq(self, x$1: int) -> None: ...
    def scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LabelInPackagedProof_$eq(self, x$1: int) -> None: ...
    def scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LeafInPackagedProof_$eq(self, x$1: int) -> None: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    def topNode(self) -> 'ProverNodes'[_BatchAVLProver__D]: ...
    def topNode_$eq(self, x$1: 'ProverNodes'[_BatchAVLProver__D]) -> None: ...
    _treeWalk__IR = typing.TypeVar('_treeWalk__IR')  # <IR>
    _treeWalk__LR = typing.TypeVar('_treeWalk__LR')  # <LR>
    def treeWalk(self, internalNodeFn: scala.Function2['InternalProverNode'[_BatchAVLProver__D], _treeWalk__IR, scala.Tuple2['ProverNodes'[_BatchAVLProver__D], _treeWalk__IR]], leafFn: scala.Function2['ProverLeaf'[_BatchAVLProver__D], _treeWalk__IR, _treeWalk__LR], initial: _treeWalk__IR) -> _treeWalk__LR: ...
    def unauthenticatedLookup(self, key: typing.List[int]) -> scala.Option[typing.List[int]]: ...
    def valueLengthOpt(self) -> scala.Option[typing.Any]: ...

_BatchAVLVerifier__D = typing.TypeVar('_BatchAVLVerifier__D', bound=typing.List[int])  # <D>
_BatchAVLVerifier__HF = typing.TypeVar('_BatchAVLVerifier__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
class BatchAVLVerifier(AuthenticatedTreeOps[_BatchAVLVerifier__D], typing.Generic[_BatchAVLVerifier__D, _BatchAVLVerifier__HF]):
    def __init__(self, startingDigest: typing.List[int], proof: typing.List[int], keyLength: int, valueLengthOpt: scala.Option[typing.Any], maxNumOperations: scala.Option[typing.Any], maxDeletes: scala.Option[typing.Any], hf: _BatchAVLVerifier__HF): ...
    _$lessinit$greater$default$5__D = typing.TypeVar('_$lessinit$greater$default$5__D', bound=typing.List[int])  # <D>
    _$lessinit$greater$default$5__HF = typing.TypeVar('_$lessinit$greater$default$5__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$5() -> scala.Option[typing.Any]: ...
    _$lessinit$greater$default$6__D = typing.TypeVar('_$lessinit$greater$default$6__D', bound=typing.List[int])  # <D>
    _$lessinit$greater$default$6__HF = typing.TypeVar('_$lessinit$greater$default$6__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$6() -> scala.Option[typing.Any]: ...
    _$lessinit$greater$default$7__D = typing.TypeVar('_$lessinit$greater$default$7__D', bound=typing.List[int])  # <D>
    _$lessinit$greater$default$7__HF = typing.TypeVar('_$lessinit$greater$default$7__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$7(startingDigest: typing.List[int], proof: typing.List[int], keyLength: int, valueLengthOpt: scala.Option[typing.Any], maxNumOperations: scala.Option[typing.Any], maxDeletes: scala.Option[typing.Any]) -> scorex.crypto.hash.Blake2b256.: ...
    def EndOfTreeInPackagedProof(self) -> int: ...
    def LabelInPackagedProof(self) -> int: ...
    def LeafInPackagedProof(self) -> int: ...
    def NegativeInfinityKey(self) -> typing.List[int]: ...
    def PositiveInfinityKey(self) -> typing.List[int]: ...
    def addNode(self, r: 'Leaf'[_BatchAVLVerifier__D], key: typing.List[int], v: typing.List[int]) -> 'InternalVerifierNode'[_BatchAVLVerifier__D]: ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def changedNodesBuffer(self) -> scala.collection.mutable.ArrayBuffer['ProverNodes'[_BatchAVLVerifier__D]]: ...
    def changedNodesBufferToCheck(self) -> scala.collection.mutable.ArrayBuffer['ProverNodes'[_BatchAVLVerifier__D]]: ...
    def collectChangedNodes(self) -> bool: ...
    @typing.overload
    def digest(self, rootNode: Node[_BatchAVLVerifier__D]) -> typing.List[int]: ...
    @typing.overload
    def digest(self) -> scala.Option[typing.List[int]]: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def extractFirstNode(self, extractor: scala.Function1['VerifierNodes'[_BatchAVLVerifier__D], typing.Any]) -> scala.Option['VerifierNodes'[_BatchAVLVerifier__D]]: ...
    def extractNodes(self, extractor: scala.Function1['VerifierNodes'[_BatchAVLVerifier__D], typing.Any]) -> scala.Option[scala.collection.Seq['VerifierNodes'[_BatchAVLVerifier__D]]]: ...
    def keyLength(self) -> int: ...
    def keyMatchesLeaf(self, key: typing.List[int], r: 'Leaf'[_BatchAVLVerifier__D]) -> bool: ...
    def labelLength(self) -> int: ...
    def logError(self, t: java.lang.Throwable) -> None: ...
    def nextDirectionIsLeft(self, key: typing.List[int], r: 'InternalNode'[_BatchAVLVerifier__D]) -> bool: ...
    def onNodeVisit(self, n: Node[_BatchAVLVerifier__D], operation: Operation, isRotate: bool) -> None: ...
    def onNodeVisit$default$3(self) -> bool: ...
    def performOneOperation(self, operation: Operation) -> scala.util.Try[scala.Option[typing.List[int]]]: ...
    def replayComparison(self) -> int: ...
    def returnResultOfOneOperation(self, operation: Operation, rootNode: Node[_BatchAVLVerifier__D]) -> scala.util.Try[scala.Tuple2[Node[_BatchAVLVerifier__D], scala.Option[typing.List[int]]]]: ...
    def rootNodeHeight(self) -> int: ...
    def rootNodeHeight_$eq(self, x$1: int) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$NegativeInfinityKey_$eq(self, x$1: typing.List[int]) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$PositiveInfinityKey_$eq(self, x$1: typing.List[int]) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$changedNodesBufferToCheck_$eq(self, x$1: scala.collection.mutable.ArrayBuffer['ProverNodes'[_BatchAVLVerifier__D]]) -> None: ...
    def scorex$crypto$authds$avltree$batch$AuthenticatedTreeOps$_setter_$changedNodesBuffer_$eq(self, x$1: scala.collection.mutable.ArrayBuffer['ProverNodes'[_BatchAVLVerifier__D]]) -> None: ...
    def scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$EndOfTreeInPackagedProof_$eq(self, x$1: int) -> None: ...
    def scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LabelInPackagedProof_$eq(self, x$1: int) -> None: ...
    def scorex$crypto$authds$avltree$batch$BatchProofConstants$_setter_$LeafInPackagedProof_$eq(self, x$1: int) -> None: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    def valueLengthOpt(self) -> scala.Option[typing.Any]: ...

class Insert(Modification, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int], value: typing.List[int]): ...
    @staticmethod
    def apply(key: typing.List[int], value: typing.List[int]) -> 'Insert': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, key: typing.List[int], value: typing.List[int]) -> 'Insert': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> typing.List[int]: ...
    @staticmethod
    def curried() -> scala.Function1[typing.List[int], scala.Function1[typing.List[int], 'Insert']]: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def key(self) -> typing.List[int]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[typing.List[int], typing.List[int]], 'Insert']: ...
    @staticmethod
    def unapply(x$0: 'Insert') -> scala.Option[scala.Tuple2[typing.List[int], typing.List[int]]]: ...
    def updateFn(self) -> scala.Function1[scala.Option[typing.List[int]], scala.util.Try[scala.Option[typing.List[int]]]]: ...
    def value(self) -> typing.List[int]: ...

class InsertOrUpdate(Modification, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int], value: typing.List[int]): ...
    @staticmethod
    def apply(key: typing.List[int], value: typing.List[int]) -> 'InsertOrUpdate': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, key: typing.List[int], value: typing.List[int]) -> 'InsertOrUpdate': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> typing.List[int]: ...
    @staticmethod
    def curried() -> scala.Function1[typing.List[int], scala.Function1[typing.List[int], 'InsertOrUpdate']]: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def key(self) -> typing.List[int]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[typing.List[int], typing.List[int]], 'InsertOrUpdate']: ...
    @staticmethod
    def unapply(x$0: 'InsertOrUpdate') -> scala.Option[scala.Tuple2[typing.List[int], typing.List[int]]]: ...
    def updateFn(self) -> scala.Function1[scala.Option[typing.List[int]], scala.util.Try[scala.Option[typing.List[int]]]]: ...
    def value(self) -> typing.List[int]: ...

_InternalNode__D = typing.TypeVar('_InternalNode__D', bound=typing.List[int])  # <D>
class InternalNode(Node[_InternalNode__D], typing.Generic[_InternalNode__D]):
    @staticmethod
    def $init$($this: 'InternalNode') -> None: ...
    def b(self) -> int: ...
    def b_$eq(self, x$1: int) -> None: ...
    def balance(self) -> int: ...
    def computeLabel(self) -> _InternalNode__D: ...
    def getNew(self, newLeft: Node[_InternalNode__D], newRight: Node[_InternalNode__D], newBalance: int) -> 'InternalNode'[_InternalNode__D]: ...
    def getNew$default$1(self) -> Node[_InternalNode__D]: ...
    def getNew$default$2(self) -> Node[_InternalNode__D]: ...
    def getNew$default$3(self) -> int: ...
    def getNewKey(self, newKey: typing.List[int]) -> 'InternalNode'[_InternalNode__D]: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[_InternalNode__D]: ...
    def left(self) -> Node[_InternalNode__D]: ...
    def right(self) -> Node[_InternalNode__D]: ...

_Leaf__D = typing.TypeVar('_Leaf__D', bound=typing.List[int])  # <D>
class Leaf(Node[_Leaf__D], KeyInVar, typing.Generic[_Leaf__D]):
    @staticmethod
    def $init$($this: 'Leaf') -> None: ...
    def computeLabel(self) -> _Leaf__D: ...
    def getNew(self, newKey: typing.List[int], newValue: typing.List[int], newNextLeafKey: typing.List[int]) -> 'Leaf'[_Leaf__D]: ...
    def getNew$default$1(self) -> typing.List[int]: ...
    def getNew$default$2(self) -> typing.List[int]: ...
    def getNew$default$3(self) -> typing.List[int]: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[_Leaf__D]: ...
    def nextLeafKey(self) -> typing.List[int]: ...
    def nk(self) -> typing.List[int]: ...
    def nk_$eq(self, x$1: typing.List[int]) -> None: ...
    def toString(self) -> java.lang.String: ...
    def v(self) -> typing.List[int]: ...
    def v_$eq(self, x$1: typing.List[int]) -> None: ...
    def value(self) -> typing.List[int]: ...

_ProverNodes__D = typing.TypeVar('_ProverNodes__D', bound=typing.List[int])  # <D>
class ProverNodes(Node[_ProverNodes__D], KeyInVar, typing.Generic[_ProverNodes__D]):
    @staticmethod
    def $init$($this: 'ProverNodes') -> None: ...
    def isNew(self) -> bool: ...
    def isNew_$eq(self, x$1: bool) -> None: ...

class Remove(Modification, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['Remove', _andThen__A]) -> scala.Function1[typing.List[int], _andThen__A]: ...
    @staticmethod
    def apply(key: typing.List[int]) -> 'Remove': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.List[int]]) -> scala.Function1[_compose__A, 'Remove']: ...
    def copy(self, key: typing.List[int]) -> 'Remove': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def key(self) -> typing.List[int]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'Remove') -> scala.Option[typing.List[int]]: ...
    def updateFn(self) -> scala.Function1[scala.Option[typing.List[int]], scala.util.Try[scala.Option[typing.List[int]]]]: ...

class RemoveIfExists(Modification, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int]): ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['RemoveIfExists', _andThen__A]) -> scala.Function1[typing.List[int], _andThen__A]: ...
    @staticmethod
    def apply(key: typing.List[int]) -> 'RemoveIfExists': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.List[int]]) -> scala.Function1[_compose__A, 'RemoveIfExists']: ...
    def copy(self, key: typing.List[int]) -> 'RemoveIfExists': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def key(self) -> typing.List[int]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'RemoveIfExists') -> scala.Option[typing.List[int]]: ...
    def updateFn(self) -> scala.Function1[scala.Option[typing.List[int]], scala.util.Try[scala.Option[typing.List[int]]]]: ...

class Update(Modification, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int], value: typing.List[int]): ...
    @staticmethod
    def apply(key: typing.List[int], value: typing.List[int]) -> 'Update': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, key: typing.List[int], value: typing.List[int]) -> 'Update': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> typing.List[int]: ...
    @staticmethod
    def curried() -> scala.Function1[typing.List[int], scala.Function1[typing.List[int], 'Update']]: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def key(self) -> typing.List[int]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[typing.List[int], typing.List[int]], 'Update']: ...
    @staticmethod
    def unapply(x$0: 'Update') -> scala.Option[scala.Tuple2[typing.List[int], typing.List[int]]]: ...
    def updateFn(self) -> scala.Function1[scala.Option[typing.List[int]], scala.util.Try[scala.Option[typing.List[int]]]]: ...
    def value(self) -> typing.List[int]: ...

class UpdateLongBy(Modification, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int], delta: int): ...
    @staticmethod
    def apply(key: typing.List[int], delta: int) -> 'UpdateLongBy': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, key: typing.List[int], delta: int) -> 'UpdateLongBy': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> int: ...
    @staticmethod
    def curried() -> scala.Function1[typing.List[int], scala.Function1[typing.Any, 'UpdateLongBy']]: ...
    def delta(self) -> int: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def key(self) -> typing.List[int]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def tupled() -> scala.Function1[scala.Tuple2[typing.List[int], typing.Any], 'UpdateLongBy']: ...
    @staticmethod
    def unapply(x$0: 'UpdateLongBy') -> scala.Option[scala.Tuple2[typing.List[int], typing.Any]]: ...
    def updateFn(self) -> scala.Function1[scala.Option[typing.List[int]], scala.util.Try[scala.Option[typing.List[int]]]]: ...

_VerifierNodes__D = typing.TypeVar('_VerifierNodes__D', bound=typing.List[int])  # <D>
class VerifierNodes(Node[_VerifierNodes__D], typing.Generic[_VerifierNodes__D]): ...

_InternalProverNode__D = typing.TypeVar('_InternalProverNode__D', bound=typing.List[int])  # <D>
class InternalProverNode(ProverNodes[_InternalProverNode__D], InternalNode[_InternalProverNode__D], typing.Generic[_InternalProverNode__D]):
    def __init__(self, k: typing.List[int], l: ProverNodes[_InternalProverNode__D], r: ProverNodes[_InternalProverNode__D], b: int, hf: scorex.crypto.hash.CryptographicHash[_InternalProverNode__D]): ...
    _$lessinit$greater$default$4__D = typing.TypeVar('_$lessinit$greater$default$4__D', bound=typing.List[int])  # <D>
    @staticmethod
    def $lessinit$greater$default$4() -> int: ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def b(self) -> int: ...
    def b_$eq(self, x$1: int) -> None: ...
    def balance(self) -> int: ...
    def computeLabel(self) -> _InternalProverNode__D: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def getNew(self, newLeft: Node[_InternalProverNode__D], newRight: Node[_InternalProverNode__D], newBalance: int) -> 'InternalProverNode'[_InternalProverNode__D]: ...
    def getNew$default$1(self) -> Node[_InternalProverNode__D]: ...
    def getNew$default$2(self) -> Node[_InternalProverNode__D]: ...
    def getNew$default$3(self) -> int: ...
    def getNewKey(self, newKey: typing.List[int]) -> 'InternalProverNode'[_InternalProverNode__D]: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[_InternalProverNode__D]: ...
    def isNew(self) -> bool: ...
    def isNew_$eq(self, x$1: bool) -> None: ...
    def k(self) -> typing.List[int]: ...
    def k_$eq(self, x$1: typing.List[int]) -> None: ...
    def key(self) -> typing.List[int]: ...
    def l(self) -> ProverNodes[_InternalProverNode__D]: ...
    def l_$eq(self, x$1: ProverNodes[_InternalProverNode__D]) -> None: ...
    def label(self) -> _InternalProverNode__D: ...
    def labelOpt(self) -> scala.Option[_InternalProverNode__D]: ...
    def labelOpt_$eq(self, x$1: scala.Option[_InternalProverNode__D]) -> None: ...
    def left(self) -> ProverNodes[_InternalProverNode__D]: ...
    def r(self) -> ProverNodes[_InternalProverNode__D]: ...
    def r_$eq(self, x$1: ProverNodes[_InternalProverNode__D]) -> None: ...
    def right(self) -> ProverNodes[_InternalProverNode__D]: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    def visited(self) -> bool: ...
    def visited_$eq(self, x$1: bool) -> None: ...

_InternalVerifierNode__D = typing.TypeVar('_InternalVerifierNode__D', bound=typing.List[int])  # <D>
class InternalVerifierNode(VerifierNodes[_InternalVerifierNode__D], InternalNode[_InternalVerifierNode__D], typing.Generic[_InternalVerifierNode__D]):
    def __init__(self, l: Node[_InternalVerifierNode__D], r: Node[_InternalVerifierNode__D], b: int, hf: scorex.crypto.hash.CryptographicHash[_InternalVerifierNode__D]): ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def b(self) -> int: ...
    def b_$eq(self, x$1: int) -> None: ...
    def balance(self) -> int: ...
    def computeLabel(self) -> _InternalVerifierNode__D: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def getNew(self, newLeft: Node[_InternalVerifierNode__D], newRight: Node[_InternalVerifierNode__D], newBalance: int) -> 'InternalVerifierNode'[_InternalVerifierNode__D]: ...
    def getNew$default$1(self) -> Node[_InternalVerifierNode__D]: ...
    def getNew$default$2(self) -> Node[_InternalVerifierNode__D]: ...
    def getNew$default$3(self) -> int: ...
    def getNewKey(self, newKey: typing.List[int]) -> InternalNode[_InternalVerifierNode__D]: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[_InternalVerifierNode__D]: ...
    def l(self) -> Node[_InternalVerifierNode__D]: ...
    def l_$eq(self, x$1: Node[_InternalVerifierNode__D]) -> None: ...
    def label(self) -> _InternalVerifierNode__D: ...
    def labelOpt(self) -> scala.Option[_InternalVerifierNode__D]: ...
    def labelOpt_$eq(self, x$1: scala.Option[_InternalVerifierNode__D]) -> None: ...
    def left(self) -> Node[_InternalVerifierNode__D]: ...
    def r(self) -> Node[_InternalVerifierNode__D]: ...
    def r_$eq(self, x$1: Node[_InternalVerifierNode__D]) -> None: ...
    def right(self) -> Node[_InternalVerifierNode__D]: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    def visited(self) -> bool: ...
    def visited_$eq(self, x$1: bool) -> None: ...

_LabelOnlyNode__D = typing.TypeVar('_LabelOnlyNode__D', bound=typing.List[int])  # <D>
class LabelOnlyNode(VerifierNodes[_LabelOnlyNode__D], typing.Generic[_LabelOnlyNode__D]):
    def __init__(self, l: _LabelOnlyNode__D): ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def computeLabel(self) -> _LabelOnlyNode__D: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def label(self) -> _LabelOnlyNode__D: ...
    def labelOpt(self) -> scala.Option[_LabelOnlyNode__D]: ...
    def labelOpt_$eq(self, x$1: scala.Option[_LabelOnlyNode__D]) -> None: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def visited(self) -> bool: ...
    def visited_$eq(self, x$1: bool) -> None: ...

_ProverLeaf__D = typing.TypeVar('_ProverLeaf__D', bound=typing.List[int])  # <D>
class ProverLeaf(Leaf[_ProverLeaf__D], ProverNodes[_ProverLeaf__D], typing.Generic[_ProverLeaf__D]):
    def __init__(self, k: typing.List[int], v: typing.List[int], nk: typing.List[int], hf: scorex.crypto.hash.CryptographicHash[_ProverLeaf__D]): ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def computeLabel(self) -> _ProverLeaf__D: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def getNew(self, newKey: typing.List[int], newValue: typing.List[int], newNextLeafKey: typing.List[int]) -> 'ProverLeaf'[_ProverLeaf__D]: ...
    def getNew$default$1(self) -> typing.List[int]: ...
    def getNew$default$2(self) -> typing.List[int]: ...
    def getNew$default$3(self) -> typing.List[int]: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[_ProverLeaf__D]: ...
    def isNew(self) -> bool: ...
    def isNew_$eq(self, x$1: bool) -> None: ...
    def k(self) -> typing.List[int]: ...
    def k_$eq(self, x$1: typing.List[int]) -> None: ...
    def key(self) -> typing.List[int]: ...
    def label(self) -> _ProverLeaf__D: ...
    def labelOpt(self) -> scala.Option[_ProverLeaf__D]: ...
    def labelOpt_$eq(self, x$1: scala.Option[_ProverLeaf__D]) -> None: ...
    def nextLeafKey(self) -> typing.List[int]: ...
    def nk(self) -> typing.List[int]: ...
    def nk_$eq(self, x$1: typing.List[int]) -> None: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    def v(self) -> typing.List[int]: ...
    def v_$eq(self, x$1: typing.List[int]) -> None: ...
    def value(self) -> typing.List[int]: ...
    def visited(self) -> bool: ...
    def visited_$eq(self, x$1: bool) -> None: ...

_VerifierLeaf__D = typing.TypeVar('_VerifierLeaf__D', bound=typing.List[int])  # <D>
class VerifierLeaf(Leaf[_VerifierLeaf__D], VerifierNodes[_VerifierLeaf__D], typing.Generic[_VerifierLeaf__D]):
    def __init__(self, k: typing.List[int], v: typing.List[int], nk: typing.List[int], hf: scorex.crypto.hash.CryptographicHash[_VerifierLeaf__D]): ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def computeLabel(self) -> _VerifierLeaf__D: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def getNew(self, newKey: typing.List[int], newValue: typing.List[int], newNextLeafKey: typing.List[int]) -> 'VerifierLeaf'[_VerifierLeaf__D]: ...
    def getNew$default$1(self) -> typing.List[int]: ...
    def getNew$default$2(self) -> typing.List[int]: ...
    def getNew$default$3(self) -> typing.List[int]: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[_VerifierLeaf__D]: ...
    def k(self) -> typing.List[int]: ...
    def k_$eq(self, x$1: typing.List[int]) -> None: ...
    def key(self) -> typing.List[int]: ...
    def label(self) -> _VerifierLeaf__D: ...
    def labelOpt(self) -> scala.Option[_VerifierLeaf__D]: ...
    def labelOpt_$eq(self, x$1: scala.Option[_VerifierLeaf__D]) -> None: ...
    def nextLeafKey(self) -> typing.List[int]: ...
    def nk(self) -> typing.List[int]: ...
    def nk_$eq(self, x$1: typing.List[int]) -> None: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    def v(self) -> typing.List[int]: ...
    def v_$eq(self, x$1: typing.List[int]) -> None: ...
    def value(self) -> typing.List[int]: ...
    def visited(self) -> bool: ...
    def visited_$eq(self, x$1: bool) -> None: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("scorex.crypto.authds.avltree.batch")``.

    AuthenticatedTreeOps: typing.Type[AuthenticatedTreeOps]
    BatchAVLProver: typing.Type[BatchAVLProver]
    BatchAVLVerifier: typing.Type[BatchAVLVerifier]
    BatchProofConstants: typing.Type[BatchProofConstants]
    Insert: typing.Type[Insert]
    InsertOrUpdate: typing.Type[InsertOrUpdate]
    InternalNode: typing.Type[InternalNode]
    InternalProverNode: typing.Type[InternalProverNode]
    InternalVerifierNode: typing.Type[InternalVerifierNode]
    KeyInVar: typing.Type[KeyInVar]
    LabelOnlyNode: typing.Type[LabelOnlyNode]
    Leaf: typing.Type[Leaf]
    Lookup: typing.Type[Lookup]
    Modification: typing.Type[Modification]
    Node: typing.Type[Node]
    Operation: typing.Type[Operation]
    PersistentBatchAVLProver: typing.Type[PersistentBatchAVLProver]
    ProverLeaf: typing.Type[ProverLeaf]
    ProverNodes: typing.Type[ProverNodes]
    Remove: typing.Type[Remove]
    RemoveIfExists: typing.Type[RemoveIfExists]
    ToStringHelper: typing.Type[ToStringHelper]
    UnknownModification: typing.Type[UnknownModification]
    Update: typing.Type[Update]
    UpdateLongBy: typing.Type[UpdateLongBy]
    VerifierLeaf: typing.Type[VerifierLeaf]
    VerifierNodes: typing.Type[VerifierNodes]
    VersionedAVLStorage: typing.Type[VersionedAVLStorage]
    serialization: scorex.crypto.authds.avltree.batch.serialization.__module_protocol__
