import java.lang
import scala
import scala.collection
import scala.math
import scala.util
import scorex.crypto.authds
import scorex.crypto.authds.avltree.batch
import scorex.crypto.hash
import scorex.util.encode
import typing



class Constants:
    @staticmethod
    def LabelOfNone() -> typing.List[int]: ...
    @staticmethod
    def MaxKeySize() -> int: ...
    @staticmethod
    def NegativeInfinity() -> scala.Tuple2[typing.List[int], typing.List[int]]: ...
    @staticmethod
    def PositiveInfinity() -> scala.Tuple2[typing.List[int], typing.List[int]]: ...

class InternalNode:
    @staticmethod
    def $init$($this: 'InternalNode') -> None: ...
    def computeLabel(self) -> typing.List[int]: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[typing.List[int]]: ...
    def leftLabel(self) -> typing.List[int]: ...
    def level(self) -> 'Level': ...
    def rightLabel(self) -> typing.List[int]: ...

class Level(scala.math.Ordered['Level']):
    def bytes(self) -> typing.List[int]: ...
    @staticmethod
    def skiplistLevel(key: typing.List[int]) -> 'Level': ...
    @staticmethod
    def treapLevel(key: typing.List[int]) -> 'Level': ...

class Node(scorex.crypto.authds.avltree.batch.ToStringHelper):
    @staticmethod
    def $init$($this: 'Node') -> None: ...
    def computeLabel(self) -> typing.List[int]: ...
    def label(self) -> typing.List[int]: ...
    def labelOpt(self) -> scala.Option[typing.List[int]]: ...
    def labelOpt_$eq(self, x$1: scala.Option[typing.List[int]]) -> None: ...

_Treap__HF = typing.TypeVar('_Treap__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
class Treap(scorex.crypto.authds.TwoPartyDictionary, typing.Generic[_Treap__HF]):
    def __init__(self, rootOpt: scala.Option['Leaf'], hf: _Treap__HF, lf: scala.Function1[typing.List[int], Level]): ...
    _$lessinit$greater$default$1__HF = typing.TypeVar('_$lessinit$greater$default$1__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$1() -> scala.Option['Leaf']: ...
    _$lessinit$greater$default$2__HF = typing.TypeVar('_$lessinit$greater$default$2__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$2(rootOpt: scala.Option['Leaf']) -> scorex.crypto.hash.Blake2b256.: ...
    _$lessinit$greater$default$3__HF = typing.TypeVar('_$lessinit$greater$default$3__HF', bound=scorex.crypto.hash.CryptographicHash)  # <HF>
    @staticmethod
    def $lessinit$greater$default$3(rootOpt: scala.Option['Leaf']) -> scala.Function1[typing.List[int], Level]: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def rootHash(self) -> typing.List[int]: ...
    _run__O = typing.TypeVar('_run__O', bound=scorex.crypto.authds.avltree.batch.Operation)  # <O>
    def run(self, operation: _run__O) -> scala.util.Try['TreapModifyProof']: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def topNode(self) -> 'ProverNodes': ...
    def topNode_$eq(self, x$1: 'ProverNodes') -> None: ...

class TreapModifyProof(scorex.crypto.authds.TwoPartyProof, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int], proofSeq: scala.collection.Seq[scorex.crypto.authds.WTProofElement], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]], levelFunc: scala.Function1[typing.List[int], Level]): ...
    @staticmethod
    def apply(key: typing.List[int], proofSeq: scala.collection.Seq[scorex.crypto.authds.WTProofElement], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]], levelFunc: scala.Function1[typing.List[int], Level]) -> 'TreapModifyProof': ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def copy(self, key: typing.List[int], proofSeq: scala.collection.Seq[scorex.crypto.authds.WTProofElement], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]], levelFunc: scala.Function1[typing.List[int], Level]) -> 'TreapModifyProof': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> scala.collection.Seq[scorex.crypto.authds.WTProofElement]: ...
    def dequeueBalance(self) -> int: ...
    def dequeueDirection(self) -> scorex.crypto.authds.Direction: ...
    def dequeueKey(self) -> typing.List[int]: ...
    def dequeueLeftLabel(self) -> typing.List[int]: ...
    def dequeueLevel(self) -> Level: ...
    def dequeueNextLeafKey(self) -> typing.List[int]: ...
    def dequeueRightLabel(self) -> typing.List[int]: ...
    def dequeueValue(self) -> typing.List[int]: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def initializeIterator(self) -> None: ...
    def key(self) -> typing.List[int]: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def proofSeq(self) -> scala.collection.Seq[scorex.crypto.authds.WTProofElement]: ...
    def scorex$crypto$authds$ProofIterator$$i(self) -> int: ...
    def scorex$crypto$authds$ProofIterator$$i_$eq(self, x$1: int) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'TreapModifyProof') -> scala.Option[scala.Tuple2[typing.List[int], scala.collection.Seq[scorex.crypto.authds.WTProofElement]]]: ...
    @typing.overload
    def verify(self, digest: typing.List[int], updateFn: scala.Function1[scala.Option[typing.List[int]], scala.util.Try[scala.Option[typing.List[int]]]]) -> scala.Option[typing.List[int]]: ...
    @typing.overload
    def verify(self, digest: typing.List[int], modification: scorex.crypto.authds.avltree.batch.Modification) -> scala.Option[typing.List[int]]: ...

class ByteLevel(Level, scala.Product, scala.Serializable):
    def __init__(self, level: int): ...
    def $greater(self, that: typing.Any) -> bool: ...
    def $greater$eq(self, that: typing.Any) -> bool: ...
    def $less(self, that: typing.Any) -> bool: ...
    def $less$eq(self, that: typing.Any) -> bool: ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['ByteLevel', _andThen__A]) -> scala.Function1[typing.Any, _andThen__A]: ...
    @staticmethod
    def apply(level: int) -> 'ByteLevel': ...
    def bytes(self) -> typing.List[int]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def compare(self, that: Level) -> int: ...
    def compareTo(self, that: typing.Any) -> int: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.Any]) -> scala.Function1[_compose__A, 'ByteLevel']: ...
    def copy(self, level: int) -> 'ByteLevel': ...
    def copy$default$1(self) -> int: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def level(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ByteLevel') -> scala.Option[typing.Any]: ...

class IntLevel(Level, scala.Product, scala.Serializable):
    def __init__(self, level: int): ...
    def $greater(self, that: typing.Any) -> bool: ...
    def $greater$eq(self, that: typing.Any) -> bool: ...
    def $less(self, that: typing.Any) -> bool: ...
    def $less$eq(self, that: typing.Any) -> bool: ...
    _andThen__A = typing.TypeVar('_andThen__A')  # <A>
    @staticmethod
    def andThen(g: scala.Function1['IntLevel', _andThen__A]) -> scala.Function1[typing.Any, _andThen__A]: ...
    @staticmethod
    def apply(level: int) -> 'IntLevel': ...
    def bytes(self) -> typing.List[int]: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def compare(self, that: Level) -> int: ...
    def compareTo(self, that: typing.Any) -> int: ...
    _compose__A = typing.TypeVar('_compose__A')  # <A>
    @staticmethod
    def compose(g: scala.Function1[_compose__A, typing.Any]) -> scala.Function1[_compose__A, 'IntLevel']: ...
    def copy(self, level: int) -> 'IntLevel': ...
    def copy$default$1(self) -> int: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def level(self) -> int: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'IntLevel') -> scala.Option[typing.Any]: ...

class ProverNodes(Node):
    def key(self) -> typing.List[int]: ...

class VerifierNodes(Node): ...

class Leaf(ProverNodes, VerifierNodes, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int], _value: typing.List[int], _nextLeafKey: typing.List[int], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]): ...
    def _nextLeafKey$access$2(self) -> typing.List[int]: ...
    def _value$access$1(self) -> typing.List[int]: ...
    @staticmethod
    def apply(key: typing.List[int], _value: typing.List[int], _nextLeafKey: typing.List[int], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'Leaf': ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def computeLabel(self) -> typing.List[int]: ...
    def copy(self, key: typing.List[int], _value: typing.List[int], _nextLeafKey: typing.List[int], hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'Leaf': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> typing.List[int]: ...
    def copy$default$3(self) -> typing.List[int]: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def key(self) -> typing.List[int]: ...
    def label(self) -> typing.List[int]: ...
    def labelOpt(self) -> scala.Option[typing.List[int]]: ...
    def labelOpt_$eq(self, x$1: scala.Option[typing.List[int]]) -> None: ...
    def nextLeafKey(self) -> typing.List[int]: ...
    def nextLeafKey_$eq(self, newNextLeafKey: typing.List[int]) -> None: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'Leaf') -> scala.Option[scala.Tuple3[typing.List[int], typing.List[int], typing.List[int]]]: ...
    def value(self) -> typing.List[int]: ...
    def value_$eq(self, newValue: typing.List[int]) -> None: ...

class ProverNode(ProverNodes, InternalNode, scala.Product, scala.Serializable):
    def __init__(self, key: typing.List[int], _left: ProverNodes, _right: ProverNodes, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]], levelFunc: scala.Function1[typing.List[int], Level]): ...
    def _left$access$1(self) -> ProverNodes: ...
    def _right$access$2(self) -> ProverNodes: ...
    @staticmethod
    def apply(key: typing.List[int], _left: ProverNodes, _right: ProverNodes, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]], levelFunc: scala.Function1[typing.List[int], Level]) -> 'ProverNode': ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def computeLabel(self) -> typing.List[int]: ...
    def copy(self, key: typing.List[int], _left: ProverNodes, _right: ProverNodes, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]], levelFunc: scala.Function1[typing.List[int], Level]) -> 'ProverNode': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> ProverNodes: ...
    def copy$default$3(self) -> ProverNodes: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[typing.List[int]]: ...
    def key(self) -> typing.List[int]: ...
    def label(self) -> typing.List[int]: ...
    def labelOpt(self) -> scala.Option[typing.List[int]]: ...
    def labelOpt_$eq(self, x$1: scala.Option[typing.List[int]]) -> None: ...
    def left(self) -> ProverNodes: ...
    def leftLabel(self) -> typing.List[int]: ...
    def left_$eq(self, newLeft: ProverNodes) -> None: ...
    def level(self) -> Level: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def right(self) -> ProverNodes: ...
    def rightLabel(self) -> typing.List[int]: ...
    def right_$eq(self, newRight: ProverNodes) -> None: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'ProverNode') -> scala.Option[scala.Tuple3[typing.List[int], ProverNodes, ProverNodes]]: ...

class VerifierNode(VerifierNodes, InternalNode, scala.Product, scala.Serializable):
    def __init__(self, _leftLabel: typing.List[int], _rightLabel: typing.List[int], level: Level, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]): ...
    def _leftLabel$access$0(self) -> typing.List[int]: ...
    def _rightLabel$access$1(self) -> typing.List[int]: ...
    @staticmethod
    def apply(_leftLabel: typing.List[int], _rightLabel: typing.List[int], level: Level, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'VerifierNode': ...
    def arrayToString(self, a: typing.List[int]) -> java.lang.String: ...
    def canEqual(self, x$1: typing.Any) -> bool: ...
    def computeLabel(self) -> typing.List[int]: ...
    def copy(self, _leftLabel: typing.List[int], _rightLabel: typing.List[int], level: Level, hf: scorex.crypto.hash.CryptographicHash[typing.List[int]]) -> 'VerifierNode': ...
    def copy$default$1(self) -> typing.List[int]: ...
    def copy$default$2(self) -> typing.List[int]: ...
    def copy$default$3(self) -> Level: ...
    def encoder(self) -> scorex.util.encode.BytesEncoder: ...
    def equals(self, x$1: typing.Any) -> bool: ...
    def hashCode(self) -> int: ...
    def hf(self) -> scorex.crypto.hash.CryptographicHash[typing.List[int]]: ...
    def label(self) -> typing.List[int]: ...
    def labelOpt(self) -> scala.Option[typing.List[int]]: ...
    def labelOpt_$eq(self, x$1: scala.Option[typing.List[int]]) -> None: ...
    def leftLabel(self) -> typing.List[int]: ...
    def leftLabel_$eq(self, newLeft: typing.List[int]) -> None: ...
    def level(self) -> Level: ...
    def productArity(self) -> int: ...
    def productElement(self, x$1: int) -> typing.Any: ...
    def productIterator(self) -> scala.collection.Iterator[typing.Any]: ...
    def productPrefix(self) -> java.lang.String: ...
    def rightLabel(self) -> typing.List[int]: ...
    def rightLabel_$eq(self, newRight: typing.List[int]) -> None: ...
    def scorex$util$ScorexEncoding$_setter_$encoder_$eq(self, x$1: scorex.util.encode.BytesEncoder) -> None: ...
    def toString(self) -> java.lang.String: ...
    @staticmethod
    def unapply(x$0: 'VerifierNode') -> scala.Option[scala.Tuple3[typing.List[int], typing.List[int], Level]]: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("scorex.crypto.authds.legacy.treap")``.

    ByteLevel: typing.Type[ByteLevel]
    Constants: typing.Type[Constants]
    IntLevel: typing.Type[IntLevel]
    InternalNode: typing.Type[InternalNode]
    Leaf: typing.Type[Leaf]
    Level: typing.Type[Level]
    Node: typing.Type[Node]
    ProverNode: typing.Type[ProverNode]
    ProverNodes: typing.Type[ProverNodes]
    Treap: typing.Type[Treap]
    TreapModifyProof: typing.Type[TreapModifyProof]
    VerifierNode: typing.Type[VerifierNode]
    VerifierNodes: typing.Type[VerifierNodes]
