import java.lang
import org.bouncycastle.crypto
import org.bouncycastle.crypto.digests
import scala.collection
import scala.math
import scala.util
import scorex
import supertagged
import typing



class Blake2b256:
    @staticmethod
    def DigestSize() -> int: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @staticmethod
    def byteArrayToDigest(bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    @staticmethod
    def prefixedHash(prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...

class Blake2b512:
    @staticmethod
    def DigestSize() -> int: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @staticmethod
    def byteArrayToDigest(bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    @staticmethod
    def prefixedHash(prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...

_CryptographicHash__D = typing.TypeVar('_CryptographicHash__D', bound=typing.List[int])  # <D>
class CryptographicHash(typing.Generic[_CryptographicHash__D]):
    @staticmethod
    def $init$($this: 'CryptographicHash') -> None: ...
    def DigestSize(self) -> int: ...
    @typing.overload
    def apply(self, input: typing.List[int]) -> _CryptographicHash__D: ...
    @typing.overload
    def apply(self, input: typing.Union[java.lang.String, str]) -> _CryptographicHash__D: ...
    def byteArrayToDigest(self, bytes: typing.List[int]) -> scala.util.Try[_CryptographicHash__D]: ...
    @typing.overload
    def hash(self, input: typing.List[int]) -> _CryptographicHash__D: ...
    @typing.overload
    def hash(self, input: typing.Union[java.lang.String, str]) -> _CryptographicHash__D: ...
    @typing.overload
    def hash(self, inputs: scala.collection.Seq[typing.List[int]]) -> _CryptographicHash__D: ...
    def prefixedHash(self, prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> _CryptographicHash__D: ...

class Keccak256:
    @staticmethod
    def DigestSize() -> int: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @staticmethod
    def byteArrayToDigest(bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    @staticmethod
    def prefixedHash(prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...

class Keccak512:
    @staticmethod
    def DigestSize() -> int: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @staticmethod
    def byteArrayToDigest(bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    @staticmethod
    def prefixedHash(prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...

class Sha256:
    @staticmethod
    def DigestSize() -> int: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @staticmethod
    def byteArrayToDigest(bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    @staticmethod
    def prefixedHash(prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...

class Skein256:
    @staticmethod
    def DigestSize() -> int: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @staticmethod
    def byteArrayToDigest(bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    @staticmethod
    def prefixedHash(prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...

class Skein512:
    @staticmethod
    def DigestSize() -> int: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @staticmethod
    def byteArrayToDigest(bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    @staticmethod
    def prefixedHash(prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...

class Stribog256:
    @staticmethod
    def DigestSize() -> int: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @staticmethod
    def byteArrayToDigest(bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    @staticmethod
    def prefixedHash(prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...

class Stribog512:
    @staticmethod
    def DigestSize() -> int: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @staticmethod
    def byteArrayToDigest(bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    @staticmethod
    def prefixedHash(prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...

class Whirlpool:
    @staticmethod
    def DigestSize() -> int: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def apply(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @staticmethod
    def byteArrayToDigest(bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    @staticmethod
    def hash(inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    @staticmethod
    def prefixedHash(prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...

_BouncyCastleHash__D = typing.TypeVar('_BouncyCastleHash__D', bound=typing.List[int])  # <D>
class BouncyCastleHash(CryptographicHash[_BouncyCastleHash__D], typing.Generic[_BouncyCastleHash__D]):
    @staticmethod
    def $init$($this: 'BouncyCastleHash') -> None: ...
    def digestFn(self) -> org.bouncycastle.crypto.ExtendedDigest: ...
    def internalHash(self, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    def internalPrefixedHash(self, prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...

_CommutativeHash__D = typing.TypeVar('_CommutativeHash__D', bound=typing.List[int])  # <D>
class CommutativeHash(CryptographicHash[_CommutativeHash__D], typing.Generic[_CommutativeHash__D]):
    def __init__(self, hf: CryptographicHash[_CommutativeHash__D]): ...
    def DigestSize(self) -> int: ...
    @typing.overload
    def apply(self, input: typing.List[int]) -> _CommutativeHash__D: ...
    @typing.overload
    def apply(self, x: typing.List[int], y: typing.List[int]) -> _CommutativeHash__D: ...
    @typing.overload
    def apply(self, input: typing.Union[java.lang.String, str]) -> _CommutativeHash__D: ...
    def byteArrayToDigest(self, bytes: typing.List[int]) -> scala.util.Try[_CommutativeHash__D]: ...
    @typing.overload
    def hash(self, input: typing.List[int]) -> _CommutativeHash__D: ...
    @typing.overload
    def hash(self, x: typing.List[int], y: typing.List[int]) -> _CommutativeHash__D: ...
    @typing.overload
    def hash(self, input: typing.Union[java.lang.String, str]) -> _CommutativeHash__D: ...
    @typing.overload
    def hash(self, inputs: scala.collection.Seq[typing.List[int]]) -> _CommutativeHash__D: ...
    @typing.overload
    def prefixedHash(self, prefix: int, x: typing.List[int], y: typing.List[int]) -> _CommutativeHash__D: ...
    @typing.overload
    def prefixedHash(self, prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> _CommutativeHash__D: ...

class CryptographicHash32(CryptographicHash[typing.List[int]]):
    @staticmethod
    def $init$($this: 'CryptographicHash32') -> None: ...
    def DigestSize(self) -> int: ...
    def byteArrayToDigest(self, bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    def scorex$crypto$hash$CryptographicHash32$_setter_$DigestSize_$eq(self, x$1: int) -> None: ...

class CryptographicHash64(CryptographicHash[typing.List[int]]):
    @staticmethod
    def $init$($this: 'CryptographicHash64') -> None: ...
    def DigestSize(self) -> int: ...
    def byteArrayToDigest(self, bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    def scorex$crypto$hash$CryptographicHash64$_setter_$DigestSize_$eq(self, x$1: int) -> None: ...

_ThreadUnsafeHash__D = typing.TypeVar('_ThreadUnsafeHash__D', bound=typing.List[int])  # <D>
class ThreadUnsafeHash(CryptographicHash[_ThreadUnsafeHash__D], typing.Generic[_ThreadUnsafeHash__D]): ...

_Blake2b__D = typing.TypeVar('_Blake2b__D', bound=typing.List[int])  # <D>
class Blake2b(BouncyCastleHash[_Blake2b__D], typing.Generic[_Blake2b__D]):
    @staticmethod
    def $init$($this: 'Blake2b') -> None: ...
    @typing.overload
    def digestFn(self) -> org.bouncycastle.crypto.ExtendedDigest: ...
    @typing.overload
    def digestFn(self) -> org.bouncycastle.crypto.digests.Blake2bDigest: ...

class Blake2b256Unsafe(CryptographicHash32, ThreadUnsafeHash[typing.List[int]]):
    def __init__(self): ...
    def DigestSize(self) -> int: ...
    @typing.overload
    def apply(self, input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def apply(self, input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    def byteArrayToDigest(self, bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    def hash(self, input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def hash(self, input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def hash(self, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    def prefixedHash(self, prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    def scorex$crypto$hash$CryptographicHash32$_setter_$DigestSize_$eq(self, x$1: int) -> None: ...

_Keccak__D = typing.TypeVar('_Keccak__D', bound=typing.List[int])  # <D>
class Keccak(BouncyCastleHash[_Keccak__D], typing.Generic[_Keccak__D]):
    @staticmethod
    def $init$($this: 'Keccak') -> None: ...
    @typing.overload
    def digestFn(self) -> org.bouncycastle.crypto.ExtendedDigest: ...
    @typing.overload
    def digestFn(self) -> org.bouncycastle.crypto.digests.KeccakDigest: ...

class Sha256Unsafe(CryptographicHash32, ThreadUnsafeHash[typing.List[int]]):
    def __init__(self): ...
    def DigestSize(self) -> int: ...
    @typing.overload
    def apply(self, input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def apply(self, input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    def byteArrayToDigest(self, bytes: typing.List[int]) -> scala.util.Try[typing.List[int]]: ...
    @typing.overload
    def hash(self, input: typing.List[int]) -> typing.List[int]: ...
    @typing.overload
    def hash(self, input: typing.Union[java.lang.String, str]) -> typing.List[int]: ...
    @typing.overload
    def hash(self, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    def prefixedHash(self, prefix: int, inputs: scala.collection.Seq[typing.List[int]]) -> typing.List[int]: ...
    def scorex$crypto$hash$CryptographicHash32$_setter_$DigestSize_$eq(self, x$1: int) -> None: ...

class package:
    class BaseDigest(supertagged.package.TaggedType[typing.List[int]]): ...
    class Digest32$(scorex.crypto.hash.package.BaseDigest):
        MODULE$: typing.ClassVar['package.Digest32.'] = ...
        def __init__(self): ...
        _$at$at__TagIn = typing.TypeVar('_$at$at__TagIn')  # <TagIn>
        _$at$at__Sub = typing.TypeVar('_$at$at__Sub')  # <Sub>
        _$at$at__C = typing.TypeVar('_$at$at__C')  # <C>
        def $at$at(self, c: _.at.at__C, tagger: supertagged.package.Tagger[_.at.at__TagIn, typing.List[int], supertagged.package.TaggedType, _.at.at__Sub, _.at.at__C]) -> typing.Any: ...
        _$bang$at$at__TagIn = typing.TypeVar('_$bang$at$at__TagIn')  # <TagIn>
        _$bang$at$at__Sub = typing.TypeVar('_$bang$at$at__Sub')  # <Sub>
        _$bang$at$at__C = typing.TypeVar('_$bang$at$at__C')  # <C>
        def $bang$at$at(self, c: _.bang.at.at__C, tagger: supertagged.package.Tagger[_.bang.at.at__TagIn, typing.List[int], supertagged.package.TaggedType, _.bang.at.at__Sub, _.bang.at.at__C]) -> typing.Any: ...
        _apply__TagIn = typing.TypeVar('_apply__TagIn')  # <TagIn>
        _apply__Sub = typing.TypeVar('_apply__Sub')  # <Sub>
        _apply__C = typing.TypeVar('_apply__C')  # <C>
        def apply(self, c: _apply__C, tagger: supertagged.package.Tagger[_apply__TagIn, typing.List[int], supertagged.package.TaggedType, _apply__Sub, _apply__C]) -> typing.Any: ...
        _ordering__U = typing.TypeVar('_ordering__U')  # <U>
        def ordering(self, origin: scala.math.Ordering[typing.List[int]]) -> scala.math.Ordering[typing.List[int]]: ...
        def raw(self, c: typing.Any) -> typing.Any: ...
        _untag__TagIn = typing.TypeVar('_untag__TagIn')  # <TagIn>
        _untag__Sub = typing.TypeVar('_untag__Sub')  # <Sub>
        _untag__C = typing.TypeVar('_untag__C')  # <C>
        def untag(self, c: _untag__C, tagger: supertagged.package.Tagger[_untag__TagIn, typing.List[int], supertagged.package.TaggedType, _untag__Sub, _untag__C]) -> typing.Any: ...
    class Digest64$(scorex.crypto.hash.package.BaseDigest):
        MODULE$: typing.ClassVar['package.Digest64.'] = ...
        def __init__(self): ...
        _$at$at__TagIn = typing.TypeVar('_$at$at__TagIn')  # <TagIn>
        _$at$at__Sub = typing.TypeVar('_$at$at__Sub')  # <Sub>
        _$at$at__C = typing.TypeVar('_$at$at__C')  # <C>
        def $at$at(self, c: _.at.at__C, tagger: supertagged.package.Tagger[_.at.at__TagIn, typing.List[int], supertagged.package.TaggedType, _.at.at__Sub, _.at.at__C]) -> typing.Any: ...
        _$bang$at$at__TagIn = typing.TypeVar('_$bang$at$at__TagIn')  # <TagIn>
        _$bang$at$at__Sub = typing.TypeVar('_$bang$at$at__Sub')  # <Sub>
        _$bang$at$at__C = typing.TypeVar('_$bang$at$at__C')  # <C>
        def $bang$at$at(self, c: _.bang.at.at__C, tagger: supertagged.package.Tagger[_.bang.at.at__TagIn, typing.List[int], supertagged.package.TaggedType, _.bang.at.at__Sub, _.bang.at.at__C]) -> typing.Any: ...
        _apply__TagIn = typing.TypeVar('_apply__TagIn')  # <TagIn>
        _apply__Sub = typing.TypeVar('_apply__Sub')  # <Sub>
        _apply__C = typing.TypeVar('_apply__C')  # <C>
        def apply(self, c: _apply__C, tagger: supertagged.package.Tagger[_apply__TagIn, typing.List[int], supertagged.package.TaggedType, _apply__Sub, _apply__C]) -> typing.Any: ...
        _ordering__U = typing.TypeVar('_ordering__U')  # <U>
        def ordering(self, origin: scala.math.Ordering[typing.List[int]]) -> scala.math.Ordering[typing.List[int]]: ...
        def raw(self, c: typing.Any) -> typing.Any: ...
        _untag__TagIn = typing.TypeVar('_untag__TagIn')  # <TagIn>
        _untag__Sub = typing.TypeVar('_untag__Sub')  # <Sub>
        _untag__C = typing.TypeVar('_untag__C')  # <C>
        def untag(self, c: _untag__C, tagger: supertagged.package.Tagger[_untag__TagIn, typing.List[int], supertagged.package.TaggedType, _untag__Sub, _untag__C]) -> typing.Any: ...
    class NonStandardDigest$(scorex.crypto.hash.package.BaseDigest):
        MODULE$: typing.ClassVar['package.NonStandardDigest.'] = ...
        def __init__(self): ...
        _$at$at__TagIn = typing.TypeVar('_$at$at__TagIn')  # <TagIn>
        _$at$at__Sub = typing.TypeVar('_$at$at__Sub')  # <Sub>
        _$at$at__C = typing.TypeVar('_$at$at__C')  # <C>
        def $at$at(self, c: _.at.at__C, tagger: supertagged.package.Tagger[_.at.at__TagIn, typing.List[int], supertagged.package.TaggedType, _.at.at__Sub, _.at.at__C]) -> typing.Any: ...
        _$bang$at$at__TagIn = typing.TypeVar('_$bang$at$at__TagIn')  # <TagIn>
        _$bang$at$at__Sub = typing.TypeVar('_$bang$at$at__Sub')  # <Sub>
        _$bang$at$at__C = typing.TypeVar('_$bang$at$at__C')  # <C>
        def $bang$at$at(self, c: _.bang.at.at__C, tagger: supertagged.package.Tagger[_.bang.at.at__TagIn, typing.List[int], supertagged.package.TaggedType, _.bang.at.at__Sub, _.bang.at.at__C]) -> typing.Any: ...
        _apply__TagIn = typing.TypeVar('_apply__TagIn')  # <TagIn>
        _apply__Sub = typing.TypeVar('_apply__Sub')  # <Sub>
        _apply__C = typing.TypeVar('_apply__C')  # <C>
        def apply(self, c: _apply__C, tagger: supertagged.package.Tagger[_apply__TagIn, typing.List[int], supertagged.package.TaggedType, _apply__Sub, _apply__C]) -> typing.Any: ...
        _ordering__U = typing.TypeVar('_ordering__U')  # <U>
        def ordering(self, origin: scala.math.Ordering[typing.List[int]]) -> scala.math.Ordering[typing.List[int]]: ...
        def raw(self, c: typing.Any) -> typing.Any: ...
        _untag__TagIn = typing.TypeVar('_untag__TagIn')  # <TagIn>
        _untag__Sub = typing.TypeVar('_untag__Sub')  # <Sub>
        _untag__C = typing.TypeVar('_untag__C')  # <C>
        def untag(self, c: _untag__C, tagger: supertagged.package.Tagger[_untag__TagIn, typing.List[int], supertagged.package.TaggedType, _untag__Sub, _untag__C]) -> typing.Any: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("scorex.crypto.hash")``.

    Blake2b: typing.Type[Blake2b]
    Blake2b256: typing.Type[Blake2b256]
    Blake2b256Unsafe: typing.Type[Blake2b256Unsafe]
    Blake2b512: typing.Type[Blake2b512]
    BouncyCastleHash: typing.Type[BouncyCastleHash]
    CommutativeHash: typing.Type[CommutativeHash]
    CryptographicHash: typing.Type[CryptographicHash]
    CryptographicHash32: typing.Type[CryptographicHash32]
    CryptographicHash64: typing.Type[CryptographicHash64]
    Keccak: typing.Type[Keccak]
    Keccak256: typing.Type[Keccak256]
    Keccak512: typing.Type[Keccak512]
    Sha256: typing.Type[Sha256]
    Sha256Unsafe: typing.Type[Sha256Unsafe]
    Skein256: typing.Type[Skein256]
    Skein512: typing.Type[Skein512]
    Stribog256: typing.Type[Stribog256]
    Stribog512: typing.Type[Stribog512]
    ThreadUnsafeHash: typing.Type[ThreadUnsafeHash]
    Whirlpool: typing.Type[Whirlpool]
    package: typing.Type[package]
