from enum import Enum


class ProcessingTimeUnit(Enum):
    BUSINESS_DAYS = "business_days"
    WEEKS = "weeks"


class DestinationRegion(Enum):
    EU = "eu"
    NON_EU = "non_eu"
    NONE = "none"


class Type(Enum):
    ZERO = "0"  # Domestic Shipping
    ONE = "1"  # International Shipping


class Providers(Enum):
    FOUR_PX_WORLDWIDE_EXPRESS = "4px"
    A1POST = "a1post"
    ABF_FREIGHT = "abf"
    ACS_COURIER = "acscourier"
    AEROFLASH = "AEROFLASH"
    AFGHAN_POST = "afghan-post"
    AMAZON_LOGISTICS_UK = "amazon-uk-api"
    AMAZON_LOGISTICS_US = "amazon"
    AN_POST = "an-post"
    ANGUILLA_POSTAL_SERVICE = "anguilla-post"
    APC_POSTAL_LOGISTICS = "apc"
    ARAMEX = "aramex"
    ASENDIA_UK = "asendia-uk"
    ASENDIA_USA = "asendia-usa"
    AUSTRALIA_POST = "australia-post"
    AUSTRIAN_POST = "austrian-post"
    AUSTRIAN_POST_REGISTERED = "austrian-post-registered"
    BAHRAIN_POST = "bahrain-post"
    BANGLADESH_POST_OFFICE = "bangladesh-post"
    BELGIUM_POST_DOMESTIC = "bpost"
    BELGIUM_POST_INTERNATIONAL = "bpost-international"
    BELPOSHTA = "belpost"
    BH_POSTA = "bh-posta"
    BLUE_DART = "bluedart"
    BOTSWANAPOST = "botswanapost"
    BRUNEI_POSTAL_SERVICES = "brunei-post"
    BULGARIAN_POSTS = "bgpost"
    CAMBODIA_POST = "cambodia-post"
    CANADA_POST = "canada-post"
    CANPAR_COURIER = "canpar"
    CESKA_POSTA = "ceska-posta"
    CHINA_EMS = "china-ems"
    CHINA_POST = "china-post"
    CHIT_CHATS = "chitchats"
    CHRONOPOST_FRANCE = "chronopost-france"
    CHRONOPOST_PORTUGAL = "chronopost-portugal"
    CHUNGHWA_POST = "taiwan-post"
    CITY_LINK = "city-link"
    COLISSIMO = "colissimo"
    COLLECT_PLUS = "collectplus"
    CORREIOS_DE_BRASIL = "brazil-correios"
    CORREIOS_DE_MACAU = "correios-macau"
    CORREIOS_DE_PORTUGAL_CTT = "portugal-ctt"
    CORREO_ARGENTINO_DOMESTIC = "correo-argentino"
    CORREO_ARGENTINO_INTERNATIONAL = "correo-argentino-intl"
    CORREO_URUGUAYO = "correo-uruguayo"
    CORREOS_ESPANA = "spain-correos-es"
    CORREOS_CHILE = "correos-chile"
    CORREOS_DE_MEXICO = "correos-de-mexico"
    CORREOS_DE_COSTA_RICA = "correos-de-costa-rica"
    CORREOS_DEL_ECUADOR = "correos-ecuador"
    COURIER_POST = "courierpost"
    COURIERS_PLEASE = "couriers-please"
    CYPRUS_POST = "cyprus-post"
    DELTEC_COURIER = "deltec-courier"
    DEUTSCHE_POST = "deutsch-post"
    DHL_BENELUX = "dhl-benelux"
    DHL_EXPRESS = "dhl"
    DHL_GERMANY = "dhl-germany"
    DHL_GLOBAL_MAIL = "dhl-global-mail"
    DHL_NETHERLANDS = "dhl-nl"
    DHL_PARCEL_NL = "dhlparcel-nl"
    DHL_POLSKA = "dhl-poland"
    DHL_SPAIN_DOMESTIC = "dhl-es"
    DHL_ECOMMERCE = "dhl-global-mail-asia"
    DIRECT_LINK = "directlink"
    DPD = "dpd"
    DPD_GERMANY = "dpd-de"
    DPD_POLSKA = "dpd-poland"
    DPD_UK = "dpd-uk"
    DTDC_INDIA = "dtdc"
    EC_FIRSTCLASS = "ec-firstclass"
    EGYPT_POST = "egypt-post"
    EL_CORREO = "el-correo"
    ELTA_COURIER = "elta-courier"
    EMPOST = "emirates-post"
    EMPRESA_DE_CORREOS_DE_BOLIVIA = "correos-bolivia"
    ESTAFETA = "estafeta"
    ESTES = "estes"
    ESTONIAN_POST = "estonian-post"
    ETHIOPIAN_POSTAL_SERVICE = "ethiopian-post"
    EVERGREEN = "evergreen"
    FASTWAY_AUSTRALIA = "fastway-au"
    FASTWAY_COURIERS = "fastway-ireland"
    FASTWAY_NEW_ZEALAND = "fastway-nz"
    FASTWAYS_COURIERS_SOUTH_AFRICA = "fastway-za"
    FEDEX = "fedex"
    FEDEX_UK_DOMESTIC = "fedex-uk"
    FIRST_FLIGHT_COURIERS = "first-flight"
    FLASH_COURIER = "flash-courier"
    FREIGHTQUOTE_BY_C_H_ROBINSON = "freightquote"
    GATI_KWE = "gati-kwe"
    GHANA_POST = "ghana-post"
    GLOBEGISTICS = "globegistics"
    GLS = "gls"
    GREYHOUND = "greyhound"
    GUERNSEY_POST = "guernsey-post"
    HAY_POST = "hay-post"
    HELLENIC_POST = "hellenic-post"
    HERMES = "hermes-de"
    HERMES_ITALY = "hermes-it"
    HERMES_UK = "hermes"
    HONG_KONG_POST = "hong-kong-post"
    HRVATSKA_POSTA = "hrvatska-posta"
    I_PARCEL = "i-parcel"
    INDIA_POST = "india-post"
    INDIA_POST_INTERNATIONAL = "india-post-int"
    INTERLINK_EXPRESS = "interlink-express"
    INTERNATIONAL_SEUR = "international-seur"
    IPOSTEL = "ipostel"
    IRAN_POST = "iran-post"
    ISLANDSPOSTUR = "islandspostur"
    ISLE_OF_MAN_POST_OFFICE = "isle-of-man-post"
    ISRAEL_POST = "israel-post"
    ISRAEL_POST_DOMESTIC = "israel-post-domestic"
    JAMAICA_POST = "jamaica-post"
    JAPAN_POST = "japan-post"
    JERSEY_POST = "jersey-post"
    JORDAN_POST = "jordan-post"
    KAZPOST = "kazpost"
    KOREA_POST = "kpost"
    KOREA_POST_EMS = "korea-post"
    KUEHNE_NAGEL = "kn"
    LA_POSTE = "la-poste-colissimo"
    LA_POSTE_MONACO = "poste-monaco"
    LA_POSTE_DU_SENEGAL = "poste-senegal"
    LA_POSTE_TUNISIENNE = "poste-tunisienne"
    LANDMARK_GLOBAL = "landmark-global"
    LASERSHIP = "lasership"
    LATVIJAS_PASTS = "latvijas-pasts"
    LIBANPOST = "libanpost"
    LIETUVOS_PASTAS = "lietuvos-pastas"
    MAGYAR_POSTA = "magyar-posta"
    MAKEDONSKA_POSTA = "makedonska-posta"
    MALAYSIA_POS_DAFTAR = "malaysia-post-posdaftar"
    MALDIVES_POST = "maldives-post"
    MALTAPOST = "maltapost"
    MAURITIUS_POST = "mauritius-post"
    MONDIAL_RELAY = "mondialrelay"
    MRW = "mrw-spain"
    MULTIPACK = "mexico-multipack"
    MYHERMES_UK = "myhermes-uk"
    NACEX = "nacex-spain"
    NEW_ZEALAND_POST = "new-zealand-post"
    NEXIVE = "tntpost-it"
    NIEUWE_POST_NEDERLANDSE_ANTILLEN_PNA = "nieuwe-post-nederlandse-antillen-pna"
    NIGERIAN_POSTAL_SERVICE = "nipost"
    NOVA_POSHTA = "nova-poshta"
    OCA = "oca-ar"
    OPEK = "opek"
    OMAN_POST = "oman-post"
    ONTRAC = "ontrac"
    OPT = "opt"
    OPT_DE_NOUVELLE_CALEDONIE = "opt-nouvelle-caledonie"
    OTHER = "other"
    PAKISTAN_POST = "pakistan-post"
    PARCELFORCE_WORLDWIDE = "parcel-force"
    POCZTA_POLSKA = "poczta-polska"
    POS_INDONESIA = "pos-indonesia"
    POS_INDONESIA_INTERNATIONAL = "pos-indonesia-int"
    POS_MALAYSIA = "malaysia-post"
    POST_ARUBA = "post-aruba"
    POST_FIJI = "post-fiji"
    POST_LUXEMBOURG = "post-luxembourg"
    POSTNL_DOMESTIC = "postnl"
    POSTNL_INTERNATIONAL = "postnl-international"
    POSTNL_INTERNATIONAL_3S = "postnl-3s"
    POSTNORD = "danmark-post"
    POSTNORD_LOGISTICS = "postnord"
    POSTA = "posta"
    POSTA_KENYA = "posta-kenya"
    POSTA_MOLDOVEI = "posta-moldovei"
    POSTA_ROMANA = "posta-romana"
    POSTA_SHQIPTARE = "posta-shqiptare"
    POSTA_SLOVENIJE = "posta-slovenije"
    POSTA_SRBIJE = "posta-srbije"
    POSTA_UGANDA = "posta-uganda"
    POSTE_ITALIANE = "poste-italiane"
    POSTE_ITALIANE_PACCOCELERE = "poste-italiane-paccocelere"
    POSTE_MAROC = "poste-maroc"
    POSTEN_AB = "sweden-posten"
    POSTEN_NORGE = "posten-norge"
    POSTI = "posti"
    POSTMATES = "postmates"
    PTT_POSTA = "ptt-posta"
    PUROLATOR = "purolator"
    QATAR_POST = "qatar-post"
    RED_EXPRESS = "red-express"
    REDPACK = "mexico-redpack"
    ROYAL_MAIL = "royal-mail"
    RL_CARRIERS = "rl-carriers"
    RPX_INDONESIA = "rpx"
    RUSSIAN_POST = "russian-post"
    S_F_INTERNATIONAL = "sfb2c"
    SAFEXPRESS = "safexpress"
    SAGAWA = "sagawa"
    SAUDI_POST = "saudi-post"
    SDA_EXPRESS_COURIER = "italy-sda"
    SELEKTVRACHT = "selektvracht"
    SENDA_EXPRESS = "mexico-senda-express"
    SENDLE = "sendle"
    SERPOST = "serpost"
    SEUR_ESPANA_DOMESTICO = "spanish-seur"
    SEUR_PORTUGAL_DOMESTICO = "portugal-seur"
    SF_EXPRESS = "sf-express"
    SINGAPORE_POST = "singapore-post"
    SINGAPORE_SPEEDPOST = "singapore-speedpost"
    SIODEMKA = "siodemka"
    SKYNET_MALAYSIA = "skynet-malaysia"
    SKYNET_WORDWIDE_EXPRESS = "skynetworldwide"
    SKYNET_WORLDWIDE_EXPRESS = "skynetworldwide"
    SLOVENSKA_POSTA = "slovenska-posta"
    SOUTH_AFRICA_POST_OFFICE = "sapo"
    STALLION_EXPRESS = "stallionexpress"
    STARTRACK = "star-track"
    SWISS_POST = "swiss-post"
    TA_Q_BIN_HONG_KONG = "taqbin-hk"
    TA_Q_BIN_JAPAN = "taqbin-jp"
    TA_Q_BIN_MALAYSIA = "taqbin-my"
    TA_Q_BIN_SINGAPORE = "taqbin-sg"
    TGX = "tgx"
    THAILAND_POST = "thailand-post"
    TNT = "tnt"
    TNT_AUSTRALIA = "tnt-au"
    TNT_FRANCE = "tnt-fr"
    TNT_ITALIA = "tnt-it"
    TNT_UK = "tnt-uk"
    TOLL_GLOBAL_EXPRESS = "toll-global-express"
    TOLL_PRIORITY = "toll-priority"
    TTPOST = "ttpost"
    UK_MAIL = "uk-mail"
    UKRPOSHTA = "ukrposhta"
    UPS = "ups"
    UPS_FREIGHT = "ups-freight"
    USHIP = "uship"
    USPS = "usps"
    VANUATU_POST = "vanuatu-post"
    VIETNAM_POST = "vnpost"
    VIETNAM_POST_EMS = "vnpost-ems"
    WHISTL = "whistl"
    XEND = "xend"
    YAKIT = "yakit"
    YANWEN = "yanwen"
    YEMEN_POST = "yemen-post"
    YODEL = "yodel"
    YODEL_INTERNATIONAL = "yodel-international"
    YRC_FREIGHT = "yrc"
    ZAMPOST = "zampost"
    ZIMPOST = "ZIMPOST"
