from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = "1.0.13"
DESCRIPTION = "Etsy API Client Library for Python"

# Setting up
setup(
    name="etsy-python",
    version=VERSION,
    author="Amit Ray",
    author_email="mail@amitray.dev",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=["requests", "requests-oauthlib"],
    keywords=["python", "etsy", "api"],
    classifiers=[
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ],
    project_urls={
        "Documentation": "https://github.com/amitray007/etsy-python-sdk/blob/master/README.md",
        "Source code": "https://github.com/amitray007/etsy-python-sdk",
        "Issues": "https://github.com/amitray007/etsy-python-sdk/issues",
    },
)
