# coding: utf-8

"""
    ExKoin API Documentation

    API documentation for ExKoin Crypto exchange

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Union
from exapi_client_python.models.private_pool_tasks_get200_response_inner_spent_inner import PrivatePoolTasksGet200ResponseInnerSpentInner
from typing import Optional, Set
from typing_extensions import Self

class PrivatePoolTasksGet200ResponseInner(BaseModel):
    """
    PrivatePoolTasksGet200ResponseInner
    """ # noqa: E501
    id: StrictStr
    pool_id: StrictStr
    type: StrictStr
    status: StrictStr
    created_at: Union[StrictFloat, StrictInt]
    updated_at: Union[StrictFloat, StrictInt]
    spent: List[PrivatePoolTasksGet200ResponseInnerSpentInner]
    got: List[PrivatePoolTasksGet200ResponseInnerSpentInner]
    __properties: ClassVar[List[str]] = ["id", "pool_id", "type", "status", "created_at", "updated_at", "spent", "got"]

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['join', 'leave']):
            raise ValueError("must be one of enum values ('join', 'leave')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PrivatePoolTasksGet200ResponseInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in spent (list)
        _items = []
        if self.spent:
            for _item_spent in self.spent:
                if _item_spent:
                    _items.append(_item_spent.to_dict())
            _dict['spent'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in got (list)
        _items = []
        if self.got:
            for _item_got in self.got:
                if _item_got:
                    _items.append(_item_got.to_dict())
            _dict['got'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PrivatePoolTasksGet200ResponseInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "pool_id": obj.get("pool_id"),
            "type": obj.get("type"),
            "status": obj.get("status"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "spent": [PrivatePoolTasksGet200ResponseInnerSpentInner.from_dict(_item) for _item in obj["spent"]] if obj.get("spent") is not None else None,
            "got": [PrivatePoolTasksGet200ResponseInnerSpentInner.from_dict(_item) for _item in obj["got"]] if obj.get("got") is not None else None
        })
        return _obj


